import { Component, ElementRef, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../tariff.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { SubscriptionService } from 'src/app/subscription/subscription.service';

declare var $:any;

@Component({
  selector: 'app-list',
  templateUrl: './list.component.html',
  styleUrls: ['./list.component.css']
})

export class ListComponent implements OnInit {
  @ViewChild('tariffModal') tariffModal : ElementRef;
  @ViewChild('viewdata') viewdata : ElementRef;
  searchText = { count: 0 };
	filtre: string;
  hide:boolean=true;
  tariffs: any;
  page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
  filterTerm: string;
	row: any;
	idtariff: any;
  tariffForm: FormGroup;
  responseMessage = "";
  errMessage = "";
  editTariffRate: any;
  tariffsName: any;
  tariffLength: any;
  submitted: boolean;
  userlist: any;
  matchedData: any[] = [];
  matchedLength: number;
  tariffid:any

  dropdownSettingsd: IDropdownSettings = {};
  closeDropdownSelection = true;
  subscriptiondata:any=[];
  selectedItems: any[] = [];
  subscriptionwithteriff:any=[]; 
  matchedDatasubscription:any=[];

  idterrifupdate:any;

  @ViewChild('subscription') subscription: ElementRef;

 
  constructor(private data: UsermanagementService,
              private tariffService: TariffService,
              private fb: FormBuilder, 
              private subscriptionService:SubscriptionService) { }

  ngOnInit(): void {

    this.tariffForm=this.fb.group({
      id: [],
      name:['', [Validators.required,Validators.minLength(3),Validators.maxLength(100)]],
			description: ['', [Validators.required, Validators.minLength(10),Validators.maxLength(255)]],
      subscription:[''],
      tarifflink: ['',[Validators.maxLength(512),Validators.pattern( /^(https?:\/\/)?([\p{L}\p{N}\u0900-\u097F-]+\.)+[\p{L}\u0900-\u097F]{2,}(\/[\p{L}\p{N}\u0900-\u097F\-._~:/?#\[\]@!$&'()*+,;=%]*)?(?:\?[^#\s]*)?(?:#[^\s]*)?$/u
)]]
      //day_num: new FormControl("", [Validators.required])    
		});

    this.tariffService.getTariffs().subscribe(res => {
      this.tariffs = res.data;
      $('#basic-datatabless2').DataTable().clear();
				$('#basic-datatabless2').DataTable().destroy();
      $.getScript('./assets/table.js');
      this.tariffLength = this.tariffs.length;
    });

    this.subscriptionService.get_Subscriptiondata().subscribe((res) => {
      this.subscriptiondata = res.data;
    });

    this.data.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
    });

    this.dropdownSettingsd = {
      singleSelection: false,
      idField: 'subscription_id', 
      textField: 'name', 
      selectAllText: 'Select All',
      unSelectAllText: 'UnSelect All',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: false
    };
  }

  viewCustomer(idtariff){
    this.matchedLength = 0;
    this.tariffid=idtariff
    this.matchedData = [];
    $('#basic-datatables1').DataTable().draw();
    $('#basic-datatables1').DataTable().destroy();
    $.getScript('./assets/table.js');
    this.userlist.forEach(user => {
      if(user.idtariff == idtariff){
        this.matchedData.push(user);
      }
      this.matchedLength = this.matchedData.length;
    })
  }

  checkload(){
    this.viewCustomer(this.tariffid)
  }

  editModal(data){
    this.idterrifupdate=data.idtariff;

    this.subscriptionService.getSubscription(data.idtariff).subscribe((res) => {
      if (res.status === 200) {
        this.subscriptionwithteriff = res.data;
        this.selectedItems = this.subscriptionwithteriff.map(item => {
          return {
            subscription_id: item.subscription_id,
            name: item.name
          };
        });
      } else {
        console.log("Error fetching subscription data");
      }
    });
    
    this.tariffForm.setValue({
      id: data.idtariff,
      name: data.name,
      description: data.description,
      subscription: this.selectedItems,
      tarifflink:data.tariff_link
    });
  }


  editTariff(){
    if (this.tariffForm.invalid) {
      this.submitted = true;
      return;
    }
    else{ 
      let subscriptions = this.tariffForm.value.subscription;
      if (!subscriptions) {
        subscriptions = [];
        this.tariffForm.patchValue({ subscription: [] });
      }
      if(subscriptions.length<=7){
        const idtariff = this.idterrifupdate;
        this.tariffForm.patchValue({
          id: idtariff
        });
        this.tariffService.updateTariff(this.tariffForm.value).subscribe(res => {
          if(res.status == 201){
            $("#exampleModal").hide();
            $(".modal-backdrop").remove();
            this.responseMessage = res.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
            window.location.reload();
          }
          else{
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
          }
        }, err => {
          this.responseMessage = err.message;
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000);
        });
      }else{
        this.errMessage = "Maximum 7 subscription can be mapped on a tariff";
        setTimeout(() => {
          this.errMessage = "";
        }, 4000);
      }
    }
  }

  viewsubscription(idtariff) {
    this.matchedLength = 0;
    this.matchedDatasubscription = [];
    this.subscriptionService.getSubscription(idtariff).subscribe((res) => {
        if (res.status == 200) {
          $('#basic-datatables').DataTable().clear();
          $('#basic-datatables').DataTable().destroy();
          $.getScript('./assets/table.js');
            this.subscriptionwithteriff = res.data;
            this.matchedDatasubscription = this.subscriptionwithteriff.filter(user => user.idtariff == idtariff);
            this.matchedLength = this.matchedDatasubscription.length;
        }
    });
  }

  deleteTariff(idtariff){
    if(confirm("Are you sure you want delete data!")){
      this.tariffService.deleteTariff(idtariff).subscribe(res => {
          if(res.status == 201){
            this.responseMessage = res.message;
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
            window.location.reload();
          }
          else{
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
          }
      }, err => {
        this.responseMessage = err.message;
        setTimeout( () => {
          this.responseMessage = "";
        }, 5000)
      })
    }else{
      "Cancel!";
    }
  }
  onClose() {
    this.submitted =false;
    this.tariffForm.reset();
    this.tariffForm.value. subscription= [];
  }

ngOnDestroy(){
    this.tariffModal.nativeElement.click();
    this.viewdata.nativeElement.click();
    this.subscription.nativeElement.click();
  }
}
