import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { AppService } from '../shared/service/AppService.class';

@Injectable({
  providedIn: 'root'
})

export class TariffService extends AppService<any>  {

  constructor(public http: HttpClient) {
    super(http);
    this.appmod = "usermanagement";
  }

  @LoaderEnabled()
  updatePreferenceService(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "updateservicepreference";
    let result = super.updateService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  savePreferenceService(data: any): Observable<any> {
    this.appmod = "preferenceservice";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getSingleService(idservice): Observable<any> {
    const endpoint = environment.SERVER + 'singleservice';

    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: idservice });
  }

  @LoaderEnabled()
  getSingleUsers(): Observable<any> {
    this.appmod = "singleuser";
    let result = super.getService();
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  searchByOperator(text): Observable<any> {
    let searchText = { text: text };
    const endpoint = environment.SERVER + 'operators';
    let httpHeaders = new HttpHeaders({
      "content-type": "application/json"
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: searchText });
  }

  @LoaderEnabled()
  getPreferenceService(): Observable<any> {
    this.appmod = "service";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  setDefault(data): Observable<any>{
      let apiUrl = environment.SERVER + "default_service";
      let httpHeaders = new HttpHeaders({
        // "Content-Type": "application/json",
      });
      return this.http.put(apiUrl, {data: data}, {headers: httpHeaders});
  }


  // @LoaderEnabled()
  // deletePreferenceService(data): Observable<any> {
  //   this.appmod = "deleteservice";
  //   let result = super.deleteService(data);
  //   this.appmod = "";
  //   return result;
  // }
  @LoaderEnabled()
  deletePreferenceService(id: any): Observable<any> {
    let apiUrl = environment.SERVER + 'deleteservice';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { ID: id } });
  }

  @LoaderEnabled()
  saveSurcharge(data: any): Observable<any> {
    this.appmod = "savesurcharge";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateSurcharge(data: any): Observable<any> {
    this.appmod = "edit_Surcharge";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getSurcharge(): Observable<any> {
    this.appmod = "surcharge";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  editSurcharge(data: any): Observable<any> {
    this.appmod = 'editSurcharge';
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  deleteSurcharge(key): Observable<any> {
    this.appmod = 'deletesurcharge';
    let result = super.deleteService(key);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  saveTariff(data: any): Observable<any> {
    this.appmod = "saveTariff";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  copyTariff(data: any): Observable<any> {
    this.appmod = "copyTariff";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getTariffs(): Observable<any> {
    this.appmod = "getTariffs";
    let tmp = this.getService();
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  getTypesTariff(type: string): Observable<any> {
    this.appmod = "type_tariffs";
    let tmp = this.getService(type);
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  getTariff(idtariff): Observable<any> {
    this.appmod = "getTariff";
    let tmp = this.getService(idtariff);
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  updateTariff(data: any): Observable<any> {
    this.appmod = 'updateTariff';
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  // @LoaderEnabled()
  // deleteTariff(key): Observable<any> {
  //   this.appmod = 'deleteTariff';
  //   let result = super.deleteService(key);
  //   this.appmod = "";
  //   return result;
  // }
  @LoaderEnabled()
  deleteTariff(id: any): Observable<any> {
    let apiUrl = environment.SERVER + 'deleteTariff';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    this.appmod = "";
     return this.http.delete(apiUrl, { headers: httpHeaders, params: { ID: id } });
  }

  @LoaderEnabled()
  addA2PDLCRates(data: any): Observable<any> {
    this.appmod = "add10dlca2p";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  addTollFreeRate(data: any): Observable<any> {
    this.appmod = "tollfreerates";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  // @LoaderEnabled()
  // SMS_Rates(data: any): Observable<any>{
  //   this.appmod = "usa_sms_rates";
  //   let result = super.saveService(data);
  //   this.appmod = "";
  //   return result;
  // }

  @LoaderEnabled()
  ShortCodeRate(data: any): Observable<any> {
    this.appmod = "addshortcode";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onVoiceRates(data: any): Observable<any> {
    this.appmod = "addvoicerate";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  getRate(data: any): Observable<any> {
    this.appmod = "tier/billing_rate";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  getleadinfo(): Observable<any> {
    this.appmod = "lerg_info";
    let result = super.getService();
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  getoperatormaping(): Observable<any> {
    this.appmod = "operator-mapping";
    let result = super.getService();
    this.appmod = "";
    return result;
  }




  @LoaderEnabled()
  GetSmsRate(data?: any): Observable<any> {
    const endpoint = environment.SERVER + 'usa_sms_rates';

    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  GetCampaignRate(data?: any): Observable<any> {
    const endpoint = environment.SERVER + 'getcampaign_rate';

    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  GetCoverageRate(data?: any): Observable<any> {
    const endpoint = environment.SERVER + 'getCoverage_rate';

    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  Get10DLCRate(data?: any): Observable<any> {
    this.appmod = "get10dlca2p";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetTollFreeRates(data: any): Observable<any> {
    this.appmod = "gettollfreerate";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetShortCode(data: any): Observable<any> {
    this.appmod = "getshortcode";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  GetVoiceRates(data: any): Observable<any> {
    this.appmod = "getvoicerate";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateSMSRate(data: any): Observable<any> {
    this.appmod = "updateSMSRate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  updatelookupRate(data: any): Observable<any> {
    this.appmod = "updatelookupRate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  updateCampaignReviewRate(data: any): Observable<any> {
    this.appmod = "updateCampaignReviewRate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  updateShortCodeRate(data: any): Observable<any> {
    this.appmod = "updateShortCodeRate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateTollFreeRates(data: any): Observable<any> {
    this.appmod = "updateTollFreeRate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  update10DLCRates(data: any): Observable<any> {
    this.appmod = "update10DLCRate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateVoiceRates(data: any): Observable<any> {
    this.appmod = "updateVoiceRate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onRegisteredRates(data: any): Observable<any> {
    this.appmod = "addvoicerates";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onSaveSmsRates(data: any): Observable<any> {
    this.appmod = "sms_rates";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateVoiceRate(data: any): Observable<any> {
    this.appmod = "updateunregisteredrates";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  //@LoaderEnabled()
  updateTariffDay(data: any): Observable<any> {
    this.appmod = 'updatetariffday';
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  updateProRate(data: any): Observable<any> {
    this.appmod = 'updateproratesetting';
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateProration(data: any): Observable<any> {
    this.appmod = 'updateProration';
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

    /*Edit case Activate Msg Pricing*/
    @LoaderEnabled()
    updateactivatemessage(data: any): Observable<any> {
      this.appmod = "updateactivatemessage";
      console.log(data)
      let result = super.updateService(data);
      this.appmod = "";
      return result;
    }
  
    /*GET Activation MSg Pricing*/
      @LoaderEnabled()
      getactivate_msg(data: any): Observable<any> {
        const endpoint = environment.SERVER + 'getactivate_msg';
    
        let httpHeaders = new HttpHeaders({
        });
        return this.http.get(endpoint, { headers: httpHeaders, params: data });
      }

  @LoaderEnabled()
  getUnregisteredRate(data: any): Observable<any> {
    const endpoint = environment.SERVER + 'unregisteredrates';

    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  uploadLergFile(file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("profile_pic", file);

    const apiURL = environment.SERVER + 'upload_lerg';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  uploadZoneFile(file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("profile_pic", file);

    const apiURL = environment.SERVER + 'upload_zone';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  categoryLergInfo(): Observable<any> {

    const apiURL = environment.SERVER + 'lerg_category';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.get(apiURL, { headers: httpHeaders });
  }

  @LoaderEnabled()
  operatorsLergInfo(category?: any): Observable<any> {

    const apiURL = environment.SERVER + 'lerg_operators';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.get(apiURL, { headers: httpHeaders, params: category });
  }

  @LoaderEnabled()
  setOperatorMapping(data): Observable<any> {

    const apiURL = environment.SERVER + 'operator-mapping';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.post(apiURL, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  lookupRates(data: any): Observable<any> {
    const endpoint = environment.SERVER + 'lookupRates';

    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: data });
  }
  
  @LoaderEnabled()
  campaignReviewRates(data: any): Observable<any> {
    const endpoint = environment.SERVER + 'campaignReviewRates';

    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params: data });
  }
  @LoaderEnabled()
  deleteMapping(operator): Observable<any> {
    const apiUrl = environment.SERVER + "delete-mapping";
    let httpHeaders = new HttpHeaders({
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { operator } });
  }

  @LoaderEnabled()
  getSurcharges(idsurcharge: any): Observable<any> {
    const apiUrl = environment.SERVER + "getsurcharge";
    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(apiUrl, { headers: httpHeaders, params: { idsurcharge } });
  }

  @LoaderEnabled()
  getZones(): Observable<any> {
    const apiUrl = environment.SERVER + "zones";
    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }

  @LoaderEnabled()
  get_tarifflist(): Observable<any> {
    this.appmod = "tarifflist";
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  get_tariff(type: string): Observable<any> {
    this.appmod = "getteriff";
    let tmp = this.getService(type);
    this.appmod = "";
    return tmp;
  }

  @LoaderEnabled()
  gettarifrate(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'getplanrate';
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }
  
  public get_voiceapi(): Observable<any> {
    return this.http.get('./assets/voiceapi.json');
  }

  public get_elasticSip(): Observable<any> {
    return this.http.get('./assets/elasticsip.json');
  }

  public get_MessagePricing(): Observable<any> {
    return this.http.get('./assets/messagepricing.json');
  }


  public get_lerginfo(): Observable<any> {
    return this.http.get('./assets/lerginfo.json');
  }


  public get_zone(): Observable<any> {
    return this.http.get('./assets/zone.json');
  }

  public get_lookuprates(): Observable<any> {
    return this.http.get('./assets/lookuppricing.json');
  }

  public get_activateMsg(): Observable<any> {
    return this.http.get('./assets/activation_msg.json');
  }
  
}