import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { TollfreesmsService } from '../tollfreesms.service';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown'; 
declare var $: any;

@Component({
  selector: 'app-addverifysender',
  templateUrl: './addverifysender.component.html',
  styleUrls: ['./addverifysender.component.css']
})
export class AddverifysenderComponent implements OnInit {
  @ViewChild('createmodal') createmodal: ElementRef;
  @ViewChild('selectElement') selectElement: ElementRef;
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('modalVideoForFile') modalVideoForFile: ElementRef;

  public formdata: any;
  selectedItems = [];
  volumeMonth: any;
  public verifySenderForm: FormGroup;
  submitted: boolean = false;
  responseMessage: any = "";
  errMessage: any = "";
  user: any;
  req_id: string;
  file: File | any;
  id: string;
  userType: any;
  iduser: any;
  idaccount: any;
  isFilePath: boolean = false;
  oldFile: any;
  selectedRequestId: any;
  request_ID: any;
  selected1: any = [];
  fortune: any;
  traffic_expt: any;
  text_previous: any;
  text_msg: any;
  selectedFile: File[] = [];
  files: any;
  previousfiles: any[];
  key: any;
  urls: any[] = [];
  urls1: any[];
  url: any;
  dropdownSettings: IDropdownSettings = {};
  dropdownSettings1: IDropdownSettings = {};
  dropdownSettings2: IDropdownSettings = {};
  closeDropdownSelection = true;
  closeDropdownSelection2 = true;
  selectedItem: any = [];
  country:any;
  selectedItem1: any = [];
  selectedUSecaseValues: any = [];
  usecaseData: any = [];
  optData: any = [];
  zipLength: number;
  selecteddata: any;

  constructor(public data: TollfreesmsService, private fb: FormBuilder, public router: Router, private route: ActivatedRoute) { }
  ngOnInit(): void {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.iduser = session.iduser;
    this.idaccount = session.idaccount;

    this.verifySenderForm = this.fb.group({
      messagingprovider: ['Intelliquent'],
      businessname: ['', [Validators.required,Validators.maxLength(550), this.noLeadingSpaceValidator()]],
      address: ['', [Validators.required, Validators.maxLength(550), this.noLeadingSpaceValidator()]],
      address1: ['',[this.noLeadingSpaceValidator()]],
      city: ['', [Validators.required,Validators.maxLength(150), this.noLeadingSpaceValidator()]],
      state: ['', [Validators.required,Validators.maxLength(50), this.noLeadingSpaceValidator()]],
      zip: ['', [Validators.required, this.noLeadingSpaceValidator()]],
      // firstname: ['', [Validators.required, Validators.pattern(/^([a-zA-Z!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:\'\"\/])*[^\s]\1*$/)]],
      // lastname: ['', [Validators.required, Validators.pattern(/^([a-zA-Z!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:\'\"\/])*[^\s]\1*$/)]],
      firstname: ['', [Validators.required,Validators.maxLength(255), this.noLeadingSpaceValidator(),
        this.noDigitsValidator()]],
      lastname: ['', [Validators.required,Validators.maxLength(255),this.noLeadingSpaceValidator(),
      this.noDigitsValidator()]],
      email: ['', [Validators.required, Validators.maxLength(255), this.noLeadingSpaceValidator(), Validators.pattern("^(?!.*\\.\\.)(?!\\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,10}(?<!\\.)$")]],
      phonenumber: ['',[Validators.required,Validators.minLength(10),Validators.maxLength(10)]],
      // number: ['', Validators.required],
      websiteurl: ['', [Validators.required, Validators.pattern(/^\s*(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+\s*$/), this.noLeadingSpaceValidator()]],
      usecase: ['', [Validators.required, this.noLeadingSpaceValidator()]],
      usecasecategory: ['', [Validators.required]],
      // smsprogram: ['', Validators.required],
      contentcampaign: ['', [Validators.required,Validators.maxLength(1024), this.noLeadingSpaceValidator()]],
      published: ['', [Validators.required,Validators.maxLength(150), this.noLeadingSpaceValidator()]],
      url: ['', [Validators.pattern(/^\s*(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+\s*$/), this.noLeadingSpaceValidator()]],
      numbers: [''],
      messagevolume: ['0', [Validators.required, this.noDefaultValueValidator]],
      workdescription: ['',[this.noLeadingSpaceValidator()]],
      /* addInfo: [''],
      ticketnumber: [''],
      isv: [''], */
      supportdocs: ['', [Validators.maxLength(1024), this.noLeadingSpaceValidator()]],
      text_msg_type: ['',[Validators.required,Validators.maxLength(550)]],
      traffic_previous_msg_service: ['',[Validators.required,Validators.maxLength(550)]],
      traffic_expected: ['', [Validators.required, Validators.maxLength(550)]],
      oldFile: [''],
      dbaname: ['', [Validators.maxLength(550), this.noLeadingSpaceValidator()]],
      company: ['', [Validators.required,Validators.maxLength(550)]],
      
     /* notificationEmail:['',[Validators.required,Validators.maxLength(250), Validators.pattern("^(?!.*\\.\\.)(?!\\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,10}(?<!\\.)$")]], */
      OptInType:['',[Validators.required]],
      externalReferenceId:['',[Validators.maxLength(200), this.noLeadingSpaceValidator()]],
      country:['',Validators.required]
 
    },{ updateOn: 'change' });

    // toget request id for pending review
    this.data.get_RequestID().subscribe((result) => {
      if (result.status == 200) {
        this.request_ID = result.data;
      }
    })

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'value',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
// usecaase
    this.dropdownSettings1 = {
      singleSelection: false,
      idField: 'value',
      textField: 'name',
      selectAllText: 'Select All',
      unSelectAllText: 'UnSelect All',
      itemsShowLimit: 3,
      searchPlaceholderText: 'Search Use case',
      allowSearchFilter: true,
      // maxHeight: 130,
    };
// optintype    
    
    this.dropdownSettings2 = {
      singleSelection: true,
      idField: 'value',
      textField: 'name',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection2
    };
 
     this.route.paramMap.subscribe((params: ParamMap) => {
      if (params.get('unique_request_id')) {
       this.getallData()
      }
    })
    // this.getallData()
    this. GetVerifiedUsecaseProfile();
    this.optIntype()
    this.usecaseCategory()

    /*getting form json*/
    this.data.get_tollfree_sender().subscribe((result) => {
      this.formdata = result;
      this.volumeMonth = this.formdata[9].subheading1.options;
      this.fortune = this.formdata[7].subheading2.options;
      this.text_msg = this.formdata[4].subheading1.options;
      this.text_previous = this.formdata[5].subheading1.options;
      this.traffic_expt = this.formdata[6].subheading1.options;
      this.country = result[1].subheading6.country;
      // console.log("this.formdata", this.formdata);
      
    })
  }
  GetVerifiedUsecaseProfile(){
    this.data.get_RequestID().subscribe((result) => {
      if (result.status == 200) {
        this.request_ID = result.data;
      }
    })
 
  }
 
 
   noDefaultValueValidator(control) {
    return control.value === '0' || control.value === '' ? { default: true } : null;
  }

  optIntype(){ 
     this.data.optintype().subscribe((res) => {
      if (res.status == 201) {
        this.optData = res.data;
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
    
    
  }

  usecaseCategory(){
      this.data.usecasecategory().subscribe((res) => {
      if (res.status == 201) {
        this.usecaseData = res.data;
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });

  }
 
  onSubmit() {
    this.submitted = true;
    if (this.verifySenderForm.invalid || (!this.selectedFile || this.selectedFile.length === 0 || null) && (!this.files || this.files.length === 0 || null)) {
      return false;
    }
    if ((this.selectedFile && this.selectedFile.length > 10) || (this.files && this.files.length > 10)) {
      return false;
    }
    if ((this.urls && this.urls.length === 0)) {
      return false;
    }
    else {
      this.urls1 = [];
      this.urls.forEach((item) => {
        if (typeof item === 'object' && item.hasOwnProperty('url')) {
          this.urls1.push(item.url);
        } else {
          this.urls1.push(item);
        }
      });
      this.verifySenderForm.get('url').setValue(this.urls1[0]);
      this.verifySenderForm.value.country = this.selectedItem[0].value
      this.verifySenderForm.value.OptInType = this.selectedItem1[0].value
      this.verifySenderForm.value.usecasecategory = this.selectedUSecaseValues
 

      let payLoad: any = JSON.stringify({
        id: this.req_id,
        data: this.verifySenderForm.value,
        previosFile: this.previousfiles,
        url: this.urls1
      });
      this.data.verifySender(payLoad, this.selectedFile).subscribe(
        (res) => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.resetform()
            const compModal = document.getElementById('createmodal');
            $(compModal).modal({ backdrop: 'static', keyboard: false });
            $(compModal).modal('show');
            setTimeout(() => {
              this.responseMessage = '';
              // this.router.navigateByUrl('/Verified-Sender');
            }, 5000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        },
        (err) => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      );
    }
  }


  resetform() {
    this.submitted = false;
    this.verifySenderForm.reset();
    this.files = []
    this.urls = []
    this.selectedFile = []
    //this.previousfiles = []
    this.files = this.files
    this.selectedFile = this.selectedFile
    this.verifySenderForm.get('company').setValue('')
    this.verifySenderForm.get('traffic_expected').setValue('')
    this.verifySenderForm.get('traffic_previous_msg_service').setValue('')
    this.verifySenderForm.get('text_msg_type').setValue('')
    this.verifySenderForm.get('messagevolume').setValue('0')
    this.verifySenderForm.get('messagingprovider').setValue('Intelliquent')
    this.selectElement.nativeElement.value = '';
    this.selectedItem = '';
    this.selectedItem1 = '';
    this.selectedUSecaseValues = [];
    this.selectedItem = [];
  }

  getallData() {
    this.route.paramMap.subscribe((params: ParamMap) => {
      this.id = params.get('unique_request_id');
      this.req_id = this.id
      let payLoad: any = JSON.stringify({
        id: this.id,
        /* idaccount: this.idaccount,
        iduser: this.iduser */
      });
      this.data.view_VerifySender(payLoad).subscribe(result => {
        if (result.status == 200) {
          this.user = result.data[0];
          this.url = result.data1
          this.key = this.user.file_upload_key;
          const filePaths = this.user.file_paths.split(',');
          this.files = [];
          this.previousfiles = []
          filePaths.forEach((filePath, index) => {
            const fileName = filePath.substring(filePath.lastIndexOf('/') + 1);
            const fileObject = {
              file: filePath.trim(),
              name: fileName,
            };
            this.files.push(fileObject);
            this.previousfiles.push(fileObject);
          });
          if (this.url.length === 0) {
            this.urls.push(this.user.call_to_action_url)
          } else {
            this.url.forEach((item) => {
              this.urls.push(item.url.trim())
            });
          }
       
          const countryList = Array.isArray(this.country) ? this.country : [];
          const usecaseList = Array.isArray(this.usecaseData) ? this.usecaseData : [];
          const optList = Array.isArray(this.optData) ? this.optData : [];
 
 
          this.selectedItem = countryList
            .filter(item => item?.value === this.user.business_country)
            .map(item => ({ name: item?.name || '', value: item?.value || '' }));
 
          const useCaseCategory = this.user.use_case_category || '';
          this.selectedUSecaseValues = typeof useCaseCategory === 'string'
            ? useCaseCategory.split(',').map(s => s.trim()).filter(Boolean)
            : Array.isArray(useCaseCategory)
            ? useCaseCategory
            : [];
 
          this.selectedItems = usecaseList.filter(item =>
            this.selectedUSecaseValues.includes(item?.value)
          );
 
          this.selectedItem1 = optList.filter(item =>
            item?.value === this.user.opt_in_type
          );
 
          this.verifySenderForm.patchValue({
            messagingprovider: 'Intelliquent',
            dbaname: this.user.dba_name,
            businessname: this.user.business_name,
            address: this.user.address1,
            address1: this.user.address2,
            city: this.user.city,
            state: this.user.state,
            zip: this.user.zip,
            firstname: this.user.first_name,
            lastname: this.user.last_name,
            email: this.user.business_email,
            phonenumber: this.user.business_phone,
            websiteurl: this.user.corporate_website_url,
            usecase: this.user.summarize_usecase,
            // usecasecategory: this.user.use_case_category,
            contentcampaign: this.user.sample_message,
            published: this.user.number_published,
            company: this.user.fortune_company,
            url: this.user.call_to_action_url,
            numbers: this.user.call_to_action_numbers,
            messagevolume: this.user.message_volume_per_month,
            workdescription: this.user.opt_in_workflow_description,
            //addInfo: this.user.additional_opt_on_information,
            //ticketnumber: this.user.internal_ticket_number,
            //isv: this.user.isv_reseller,
            supportdocs: this.user.additional_supporting_documentation,
            text_msg_type: this.user.text_message_type,
            traffic_previous_msg_service: this.user.traffic_previously_msg_service,
            traffic_expected: this.user.traffic_expected,
            //smsprogram: this.user.sms_program,
 
           /*  notificationEmail: this.user.notification_email, */
            // OptInType: this.user.opt_in_type,
            externalReferenceId: this.user.external_reference,
 
          });
        } else {
          this.errMessage = result.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    })
  }

  onFilePicked(event: Event) {
    const file: File = (event.target as HTMLInputElement).files[0];
    this.file = file;
    const reader = new FileReader();
    reader.readAsDataURL(file)
    this.isFilePath = false;

  }
  clickForOldFile() {
    this.isFilePath = true;
    this.file = '';
    /* this.verifySenderForm.patchValue({
      smsprogram:''
    }) */
    this.verifySenderForm.get('smsprogram').setValue('');
  }
  updateSender() {
    this.submitted = true;
    if (this.verifySenderForm.invalid || this.files.length === 0 || null) {
      return false;
    }
    if (this.files.length > 10 || this.selectedFile.length > 10) {
      return false;
    }
    if ((this.urls && this.urls.length === 0)) {
      return false;
    }
    else {
      this.urls1 = [];
      this.urls.forEach((item) => {
        if (typeof item === 'object' && item.hasOwnProperty('url')) {
          this.urls1.push(item.url);
        } else {
          this.urls1.push(item);
        }
      });
      this.verifySenderForm.get('url').setValue(this.urls1[0]);
      this.verifySenderForm.value.country = this.selectedItem[0].value
      this.verifySenderForm.value.OptInType = this.selectedItem1[0].value
      this.verifySenderForm.value.usecasecategory = this.selectedUSecaseValues      
 
      let payLoad: any = JSON.stringify({
        id: this.req_id,
        data: this.verifySenderForm.value,
        previosFile: this.previousfiles,
        key: this.key,
        url: this.urls1
      })
      this.data.updateVerifySender(payLoad, this.files).subscribe(res => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = '';
            this.router.navigateByUrl('/Verified-Sender');
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      },
        (err) => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      );
      // }
    }
  }

  onSelectChange(event: any) {
    this.selectedRequestId = event.target.value;
    let payLoad: any = JSON.stringify({
      id: this.selectedRequestId,
      /* idaccount: this.idaccount,
      iduser: this.iduser */
    });
    this.data.view_VerifySender(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.urls = [];
        this.user = result.data[0];
        this.url = result.data1
        const filePaths = this.user.file_paths.split(',');
        this.files = [];
        this.previousfiles = []
        filePaths.forEach((filePath, index) => {
          const fileName = filePath.substring(filePath.lastIndexOf('/') + 1);
          const fileObject = {
            file: filePath,
            name: fileName,
          };
          this.files.push(fileObject);
          this.previousfiles.push(fileObject);
        });
        if (this.url.length === 0) {
          this.urls.push(this.user.call_to_action_url)
        } else {
          this.url.forEach((item) => {
            this.urls.push(item.url.trim())
          });
        }
        
        this.selectedItem = this.country
        .filter((item: any) => item.value == this.user.business_country)
        .map((item: any) => ({ name: item.name, value: item.value }));
          this.selectedUSecaseValues = this.user.use_case_category.split(',').map(s => s.trim());
          this.selectedItems = this.usecaseData.filter(item =>
              this.selectedUSecaseValues.includes(item.value)
          );

          this.selectedItem1 = this.optData.filter(item => item.value === this.user.opt_in_type);
        this.verifySenderForm.patchValue({
          messagingprovider: 'Intelliquent',
          businessname: this.user.business_name,
          address: this.user.address1,
          address1: this.user.address2,
          city: this.user.city,
          state: this.user.state,
          zip: this.user.zip,
          firstname: this.user.first_name,
          lastname: this.user.last_name,
          email: this.user.business_email,
          phonenumber: this.user.business_phone,
          websiteurl: this.user.corporate_website_url,
          usecase: this.user.summarize_usecase,
          // usecasecategory: this.user.use_case_category,
          contentcampaign: this.user.sample_message,
          published: this.user.number_published,
          url: this.user.call_to_action_url,
          numbers: this.user.call_to_action_numbers,
          messagevolume: this.user.message_volume_per_month,
          workdescription: this.user.opt_in_workflow_description,
          // addInfo: this.user.additional_opt_on_information,
          // ticketnumber: this.user.internal_ticket_number,
          // isv: this.user.isv_reseller,
          supportdocs: this.user.additional_supporting_documentation,
          text_msg_type: this.user.text_message_type,
          traffic_previous_msg_service: this.user.traffic_previously_msg_service,
          traffic_expected: this.user.traffic_expected,
          //smsprogram: this.user.sms_program,
          dbaname: this.user.dba_name,
          company: this.user.fortune_company,

          /* notificationEmail: this.user.notification_email, */
          // OptInType: this.user.opt_in_type,
          externalReferenceId: this.user.external_reference
 
        });
      } else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  // handleClick1(file: File): void {
  //   if (this.files && this.selectedFile) {
  //     this.removeFile1(file);
  //     this.removeFile(file);
  //   }
  // }

  downloadFile(file: File) {
    if (file) {
      const a = document.createElement('a');
      a.href = URL.createObjectURL(file);
      a.download = file.name;
      a.click();
    }
  }

  viewFile(data: File) {
    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal = document.getElementById('modalVideoForFile');
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    if (data.type.startsWith('image/')) {
      const imageData = data;
      modalImage.src = URL.createObjectURL(imageData);
      // Open the modal for images
      $(imageModal).modal('show');
    } else if (data.type === 'application/pdf') {
      const pdfData = data
      modalImage123.src = URL.createObjectURL(pdfData);
      // Open the modal for non-image files
      $(pdfModal).modal('show');
    } else if (data.type.startsWith('video/')) {
      const videoData = data;
      videoModal12.src = URL.createObjectURL(videoData);
      // Open Modal for Video
      $(videoModal).modal('show');
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    }
    else {
      if (data) {
        const a = document.createElement('a');
        a.href = URL.createObjectURL(data);
        a.download = data.name;
        a.click();
        $(docxModal).modal('show');
      }
    }
  }

  viewFile1(data: any) {
    const fileExtension = data.name.split('.').pop();

    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const videoModal = document.getElementById('modalVideoForFile');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg") {
      const imageData = data.file;
      modalImage.src = data.file
      // Open the modal for images
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      // const pdfData = data.file
      modalImage123.src = data.file
      // Open the modal for non-image files
      $(pdfModal).modal('show');
    } else if (fileExtension === 'mp4') {
      // const videoData = data.file;
      videoModal12.src = data.file
      // Open Modal for Video
      $(videoModal).modal('show');
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    }
    else {
      if (data.file) {
        const a = document.createElement('a');
        a.href = data.file;
        a.download = data.name;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        $(docxModal).modal('show');
      }
    }
  }

  removeFile(fileToRemove: File): void {
    this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
    this.files = this.files.filter(file => file !== fileToRemove);
  }


  removeFile1(fileToRemove: File): void {
    this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
    this.previousfiles = this.previousfiles.filter(file => file !== fileToRemove);
    this.previousfiles = this.previousfiles
    this.files = this.files.filter(file => file !== fileToRemove);
  }

  downloadFile1(data: any) {
    if (data.file) {
      const a = document.createElement('a');
      a.href = data.file;
      a.download = data.name;
      a.click();
    }
  }

  handledownload(file: any): void {
    if (file.file && file.name) {
      this.downloadFile1(file);
    } else {
      this.downloadFile(file);
    }
  }

  onFileChange(event: Event) {
    const fileInput = event.target as HTMLInputElement;

    if (fileInput.files && fileInput.files.length > 0) {
      const file: File = fileInput.files[0];
      const fileSize = file.size;
      const maxSizePerFile = 10 * 1024 * 1024;
      if (fileSize > maxSizePerFile) {
        this.errMessage = "Individual file size limit exceeded";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      const totalFileSize = this.selectedFile.reduce((total, selectedFile) => total + selectedFile.size, 0);
      const maxTotalSize = 30 * 1024 * 1024;
      if (totalFileSize + fileSize > maxTotalSize) {
        this.errMessage = "Total files size limit exceeded";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      const allowedTypes = ['image/jpeg', 'image/png', 'application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'video/mp4', 'text/plain'];
      if (!allowedTypes.includes(file.type)) {
        this.errMessage = "Invalid file type. Allowed types are: .jpg, .jpeg, .png, .pdf, .docx, .mp4, .txt";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      const reader = new FileReader();
      reader.readAsDataURL(file);
      if (this.req_id) {
        this.selectedFile.push(file);
        this.files.push(file);
      } else {
        this.selectedFile.push(file);
        this.files.push(file);
      }
      fileInput.value = '';
    }
  }

  handleClick(file: File): void {
    if (this.files && this.selectedFile) {
      this.viewFile1(file);
      this.viewFile(file);
    }
  }

  addUrl(url: string): void {
    if (url.trim() !== '') {
      this.urls.push(url.trim());
      this.verifySenderForm.get('url').reset();
    }
  }

  removeUrl(index: number): void {
    this.urls.splice(index, 1);
  }

  truncateUrl(url: string): string {
    if (!url) return '';
    return url.length > 40 ? url.substring(0, 40) + '...' : url;
  }

  ModalOPen() {
    
    const modal = document.getElementById('createmodal');
    if (modal) {
      $(modal).modal('hide');
      $('.modal-backdrop').remove();
    }
    this.router.navigateByUrl('/addverifysender')

    this. GetVerifiedUsecaseProfile()
 
  }

  onItemSelect(item: any) {
    // console.log(item);
  }

onChange() {
    this.selectedUSecaseValues = this.selectedItems.map(item => item.value);
   
}

onSelectAll(items: any[]) {
    this.selectedItems = [...items];
    this.onChange();
}

onDeSelectAll() {
    this.selectedItems = [];
    this.onChange();
}

truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

PostalCode(event: any): boolean {
    this.selecteddata = this.verifySenderForm.get('country').value;
  if (this.selecteddata[0]?.value == 'CA') {
    this.zipLength = 10;
    let Post: any = this.verifySenderForm.get("zip");
    Post.setValidators([Validators.required, 
      Validators.minLength(0), 
      Validators.maxLength(this.zipLength)]);
    Post.updateValueAndValidity();

    const regex = /^[0-9a-zA-Z\b]+$/;
    const key = String.fromCharCode(event.which || event.keyCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
    return true;
  }

  if (this.selecteddata[0]?.value == 'US') {
    this.zipLength = 5;
    let Post: any = this.verifySenderForm.get("zip");
    Post.setValidators([Validators.required, 
      Validators.minLength(this.zipLength), 
      Validators.maxLength(this.zipLength)]);
    Post.updateValueAndValidity();

    const charCode = event.which || event.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
      event.preventDefault();
      return false;
    }
    return true;
  }

  return true;
}

// Updated validators to show validation immediately on input
  noLeadingSpaceValidator() {
    return (control: any) => {
      if (control.value === null || control.value === undefined || control.value === '') return null;
      const regex = /^[^\s].*$/; // first char should not be space
      if (control.value.length > 0 && !regex.test(control.value)) {
        return { leadingSpace: true };
      }
      return null;
    };
  }

  noDigitsValidator() {
    return (control: any) => {
      if (control.value === null || control.value === undefined || control.value === '') return null;
      const regex = /^(?!.*\d)[^\d]*$/;
      if (control.value && !regex.test(control.value)) {
        return { invalidName: true };
      }
      return null;
    };
  }
  ngOnDestroy() {
    this.modalVideoForFile.nativeElement.click();
    this.modalPdfAppeal.nativeElement.click();
    this.modalImageAppeal.nativeElement.click();
    this.createmodal.nativeElement.click();

  }
}




