import { Component, ElementRef, Input, OnInit, ViewChild } from '@angular/core';
import {  FormBuilder, FormGroup} from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from '../usermanagement.service';
import * as pdfMake from 'pdfmake/build/pdfmake.js';
import * as pdfFonts from 'pdfmake/build/vfs_fonts.js';
pdfMake.vfs = pdfFonts.pdfMake.vfs;
(pdfMake as any).vfs = pdfFonts.pdfMake.vfs;
import { Router } from '@angular/router';
declare var $: any;

@Component({
  selector: 'app-account-verification',
  templateUrl: './account-verification.component.html',
  styleUrls: ['./account-verification.component.css']
})
export class AccountVerificationComponent implements OnInit {
	@Input() userList: any;
	show_filter: boolean = false;
	iduser: any;
	filterUser: FormGroup;
	dropdownSetting: IDropdownSettings = {};
	closeDropdownSelection = true;
	userlistFull: any = [];
	responseMessage: "";
	errMessage: any;
	submitted: boolean;
	reloaduserlist: any = [];
	countUser: any;
	rechargeForm: FormGroup;
	rechargedata: any;
	showcardPdf: any;
	federalStatus: any;
	showKycPdf: any;
	showfederalPdf: any;
	idaccount: any;
	federalPDF: any;
	cardPdfDetails: any = [];
	kycPdfDetails: any = [];
	public custoDfilter: FormGroup;
	showAddNote: boolean = false;
	selectedIdUse: number | null = null;
	selectedIdAccount: number | null = null;
	@ViewChild('modalpdf')modalpdf : ElementRef;

  constructor(public fb: FormBuilder,public data:UsermanagementService,private router: Router) { }

  ngOnInit(): void {
	this.loadInitialData();
	this.initializeForm();

	$('#basic-datatablesaccount').dataTable().fnClearTable();
    $('#basic-datatablesaccount').dataTable().fnDraw();
    $('#basic-datatablesaccount').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');

	this.dropdownSetting = {
		singleSelection: true,
		idField: 'userdata',
		textField: 'reloaduserlist',
		itemsShowLimit: 1,
		allowSearchFilter: true,
		closeDropDownOnSelection: this.closeDropdownSelection
	};

	this.data.getCardPdfForAdmin().subscribe((res) => {
		this.cardPdfDetails = res.data;
	})
	this.data.getKycPdfData().subscribe((res) => {
		this.kycPdfDetails = res.data;
	})
  }

  	 showfilter() {
  this.show_filter = !this.show_filter;
}
	initializeForm() {
		this.filterUser = this.fb.group({
		  to_date: [''],
		  from_date: [''],
		  customername: [''],
		  emailid: [''],
		  san: ['']
		});
	}

	loadInitialData() {
		this.GetUsers();
	}
	GetUsers(): void {
	$('#basic-datatablesaccount').dataTable().fnClearTable();
    $('#basic-datatablesaccount').dataTable().fnDraw();
    $('#basic-datatablesaccount').dataTable().fnDestroy();
		if(this.userList && this.userList.length){
			this.userlistFull = this.userList
			.filter(user => 
				user.is_deleted == 0 && 
				user.kyc_verify_status !== 1 && 
				user.country !== 'US' && 
				user.country !== 'CA' &&  
				user.country !== 'USA' && 
				user.country !== 'United States' && 
				user.country !== 'Canada' && 
				user.country !== 'United States ' && 
				user.country !== 'undefined' && 
				user.country				
			).sort((a, b) => new Date(b.created).getTime() - new Date(a.created).getTime())
			.map(user => ({
				...user,
				createdFormatted: new Intl.DateTimeFormat('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' }).format(new Date(user.created)),
				reloaduserlist: `${user.san} - ${user.first_name} ${user.last_name}`,
				color: user.is_billing === '0' ? 'green' : 'red',
				msg: user.is_billing === '0' ? 'Billing is Enabled' : 'Billing is Disabled',
				onboardingstatus: this.getOnboardingStatus(user),
				tooltp: this.getOnboardingTooltip(user)
			}));
		
			this.reloaduserlist = this.userlistFull
			.map(item => ({
				userdata: item.idaccount,
				reloaduserlist: item.reloaduserlist
			}))
			.sort((a, b) => a.reloaduserlist.localeCompare(b.reloaduserlist));
		}else{
			console.error('data is undefiend');
		}
		$.getScript('./assets/tollfree.js');
	}

	resetFrm() {
		this.submitted = false
		this.rechargeForm.reset();
		this.rechargeForm.patchValue({
			paymentType: 2,
			idaccount: this.rechargedata.idaccount,
			email: this.rechargedata.email,
			currentDateTime: this.current_datetime()
		})
	}

	downloadPdf(iduser: any, idaccount: any) {
		this.iduser = iduser;
		this.idaccount = idaccount;
		let findedData = this.kycPdfDetails.find(i => i.iduser == this.iduser && i.kyc_verify_status == '1');
		if (findedData != undefined) {
			this.showKycPdf = findedData.value
		}
		else {
			this.showKycPdf = false
		}

		let findCardData = this.cardPdfDetails.find(x => x.idaccount == this.idaccount && x.card_pdf !== '');
		if (findCardData != undefined) {
			this.showcardPdf = findCardData.card_pdf;
			console.log('findCardData', this.showcardPdf)
		}
		else {
			this.showcardPdf = false;
		}
	}

	downloadPDF(e) {
		fetch(e).then(resp => resp.arrayBuffer()).then(resp => {
			// set the blog type to final pdf
			const file = new Blob([resp], { type: 'application/pdf' });
			// process to auto download it
			const fileURL = URL.createObjectURL(file);
			const link = document.createElement('a');
			link.href = fileURL;
			link.download =  e.split('kyc_pdf/')[1] || e.split('card_pdf/')[1];
			link.click();
		});
	}

	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + "-" + month + "-" + day //+ " " + hour + ":" + minute + ":" + second;
	}

	getOnboardingStatus(user: any): string {
		return (user.isAddress === 'true' && user.isEmailVerify === 'true' && user.isMobileVerify === 'true' && user.isPlan === 'true' && !(user.newUser_status === 1 && user.isCard !== "true"))
			? "green" : "red";
	}
	getOnboardingTooltip(user: any): string {
		return this.getOnboardingStatus(user) === "green" ? "On-Boarding Complete" : "On-Boarding In Process";
	}
	filterByUser(e) {
		this.filterUser.patchValue({
			selectedUser: e.target.value
		});
	}

	applyUserFilter() {
		this.submitted = true;
		if (this.filterUser.invalid) {
			return false;
		} else {
			if (this.filterUser.value.to_date ||this.filterUser.value.from_date ||(this.filterUser.value.san && this.filterUser.value.san.length > 0) ||this.filterUser.value.customername ||this.filterUser.value.emailid
			) {
				const filterValues = Object.values(this.filterUser.value);
				const allFieldsEmpty = filterValues.every(value => value === "");
	
				this.data.UserFilternonca(JSON.stringify(this.filterUser.value)).subscribe((res) => {
					if (res.status === 201) {
						$('#basic-datatablesaccount').dataTable().fnClearTable();
						$('#basic-datatablesaccount').dataTable().fnDraw();
						$('#basic-datatablesaccount').dataTable().fnDestroy();
	
						this.userlistFull = res.data
							.filter(user => user.kyc_verify_status === 0 && user.country !== 'US' && user.country !== 'CA' &&  user.country!=='USA' && user.country!=='United States' && user.country!=='Canada' && user.country!=='United States ' && user.country!=='undefined'&& user.country  )
							.sort((a, b) => new Date(b.created).getTime() - new Date(a.created).getTime())
							.map(user => ({
								...user,
								createdFormatted: new Intl.DateTimeFormat('en-US', { year: 'numeric', month: '2-digit', day: '2-digit' }).format(new Date(user.created)),
								reloaduserlist: `${user.san} - ${user.first_name} ${user.last_name}`,
								color: user.is_billing === '0' ? 'green' : 'red',
								msg: user.is_billing === '0' ? 'Billing is Enabled' : 'Billing is Disabled',
								onboardingstatus: this.getOnboardingStatus(user),
								tooltp: this.getOnboardingTooltip(user)
							
							}));
	
						$.getScript('./assets/tollfree.js');
						this.responseMessage = allFieldsEmpty ? "" : res.message;
						setTimeout(() => (this.responseMessage = ""), 5000);
					} else {
						this.errMessage = res.message;
						setTimeout(() => (this.errMessage = ""), 5000);
					}
				});
	
			} else {
				this.errMessage = "Please enter at least one field!";
				setTimeout(() => {
					this.errMessage = "";
				}, 3000);
			}
		}
	}

  	resetUserFilter() {
		this.filterUser.reset();
		this.GetUsers();
  	}

	messageshow() {
		const from_date = this.filterUser.get('from_date').value;
		const to_date = this.filterUser.get('to_date').value;
		const currentDate = new Date();
		if ((!from_date && !to_date)) {
		} else if ((from_date == null || !from_date) && (to_date != null)) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((from_date != null) && (to_date == null || !to_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
		  return;
		} else if (to_date && new Date(to_date) > currentDate) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
		  return;
		} else if (from_date && new Date(from_date) > currentDate) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
		  return;
		} else {
		  this.filterUser.get('from_date').setErrors(null);
		  this.filterUser.get('to_date').setErrors(null);
		}
	}

	addNote(data:any): void {
        sessionStorage.removeItem('navigation');
         sessionStorage.setItem('navigation', 'fromuserlist');
        this.router.navigate([`/user/addnote/${data.idaccount}/${data.iduser}`]);  
    }

	toggleView(): void {
		this.showAddNote = !this.showAddNote;
	}
	ngOnDestroy() {
		this.modalpdf.nativeElement.click();
	}
}
