import { Component, ElementRef, HostListener, Input, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { NgbActiveModal, NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-password',
  templateUrl: './password.component.html',
  styleUrls: ['./password.component.css']
})
export class PasswordComponent implements OnInit {
  // @ViewChild ('passwordmodal') passwordmodal;
  @Input() currentUser: any;
  submitted3 = false;
  changepasswordForm: FormGroup;
  curaccount: any;
  key = -1;
  responseMessage: any = "";
  errMessage: any = "";
  eyetoggle: boolean = false;
  eyetoggle1: boolean = false;
  eyetoggle2: boolean = false;
  showErr: any = "";
  oldPass: any ="";
  constructor(public data: UsermanagementService, public fb: FormBuilder,
    public activeModal: NgbActiveModal, public config: NgbModalConfig,
    private modalService: NgbModal) {
    config.backdrop = 'static';
    config.keyboard = false;
  }

  ngOnInit(): void {
    this.changepasswordForm = this.fb.group({
      old_password: ['', [Validators.required]],
      new_password: ['', [Validators.required,Validators.minLength(8)]],
      confirm_password: ['', [Validators.required,Validators.minLength(8)]]
    });
  }

  change_password() {
    this.submitted3 = true;
    if (this.changepasswordForm.invalid) {
      return false;
    }
    else {
      this.key = this.currentUser.iduser;
      if (this.changepasswordForm.get('new_password').value == this.changepasswordForm.get('old_password').value)      
      alert("New password should be different from old password");
    else {
      if (this.changepasswordForm.get('new_password').value == this.changepasswordForm.get('confirm_password').value) {
        this.data.updatePass(JSON.stringify(this.changepasswordForm.value), this.key).subscribe(rs => {
          if (rs.status == 201) {
            this.activeModal.close({ message: rs.message, status: true, result: rs.result });
            this.responseMessage = rs.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          }
          else {
            this.errMessage = rs.message;
            this.showErr = rs.message;
            // this.oldPass = rs.result[0]; 
            setTimeout(() => {
              this.errMessage = "";
            }, 3000);
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        });
      }
      else {
        alert("Your entered confirm password does not match");
      }
      }
    }
  }

  closeModal() {
    this.activeModal.close({ message: "", status: false });
  }

  removeErr(){   
    this.showErr= '';
  }
  eyeToggle(check: any) {
    if (check == 1)
      if (this.eyetoggle)
        this.eyetoggle = false
      else
        this.eyetoggle = true
    else if (check == 2)
      if (this.eyetoggle1)
        this.eyetoggle1 = false
      else
        this.eyetoggle1 = true
    else
      if (this.eyetoggle2)
        this.eyetoggle2 = false
      else
        this.eyetoggle2 = true
  }
  
  @HostListener('window:keydown', ['$event'])
  handleKeyDown(event: KeyboardEvent) {
    if (event.altKey && event.key === 'ArrowLeft') {
      this.closeModal();
    }
  }

  // ngOnDestroy(){
	// 	this.passwordmodal.nativeElement.click();
	//   }
}



