import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSlideToggleChange } from '@angular/material/slide-toggle';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-payment',
  templateUrl: './payment.component.html',
  styleUrls: ['./payment.component.css']
})

export class PaymentComponent implements OnInit {

  public status: boolean = false;
  submitted: boolean;
  public key: number;
  public ptype: number;
  header: any;
  paymentlist: any;
  public isapply: boolean = true;
  isLoggedIn: any;
  responseMessage: any;
  paymentSettingForm: FormGroup;
  subbmitted: boolean = false;
  isAutoPayment = false;
  isAutoEmail: Boolean = false;
  isAutowebhook: Boolean = false;
  paymentData: any = "";
  errMessage: any = "";
  stripeCards: any = [];
  isCard: Boolean = false;
  paymentHandler: any;
  isNewCard: Boolean = false;
  defaultamt: any;
  topup_amount: any;
  idwallet: any;
  roles_permissions: any = [];
  onlyRead: boolean = false;
  userType: any;
  curaccount: any;
  useriduser: any;
  useridaccount: any;
  isToggled: boolean;
  status1: any; // emailToggle
  status2: any; // webhookToggle
  status3: any; // autTopUpToggle

  constructor(private data: UsermanagementService, public dialog: MatDialog, private fb: FormBuilder) { }

  ngOnInit(): void {

    this.curaccount = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = this.curaccount.type;
    this.useriduser = this.curaccount.iduser;
    this.useridaccount = this.curaccount.idaccount;

    this.data.stripeCards().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.stripeCards = res.data;
          this.isCard = true;
          if (this.stripeCards.length >= 5) {
            this.isNewCard = true;
          }
          else {
            this.isNewCard = false;
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });


    this.paymentSettingForm = this.fb.group({
      idwallet: [],
      defaultamt: ['', [Validators.required, Validators.min(1), Validators.max(500000)]],
      topup_amount: [''],
      webhook_url: [''],
      credit_limit: ['']
    });

    this.getDataPatch();
    this.getUserPermissions();
  }

  getDataPatch() {
    let webhookControl = this.paymentSettingForm.get('webhook_url');
    let TopUpControl = this.paymentSettingForm.get('topup_amount')
    this.data.getBalance().subscribe(response => {
      console.log(response, 'okdead')
      if (response.data[0].isWebhook == 'true') {
        webhookControl.setValidators([Validators.required, Validators.pattern("Validators.pattern(/^(https?:\/\/)?((([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,})|localhost|(\d{1,3}\.){3}\d{1,3})(:\d+)?(\/[^\s]*)?$/)")]);
      } else {
        webhookControl.clearValidators();
      }
      webhookControl.updateValueAndValidity();
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.paymentData = response.data[0];
          this.idwallet = this.paymentData.idwallet;
          this.status3 = this.paymentData.status
          this.status2 = this.paymentData.isWebhook 
          this.status1 = this.paymentData.isEmail

          this.paymentSettingForm.patchValue({
            idwallet: response.data[0].idwallet,
            defaultamt: response.data[0].min_balance,
            topup_amount: response.data[0].topup_amount,
            webhook_url: response.data[0].webhook_url,
            credit_limit: response.data[0].credit_limit,
          });
          if (this.paymentData.status == 'true') {
            TopUpControl.setValidators([Validators.required, Validators.min(50), Validators.max(500000)]);

          } else {
            TopUpControl.clearValidators();
            TopUpControl.setValidators([Validators.max(500000)]);
          }
          TopUpControl.updateValueAndValidity();
        }
        else {
          this.paymentData = {
            status: 'false',
            isWebhook: 'false',
            isEmail: 'false',
          }
        }
        this.subbmitted = false;
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }


  getUserPermissions() {
    this.data.getPermissions().subscribe((res) => {
      if (res.status == 200) {
        this.roles_permissions = res.data;
        this.roles_permissions.forEach((item) => {
          let user_type_name: any = item.id_user_type == '1' ? '201' : item.id_user_type == '2' ? '202' : item.id_user_type == '3' ? '203' : item.id_user_type == '4' ? '231' : item.id_user_type == '5' ? '232' : ''
          if (item.feature_id == 3 && item.read == 1 && item.write == 0 && (this.userType == user_type_name)) {
            this.onlyRead = true;
          }
          else if (item.feature_id == 3 && item.write == 1 && item.read == 0 && (this.userType == user_type_name)) {
            this.onlyRead = false;
          }
        });
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      }
    });
  }
  onPaymentSetting() {
    this.submitted = true;
    const topupAmt = this.paymentSettingForm.value.topup_amount;
    if (this.paymentSettingForm.invalid) {
      this.submitted = true;
      return;
    }
    else {
      if (!this.isCard) {
        this.errMessage = "Add Card Detail For Auto Payment!";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
      else {
        let payload = {
          data: this.paymentSettingForm.value,
          isAutoEmail: this.status1, 
          isAutowebhook: this.status2, 
          isAutoPayment: this.status3, 
          userType: this.curaccount.type, 
          useriduser: this.curaccount.iduser, 
          useridaccount: this.curaccount.idaccount,
          IsToggled: this.isToggled 
        };
        this.data.updatePaymentService(payload).subscribe(response => {
          if (response.status == 201) {
            this.isToggled = false;
            this.responseMessage = response.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            // this.ngOnInit();
          }
          else {
            this.isToggled = false;
            this.errMessage = response.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
      }
    }
  }

  onEmailStatus(e: MatSlideToggleChange) {
    // let status: any;
    if (e.checked) {
      this.status1 = 'true';
    }
    else {
      this.status1 = 'false';
    }
  }

  onAutoPayment(e: MatSlideToggleChange) {
    let TopUpControl = this.paymentSettingForm.get('topup_amount')
    this.isToggled = true;
    if (e.checked) {
      this.status3 = 'true';
    }
    else {
      this.status3 = 'false';
    }
    if (this.status3 == 'true') {
      TopUpControl.setValidators([Validators.required, Validators.min(50), Validators.max(500000)]);
    } else {
      TopUpControl.clearValidators();
      TopUpControl.setValidators([Validators.max(500000)]);
    }
    TopUpControl.updateValueAndValidity();

  }

  dftBalance(e) {
    if (e == '1') {
      this.paymentSettingForm.patchValue({
        defaultamt: 200,
      });
    } else {
      this.paymentSettingForm.patchValue({
        topup_amount: 200,
      });
    }

  }
  onIsWebhook(e: MatSlideToggleChange) {
    let webhookControl = this.paymentSettingForm.get('webhook_url')
    if (e.checked) {
      this.status2 = 'true';
    }
    else {
      this.status2 = 'false';
    }
    if (this.status2 == 'true') {
      webhookControl.setValidators([Validators.required, Validators.pattern("Validators.pattern(/^(https?:\/\/)?((([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,})|localhost|(\d{1,3}\.){3}\d{1,3})(:\d+)?(\/[^\s]*)?$/)")]);
    } else {
      webhookControl.clearValidators();
    }
    webhookControl.updateValueAndValidity();
  }

  getAmount(e: any) {
    this.defaultamt = e.target.value;
    this.paymentSettingForm.patchValue({
      defaultamt: this.defaultamt
    });
    let data = e.target.value;
    e.target.value = (data.indexOf(".") >= 0) ? (data.substr(0, data.indexOf(".")) + data.substr(data.indexOf("."), 2)) : data;
    return;
  }

  getTopup(e: any) {
    this.isToggled = true;
    this.topup_amount = e.target.value;
    this.paymentSettingForm.patchValue({
      topup_amount: this.topup_amount
    });
    let data1 = e.target.value;
    e.target.value = (data1.indexOf(".") >= 0) ? (data1.substr(0, data1.indexOf(".")) + data1.substr(data1.indexOf("."), 2)) : data1;
    return;
  }

  resetform() {
    this.submitted = false;
    // this.paymentSettingForm.reset();
    if (this.status2 == 'true') {
      this.paymentSettingForm.get('webhook_url')?.reset('');
    }
    this.paymentSettingForm.patchValue({
      idwallet: this.idwallet,
      credit_limit: this.paymentData.credit_limit,
      topup_amount: 200,
      defaultamt: 200
    })
  }

}
