import { Component, ElementRef, Input, ViewChild } from '@angular/core';
import { UsermanagementService } from '../usermanagement.service'
import { Router } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { usermanagement, usermanagementForm } from '../user.class';
import { BehaviorSubject, Observable } from 'rxjs';
import { TariffService } from 'src/app/tariff/tariff.service';
import { ResellerService } from 'src/app/reseller/reseller.service';
import { MatSelectChange } from '@angular/material/select';
import { SubscriptionService } from 'src/app/subscription/subscription.service';
declare var $: any;

@Component({
	selector: 'app-supplieruser',
	templateUrl: './supplieruser.component.html',
	styleUrls: ['./supplieruser.component.css']
})

export class SupplieruserComponent extends AppComponentClass<usermanagement, usermanagementForm> {
	@ViewChild('createmodal') createmodal: ElementRef;
	@Input() usertype: Observable<boolean>;
	@Input() curuserid?: number = -1;
	step = 0;

	v_status$ = new BehaviorSubject<String>("Disable");
	v_status = this.v_status$.asObservable();
	isDisableAdd: boolean;
	isDesMob: boolean;
	isDesEmail: boolean;
	isAddChecked: boolean;
	isMobChecked: boolean;
	isEmailChecked: boolean;
	zipLength: any;
	Addresslist: any;
	UsaState: any;
	custType: any;
	resellerFilter: FormGroup;
	resllerlist: any = [];
	corporationLimitedCountry: any = [];
	solePropCountry: any[];
	internationalBusiCountry: any = [];
	noneProfitCountry: any = [];
	allCountry: any = [];
	Country: any;
	customerType: any;
	setStep(index: number) {
		this.step = index;
	}

	showMsg: boolean = false;
	p: number = 1;
	rowdata: any;
	details: any;
	listdata: any;
	record: any;
	list: any;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [5, 9, 12];
	modelform: any;
	public show: boolean = false;
	public package: any;
	public buttonName: any = "Add";
	public supplieruserForm: FormGroup;
	responseMessage = "";
	public submitted: boolean = false;
	filterTerm: string;
	fileToUpload: File = null;
	file: any;
	is_true: boolean = false;
	addedUserId: string;
	imagePreview: any;
	regTariffs: any = [];
	unregTariffs: any = [];
	dangMessage = "";
	preferenceServices: any = [];
	errMessage: any = "";
	USA: boolean = false;
	Canada: boolean = false;
	countryVal: any;
	// dropdownSettings: IDropdownSettings = {};
	resllerlists: any = [];
	resllers: any = [];
	subscriptions: any = [];

	constructor(public data: UsermanagementService,
		public router: Router, public fb: FormBuilder,
		private tariffService: TariffService, private resellerService: ResellerService, private subscriptionservice: SubscriptionService) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		this.isDisableAdd = true;
		this.isDesEmail = true;
		this.isDesMob = true;
		this.isAddChecked = false;
		this.isMobChecked = false;
		this.isEmailChecked = false;
		this.tariffService.getPreferenceService().subscribe(res => {
			this.preferenceServices = res.data;
			const found_true = this.preferenceServices.find(element => element.is_default == 'true');
			this.is_true = found_true.idservice;
			this.patchService();
		}, err => {
			console.log(err.message);
		});

		$(document).ready(() => {
			$('[data-toggle="tooltip"]').tooltip()
		})

		// Get tariffs
		this.tariffService.getTariffs().subscribe(res => {
			this.regTariffs = res.data;
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});

		// this.tariffService.getTypesTariff("Unregistered").subscribe(res => {
		// 	this.unregTariffs = res.data;
		// }, err => {
		// 	this.responseMessage = err.message;
		// 	setTimeout(()=>{
		// 		this.responseMessage= "";
		// 	}, 5000);
		// });

		let sessData = JSON.parse(sessionStorage.getItem("isLoggedIn"));
		let iduser = sessData.iduser;

		// @subscribing form group		
		this.data.solution.subscribe(res => {
			if (res != null) {
				this.cdata = new usermanagementForm(res);
				this.keyfield = this.userid;
				this.cdata.iduser = iduser;
				this.supplieruserForm = this.cdata.makeform(this.fb);
			} else {
				this.cdata = new usermanagementForm(null);
				this.cdata.idaccount = -1;
				this.cdata.iduser = iduser;
				this.usertype.subscribe(res => {
					if (res) {
						this.cdata.type = 3;
						this.supplieruserForm = this.cdata.makeform(this.fb);
					}
					else {
						this.cdata.type = 2;
						this.supplieruserForm = this.cdata.makeform(this.fb);
					}
					this.customerType = this.cdata.type;
				});
			}
		});

		this.data.getsuppiler().subscribe((result) => {
			this.listdata = result[1];
			this.record = result[0].headers_details;
			this.list = result[0].profile_details;
			this.Addresslist = result[0].address_details;
			this.custType = "Corporation";
			this.getCountry();
		});

		this.data.US_State().subscribe(res => {
			this.UsaState = res[0].US_State;
		});

		this.supplieruserForm.patchValue({
			reseller_id: 0
		});
		this.resellerFilter = this.fb.group({
			fType: [''],
			email: [''],
			firstname: [''],
			lastname: [''],
			fromDate: [''],
			toDate: [''],
		})

		this.resellerService.getReseller(JSON.stringify(this.resellerFilter.value)).subscribe(res => {
			if (res.status == 200) {
				this.resllerlist = res.data;
				this.resllerlist.sort((a, b) => {
					return a.iduser - b.iduser;
				  });

				// 	this.resllerlists = res.data.map(data => ({
				// 		...data,
				// 		resellername: `${data.firstname} - ${data.lastname}`
				// 	})
				//   )
				//   console.log("jhsdgjhsdghjksdhgjkshgksjg", this.resllerlists);

			}
		});

		// this.dropdownSettings = {
		// 	singleSelection: true,
		// 	idField: 'iduser',
		// 	textField: 'resellername',
		// 	itemsShowLimit: 1,
		// 	allowSearchFilter: true,
		// 	closeDropDownOnSelection: true
		//   };
	}

	getCountry() {
		this.data.getCountry().subscribe(res => {
			this.corporationLimitedCountry = [];
			this.solePropCountry = [];
			this.internationalBusiCountry = [];
			this.noneProfitCountry = [];
			if (res.status == 200) {
				this.allCountry = res.data;
				this.allCountry.forEach(element => {
					// To get Corporation / Limited Liability Company (USA Only)
					if (element.corporation_or_limited_liability_company_only_us == '1')
						this.corporationLimitedCountry.push(element);

					// To get Sole Proprietor / Individual
					if (element.sole_proprietor_or_individual == '0' || element.sole_proprietor_or_individual == '1')
						this.solePropCountry.push(element);

					// To get International Business (non-US)
					if (element.international_business_none_us == '1')
						this.internationalBusiCountry.push(element);

					// To get Non-Profit, 501C
					if (element.none_profit_501c == '0' || element.none_profit_501c == '1')
						this.noneProfitCountry.push(element);
				});
				this.Oncustomer();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = "Something went wrong with country list!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	patchService() {
		this.preferenceServices.forEach(element => {
			// console.log("all services",element);			
		});
	}

	onTypeEmail(event) {
		this.supplieruserForm.patchValue({
			email: event.target.value
		});
	}
	onImagePicked(event) {
		const file = (event.target as HTMLInputElement).files[0];
		this.supplieruserForm.patchValue({
			profile_pic: file
		});
		this.supplieruserForm.get("profile_pic").updateValueAndValidity();
		const reader = new FileReader();
		reader.onload = () => {
			this.imagePreview = reader.result;
		}
		reader.readAsDataURL(file);
	}

	downloadMyFile(): void {
		this.data
			.download('./assets/sample-csv/ratelist-sample.csv')
			.subscribe(blob => {
				const a = document.createElement('a')
				const objectUrl = URL.createObjectURL(blob)
				a.href = objectUrl
				a.download = 'ratelist-sample.csv';
				a.click();
				URL.revokeObjectURL(objectUrl);
			});
	}


	toggle() {
		this.show = !this.show;
		// CHANGE THE NAME OF THE BUTTON.
		if (this.show) this.buttonName = "Back";
		else this.buttonName = "Add";
	}

	// close() {
	// 	this.supplieruserForm.reset();
	// }


	// @to save/update form data
	onSubmit() {
		if (this.supplieruserForm.invalid) {
			this.submitted = true;
			return false;
		} else {
			let payload = {
				cdata: this.cdata,
				subscriptionid: this.subscriptions
			}
			if (this.cdata.saveForm(this.supplieruserForm)) {
				this.data.SaveAdminData(JSON.stringify(payload)).subscribe(res => {
					if (res.status == 201) {
						this.show = false;
						this.responseMessage = res.message;
						this.close1();
						const compModal = document.getElementById('createmodal');
						$(compModal).modal({ backdrop: 'static', keyboard: false });
						$(compModal).modal('show');
						setTimeout(() => {
							this.responseMessage = "";
						}, 3000);
						this.addedUserId = res.data[0].account;
						// this.submitted = false;
						// this.ngOnInit();
					}
					else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 3000);
					}
				});
			}
		}
	}

	onTariffSelect(event): void {
		let terrifid = event.target ? event.target.value : event.value;
		this.subscriptionservice.getSubscription(terrifid).subscribe(res => {
			if (res.status == 200) {
				this.subscriptions = res.data
			}
		})
	}

	isCheckedFun(event, type) {
		if (type == 'address') {
			this.supplieruserForm.patchValue({
				isAddress: event.target.checked
			})
			this.isAddChecked = true;
		}
		if (type == 'phone') {
			if (!this.supplieruserForm.controls['contact_number'].errors) {
				this.supplieruserForm.patchValue({
					isMobileVerify: event.target.checked
				})
			}
			this.isMobChecked = true;
		}
		if (type == 'email') {
			if (!this.supplieruserForm.controls['email'].errors) {
				this.supplieruserForm.patchValue({
					isEmailVerify: event.target.checked
				})
			}
			this.isEmailChecked = true;
		}
	}
	isField(type) {
		if (type == 'address') {
			if (this.supplieruserForm.value.address1 && this.supplieruserForm.value.city && this.supplieruserForm.value.state && this.supplieruserForm.value.country && this.supplieruserForm.value.postal_code && this.supplieruserForm.value.website && this.supplieruserForm.controls['website'].valid && this.supplieruserForm.controls['postal_code'].valid) {
				if (this.custType == 'Corporation' || this.custType == 'International_business') {
					if (this.supplieruserForm.value.businessName && this.supplieruserForm.value.ein && this.supplieruserForm.value.title && this.supplieruserForm.controls['ein'].valid) {
						this.isAddChecked = false;
						this.isDisableAdd = false;
					}
					else {
						this.isAddChecked = false;
						this.isDisableAdd = true;
					}
				}
				else if (this.custType == 'Non_Profit') {
					if (this.supplieruserForm.value.groupExmpt_number && this.supplieruserForm.value.title && this.supplieruserForm.value.ein && this.supplieruserForm.controls['ein'].valid) {
						this.isAddChecked = false;
						this.isDisableAdd = false;
					}
					else {
						this.isAddChecked = false;
						this.isDisableAdd = true;
					}
				}
				else if (this.custType == 'Sole_Proprietor') {
					if (this.supplieruserForm.value.businessName) {
						this.isAddChecked = false;
						this.isDisableAdd = false;
					}
					else {
						this.isAddChecked = false;
						this.isDisableAdd = true;
					}
				}
			}
			else {
				this.isAddChecked = false;
				this.isDisableAdd = true;
			}
		}
		if (type == 'phone') {
			if (this.supplieruserForm.value.contact_number && !this.supplieruserForm.controls['contact_number'].errors) {
				this.isMobChecked = false;
				this.isDesMob = false;
			}
			else {
				this.isMobChecked = false;
				this.isDesMob = true;
			}
		}
		if (type == 'email') {
			if (this.supplieruserForm.value.email && !this.supplieruserForm.controls['email'].errors) {
				this.isEmailChecked = false;
				this.isDesEmail = false;
			}
			else {
				this.isEmailChecked = false;
				this.isDesEmail = true;
			}
		}

	}
	onInputChange(event) {
		var k;
		k = event.charCode;
		const targetValue: string = (event.target as HTMLInputElement).value;
		if ((k >= 33 && k <= 126) || k === 8 || (k === 32 && /[^\s]$/.test(targetValue))) {
			return true;
		}
		return false
	}

	// resetSuplier(){
	// 	this.submitted = false;
	// 	this.supplieruserForm.reset({
	// 		user_name:this.cdata.user_name,
	// 		service : this.cdata.service,
	// 		type : this.customerType,
	// 		tariff1 : this.cdata.tariff1,
	// 		customerType : this.cdata.customerType,
	// 		country : this.cdata.country, 
	// 		state : this.cdata.state, 
	// 		credit_limit : this.cdata.credit_limit
	// 	});
	// 	this.supplieruserForm.get('reseller_id').setValue(0);
	// }

	close() {
		this.submitted = false;
		this.isAddChecked = false;
		this.isMobChecked = false;
		this.isEmailChecked = false;
		this.supplieruserForm.reset({
			// service: this.cdata.service,
			type: this.customerType,
			// tariff1: this.cdata.tariff1,
			// customerType: this.cdata.customerType,
			// country: this.cdata.country,
			// state: this.cdata.state,
			credit_limit: 0
		});
		this.supplieruserForm.get('reseller_id').setValue(0);
		this.supplieruserForm.get('groupExmpt_number').setValue('');
		this.supplieruserForm.get('businessName').enable();
		this.supplieruserForm.get('ein').enable();
		this.supplieruserForm.get('ein').setValue('');
		this.supplieruserForm.get('country').setValue('');
		this.supplieruserForm.get('customerType').setValue('');
		this.supplieruserForm.get('state').setValue('');
		this.supplieruserForm.get('tariff1').setValue('');
		this.supplieruserForm.get('service').setValue('');
		this.supplieruserForm.get('isEmailVerify').setValue('false');
		this.supplieruserForm.get('isMobileVerify').setValue('false');
		this.supplieruserForm.get('isAddress').setValue('false');
	}
	close1() {
		this.submitted = false;
		this.isAddChecked = false;
		this.isMobChecked = false;
		this.isEmailChecked = false;
		this.supplieruserForm.reset({
			type: this.customerType,
			credit_limit: 0
		});
		this.supplieruserForm.get('reseller_id').setValue(0);
		this.supplieruserForm.get('groupExmpt_number').setValue('');
		this.supplieruserForm.get('country').setValue('');
		this.supplieruserForm.get('customerType').setValue('');
		this.supplieruserForm.get('businessName').enable();
		this.supplieruserForm.get('ein').enable();
		this.supplieruserForm.get('ein').setValue('');
		this.supplieruserForm.get('state').setValue('');
		this.supplieruserForm.get('service').setValue('');
		this.supplieruserForm.get('isEmailVerify').setValue('false');
		this.supplieruserForm.get('isMobileVerify').setValue('false');
		this.supplieruserForm.get('isAddress').setValue('false');
		this.supplieruserForm.get('tariff1').setValue('');
	}


	listpage() {
		this.submitted = false;
		location.reload();
		this.createmodal.nativeElement.click();
	}

	ValidateAddress() {
		if (this.supplieruserForm.invalid) {
			this.submitted = true;
			return false;
		}
		else {
			if (this.countryVal == 'US') {
				this.data.getGeoCodeAdd(this.supplieruserForm.value).subscribe(res => {
					if (res.status == 200) {
						this.onSubmit();
					}
					else {
						this.errMessage = "Address Validation Failed!";
						setTimeout(() => {
							this.errMessage = "";
						}, 3000);
						return false;
					}
				}, err => {
					this.responseMessage = err.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 3000);
				});
				return false
			}
			else {
				this.onSubmit();
			}
		}

	}

	onCheck(e) {
		if (e.target.checked) {
			this.v_status$.next("Enable");
		}
		else {
			this.v_status$.next("Disable");
		}
	}

	onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	}

	onTableDataChange(event) {
		this.page = event;
	}

	onCountry(e: MatSelectChange) {
		if (e.value == 'US') {
			this.USA = true;
			this.Canada = false;
			this.countryVal = 'US';
			this.zipLength = '';
			let post = this.supplieruserForm.get('postal_code').value;
			this.supplieruserForm.get('state').setValue('');
			if (post.length != 5) {
				this.supplieruserForm.get('postal_code').setValue('');
			}
		} else if (e.value == 'CA') {
			this.Canada = true;
			this.USA = false;
			this.countryVal = 'CA';
			let post = this.supplieruserForm.get('postal_code').value;
			this.supplieruserForm.get('state').setValue('');
			if (post.length != 7) {
				this.supplieruserForm.get('postal_code').setValue('');
			}
		} else {
			this.Canada = false;
			this.USA = false;
			this.countryVal = '';
		}
		let ein: any = this.supplieruserForm.get('ein');
		if (this.custType == 'International_business' && this.countryVal == 'CA') {
			ein.setValidators([Validators.required, Validators.minLength(9), Validators.maxLength(9)]);
		} else if (this.countryVal == 'US' || (this.custType == 'Non_Profit' && (this.countryVal == 'US' || this.countryVal == 'CA'))) {
			ein.setValidators([Validators.required, Validators.minLength(9), Validators.maxLength(9)]);
		} else {
			ein.setValidators([Validators.required]); // Minimal validation for other cases
		}
		ein.updateValueAndValidity();
	}


	Oncustomer() {
		this.Addresslist.forEach(element => {
			if (this.custType == 'Corporation' || this.custType == 'International_business') {
				if (element.id == "groupExmpt_number") {
					this.supplieruserForm.get('groupExmpt_number').setValue('');
					element.hide = true;
				}
				else {
					element.hide = false;
				}
				if (element.id == "businessName" || element.id == "ein") {
					this.supplieruserForm.get('businessName').enable();
					this.supplieruserForm.get('ein').enable();
				}
				if (element.id == "businessName" || element.id == "ein" || element.id == "title" || element.id == "groupExmpt_number") {
					if (element.id == "businessName") {
						element.label = "Legal Business Name";
						element.placeholder = "Legal Business Name"	
					}
					// else if (element.id == "ein" && this.custType == 'Corporation') {
					// 	let ein: any = this.supplieruserForm.get(element.formControl);
					// 	ein.setValidators([Validators.minLength(9)]);
					// 	ein.updateValueAndValidity();
					// }
						else if (element.id == "ein") {
						let ein: any = this.supplieruserForm.get(element.formControl);
						// ADD: Validation for International Business with Canada
						if (this.custType == 'Corporation' || (this.custType == 'International_business' && this.countryVal == 'CA')) {
							ein.setValidators([Validators.required, Validators.minLength(9), Validators.maxLength(9)]);
						} else {
							ein.setValidators([Validators.required]);
						}
						// END ADD
						ein.updateValueAndValidity();
						}
					else {
						let other: any = this.supplieruserForm.get(element.formControl);
						other.setValidators([]);
						other.updateValueAndValidity();
					}
				}
				if (this.custType == 'Corporation') {
					this.Country = this.corporationLimitedCountry;
				}
				else {
					this.Country = this.internationalBusiCountry;
				}
			}
			else if (this.custType == 'Non_Profit') {
				if (element.id == "title" || element.id == "groupExmpt_number") {
					element.hide = false;
				}
				if (element.id == "businessName" || element.id == "ein") {
					this.supplieruserForm.get('ein').enable();
					if (element.id == "businessName") {
						element.label = "Legal Name";
						element.placeholder = "Legal Name"
					}
				}

				if (element.id == "businessName" || element.id == "ein" || element.id == "title" || element.id == "groupExmpt_number") {
					if (element.id == "ein") {
						let ein: any = this.supplieruserForm.get(element.formControl);
						// ein.setValidators([Validators.minLength(9)]);
						if (this.countryVal == 'US' || this.countryVal == 'CA') {
							ein.setValidators([Validators.minLength(9)]);
						} else {
							ein.setValidators([]);
						}
						ein.updateValueAndValidity();
					}
					else {
						let other: any = this.supplieruserForm.get(element.formControl);
						other.setValidators([]);
						other.updateValueAndValidity();
					}
				}
				this.Country = this.noneProfitCountry;
			}
			else if (this.custType == 'Sole_Proprietor') {
				if (element.id == "title" || element.id == "groupExmpt_number") {
					this.supplieruserForm.get('groupExmpt_number').setValue('');
					this.supplieruserForm.get('title').setValue('');
					element.hide = true;
				}
				else {
					element.hide = false;
				}
				if (element.id == 'ein' || element.id == 'businessName') {
					this.supplieruserForm.get('businessName').enable();
					this.supplieruserForm.get('ein').disable();
					this.supplieruserForm.get('ein').setValue('');
				}

				if (element.id == "businessName" || element.id == "ein" || element.id == "title" || element.id == "groupExmpt_number") {
					if (element.id == "businessName") {
						element.label = "Fictitious Business Name";
						element.placeholder = "Fictitious Business Name"
					}
					else {
						let other: any = this.supplieruserForm.get(element.formControl);
						other.setValidators([]);
						other.updateValueAndValidity();
					}
				}
				this.Country = this.solePropCountry;
			}
			if (this.custType !== 'International_business') {
				this.supplieruserForm.get('country').setValue('');
			}
		});
		if (this.custType == 'Corporation') {
			this.countryVal = "US";
			this.supplieruserForm.get('country').setValue('US');
			this.supplieruserForm.get('ein').setValue('');
			this.USA = true;
			this.Canada = false;
		}
		else {
			this.supplieruserForm.get('country').setValue('');
			this.supplieruserForm.get('ein').setValue('');
			this.USA = false;
		}
		if (this.custType !== 'Sole_Proprietor') {
			this.isAddChecked = false;
			this.isDisableAdd = true;
		}
	}

	taxeinID(evt: any) {
		if (this.custType == 'International_business') {
			// var regex = new RegExp("^[0-9a-zA-Z \b]+$");
			// var key = String.fromCharCode(!evt.charCode ? evt.which : evt.charCode);
			// if (!regex.test(key)) {
			// 	evt.preventDefault();
			// 	return false;
			// }
			return true;
		}
		else {
			var charCode = (evt.which) ? evt.which : evt.keyCode;
			if (charCode != 45 && charCode > 31 && (charCode < 48 || charCode > 57))
				return false;
			return true;
		}
	}

	specialNumber(event: any): boolean {
		const inputElement = event.target as HTMLInputElement;
		inputElement.value = inputElement.value.toUpperCase();
		if (this.Canada == true) {
			this.zipLength = 10;
			let Post: any = this.supplieruserForm.get("postal_code");
			Post.setValidators([Validators.minLength(0), Validators.maxLength(this.zipLength)]);
			Post.updateValueAndValidity();
			var regex = new RegExp("^[0-9a-zA-Z \b]+$");
			var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			if (!regex.test(key)) {
				event.preventDefault();
				return false;
			}
		}
		if (this.USA == true) {
			this.zipLength = 5;
			let Post: any = this.supplieruserForm.get("postal_code");
			Post.setValidators([Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
			Post.updateValueAndValidity();
			const charCode = (event.which) ? event.which : event.keyCode;
			if (charCode > 31 && (charCode < 48 || charCode > 57)) {
				return false;
			}
			return true;
		}
	}
	truncatenotification(subject: string, maxLength: number): string {
		return subject.length > maxLength ? subject.substring(0, maxLength) + '...' : subject;
	}

	ModalOPen() {
		const modal = document.getElementById('createmodal');
		if (modal) {
			$(modal).modal('hide');
			$('.modal-backdrop').remove();
		}
		// location.reload();
	}

	ngOnDestroy() {
		this.createmodal.nativeElement.click();
	}
}