import { Component, OnInit } from '@angular/core';
import { SuspendedServicesComponent } from '../suspended-services/suspended-services.component';
import { MatDialog } from '@angular/material/dialog';
import { UsermanagementService } from '../usermanagement.service';
import { Subscription } from 'rxjs';
import { AbstractControl, FormBuilder, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { TariffService } from 'src/app/tariff/tariff.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
	selector: 'app-suspended-user',
	templateUrl: './suspended-user.component.html',
	styleUrls: ['./suspended-user.component.css']
})
export class SuspendedUserComponent implements OnInit {
	featureServiceData: any;
	suspendedUserList: any;
	userlist: any;
	countUser: any;
	suspendedUsers: any = [];
	responseMessage: any = "";
	errMessage: any = "";
	private subscriptionName: Subscription
	filterUser: FormGroup;
	show_filter: boolean = false;
	preferenceServices: any = [];
	regTariffs: any = [];
	dropdownSetting: IDropdownSettings = {};
	dropdownSetting1: IDropdownSettings = {};
	dropdownSetting2: IDropdownSettings = {};
	closeDropdownSelection = true;
	public submitted: boolean = false;
	public buttonName: any = "Add";
	constructor(public data: UsermanagementService, public dialog: MatDialog, public fb: FormBuilder, public router: Router, private tariffService: TariffService) {
		this.subscriptionName = this.data.getUpdate().subscribe
			(message => {
				if (message.text) {
					this.ngOnInit();
				}
			});
	}

	ngOnInit(): void {
		this.data.getfeatureService().subscribe((res) => {
			this.featureServiceData = res.data;
		});
		this.getUsers();
		this.data.getSuspendedService().subscribe((res) => {
			this.suspendedUserList = res.data;
		});
		this.filterUser = this.fb.group({
			to_date: [''],
			from_date: [''],
			service: [''],
			regTariff: [''],
			idaccount: [null],
			onboarding: ['']
		});
		this.tariffService.getPreferenceService().subscribe(res => {
			this.preferenceServices = res.data;
			this.preferenceServices = res.data.map(item => ({
				preferid: item.idservice,
				preferenceServices: `${item.name}`
			}));
		}, err => {
			console.log(err.message);
		});

		// Get tariffs
		this.tariffService.getTariffs().subscribe(res => {
			this.regTariffs = res.data;
			this.regTariffs = res.data.map(item => ({
				regid: item.idtariff,
				regTariffs: `${item.name}`
			}));
		}, err => {
			console.log(err.message);
		});

		this.dropdownSetting = {
			singleSelection: true,
			idField: 'userdata',
			textField: 'displayName', // Use the new display name field
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSetting1 = {
			singleSelection: true,
			idField: 'regid',
			textField: 'regTariffs',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSetting2 = {
			singleSelection: true,
			idField: 'preferid',
			textField: 'preferenceServices',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};
	}

	getUsers(): void {
		this.data.getUsers('main').subscribe((res) => {
			this.userlist = res.data[0].filter((user) => user.is_deleted == 0);
			this.countUser = res.data[0];
			this.suspendedUsers = [];
			this.suspendedUserList.forEach((suspendedUser) => {
				const suspendSame = this.userlist.find((user) => user.idaccount === suspendedUser.idaccount);

				if (suspendSame) {
					const alreadyAdded = this.suspendedUsers.some((user) => user.idaccount === suspendSame.idaccount);
					if (!alreadyAdded) {
						const clonedUser = { ...suspendSame };
						clonedUser.userdata = clonedUser.idaccount;
						clonedUser.displayName = `${clonedUser.san} - ${clonedUser.first_name} ${clonedUser.last_name}`;
						this.suspendedUsers.push(clonedUser);
					}
				}
			});

			$('#basic-datatablessSus').dataTable().fnClearTable();
			$('#basic-datatablessSus').dataTable().fnDestroy();
			setTimeout(() => {
				$.getScript('./assets/table.js');
			}, 0);

		});
	}

	suspendedDialog(featureServiceData, idaccount): void {
		const dialogRef = this.dialog.open(SuspendedServicesComponent, {
			width: '50px',
			data: { serviceData: featureServiceData, idaccount: idaccount }
		});

		dialogRef.afterClosed().subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	showfilter() {
		this.show_filter = !this.show_filter;
	}

	applyUserFilter() {
		if (this.filterUser.invalid) {
			return
		}
		else {
			if (this.filterUser.value.to_date || this.filterUser.value.from_date ||
				(this.filterUser.value.service && this.filterUser.value.service.length > 0) || (this.filterUser.value.regTariff && this.filterUser.value.regTariff.length > 0) || (this.filterUser.value.idaccount && this.filterUser.value.idaccount.length > 0)) {
				const filterValues = Object.values(this.filterUser.value);
				const allFieldsEmpty = filterValues.every(value => value === "");
				this.data.UserFilter(JSON.stringify(this.filterUser.value)).subscribe((res) => {
					if (res.status == 201) {
						$('#basic-datatablessSus').dataTable().fnClearTable();
						$('#basic-datatablessSus').dataTable().fnDraw();
						$('#basic-datatablessSus').dataTable().fnDestroy();
						this.userlist = res.data;
						// this.suspendedUsers = [];
						this.suspendedUserList.forEach((suspendedUser) => {
							const suspendSame = this.userlist.find((user) => user.idaccount === suspendedUser.idaccount);
							if (suspendSame && suspendSame.is_deleted == 0) {
								this.suspendedUsers.push(suspendSame);
							}
						});
						$.getScript('./assets/table.js');
						if (allFieldsEmpty) {
							this.responseMessage = "";
							setTimeout(() => {
								this.responseMessage = "";
							}, 5000);
						}
						else {
							this.responseMessage = res.message;
							setTimeout(() => {
								this.responseMessage = "";
							}, 5000);
						}
					}
					else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});
			}
			else {
				this.errMessage = "Please Enter atleast 1 field!";
				setTimeout(() => {
					this.errMessage = "";
				}, 3000);
			}
		}
	}
	messageshow() {
		const from_date = this.filterUser.get('from_date').value;
		const to_date = this.filterUser.get('to_date').value;
		const currentDate = new Date();
		if ((!from_date && !to_date)) {
		} else if ((from_date == null || !from_date) && (to_date != null)) {
			this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((from_date != null) && (to_date == null || !to_date)) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		} else if (to_date && new Date(to_date) > currentDate) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
			return;
		} else if (from_date && new Date(from_date) > currentDate) {
			this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
			return;
		} else {
			this.filterUser.get('from_date').setErrors(null);
			this.filterUser.get('to_date').setErrors(null);
		}
	}

	// truncatenotification(subject: string, maxLength: number): string {
	// 	return subject.length > maxLength ? subject.substring(0, maxLength) + '...' : subject;
	//   }

	truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

	resetUserFilter() {
		this.filterUser.reset();
		this.router.navigate(['/user/user-details']);
		this.getUsers();
	}

}
