import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Socket } from "net";
//import { VoiceServer, UploadDirectory, Setting, GetRate } from "../config/setting.config";
import { VoiceServer, UploadDirectory, Setting, MicroservicesUrlandKey, SignalmashNumber, SignalmashUrl } from "../config/setting.config";
import { RawView } from "../lib/view/RawView";
import { VoiceRates } from "./common.lib";
import { setToZero, parseBody } from "./markError";
var request = require('request');
//const getRatE = new GetRate();
const vs_server = new VoiceServer();
const prefix = vs_server.Prefix;
const scriptUrl = new MicroservicesUrlandKey();
import { DIDSearchHMData } from '../server';
const smNumber = new SignalmashNumber();
const smApiUrl = new SignalmashUrl();
 
interface RecordType {
  [key: string]: any;
}

export class APIBase {
  constructor() {
  }

  public getLRN(lrn_detail: any): boolean {
    if (lrn_detail.hasOwnProperty('errors')) {
      if (lrn_detail.errors[0] == "LRN Not Found.") {
        return true;
      }
      else
        return false;
    }
    else
      return false;
  }

  public prorateCalculator(req: Request, res: Response, proration :any ,rates:any ,setup_cost:any , callback: (err: any, data: any) => void) {
    console.log("Prorate Data for Calculate :: ",{proration:proration,rates:rates,setup_cost:setup_cost});
  
    const parsedRates = parseFloat(rates);
    const parsedSetupCost = parseFloat(setup_cost);
    const errors = [
        isNaN(parsedRates) && "rates",
        isNaN(parsedSetupCost) && "setup cost"
    ].filter(Boolean) as string[]; 
    const errorMessage = errors.length > 0 ? errors.join(", ") : null;
    if (errorMessage) {
      let objv = new RawView(res);
      objv.prepare({ status: 506,  message: "Something went wrong with ["+errorMessage+"]"});
      objv.execute();
      return;
    }

    let dateObj = new Date();
    let day = dateObj.getUTCDate();
    let nDate: any = new Date()
    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
    let totalDays = (lDate - day) + 1;
    let prorate: any;
    if (proration == "true")
        prorate = ((totalDays * parseFloat(rates)) / lDate) + parseFloat(setup_cost);      
    else
        prorate = (parseFloat(rates)) + parseFloat(setup_cost);
      
    console.log("Final Prorate :: ",prorate);
    callback(1, setToZero(parseFloat(prorate).toFixed(3)))
  }

  public subscriptionProrationCalculator(req: Request, res: Response, idaccount:any, callback: (err: any, data: any, dataprorate:any) => void) {
 
    let obj = new ModelRawQuery(req, res);
    obj.qrysql = "SELECT sa.subscription_id, s.proration, s.mrc,s.quantity FROM subscription s JOIN subscription_account sa ON sa.subscription_id = s.subscription_id JOIN `account` ab ON sa.idaccount = ab.idaccount WHERE sa.idaccount = '"+idaccount+"' AND ab.subscription_payment = 0 AND sa.status=0;"
    obj.prepare();
    obj.execute((err, result) => {
    
      let totalProrate : any = 0;
      let errors: string[] = [];
      let dataprorate3:any=[];
      result.forEach((entry: any) => {
        const parsedRates = parseFloat(entry.mrc);
        const parsedQuantity = parseInt(entry.quantity);
        const prorateFlag = parseInt(entry.proration);
  
        if (isNaN(parsedRates)) errors.push("mrc");
        if (isNaN(parsedQuantity)) errors.push("quantity");
        if (isNaN(prorateFlag)) errors.push("proration");
        if (errors.length > 0) return;
        let dateObj = new Date();
        let day = dateObj.getUTCDate();
        let nDate: any = new Date();
        let lDate: any = new Date(nDate.getFullYear(), nDate.getMonth() + 1, 0).getDate();
        let totalDays = lDate - day + 1;
        let prorate;
        let prate:any=(parsedQuantity * parsedRates)
        if (entry.proration == "1") {
          prorate = (totalDays * prate) / lDate ;
         
        } else {
          prorate = prate 
     
        }
        dataprorate3.push({ subscription_id: entry.subscription_id, mrc: entry.mrc, quantity: entry.quantity, proration: entry.proration, prorate });
        totalProrate += prorate; 
      });
  
      if (errors.length > 0) {
        let objv = new RawView(res);
        objv.prepare({
          status: 506,
          message: "Something went wrong with [" + errors.join(", ") + "]",
        });
        objv.execute();
        return;
      }
  
      
      callback(1, setToZero(parseFloat(totalProrate).toFixed(3)), dataprorate3);
    });
  }

  // public prorateCalculatorwallet(req: Request,res: Response,mrc: any,proration: any,quantity: any,callback: (err: any, data: any) => void
  // ) {
   
  //   let totalProrate: any = 0;
  //   let errors: string[] = [];
  //   const parsedRates = parseFloat(mrc);
  //   const parsedQuantity = parseInt(quantity);
  //   const prorateFlag = parseInt(proration);
  //   if (isNaN(parsedRates)) errors.push("mrc");
  //   if (isNaN(parsedQuantity)) errors.push("quantity");
  //   if (isNaN(prorateFlag)) errors.push("proration");
  //   if (errors.length > 0) {
  //       let objv = new RawView(res);
  //       objv.prepare({
  //           status: 506,
  //           message: "Something went wrong with [" + errors.join(", ") + "]",
  //       });
  //       objv.execute();
  //       return;
  //   }
  //   let dateObj = new Date();
  //   let day = dateObj.getUTCDate();
  
  //   let nDate: any = new Date();
  //   let lDate: any = new Date(nDate.getFullYear(), nDate.getMonth() + 1, 0).getDate();
  //   let totalDays = lDate - day + 1;
  
  //   let prorate;
  //   let prate: any = (parsedQuantity * parsedRates);
  
  //   if (proration == "1") {
  //       prorate = (totalDays * prate) / lDate;
     
  //   } else {
  //       prorate = prate;
       
  //   }
  
  //   totalProrate = prorate;
  
   
  
  //   // Fix: toFixed() string deta hai, usko parseFloat se number banaya hai.
  //   callback(1, setToZero(parseFloat(totalProrate.toFixed(3))));
  // }

  public prorateCalculatorwallet(req: Request,res: Response, subscription_id:any,mrc: any,proration: any,quantity: any,callback: (err: any, data: any,dataprorate:any) => void
) {
  let totalProrate: any = 0;
  let errors: string[] = [];
  let dataprorate3:any=[];
  const parsedRates = parseFloat(mrc);
  const parsedQuantity = parseInt(quantity);
  const prorateFlag = parseInt(proration);
  if (isNaN(parsedRates)) errors.push("mrc");
  if (isNaN(parsedQuantity)) errors.push("quantity");
  if (isNaN(prorateFlag)) errors.push("proration");
  if (errors.length > 0) {
      let objv = new RawView(res);
      objv.prepare({
          status: 506,
          message: "Something went wrong with [" + errors.join(", ") + "]",
      });
      objv.execute();
      return;
  }
  let dateObj = new Date();
  let day = dateObj.getUTCDate();
  let nDate: any = new Date();
  let lDate: any = new Date(nDate.getFullYear(), nDate.getMonth() + 1, 0).getDate();
  let totalDays = lDate - day + 1;
  let prorate;
  let prate: any = (parsedQuantity * parsedRates);
  if (proration == "1") {
      prorate = (totalDays * prate) / lDate;
  } else {
      prorate = prate;
  }
  dataprorate3.push({ subscription_id: subscription_id, mrc:mrc, quantity: quantity, prorate });

  totalProrate = prorate;
  callback(1, setToZero(parseFloat(totalProrate.toFixed(2))),dataprorate3);
}

  public getLRNRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    let cat: any;
    if (category !== 'lrn' && category !== 'lrn_dnc') {
      return false;
    }
    if (category == 'lrn' || 'lrn_dnc') {
      cat = "lrn";
    }
    if (category == 'lrn_dnc') {
      cat = "lrn_dnc";
    }
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `rate` FROM `lookup_api_rates` WHERE `idtariff`='" + tariff + "'  AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
    obj1.prepare()
    obj1.execute((err, rates) => {
      if (err == 1) {
        let rt: any = [];
        rt = rates.length > 0 ? rates : [Object.assign({ rate: 0 }, rates[0])];
        callback(1, rt)
      }
      else {
        callback(0, "")
      }
    });
  }

  public getRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    let cat: any;
    if (category == 'TF' || category == 'NN') {
      cat = category == 'TF' ? "toll_free_number" : "local_number";
    }
    if (category == 'VN') {
      cat = category == 'VN' ? "vanity_number" : "";
    }
    if (category == '') {
      return false;
    }
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `final_rate` as `rate`, `billing_frequency` FROM `voice_rates` WHERE `idtariff`='" + tariff + "'  AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
    obj1.prepare()
    obj1.execute((err, rates) => {
       if (err == 1) {       
            let rate: any = rates[0].rate ;
            let rt: any = [];
            rt = rates.length > 0 ? [Object.assign({ rate: rate }, rates[0]),rates[0].billing_frequency] : [Object.assign({ rate: 0 }, rates[0].rate),rates[0].billing_frequency];
            callback(err, rt)
        } else {
            callback(err, '');
        }
    });
  }

  /* public getRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    if (!category) {
        return res.status(400).json({
            status: 400,
            message: 'Category is required',
        });
    }

    let cat: any;
    if (category == 'TF' || category == 'NN') {
      cat = category == 'TF' ? "toll_free_number" : "local_number";
    }
    if (category == 'VN') {
      cat = category == 'VN' ? "vanity_number" : "";
    }
    if (category == '') {
      return false;
    }

    const options = {
        method: 'GET',
        url: `${scriptUrl.RedisDAta}/getrate/${tariff}/${type}/${cat}`,  
        headers: {
            'Content-Type': 'application/json',
            Authorization: scriptUrl.KEY,  
        },
    };

    request(options, (error: any, response: any, body: any) => {
      if (error) {
        console.error('Request failed:', error);
        return res.status(500).json({
          status: 500,
          message: 'Request failed due to network error.',
          error: error.message,
        });
      }
  
      if (!response || response.statusCode !== 200) {
        console.error('Unexpected response status:', response?.statusCode);
        return res.status(response?.statusCode || 500).json({
          status: response?.statusCode || 500,
          message: 'Unexpected response from the server.',
        });
      }

      try {
        const data = JSON.parse(body);
        console.log("Helooooooo",data)
      
        if (data?.success) {
          let rate;
          let billingFrequency;
      
          if (typeof data.data?.report_data === 'string') {
            const reportData = JSON.parse(data.data.report_data);
            rate = reportData?.rate;
            billingFrequency = reportData?.billing_frequency;
          } else if (Array.isArray(data.data) && data.data.length > 0) {
            rate = data.data[0]?.rate;
            billingFrequency = data.data[0]?.billing_frequency;
          }
      
          if (rate !== undefined && billingFrequency !== undefined) {
            const result = [{ rate, billing_frequency: billingFrequency }, billingFrequency];
            return callback(1, result);
          } else {
            console.error('Rate or billing frequency not found in data');
            return res.status(500).json({
              status: 500,
              message: 'Rate or billing frequency not found in response data.',
            });
          }
        } else {
          console.error('API error:', data.message || 'Unknown error');
          return res.status(data.status || 500).json({
            status: data.status || 500,
            message: data.message || 'Unknown error occurred.',
          });
        }
      } catch (parseError: any) {
        console.error('Error parsing response body:', parseError);
        return res.status(500).json({
          status: 500,
          message: 'Error parsing response body.',
          error: parseError.message,
        });
      }      
    });
  }*/

  public checkBalance1(req: Request, res: Response, idaccount: number, Rate: number, callback: (err: any, data: any) => void) {
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + idaccount + "' AND `balance` + `credit_limit` >= '" + Rate + "'";
    obj1.prepare()
    obj1.execute((err, rates) => {
      if (err == 1 && rates.length > 0)
        callback(1, rates)
      else
        callback(0, "")
    });
  }

  public checkBalance(req: Request, res: Response, idaccount: number, Rate: number, callback: (err: any, data: any) => void) {
    if (Rate > 0) {
      let options: any = {
        'method': 'GET',
        'url': scriptUrl.BalanceCheckURL + '/wallet/getbalance/' + idaccount,
        'headers': {
          'Content-Type': 'application/json',
          'Authorization': scriptUrl.KEY
        },
      };
      request(options, (error: any, response: any, body: any) => {
        try {
          if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
            let data = JSON.parse(response.body);
            if (data.status == 200) {
              if (data) {
                if (data.data.totalBalance > Rate) {
                  callback(1, data);
                } else {
                  callback(0, '');
                }
              } else {
                this.checkBalance1(req, res, idaccount, Rate, callback);
              }
            } else {
              this.checkBalance1(req, res, idaccount, Rate, callback);
            }
          } else {
            this.checkBalance1(req, res, idaccount, Rate, callback);
          }
        } catch (e) {
          console.error("Error parsing response body:", e);
          this.checkBalance1(req, res, idaccount, Rate, callback);
        }
      });
    }
    else {
      if(Rate == 0){
        callback(1, '')
      }
      else{
        callback(0, '')
      }      
    }
  }

  public checkTwilioDID1(req: Request, res: Response, did: string, callback: (err: any, data: any) => void) {
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT TRIM(db.`did`) AS did, MAX(db.`order_id`) AS order_id, MAX(db.`camp_registry`) AS camp_registry, MAX(db.`account_id`) AS account_id, MAX(db.`provider`) AS provider, MAX(db.`sms_provider`) AS sms_provider, MAX(vs.`subaccount_sid`) AS subaccount_sid, MAX(ts.subaccount_sid) AS sub_username, MAX(ts.subaccount_secret) AS `sub_password` FROM did_buy db JOIN verified_sender vs ON vs.unique_request_id = db.camp_registry LEFT JOIN `twillio_subaccount` ts ON ts.sid=vs.subaccount_sid WHERE db.disconnect_did_status = '1' AND db.`provider`='twilio' AND db.sinch_status=1 AND TRIM(db.did) = "+did+" GROUP BY TRIM(db.did) LIMIT 1";
    obj1.prepare()
    obj1.execute((err, rates) => {
      if (err == 1) {
        if(rates.length > 0) {
          callback(1, rates[0])
        } else {
          callback(0, {status: 404, message: "Twilio DID Data Does Not Exist!"})
        }
      } else {
        callback(0, {status: 403, message: "Not able to find twilio data!"})
      }
    });
  }

  public checkTwilioDID(req: Request, res: Response, did: string, callback: (err: any, data: any) => void) {
    if (did) {
      let options: any = {
        'method': 'GET',
        'url': scriptUrl.TwilioDIDServiceURL + '/gettwiliodid/' + did,
        'headers': {
          'Content-Type': 'application/json',
          'Authorization': scriptUrl.KEY
        },
      };
      console.log("Twilio DID Check Option: ", options);
      request(options, (error: any, response: any, body: any) => {
        try {
          if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
            console.log("Twilio DID Check Response: ", response.body);
            
            let data = JSON.parse(response.body);
            if (data.status == 200) {
                callback(1, data.data);
            } else {
              this.checkTwilioDID1(req, res, did, callback);
            }
          } else {
            this.checkTwilioDID1(req, res, did, callback);
          }
        } catch (e) {
          console.error("Error parsing response body:", e);
          this.checkTwilioDID1(req, res, did, callback);
        }
      });
    }
    else {
      callback(0, {status: 404, message: "Twilio DID is not valid!"})
    }
  }
  
  public checkSwaggerBalance1(req: Request, res: Response, idaccount: number, callback: (err: any, data: any) => void) {
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT idaccount, IF(`balance`+`credit_limit`>0,1,0) isbalance, balance,(`balance`+`credit_limit`) `totalBalance` FROM wallet WHERE idaccount='" + idaccount + "' LIMIT 1";
    obj1.prepare()
    obj1.execute((err, rates) => {
      if (err == 1 && rates.length > 0)
        callback(1, rates[0])
      else
        callback(0, "")
    });
  }

  public checkSwaggerBalance(req: Request, res: Response, idaccount: number, callback: (err: any, data: any) => void) {
    if (idaccount) {
      let options: any = {
        'method': 'GET',
        'url': scriptUrl.BalanceCheckURL + '/wallet/getbalance/' + idaccount,
        'headers': {
          'Content-Type': 'application/json',
          'Authorization': scriptUrl.KEY
        },
      };
      request(options, (error: any, response: any, body: any) => {
        try {
          if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
            let data = JSON.parse(response.body);
            if (data.status == 200) {
              if (data) {
                  callback(1, data.data);
              } else {
                this.checkSwaggerBalance1(req, res, idaccount, callback);
              }
            } else {
              this.checkSwaggerBalance1(req, res, idaccount, callback);
            }
          } else {
            this.checkSwaggerBalance1(req, res, idaccount, callback);
          }
        } catch (e) {
          console.error("Error : checkSwaggerBalance1 ::", e);
          this.checkSwaggerBalance1(req, res, idaccount, callback);
        }
      });
    }
    else {
      callback(1, '')
    }
  }

  public checkLergInfoDetail1(req: Request, res: Response, npa: number, nxx: number, callback: (err: any, data: any) => void) {
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`, `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`=" + npa + " AND `nxx`=" + nxx + "";
    obj1.prepare()
    obj1.execute((err, data) => {
      if (err == 1 && data.length > 0)
        callback(1, data[0])
      else
        callback(0, "")
    });
  }

  public checkLergInfoDetail(req: Request, res: Response, npa: number, nxx: number, callback: (err: any, data: any) => void) {
    if (npa && nxx) {
      let options: any = {
        'method': 'GET',
        'url': scriptUrl.LergInfoDetailURL + '/getLergeInfoDetail/'+npa+'/'+nxx,
        'headers': {
          'Content-Type': 'application/json',
          'Authorization': scriptUrl.KEY
        },
      };
      request(options, (error: any, response: any, body: any) => {
        try {
          if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
            let data = JSON.parse(response.body);
            if (data.status == 200) {
              if (data.data) {
                callback(1, data.data);
              } else {
                this.checkLergInfoDetail1(req, res, npa, nxx, callback);
              }
            } else {
              this.checkLergInfoDetail1(req, res, npa, nxx, callback);
            }
          } else {
            this.checkLergInfoDetail1(req, res, npa, nxx, callback);
          }
        } catch (e) {
          console.error("Error parsing response body->checkLergInfoDetail:", e);
          this.checkLergInfoDetail1(req, res, npa, nxx, callback);
        }
      });
    }
    else {
      callback(0, '')
    }
  }

  public getMessageRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    let cat: any;
    if (category == 'NN') {
      cat = "local_number";
    }
    if (category == 'TF') {
      cat = "toll_free_number";
    }
    if (category == '') {
      return false;
    }
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `nrc`, `mrc` FROM `message_activation_pricing` WHERE `idtariff`='" + tariff + "'  AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
    obj1.prepare()
    obj1.execute((err, rates) => {
      if (err == 1) {
        let rt: any = [];
        rt = rates.length > 0 ? rates : [Object.assign({ nrc: 0, mrc: 0 }, rates[0])];
        callback(err, rt)
      }
      else {
        callback(err, "")
      }
    });
  }

  public checkNumberType(did: any, callback: (err: any, data: any) => void) {
    let len = did.length - 10;
    let npa = did.slice(len, len + 3);
    let type: any = ''
    if ((npa == "800" || npa == "822" || npa == "833" || npa == "844" || npa == "855" || npa == "866" || npa == "877" || npa == "888")) {
      console.log("Number Type is Toll-free ", did);
      type = 'toll_free'
      callback(0, { message: "Number Type is Toll-free!", data: type })
    }
    else if (did.length == 10) {
      console.log("Number Type is Local Number ", did);
      type = '10_dlc'
      callback(1, { message: "Number Type is Local Number!", data: type })
    }
    else {
      console.log("Number Type is Short-Code ", did);
      type = 'short_code'
      callback(2, { message: "Number Type is Short-Code!", data: type })
    }
  }
  public checkSCType(req: Request, res: Response, did: any, callback: (err: any, data: any) => void) {
    if(!did){
      return callback(0, { status: 403, message: "Invalid Shortcode!" });
    }
    const obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT scp.migrated_campaign FROM did_buy db LEFT JOIN sc_request sr ON db.camp_registry = sr.sc_campaign_unique_id LEFT JOIN sc_campaign_profile scp ON sr.profile_id = scp.id_profile WHERE db.did = "+did+" AND db.sinch_status=1 AND db.disconnect_did_status=1 GROUP BY db.did;";
    obj1.prepare();
    obj1.execute((err, sctype) => {

        if (err !==1) {
            return callback(0, { status: 500, message: "Something went wrong with Shortcode detail!" });
        }

        if (!sctype || sctype.length === 0) {
            return callback(0, { status: 405, message: "Shortcode data not found!" });
        }

        let type: string | null = '', iSCType = 1, trfSCType = "short_code";
        switch (sctype[0].migrated_campaign) {
            case 1: type = "ShortCode"; iSCType = 1; trfSCType = "short_code"
                break;
            case 2: type = "FreeToEndUserShortCode"; iSCType = 2; trfSCType = "free_to_end_user"
                break;
            default: type = "ShortCode";  iSCType = 1; trfSCType = "short_code";
        }
        console.log("SC Type : "+ type + "iType : "+ iSCType);
        return callback(1, {scType:type, intSCType:iSCType, trfSCType:trfSCType});
    });
  }


  public getTollfreeSMSRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    let cat: any;
    if (category == 'toll_free') {
      cat = "toll_free";
    }
    if (category == 'short_code') {
      cat = "short_code";
    }
    if (category == '') {
      return false;
    }
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `MT_rates` FROM `sms_rate` WHERE `id_tariff`='" + tariff + "'  AND `category`='" + cat + "' AND `subcategory`='" + type + "' LIMIT 1";
    obj1.prepare()
    obj1.execute((err, rates) => {
      if (err == 1) {
        let rt: any = [];
        rt = rates.length > 0 ? rates : [Object.assign({ MO_rates: 0 }, rates[0])];
        callback(err, rt)
      }
      else {
        callback(err, "")
      }
    });
  }

  public saveHmp(timekey:any, provider:any, data:any){
    let existingArray = DIDSearchHMData.get(timekey);
    if (!existingArray) {
        existingArray = []; // Initialize if the key does not exist
    }
    let key = timekey+'_'+provider;
    let obj = {
      [key]: data
    };
    existingArray.push(obj);
    DIDSearchHMData.set(timekey, existingArray);
    // return DIDSearchHMData;
  }

  public shuffleArray<T>(array: T[]): T[] {
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]];
    }
    return array;
  }

  public getSearchedDID(prodata:any,qty:number){
    const allRecords: RecordType[] = [];
    for (const obj of prodata) {
        const key = Object.keys(obj)[0];
        const records = obj[key];
        allRecords.push(...records);
    }
    const shuffledRecords = this.shuffleArray(allRecords);
    const result = shuffledRecords.slice(0, qty);
    return result;

  }

  public getCampaignRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
    let obj = new ModelRawQuery(req, res);
    obj.qrysql = "SELECT `rate`,`mrc` FROM `campaign_rates` WHERE `idtariff`='" + tariff + "' AND `type`='" + type + "'  AND `category`='" + category + "' LIMIT 1";
    obj.prepare();
    obj.execute((err, rates) => {
      if (err == 1) {
        let rt: any = [];
        rt = rates.length > 0 ? rates : [Object.assign({ rate: 0 }, rates[0])];
        callback(err, rt)
      }
      else {
        callback(err, "")
      }
    });
  }

  public getRateCenter(req: Request, res: Response, npa: any, nxx: any, callback: (err: any, data: any) => void) {
    let obj = new ModelRawQuery(req, res);
    obj.qrysql = "SELECT `rc_abbre`, `loc_state` FROM `did_location_info` WHERE `npa`='" + npa + "'  AND `nxx`='" + nxx + "'";
    obj.prepare();
    obj.execute((err, ratecenter_state) => {
      if (ratecenter_state.length > 0) {
        callback('', ratecenter_state)
      } else {
        callback(err, '')
      }
    });
  }

  public getLrnDetails(req: Request, res: Response, did: any, callback: (err: any, data: any) => void) {
    did = "" + did + "";
    let len = did.length - 10;
    let number = did.slice(len, did.length);
    let npa = number.slice(0, 3);
    let nxx = number.slice(3, 6);
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT *  FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
    obj1.prepare()
    obj1.execute((err, lrn_details) => {
      if (lrn_details.length > 0) {
        let lrn_result = Object.assign({ lrn: number }, lrn_details[0]);
        callback('', [lrn_result])
      } else {
        callback(err, '')
      }
    });
  }
  
  public getApiRate(req: Request, res: Response, idaccount: any, req_type:any, callback: (err: any, data: any) => void) {
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT req_hits, rate_limit, req_type FROM `api_rate_limit` WHERE req_type = "+req_type+" AND `idaccount` = " + idaccount + " AND `type`=2 AND req_hits < rate_limit";
    obj1.prepare()
    obj1.execute((err, resp) => {
      if (err == 1) {
        if (resp.length > 0) {
            callback(1, {status: 200, message: "Request Allowed." });
        }
        else {
          callback(0, {status: 429, message: 'Too Many Requests. You have exceeded the request limit. Please try again later.' });
        }
      }
      else {
        callback(0, {status: 502, message: "Something went wrong with Request!" })
      }
    });
  }

  public calculateNextBillingDate(req: Request, res: Response, billf: any, callback: (err: any, data: any) => void){
    let calculatedDate;
    const currentDate = new Date();
    // const currentDay = currentDate.getUTCDate() + 5; 
    const currentDay = currentDate.getUTCDate(); 
    console.log("Current Day:", currentDay);
    console.log("Billing Frequency:", billf);
    let billingfreq = parseFloat(billf);
    if (billingfreq === 0) {
        
      calculatedDate = new Date(Date.UTC(currentDate.getUTCFullYear(), currentDate.getUTCMonth() + 1, 1));
    } else if (billingfreq === 1 || billingfreq === 2 || billingfreq === 3) {
      // Billing Frequency 1, 2, 3: Calculate based on the anniversary date
      const monthsToAdd = billingfreq === 1 ? 3 : billingfreq === 2 ? 6 : 12; // Define months to add
    
      // Calculate the target month and year
      let targetMonth:any = currentDate.getUTCMonth() + monthsToAdd;
      let targetYear:any = currentDate.getUTCFullYear();    
      if (targetMonth > 11) {
        targetMonth -= 12;
        targetYear += 1;
      }
    
      const maxDaysInTargetMonth = new Date(Date.UTC(targetYear, targetMonth + 1, 0)).getUTCDate();
    
      const adjustedDay:any = Math.min(currentDay, maxDaysInTargetMonth);
    
      calculatedDate = new Date(Date.UTC(targetYear, targetMonth, adjustedDay));
    
      console.log("Next Date Before Adjustment:", calculatedDate);
    
      // If the currentDay is 29, 30, or 31 and exceeds the max days, default to the 28th
      console.log("currentDay :: ",currentDay)
      console.log("maxDaysInTargetMonth :: ",maxDaysInTargetMonth)
      if (currentDay > maxDaysInTargetMonth || currentDay >= 29) {
        calculatedDate = new Date(Date.UTC(targetYear, targetMonth, 28));
      }
    } else {
      callback(0, {status:404, message:"Invalid billing frequency"});
      return;
    }
    
    let formattedDate = calculatedDate ? calculatedDate.toISOString().slice(0, 19).replace('T', ' ') : null;
    console.log("Formatted Date ::", formattedDate);
    callback(1, formattedDate)
    return;
  }


  public updateApiRate(req: Request, res: Response, idaccount: any, req_type:any, callback: (err: any, data: any) => void) {
      let objj = new ModelRawNonQuery(req, res);
      objj.nonqrysql = "UPDATE `api_rate_limit` SET `req_hits`=`req_hits`+1 WHERE req_type = "+req_type+" AND `type`=2 AND  `idaccount` = " + idaccount + "";
      objj.prepare();
      objj.execute((err1, resp1) => {
          console.log("Request Hits Updated");
      });
  }
  
  public serviceActivation1(req: Request, res: Response, idaccount: number, fservice_id: any, callback: (err: any, data: any) => void) {
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT fs_id, idaccount, as_status FROM `account_service`  WHERE `idaccount` = " + idaccount + " AND as_status ='1' AND fs_id=" + fservice_id + "";
    obj1.prepare()
    obj1.execute((_err, resp) => {
      if (_err == 1) {
        if (resp.length > 0) {
          callback(1, { data: resp, message: "::SN:: service is activated", status: 200 });
        }
        else {
          callback(0, { data: resp, message: "::SN:: service has been suspended. More information please contact support", status: 501 });
        }
      }
      else {
        callback(0, { message: "Something went wrong with ::SN:: service activation", status: 502 })
      }
    });
  }

  public serviceActivation(req: Request, res: Response, sessdata: any, fservice_id: any, callback: (err: any, data: any) => void) {
    let options: any = {
      'method': 'GET',
      // 'url': 'http://localhost:3001/getService/' + sessdata.idaccount +'/'+ fservice_id,
      'url': scriptUrl.ServiceActivationURL + '/getService/' + sessdata.idaccount + '/' + fservice_id,
      'headers': {
        'Content-Type': 'application/json',
        'Authorization': scriptUrl.KEY
      },
    };
    request(options, (error: any, response: any, body: any) => {
      try {       
        if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) { 
          let data = JSON.parse(response.body);
          if (data) {
            if (data.status == 200) {
              if (data.data.fs_id = parseInt(fservice_id) && data.data.as_status == 1) {
                callback(1, data);
              } 
              else {
                callback(0, {status: 501, message: "::SN:: service has been suspended. More information please contact support"});
              }              
            } else if(data.status==502){
              callback(0, { message: data.message, status: 501 });
            }
            else {
              this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
            }
          } 
          else {
            this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
          }
        } 
        else {
          this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
        }
      } catch (e) {
        console.error("Error serviceActivation :: ", e);
        this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
      }
    });
  }

  public getMasterSlave(req: Request, res: Response, sessdata: any, idactoridusr: any, type: any, callback: (err: any, data: any) => void) {
    let iduser: any, idaccount: any, con: any = '', condition: any='';
    if (type == 2) {
      idaccount = idactoridusr;
      con = '`master_idaccount` = ' + idactoridusr;
    } else {
      iduser = idactoridusr;
      con = '`master_iduser` = ' + idactoridusr;
    }
    let obj0 = new ModelRawQuery(req, res);
    obj0.qrysql = "SELECT `master_iduser`,`slave_iduser`, `master_idaccount` , `slave_idaccount` FROM `customer_group_mapping` WHERE " + con + " AND `cm_status` = '0'";
    obj0.prepare();
    obj0.execute((err: any, cmRes: any) => {
      if (err == 1) {
        if (type == 22 || type == 1) {
          if (cmRes.length > 0) {
            let masterIduser = cmRes.map((row: any) => row.slave_iduser);
            masterIduser.push(iduser);
            condition += '`iduser` IN(' + masterIduser.join(',') + ')';
          }
          else {
            condition += '`iduser`= ' + iduser + '';
          }
        }
        else if (type == 2) {
          if (cmRes.length > 0) {
            let masterIdaccount = cmRes.map((row: any) => row.slave_idaccount);
            masterIdaccount.push(idaccount);
            condition += '`idaccount` IN(' + masterIdaccount.join(',') + ')';
          }
          else {
            condition += '`idaccount`= ' + idaccount + '';
          }
        }
        else {
          callback(1, { status: 501, message: "Customer does not exist during ::MG::" })
        }
        callback(1, { status: 200, message: "Group Found Successfully during ::MG:: ", condition: condition })
      }
      else {
        callback(0, { status: 502, message: "Something went wrong with finding detail during ::MG::" })
      }
    })
  }
  generateInsertQuery(payload: Record<string, any>, funDetail:any) {
    if (!payload || Object.keys(payload).length === 0) {
      console.log({ status: 504, message: "Payload is empty for "+ funDetail.logName + ' from function '+  funDetail.functionName});
      return '';
    }
    else{
      const setQuery = Object.entries(payload).map(([key, value]) => {
        switch (typeof value) {
          case "string":
            return `\`${key}\` = '${parseBody(value)}'`;
  
          case "number":
            return `\`${key}\` = '${setToZero(value)}'`;
  
          case "boolean":
            return `\`${key}\` = '${value ? 'true' : 'false'}'`;
  
          case "object":
            return value === null ? `\`${key}\` = ''` : `\`${key}\` = '${JSON.stringify(value)}'`;
  
          case "undefined":
          default:
            return `\`${key}\` = ''`; 
        }
      }).join(", ");
  
      return `INSERT INTO \`${funDetail.tableName}\` SET ${setQuery};`;
    }    
  }
  insertLog(req: Request, res: Response, payload: Record<string, any>, callback: (err: any, data: any) => void) {
    console.log("The " +payload.funDetail.logName +" Log is generating for ", payload.funDetail.functionName); 
    if (payload.data && Object.keys(payload.data).length > 0) {
      if (!payload.data || Object.keys(payload.data).length === 0) {
        console.log({ status: 504, message: payload.funDetail.logName +" Log Data Not Available" });
        return;
      }
      try {
        let obj = new ModelRawNonQuery(req, res); 
        let qry = this.generateInsertQuery(payload.data, payload.funDetail);
        if(qry){
        obj.nonqrysql = qry;
        console.log("Generated Query:", obj.nonqrysql);    
        obj.prepare();
        obj.execute((error: any, result: any) => {
          if (error == 1) {
            console.log({ status: 200, message: payload.funDetail.logName +" Log Inserted for function " + payload.funDetail.functionName });
            callback(1, error);
          } else {
            callback(0, result);
            console.log({ status: 502, message: payload.funDetail.logName +" Log Not Inserted for function " + payload.funDetail.functionName });
          }
        });
        }
        else{
        console.log({ status: 506, message: payload.funDetail.logName +" Log Query Not created for function " + payload.funDetail.functionName });
        }        
      } catch (err:any) {
        console.error(payload.funDetail.functionName  + " =:> Error generating query for :", payload.funDetail.logName, "Log =>", err.message);
      }
    }
  }

    generateInsertQuery1(payload: Record<string, any>, funDetail: any, whereConn: any) {
    if (!payload || Object.keys(payload).length === 0) {
      console.log({
        status: 504,
        message: `Payload is empty for ${funDetail.logName} from function ${funDetail.functionName}`
      });
      return '';
    }
  
    const setQuery = Object.entries(payload)
      .map(([key, value]) => {
        switch (typeof value) {
         case "string":
            return (
              funDetail.functionName === 'updatePaymentSetting' ||
              funDetail.functionName === 'onBoardcreateCard' ||
              funDetail.functionName === 'setDfaultCard' ||
              funDetail.functionName === 'createCustomerCard'
            )
              ? `\`${key}\` = '${parseBody(value)}'`
              : `\`${key}\` = ${parseBody(value)}`;
              
          case "number":
            return `\`${key}\` = '${setToZero(value)}'`;
  
          case "boolean":
            return `\`${key}\` = '${value ? 'true' : 'false'}'`;
  
          case "object":
            return value === null ? `\`${key}\` = ''` : `\`${key}\` = '${JSON.stringify(value)}'`;
  
          case "undefined":
          default:
            return `\`${key}\` = ''`;
        }
      })
      .join(", ");
  
    let whereQuery = "";
    if (whereConn && Object.keys(whereConn).length > 0) {
      whereQuery =
        " WHERE " +
        Object.entries(whereConn)
          .map(([key, value]) => `\`${key}\` = '${value}'`)
          .join(" AND ");
    }
  
    return `UPDATE \`${funDetail.tableName}\` SET ${setQuery}${whereQuery};`;
  }
  
  insertLog1(req: Request, res: Response, payload: Record<string, any>, callback: (err: any, data: any) => void) {
    console.log("The " +payload.funDetail.logName +" Log is generating for ", payload.funDetail.functionName); 
    if (payload.data && Object.keys(payload.data).length > 0) {
      if (!payload.data || Object.keys(payload.data).length === 0) {
        console.log({ status: 504, message: payload.funDetail.logName +" Log Data Not Available" });
        return;
      }
      try {
        let obj = new ModelRawNonQuery(req, res); 
        let qry = this.generateInsertQuery1(payload.data, payload.funDetail,payload.connWhere);
        if(qry){
        obj.nonqrysql = qry;
        console.log("Generated Query:", obj.nonqrysql);    
        obj.prepare();
        obj.execute((error: any, result: any) => {
          if (error == 1) {
            console.log({ status: 200, message: payload.funDetail.logName +" Log Inserted for function " + payload.funDetail.functionName });
            callback(1, error);
          } else {
            callback(0, result);
            console.log({ status: 502, message: payload.funDetail.logName +" Log Not Inserted for function " + payload.funDetail.functionName });
          }
        });
        }
        else{
        console.log({ status: 506, message: payload.funDetail.logName +" Log Query Not created for function " + payload.funDetail.functionName });
        }        
      } catch (err:any) {
        console.error(payload.funDetail.functionName  + " =:> Error generating query for :", payload.funDetail.logName, "Log =>", err.message);
      }
    }
  }


  walletRechargeLog(req: Request, res: Response, payload: Record<string, any>, status: number, type:any, callback: (err: any, data: any) => void){
    let obj1 = new ModelRawNonQuery(req, res);
    obj1.nonqrysql = "INSERT INTO `wallet_recharge_log` (`idaccount`,`amount`,`purpose`,`status`) VALUES ('" + payload.idaccount + "', '" + type + payload.amount + "', '" + payload.purpose + "', '" + status + "')";
    obj1.prepare();
    obj1.execute((error1: any, result1: any) => {
      if (error1 == 1) {
        callback(1, { message: payload.purpose,  status: 200 }); 
      }
      else{
        callback(0, { message: payload.purpose, status: 501 });
      }
    });
  }
  walletDeduction(req: Request, res: Response, payload: Record<string, any>, callback: (err: any, data: any) => void){
    if(payload.amount > 0){
      let obj = new ModelRawNonQuery(req, res);
      obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + payload.amount + " WHERE `idaccount` = '" + payload.idaccount + "'";
      obj.prepare();
      obj.execute((error: any, result: any) => {
        if (error == 1) {
          callback(1, {}); 
          payload.purpose = "Wallet amount successfully updated for " + payload.purpose;
          this.walletRechargeLog(req, res, payload, 1, '-', (err: any, data: any) => { });
        }
        else{
          callback(0, {}); 
          payload.purpose = "Wallet amount not deducted for " + payload.purpose;
          this.walletRechargeLog(req, res, payload, 2, '-', (err: any, data: any) => {
            callback(err, {}); 
          });
        }
      });
    }
    else{
      callback(0, {}); 
      payload.purpose = "Wallet amount not deducted for " + payload.purpose + " due to amount " + payload.amount
      this.walletRechargeLog(req, res, payload, 3, '-', (err: any, data: any) => {});
    }
  }
  walletDeductionWithoutLog(req: Request, res: Response, payload: Record<string, any>, callback: (err: any, data: any) => void){
    if(payload.amount > 0){
      let obj = new ModelRawNonQuery(req, res);
      obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + payload.amount + " WHERE `idaccount` = '" + payload.idaccount + "'";
      obj.prepare();
      obj.execute((error: any, result: any) => {
        if (error == 1) {
          callback(1, {}); 
        }
        else{
          callback(0, {}); 
        }
      });
    }
    else{
      callback(0, {}); 
    }
  }


  deleteSipBcidtData(req: Request, res: Response, otherPayLoad: any, callback: (err: any, data: any) => void) {
    let obj1 = new ModelRawQuery(req, res);
     obj1.qrysql = "SELECT `did`,`idbcidoverride` FROM `sip_bcid_override` WHERE `did` IN(" + otherPayLoad.did + ") AND idaccount='" + otherPayLoad.idaccount + "'";
    obj1.prepare();
    obj1.execute((error: any, result: any) => {
      if (error == 1) {
        if (result.length > 0) {
           let Ids: any = [];
           for (let x of result) {
               Ids.push(x.idbcidoverride)
            }
          if(Ids.length > 0){
            let obj2 = new ModelRawNonQuery(req, res);
            obj2.nonqrysql = "DELETE FROM `sip_bcid_override` WHERE `idbcidoverride` IN(" + Ids + ")";
            obj2.prepare();
            obj2.execute((error1: any, result1: any) => {
              if (error1 == 1) {
                callback(1, { data: result1, message: "BCID DID Deleted Successfully", status: 201 });
              } else {
                callback(0, { message: "Something went wrong with delete", status: 501 })
              }
           });
          }          
          else{
            callback(0, { message: "No record to delete!", status: 501 })
          }
        } else {
          callback(0, { message: "No record found!", status: 502 })
        }
      } else {
        callback(0, { message: "Something went wrong with get data", status: 503 })
      }
    })
  }
 
  getPreFixnIp1(req: Request, res: Response, from:any, to: any, callback: (err: any, data: any) => void) {  
    let obj1 = new ModelRawQuery(req, res);
     obj1.qrysql = "SELECT `sip_override_prefix`, `sip_override_ip` FROM `sip_bcid_override` WHERE TRIM(`did`)="+from+"";
    obj1.prepare();
    obj1.execute((error: any, result: any) => {
      if (error == 1) {
        if (result.length > 0) {
          /* // sofia/internal/prefix+number@ip */
          console.log({ status : 200, data: "sofia/internal/" + result[0].sip_override_prefix + to.trim()+"@"+result[0].sip_override_ip});
          
          callback(1, { status : 200, data: "sofia/internal/" + result[0].sip_override_prefix + to.trim()+"@"+result[0].sip_override_ip});
        } else {
          /* // sofia/gateway/iplink/+prefix+number */
          console.log({ status : 201,  data: "sofia/gateway/iplink/" + prefix + to.trim()});
          
          callback(1, { status : 201,  data: "sofia/gateway/iplink/" + prefix + to.trim()})
        }
      } else {
        callback(0, { status : 503, message: "Something went wrong with get Prefix and IP" })
      }
    })
  }
  public getPreFixnIp(req: Request, res: Response, from: any, to:any, callback: (err: any, data: any) => void) {
    if (from) {
      let options: any = {
        'method': 'GET',
        'url': scriptUrl.BCIDServiceURL + '/getbciddid/' + from,
        'headers': {
          'Content-Type': 'application/json',
          'Authorization': scriptUrl.KEY
        },
      };
      request(options, (error: any, response: any, body: any) => {
        try {
          if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
            let data = JSON.parse(response.body);
            console.log("getPreFixnIp data ::=> ", data);
            if (data.status == 200) {
              callback(1, {status : 200, data: "sofia/internal/" + data.sip_override_prefix + to+"@"+data.sip_override_ip});
            } else if(data.status == 404){
              callback(1, {status : 201, data: "sofia/gateway/iplink/" + prefix + to})
            } else {
              this.getPreFixnIp1(req, res, from, to, callback);
            }
          }
          else {
            this.getPreFixnIp1(req, res, from, to, callback);
          }
        } catch (e) {
          console.error("getPreFixnIp Error parsing response body ::=> ", e);
          this.getPreFixnIp1(req, res, from, to, callback);
        }
      });
    }
    else {
      callback(0, { status : 404, message: "Number is not provided!" })
    }
  }
  public DialCall(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    this.getPreFixnIp(req, res, req.body.CALLER.trim(), req.body.CALLEE.trim(), (erroR, resulT) => {
      if (erroR == 1) {
        let socketData = '{caller_id_number=' + req.body.CALLER.trim() + ',dialed_number=' + req.body.CALLEE.trim() + ',effective_caller_id_name=' + req.body.CALLER.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + setToZero(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_to=' + vrate.getCallRate(req.body.CALLER) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',ctype=4,ocn=' + lerg_data[0].ocn + ',category=' + lerg_data[0].category + ',mobility=' + lerg_data[0].co_name_spec_c + ',effective_caller_id_number=' + req.body.CALLER.trim() + ',origination_caller_id_name=' + req.body.CALLER.trim() + ',origination_caller_id_number=' + req.body.CALLER.trim() + '}'+ resulT.data + ' &bridge({caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.CALLEE.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',effective_caller_id_number=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + setToZero(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',ctype=4,rec_rate=' + vrate.RecordRate(req.body.Recording) + ',lata=' + lerg_data[0].lata + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}' + resulT.data + ')'
        console.log("socketData :: ",socketData)
        let client = new Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
          client.write('auth ' + vs_server.PASS + '\n\n');;
          client.write('api originate ' + socketData + '\n\n');
          client.on("data", (respon) => {
            try{
              let tmp = respon.toString().split("\n");
              tmp.forEach((elem: any) => {
                if (elem != undefined) {
                  if (elem.length > 0) {
                    let t1 = elem.split("OK");
                    if (t1.length == 2) {
                      /* if (t1[0] == "+") { */
                      if (t1[0] == "Reply-Text: +") {
                        res.send({ status: 201, message: "Call connected successfully", uuid: t1[1].trim() });
                      }
                    }
                    let t2 = elem.split("ERR");
                    if (t2.length == 2) {
                      res.send({ status: 404, message: t2[1].trim() });
                      client.end();
                    }
                  }
                }
              });
            }catch(e){
              console.log("Error in DialCall", e);
              res.status(503).send({ message: "Call not Connected" });
            }            
          });

          client.on("error", (e) => {
          })
          client.on("end", (err: any) => {
          })
        });
      } else {
          res.send(resulT);
      }
    });    
  }


  public makeCall(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    this.getPreFixnIp(req, res, req.body.FROM.trim(), req.body.TO.trim(), (erroR, resulT) => {
      if (erroR == 1) {
        let socketData = '{caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.TO.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',effective_caller_id_number=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + setToZero(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}user/' + req.body.Extension.trim() + ' &bridge({caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.TO.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + setToZero(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_to=' + vrate.getCallRate(req.body.TO) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',ocn=' + lerg_data[0].ocn + ',category=' + lerg_data[0].category + ',mobility=' + lerg_data[0].co_name_spec_c + ',effective_caller_id_number=' + req.body.FROM.trim() + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}'+ resulT.data + ')';
        console.log("makeCall socketData :: ",socketData);
        
        let client = new Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
          console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
          client.write('auth ' + vs_server.PASS + '\n\n');
          console.log("Password : " + vs_server.PASS);
          console.log(socketData);
          client.write('api originate ' + socketData + '\n\n');
          client.on("data", (respon) => { 
            try{
              let tmp = respon.toString().split("\n");
              tmp.forEach((elem: any) => {
                if (elem != undefined) {
                  if (elem.length > 0) {
                    console.log(elem);
                    let t1 = elem.split("OK");
                    if (t1.length == 2) {
                      console.log(t1);
                      /* if (t1[0] == "+") { */
                      if (t1[0] == "Reply-Text: +") {
                        res.status(200).send({ message: "Call Connected Successfully", uuid: t1[1].trim() });
  
                      }
                    }
                  }
                }
              });
            }catch(e){
              console.log("Error in makeCall", e);
              res.status(503).send({ message: "Call not Connected" });
            }
          });

          client.on("error", (e) => {
            console.log(e);
          })

          client.on("end", () => {

          })
        });
         } else {
          res.send(resulT);
      }
    });
  }

  public makeCallviaMedia(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    let sdata: any = req.body;
    this.getPreFixnIp(req, res, req.body.FROM, req.body.TO, (erroR, resulT) => {
      if (erroR == 1) {
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `uploaded_file`,`iduser` FROM `upload_media` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "' AND `media_id`='" + sdata.mediaID + "'";
        obj.prepare();
        obj.execute((err, result) => {
          if (result.length > 0) {
            let dir = new UploadDirectory();
            let mediapath: any = dir.FREESWITCHUPLOAD + result[0].uploaded_file;
            let vz = new VoiceRates();
            vz.getZone(req, res, lerg_data[0].lrn, (errr: any, zone: any) => {
              let socketData = '{caller_id_number=' + req.body.FROM + ',dialed_number=' + req.body.TO + ',effective_caller_id_name=' + req.body.FROM + ',effective_caller_id_number=' + req.body.FROM + ',iduser=' + sessdata.iduser + ',idapi=' + setToZero(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_to=' + vrate.getCallRates(lerg_data[0].lrn, zone) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',ctype=4,rec_rate=' + vrate.RecordRate(req.body.Recording) + ',lata=' + lerg_data[0].lata + ',origination_caller_id_name=' + req.body.FROM + ',origination_caller_id_number=' + req.body.FROM + ',ignore_early_media=true}' + resulT.data + ' &playback(' + mediapath + ')';
              console.log("makeCallviaMedia socketData :: ", socketData);
              let client = new Socket();
              client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                try {
                  client.write('auth ' + vs_server.PASS + '\n\n');
                  console.log("Password : " + vs_server.PASS);
                  client.write('api originate ' + socketData + '\n\n');
                  client.on("data", (respon) => { 
                    try{
                      let tmp = respon.toString().split("\n");
                      tmp.forEach((elem: any) => {
                        if (elem != undefined) {
                          if (elem.length > 0) {
                            console.log(elem);
                            let t1 = elem.split("OK");
                            if (t1.length == 2) {
                              console.log(t1);
                              /* if (t1[0] == "+") { */
                              if (t1[0] == "Reply-Text: +") {
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Call Connected Successfully!", uuid: t1[1].trim() });
                                objv.execute();
                              }
                            }
                          }
                        }
                      });
                    }catch(e){
                      console.log("Error in makeCallviaMedia", e);
                      res.status(503).send({ message: "Call not Connected" });
                    }

                  });
                  client.on("error", (e) => {
                    console.log(e);
                  })

                  client.on("end", () => {

                  })
                } catch (e) {
                  console.log("Error :: makeCallviaMedia ::", e);
                  let obj = new RawView(res);
                  obj.prepare({ error_code: 0, status: 502, message: "Something Went Wrong!" });
                  obj.execute();
                }
              });
            })
          } else {
            let objv = new RawView(res);
            objv.prepare({ status: 404, message: "MediaID is Invalid Please Provide Correct MediaID!" });
            objv.execute();
          }
        });
      } else {
          res.send(resulT);
      }
    });
  }

  public ThreeWayCall(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
      console.log("api originate {effective_caller_id_name=" + smNumber.affectiveOriginate + ",effective_caller_id_number=" + smNumber.affectiveOriginate + ",origination_caller_id_name=" + smNumber.affectiveOriginate + ",origination_caller_id_number=" + smNumber.affectiveOriginate + ",ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + ",idapi=' + sessdata.idapi + ',leg_other=" + vrate.getCallRate(req.body.Number) + "}sofia/gateway/iplink/" + prefix + req.body.Number + " XML default");
      let digit: any;
      digit = req.body.TONE;
      let client = new Socket();
      client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
        console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
        client.write('auth ' + vs_server.PASS + '\n\n');
        console.log("Password : " + vs_server.PASS);
        client.write("api originate {effective_caller_id_name=" + smNumber.affectiveOriginate + ",effective_caller_id_number=" + smNumber.affectiveOriginate + ",origination_caller_id_name=" + smNumber.affectiveOriginate + ",origination_caller_id_number=" + smNumber.affectiveOriginate + ",ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + ",idapi=' + sessdata.idapi + ',leg_other=" + vrate.getCallRate(req.body.Number) + "}sofia/gateway/iplink/" + prefix + req.body.Number + " XML default");
        client.on("data", (respon) => {
          try{
            console.log("respon", respon.toString);
            let tmp = respon.toString().split("\n");
            console.log("tmp", tmp);
            tmp.forEach((elem: any) => {
              console.log("elem", elem);
              if (elem != undefined) {
                if (elem.length > 0) {
                  console.log(elem);
                  let t1 = elem.split("OK");
                  console.log("t1", t1);
                  if (t1.length == 2) {
                    console.log(t1);
                    /* if (t1[0] == "+") { */
                    if (t1[0] == "Reply-Text: +") {
                      res.status(200).send(t1[1].trim());
                      console.log("uuid_bridge" + req.body.UUID + " " + t1[1].trim());
                      client.write("uuid_bridge" + req.body.UUID + " " + t1[1].trim());
                      client.destroy();
                    }
                  }
                }
              }
            });
          }
          catch(e){
            console.log("Error in ThreeWayCall", e);
            res.status(503).send({ message: "Call not Connected" });
          }
          
        });

        client.on("error", (e) => {
          console.log(e);
        })

        client.on("end", () => {

        })
      });      
  }

  public Barge(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
        req.body.FROM = smNumber.barge;
        let cmd = "api originate {effective_caller_id_name=" + req.body.FROM.trim() + ",effective_caller_id_number=" + req.body.FROM.trim() + ",origination_caller_id_name=" + req.body.FROM.trim() + ",origination_caller_id_number=" + req.body.FROM.trim() + ",leg_other=" + vrate.getCallRate(req.body.Number) + ",idapi=" + setToZero(sessdata.idapi) + ",ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + "}sofia/gateway/iplink/" + prefix + req.body.Number + " 88" + req.body.Extension + "";
        console.log(cmd);
        let client = new Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
          console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
          client.write('auth ' + vs_server.PASS + '\n\n');
          console.log("Password : " + vs_server.PASS);
          client.write(cmd + '\n\n');
          client.on("data", (respon) => {
            try{
              let tmp = respon.toString().split("\n");
              tmp.forEach((elem: any) => {
                if (elem != undefined) {
                  if (elem.length > 0) {
                    console.log(elem);
                    let t1 = elem.split("OK");
                    if (t1.length == 2) {
                      console.log(t1);
                      /* if (t1[0] == "+") { */
                      if (t1[0] == "Reply-Text: +") {
                        res.status(200).send(t1[1].trim());
                        client.destroy();
                      }
                    }
                  }
                }
              });
            }catch(e){
              console.log("Error in Barge", e);
              res.status(503).send({ message: "Call not Connected" });
            }            
          });

          client.on("error", (e) => {
            console.log(e);
          })

          client.on("end", () => {

          })
        });
      
  }

  public CallTransfer(req: Request, res: Response, next: NextFunction, sessdata: any, lerg_data: any, vrate: any, callback: (err: any, data: any) => void) {
    let length = req.body.Number.length;
    if (length == 7) {
      var socketData = req.body.UUID + " -bleg " + req.body.Number + " XML default";
    } else {
      var socketData = req.body.UUID.trim() + " -bleg 88791" + req.body.Number.trim() + " XML default";
    }
    let client = new Socket();
    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
      console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
      client.write('auth ' + vs_server.PASS + '\n\n');
      console.log("Password : " + vs_server.PASS);
      console.log(socketData);
      client.write('api uuid_transfer ' + socketData + '\n\n');
      client.on("data", (respon) => {
        try{
          let tmp = respon.toString().split("\n");
          tmp.forEach((elem: any) => {
            if (elem != undefined) {
              if (elem.length > 0) {
                console.log(elem);
                let t1 = elem.split("OK");
                if (t1.length == 2) {
                  console.log(t1);
                  /* if (t1[0] == "+") { */
                  if (t1[0] == "Reply-Text: +") {
                    client.write("api uuid_setvar " + req.body.UUID + " leg_other " + vrate.getCallRate(req.body.Number) + '\n\n');
                    res.status(200).send(t1[1].trim());
                    client.destroy();
                  }
                }
              }
            }
          });
        } catch(e){
          console.log("Error in CallTransfer", e);
          res.status(503).send({ message: "Call not Connected" });
        }
      });
      client.on("error", (e) => {
        console.log("Error", e);
      });
      client.on("end", () => {
        console.log("End")
      })
    });
  }

  public login(req: Request, res: Response, callback: (err: any, data: any) => void) {
    var options = {
      'method': 'POST',
      'url': 'https://apicontrol.call48.com/api/v4/login',
      'headers': {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({
        'user_name': 'iplink1',
        "password": "kzwJQV4arc4",
      }),
    };
    request(options, (error: any, response: any) => {
      if (!error) {
        try {
          let sdata = JSON.parse(response.body);
          if (sdata.code == 200) {
            let authkey = sdata.data.token
            callback('', authkey);
          } else {
            callback(sdata, '');
          }
        }
        catch (e) {
          console.log("Error :: login ::", e);
          callback(error, '');
        }
      } else {
        callback(error, '');
      }
    })
  }

  // public abstract getByRate(req:Request, res:Response, callback:(err:any, data:any)=>void):void;
  // public abstract getTollFree(req:Request, res:Response, callback:(err:any, data:any)=>void):void;
  // public abstract buyDID(req: Request, res: Response, callback: (err: any, data: any) => void):void;
  // public abstract disconnectDID(req: Request, res: Response, callback: (err: any, data: any) => void):void;
  // public abstract MakeCall(req: Request, res: Response, next: NextFunction):void;
  // public abstract MakeOutboundCallToNumber(req: Request, res: Response, next: NextFunction): void;
}