import { SMS } from "./APISMSBase";
import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { Number } from "./numberApi";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { LergApi } from "./lrnApi";
import { InteliquentAPI } from "./Inteliquent";
import { InteliquentSMS } from "./InteliquentSMS";

export class SinchSMS extends SMS {
    constructor() {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5"
    }


    public SendSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        this.saveSMS(req, res, next, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        })
    }

    // Not in Use. it may be changed as per requirement
    public SendTFSms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id });
            objv.execute();
        });
    }

    public SendTFMms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFMMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }

    public SendMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        this.saveMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })

    }
    public SendSynivMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        this.saveSynivMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })
    }

    public SendSCSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let lergData: any = Data.lergData
        // To set the data for final SMS
        this.saveSCSMS(req, res, next, sessdata, lergData, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }

    public SendSCMms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let lergData: any = Data.lergData
        let didData: any = Data.DIDdata
        let fType: any = Data.fileType
        let file: any = Data.file
        // To set the data for final SMS
        this.saveSCMMS(req, res, next, sessdata, lergData, DIDData, didData, fType, file, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        })
    }
}