import { SMS } from "./APISMSBase";
import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { Number } from "./numberApi";
import { Res406 } from "../lib/view/406";
import { LergApi } from "./lrnApi";
import { APIBase } from "./APIBase";
import { InteliquentAPI } from "./Inteliquent";
import { InteliquentSMS } from "./InteliquentSMS";

export class TeleSMS extends SMS {

    constructor() {
        super();
        this.key = "48de6c84-7726-4879-bc08-f7a5dcf63f1c";
        this.account = "";
    }

    public SendSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        this.saveSMS(req, res, next, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        })
    }

    // Not in Use. it may be changed as per requirement
    public SendTFSms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id });
            objv.execute();
        });
    }

    public SendTFMms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFMMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }

    public SendSynivMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        this.saveSynivMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })
    }

    public SendSCSms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentSMS();
        intel.SendSCSms(req, res, next, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }

    public SendMms(req: Request, res: Response, next: NextFunction, token: string, sms_provider: string, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let number = new Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    } else {
                        let PayLoad: any = {
                            TO: TO
                        }
                        let lerg = new LergApi("", "");
                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                if (lerg_info.length > 0) {
                                    let Data={
                                        sessdata:sessdata,
                                        lerg_info:lerg_info
                                    }
                                    this.saveSMS(req, res, next, Data, sms_provider, (sms_err, sms_result) => {
                                        if (sms_result != undefined) {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_result);
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare(sms_err);
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Lerg Info Not Found" });
                                    objv.execute();
                                }
                            })
                        })
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    public SendSCMms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let didData: any = Data.DIDdata
        let fType: any = Data.fileType
        let file: any = Data.file
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let PayLoad: any = {
                    TO: TO
                }
                let lerg = new LergApi("", "");
                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                    let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                    let baseapi = new APIBase();
                    baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                        if (lerg_info.length > 0) {
                            this.saveSCMMS(req, res, next, sessdata, lerg_info, DIDData, didData, fType, file, (sms_err, sms_result) => {
                                if (sms_result != undefined) {
                                    let objv = new RawView(res);
                                    objv.prepare(sms_result);
                                    objv.execute();
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare(sms_err);
                                    objv.execute();
                                }
                            })
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Lerg Info Not Found" });
                            objv.execute();
                        }
                    })
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}