import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { parseBody } from "./markError";
export class Webhook {
    constructor() {
        // super();
    }

    public Webhookcategory(req: Request, res: Response, next: NextFunction) {
     
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `webhookCategory` FROM `webhook_roles` GROUP BY `webhookCategory`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Webhook Category Fetched",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public geteventType(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `eventType` FROM `webhook_roles` where `webhookCategory`='"+sdata.type+"'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Hook Url Fetched Successfully",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getWebhook(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata:any = req.query;

            let con:any = '';
            if(sessdata.type == 1){
                if(sdata.type !== null && sdata.type !== undefined && sdata.type){
                    con = "WHERE we.`idaccount`= '" + sdata.type.split('-')[1] + "'"
                }
                else {
                    con = '';
                }
            }
            if(sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203){
                con = "WHERE `idaccount`= '" + sessdata.idaccount + "'"
            }
            if(sessdata.type == 22){
                con = "WHERE `iduser`= '" + sessdata.iduser + "'"
            }
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT `webhook_id`,`iduser`, `idaccount`, `webhookCategory`,`eventType`,`webhookUrl`,`created_at` FROM `webhook_endpoint` "+con+"";

                obj.qrysql = "SELECT we.`webhook_id`,we.`iduser`, we.`idaccount`,up.`firstname`,up.`lastname`, we.`webhookCategory`,we.`eventType`,we.`webhookUrl`,we.`created_at`,we.`updated_at` FROM `webhook_endpoint` we INNER JOIN `user_profile` up ON we.iduser=up.iduser  "+con+"";
                 obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Webhook Fetched Successfully",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public addWebhook(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data; 
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `webhookCategory` FROM `webhook_endpoint` WHERE `webhookCategory`='"+sdata.webhookCategory+"' AND `idaccount`='"+sessdata.idaccount+"'";
                obj0.prepare();
                obj0.execute((__error: any, resWebhook: any) => {
                    if(__error==1 && resWebhook.length < 1){
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql=" INSERT INTO `webhook_endpoint` (`iduser`,`idaccount`,`webhookCategory`, `eventType`,`webhookUrl`) VALUES ('"+sessdata.iduser+"', '"+sessdata.idaccount+"', '"+sdata.webhookCategory+"', '"+sdata.eventType+"', '"+parseBody(sdata.webhookUrl)+"')";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Webhook Inserted Successfully",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Something Went Wrong With Webhook!",
                                status: 502,
                                error: result
                            });
                            objv.execute();
                        }
                    });              
                    }else{
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Already Exits Webhook Endpoint",
                            status: 502,
                        });
                        objv.execute();

                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public deleteWebhook(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, _sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `webhook_endpoint` WHERE `webhook_id`='"+sdata.id+"';";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Webhook Deleted Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Webhook!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    
    public updateWebhook(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, _sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data;  
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `webhook_endpoint` SET `webhookCategory`='" + sdata.webhookCategory + "',`eventType`='" + sdata.eventType + "',`webhookUrl`='" + parseBody(sdata.webhookUrl) + "', `updated_at`=NOW() WHERE `webhook_id`='" + sdata.webhook_id + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => { 
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Webhook Updated Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Webhook Update!", status: 502 });
                        objv.execute();
                    }
                });

              
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public addWebhookForSwagger(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let sdata = req.body;
                    let obj0 = new ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `webhookCategory` FROM `webhook_endpoint` WHERE `webhookCategory`='"+sdata.eventCategory+"' AND `idaccount`='"+sessdata.idaccount+"'";
                    obj0.prepare();
                    obj0.execute((__error: any, resWebhook: any) => {
                        if(__error==1 && resWebhook.length < 1){
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql="INSERT INTO `webhook_endpoint` (`iduser`,`idaccount`,`webhookCategory`,`webhookUrl`) VALUES ('"+sessdata.iduser+"', '"+sessdata.idaccount+"', '"+sdata.eventCategory+"', '"+parseBody(sdata.webhookEndpoint)+"')";
                            obj.prepare();
                            obj.execute((error: any, result: any) => {
                                if (error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        data: sdata,
                                        message: "Webhook Subscribed Successfully.",
                                        status: 200
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Webhook Not Subscribed!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else{
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `webhook_endpoint` SET `webhookCategory`='" + sdata.eventCategory + "',`webhookUrl`='" + parseBody(sdata.webhookEndpoint) + "',`updated_at`=NOW() WHERE `webhookCategory`='" + sdata.eventCategory + "' AND `idaccount`='" + sessdata.idaccount + "'";
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: sdata, message: "Webhook Subscribed Successfully!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Webhook Update!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    });
                }else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
 
    
}