import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { OsrApi } from "./Osr";
import { SinchApi } from "./SinchSubmitNumber";
import { TeleAPI } from "./TeleApi";
import { Number } from "./numberApi";
import { RawView } from "../lib/view/RawView";
import { parseBody, setToZero } from "./markError";
import { Types } from "mongoose";
var request = require('request');

export class ThinQAPI extends APIBase {
    private key: string;
    private secret: string;
    private priority: string;
    private sessdata: any;
    private timekey: string;

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5";
        this.timekey = timekey;
        this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }

    public getNpaNxx(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err = 1 && voice_rate.length > 0) {
                    const sdata = req.query;
                    var url;
                    if (sdata.NPA != undefined && sdata.NPA != 'null') {
                        url = "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=npa&quantity=" + sdata.Qty + "&contiguous=false&npa=" + sdata.NPA + ""
                    }
                    if ((sdata.NPA != undefined && sdata.NPA != 'null') && (sdata.NXX != undefined && sdata.NXX != 'null')) {
                        url = "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=npanxx&quantity=" + sdata.Qty + "&contiguous=false&npa=" + sdata.NPA + "&nxx=" + sdata.NXX + ""
                    }
                    let options = {
                        'method': 'GET',
                        'url': url,
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let data = JSON.parse(response.body);
                                if (data.dids != undefined && data.dids.length > 0) {
                                    let str: any = data.dids;
                                    let found: boolean = false;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        if (ele.thinqTier == 0) {
                                            let did: string = "" + ele.id + "";
                                            let number = did.substring(1, 11);
                                            qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + parseBody(ele.state) + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                            found = true;
                                        }
                                    });
                                    if (found) {
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        callback('', data);
                                    }
                                }
                                else {
                                    callback('', data);
                                }
                            }
                            catch (e) {
                                console.log("Error :: Thinq->getNpaNxx::", e);
                                callback(error, '');
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    let options = {
                        'method': 'GET',
                        'url': "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=ratecenter&quantity=" + sdata.Qty + "&contiguous=false&state=" + sdata.State + "&rateCenter=" + sdata.RateCenter + "",
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    request(options, (error: any, response: any) => {
                        if (!error && response.body) {
                            try {
                                let data = JSON.parse(response.body);
                                if (data.dids != undefined && data.dids.length > 0) {
                                    let str: any = data.dids;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let found: boolean = false;
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        if (ele.thinqTier == 0) {
                                            let did: string = "" + ele.id + "";
                                            let number = did.substring(1, 11);
                                            qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + parseBody(ele.state) + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                            found = true;
                                        }
                                    });
                                    if (found) {
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        callback(err, data);
                                    }
                                }
                                else {
                                    callback('', data);
                                }
                            }
                            catch (e) {
                                console.log("Error :: Thinq->getByRate::", e);
                                callback(error, '');
                            }

                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    var options = {
                        'method': 'GET',
                        'url': "https://api.thinq.com/inbound/get-numbers?searchType=tollfree&searchBy=&quantity=" + sdata.Qty + "&contiguous=false",
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let data = JSON.parse(response.body);
                                if (data.dids != undefined && data.dids.length > 0) {
                                    let str: any = data.dids;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        let did: string = "" + ele.id + "";
                                        let number = did.substring(1, 11);
                                        qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','TF','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', data);
                                }
                            }
                            catch (e) {
                                console.log("Error :: Thinq->getTollFree::", e);
                                callback(error, '');
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }

    public buyDID(req: Request, res: Response, did_details: any, other_data: any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let types: any;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6)
        let Did = did.slice(len, len + 10);
        let id_grouporder: number = other_data.id_grouporder;
        let sub_type: number = other_data.sub_type;

        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : ''
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : ''

            // To get the proration status
            let objv0 = new ModelRawQuery(req, res);
            objv0.qrysql = "SELECT t.`proration`,t.`day_num` FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((proration_error, proration_success) => {
                if (proration_error == 1) {
                    let did_dis_days = proration_success[0].day_num > 0 ? proration_success[0].day_num : 0;
                    let proration_status = proration_success[0].proration;

                    types = did_details[0].type == 'TF' ? 'TF' : 'NN';
                    var options = {
                        'method': 'POST',
                        'url': 'https://api.thinq.com/account/15080/origination/order/create',
                        'headers': {
                            'Authorization': 'Basic ' + this.key,
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            "order": {
                                "tns": [
                                    {
                                        "route_id": 7818,
                                        "did": sdata.DID.trim()
                                    }
                                ],
                                "blocks": []
                            }
                        })
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                let data = JSON.parse(response.body);
                                // If order created on provider side
                                if (typeof data.id != 'undefined' && data.id) {
                                    var options = {
                                        'method': 'POST',
                                        'url': 'https://api.thinq.com/account/15080/origination/order/complete/' + `${data.id}`,
                                        'headers': {
                                            'Authorization': 'Basic ' + this.key,
                                            'Content-Type': 'application/json'
                                        }
                                    };
                                    request(options, (error: any, response: any) => {
                                        if (!error) {
                                            try {
                                                let ddata = JSON.parse(response.body);
                                                // If order completed on provider side
                                                if (typeof ddata.id != 'undefined' && ddata.id) {
                                                    let providerOrderId: any = typeof data.id != 'undefined' && data.id ? data.id : ''
                                                    let dateObj = new Date();
                                                    let day = dateObj.getUTCDate();

                                                    let nDate: any = new Date()
                                                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                                    let totalDays = (lDate - day) + 1;

                                                    let prorate: any = 0;
                                                    if (proration_status == "true") {
                                                        prorate = (totalDays * did_details[0].rates) / lDate;
                                                    }
                                                    else {
                                                        prorate = did_details[0].rates;
                                                    }
                                                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0
                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`,`did_sub_type`) VALUE('" + this.sessdata.idaccount + "','','completed','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + setToZero(this.sessdata.idapi) + "','" + prorate + "','" + did_dis_days + "','" + did_details[0].rates + "','" + sub_type + "')";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        if (did_err == 1) {
                                                            // update end subscription date
                                                            let obj0 = new ModelRawQuery(req, res);
                                                            obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + did_data.insertId + "' AND disconnect_did_status = '1'";
                                                            obj0.prepare();
                                                            obj0.execute((dids_err, didRes) => {
                                                                let dates = didRes[0].subscription_end_date;
                                                                let isoDate = new Date(dates);
                                                                let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                                let obj01 = new ModelRawNonQuery(req, res);
                                                                obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                                obj01.prepare();
                                                                obj01.execute((error, result) => { })
                                                            })

                                                            // To update the wallet amount
                                                            let objv = new ModelRawNonQuery(req, res);
                                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                            objv.prepare();
                                                            objv.execute((wallet_error, wallet_success) => {

                                                                // To update the wallet transaction log
                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                                iQry += "`amount`='-" + prorate + "', "
                                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                                iQry += "`status`=1;"

                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                objWL.nonqrysql = iQry
                                                                objWL.prepare()
                                                                objWL.execute((error: any, result: any) => {
                                                                })

                                                                // To create the DID log
                                                                let objv1 = new ModelRawNonQuery(req, res);
                                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`,`full_log`) VALUE('" + this.sessdata.idaccount + "','','completed','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "','1','DID Buy','" + ddata + "')"
                                                                objv1.prepare();
                                                                objv1.execute((log_error, did_log) => { });

                                                                // To delete the DID from cart
                                                                let obj5 = new ModelRawNonQuery(req, res);
                                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                                obj5.prepare();
                                                                obj5.execute((walletError1: any, wallet1: any) => { });

                                                                // To update the process count of group order
                                                                let objk = new ModelRawNonQuery(req, res)
                                                                objk.nonqrysql = "UPDATE `did_group_order` SET `process_dids`=`process_dids`+ 1 WHERE `id_grouporder`=" + id_grouporder + ";"
                                                                objk.prepare()
                                                                objk.execute((error, result) => {
                                                                    console.log("GroupOrder process count::\n", result)
                                                                })

                                                                // To create the did_order
                                                                let obj = new ModelRawNonQuery(req, res);
                                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + Did + "', '2', '" + types + "', '" + did_details[0].rates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                                obj.prepare();
                                                                obj.execute((did_err, did_data) => {
                                                                    // To update the other data on current order
                                                                    if (did_err == 1) {
                                                                        let id_order: number = did_data.insertId
                                                                        let orderID: string = "SORD" + id_order.toString()

                                                                        let log_error: string = ""
                                                                        let log_message: string = ddata.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                                        let log_result: string = JSON.stringify(ddata).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";"
                                                                        obj.prepare();
                                                                        obj.execute((error, result) => { })
                                                                    }
                                                                });

                                                                // To submit the number on OSR
                                                                if (sdata.CampaignId && types == "NN") {
                                                                    let osr = new OsrApi(this.priority, this.sessdata)
                                                                    osr.updateNumber(req, res, did_data.insertId, (error, responce) => { })
                                                                }
                                                                else {
                                                                    let obj = new RawView(res);
                                                                    obj.prepare({
                                                                        error_code: 1,
                                                                        status: 201,
                                                                        message: "DID buy successfully.",
                                                                        result: [
                                                                            {
                                                                                "did": Did
                                                                            }
                                                                        ]
                                                                    });
                                                                    obj.execute()
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let obj = new RawView(res);
                                                            obj.prepare({
                                                                error_code: 0,
                                                                status: 502,
                                                                message: "Something went wrong with connection!"
                                                            });
                                                            obj.execute()
                                                        }
                                                    });
                                                }

                                                // If order failed
                                                else {
                                                    let providerOrderId: any = typeof data.id != 'undefined' && data.id ? data.id : ''

                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + Did + "', '4', '" + types + "', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        // To update the other data on current order
                                                        if (did_err == 1) {
                                                            let id_order: number = did_data.insertId
                                                            let orderID: string = "SORD" + id_order.toString()

                                                            let log_error: string = JSON.stringify(ddata).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                            let log_message: string = ddata.message.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                            let log_result: string = ""

                                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + ddata.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";"
                                                            obj.prepare();
                                                            obj.execute((error, result) => { })
                                                        }
                                                    });

                                                    let objn = new ModelRawNonQuery(req, res);
                                                    objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + ddata + "')"
                                                    objn.prepare();
                                                    objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                                        console.log("DID Buy failed from provider");
                                                    });

                                                    let objV = new RawView(res);
                                                    objV.prepare({
                                                        error_code: 0,
                                                        status: ddata.code,
                                                        message: ddata.message,
                                                        error: ddata
                                                    });
                                                    objV.execute();
                                                }
                                            }
                                            catch (e) {
                                                console.log("Error :: Thinq->buyDID::", e);
                                                let obj = new RawView(res);
                                                obj.prepare({
                                                    error_code: 0,
                                                    status: 502,
                                                    message: "Something went wrong with DID Buy!"
                                                });
                                                obj.execute();
                                            }

                                        }
                                        else {
                                            let obj = new RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with DID Buy!"
                                            });
                                            obj.execute();
                                        }

                                    });
                                }

                                // If order failed
                                else {
                                    let providerOrderId: any = typeof data.id != 'undefined' && data.id ? data.id : ''

                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + Did + "', '4', '" + types + "', '" + did_details[0].rates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order: number = did_data.insertId
                                            let orderID: string = "SORD" + id_order.toString()

                                            let log_error: string = JSON.stringify(data).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_message: string = data.message.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                            let log_result: string = ""

                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + data.code + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='thinQ', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";"
                                            obj.prepare();
                                            obj.execute((error, result) => { })
                                        }
                                    });

                                    let objn = new ModelRawNonQuery(req, res);
                                    objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + data + "')"
                                    objn.prepare();
                                    objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                        console.log("DID Buy failed from provider");
                                    });

                                    let objV = new RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: data.code,
                                        message: data.message,
                                        error: data
                                    });
                                    objV.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: Thinq->buyDID::", e);
                                let obj = new RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 502,
                                    message: "Something went wrong!"
                                });
                                obj.execute();
                            }
                        }
                        else {
                            let obj = new RawView(res);
                            obj.prepare({
                                error_code: 0,
                                status: 400,
                                error: error
                            });
                            obj.execute()
                        }
                    });
                }
                else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            });
        });
    }

    disconnectDID(req: Request, res: Response, payload: any, callback: (err: any, data: any) => void) {
        let sdata: any = req.body;
        let iduser: number = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        var options = {
            'method': 'POST',
            'url': 'https://api.thinq.com/account/15080/origination/disconnect',
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + this.key
            },
            body: JSON.stringify({
                "dids": [sdata.DID.trim()]
            })
        };
        request(options, (error: any, response: any) => {
            if (!error) {
                try {
                    let data: any = JSON.parse(response.body);
                    if (data.status == "completed" || data.code == 403) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + iduser + "'";
                        obj.prepare();
                        obj.execute((error: any, resp: any) => {
                            if (error == 1) {
                                // To  update updated_at date in did log
                                let obj = new ModelRawNonQuery(req, res);
                                // obj.nonqrysql = "UPDATE `did_log` SET `event_type`='5',`description`='DID Disconnect Successfully',`updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','Disconnect DID from provider','" + sdata.DID.trim() + "','" + data + "')"
                                obj.prepare();
                                obj.execute((errorDiDLg: any, resDiDLg: any) => { });

                                // To delete the number from OSR
                                let payLoad: any = {
                                    DID: sdata.DID.trim(),
                                    campaign: payload.campaign,
                                    iduser: iduser
                                }
                                let osr = new OsrApi(this.priority, this.sessdata)
                                osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                    if (error == 1) {
                                        if (payload.sms_provider == 'sinch') {
                                            // To delete the number from Sinch
                                            let osr = new SinchApi(this.priority, this.sessdata)
                                            osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                            })
                                        } else {
                                            // To delete the number from Syniverse
                                            let osr = new SinchApi(this.priority, this.sessdata)
                                            osr.deleteNumberM2fromSyniverse(req, res, payLoad, (error, response) => {
                                            })
                                        }
                                    }
                                })
                                let objv = new RawView(res);
                                objv.prepare({ status: 201, message: "DID Disconnected Successfully" })
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection" });
                                objv.execute();
                            }
                        })
                    }
                    else {
                        let objn = new ModelRawNonQuery(req, res);
                        objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'39','DID disconnect failed from provider','" + sdata.DID.trim() + "','" + data + "')"
                        objn.prepare();
                        objn.execute((errorDiDLg: any, resDiDLg: any) => {
                            console.log("DID disconnect failed FROM provider");
                        });

                        let objv = new RawView(res);
                        objv.prepare({ status: data.code, message: data.message });
                        objv.execute();
                    }
                }
                catch (e) {
                    console.log("Error :: Thinq->disconnectDID::", e);
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                console.log("ThinQ :::::::::::::::::::");
                let objv = new RawView(res);
                objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                objv.execute();
            }
        });
    }

}