import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { OsrApi } from "./Osr";
import { TeleAPI } from "./TeleApi";
import { Number } from "./numberApi";
import { RawView } from "../lib/view/RawView";
import { Types } from "mongoose";
var request = require('request');

export class BlitzAPI extends APIBase {
    private key: string;
    private secret: string;
    private priority: string;
    private sessdata: any;
    private timekey: string;

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5";
        this.timekey = timekey;
        this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }


    public getNpaNxx(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err = 1 && voice_rate.length > 0) {
                    let baseapi = new APIBase()
                    baseapi.login(req, res, (token_err, token_resp) => {
                        if (token_resp) {
                            const sdata = req.query;
                            console.log("sdata", sdata);
                            var url;
                            if (sdata.NPA != undefined) {
                                url = "https://apicontrol.call48.com/api/v4/search?type=local&npa="+sdata.NPA+"&limit="+sdata.Qty
                            }
                            if (sdata.NPA != undefined && sdata.NXX != undefined) {
                                url = "https://apicontrol.call48.com/api/v4/search?type=local&npa="+sdata.NPA+"&nxx="+sdata.NPA+"&limit="+sdata.Qty
                            }
                            let options = {
                                'method': 'GET',
                                'url': url,
                                'headers': {
                                    'Authorization': token_resp
                                },
                            };
                            request(options, (error: any, response: any) => {
                                if (!error) {
                                    try{
                                        let data = JSON.parse(response.body);
                                        console.log("Reponcnce==>", data);
                                        if (data.code == 200) {
                                            if (data.data.result.length > 0) {
                                                let str = data.data.result;
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE";
                                                str.forEach((ele: any) => {
                                                    qrystr += "('','" + ele.number + "', '', '', '" + ele.ratecenter + "', '" + ele.state + "', '', '','', '" + "teleapi" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.tier + "','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','"+this.sessdata.idapi+"','"+this.timekey+"'),";
                                                });
                                                obj1.nonqrysql = qrystr.slice(0, -1);
                                                obj1.prepare();
                                                obj1.execute((err, data) => {
                                                    callback(err, data);
                                                });
                                            } else {
                                                let obj = new RawView(res);
                                                obj.prepare({message:"No DID's found on ["+sdata.NPA+"]"});
                                                obj.execute();
                                            }
                                        } else {
                                            callback('', data);
                                        }
                                    }
                                    catch(e){
                                        console.log("Error :: blitz->getNpaNxx::",e);                                 
                                        callback(error, '');
                                    }
                                  
                                } else {
                                    callback(error, '');
                                }
                            });
                        } else {
                            callback(token_err, '');
                        }
                    })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    let options = {
                        'method': 'GET',
                        'url': "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=ratecenter&quantity=" + sdata.Qty + "&contiguous=false&state=" + sdata.State + "&rateCenter=" + sdata.RateCenter + "",
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    console.log("Options", options);
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                let data = JSON.parse(response.body);
                                console.log("data==>", data);
                                if (data.dids != undefined && data.dids.length > 0) {
                                    let str: any = data.dids;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let found: boolean = false;
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        if (ele.thinqTier == 0) {
                                            let did: string = "" + ele.id + "";
                                            let number = did.substring(1, 11);
                                            qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + sdata.CampaignId + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                            found = true;
                                        }
                                    });
                                    if (found)
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                    else
                                        obj1.nonqrysql = "";
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', data);
                                }
                            }
                            catch(e){
                                console.log("Error :: blitz->getByRate::",e);                                 
                                callback(error, '');
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    var options = {
                        'method': 'GET',
                        'url': "https://api.thinq.com/inbound/get-numbers?searchType=tollfree&searchBy=&quantity=" + sdata.Qty + "&contiguous=false",
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                let data = JSON.parse(response.body);
                                console.log("data", data);
                                if (data.dids != undefined && data.dids.length > 0) {
                                    let str: any = data.dids;
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele: any) => {
                                        let did: string = "" + ele.id + "";
                                        let number = did.substring(1, 11);
                                        qrystr += "('" + ele.didSummary + "','" + number + "', '', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '', '', '', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','TF','" + ele.thinqTier + "','','" + voice_rate[0].rate + "','" + this.sessdata.path + "','" + this.sessdata.idapi + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', data);
                                }
                            }
                            catch(e){
                                console.log("Error :: blitz->getTollFree::",e);                                 
                                callback(error, '');
                            }
                           
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }

    buyDID(req: Request, res: Response, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let types: any;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6)
        let Did = did.slice(len, len + 10);
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : ''
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : ''
            let obj1 = new ModelRawQuery(req, res);
            obj1.qrysql = "SELECT `type`,`rates` from `did_search` WHERE `iduser`='" + this.sessdata.iduser + "' AND `phone_number`='" + sdata.DID.trim() + "'";
            obj1.prepare();
            obj1.execute((error, did_details) => {
                if (did_details.length > 0) {
                    types = did_details[0].type == 'TF' ? 'TF' : 'NN';
                    var options = {
                        'method': 'POST',
                        'url': 'https://api.thinq.com/account/15080/origination/order/create',
                        'headers': {
                            'Authorization': 'Basic ' + this.key,
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            "order": {
                                "tns": [
                                    {
                                        "route_id": 7818,
                                        "did": sdata.DID.trim()
                                    }
                                ],
                                "blocks": []
                            }
                        })
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                console.log("response", response.body);
                                let data = JSON.parse(response.body);
                                if (data.id != undefined) {
                                    console.log(data.id);
                                    var options = {
                                        'method': 'POST',
                                        'url': 'https://api.thinq.com/account/15080/origination/order/complete/' + `${data.id}`,
                                        'headers': {
                                            'Authorization': 'Basic ' + this.key,
                                            'Content-Type': 'application/json'
                                        }
                                    };
                                    request(options, (error: any, response: any) => {
                                        console.log("Data", sdata);
                                        if (!error) {
                                            try{
                                                let ddata = JSON.parse(response.body);
                                                if (ddata.code == 404) {
                                                    let obj = new RawView(res);
                                                    obj.prepare({ status: ddata.code, result: ddata });
                                                    obj.execute()
                                                } else {
                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`sms_provider`) VALUE('" + ddata.account_id + "','" + ddata.user_id + "','" + ddata.status + "','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + this.sessdata.idapi + "','sinch')";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        if (did_err == 1) {
                                                            let dateObj = new Date();
                                                            let day = dateObj.getUTCDate();
                                                            let totalDays = 30 - day + 1;
                                                            let prorate = (totalDays * did_details[0].rates) / 30;
                                                            console.log(prorate);
                                                            let objv = new ModelRawNonQuery(req, res);
                                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                            objv.prepare();
                                                            objv.execute((wallet_error, wallet_success) => {
                                                                let objv1 = new ModelRawNonQuery(req, res);
                                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`) VALUE('','','completed','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + did_details[0].rates + "','" + this.sessdata.idapi + "','" + prorate + "')"
                                                                objv1.prepare();
                                                                objv1.execute((log_error, did_log) => {
                                                                    if (sdata.CampaignId && types == "NN") {
                                                                        let osr = new OsrApi(this.priority, this.sessdata);
                                                                        osr.updateNumber(req, res, data.insertId, (error, responce) => {
                                                                            if (responce) {
                                                                                return callback('', responce);
                                                                            } else {
                                                                                callback(error, '');
                                                                            }
                                                                        })
                                                                    } else {
                                                                        let obj2 = new ModelRawQuery(req, res);
                                                                        obj2.qrysql = "SELECT `did` FROM `did_buy` WHERE `iddid`='" + did_data.insertId + "' ";
                                                                        obj2.prepare();
                                                                        obj2.execute((did_err, did_result) => {
                                                                            if (did_err == 1) {
                                                                                let obj = new RawView(res);
                                                                                obj.prepare({ status: 201, message: "DID buy successfully", result: did_result });
                                                                                obj.execute()
                                                                            }
                                                                        })
                                                                    }
                                                                });
                                                            })
                                                        } else {
                                                            let obj = new RawView(res);
                                                            obj.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                            obj.execute()
                                                        }
                                                    });
                                                }
                                            }
                                            catch(e){
                                                console.log("Error :: blitz->buyDID::",e);                                 
                                                let obj = new RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                obj.execute();
                                            }
                                           
                                        } else {
                                            let obj = new RawView(res);
                                            obj.prepare({ status: 400, error: error });
                                            obj.execute()
                                        }
                                    });
                                } else {
                                    let obj = new RawView(res);
                                    obj.prepare({ status: data.code, message: data.message, error: data });
                                    obj.execute()
                                }
                            }
                            catch(e){
                                console.log("Error :: blitz->buyDID::",e);                                 
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                            
                        } else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 400, error: error });
                            obj.execute()
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Did Not Available" });
                    objv.execute();
                }
            })
        });
    }

    disconnectDID(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata: any = req.body;
        console.log("sdata", sdata);
        let number = new Number();
        number.countDays(req, res, sdata.DID.trim(), (err, countdays) => {
            if (countdays) {
                if (countdays > 90) {
                    var options = {
                        'method': 'POST',
                        'url': 'https://api.thinq.com/account/15080/origination/disconnect',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            "dids": [sdata.DID.trim()]
                        })
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                let data: any = JSON.parse(response.body);
                                console.log("data", data);
                                if (data.status == "completed") {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='0',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + this.sessdata.iduser + "'";
                                    obj.prepare();
                                    obj.execute((error, resp) => {
                                        if (error == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: "Something went wrong with connection" });
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let obj = new RawView(res);
                                    obj.prepare({ status: data.code, message: data.message });
                                    obj.execute()
                                }
                            }
                            catch(e){
                                console.log("Error :: blitz->disconnectDID::",e);                                 
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }                    
                        } else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 400, error: error });
                            obj.execute()
                        }
                    });
                } else {
                    let obj = new RawView(res);
                    obj.prepare({ status: 417, message: "Days are Less then 90 So you can not disconnect Did from this Account" });
                    obj.execute();
                }
            } else {
                let obj = new RawView(res);
                obj.prepare({ status: 404, message: "Data Not Found" })
                obj.execute();
            }
        });
    }
}