import { Request, Response, NextFunction } from "express";
import HashMap from "hashmap";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { SessionManagment } from "../lib/model/Session";


export class VoiceRates {
    private rate_data: HashMap<string, string>;

    constructor() {
        this.rate_data = new HashMap();
    }

    public count() {
        return this.rate_data.count();
    }

    public getDIDRate(did: string) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == "800" || digit == "822" || digit == "9" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("toll_free_number")
        } else if (digit == "808" && number.length == 10) {
            return this.rate_data.get("united_states - Hawaii (Zone 2)");
        } else if (digit == "907" && number.length == 10) {
            return this.rate_data.get("united_states - Alaska (Zone 3)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("local_number");
        }
        else {
            return this.rate_data.get("sip_interface");
        }
    }

    public getCallRate(did: string) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == "800" || digit == "822" || digit == "833" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("united_states_toll_free")
        } else if (digit == "808" && number.length == 10) {
            return this.rate_data.get("united_states - Hawaii (Zone 2)");
        } else if (digit == "907" && number.length == 10) {
            return this.rate_data.get("united_states - Alaska (Zone 3)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        else {
            return this.rate_data.get("sip_interface");
        }
    }

    public getCallRates(did: string, zone: String) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        
        if ((digit == "800" || digit == "822" || digit == "833" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("united_states_toll_free");           
        }
        else if(zone){
            switch (zone) {
                case "Zone 2":
                    return this.rate_data.get("united_states - Hawaii (Zone 2)808");

                case "Zone 3":
                    return this.rate_data.get("united_states - Alaska (Zone 3)907");

                case "Zone 4":
                    return this.rate_data.get("united_state High Cost (Zone 4)");

                case "Zone 5":
                    return this.rate_data.get("united_state High Cost (Zone 5)");
                    
                default:
                    return this.rate_data.get("united_states_lower 48 (Zone 1)");
            }
        }
        else{
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        /* else {
            return this.rate_data.get("sip_trunking");
        } */
    }

    public getZone(req: Request, res: Response, did:any, callback: (err: any, data: any) => void){
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 6);
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `tz` FROM `zones` WHERE `npanxx`='" + digit + "'";
        obj1.prepare()
        obj1.execute((err, zone) => {
            if (err && zone.length > 0) {
                callback("", zone[0].tz);
            }
            else{
                callback("0", "");
            }
        });
    }

    public AMDRate(status: any) {
        if (status == "true")
            return this.rate_data.get("answering_machine_detection");
        else
            return "0";
    }

    public RecordRate(status: string) {
        if (status == "true") {
            console.log("record", this.rate_data.get("call_recording"));
            return this.rate_data.get("call_recording");
        }
        else
            return "0";
    }

    public setRate(data: HashMap<string, string>) {
        this.rate_data = data;
    }

    public getType(did: any) {
        console.log("did", did);
        let rate_type;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        console.log("number", number);
        let digit = number.slice(0, 3);
        console.log("digit", digit);
        if ((digit == 800 || digit == 822 || digit == 833 || digit == 844 || digit == 855 || digit == 866 || digit == 877 || digit == 888) && number.length == 10) {
            rate_type = "TF";
        }
        else if (number.length == 10) {
            rate_type = "NN";
        }
        else {
            rate_type = "short_code";
        }
        return rate_type;
    }

    public prepareRate(req: any, res: any, tariff: number, type: string, callback: (err: any, data: any) => void) {
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT IF(`rate`>0,`rate`,`mt`) `rate` ,`category` FROM `voice_rates` WHERE `idtariff`='" + tariff + "'  AND `type`='" + type + "'";
        obj1.prepare()
        obj1.execute((err, voice_rate) => {
            if (voice_rate.length > 0) {
                voice_rate.forEach((element: any) => {
                    this.rate_data.set(element.category, element.rate);
                });
                callback("", this.rate_data);
            } else {
                callback(err, "")
            }
        });
    }

    public verifyDid(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let didNumber = sdata.FROM;
        // let len = didNumber.length - 10;
        // let number = didNumber.slice(len, didNumber.length);
        let session = new SessionManagment(req, res, () => { });
        session.GetSession((error: any, sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT * FROM `did_buy` WHERE `did`='" + didNumber + "'";
            obj.prepare();
            obj.execute((err, did) => {
                if (did.length > 0) {
                    callback('', 1);
                } else {
                    callback('', 1);
                }
            });
        });
    }

    public getState(req: any, res: any, did: any, callback: (err: any, data: any) => void) {
        let len = did.length - 10;
        var npa = did.slice(len, len + 3);
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT loc_state FROM `did_location_info` WHERE `npa`='" + npa + "' LIMIT 1";
        obj1.prepare()
        obj1.execute((err, state) => {
            if (state.length > 0) {
                callback("", state);
            } else {
                callback(err, "")
            }
        });
    }

}

