import e, { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { parseBody, setToZero } from "./markError";
const Str = require('@supercharge/strings');

const makeNumber = (length: number) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}
const makeChar = (length: number) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
}

const makeRanChar = (length: number) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const generatePassword = () => {
    let result: any = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
}

export class Connection extends AppRoute {
    constructor() {
        super();

    }

    getConnections(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                if (sessdata.type == 22) {
                    obj.qrysql = "SELECT iduser, idaccount, name, username, password, status,idendpoint,isDefault, connection_key, tech_prefix, forward, forward_type FROM `endpoint` WHERE `iduser`= " + sessdata.iduser + "";
                }
                else {
                    obj.qrysql = "SELECT e.iduser, e.idaccount, e.idendpoint, e.name, e.username, e.password,  e.isDefault, e.status, e.connection_key, e.tech_prefix, CONCAT(us.firstname,' ',us.lastname) AS fullname, e.forward, e.forward_type,e.port FROM `endpoint`e JOIN `user_profile`us ON us.iduser = e.iduser WHERE e.`idaccount`= " + sessdata.idaccount + " ORDER BY e.`idendpoint` DESC";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // it is not in use
    getDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `did` FROM did_buy";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Did Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // get did history
    getDidHistory(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let condition: any = "";
                let obj = new ModelRawQuery(req, res);
                if (sdata.fromDate || sdata.toDate || sdata.didnumber || sdata.didnpa) {

                    if (sdata.didnumber && sdata.didnpa && sdata.fromDate && sdata.toDate) {
                        condition += 'created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `did` LIKE "%' + sdata.didnumber + '%" AND `npa`="' + sdata.didnpa + '"';
                    }

                    else if (sdata.didnpa && sdata.fromDate && sdata.toDate) {
                        condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `npa`="' + sdata.didnpa + '"';
                    }

                    else if (sdata.didnumber && sdata.fromDate && sdata.toDate) {
                        condition += 'created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `did` LIKE "%' + sdata.didnumber + '%"';
                    }

                    else {
                        condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
                    }

                    obj.qrysql = "SELECT DISTINCT(TRIM('\r' FROM did )) AS did,`provider`,`account_id`,`iduser` FROM `did_log` WHERE " + condition + " ORDER BY `iddidlog` DESC LIMIT 1000";

                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "DID Log Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "No data Found!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // get did history Details
    /*getDidHistoryDetails(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let splitdata = sdata.type.split('_');
        let iduser = splitdata[0];
        let did = splitdata[1];

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT dl.iduser,dl.did,ch.iduser,dl.status,dl.provider,ch.`campaign_name`,ch.`campaign_key`, CONCAT(up.firstname,' ',up.lastname)`customer_name`, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=0  LIMIT 1) sdate, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=1 ORDER BY id DESC LIMIT 1) edate FROM `did_log` dl INNER JOIN `campaign_history` ch ON dl.`iddidlog`=ch.`iddidlog` INNER JOIN `user_profile` up ON up.iduser=dl.iduser WHERE dl.iduser='" + iduser + "' AND dl.did='" + did + "' GROUP BY ch.iddidlog ORDER BY ch.in_use ASC;";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Did Log Detail Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }*/

    getDidHistoryDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let did = sdata.type;
                let obj = new ModelRawQuery(req, res);
                //obj.qrysql = "SELECT DISTINCT dl.iddidlog, dl.iduser, CONCAT(up.firstname,' ',up.lastname)`customer`, dl.created_at `sdate`, dl.updated_at `edate`, IF(dl.created_at IS NOT NULL AND dl.updated_at IS NOT NULL, DATEDIFF(dl.updated_at, dl.created_at), 'N/A') duration FROM `did_log` dl INNER JOIN `user_profile` up ON up.iduser=dl.iduser WHERE dl.did='" + did + "' ORDER BY dl.iddidlog DESC";
                // obj.qrysql = "SELECT up.iduser,CONCAT(up.firstname,' ',up.lastname)`customer`,dl.`description`,dl.created_at AS `date`,CASE WHEN dl.event_type = '1' THEN 'DID Buy' WHEN dl.event_type = '2' THEN 'Import DID' WHEN dl.event_type = '3' THEN 'Auto Renewal Enable' WHEN dl.event_type = '33' THEN 'Auto Renewal Disable' WHEN dl.event_type = '4' THEN 'Connection Enable' WHEN dl.event_type = '44' THEN 'Connection Disable' WHEN dl.event_type = '5' THEN 'Disconnect DID' WHEN dl.event_type = '6' THEN 'Campaign Enable' WHEN dl.event_type = '66' THEN 'Campaign Disable From OSR' WHEN dl.event_type = '67' THEN 'Campaign Disable From SINCH' END AS event_type FROM `did_log` dl LEFT JOIN `user_profile` up ON up.iduser = dl.iduser WHERE dl.did='" + did + "'ORDER BY dl.iddidlog DESC;";
                //obj.qrysql = "SELECT up.iduser,CONCAT(up.firstname,' ',up.lastname)`customer`,dl.`description`,dl.created_at AS `date`,CASE WHEN dl.event_type = '1' THEN 'DID Buy' WHEN dl.event_type = '2' THEN 'Import DID' WHEN dl.event_type = '3' THEN 'Auto Renewal Enable' WHEN dl.event_type = '4' THEN 'Connection Enable' WHEN dl.event_type = '5' THEN 'Disconnect DID from Provider' WHEN dl.event_type = '6' THEN 'DID provisioned TO OSR' WHEN dl.event_type = '7' THEN 'DID provisioned TO SINCH' WHEN dl.event_type = '8' THEN 'Auto Renewal Disable' WHEN dl.event_type = '9' THEN 'Connection Disable' WHEN dl.event_type = '10' THEN 'DID Disconnect From OSR' WHEN dl.event_type = '11' THEN 'DID Disconnect From SINCH' WHEN dl.event_type = '12' THEN 'OSR Provisioning Failed' WHEN dl.event_type = '13' THEN 'SINCH Provisioning Failed' WHEN dl.event_type = '14' THEN 'Connection Changed' WHEN dl.event_type = '15' THEN 'DID Billed' WHEN dl.event_type = '16' THEN 'DID Disconnect Failed From OSR' WHEN dl.event_type = '17' THEN 'DID Disconnect failed From SINCH' END AS event_type FROM `did_log` dl LEFT JOIN `user_profile` up ON up.iduser = dl.iduser WHERE dl.did='" + did + "'ORDER BY dl.iddidlog DESC;";

                obj.qrysql = "SELECT up.iduser,CONCAT(up.firstname,' ',up.lastname)`customer`,dl.`description`,dl.created_at AS `date`,CASE WHEN dl.event_type = '1' THEN 'DID Buy' WHEN dl.event_type = '2' THEN 'Import DID' WHEN dl.event_type = '3' THEN 'Auto Renewal Enable' WHEN dl.event_type = '4' THEN 'Connection Enable' WHEN dl.event_type = '5' THEN 'Disconnect DID from Provider'WHEN dl.event_type = '6' THEN 'DID provisioned TO OSR' WHEN dl.event_type = '7' THEN 'DID provisioned TO SINCH' WHEN dl.event_type = '8' THEN 'Auto Renewal Disable' WHEN dl.event_type = '9' THEN 'Connection Disable' WHEN dl.event_type = '10' THEN 'DID Disconnect From OSR' WHEN dl.event_type = '11' THEN 'DID Disconnect From SINCH' WHEN dl.event_type = '12' THEN 'OSR Provisioning Failed'WHEN dl.event_type = '13' THEN 'SINCH Provisioning Failed' WHEN dl.event_type = '14' THEN 'Connection Changed' WHEN dl.event_type = '15' THEN 'DID Billed' WHEN dl.event_type = '16' THEN 'DID re-provisioned to SINCH' WHEN dl.event_type = '17' THEN 'DID disconnect failed from OSR' WHEN dl.event_type = '18' THEN 'DID disconnect failed from SINCH' WHEN dl.event_type = '19' THEN 'DID provisioning ACCEPTED to SYNIVERSE' WHEN dl.event_type = '20' THEN 'DID provisioning CONFLICT to SYNIVERSE' WHEN dl.event_type = '21' THEN 'DID provisioning PENDING to SYNIVERSE' WHEN dl.event_type = '22' THEN 'DID provisioning DEPLOYED to SYNIVERSE' WHEN dl.event_type = '23' THEN 'DID provisioning DEPLOYED_FAILED / ADD_FAILED to SYNIVERSE' WHEN dl.event_type = '24' THEN 'DID provisioning ADDED to SYNIVERSE' WHEN dl.event_type = '25' THEN 'DID provisioning MARK_DELETE to SYNIVERSE' WHEN dl.event_type = '26' THEN 'DID provisioning DELETE_FAILED / REMOVE_FAILED to SYNIVERSE' WHEN dl.event_type = '27' THEN 'DID provisioning REMOVED to SYNIVERSE' WHEN dl.event_type = '28' THEN 'DID provisioned to INTELLIQUENT' WHEN dl.event_type = '29' THEN 'DID provisioning failed to INTELLIQUENT' WHEN dl.event_type = '30' THEN 'DID provisioning MARK_DELETE to INTELLIQUENT' WHEN dl.event_type = '31' THEN 'Bulk DID Delete Initiated'END AS event_type FROM `did_log` dl LEFT JOIN `user_profile` up ON up.iduser = dl.iduser WHERE dl.did='" + did + "'ORDER BY dl.iddidlog DESC;";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Customer History Detail Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getCampaignHistoryDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let did = sdata.type;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT dl.iduser,dl.did,ch.`campaign_name`,ch.`campaign_key`, GROUP_CONCAT(in_use)`in_use`,(SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=0  LIMIT 1) sdate, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=1 ORDER BY id DESC LIMIT 1) edate FROM `did_log` dl INNER JOIN `campaign_history` ch ON dl.`iddidlog`=ch.`iddidlog` WHERE dl.did='" + did + "' GROUP BY ch.campaign_key ORDER BY ch.id ASC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Campaign History Detail Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    AddCredential(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body;
                if (rdata.Password.length >= 8) {
                    if (rdata.Password.length <= 30) {
                        const passw = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,30}$/;
                        if (rdata.Password.match(passw)) {
                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.filter = null;
                            obj2.nonqrysql = "UPDATE `endpoint` SET `username`='" + parseBody(rdata.Username) + "', `password`='" + parseBody(rdata.Password) + "' WHERE `connection_key`='" + rdata.ConnectionKey + "'";
                            obj2.prepare();
                            obj2.execute((_error: any, allcamp: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res)
                                    objv.prepare({
                                        message: "Connection Add Successfully",
                                        status: 201
                                    })
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res)
                                    objv.prepare({
                                        message: "Something Went Wrong With Connection!",
                                        status: 502
                                    })
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                message: "At least One Uppercase Letter, One Lowercase Letter and At least One Number!",
                                status: 503
                            })
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            message: "Password should be max 30 character long!",
                            status: 504
                        })
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res)
                    objv.prepare({
                        message: "Password should be minimum 8 character long",
                        status: 505
                    })
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    /* AddIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='"+sessdata.idaccount+"'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata: any = [];
                            let da = req.body.IP.split(',');
                            da.forEach((element: any) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element })
                            });
                            rdata.forEach((element: any) => {
                                let obj2 = new ModelRawQuery(req, res);
                                obj2.qrysql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES('" + element.idendpoint + "', '" + element.ip + "')";
                                obj2.prepare();
                                obj2.execute((_error: any, allcamp: any) => {
                                });
                            });
                            let objv = new RawView(res);
                            objv.prepare({ status: 201, message: "IP Add Successfully!" });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Connection Key not found", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    } */
    // used only swagger side

    AddIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` WHERE `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata: any = [];
                            let uipVal = '';
                            let checkIp: boolean = false;
                            let isValidIP: boolean = false;
                            let da = req.body.IP.split(',');
                            const octet = '(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)';
                            const regex = new RegExp(`^${octet}\\.${octet}\\.${octet}\\.${octet}$`);
                            da.forEach((element: any) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element });
                                checkIp = regex.test(element);
                                if (!checkIp) {
                                    isValidIP = true;
                                }
                            });
                            if (!isValidIP) {
                                let unique = da.filter((items: any, i: any, ar: string | any[]) => ar.indexOf(items) === i);
                                let uniqueAllData: any = [...new Map(rdata.map((item: { [x: string]: any; }) => [item['ip'], item])).values()];
                                for (let uip of unique) {
                                    uipVal += "'" + uip + "'" + ','
                                }

                                let checkUniqueIp = uipVal.slice(0, uipVal.length - 1);
                                let obj0 = new ModelRawQuery(req, res);
                                obj0.qrysql = "SELECT `idendpoint`, `ip` FROM `ip_address` WHERE `ip` IN (" + checkUniqueIp + ") && idendpoint!='" + uniqueAllData[0].idendpoint + "'";
                                obj0.prepare();
                                obj0.execute((error: any, data: any) => {
                                    if (error == 1) {
                                        if (data.length > 0) {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "IP Address already exists!",
                                                status: 502
                                            })
                                            objv.execute();
                                        }
                                        else {
                                            if (uniqueAllData.length == rdata.length) {
                                                rdata.forEach((element: any) => {
                                                    let obj2 = new ModelRawNonQuery(req, res);
                                                    obj2.nonqrysql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES('" + element.idendpoint + "', '" + element.ip + "')";
                                                    obj2.prepare();
                                                    obj2.execute((_error: any, allcamp: any) => {
                                                    });
                                                });
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 201, message: "IP Add Successfully!" });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res)
                                                objv.prepare({
                                                    message: "Duplicate Ip Address!",
                                                    status: 503
                                                })
                                                objv.execute();
                                            }
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res)
                                        objv.prepare({
                                            message: "Something Went Wrong with Ip Address!",
                                            status: 504
                                        })
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "IPaddress format is Incorrect", status: 505 });
                                objv.execute();
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data not found", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    /* UpdateIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata: any = [];
                            let da = req.body.IP.split(',');
                            da.forEach((element: any) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element })
                            });
                            let obj3 = new ModelRawQuery(req, res);
                            obj3.qrysql = "delete from ip_address where idendpoint = '" + rdata[0].idendpoint + "'";
                            obj3.prepare();
                            obj3.execute((derror: any, allcamp: any) => {
                                if (derror == 1) {
                                    let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                    rdata.forEach((element: any) => {
                                        sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                    });
                                    sql = sql.substring(0, sql.length - 1);
                                    let obj2 = new ModelRawQuery(req, res);
                                    obj2.qrysql = sql;
                                    obj2.prepare();
                                    obj2.execute((_error: any, allcamp: any) => {
                                        if (_error == 1) {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "IP Updated Successfully!",
                                                status: 201
                                            })
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!",
                                                status: 502
                                            })
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                    rdata.forEach((element: any) => {
                                        sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                    });
                                    sql = sql.substring(0, sql.length - 1);
                                    let obj2 = new ModelRawQuery(req, res);
                                    obj2.qrysql = sql;
                                    obj2.prepare();
                                    obj2.execute((_error: any, allcamp: any) => {
                                        if (_error == 1) {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "IP Updated Successfully!",
                                                status: 201
                                            })
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!",
                                                status: 502
                                            })
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        } else {
                            let objv = new RawView(res)
                            objv.prepare({
                                message: "Connection Key not found!",
                                status: 404
                            })
                            objv.execute();
                        }
                    } else {
                        let objv = new RawView(res)
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    } */

    UpdateIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` WHERE `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata: any = [];
                            let da = req.body.IP.split(',');
                            let uipVal = '';
                            let checkIp: boolean = false;
                            let isValidIP: boolean = false;
                            const octet = '(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)';
                            const regex = new RegExp(`^${octet}\\.${octet}\\.${octet}\\.${octet}$`);
                            da.forEach((element: any) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element });
                                checkIp = regex.test(element);
                                if (!checkIp) {
                                    isValidIP = true;
                                }
                            });
                            if (!isValidIP) {
                                let unique = da.filter((items: any, i: any, ar: string | any[]) => ar.indexOf(items) === i);
                                let uniqueAllData: any = [...new Map(rdata.map((item: { [x: string]: any; }) => [item['ip'], item])).values()];
                                for (let uip of unique) {
                                    uipVal += "'" + uip + "'" + ','
                                }
                                let checkUniqueIp = uipVal.slice(0, uipVal.length - 1);
                                let obj0 = new ModelRawQuery(req, res);
                                obj0.qrysql = "SELECT `idendpoint`, `ip` FROM `ip_address` WHERE `ip` IN (" + checkUniqueIp + ") && idendpoint!='" + uniqueAllData[0].idendpoint + "'";
                                obj0.prepare();
                                obj0.execute((error: any, data: any) => {
                                    if (error == 1) {
                                        if (data.length > 0) {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "IP Address already exists!",
                                                status: 502
                                            })
                                            objv.execute();
                                        }
                                        else {
                                            if (uniqueAllData.length == rdata.length) {
                                                let obj3 = new ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "DELETE FROM ip_address WHERE idendpoint = '" + rdata[0].idendpoint + "'";
                                                obj3.prepare();
                                                obj3.execute((derror: any, allcamp: any) => {
                                                    if (derror == 1) {
                                                        let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                                        rdata.forEach((element: any) => {
                                                            sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                                        });
                                                        sql = sql.substring(0, sql.length - 1);
                                                        let obj2 = new ModelRawNonQuery(req, res);
                                                        obj2.nonqrysql = sql;
                                                        obj2.prepare();
                                                        obj2.execute((_error: any, allcamp: any) => {
                                                            if (_error == 1) {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "IP Updated Successfully!",
                                                                    status: 201
                                                                })
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "Something Went Wrong With Connection!",
                                                                    status: 502
                                                                })
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "Something Went Wrong With Update IP!",
                                                            status: 506
                                                        })
                                                        objv.execute();
                                                        /* let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                                        rdata.forEach((element: any) => {
                                                            sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                                        });
                                                        sql = sql.substring(0, sql.length - 1);
                                                        let obj2 = new ModelRawQuery(req, res);
                                                        obj2.qrysql = sql;
                                                        obj2.prepare();
                                                        obj2.execute((_error: any, allcamp: any) => {
                                                            if (_error == 1) {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "IP Updated Successfully!",
                                                                    status: 201
                                                                })
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "Something Went Wrong With Connection!",
                                                                    status: 502
                                                                })
                                                                objv.execute();
                                                            }
                                                        }); */
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res)
                                                objv.prepare({
                                                    message: "Duplicate Ip Address!",
                                                    status: 503
                                                })
                                                objv.execute();
                                            }
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res)
                                        objv.prepare({
                                            message: "Something Went Wrong with Ip Address!",
                                            status: 504
                                        })
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "IPaddress format is Incorrect", status: 505 });
                                objv.execute();
                            }
                        } else {
                            let objv = new RawView(res)
                            objv.prepare({
                                message: "Data not found!",
                                status: 404
                            })
                            objv.execute();
                        }
                    } else {
                        let objv = new RawView(res)
                        objv.prepare({
                            message: "Something Went Wrong With Connection!!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    UpdataFqdn(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let obj2 = new ModelRawNonQuery(req, res);
                            let rdata;
                            rdata = req.body;
                            obj2.filter = null;
                            obj2.nonqrysql = "UPDATE routing_profile SET FQDN_type='" + rdata.type + "', FQDN_user='" + rdata.user + "' WHERE idendpoint='" + result[0].idendpoint + "'";
                            obj2.prepare();
                            obj2.execute((_error: any, allcamp: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res)
                                    obj2.prepare();
                                    objv.prepare({
                                        status: 201,
                                        message: "Updated Successfully"
                                    })
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res)
                                    obj2.prepare();
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong With Connection!"
                                    })
                                    objv.execute();
                                }
                            });
                        } else {
                            let objv2 = new RawView(res)
                            objv2.prepare({
                                status: 404,
                                message: "Connection Key not found"
                            })
                            objv2.execute();
                        }
                    } else {
                        let objv2 = new RawView(res)
                        objv2.prepare({
                            status: 502,
                            message: "Something went wrong with connection!"
                        })
                        objv2.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    AddForwardAll(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var rdata: any = [];
                rdata = req.body.data;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let obj2 = new ModelRawNonQuery(req, res);
                            let rdata = [];
                            rdata = req.body;
                            let number;
                            switch (rdata.forward_type) {
                                case "Sip uri":
                                    number = 1;
                                    break;
                                case "Number":
                                    number = 2;
                                    break;
                                case "IP Address":
                                    number = 3;
                                    break;
                                case "Group":
                                    number = 4;
                                    break;
                                case "Extension":
                                    number = 5;
                                    break;
                            }
                            obj2.filter = null;
                            obj2.nonqrysql = "UPDATE `endpoint` SET `forward_type`='" + number + "',`forward`='" + rdata.forward + "' WHERE `connection_key`='" + rdata.ConnectionKey + "' AND `idaccount`=" + sessdata.idaccount + "";
                            obj2.prepare();
                            obj2.execute((_error: any, allcamp: any) => {
                                if (_error == 1) {
                                    if (allcamp.affectedRows > 0) {
                                        let objv = new RawView(res)
                                        objv.prepare({
                                            message: "Connection Updated Successfully",
                                            status: 201
                                        })
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res)
                                        objv.prepare({
                                            message: "Connection Not Updated Successfully",
                                            status: 503
                                        })
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView(res)
                                    objv.prepare({
                                        message: "Something Went Wrong With Connection!",
                                        status: 502
                                    })
                                    objv.execute();
                                }
                            });
                        } else {
                            let objv2 = new RawView(res)
                            objv2.prepare({
                                status: 404,
                                message: "Connection Key not found"
                            })
                            objv2.execute();
                        }
                    } else {
                        let objv2 = new RawView(res)
                        objv2.prepare({
                            status: 504,
                            message: "Something went wrong with connection!"
                        })
                        objv2.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    AddHookUrl(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idendpoint` FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "' AND `idaccount`= '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_errorChk: any, resLt: any) => {
                    if (_errorChk == 1) {
                        if (resLt.length > 0) {
                            let type: any;
                            let priority: any;
                            switch (sdata.Type) {
                                case "CDR Url":
                                    type = "cdr";
                                    priority = '0';
                                    break;
                                case "SMS Receive":
                                    type = "sms-received";
                                    priority = '1';
                                    break;
                                case "SMS Status":
                                    type = "sms-status";
                                    priority = '2';
                                    break;
                            }
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND `type`= '" + type + "'";
                            obj1.prepare();
                            obj1.execute((_errorgt: any, result: any) => {
                                if (_errorgt == 1) {
                                    if (result.length > 0) {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE hooksetting SET url='" + sdata.Urls + "' WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND type='" + type + "'";
                                        obj.prepare();
                                        obj.execute((hook_error: any, hook_result: any) => {
                                            if (hook_error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Webhook Url Inserted Successfully", status: 201 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something went wrong with Insert Urls!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let obj11 = new ModelRawNonQuery(req, res);
                                        obj11.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES ((SELECT idaccount FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "'), (SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') , '" + type + "' , '" + sdata.Urls + "', " + setToZero(priority) + " , '')";
                                        obj11.prepare();
                                        obj11.execute((_error: any, data: any) => {
                                            if (_error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Webhook Url Inserted Successfully", status: 201 });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something went wrong with Insert Urls!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv2 = new RawView(res)
                                    objv2.prepare({
                                        status: 504,
                                        message: "Something went wrong with hook data!"
                                    })
                                    objv2.execute();
                                }
                            });
                        }
                        else {
                            let objv2 = new RawView(res)
                            objv2.prepare({
                                status: 404,
                                message: "Connection Key not found"
                            })
                            objv2.execute();
                        }
                    }
                    else {
                        let objv2 = new RawView(res)
                        objv2.prepare({
                            status: 504,
                            message: "Something went wrong with connection!"
                        })
                        objv2.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    UpdateHookUrl(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idendpoint` FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "' AND `idaccount`= '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_errorChk: any, resLt: any) => {
                    if (_errorChk == 1) {
                        if (resLt.length > 0) {
                            let type;
                            switch (sdata.Type) {
                                case "CDR Url":
                                    type = "cdr";
                                    break;
                                case "SMS Receive":
                                    type = "sms-received";
                                    break;
                                case "SMS Status":
                                    type = "sms-status";
                                    break;
                            }
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE hooksetting SET url='" + sdata.Urls + "' WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND type='" + type + "'";
                            obj.prepare();
                            obj.execute((hook_error: any, hook_result: any) => {
                                if (hook_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Webhook Urls Updated Successfully", status: 201 });
                                    objv.execute();
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something went wrong with connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv2 = new RawView(res)
                            objv2.prepare({
                                status: 404,
                                message: "Connection Key not found"
                            })
                            objv2.execute();
                        }
                    }
                    else {
                        let objv2 = new RawView(res)
                        objv2.prepare({
                            status: 504,
                            message: "Something went wrong with connection!"
                        })
                        objv2.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    getInbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT ani, dnis, ringback_timeout, answer_timeout, enable_prack, enable_privacy_zone, enable_sip_compact,sip_uri,media_type,inbound_key, recording FROM inbound WHERE idendpoint=" + sdata.type + "";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Inbound Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getOutbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT outbound_key, caller_id, recording,  uuid_detail, country, initiated_by, voice_profile, type, media_type, generate_ringback, enable_ringback, amd FROM outbound WHERE idendpoint=" + sdata.type + "";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Outbound Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // currently this function not in use
    getConnectionData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT idrouting_profile, idendpoint, encode_header, DTMF_type, enable_on_net, comfort_noise, FQDN_type, FQDN_user FROM routing_profile";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Routing Profile Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavialable!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getUrlData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idhooksetting, idaccount, idendpoint, type, url, priority, sms_key FROM `hooksetting` WHERE `idendpoint`=" + sdata.type + " AND `idaccount`=" + sessdata.idaccount + "";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Hooksetting Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    getExpertSetting(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT encode_header, enable_on_net, DTMF_type, comfort_noise FROM `routing_profile` WHERE `idendpoint`=" + sdata.type + "";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Routing Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    saveConnection(req: Request, res: Response, next: NextFunction) {
        const connection_key = Str.random(30);
        const randDigit = connection_key.slice(4, 12);
        var rdata: any = [];
        rdata = req.body.data != undefined ? req.body.data : req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `idendpoint` FROM endpoint where `idaccount`='" + sessdata.idaccount + "' AND name = '" + parseBody(rdata.connectionName) + "'";
                obj1.prepare();
                obj1.execute((_error: any, getConn: any) => {
                    if (_error == 1) {
                        if (getConn.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Connection Already Exists!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            let obj8 = new ModelRawQuery(req, res);
                            obj8.qrysql = "SELECT `idendpoint` FROM endpoint where isDefault = 'true'";
                            obj8.prepare();
                            obj8.execute((cerror: any, getConn1: any) => {
                                if (cerror == 1) {
                                    var isDefault: any;
                                    if (getConn1.length > 0) {
                                        isDefault = "false";
                                    }
                                    else {
                                        isDefault = "true";
                                    }

                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.filter = null;
                                    let username = Math.random().toString(36).substr(2, 11);
                                    //let username = sessdata.username + val;
                                    //let password = randDigit;
                                    let password = generatePassword();
                                    const inbound_key = Str.random(30);
                                    const outbound_key = Str.random(30);
                                    obj2.nonqrysql = "CALL addconnection('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + rdata.connectionName + "', '" + connection_key + "', '" + username + "', '" + password + "', '" + inbound_key + "', '" + outbound_key + "', '" + isDefault + "')";
                                    obj2.prepare();
                                    obj2.execute((__error: any, allcamp: any) => {
                                        if (__error == 1) {
                                            let newData = allcamp[0];
                                            delete newData[0].idendpoint
                                            delete newData[0].iduser
                                            delete newData[0].idaccount
                                            delete newData[0].isDeleted
                                            delete newData[0].isbalance
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                data: newData[0],
                                                message: "Connection Saved Successfully!",
                                                status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                data: allcamp[0],
                                                message: "Something Went Wrong With Connection",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With DB Connection!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With DB Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    saveConnectionIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const connection_key = Str.random(30);
                const randDigit = connection_key.slice(4, 12);
                var rdata: any = [];
                rdata = req.body.data != undefined ? req.body.data : req.body;
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT idendpoint FROM endpoint where `idaccount`=" + sessdata.idaccount + " AND name = '" + parseBody(rdata.connectionName) + "'";
                obj1.prepare();
                obj1.execute((_error: any, getConn: any) => {
                    if (_error == 1) {
                        if (getConn.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Connection Already Exists!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            let obj8 = new ModelRawQuery(req, res);
                            obj8.qrysql = "SELECT `idendpoint` FROM endpoint where isDefault = 'true'";
                            obj8.prepare();
                            obj8.execute((cerror: any, getConn1: any) => {
                                if (cerror == 1) {
                                    var isDefault: any;
                                    if (getConn1.length > 0) {
                                        isDefault = "false";
                                    }
                                    else {
                                        isDefault = "true";
                                    }

                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.filter = null;
                                    let username = Math.random().toString(36).substr(2, 11);
                                    //let username = sessdata.username + val;
                                    //let password = randDigit;
                                    let password = generatePassword();
                                    const inbound_key = Str.random(30);
                                    const outbound_key = Str.random(30);
                                    obj2.nonqrysql = "CALL addconnection(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + parseBody(rdata.connectionName) + "', '" + connection_key + "', '" + username + "', '" + password + "', '" + inbound_key + "', '" + outbound_key + "', '" + isDefault + "')";
                                    obj2.prepare();
                                    obj2.execute((__error: any, allcamp: any) => {
                                        if (__error == 1) {
                                            let newData = allcamp[0];
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                data: newData[0],
                                                message: "Connection Saved Successfully!",
                                                status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                data: allcamp[0],
                                                message: "Something Went Wrong With Connection",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With DB Connection!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With DB Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    getIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT id_ipaddress,idendpoint,ip FROM ip_address WHERE idendpoint=" + sdata.type + "";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "IP Address Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service unavailable!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let idendpoint:any = req.query.id;
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "DELETE FROM inbound WHERE idendpoint = " + idendpoint + "";
                obj0.prepare();
                obj0.execute((_error: any, resInbound: any) => {
                    console.log("Connection's inbound data has Deleted from inbound table");
                });
                let obj1 = new ModelRawNonQuery(req, res);
                obj1.nonqrysql = "DELETE FROM outbound WHERE idendpoint = " + idendpoint + "";
                obj1.prepare();
                obj1.execute((_error: any, resOutbound: any) => {
                    console.log("Connection's outbound data has Deleted from outbound table");
                });
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "DELETE FROM ip_address WHERE idendpoint = " + idendpoint + "";
                obj2.prepare();
                obj2.execute((_error: any, resIP: any) => {
                    console.log("Connection's ip_address data has Deleted from ip_address table");
                });
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = "DELETE FROM routing_profile WHERE idendpoint = " + idendpoint + "";
                obj3.prepare();
                obj3.execute((_error: any, resRP: any) => {
                    console.log("Connection's  routing_profile data has Deleted from routing_profile table");
                });
                let obj4 = new ModelRawNonQuery(req, res);
                obj4.nonqrysql = "DELETE FROM hooksetting WHERE idendpoint = " + idendpoint + "";
                obj4.prepare();
                obj4.execute((_error: any, resHS: any) => {
                    console.log("Connection's hooksetting data has Deleted from hooksetting table");
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM endpoint WHERE idendpoint = " + idendpoint + "";
                obj.prepare();
                obj.execute((_error: any, lastid: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Connection Deleted Successfully!", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", data: lastid[0], status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    saveIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var rdata: any = [];
                rdata = req.body.data.IPArr;
                rdata.forEach((element: any) => {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO ip_address (`iduser`, `idaccount`, `idendpoint`, `ip`) VALUES('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + element.idendpoint + "', '" + element.ip + "')";
                    obj2.prepare();
                    obj2.execute((_error: any, allcamp: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "IP Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    save_smsOutbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let obj2 = new ModelRawQuery(req, res);
                obj2.filter = null;
                obj2.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type`='" + rdata.type + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, response: any) => {
                    if (_error == 1) {
                        if (response.length > 0) {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE hooksetting SET `url`='" + rdata.delivery_url + "' WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type` = '" + rdata.type + "' AND `idaccount`='" + sessdata.idaccount + "'";
                            obj3.execute((error: any, result: any) => {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Updated Successfully!", status: 201 });
                                objv.execute();
                            });
                        }
                        else {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "INSERT INTO hooksetting(`idaccount`, `idendpoint`, `type`, `url`) VALUES ('" + sessdata.idaccount + "', '" + rdata.idendpoint + "', '" + rdata.type + "', '" + rdata.delivery_url + "')";
                            obj3.execute((error: any, result: any) => {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Saved Successfully!", status: 201 });
                                objv.execute();
                            });
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: response, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    save_smsInbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let obj2 = new ModelRawQuery(req, res);
                obj2.filter = null;
                obj2.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type`='" + rdata.type + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, response: any) => {
                    if (_error == 1) {
                        if (response != null && response != '') {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE hooksetting SET `url`='" + rdata.url + "' WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type` = '" + rdata.type + "'  AND `idaccount`='" + sessdata.idaccount + "'";
                            obj3.execute((__error: any, result: any) => {
                                if (__error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "Updated Successfully", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "Updated Successfully", status: 502 });
                                    objv.execute();
                                }
                            });
                        } else {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "INSERT INTO hooksetting(`idaccount`, `idendpoint`, `type`, `url`) VALUES ('" + sessdata.idaccount + "', '" + rdata.idendpoint + "', '" + rdata.type + "', '" + rdata.url + "')";
                            obj3.execute((__error: any, result: any) => {
                                if (__error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "Saved Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }


    saveUrls(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                let result: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((ele: any) => {
                        result[ele.field] = ele.value;
                    });
                    let sms_key = Str.random(30);
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES(" + sessdata.idaccount + ", " + result.idendpoint + ", '" + result.type + "', '" + result.url + "', " + setToZero(result.ID) + ", '" + sms_key + "')";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Updated Successfully", status: 201 });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    deleteIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM ip_address WHERE id_ipaddress = '" + req.query.id + "'";
                obj.prepare();
                obj.execute((_error: any, lastid: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "IP Deleted Successfully.", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateInbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE inbound SET dnis='" + rdata.dnis + "', ani='" + rdata.ani + "', ringback_timeout='" + rdata.ringback_timeout + "', answer_timeout='" + rdata.answer_timeout + "', channel_limit='" + rdata.channel_limit + "', sip_uri='" + rdata.sip_uri + "', media_type='" + rdata.media_type + "', enable_sip_compact='" + rdata.enable_sip_compact + "', enable_privacy_zone='" + rdata.enable_privacy_zone + "', enable_prack='" + rdata.enable_prack + "', recording='" + rdata.recording + "' WHERE idendpoint=" + rdata.idendpoint + "";
                obj2.prepare();
                obj2.execute((_error: any, data: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: data,
                            message: "Inbound Updated Successfully!",
                            status: 201
                        })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: data,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateOutbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let ntype = req.body.data.type;
                let uuid: any = '';
                if (rdata.uuid_detail && rdata.uuid_detail != 'null') { uuid = rdata.uuid_detail; } else { uuid = ''; }
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE outbound SET caller_id='" + rdata.caller_id + "', type='" + ntype + "', country='" + rdata.country + "', channel_limit='" + rdata.channel_limit + "', initiated_by='" + rdata.initiated_by + "', voice_profile='" + rdata.voice_profile + "', media_type='" + rdata.media_type + "', enable_ringback='" + rdata.ringback + "', generate_ringback='" + rdata.tone + "', recording='" + rdata.recording + "', uuid_detail='" + parseBody(uuid) + "', amd='" + rdata.amd + "' WHERE idendpoint=" + rdata.idendpoint + "";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Outbound Updated Successfully",
                            status: 201
                        })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateConnectionName(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT * FROM endpoint where name = '"+rdata.connectionName+"'";
                // obj.prepare();
                // obj.execute((error: any, result: any) => {
                //     if(result[0]){
                //         let objv = new RawView(res);
                //         objv.prepare({  
                //             message: "Connection Already Exists!" 
                //         });
                //         objv.execute();
                //     }
                //     else{
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `name`='" + parseBody(rdata.connectionName) + "', `brandId`='" + rdata.brand + "', `campaignId`='" + rdata.campaign + "'  WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Connection Name Updated Successfully",
                            status: 201
                        })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection Name!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
                //     }
                // });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateConnTeckPre(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `tech_prefix`='" + rdata.tech_prefix + "' WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                obj2.prepare();
                obj2.execute((_error: any, trechPre: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        objv.prepare({ data: trechPre, message: "Tech Prefix Updated Successfully!", status: 201 })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            data: trechPre, message: "Something Went Wrong With Tech Prefix!", status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateConnUserPass(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `username`='" + parseBody(rdata.username) + "', `password`='" + parseBody(rdata.password) + "' WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                obj2.prepare();
                obj2.execute((_error: any, credentials: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        objv.prepare({ error: 0, data: credentials, message: "Credentials Updated Successfully!", status: 201 })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: 0, data: credentials, message: "Something Went Wrong With Credentials!", status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateConnInboundCall(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `endpoint` SET `forward_type`='" + rdata.forward_type + "',`forward`='" + parseBody(rdata.forward) + "', `port` = CASE WHEN `forward_type` IN (1, 2) THEN 0 ELSE "+ setToZero(rdata.port) + " END WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                obj2.prepare();
                obj2.execute((_error: any, credentials: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        objv.prepare({ error: 0, data: credentials, message: "Forwards Updated Successfully!", status: 201 })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: 0, data: credentials, message: "Something Went Wrong With Forwords!", status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }

    updateStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE endpoint SET status='" + req.body.data + "' WHERE idendpoint=" + req.query.id + " AND `idaccount`=" + sessdata.idaccount + ""
                obj.prepare();
                obj.execute((_error: any, lastid: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Status Update Successfully.", data: lastid[0], status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Status Update Successfully.", data: lastid, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                let techPrefix: any;
                if (rdata.tech_prefix) {
                    techPrefix = rdata.tech_prefix;
                } else {
                    techPrefix = '';
                }
                obj2.nonqrysql = "UPDATE `endpoint` SET `name`='" + parseBody(rdata.connectionName) + "', `username`='" + rdata.username + "', `password`='" + rdata.password + "', `tech_prefix`='" + techPrefix + "',`forward_type`='" + rdata.forward_type + "',`forward`='" + rdata.forward + "', `brandId`='" + rdata.brand + "', `campaignId`='" + rdata.campaign + "' WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Connection Updated Successfully",
                            status: 201
                        })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateFQDN(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata;
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE routing_profile SET FQDN_type='" + rdata.type + "', FQDN_user='" + rdata.user + "' WHERE idendpoint='" + rdata.idendpoint + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 201,
                            message: "Updated Successfully"
                        })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong With Connection!"
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    // updateIP(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let rdata: any = [];
    //             rdata = req.body.data.IPArr
    //             let obj3 = new ModelRawQuery(req, res);
    //             obj3.qrysql = "delete from ip_address where idendpoint = '" + rdata[0].idendpoint + "'";
    //             obj3.prepare();
    //             obj3.execute((derror: any, allcamp: any) => {
    //                 if (derror == 1) {
    //                     let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
    //                     rdata.forEach((element: any) => {
    //                         sql += "('" + element.idendpoint + "','" + element.ip + "'),"
    //                     });
    //                     sql = sql.substring(0, sql.length - 1);
    //                     let obj2 = new ModelRawQuery(req, res);
    //                     obj2.qrysql = sql;
    //                     obj2.prepare();
    //                     obj2.execute((_error: any, allcamp: any) => {
    //                         if (_error == 1) {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "IP Updated Successfully!",
    //                                 status: 201
    //                             })
    //                             objv.execute();
    //                         }
    //                         else {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "Duplicate Entry Please Try Again!",
    //                                 status: 1062
    //                             })
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //                 else {
    //                     let sql = "INSERT INTO ip_address (`iduser`, `idaccount`,`idendpoint`, `ip`) VALUES ";
    //                     rdata.forEach((element: any) => {
    //                         sql += "('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + element.idendpoint + "','" + element.ip + "'),"
    //                     });
    //                     sql = sql.substring(0, sql.length - 1);
    //                     let obj2 = new ModelRawQuery(req, res);
    //                     obj2.qrysql = sql;
    //                     obj2.prepare();
    //                     obj2.execute((_error: any, allcamp: any) => {
    //                         if (_error == 1) {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "IP Updated Successfully!",
    //                                 data: allcamp,
    //                                 status: 201
    //                             })
    //                             objv.execute();
    //                         }
    //                         else {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "Something Went Wrong With Connection!",
    //                                 status: 502
    //                             })
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //             });
    //             // obj2.filter = null;
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }

    updateIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data.IPArr
                let ipVal = '';
                let uipVal = '';
                let uniqueIp: any = [];
                let uniqueData: any = [];
                for (let ip of rdata) {
                    ipVal += "'" + ip.ip + "'" + ','
                }
                rdata.forEach((element: any) => {
                    uniqueIp.push(element.ip),
                        uniqueData.push({ "idendpoint": element.idendpoint, "ip": element.ip })
                });
                let unique = uniqueIp.filter((items: any, i: any, ar: string | any[]) => ar.indexOf(items) === i);
                let uniqueAllData: any = [...new Map(uniqueData.map((item: { [x: string]: any; }) => [item['ip'], item])).values()];
                for (let uip of unique) {
                    uipVal += "'" + uip + "'" + ','
                }

                let checkUniqueIp = uipVal.slice(0, uipVal.length - 1);
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `idendpoint`, `ip` from `ip_address` WHERE `ip` IN (" + checkUniqueIp + ") && idendpoint!=" + uniqueAllData[0].idendpoint + "";
                obj0.prepare();
                obj0.execute((error: any, data: any) => {
                    if (error == 1) {
                        if (data.length > 0) {
                            let objv = new RawView(res)
                            objv.prepare({
                                message: "IP Address already exists!",
                                status: 502
                            })
                            objv.execute();
                        }
                        else {
                            if (uniqueAllData.length == uniqueData.length) {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "DELETE from ip_address WHERE idendpoint = " + uniqueAllData[0].idendpoint + "";
                                obj3.prepare();
                                obj3.execute((derror: any, delRes: any) => {
                                    if (derror == 1) {
                                        let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                        uniqueAllData.forEach((element: any) => {
                                            sql += "(" + element.idendpoint + ",'" + element.ip + "'),"
                                        });
                                        sql = sql.substring(0, sql.length - 1);
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = sql;
                                        obj2.prepare();
                                        obj2.execute((_error: any, insertRes: any) => {
                                            if (_error == 1) {
                                                let obj1 = new ModelRawQuery(req, res);
                                                obj1.qrysql = "SELECT ip,id_ipaddress FROM `ip_address` WHERE `idendpoint`=" + uniqueAllData[0].idendpoint + "";
                                                obj1.prepare();
                                                obj1.execute((_errorget: any, resultenp: any) => {
                                                    if (_errorget) {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "IP Inserted Successfully!",
                                                            status: 201,
                                                            dataip: resultenp
                                                        })
                                                        objv.execute();
                                                    } else {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "IP Not Inserted!",
                                                            status: 502,
                                                            dataip: resultenp
                                                        })
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res)
                                                objv.prepare({
                                                    message: "IP Address already exists!!",
                                                    status: 502
                                                })
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res)
                                        objv.prepare({
                                            message: "Something Went Wrong With Update IP!",
                                            status: 506
                                        })
                                        objv.execute();
                                        /* let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                        rdata.forEach((element: any) => {
                                            sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                        });
                                        sql = sql.substring(0, sql.length - 1);
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.qrysql = sql;
                                        obj2.prepare();
                                        obj2.execute((_error: any, allcamp: any) => {
                                            if (_error == 1) {
                                                let obj1 = new ModelRawQuery(req, res);
                                                obj1.qrysql = "SELECT ip FROM `ip_address` WHERE `idendpoint`='" + rdata[0].idendpoint + "'";
                                                obj1.prepare();
                                                obj1.execute((_errorget: any, resultenp: any) => {
                                                    if (_errorget == 1) {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "IP Inserted Successfully!",
                                                            status: 201,
                                                            dataip: resultenp
                                                        })
                                                        objv.execute();
                                                    } else {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "IP Not Inserted!",
                                                            status: 502
                                                        })
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res)
                                                objv.prepare({
                                                    message: "Something Went Wrong With Connection!",
                                                    status: 502
                                                })
                                                objv.execute();
                                            }
                                        }); */
                                    }
                                });
                                //obj2.filter = null;
                            }
                            else {
                                let objv = new RawView(res)
                                objv.prepare({
                                    message: "Duplicate Ip Address!",
                                    status: 502
                                })
                                objv.execute();
                            }
                        }
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            message: "Something Went Wrong with Ip Address!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateUrls(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                let result: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((ele: any) => {
                        result[ele.field] = ele.value;
                    });
                    // if(result.idhooksetting){
                    if (result.url == null) {
                        result.url = '';
                    }
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE hooksetting SET url='" + parseBody(result.url) + "' WHERE idendpoint=" + result.idendpoint + " AND type='" + result.type + "' AND `idaccount`=" + sessdata.idaccount + "";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                    // }
                    // else{
                    //     let sms_key = Str.random(30);
                    //     let obj = new ModelRawNonQuery(req, res);
                    //     obj.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES('" + sessdata.idaccount + "', '" +result.idendpoint + "', '" + result.type + "', '" + result.url + "', '" + result.ID + "', '"+sms_key+"')";
                    //     obj.prepare();
                    //     obj.execute((error: any, data: any) => {
                    //     });
                    // }
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Updated Successfully", status: 201 });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    insertUrlsData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let idendpoint = req.body.data;
                // delete
                // let obj0 = new ModelRawQuery(req, res);
                // obj0.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint`='"+ idendpoint +"'";
                // obj0.prepare();
                // obj0.execute((_errorgt: any, resultchk: any) => {
                //     if(resultchk.length <= 2){
                //         let obj00 = new ModelRawQuery(req, res);
                //         obj00.qrysql = "delete from hooksetting where idendpoint = '" + idendpoint + "'";
                //         obj00.prepare();
                //         obj00.execute((derror: any, allcamp: any) => {
                // insert
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint`='" + idendpoint + "' AND `type`= 'cdr' AND `idaccount`='" + sessdata.idaccount + "'";
                obj1.prepare();
                obj1.execute((_errorgt: any, resultcdr: any) => {

                    if (resultcdr == '') {
                        let obj11 = new ModelRawNonQuery(req, res);
                        obj11.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  (" + sessdata.idaccount + ", " + idendpoint + " , 'cdr' , '', 0 , '')";
                        obj11.prepare();
                        obj11.execute((_error: any, data: any) => { });
                    }
                });
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint`='" + idendpoint + "' AND `type`= 'sms-status'";
                obj2.prepare();
                obj2.execute((_errorgt: any, resultstatus: any) => {

                    if (resultstatus == '') {
                        let obj22 = new ModelRawNonQuery(req, res);
                        obj22.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  (" + sessdata.idaccount + ", " + idendpoint + " , 'sms-status' , '', 2 , '')";
                        obj22.prepare();
                        obj22.execute((_error: any, data: any) => { });
                    }
                });
                let obj3 = new ModelRawQuery(req, res);
                obj3.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint`=" + idendpoint + " AND `type`= 'sms-received'";
                obj3.prepare();
                obj3.execute((errorgtreceived: any, resultreceived: any) => {

                    if (resultreceived == '') {
                        let obj33 = new ModelRawNonQuery(req, res);
                        obj33.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  (" + sessdata.idaccount + ", " + idendpoint + " , 'sms-received' , '', 1 , '')";
                        obj33.prepare();
                        obj33.execute((_error: any, data: any) => { });
                    }
                });
                //});
                let objv = new RawView(res);
                objv.prepare({ error: 0, message: "Updated Successfully", status: 201 })
                objv.execute();
                //     }
                // });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateExpertSetting(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE routing_profile SET encode_header='" + rdata.Encode + "', comfort_noise='" + rdata.enable_comfort + "', enable_on_net='" + rdata.enable_on_net + "', DTMF_type='" + rdata.DTMF_type + "' WHERE idendpoint=" + rdata.idendpoint + "";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Updated Successfully",
                            status: 201
                        })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        obj2.prepare();
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    public updatePassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE endpoint SET username='" + rdata.password + "' WHERE idendpoint='" + rdata.idendpoint + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, upPass: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        objv.prepare({ error: 1, data: upPass, message: "Updated Successfully", status: 201 })
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({ error: 0, message: "Something Went Wrong With update Password!", status: 502 })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data available!");
                objv.execute();
            }
        });
    }

    listConnectionsSwagger(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let resultAll: any = [];
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL ListConnection('" + sessdata.idaccount + "')";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            for (let r of result[0]) {
                                delete r.idendpoint
                                resultAll.push(r);
                            }
                            let objv = new RawView(res);
                            objv.prepare({ data: [resultAll], message: "List Connection Fetched!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: [], message: "No Data Found!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    listConnectionsPanel(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL ListConnection('" + sessdata.idaccount + "')";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "List Connection Fetched!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    UserDefaultConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                if (sessdata.type == 22) {
                    obj.qrysql = "SELECT idendpoint, connection_key, name, idaccount,iduser FROM `endpoint` WHERE `isDefault`='true' AND `iduser`= '" + sessdata.iduser + "'";
                }
                else {
                    obj.qrysql = "SELECT e.idendpoint, e.connection_key, e.name, e.idaccount,e.iduser, CONCAT(us.firstname,' ',us.lastname) AS fullname FROM `endpoint`e JOIN `user_profile`us ON us.iduser = e.iduser WHERE `isDefault`='true' AND e.`idaccount`= '" + sessdata.idaccount + "'";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Single Connection Fetched!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    AllKeyByConnKey(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22) {
                    let key = req.query.type;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT endpoint.idendpoint,endpoint.connection_key, inbound.inbound_key, outbound.outbound_key FROM endpoint JOIN inbound ON endpoint.idendpoint = inbound.idendpoint JOIN outbound ON endpoint.idendpoint = outbound.idendpoint WHERE `connection_key`= '" + key + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Key Fetched!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Key!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavialable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    setDefaultConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.body;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='false' WHERE `iduser`=" + sdata.data.split('-')[1] + " AND `idaccount`=" + sessData.idaccount + "";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='true' WHERE `idendpoint`=" + sdata.data.split('-')[0] + " AND `idaccount`=" + sessData.idaccount + "";
                        obj.prepare();
                        obj.execute((__error: any, _result: any) => {
                            if (__error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Default Connection Changed Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Default Connection Not Changed DB Error!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

}