"use strict";
const multer1 = require('multer');
import { NextFunction } from 'express';
import { UploadDirectory } from '../config/setting.config';

const MIME_TYPE_MAP1: any = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx',

    // Images
    'image/bmp': 'bmp',
    'image/gif; version="87a"': 'gif',
    'image/gif; version="89a"': 'gif',

    // Audio    
    'audio/qcelp': 'qcelp',
    'audio/QCELP': 'qcp',
    'audio/x-wav': 'xwav',
    'audio/midi': 'midi',
    'audio/mid': 'mid',
    'audio/amr': 'amr',
    'audio/aac': 'aac',
    'audio/aacp': 'aacp',

    // Video   
    'video/h263': 'h263',
    'video/h264': 'h264',
    'video/jpeg': 'jpgv',
    'video/3gpp': '3gp',
    'video/3gpp2': '3g2',
    'video/mp4v-es': 'mp4',
    'video/mp4-es': 'mp4',
    'video/quicktime': 'mov',

    // Application
    'application/gzip': 'gz',
    'application/rtf': 'rtf',
    'application/zip': 'zip',
    'application/x-zip-compressed': 'zip',

    'text/x-vcard': 'vcf',
    'text/vcard': 'vcf',
};

const storage1 = multer1.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        let mmsdir = new UploadDirectory();
        const isValid = MIME_TYPE_MAP1[file.mimetype];
        let error: any = "";
        if (!isValid) {
            error = new Error("Invalid file type");
        }
        cb(error, mmsdir.MMSUPLOADS);
    },
    filename: (req: any, file: any, cb: any) => {
        const name = file.originalname.toLowerCase().split(' ').join('_');
        const ext = MIME_TYPE_MAP1[file.mimetype];
        cb(null, Date.now() + '-' + name);
    }
});

const errorHandler = (err: any, req: Request, res: any, next: NextFunction) => {
    if (err) {
        res.status(502).json({status: 404, message: err.message});
    } else {
        next();
    }
};

module.exports = [
    multer1({ storage: storage1 }).single('ATTACHMENT'),
    errorHandler
];