import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { CSPApiConfig, UploadDirectory, AppealEvidence, SMTPDetails } from "../config/setting.config";
import { APIBase } from "./APIBase";
import { parseBody,setToZero } from "./markError";
var nodemailer = require("nodemailer");
const fs = require('fs');
const FromSmtpMail = new SMTPDetails();
const FromEmail = FromSmtpMail.from;
const appealEvidence = new AppealEvidence();
let appealDir = new UploadDirectory();
const request = require("request");
const cspSetting = new CSPApiConfig();
const authKey = cspSetting.AUTHKEY;
const apiUrl = cspSetting.APIURL;

const MIME_TYPE_MAP: any = {
    'text/csv': 'csv',
    'audio/3gpp': '3ga',
    'video/3gpp': '3gp',
    'text/plain': 'txt',
    'audio/amr': 'amr',
    'video/x-msvideo': 'avi',
    'image/bmp': 'bmp',
    'application/x-bzip2': 'bz2',
    'application/calendar': 'cal',
    'text/css': 'css',
    'image/dib': 'dib',
    'audio/flac': 'flac',
    'video/x-flv': 'flv',
    'image/gif': 'gif',
    'application/x-gzip': 'gz',
    'image/x-icon': 'ico',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'application/javascript': 'js',
    'application/json': 'json',
    'audio/mpeg': 'm1a',
    'video/m1v': 'm1v',
    'audio/m2a': 'm2a',
    'audio/x-m4a': 'm4a',
    'audio/m4b': 'm4b',
    'audio/x-mp3': 'mp3',
    'video/mp4': 'mp4',
    'audio/x-ms-wma': 'mpa',
    'video/mpeg': 'mpeg',
    'video/mpg': 'mpg',
    'application/pdf': 'pdf',
    'image/pjpeg': 'pjpeg',
    'image/png': 'png',
    'video/quicktime': 'qt',
    'text/rtf': 'rtf',
    'audio/x-wav': 'wav',
    'video/webm': 'webm',
    'image/webp': 'webp',
    'video/x-ms-wmv': 'wmv',
    'application/xml': 'xml',
    'application/zip': 'zip'
};



export class NewCampaign extends AppRoute {
    constructor() {
        super();
    }

    /****************************************************************************
    * Start Brand Functionality  ************************************************
    ****************************************************************************/

    /**************************
    * Get Brand Relationship  *
    **************************/
    public brandRelationship(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/brandRelationship',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {                            
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand Relationship Types!", data: JSON.parse(response.body), status: 200 });
                            objv.execute();
                        }
                        catch (e) {
                            console.log("Error :: getBrandFeedback ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    public getBrandFeedback(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                var options = {
                    'method': 'GET',
                    'url': apiUrl + 'brand/feedback/' + req.query.type,
                    'headers': {
                        'Content-Type': 'application/json',
                        //   'Authorization': 'Basic MjQ1QUJEQjExODFENDI0QTgzRDNGNjU4MzhGNDFCNTA6Qjg0OTMzMUM1NTA3NEI0MkFCMTQ0MEYzNjI2M0IwOEI='
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Brand feedback Status!", data: JSON.parse(response.body), status: 200 });
                            objv.execute();
                        }
                        catch (e) {
                            console.log("Error :: getBrandFeedback ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    /***************************
    * Get Brand Vertical Type  *
    ***************************/
    public brandVertical(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/vertical',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any) => {
                    if (!error) {
                        try {
                            if (response) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Vertical Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: brandVertical ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************
    * Brand Entity Type  *
    **********************/
    public brandEntityType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/entityType',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Entity Types!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Entity Type Fetching!", error: error, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: brandEntityType ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*************************
    * Brand DCAs List  *
    *************************/
    public brandDCA(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/dca',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand DCA Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went Wrong With Fetch DCAs List!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: brandDCA ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*************************
    * Brand Identity Status  *
    *************************/
    public brandIdentityStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/brandIdentityStatus',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any) => {
                    if (!error) {
                        try {
                            if (response) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Identity Status Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Identity Status Fetching!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: brandIdentityStatus ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**************************
    * Brand Alt Business Type *
    **************************/
    public altBusinessIdType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/altBusinessIdType',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Brand Business Type Fetched!", data: data });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went Wrong With Get Brand Business Type Id List!" });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: altBusinessIdType ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went Wrong With Connection!", error: error });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**********************
    * Brand stockExchange *
    **********************/
    public stockExchange(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/stockExchange',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Brand stockExchange List!", data: data });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something went Wrong With Get stockExchange List!" });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: stockExchange ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went Wrong With Connection!", error: error });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************
    * Add Brand      *
    *****************/
    addBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let brandData: any = req.body;
                let obj5 = new ModelRawQuery(req, res);
                obj5.qrysql = "SELECT * FROM `brand` WHERE `brandId` = '" + brandData.brand_key + "'";
                obj5.prepare();
                obj5.execute((error: any, brand: any) => {
                    if (error == 1) {
                        try {
                            if (brand.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Brand Already Exists!",
                                    status: 404
                                });
                                objv.execute();
                            }
                            else {
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_relation`,`vertical_type`,`website`, `city`,`country`,`brand_name`, `brandId`, `brandType`) VALUES('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + brandData.companyName + "','" + brandData.brandRelationship + "','" + brandData.vertical + "','" + brandData.website + "','" + brandData.city + "','" + brandData.country + "', '" + brandData.companyName + "','" + brandData.brand_key + "', 'add')";
                                obj4.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 201, data: result, message: "Brand Added Successfully!" });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ error: result, message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        catch (e) {
                            console.log("Error :: addBrand ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: brand, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /******************************
    * Brand Register Normal       *
    ******************************/
    public BrandRegister(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let brandData: any = req.body;
                let objv = new RawView(res);
                if (brandData.displayName && brandData.firstName && brandData.lastName && brandData.phone && brandData.street && brandData.city && brandData.state && brandData.postalCode && brandData.country && brandData.email && brandData.referenceId) {
                    let options: any = {
                        'method': 'POST',
                        'url': apiUrl + 'brand',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify(brandData)
                    };
                    request(options, (error: any, response: any, body: any) => {
                        if (!error) {
                            try {
                                let resData = JSON.parse(response.body);
                                if (resData.brandId) {
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT into `brand` (`iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `brandId`, `cspId`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`) VALUES('" + sessdata.iduser + "', '" + brandData.companyName + "', '" + brandData.displayName + "', '" + brandData.entityType + "', '" + brandData.ein + "', '" + brandData.brandRelationship + "', '" + brandData.street + "', '" + brandData.city + "', '" + brandData.state + "', '" + brandData.postalCode + "', '" + brandData.website + "', '" + brandData.vertical + "', '" + brandData.country + "', '" + brandData.email + "', '" + brandData.phone + "', '" + resData.brandId + "', '" + resData.cspId + "', '" + resData.registrationScore + "', '" + resData.universalEin + "',  '" + resData.referenceId + "', '" + resData.entityType + "', '" + resData.identityStatus + "', '" + resData.einIssuingCountry + "', '" + resData.mock + "', '" + brandData.firstName + "', '" + brandData.lastName + "', '" + brandData.ipAddress + "')";
                                    obj3.execute((error: any, result: any) => {
                                        if (result) {
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`='" + sessdata.idaccount + "'";
                                            obj.prepare();
                                            obj.execute((_error, _resp) => {
                                                if (_error == 1) {

                                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                    iQry += "`amount`='-4', "

                                                    iQry += "`purpose`='Wallet amount successfully updated for brand registration', "

                                                    iQry += "`status`=1;"

                                                    let objWL = new ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry
                                                    objWL.prepare()
                                                    objWL.execute((error: any, result: any) => {
                                                        console.log("Transaction response::", result)
                                                    })

                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `date`, `description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.brandId + "',4,'" + Date.now() + "', 'Brand_Rate')";
                                                    obj3.prepare();
                                                    obj3.execute((__error, resp) => {
                                                        if (__error == 1) {
                                                            objv.prepare({
                                                                data: {
                                                                    brandId: resData.brandId,
                                                                    cspId: resData.cspId
                                                                },
                                                                message: "Brand Register Successfully!",
                                                                status: 201
                                                            });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            objv.prepare({
                                                                error: resp,
                                                                message: "Something Went Wrong With Connection!",
                                                                status: 502
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    objv.prepare({
                                                        error: _resp,
                                                        message: "Something Went Wrong With Connection!",
                                                        status: 502
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            objv.prepare({
                                                error: error,
                                                message: "Something Went Wrong!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    objv.prepare({
                                        message: resData[0].field + " " + resData[0].description,
                                        error: error,
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: BrandRegister ::",e);
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }

                        }
                    });
                }
                else {
                    objv.prepare({
                        status: 502,
                        error: "displayName, firstName, lastName, phone, street, city, state, postalCode, country, email, and referenceId are mendatory fields!"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /******************************
    * Brand Register None Blocking*
    ******************************/
    public brandRegisterNonBlocking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let checkService = new APIBase();
                checkService.serviceActivation(req, res, sessdata, "6", (err, resp) => {
                    if (resp.status == 200) {
                        let brandData: any = req.body;
                        if (brandData.entityType && brandData.entityType == "SOLE_PROPRIETOR") {
                            let ObjA = new ModelRawQuery(req, res);
                            ObjA.qrysql = "SELECT address,city,state,postal_code,country FROM `brand` WHERE `address`='" + parseBody(brandData.street) + "' AND `city`='" + parseBody(brandData.city) + "' AND `state`='" + brandData.state + "' AND `postal_code`='" + brandData.postalCode + "' AND `country`='" + brandData.country + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                            ObjA.prepare();
                            ObjA.execute((adErr: any, addressRes) => {
                                if (addressRes.length < 10) {
                                    let Obj0 = new ModelRawQuery(req, res);
                                    Obj0.qrysql = "SELECT email FROM `brand` WHERE `email`='" + brandData.email + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                                    Obj0.prepare();
                                    Obj0.execute((brErr: any, brandRes) => {
                                        if (brandRes.length < 3) {
                                            let Obj00 = new ModelRawQuery(req, res);
                                            Obj00.qrysql = "SELECT phone FROM `brand` WHERE `phone`='" + brandData.phone + "' AND `entityType`='SOLE_PROPRIETOR' AND `identityStatus`='VERIFIED' AND `deleted`=0";
                                            Obj00.prepare();
                                            Obj00.execute((brPhErr: any, brandPhRes) => {
                                                if (brandPhRes.length < 3) {
                                                    let fun = new NewCampaign();
                                                    fun.inbrandRegisterNonBlocking(req, res, next);
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ error: brPhErr, message: "Phone No. Already Exits 3 Times", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Email Id Already Exits 3 Times", status: 502 });
                                            objv.execute();

                                        }
                                    });

                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ error: adErr, message: "Address Already Exits 10 Times", status: 502 });
                                    objv.execute();

                                }

                            })
                        } else {
                            let fun = new NewCampaign();
                            fun.inbrandRegisterNonBlocking(req, res, next);
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error_code: err,
                            status: resp.status,
                            message: resp.message.replace(/::SN::/g, "Brand Registration")
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    public inbrandRegisterNonBlocking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let brandData: any = req.body;
                let Obj = new ModelRawQuery(req, res);
                Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 4";
                Obj.prepare();
                Obj.execute((crErr: any, crRes) => {
                    if (crErr == 1 && crRes.length > 0) {
                        let options: any = {
                            'method': 'POST',
                            'url': apiUrl + 'brand/nonBlocking',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            },
                            body: JSON.stringify(brandData)
                        };
                        request(options, (error: any, response: any, body: any) => {
                            if (!error) {
                                try {
                                    let resultData = JSON.parse(response.body);
                                    if (resultData.brandId && resultData.brandId !== undefined) {
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT into `brand` (`idaccount`, `iduser`, `company_name`, `brand_name`,`company_type`, `ein`, `brand_relation`, `address`, `city`, `state`, `postal_code`, `website`, `vertical_type`, `country`, `email`, `phone`, `mobilePhone`, `brandId`,`cspId`, `altBusinessId`, `altBusinessIdType`, `registrationScore`, `universalEin`,  `referenceId`, `entityType`, `identityStatus`, `stockSymbol`, `stockExchange`, `einIssuingCountry`, `mock`, `firstName`, `lastName`, `ipAddress`,`optionalAttributes`,`createDate`,`evpVettingScore`,`mobilePhoneVerifiedDate`, `brandType`,`cost`) VALUES(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + parseBody(resultData.companyName) + "', '" + parseBody(resultData.displayName) + "', '" + resultData.entityType + "', '" + resultData.ein + "', '" + resultData.brandRelationship + "', '" + parseBody(resultData.street) + "', '" + parseBody(resultData.city) + "', '" + resultData.state + "', '" + resultData.postalCode + "', '" + resultData.website + "', '" + resultData.vertical + "', '" + resultData.country + "', '" + resultData.email + "', '" + brandData.phone + "','" + brandData.mobilePhone + "', '" + resultData.brandId + "', '" + resultData.cspId + "', '" + brandData.altBusinessId + "', '" + brandData.altBusinessIdType + "', " + setToZero(resultData.registrationScore) + ", '" + resultData.universalEin + "',  '" + resultData.referenceId + "', '" + resultData.entityType + "', '" + resultData.identityStatus + "', '" + resultData.stockSymbol + "', '" + resultData.stockExchange + "', '" + resultData.einIssuingCountry + "', '" + resultData.mock + "', '" + parseBody(brandData.firstName) + "', '" + parseBody(resultData.lastName) + "', '" + resultData.ipAddress + "', '" + JSON.stringify(resultData.optionalAttributes) + "', '" + resultData.createDate + "', '" + resultData.evpVettingScore + "', '" +resultData.mobilePhoneVerifiedDate + "', 'register', 4)";
                                        obj3.execute((__error: any, result: any) => {
                                            if (__error == 1) {
                                                let swaggerResChn = resultData;
                                                delete swaggerResChn.cspId;
                                                delete swaggerResChn.mock;
                                                let swaggerResponse = swaggerResChn
                                                if (resultData.entityType == "SOLE_PROPRIETOR") {
                                                    let otp = new BrandManager();
                                                    otp.smsOTPBrand(req, res, resultData.brandId, (smsErr: any, smsOtp: any) => {
                                                        if (smsErr == 1) {

                                                            let obj = new ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "UPDATE `brand` SET `referenceIdOTP`='" + smsOtp.data.referenceId + "' WHERE `iduser`=" + sessdata.iduser + " AND `brandId`='" + resultData.brandId + "' AND `deleted`=0";
                                                            obj.prepare();
                                                            obj.execute((___error, resp) => { });

                                                            let objv = new RawView(res);
                                                            objv.prepare({
                                                                status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, smsOtp: smsOtp.data, message: "New Brand Created Successfully And " +
                                                                    smsOtp.message
                                                            });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, message: smsOtp.message });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 201, brandId: resultData.brandId, data: swaggerResponse, message: "New Brand Created Successfully." });
                                                    objv.execute();
                                                }

                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`=" + sessdata.idaccount + " ";
                                                obj.prepare();
                                                obj.execute((___error, resp) => {
                                                    if (___error == 1) {
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                        iQry += "`amount`= -4, "
                                                        iQry += "`purpose`='Wallet amount successfully updated for brand registration', "
                                                        iQry += "`status`=1;"

                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {

                                                        })
                                                    }
                                                    else {
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                        iQry += "`amount`= -4, "
                                                        iQry += "`purpose`='Wallet amount not successfully updated for brand registration', "
                                                        iQry += "`status`=2;"

                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {

                                                        })
                                                    }
                                                });
                                                let obj3 = new ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + resultData.brandId + "',4,'" + Date.now() + "',1, 'Brand Registered')";
                                                obj3.prepare();
                                                obj3.execute((log_error, _resp) => {
                                                    if (log_error == 1) {
                                                        console.log("Brand Log Updated.");
                                                    }
                                                    else {
                                                        console.log("Brand Log Not Updated.");
                                                    }
                                                });

                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 504, brandId: resultData.brandId, message: "Result Not Saved Successfully!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + resultData.brandId + "',4,'" + Date.now() + "',2, 'Brand Register Failed')";
                                        obj3.prepare();
                                        obj3.execute((log_error, _resp) => {
                                            if (log_error == 1) {
                                                console.log("Brand Log Updated.");
                                            }
                                            else {
                                                console.log("Brand Log Not Updated.");
                                            }
                                        });
                                        let objv = new RawView(res);
                                        objv.prepare({ message: resultData[0].fields + " " + resultData[0].description, status: resultData[0].code });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: inBrandRegisterNOnBlocking ::",e);
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 505, message: "Something Went Wrong. Brand Not Created Successfully!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: crErr, message: "Account Balance is Low!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /**********************
    * Start Update Brand  *
    **********************/
    public updateBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let brandId: any = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.query.brandId;
            let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
            let Obj0 = new ModelRawQuery(req, res);
            Obj0.qrysql = "SELECT identityStatus FROM `brand` WHERE `brandId`='" + brandId + "' AND `iduser`=" + iduser + " AND `deleted`=0";
            Obj0.prepare();
            Obj0.execute((_err: any, resStatus) => {
                if (resStatus[0].identityStatus == 'UNVERIFIED') {
                    let Obj00 = new ModelRawQuery(req, res);
                    Obj00.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 4";
                    Obj00.prepare();
                    Obj00.execute((crErr: any, crRes) => {
                        if (crErr == 1 && crRes.length > 0) {
                            let fun = new NewCampaign();
                            fun.inUpdateBrand(req, res, next);
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let fun = new NewCampaign();
                    fun.inUpdateBrand(req, res, next);
                }
            });
        });
    }

    public inUpdateBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
                let brandId: any = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.query.brandId;
                let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let Obj0 = new ModelRawQuery(req, res);
                Obj0.qrysql = "SELECT identityStatus,entityType FROM `brand` WHERE `brandId`='" + brandId + "' AND `iduser`=" + iduser + " AND `deleted`=0";
                Obj0.prepare();
                Obj0.execute((_err: any, resStatus) => {
                    var resultAllBrand = [];
                    for (var i in data) {
                        (i == "referenceId" && (data[i] == '' || data[i] == null)) ? '' : data[i] !== 'undefined' ? resultAllBrand.push([i, data[i]]) : '';
                    }
                    let brandData = Object.fromEntries(resultAllBrand);
                    let options: any = {
                        'method': 'PUT',
                        'url': apiUrl + 'brand/' + brandId,
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify(brandData)
                    };
                    request(options, (__error: any, response: any, body: any) => {
                        if (!__error) {
                            try {
                                let resultData = JSON.parse(response.body);
                                if (resultData.brandId && resultData.brandId !== undefined) {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `brand` SET `company_name`='" + parseBody(resultData.companyName) + "',`brand_name`='" + parseBody(resultData.displayName) + "',`entityType`='" + resultData.entityType + "',`ein`='" + resultData.ein + "',`einIssuingCountry`='" + resultData.einIssuingCountry + "', `identityStatus`='" + resultData.identityStatus + "', `cspId`='" + resultData.cspId + "',`address`='" + parseBody(resultData.street) + "',`city`='" + parseBody(resultData.city) + "',`state`='" + resultData.state + "',`postal_code`='" + resultData.postalCode + "',`country`='" + resultData.country + "',`website`='" + resultData.website + "',`stockSymbol`='" +resultData.stockSymbol + "',`stockExchange`='" + resultData.stockExchange + "',`vertical_type`='" + resultData.vertical + "',`referenceId`='" + resultData.referenceId + "',`brand_relation`='" + resultData.brandRelationship + "',`email`='" + resultData.email + "',`phone`='" + resultData.phone + "',`mobilePhone`='" + resultData.mobilePhone + "',`firstName`='" + parseBody(resultData.firstName) + "',`lastName`='" + parseBody(resultData.lastName) + "',`altBusinessId`='" + brandData.altBusinessId + "',`altBusinessIdType`='" + brandData.altBusinessIdType + "',`ipAddress`='" + resultData.ipAddress + "',`optionalAttributes`='" + JSON.stringify(resultData.optionalAttributes) + "',`mock`='" + resultData.mock + "',`createDate`='" + resultData.createDate + "',`evpVettingScore`='" + resultData.evpVettingScore + "',`mobilePhoneVerifiedDate`='" + resultData.mobilePhoneVerifiedDate + "' WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `deleted`=0";
                                    obj.prepare();
                                    obj.execute((___error: any, result: any) => {
                                        let swaggerResChn = resultData;
                                        delete swaggerResChn.cspId;
                                        delete swaggerResChn.mock;
                                        let swaggerResponse = swaggerResChn
                                        if (___error == 1) {
                                            if (resStatus[0].entityType !== 'SOLE_PROPRIETOR' && resStatus[0].identityStatus == 'UNVERIFIED' && resultData.identityStatus == "VERIFIED") {
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`=" + sessdata.idaccount + " ";
                                                obj.prepare();
                                                obj.execute((____error, resp) => {
                                                    if (____error) {
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                        iQry += "`amount`=-4, "
                                                        iQry += "`purpose`='Wallet amount successfully updated for brand identity status changed ', "
                                                        iQry += "`status`=1;"
                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {
                                                            console.log("Wallet amount successfully updated.");
                                                        })
                                                    }
                                                    else {
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                        iQry += "`amount`=-4, "
                                                        iQry += "`purpose`='Wallet amount successfully not updated for brand identity status changed', "
                                                        iQry += "`status`=2;"
                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {
                                                            console.log("Wallet amount not updated!");
                                                        })
                                                    }
                                                })
                                                let obj3 = new ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "',4,'" + Date.now() + "',3, 'Brand Updated')";
                                                obj3.prepare();
                                                obj3.execute((log_error, _resp) => {
                                                    if (log_error == 1) {
                                                        console.log("Brand Log Updated.");
                                                    }
                                                    else {
                                                        console.log("Brand Log Not Updated.");
                                                    }
                                                });
                                            }
                                            if (resStatus[0].entityType == 'SOLE_PROPRIETOR' && (!resStatus[0].identityStatus || resStatus[0].identityStatus == '' || resStatus[0].identityStatus == 'undefined' || resStatus[0].identityStatus == null || resStatus[0].identityStatus == undefined || resStatus[0].identityStatus == 'UNDEFINED' || resStatus[0].identityStatus == 'SELF_DECLARED')) {
                                                let otp = new BrandManager();
                                                otp.smsOTPBrand(req, res, resultData.brandId, (smsErr: any, smsOtp: any) => {
                                                    if (smsErr == 1) {
                                                        let obj = new ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `brand` SET `referenceIdOTP`='" + smsOtp.data.referenceId + "' WHERE `iduser`=" + sessdata.iduser + " AND `brandId`='" + resultData.brandId + "'";
                                                        obj.prepare();
                                                        obj.execute((___error, resp) => { });
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, smsOtp: smsOtp.data, message: "Brand Updated Successfully And " +
                                                                smsOtp.message
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: smsOtp.status, brandId: resultData.brandId, data: swaggerResponse, message: smsOtp.message });
                                                        objv.execute();
                                                    }
                                                });
                                                let obj3 = new ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", '" + sessdata.iduser + "','" + brandId + "',4, '" + Date.now() + "',3, 'Brand Updated')";
                                                obj3.prepare();
                                                obj3.execute((log_error, _resp) => {
                                                    if (log_error == 1) {
                                                        console.log("Brand Log Updated.");
                                                    }
                                                    else {
                                                        console.log("Brand Log Not Updated.");
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    message: "Brand Updated Successfully!", data: swaggerResponse, status: 201
                                                });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong With Brand Update!" });
                                            objv.execute();
                                        }
                                    })
                                }
                                else {
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "',0, '" + Date.now() + "',4, 'Brand Update Failed')";
                                    obj3.prepare();
                                    obj3.execute((log_error, _resp) => {
                                        if (log_error == 1) {
                                            console.log("Brand Log Updated.");
                                        }
                                        else {
                                            console.log("Brand Log Not Updated.");
                                        }
                                    });
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: resultData[0].fields + ' ' + resultData[0].description,
                                        status: resultData[0].code
                                    });
                                    objv.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: inUpdateBrand ::",e);
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }

                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 505, message: "Something Went Wrong. Brand Not Created Successfully!" });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /********************
    * End Update Brand  *
    ********************/

    /************************************
    * Start Revet Brand Identity Status *
    *************************************/
    public brandRvtForIdenSttsUp(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let Obj00 = new ModelRawQuery(req, res);
            Obj00.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 4";
            Obj00.prepare();
            Obj00.execute((crErr: any, crRes) => {
                if (crErr == 1 && crRes.length > 0) {
                    let fun = new NewCampaign();
                    fun.inRevet(req, res, next);
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                    objv.execute();
                }
            });
        });
    }
    public inRevet(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let brandId: any = req.body.data !== undefined ? JSON.parse(req.body.data).brandId : req.body.brandId;
                let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let Obj0 = new ModelRawQuery(req, res);
                Obj0.qrysql = "SELECT identityStatus,brandId FROM `brand` WHERE `brandId`='" + brandId + "' AND `iduser`=" + iduser + " AND `deleted`=0";
                Obj0.prepare();
                Obj0.execute((_err: any, resStatus) => {
                    if (resStatus.length > 0) {
                        let options: any = {
                            'method': 'PUT',
                            'url': apiUrl + 'brand/' + brandId + '/revet',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            },
                            body: JSON.stringify({ nonBlocking: true })
                        };
                        request(options, (error: any, response: any, body: any) => {
                            if (!error) {
                                try {
                                    if (response.body) {
                                        let resultData = JSON.parse(response.body);
                                        if (resStatus[0].identityStatus == "UNVERIFIED" && resultData.identityStatus == "VERIFIED") {
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='" + resultData.identityStatus + "' WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `deleted`=0";
                                            obj.prepare();
                                            obj.execute((___error, resp) => {
                                                if (___error == 1) {
                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`=" + sessdata.idaccount + " ";
                                                    obj.prepare();
                                                    obj.execute((____error, resp) => {
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                        iQry += "`amount`=-4, "
                                                        iQry += "`purpose`='Wallet amount successfully updated for identity status changed', "
                                                        iQry += "`status`=1;"
                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {
                                                        })
                                                    })
                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + brandId + "',4,'" + Date.now() + "',7, 'Brand Re-Submitted')";
                                                    obj3.prepare();
                                                    obj3.execute((log_error, _resp) => {
                                                        if (log_error == 1) {
                                                            console.log("Brand Log Updated.");
                                                        }
                                                        else {
                                                            console.log("Brand Log Not Updated.");
                                                        }
                                                    });
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Brand Status Updated Successfully.", data: resStatus.identityStatus, status: 200 });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Brand Status!", status: 502 });
                                                    objv.execute();
                                                }
                                            })
                                        }
                                        else {
                                            let obj3 = new ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "',4,'" + Date.now() + "',8, 'Brand Re-Submit Failed')";
                                            obj3.prepare();
                                            obj3.execute((log_error, _resp) => {
                                                if (log_error == 1) {
                                                    console.log("Brand Log Updated.");
                                                }
                                                else {
                                                    console.log("Brand Log Not Updated.");
                                                }
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "No Change in Brand Identity Status.", data: resStatus.identityStatus, status: 502 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "', 4,'" + Date.now() + "',8, 'Brand Re-Submit Failed')";
                                        obj3.prepare();
                                        obj3.execute((log_error, _resp) => {
                                            if (log_error == 1) {
                                                console.log("Brand Log Updated.");
                                            }
                                            else {
                                                console.log("Brand Log Not Updated.");
                                            }
                                        });
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: resStatus[0].field + ' ' + resStatus[0].description,
                                            status: resStatus[0].code
                                        });
                                        objv.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: inRevet ::",e);
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Expired!", status: 503 });
                                objv.execute();
                            }

                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Brand Expired!", status: 503 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /***********************************
    * End Identtity Status Of Brand  *
    ***********************************/

    /****************
    * Delete Brand  *
    ****************/
    public deleteBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let brandId = req.query.id !== undefined ? req.query.id : req.query.brandId;
                let options: any = {
                    'method': 'DELETE',
                    'url': apiUrl + 'brand/' + brandId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (__error: any, response: any, body: any) => {
                    if (!__error) {
                        try {
                            if ((response.statusCode == 405) || (response.statusCode == 204 && response.statusCode !== undefined) || (JSON.parse(body)[0].code == 502 && JSON.parse(body)[0].code !== undefined)) {
                                let obj0 = new ModelRawNonQuery(req, res);
                                obj0.nonqrysql = "UPDATE `brand` SET `deleted`=1, `delete_date`=NOW() WHERE `brandId`='" + brandId + "' AND `iduser`=" + sessdata.iduser + " ";
                                obj0.prepare();
                                obj0.execute((__errorb: any, resbrand: any) => {
                                    if (__errorb == 1) {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "DELETE FROM `brand_log` WHERE `brand_key`='" + brandId + "' AND `iduser`=" + sessdata.iduser + " ";
                                        obj.prepare();
                                        obj.execute((__errlog: any, lastid: any) => {
                                            if (__errlog == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    message: "Brand Deleted Successfully!",
                                                    data: lastid[0],
                                                    status: 201
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    message: "Something Went Wrong With Brand!",
                                                    error: lastid,
                                                    status: 502
                                                });
                                                objv.execute();
                                            }
                                        });
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "', 0, '" + Date.now() + "',5, 'Brand Removed')";
                                        obj3.prepare();
                                        obj3.execute((log_error, _resp) => {
                                            if (log_error == 1) {
                                                console.log("Brand Log Updated.");
                                            }
                                            else {
                                                console.log("Brand Log Not Updated.");
                                            }
                                        });
                                    }
                                    else {
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + brandId + "', 0, '" + Date.now() + "',6, 'Brand Remove Failed')";
                                        obj3.prepare();
                                        obj3.execute((log_error, _resp) => {
                                            if (log_error == 1) {
                                                console.log("Brand Log Updated.");
                                            }
                                            else {
                                                console.log("Brand Log Not Updated.");
                                            }
                                        });
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: "Something Went Wrong With Delete Brand!",
                                            error: resbrand,
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });

                            }
                            else {
                                let data = JSON.parse(body);
                                let objv = new RawView(res);
                                objv.prepare({
                                    //message: data[0].field + ' ' + data[0].description,
                                    message: data[0].description,
                                    status: data[0].code
                                });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: deleteBrand ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Brand Can't be Delete!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************
    * Get All Brand  *
    *****************/
    public getAllBrands(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser: any = sessdata.iduser;
                let condition = '';
                if (sessdata.type == 1) {
                    condition += ''
                }
                if (sessdata.type == 2) {
                    condition += "AND `idaccount`=" + sessdata.idaccount + " "
                }
                if (sessdata.type == 22) {
                    condition += "AND `iduser`=" + sessdata.iduser + " "
                }
                let ext_field = req.query.type ? "idbrand,iduser, idaccount,cspId,registrationScore,CONCAT(brand_name,' - ',brandId)brand_name_with_key, DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On, deleted, delete_date, mock,company_type," : '';
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " brand_name, brandId, brand_relation, entityType, referenceId, ein,firstName,lastName,company_name,address,city,postal_code,state,country,website,vertical_type,email,phone,mobilePhone,universalEin,einIssuingCountry,ipAddress,stockSymbol,stockExchange,optionalAttributes, (CASE WHEN identityStatus !='undefined' THEN identityStatus ELSE '' END )`identityStatus`,created_at FROM brand WHERE `status`=0 AND `deleted`=0 " + condition + " ORDER BY `idbrand` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /****************
    * Brand Filter  *
    ****************/
    public brandFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += ''
                }
                if (sessdata.type == 2) {
                    conditionU += "`idaccount`=" + sessdata.idaccount + "  AND"
                }
                if (sessdata.type == 22) {
                    conditionU += "`iduser`=" + sessdata.iduser + "  AND"
                }

                let obj = new ModelRawQuery(req, res);
                if (data.brandId)
                    condition += '`brandId` LIKE "%' + parseBody(data.brandId) + '%" AND ';

                if (data.brand_name)
                    condition += '`brand_name` LIKE "%' + parseBody(data.brand_name) + '%" AND ';

                if (data.country)
                    condition += '`country`="' + data.country + '" AND ';

                if (data.entityType)
                    condition += '`entityType` LIKE "%' + data.entityType + '%" AND ';

                if (data.ein)
                    condition += '`ein` LIKE "%' + data.ein + '%" AND ';

                if (data.identityStatus)
                    condition += '`identityStatus` LIKE "' + data.identityStatus + '%" AND ';

                if (data.referenceId)
                    condition += '`referenceId` LIKE "%' + parseBody(data.referenceId) + '%" AND ';

                // obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE deleted='0' AND " + condition + " " + conditionU + " ";
                obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE " + conditionU + " " + condition + " deleted=0"
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /****************
    * CNP Brand Filter  *
    ****************/
    public cnpBrandFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += ''
                }
                if (sessdata.type == 2) {
                    conditionU += "`idaccount`=" + sessdata.idaccount + " AND"
                }
                if (sessdata.type == 22) {
                    conditionU += "`iduser`=" + sessdata.iduser + " AND"
                }

                if (data.brandId)
                    condition += '`brandId` LIKE "%' + parseBody(data.brandId) + '%" AND ';

                if (data.displayName)
                    condition += '`displayName` LIKE "%' + parseBody(data.displayName) + '%" AND ';

                if (data.company_name)
                    condition += '`company_name` LIKE "%' + parseBody(data.company_name) + '" AND ';

                if (data.website)
                    condition += '`website` LIKE "%' + parseBody(data.website) + '%" AND ';


                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT iduser, idaccount,brand_name, brandId, brand_relation, entityType, referenceId, ein, country,`identityStatus` , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE deleted='0' AND " + condition + " " + conditionU + " ";
                obj.qrysql = "SELECT iduser, idaccount, brandId, company_name, displayName, website , status, DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On  FROM brand WHERE " + conditionU + " " + condition + " deleted=0 AND `status`=1 ORDER BY `idbrand` DESC"
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    /*******************
    * Campaign Filter  *
    *******************/
    public campaignFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";

                let obj = new ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== '' && data.idaccount !== null ? "c.`idaccount`=" + data.idaccount + "  AND" : '';
                }
                if (sessdata.type == 2) {
                    conditionU += "c.`idaccount`=" + sessdata.idaccount + " AND"
                }
                if (sessdata.type == 22) {
                    conditionU += "c.`iduser`=" + sessdata.iduser + " AND"
                }

                if (data.brandId)
                    condition += '`brandId` LIKE "%' + parseBody(data.brandId) + '%" AND ';

                if (data.brand_name)
                    condition += '`brand_name` LIKE "%' + parseBody(data.brand_name) + '%" AND ';

                if (data.campaign_key)
                    condition += '`campaign_key` LIKE "%' + parseBody(data.campaign_key) + '%" AND ';

                if (data.usecase)
                    condition += '`usecase`="' + data.usecase + '" AND ';
                if (data.tcrStatus == 'Both' || data.tcrStatus == null) {
                    condition += '';
                }
                else {
                    condition += 'c.`deleted`="' + data.tcrStatus + '" AND ';
                }
                if (data.filter_type == "Pending Review")
                    condition += 'c.`provisioning_status`="0" AND ';

                if (data.filter_type == "Shared")
                    condition += 'c.`provisioning_status`="1" AND ';

                if (data.filter_type == "Completed")
                    condition += 'c.`provisioning_status`="3" AND ';

                if (data.filter_type == "Failed")
                    condition += 'c.`provisioning_status`="4" AND ';

                if (data.filter_type == "Customer Action Required")
                    condition += 'c.`provisioning_status`="5" AND ';

                if (data.provisioning_status == "0")
                    condition += 'c.`provisioning_status`="0" AND ';

                if (data.provisioning_status == "1")
                    condition += 'c.`provisioning_status`="1" AND ';

                if (data.provisioning_status == "2")
                    condition += 'c.`provisioning_status`="2" AND ';

                if (data.provisioning_status == "3")
                    condition += 'c.`provisioning_status`="3" AND ';

                if (data.provisioning_status == "4")
                    condition += 'c.`provisioning_status`="4" AND ';

                if (data.provisioning_status == "5")
                    condition += 'c.`provisioning_status`="5" AND ';

                if (!data.provisioning_status || data.filter_type == "All")
                    condition += '';


                obj.qrysql = "SELECT c.iduser, c.idaccount, b.brandId, b.brand_name,c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit,c.deleted,c.provisioning_status FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + conditionU + " " + condition + " c.`status`=0 GROUP BY c.`campaign_key` ORDER BY c.`id_campaign` DESC";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign List Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*******************
    * Campaign Filter  *
    *******************/

    /********************
    * Get Brand Detail  *
    ********************/

    public getBrandsDetail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let gdata: any = req.query;
                let data: any = gdata.type !== undefined ? JSON.parse(gdata.type) : gdata;
                let iduser: any = data.iduser !== undefined ? data.iduser : sessdata.iduser;
                let ext_field = gdata.type ? "idbrand,iduser, idaccount,cspId,registrationScore,mock,deleted, delete_date , DATE_FORMAT(created_at, '%Y-%m-%d')  AS Registered_On,createDate,company_type," : '';

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " brand_name, brandId, brand_relation,altBusinessId, altBusinessIdType, entityType, referenceId, ein,firstName,lastName,company_name,address,city,postal_code,state,country,website,vertical_type,email,phone,mobilePhone,universalEin,einIssuingCountry,ipAddress,stockSymbol,stockExchange,optionalAttributes,mobilePhoneVerifiedDate, (CASE WHEN identityStatus !='undefined' THEN identityStatus ELSE '' END )`identityStatus`, created_at  FROM brand WHERE `deleted`=0 AND brandId='" + data.brandId + "' AND iduser = " + iduser + " ";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Brand Fetched Successfully!",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: result,
                                message: "No Result Found!",
                                status: 502
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    /***************************
    * Get OTP Status For Brand *
    ***************************/
    sendOTPforBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.body;
                let otp = new BrandManager();
                otp.smsOTPBrand(req, res, sdata.brandId, (smsErr: any, smsOtp: any) => {
                    if (smsErr == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: smsOtp.status, data: smsOtp.data, message: smsOtp.message });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: smsOtp.status, brandId: sdata.brandId, message: smsOtp.message });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /***************************
    * Get OTP Status For Brand *
    ***************************/
    verifyBrandOTP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.body;
                let otpdata: any = {
                    otpPin: sdata.brandOTP,
                }
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'brand/' + sdata.brandId + '/smsOtp',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(otpdata)
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let data = JSON.stringify(response.body);
                            let objv = new RawView(res);
                            objv.prepare({ message: 'OTP Updated !', data: data, status: 200 });
                            objv.execute();
                        }
                        catch (e) {
                            console.log("Error :: verifyBrandOTP ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "OTP Not Updated!", data: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /*********************
    * Send OTP For Brand *
    *********************/
    getOTPStatusForBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'brand/smsOtp/' + sdata.referenceId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let resData = JSON.parse(response.body);
                            if (resData.referenceId && resData.referenceId !== undefined) {
                                let objv = new RawView(res);
                                objv.prepare({ message: 'Brand OTP Status!', data: resData, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: resData[0].field + ' ' + resData[0].description, status: resData[0].code });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getOTPStatusForBrand ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "No Status Available!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************
    * Vetting Class *
    *****************/
    public brandVettingClass(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'enum/vettingClass',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Vetting Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went Wrong With Brand Vetting Fetching!", error: error, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: BrandVettingClass ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /***********************
    * Get Vetting Provider *
    ***********************/
    public brandVettingProvider(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/extVettingProvider',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Vetting Provider Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went Wrong With Brand Vetting Provider Fetching!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: BrandVettingProvider ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    /***********************
    * Get Vetting Status   *
    ***********************/
    public brandVettingStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/vettingStatus',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Vetting Status Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went Wrong With Brand Vetting Status Fetching!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: BrandVettingStatus ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /*****************************************
    * Get Vetting Class Class By Entity Type *
    *****************************************/
    public getVettingClassByEtype(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                let entityType: any = data.entityType;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT vettingClass,VC_displayName,evpId,EI_displayName,price,waitTime FROM `brand_vetting_additional` WHERE entityType='" + entityType + "' GROUP BY `vettingClass`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Vetting Class and Provider Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Vetting Class and Provider Not Fetched!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /**************************************
    * Get Vetting Provider By Entity Type *
    **************************************/
    public getVettingPartner(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                let entityType: any = data.entityType;
                let vettingClass: any = data.vettingClass;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT vettingClass,VC_displayName,evpId,EI_displayName,price,waitTime FROM `brand_vetting_additional` WHERE entityType='" + entityType + "' AND `vettingClass`='" + vettingClass + "'";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Vetting Class and Provider Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Vetting Class and Provider Not Fetched!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************************
    * Get Vetting List By Brand *
    ****************************/
    public getBrandsVettingList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                let brandId: any = data.brandId;
                // let iduser: any = data.iduser;
                let iduser: any = sessData.type == 1 ? data.iduser : sessData.iduser;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,brandID,type,filepath,filename,evpId,vettingId,vettingToken,vettingScore,vettingClass,vettingStatus,reasons,vettingDetails,VettedDate,createdDate FROM `brand_vetting` WHERE brandId='" + brandId + "' AND iduser=" + iduser + " GROUP BY `vettingId`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Vetting Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO Vetting available in this Brand!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************
    * Apply Vetting *
    ****************/
    public applyVetting(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let vettingData: any = req.body;
                let vettingData1: any = req.query;
                let brandId: any = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT entityType,einIssuingCountry FROM `brand` WHERE brandId='" + brandId + "' AND `idaccount` = " + sessdata.idaccount + " ";
                obj.prepare();
                obj.execute((errBrand: any, resultBrand: any) => {
                    if (errBrand == 1 && resultBrand.length > 0) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `vettingStatus` FROM `brand_vetting` WHERE evpId='" + vettingData.evpId + "' AND vettingClass='" + vettingData.vettingClass + "' AND vettingStatus='PENDING' AND `brandId`='" + brandId + "' AND `idaccount` = " + sessdata.idaccount + " ";
                        obj.prepare();
                        obj.execute((errDplctVtng: any, duplicateVetting: any) => {
                            if (errDplctVtng == 1 && duplicateVetting.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ status: 525, message: "Vetting re-submission not allowed with same brand information." });
                                objv.execute();
                            }
                            else {
                                let obj = new ModelRawQuery(req, res);
                                obj.qrysql = "SELECT vettingClass,evpId,price,waitTime,failedPrice FROM `brand_vetting_additional` WHERE evpId='" + vettingData.evpId + "' AND vettingClass='" + vettingData.vettingClass + "' AND entityType='" + resultBrand[0].entityType + "'";
                                obj.prepare();
                                obj.execute((errV: any, resulttV: any) => {
                                    let resultV: any = resulttV.length > 0 ? resulttV : [0];
                                    // For pinPreference (swagger side request)
                                    let price: any;
                                    if ((resultBrand[0].entityType == "NON_PROFIT" && resultBrand[0].einIssuingCountry == "US" && resultV[0].vettingClass == "POLITICAL" && resultV[0].evpId == "AEGIS") || (resultBrand[0].entityType == "SOLE_PROPRIETOR" && resultBrand[0].einIssuingCountry == "US" && resultV[0].vettingClass == "POLITICAL" && resultV[0].evpId == "AEGIS")) {
                                        let pinPre: any = JSON.parse(vettingData.additionalRequestPayload).pinPreference;
                                        switch (pinPre) {
                                            case "Regular":
                                                price = 64;
                                                break;
                                            case "Email":
                                                price = 64;
                                                break;
                                            default: // Express
                                                price = 91.95;
                                        }
                                    }
                                    else {
                                        price = resultV[0].price !== undefined ? resultV[0].price : 0;
                                    }
                                    let deductPrice: any = price;
                                    let waittime = resultV[0].waitTime !== undefined ? resultV[0].waitTime : '';
                                    let Obj = new ModelRawQuery(req, res);
                                    Obj.qrysql = "SELECT balance,min_balance,topup_amount,credit_limit FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= '" + deductPrice + "'";
                                    Obj.prepare();
                                    Obj.execute((bErr: any, bRes) => {                                        
                                        if (bErr == 1 && bRes.length > 0) {
                                            let options: any = {
                                                'method': 'POST',
                                                'url': apiUrl + 'brand/' + brandId + '/externalVetting/',
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                },
                                                body: JSON.stringify({
                                                    "evpId": vettingData.evpId,
                                                    "vettingClass": vettingData.vettingClass,
                                                    "additionalRequestPayload": vettingData.additionalRequestPayload
                                                })
                                            };                                            
                                            request(options, (error: any, response: any, body: any) => {
                                                if (!error) {
                                                    try {
                                                        let resData = JSON.parse(response.body);
                                                        if (resData.vettingId && resData.vettingId !== undefined) {
                                                            // To Charge deduct from wallet
                                                            //let deductPrice: any = price;
                                                            /*switch (resData.vettingStatus) {
                                                                case "FAILED":
                                                                    switch (vettingData.evpId) {
                                                                        case "STANDARD":
                                                                            deductPrice = resultV[0].failedPrice;
                                                                            break;
                                                                        case "POLITICAL":
                                                                            deductPrice = resultV[0].failedPrice;
                                                                            break;
                                                                        default:
                                                                            deductPrice = 0;
                                                                    }
                                                                    break;
                                                                default:
                                                                    deductPrice = price;
                                                            }*/

                                                            //To deduct price from wallet
                                                            let objv = new ModelRawNonQuery(req, res);
                                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + deductPrice + " WHERE `idaccount`=" + sessdata.idaccount + " ";
                                                            objv.prepare();
                                                            objv.execute((wallet_error, wallet_success) => {
                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                iQry += "`amount`=-" + deductPrice + ", "
                                                                iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "
                                                                iQry += "`status`=1;"
                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                objWL.nonqrysql = iQry
                                                                objWL.prepare()
                                                                objWL.execute((error: any, result: any) => {
                                                                    console.log("Transaction response::", result)
                                                                })
                                                                console.log("Charge deducted $", deductPrice);
                                                            });
                                                            //To insert brand vetting detail
                                                            let obj = new ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "INSERT INTO `brand_vetting` (`idaccount`, `iduser`, `brandId`,`type`, `evpId`, `vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate`,`priceDeducted`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + brandId + "', 'applyVetting', '" + resData.evpId + "', '" + resData.vettingId + "','" + resData.vettingToken + "'," + setToZero(resData.vettingScore) + ",'" + resData.vettingClass + "','" + resData.vettingStatus + "','" + JSON.stringify(resData.reasons) + "','" + JSON.stringify(resData.vettingDetails) + "','" + resData.vettedDate + "','" + resData.createDate + "'," + deductPrice + ")";
                                                            obj.prepare();
                                                            obj.execute((___error, resp) => {
                                                                if (___error == 1) {
                                                                    //To update vetting log 
                                                                    let objh = new ModelRawNonQuery(req, res);
                                                                    objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`) VALUES ('" + sessdata.idaccount + "','" + sessdata.iduser + "','" + brandId + "'," + deductPrice + "," + deductPrice + ",'" + resData.evpId + "','" + resData.vettingId + "',1,'Vetting Apply')";
                                                                    objh.prepare();
                                                                    objh.execute((vetting_error, vetting_success) => {
                                                                        console.log("Vetting log updated");
                                                                    });

                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ status: 200, message: "Vetting Applied Successfully.Vetting Price " + deductPrice + " and Estimated Time for Vetting: " + waittime + "", data: resData });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    //To update vetting log 
                                                                    let objhk = new ModelRawNonQuery(req, res);
                                                                    objhk.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "'," + deductPrice + "," + deductPrice + ",'" + resData.evpId + "','" + resData.vettingId + "',2,'Vetting Apply Failed')";
                                                                    objhk.prepare();
                                                                    objhk.execute((vetting_error, vetting_success) => {
                                                                        console.log("Vetting log updated");
                                                                    });

                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ status: 501, message: "Vetting Data Not Saved!", data: resData });
                                                                    objv.execute();
                                                                }
                                                            })
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            // objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                                            objv.prepare({ status: resData[0].code, message: resData[0].description });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: applyVetting ::",e);
                                                        let obj = new RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }

                                                }
                                                else {
                                                    //To update vetting log 
                                                    let objhk = new ModelRawNonQuery(req, res);
                                                    objhk.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','','','" + vettingData.evpId + "','',2,'Vetting Apply Failed')";
                                                    objhk.prepare();
                                                    objhk.execute((vetting_error, vetting_success) => {
                                                        console.log("Vetting log updated");
                                                    });

                                                    let objv = new RawView(res);
                                                    objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {                                            
                                            let objv = new RawView(res);
                                            objv.prepare({ error: error, message: "Your Current Balance is Low From $" + price + "!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                });
                            }

                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: error, message: "Brand Does Not Exist!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /****************************************************************
    * Enhanced Vetting Report Download API, it will be hit from PHP *
    ****************************************************************/
    public enhancedVettingReportDownload(req: Request, res: Response, next: NextFunction) {
        if (req.headers.authorization == 'Basic ' + authKey) {
            let sdata: any = req.body;
            let brandId: any = sdata.brandId;
            if (brandId[0] == 'B' && sdata.evpId && sdata.vettingId && sdata.vettingClass) {
                let Obj = new ModelRawQuery(req, res);
                Obj.qrysql = "SELECT iduser, idaccount, brandId, vettingId, evpId, vettingClass FROM `brand_vetting` WHERE `evpId`='" + sdata.evpId + "' AND `vettingId`='" + sdata.vettingId + "' AND `brandId`='" + brandId + "' AND `vettingClass`='" + sdata.vettingClass + "'";
                Obj.prepare();
                Obj.execute((Err: any, Res: any) => {
                    if (Err == 1) {
                        if (Res.length > 0) {
                            var options = {
                                'method': 'GET',
                                'url': apiUrl + 'brand/' + brandId + '/externalVetting/enhancedVettingReport',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                }
                            };
                            request(options, function (error: any, response: any) {
                                if (!error) {
                                    try {
                                        let resp = JSON.parse(response.body);
                                        if (resp[0].uuid) {
                                            let uuid: any = resp[0].uuid.replace(/\//g, '%2F');
                                            var options1 = {
                                                'method': 'GET',
                                                'url': apiUrl + 'attachment/' + uuid,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            request(options1, function (error1: any, response1: any) {
                                                if (!error1) {
                                                    try {
                                                        const index = response1.body.indexOf('%PDF');
                                                        if (index !== -1) {
                                                            let fName: any = 'evr-' + Date.now() + '-' + resp[0].fileName,
                                                                filePath: any = appealEvidence.fileEnhanced + fName, fileUpload: any = appealDir.ENHANCEDUPLOADS + '/' + fName;
                                                            fs.writeFile(fileUpload, response1.body, 'binary', (err: any) => {
                                                                if (!err) {
                                                                    let obj = new ModelRawNonQuery(req, res);
                                                                    obj.nonqrysql = "UPDATE `brand_vetting` SET `uuid`= '" + resp[0].uuid + "',`mimeType`='" + resp[0].mimeType + "',`fileName`='" + resp[0].fileName + "', `filepath`='" + filePath + "'  WHERE `iduser`=" + Res[0].iduser + " AND `brandId`='" + brandId + "' AND `evpId`='" + Res[0].evpId + "' AND `vettingId`='" + Res[0].vettingId + "' AND `vettingClass`='" + Res[0].vettingClass + "'";
                                                                    obj.prepare();
                                                                    obj.execute((_err: any, result: any) => {
                                                                        if (_err == 1) {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "File inserted successfully!", status: 200 });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong With Update!", status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With File Writing", status: 403 });
                                                                    objv.execute();
                                                                }
                                                            })
                                                        }
                                                        else {
                                                            if (response1.body == "Credentials are required to access this resource.") {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: "Request Format is wrong!", status: 503 });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let resp1: any = JSON.parse(response1.body);
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: resp1[0].description, status: resp1[0].code });
                                                                objv.execute();
                                                            }
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: enhancedVettingReportDownload ::",e);
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Something Went Wrong With Attachment API!", status: 506 });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Report!", status: 504 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: resp[0].code, message: resp[0].description });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error :: enhancedVettingReportDownload ::",e);
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Enhanced Vetting API!", status: 507 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Report!!", status: 505 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data Not Found!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went wrong with data founding!", status: 508 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Something is Missing from brandId, evpId, vettingId or vettingClass!", status: 506 });
                objv.execute();
            }
        }
        else {
            let objv = new RawView(res);
            objv.prepare({ message: "Invalid Authorization!", status: 401 });
            objv.execute();
        }
    }

    /*****************
    * Import Vetting *
    *****************/
    public importVetting(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let vettingData: any = req.body;
                let vettingData1: any = req.query;
                let brandId: any = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
                let Obj = new ModelRawQuery(req, res);
                Obj.qrysql = "SELECT evpId FROM `brand_vetting` WHERE `evpId`='" + vettingData.evpId + "' AND `vettingId`='" + vettingData.vettingId + "' AND `iduser`=" + sessdata.iduser + " ";
                Obj.prepare();
                Obj.execute((VErr: any, VRes) => {
                    let options: any = {
                        'method': 'PUT',
                        'url': apiUrl + 'brand/' + brandId + '/externalVetting/',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        body: JSON.stringify({
                            "evpId": vettingData.evpId,
                            "vettingId": vettingData.vettingId,
                            "vettingToken": vettingData.vettingToken
                        })
                    }
                    request(options, (error: any, response: any, body: any) => {
                        if (!error) {
                            try {
                                let resData = JSON.parse(response.body);                                
                                if (resData.vettingId && resData.vettingId !== undefined) {
                                    let qry: any = '';
                                    if (VRes.length > 0) {
                                        qry = "UPDATE `brand_vetting` SET `evpId`='" + resData.evpId + "',`vettingToken`='" + resData.vettingToken + "', `vettingScore`=" + resData.vettingScore + ",`vettingClass`='" + resData.vettingClass + "',`vettingStatus`='" + resData.vettingStatus + "',`reasons`='" + JSON.stringify(resData.reasons) + "',`type`='importVetting',`vettingDetails`='" + JSON.stringify(resData.vettingDetails) + "',`vettedDate`='" + resData.vettedDate + "',`createdDate`='" + resData.createDate + "' WHERE `iduser`= " + sessdata.iduser + "  AND `brandId`='" + brandId + "' AND `vettingId`='" + vettingData.vettingId + "'";
                                    }
                                    else {
                                        qry = "INSERT INTO `brand_vetting` (`idaccount`, `iduser`, `brandId`,`type`, `evpId`, `vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + brandId + "', 'importVetting', '" + resData.evpId + "', '" + resData.vettingId + "','" + resData.vettingToken + "'," + resData.vettingScore + ",'" + resData.vettingClass + "','" + resData.vettingStatus + "','" + JSON.stringify(resData.reasons) + "','" + JSON.stringify(resData.vettingDetails) + "','" + resData.vettedDate + "','" + resData.createDate + "')";
                                    }
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = qry;
                                    obj.prepare();
                                    obj.execute((___error, resp) => {
                                        if (___error == 1) {
                                            //To update vetting log 
                                            let objh = new ModelRawNonQuery(req, res);
                                            objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','','','" + resData.evpId + "','" + resData.vettingId + "',5,'Vetting Import')";
                                            objh.prepare();
                                            objh.execute((vetting_error, vetting_success) => {
                                                console.log("Vetting log updated");
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Vetting Imported Successfully!", data: resData, status: 200 });
                                            objv.execute();
                                        }
                                        else {
                                            //To update vetting log 
                                            let objh = new ModelRawNonQuery(req, res);
                                            objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','','','" + resData.evpId + "','" + resData.vettingId + "',6,'Vetting Import Failed')";
                                            objh.prepare();
                                            objh.execute((vetting_error, vetting_success) => {
                                                console.log("Vetting log updated");
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Vetting Not Inserted", status: 501 });
                                            objv.execute();
                                        }
                                    })
                                }
                                else {
                                    //To update vetting log 
                                    let objh = new ModelRawNonQuery(req, res);
                                    objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','','','" + resData.evpId + "','" + resData.vettingId + "',6,'Vetting Import Failed')";
                                    objh.prepare();
                                    objh.execute((vetting_error, vetting_success) => {
                                        console.log("Vetting log updated");
                                    });

                                    let objv = new RawView(res);
                                    objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                    objv.execute();

                                }
                            }
                            catch (e) {
                                console.log("Error :: importVetting ::",e);
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }

                        }
                        else {
                            //To update vetting log 
                            let objh = new ModelRawNonQuery(req, res);
                            objh.nonqrysql = "INSERT INTO `brand_vetting_log` (`idaccount`, `iduser`,`brand_key`,`cost`, `vetting_charge`, `evpId`, `vettingId`, `event_type`, `description`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ",'" + brandId + "','','','','',6,'Vetting Import Failed')";
                            objh.prepare();
                            objh.execute((vetting_error, vetting_success) => {
                                console.log("Vetting log updated");
                            });
                            let objv = new RawView(res);
                            objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                            objv.execute();

                        }
                    });
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************************************************************
    * Get Single External Vetting List By Brand Id And Status Update *
    *****************************************************************/
    /* public externalVettingList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let vettingData: any = req.query;
            // To Check Brand Exist Or Not
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT entityType FROM `brand` WHERE brandId='" + vettingData.brandId + "' AND `iduser` = '" + sessdata.iduser + "'";
            obj.prepare();
            obj.execute((errBrand: any, resultBrand: any) => {
                if (errBrand == 1 && resultBrand.length > 0) {
                    if (error == 1) {
                        // To Get Brand Vetting List
                        let options: any = {
                            'method': 'GET',
                            'url': apiUrl + 'brand/' + vettingData.brandId + '/externalVetting/?evpId=' + vettingData.evpId + '&vettingClass=' + vettingData.vettingClass + '&vettingStatus=' + vettingData.vettingStatus + '',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            }
                        };
                        request(options, (error: any, response: any) => {
                            if (!error) {
                                let resData: any = JSON.parse(response.body);
                                if (resData.length == 0) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "No Record Found!", status: 502 });
                                    objv.execute();
                                }
                                else if (resData[0].code && resData[0].code !== undefined && resData.length > 0) {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                    objv.execute();
                                }
                                else {
                                    resData.forEach((element: any) => {

                                        // To Update Brand Vetting

                                        let obj0 = new ModelRawNonQuery(req, res);
                                        obj0.nonqrysql = "UPDATE `brand_vetting` SET `evpId`='" + element.evpId + "', `vettingId`='" + element.vettingId + "',`vettingToken`='" + element.vettingToken + "',`vettingScore`='" + element.vettingScore + "',`vettingClass`='" + element.vettingClass + "',`vettingStatus`='" + element.vettingStatus + "',`reasons`='" + JSON.stringify(element.reasons) + "',`vettingDetails`='" + JSON.stringify(element.vettingDetails) + "',`vettedDate`='" + element.vettedDate + "',`createdDate`='" + element.createDate + "' WHERE `vettingId` = '" + element.vettingId + "' AND `vettingStatus` != 'ACTIVE' AND `iduser`='" + sessdata.iduser + "'";
                                        obj0.prepare();
                                        obj0.execute((___error, resp) => { });

                                    });

                                    // To Show Brand Vetting Response
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 200, message: "Record Fetched Successfully!", data: resData });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Request!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new Res406(res);
                        objv.prepare(session);
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Brand Does Not Exist!" });
                    objv.execute();
                }
            });
        });
    } */

    public externalVettingList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let vettingData: any = req.query;
                let condition: any = "";
                // To Check Brand Exist Or Not
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT entityType FROM `brand` WHERE brandId='" + vettingData.brandId + "' AND `iduser` = " + sessdata.iduser + " ";
                obj.prepare();
                obj.execute((errBrand: any, resultBrand: any) => {
                    if (errBrand == 1 && resultBrand.length > 0) {
                        // To Get Brand Vetting List
                        if (vettingData.evpId !== '' && vettingData.evpId !== undefined) {
                            condition += " AND `evpId`='" + vettingData.evpId + "'";
                        }
                        if (vettingData.vettingClass !== '' && vettingData.vettingClass !== undefined) {
                            condition += " AND `vettingClass`='" + vettingData.vettingClass + "'";
                        }
                        let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `evpId`,`vettingId`,`vettingToken`,`vettingScore`,`vettingClass`,`vettingStatus`,`reasons`,`vettingDetails`,`vettedDate`,`createdDate` FROM `brand_vetting` WHERE brandId='" + vettingData.brandId + "' AND  `vettingStatus` = '" + vettingData.vettingStatus + "' " + condition + "";
                        obj0.prepare();
                        obj0.execute((errBV: any, resultBV: any) => {
                            if (errBV == 1) {
                                if (resultBV.length > 0) {
                                    // To Show Brand Vetting Response
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 200, message: "Record Fetched Successfully!", data: resultBV });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 404, message: "No Record Found!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 503, message: "Something went wrong with External Vetting list" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Brand Does Not Exist!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*******************************************************************
    * Get Multiple External Vetting List By Brand Id And Status Update *
    *******************************************************************/
    public externalVettingBulkUpdate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = JSON.parse(req.body.data);
                let brandId: any = data.brandId;
                let iduserVal: any = data.iduser;
                let iduser: any = iduserVal !== undefined ? iduserVal : sessdata.iduser;
                // To Check Brand Exist Or Not
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT entityType FROM `brand` WHERE brandId='" + brandId + "' AND `iduser` = " + iduser + " ";
                obj.prepare();
                obj.execute((errBrand: any, resultBrand: any) => {
                    if (errBrand == 1 && resultBrand.length > 0) {
                        // To Get All Vetting Detail By Brand
                        let obj00 = new ModelRawQuery(req, res);
                        obj00.qrysql = "SELECT vettingStatus,brandId,vettingClass,evpId,paid_time FROM `brand_vetting` WHERE brandId='" + brandId + "' AND `iduser` = " + iduser + " ";
                        obj00.prepare();
                        obj00.execute((errAll: any, resultAll: any) => {

                            if (errAll == 1 && resultAll.length > 0) {
                                resultAll.forEach((ele: any) => {

                                    // To Get Brand Vetting List
                                    let options: any = {
                                        'method': 'GET',
                                        'url': apiUrl + 'brand/' + ele.brandId + '/externalVetting',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            'Authorization': 'Basic ' + authKey
                                        },
                                    };
                                    request(options, (error: any, response: any) => {
                                        if (!error) {
                                            try {
                                                let resData: any = JSON.parse(response.body);
                                                if (resData.length == 0) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "No Record Found!", status: 502 });
                                                    objv.execute();
                                                }
                                                else if (resData[0].code && resData[0].code !== undefined && resData.length > 0) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                                    objv.execute();
                                                }
                                                else {
                                                    resData.forEach((element: any) => {

                                                        // To Update Brand Vetting with Price Deduction

                                                        let obj0 = new ModelRawNonQuery(req, res);
                                                        obj0.nonqrysql = "UPDATE `brand_vetting` SET `evpId`='" + element.evpId + "', `vettingId`='" + element.vettingId + "',`vettingToken`='" + element.vettingToken + "',`vettingScore`=" + element.vettingScore + ",`vettingClass`='" + element.vettingClass + "',`vettingStatus`='" + element.vettingStatus + "',`reasons`='" + JSON.stringify(element.reasons) + "',`vettingDetails`='" + JSON.stringify(element.vettingDetails) + "',`vettedDate`='" + element.vettedDate + "',`createdDate`='" + element.createDate + "' WHERE `vettingId` = '" + element.vettingId + "' AND `iduser`=" + iduser + " ";
                                                        obj0.prepare();
                                                        obj0.execute((___error, resp) => { });
                                                    });
                                                }
                                            }
                                            catch (e) {
                                                console.log("Error :: externalVettingBulkUpdate ::",e);
                                                let obj = new RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                obj.execute();
                                            }
                                        }
                                        else {

                                        }
                                    });
                                });
                                // To Show Brand Vetting Response
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Record Updated!", data: resultAll });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "No Record Found!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Brand Does Not Exist!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /***************
    * Revet Brand  * 
    ***************/
    public revetBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let reqQry: any = req.query;
                let reqData: any = req.body;
                let Obj00 = new ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 4";
                Obj00.prepare();
                Obj00.execute((crErr: any, crRes) => {
                    if (crErr == 1 && crRes.length > 0) {
                        let Obj0 = new ModelRawQuery(req, res);
                        Obj0.qrysql = "SELECT identityStatus,brandId FROM `brand` WHERE `brandId`='" + reqQry.brandId + "' AND `iduser`=" + sessdata.iduser + " AND `deleted`=0";
                        Obj0.prepare();
                        Obj0.execute((_err: any, resStatus) => {
                            if (resStatus.length > 0) {
                                let options: any = {
                                    'method': 'PUT',
                                    'url': apiUrl + 'brand/' + reqQry.brandId + '/revet',
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Authorization': 'Basic ' + authKey
                                    },
                                    body: JSON.stringify({ nonBlocking: reqData.nonBlocking })
                                };
                                request(options, (error: any, response: any, body: any) => {
                                    if (!error) {
                                        try {
                                            if (response.body) {
                                                let resultData = JSON.parse(response.body);
                                                if (resStatus[0].identityStatus == "UNVERIFIED" && resultData.identityStatus == "VERIFIED") {
                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "UPDATE `brand` SET `identityStatus`='" + resultData.identityStatus + "' WHERE `iduser`=" + sessdata.iduser + " AND `brandId`='" + reqQry.brandId + "' AND `deleted`=0";
                                                    obj.prepare();
                                                    obj.execute((___error, resp) => {
                                                        if (___error == 1) {
                                                            let obj = new ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-4 WHERE `idaccount`=" + sessdata.idaccount + " ";
                                                            obj.prepare();
                                                            obj.execute((____error, resp) => {
                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                iQry += "`amount`=-4, "
                                                                iQry += "`purpose`='Wallet amount successfully updated for Resubmit Brand', "
                                                                iQry += "`status`=1;"
                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                objWL.nonqrysql = iQry
                                                                objWL.prepare()
                                                                objWL.execute((error: any, result: any) => {
                                                                })
                                                            })
                                                            let obj3 = new ModelRawNonQuery(req, res);
                                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "',4,'" + Date.now() + "',7, 'Brand Re-Submitted')";
                                                            obj3.prepare();
                                                            obj3.execute((log_error, _resp) => {
                                                                if (log_error == 1) {
                                                                    console.log("Brand Log Updated.");
                                                                }
                                                                else {
                                                                    console.log("Brand Log Not Updated.");
                                                                }
                                                            });
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Brand Revet Successfully.", data: resStatus.identityStatus, status: 200 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let obj3 = new ModelRawNonQuery(req, res);
                                                            obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "',0, '" + Date.now() + "',8, 'Brand Re-Submit Failed')";
                                                            obj3.prepare();
                                                            obj3.execute((log_error, _resp) => {
                                                                if (log_error == 1) {
                                                                    console.log("Brand Log Updated.");
                                                                }
                                                                else {
                                                                    console.log("Brand Log Not Updated.");
                                                                }
                                                            });
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Something Went Wrong With Brand Revet!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    })
                                                }
                                                else {
                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `brand_key`,`cost`, `date`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + reqQry.brandId + "',0, '" + Date.now() + "',8, 'Brand Re-Submit Failed')";
                                                    obj3.prepare();
                                                    obj3.execute((log_error, _resp) => {
                                                        if (log_error == 1) {
                                                            console.log("Brand Log Updated.");
                                                        }
                                                        else {
                                                            console.log("Brand Log Not Updated.");
                                                        }
                                                    });
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "No Change in Brand Status.", data: resStatus.identityStatus, status: 502 });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    message: resStatus[0].field + ' ' + resStatus[0].description,
                                                    status: resStatus[0].code
                                                });
                                                objv.execute();
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: revetBrand ::",e);
                                            let obj = new RawView(res);
                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                            obj.execute();
                                        }
                                    }
                                    else {
                                        let obj = new RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }

                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Brand Expired!", status: 503 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Your Wallet Balance is Low From $4!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /****************************************
    * Get campaing's DID limit and counting *
    ****************************************/
    getCampaignDIDCount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let camp_key = sdata.type;
                let iduser = sdata.filter;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT did_limit, did_count FROM `campaign` WHERE campaign_key='" + camp_key + "' AND iduser=" + iduser + " GROUP BY `campaign_key`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'DID Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO DID available in this Campaign!", data: [], status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /*********************
    * Get campaing's DID *
    **********************/

    public getCampaignDID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata = req.query;
                let camp_key = sdata.type;
                let iduser = sdata.filter;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT did FROM `did_buy` WHERE camp_registry='" + camp_key + "' AND iduser=" + iduser + " AND `disconnect_did_status`='1' AND `osr_status`='register' AND `sinch_status`='1'  GROUP BY `did`";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: 'DID Fatched Successfully!', data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "NO DID available in this Campaign!", data: [], status: 501 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went wrong with Campaign DIDs", data: [], status: 502 });
                        objv.execute();
                    }

                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /****************
    * Update CSP ID *
    ****************/
    updateCSPID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessdata: any) => {
            if (sessErr == 1) {
                let sdata = req.body;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `account` SET `csp_id`= '" + sdata.csp_id + "' WHERE idaccount= " + sessdata.idaccount + " ";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "CSP ID Updated Successfully", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                })
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access", status: 401 });
                objv.execute();
            }
        })
    }

    /****************
    * Get CSP ID *
    ****************/
    getCspId(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `csp_id` FROM `account` WHERE idaccount=" + sessData.idaccount + " ";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'CSP ID Fatched', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /************************
    * CNP Campaigns Filters *
    ************************/

    public CNPcampaignFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let obj = new ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== '' && data.idaccount !== null ? " AND c.`idaccount`=" + data.idaccount + " " : '';
                }

                if (sessdata.type == 2)
                    conditionU += " AND c.`idaccount`=" + sessdata.idaccount + " ";

                if (sessdata.type == 22)
                    conditionU += " AND c.`iduser`= " + sessdata.iduser + " ";

                if (data.brandId)
                    condition += 'b.`brandId` LIKE "%' + parseBody(data.brandId) + '%" AND ';

                if (data.brand_name)
                    condition += 'b.`brand_name` LIKE "%' + parseBody(data.brand_name) + '%" AND ';

                if (data.campaign_key)
                    condition += 'c.`campaign_key` LIKE "%' + parseBody(data.campaign_key) + '%" AND ';

                if (data.usecase)
                    condition += 'c.`usecase`="' + data.usecase + '" AND ';

                if (data.filter_type == "Pending Review")
                    condition += 'c.`provisioning_status`="0" AND ';

                if (data.filter_type == "Shared")
                    condition += 'c.`provisioning_status`="1" AND ';

                if (data.filter_type == "Completed")
                    condition += 'c.`provisioning_status`="3" AND ';

                if (data.filter_type == "Failed")
                    condition += 'c.`provisioning_status`="4" AND ';

                if (data.filter_type == "Customer Action Required")
                    condition += 'c.`provisioning_status`="5" AND ';

                if (data.provisioning_status == "0")
                    condition += 'c.`provisioning_status`="0" AND ';

                if (data.provisioning_status == "1")
                    condition += 'c.`provisioning_status`="1" AND ';

                if (data.provisioning_status == "2")
                    condition += 'c.`provisioning_status`="2" AND ';

                if (data.provisioning_status == "3")
                    condition += 'c.`provisioning_status`="3" AND ';

                if (data.provisioning_status == "4")
                    condition += 'c.`provisioning_status`="4" AND ';

                if (data.provisioning_status == "5")
                    condition += 'c.`provisioning_status`="5" AND ';

                if (!data.provisioning_status || data.filter_type == "All")
                    condition += '';

                obj.qrysql = "SELECT c.idbrand `brandId`, b.brand_name,c.campaign_key,c.campaign_name,c.idaccount,c.iduser,c.usecase,c.start_date,c.did_count,c.did_limit,c.`status`,c.provisioning_status FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + " c.`status`= 1 " + conditionU + " GROUP BY c.`campaign_key` ORDER BY c.`id_campaign` DESC";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Campaign List Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched CNP Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public rejectFormByAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let Obj00 = new ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0 ";
                Obj00.prepare();
                Obj00.execute((_Err: any, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,`event_type`,`webhook_event_type`,`description`,`webhook_description_detail`,`request_type`) VALUE(" + data.idaccount + "," + data.iduser + ",'" + data.campId + "',29,'ADMIN_REJECT_CAMPAIGN','Admin Reject Campaign','" + parseBody(data.desc_details) + "',3)";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5' WHERE `campaign_key`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                                obj1.prepare();
                                obj1.execute((___error, UpRes) => {
                                    let fun = new NewCampaign();
                                    fun.sendMailForRejectMail(req, res, data, next);
                                })

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }

                })

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public failedFormByAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let Obj00 = new ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0 ";
                Obj00.prepare();
                Obj00.execute((_Err: any, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`) VALUE(" + data.idaccount + "," + data.iduser + ",'" + data.campId + "',30,'Admin Reject After Failed','ADMIN_REJECT_AFTER_FAILED','" + parseBody(data.desc_details) + "',3)";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5' WHERE `campaign_key`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                                obj1.prepare();
                                obj1.execute((___error, UpRes) => {
                                    let fun = new NewCampaign();
                                    fun.sendMailForFailedMail(req, res, data, next);
                                })

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public RequestEdit(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let Obj00 = new ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0";
                Obj00.prepare();
                Obj00.execute((_Err: any, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let obj0 = new ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,webhook_description_detail,`description`, webhook_event_type, event_type,`request_type`) VALUES (" + data.idaccount + ", " + data.iduser + ", " + data.campaign_key + ", '" + parseBody(data.description) + "','Admin Reject CNP Campaign','ADMIN_REJECT_CNP_CAMPAIGN',31,3)";
                        obj0.prepare();
                        obj0.execute((error: any, result: any) => {
                            if (error == 1) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5' WHERE `idaccount`=" + data.idaccount + " AND `campaign_key`='" + data.campaign_key + "'";
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    let fun = new NewCampaign();
                                    fun.sendMailForRejectMail(req, res, data, next);
                                })
                            } else {
                                let objv0 = new RawView(res);
                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }
                })

            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    public failedCnpFormByAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data = req.body.data;
                let condition: any = "";
                let Obj00 = new ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + data.iduser + " AND `campaign_key`='" + data.campId + "' AND `deleted` = 0";
                Obj00.prepare();
                Obj00.execute((_Err: any, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `campaign_log`(`idaccount`,`iduser`,`campaign_key`,`event_type`,`description`,`webhook_event_type`,`webhook_description_detail`,`request_type`) VALUE(" + data.idaccount + "," + data.iduser + ",'" + data.campId + "',32,'Admin Reject CNP Campaign After Failed','ADMIN_REJECT_CNP_CAMPAIGN_AFTER_FAILED','" + parseBody(data.desc_details) + "',3)";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='5' WHERE `campaign_key`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                                obj1.prepare();
                                obj1.execute((___error, UpRes) => {
                                    let fun = new NewCampaign();
                                    fun.sendMailForFailedMail(req, res, data, next);
                                })

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public sendMailForRejectMail(req: Request, res: Response, data: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                if (data.iduser !== '' && data.iduser !== 'null' && data.iduser !== 'undefined') {
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT firstname,lastname,email FROM `user_profile` WHERE iduser = " + data.iduser + " ";
                    obj2.prepare();
                    obj2.execute((_err: any, customerDetail: any) => {
                        let obj3 = new ModelRawQuery(req, res);
                        obj3.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='Admin_reject_campaign'";
                        obj3.prepare();
                        obj3.execute((emlErr: any, emlRes: any) => {

                            if (emlErr == 1) {
                                if (emlRes.length > 0) {
                                    let tmpData = emlRes[0].template;
                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, customerDetail[0].firstname);
                                    tmpData = tmpData.replace(/{LAST_NAME}/g, customerDetail[0].lastname);
                                    tmpData = tmpData.replace(/{CAMPAIGN_KEY}/g, data.campId);


                                    // var smtpTransport = nodemailer.createTransport({
                                    //     service: "gmail",
                                    //     host: "smtp.gmail.com",
                                    //     port: 587,
                                    //     secure: true,
                                    //     auth: {
                                    //         user: "mailto:donotreply@nglcommunications.com",
                                    //         pass: "yr%5V9GB"
                                    //     }
                                    // });
                                    // var mailOptions = {
                                    //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                    //     to: customerDetail[0].email,
                                    //     email: customerDetail[0].email,
                                    //     subject: `${emlRes[0].subject}`,
                                    //     text: "Campaign Rejected",
                                    //     html: `${tmpData}`
                                    // }
                                    // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                    //     if (_emailError) {
                                    //         console.log("Mail Not Sent Successfully!");

                                    //     } else {
                                    //         console.log("Mail Sent Successfully!");

                                    //     }
                                    // });

                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES (" + data.iduser + "," + data.idaccount + ",'" + FromEmail + "','" + customerDetail[0].email + "', '" + parseBody(emlRes[0].subject) + "','Campaign Rejected','Mail Send for Campaign Rejected',14,'" + parseBody(tmpData) + "')";
                                    obj1.prepare();
                                    obj1.execute((_emailError: any, emailRes: any) => {
                                        if (_emailError == 1) {
                                            console.log("Mail Sent Successfully!");
                                        } else {
                                            console.log("Mail Not Sent Successfully!");
                                        }
                                    })

                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 401, errMessage: "Template Data Not Found!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                objv.execute();
                            }
                        });
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, message: "Campaign Rejected Successfully" });
                        objv.execute();
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ errMessage: "Iduser Not Found!", status: 502 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })

    }

    public sendMailForFailedMail(req: Request, res: Response, data: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((__error: any, sessdata: any) => {
            if (__error == 1) {
                if (data.iduser !== '' && data.iduser !== 'null' && data.iduser !== 'undefined') {
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT firstname,lastname,email FROM `user_profile` WHERE iduser = " + data.iduser + " ";
                    obj2.prepare();
                    obj2.execute((_err: any, customerDetail: any) => {
                        if (data.mailCheck) {
                            let obj3 = new ModelRawQuery(req, res);
                            obj3.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type`='Admin_reject_after_failed'";
                            obj3.prepare();
                            obj3.execute((emlErr: any, emlRes: any) => {
                                if (emlErr == 1) {
                                    if (emlRes.length > 0) {
                                        let tmpData = emlRes[0].template;
                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, customerDetail[0].firstname);
                                        tmpData = tmpData.replace(/{LAST_NAME}/g, customerDetail[0].lastname);
                                        tmpData = tmpData.replace(/{CAMPAIGN_KEY}/g, data.campId);

                                        // var smtpTransport = nodemailer.createTransport({
                                        //     service: "gmail",
                                        //     host: "smtp.gmail.com",
                                        //     port: 587,
                                        //     secure: true,
                                        //     auth: {
                                        //         user: "mailto:donotreply@nglcommunications.com",
                                        //         pass: "yr%5V9GB"
                                        //     }
                                        // });
                                        // var mailOptions = {
                                        //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                        //     to: customerDetail[0].email,
                                        //     email: customerDetail[0].email,
                                        //     subject: `${emlRes[0].subject}`,
                                        //     text: "Campaign Rejected",
                                        //     html: `${tmpData}`
                                        // }
                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                        //     if (_emailError) {
                                        //         let objv = new RawView(res);
                                        //         objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!", error: _emailError });
                                        //         objv.execute();
                                        //     } else {
                                        //         let objv = new RawView(res);
                                        //         objv.prepare({ iduser: data.iduser, status: 201, data: emailRes, message: "Campaign Rejected Succesfully!" });
                                        //         objv.execute();
                                        //     }
                                        // });

                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES (" + data.iduser + "," + data.idaccount + ",'" + FromEmail + "','" + customerDetail[0].email + "', '" + emlRes[0].subject + "','Campaign Rejected','Admin Campaign Reject After Failed',15,'" + parseBody(tmpData) + "')";
                                        obj1.prepare();
                                        obj1.execute((_emailError: any, emailRes: any) => {
                                            if (_emailError == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ iduser: data.iduser, status: 201, data: emailRes, message: "Campaign Rejected Succesfully!" });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!", error: _emailError });
                                                objv.execute();
                                            }
                                        })
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 401, errMessage: "Template Data Not Found!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 201, message: "Campaign Rejected Successfully!" });
                            objv.execute();
                        }


                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ errMessage: "Iduser Not Found!", status: 502 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })

    }

    public finalUpdateForCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            //let campid = req.body.data;
            if (error == 1) {
                let data = JSON.parse(req.body.data);
                let condition: any = "";
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='0' WHERE `campaign_key`='" + data.campId + "' AND `iduser`=" + data.iduser + " ";
                obj.prepare();
                obj.execute((___error, UpRes) => {
                    if (___error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Campaign Update Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong",
                            status: 502,
                        });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /********************
    * Get CNP Campaigns *
    ********************/
    public getCNPCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let condition = '';
                if (sessdata.type == 1) {
                    condition += ''
                }
                if (sessdata.type == 2) {
                    condition += "AND c.`idaccount`=" + sessdata.idaccount + " "
                }
                if (sessdata.type == 22) {
                    condition += "AND c.`iduser`=" + sessdata.iduser + " "
                }
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId, b.brand_name,c.campaign_key,c.campaign_name,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + sessdata.iduser + "' AND c.`status`= 1 GROUP BY campaign_key";
                obj.qrysql = "SELECT c.idbrand `brandId`, b.brand_name,c.campaign_key,c.campaign_name,c.id_campaign,c.idaccount,c.iduser,c.usecase,c.start_date,c.provisioning_status,c.did_count,c.did_limit,c.`status` FROM `brand`b RIGHT JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`status`= 1 " + condition + "  GROUP BY c.campaign_key ORDER BY c.`id_campaign` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*****************
 * Get CNP Brand LIST *
 *****************/
    public getBrandCnpList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser: any = sessdata.iduser;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `brandId`,`iduser`,`company_name`,`website`,`displayName`,`status` FROM `brand` WHERE `status`= 1 ORDER BY `idbrand` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "CNP Brand Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /****************************************
    * Send a mock webhook to your endpoint  *
    ****************************************/

    public mockWebhookEndpoint(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let reqQry: any = req.query;
                let iduser: any = sessdata.iduser;
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'webhook/subscription/eventType/' + reqQry.eventType + '/mock',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                }
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let resData = JSON.parse(response.body);
                            if (resData.brandId && resData.brandId !== undefined) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Revet Successfully!", data: resData, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: resData[0].code, message: resData[0].field + ' ' + resData[0].description });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: mockWbhookEndpoint ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let obj = new RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                    // if (!error) {
                    //     let resData = JSON.parse(response.body);
                    //     if (resData.campaignId && resData.campaignId !== undefined) {
                    //         let obj = new ModelRawNonQuery(req, res);
                    //         obj.nonqrysql = "UPDATE `campaign` SET `campaign_description`='" + resData.description + "',`sample1`='" + resData.sample1 + "',`sample2`='" + resData.sample2 + "',`sample3`='" + resData.sample3 + "',`sample4`='" + resData.sample4 + "',`sample5`='" + resData.sample5 + "',`messageFlow`='" + resData.messageFlow + "',`helpMessage`='" + resData.helpMessage + "',`optinKeywords`='" + resData.optinKeywords + "',`optoutKeywords`='" + resData.optoutKeywords + "',`helpKeywords`='" + resData.helpKeywords + "',`optinMessage`='" + resData.optinMessage + "',`optoutMessage`='" + resData.optoutMessage + "',`autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "' WHERE `campaign_key`='" + campId + "' AND `iduser`='" + iduser + "'";
                    //         obj.prepare();
                    //         obj.execute((___error, resp) => {
                    //             if (!error) {
                    //                 let objv = new RawView(res);
                    //                 objv.prepare({ status: 200, message: "Campaign details Updated Successfully!", data: resData });
                    //                 objv.execute();
                    //             }
                    //             else {
                    //                 let objv = new RawView(res);
                    //                 objv.prepare({ message: "Campaign details Not updated", data: resData, status: 501 });
                    //                 objv.execute();
                    //             }
                    //         })
                    //     }
                    //     else {
                    //         let objv = new RawView(res);
                    //         objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                    //         objv.execute();
                    //     }
                    // }
                    // else {
                    //     let objv = new RawView(res);
                    //     objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                    //     objv.execute();
                    // }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /**************************************************************************
    * End Brand Functionality  ************************************************
    **************************************************************************/

    /***************************************************************************
    * Start Campaign Functionality *********************************************
    ***************************************************************************/
    public campaignFilterForBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let Cdata: any = JSON.parse(req.body.data);
                let data = Cdata.companyFilter;
                let condition: any = "";
                let obj = new ModelRawQuery(req, res);
                if (data.usecase)
                    condition += '`usecase`="' + data.usecase + '" AND ';

                if (data.description)
                    condition += '`campaign_description` LIKE "%' + data.description + '%" AND ';

                if (data.campaignId)
                    condition += '`campaign_key` LIKE "%' + data.campaignId + '%" AND ';

                obj.qrysql = "SELECT `campaign_key`,`usecase`,`campaign_description`,DATE_FORMAT(start_date,'%Y-%m-%d')`start_date` FROM `campaign` WHERE " + condition + " `idbrand` = '" + Cdata.brandId + "'AND iduser=" + Cdata.iduser + " AND `deleted`=0 GROUP BY campaign_key";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaignByBrandId(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let brandId: any = req.query.type !== undefined ? JSON.parse(data.type).brandId : req.query.brandId
                let iduser: any = req.query.type !== undefined ? JSON.parse(data.type).iduser : sessdata.iduser
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `campaign_key`,`iduser`,`usecase`,`campaign_description`,DATE_FORMAT(start_date,'%Y-%m-%d')`start_date` FROM `campaign` WHERE `idbrand` = '" + brandId + "'AND iduser=" + iduser + " AND `status`=0 GROUP BY campaign_key";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getSwaggerCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let iduser: any = sessdata.iduser;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = " + iduser + " AND c.`deleted` = 0 GROUP BY campaign_key";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                // let iduser: any = sdata.type == 'main' ? JSON.parse(sdata.type).iduser : sessdata.iduser;
                //let iduser: any = sdata.type.iduser !== undefined ? sdata.type.iduser : JSON.parse(sdata.type).iduser;
                let condition = '';
                if (sessdata.type == 1) {
                    condition += ''
                }
                if (sessdata.type == 2) {
                    condition += "c.`idaccount`=" + sessdata.idaccount + " AND"
                }
                if (sessdata.type == 22) {
                    condition += "c.`iduser`=" + sessdata.iduser + " AND"
                }
                let ext_field: any = "c.iduser,c.idaccount,";
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId,b.brand_name, " + ext_field + " c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit,c.provisioning_status,c.deleted FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE " + condition + "  c.`status`=0 GROUP BY  b.brandId, b.brand_name,c.iduser,c.idaccount,c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit,c.provisioning_status,c.deleted ORDER BY c.`id_campaign` DESC";

                obj.qrysql = "SELECT DISTINCT b.brandId,b.brand_name, " + ext_field + " c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit,c.provisioning_status,c.deleted FROM `brand` b INNER JOIN `campaign` c ON c.idbrand = b.brandId WHERE " + condition + "  c.`status`=0 GROUP BY c.campaign_key, c.campaign_key, b.brandid, b.brand_name, c.iduser, c.idaccount, c.campaign_key, c.usecase,c.start_date,c.did_count,c.did_limit,c.provisioning_status,c.deleted ORDER BY `start_date` DESC;"

                // obj.qrysql = "SELECT b.brandId,b.brand_name," + ext_field + " c.campaign_key, MAX(c.usecase),MAX(c.start_date),MAX(c.did_count),MAX(c.did_limit),MAX(c.provisioning_status),MAX(c.deleted) FROM `brand` b INNER JOIN `campaign` c ON c.idbrand = b.brandId WHERE " + condition + " c.`status` = 0 GROUP BY c.campaign_key, b.brandId, b.brand_name ORDER BY c.`id_campaign` DESC;";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaignForReview(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let idaccount = JSON.parse(sdata.type).idaccount
                let ext_field: any = "c.iduser,c.idaccount,";
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId,b.brand_name,b.referenceId, "+ext_field+" c.campaign_key,c.usecase,c.start_date,c.did_count,c.did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`iduser` = '" + iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                obj.qrysql = "SELECT MAX(b.brandId) AS brandId,MAX(b.brand_name) AS brand_name,MAX(b.referenceId) AS referenceId, MAX(c.iduser) AS iduser,c.idaccount, c.campaign_key, MAX(c.id_campaign) AS id_campaign,MAX(c.usecase) AS usecase,MAX(DATE_FORMAT(c.`start_date`, '%Y-%m-%d'))`start_date`,MAX(c.did_count) AS did_count,MAX(c.did_limit) AS did_limit FROM `brand`b INNER JOIN `campaign`c ON c.idbrand = b.brandId WHERE c.`idaccount` = "+ idaccount +" AND c.`deleted` = 0 GROUP BY c.campaign_key ORDER BY `start_date` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // Get Campaign For Admin
    public getCampaignForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT campaign_key FROM `campaign` WHERE `deleted`=0 AND `status`=0 GROUP BY `campaign_key`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Loaded Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampaignCases(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let id: any;
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/usecase',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (_err: any, response: any, body: any) => {
                    if (!_err) {
                        try {
                            let data = JSON.parse(response.body);
                            if (data) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Campaign Cases Fetched!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", error: data, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getCampaignCases ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                        /*
                        let tmp:any=[];
                        Object.entries(data).forEach((ele:any)=>{
                            let t=ele[1];
                            t["isDisable"] = false;
                            t["name"]=ele[0];
                            tmp.push(t);
                        });

                        console.log(tmp);

                        let tmpqurty="INSERT INTO `campaign_cases` (`name`, `displayName`, `minSubUsecases`, `maxSubUsecases`, `validSubUsecase`, `classification`) VALUES ";
                        tmp.forEach((campaignData: any) => {
                            console.log(campaignData, "campData");
                            tmpqurty += "('"+campaignData.name+"', '"+campaignData.displayName+"', '"+campaignData.minSubUsecases+"', '"+campaignData.maxSubUsecases+"', '"+campaignData.validSubUsecase+"', '"+campaignData.classification+"'),";
                        });
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql =tmpqurty.slice(0, -1);
                        obj.prepare();
                        obj.execute((_error: any, data: any) => {
                            if(data.length > 0){
                                let objv = new RawView(res);
                                objv.prepare({ message: "Cases Fetched Successfully!", data: data });
                                objv.execute();
                            }
                            else{
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", error: _error });
                                objv.execute();
                            }
                        });*/

                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public campaignCases(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idcamp_cases`,`name`,`displayName`,`minSubUsecases`,`validSubUsecase`,`maxSubUsecases`,`rate`,`classification`,`nrc_rates`,`service_limit`,`description` FROM `campaign_cases`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Case Fetches",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    addCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campData = req.body;
                let id: any;
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'partnerCampaign/' + campData.campaign_key + '/sharing',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (_err: any, response: any, body: any) => {
                    if (!_err) {
                        try {
                            let data = JSON.parse(response.body);
                            if (response.statusCode == 200) {
                                if (!_err) {
                                    let obj5 = new ModelRawQuery(req, res);
                                    obj5.qrysql = "SELECT * FROM `campaign` WHERE `campaign_key` = '" + campData.campaign_key + "'";
                                    obj5.prepare();
                                    obj5.execute((_error: any, campaign: any) => {
                                        if (_error == 1) {
                                            //-- Get SMS Provider 
                                            obj5.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                                            obj5.prepare();
                                            obj5.execute((proerr: any, provider: any) => {
                                                if (proerr == 1 && provider.length > 0) {
                                                    if (campaign.length > 0) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            message: "Campaign Already Exists!",
                                                            status: 404
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let tmp: any = [];
                                                        let options: any = {
                                                            'method': 'PUT',
                                                            'url': apiUrl + 'partnerCampaign/' + data.campaignId + '/sharing/' + provider[0].username,
                                                            'headers': {
                                                                'Content-Type': 'application/json',
                                                                'Authorization': 'Basic ' + authKey
                                                            }
                                                        };
                                                        request(options, (err: any, response: any, body: any) => {
                                                            if (!err) {
                                                                try {
                                                                    let partnerCampaign = JSON.parse(response.body);
                                                                    if (response.statusCode == 200) {
                                                                        let obj = new ModelRawNonQuery(req, res);
                                                                        obj.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idbrand`,`campaign_key`, `campaign_name`, `status`) VALUES ('" + sessdata.iduser + "','" + campData.brandId + "', '" + campData.campaign_key + "', '" + campData.campaignName + "', '1')";
                                                                        obj.prepare();
                                                                        obj.execute((__error: any, data: any) => {
                                                                            if (__error == 1) {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Campaign Added Successfully!", result: data, status: 201 });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Something Went Wrong With Connection!", error: data, status: 502 });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: data[0].field + " " + data[0].description, error: error, status: 502 });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                catch (e) {
                                                                    console.log("Error :: addcampaign ::",e);
                                                                    let obj = new RawView(res);
                                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                    obj.execute();
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    status: 502,
                                                                    message: "Service Profile not found!",
                                                                    error: proerr,
                                                                    campaignId: null
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        status: 502,
                                                        message: "Service Profile not found!",
                                                        error: proerr,
                                                        campaignId: null
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Connection!", error: campaign, status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: data[0].field + " " + data[0].description, status: 502 });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: data[0].field + " " + data[0].description, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: addcampaign ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let obj = new RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }

                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public registerCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let checkService = new APIBase();
                checkService.serviceActivation(req, res, sessdata, "7", (err, resp) => {
                    if (resp.status == 200) {
                        let campData: any = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;                        
                        let objb = new ModelRawQuery(req, res);
                        objb.qrysql = "SELECT brandId,entityType,identityStatus FROM `brand` WHERE `brandId`='" + campData.brandId + "' AND `deleted`=0";
                        objb.prepare();
                        objb.execute((bError, bRes) => {                            
                            if (bError == 1 && bRes.length > 0) {
                                if(bRes[0].entityType == 'SOLE_PROPRIETOR'){
                                    let objc = new ModelRawQuery(req, res);
                                    objc.qrysql = "SELECT idbrand From `campaign` WHERE `idbrand`='" + bRes[0].brandId + "' AND `deleted`=0";
                                    objc.prepare();
                                    objc.execute((cError, cRes) => {                                    
                                        if (cError == 1 && cRes.length < 1) {
                                            // fOR Sole proprietor
                                            let fun = new NewCampaign();
                                            fun.inRegisterCampaign(req, res, next);
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ error: cError, message: "Active campaign per brand, per usecase limit exceeded " + campData.brandId, status: 502 });
                                            objv.execute();

                                        }
                                    })
                                }
                                else if(bRes[0].entityType == 'NON_PROFIT' && campData.usecase == 'POLITICAL'){
                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT `evpId` FROM `brand_vetting` WHERE `brandId`='" + campData.brandId + "' AND `evpId`= 'CV' AND `idaccount` = " + sessdata.idaccount + " ";
                                    obj.prepare();
                                    obj.execute((errrr: any, resBV: any) => {
                                    if(errrr == 1)
                                    {
                                        if(resBV.length > 0){
                                            let fun = new NewCampaign();
                                            fun.inRegisterCampaign(req, res, next);
                                        }
                                        else{
                                            let objv = new RawView(res);
                                            objv.prepare({status: 504, message: "Campaign can not register for POLITICAL usecase. Because there is no vetting imported for Campaign Verified" });
                                            objv.execute();
                                        }                                        
                                    }
                                    else{
                                        let objv = new RawView(res);
                                        objv.prepare({status: 505, message: "Something went wrong with checking brand vetting!"});
                                        objv.execute();
                                    }
                                    })
                                }
                                else{
                                    let fun = new NewCampaign();
                                    fun.inRegisterCampaign(req, res, next);
                                }                                
                            }
                            else {
                                let fun = new NewCampaign();
                                fun.inRegisterCampaign(req, res, next);
                            }
                        })
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error_code: err,
                            status: resp.status,
                            message: resp.message.replace(/::SN::/g, "Campaign Registration")
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public inRegisterCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {

                let campData: any = req.body.campaignData !== undefined ? JSON.parse(req.body.campaignData) : req.body;                
                if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                    campData.optinKeywords = campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                }
                if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                    campData.optoutKeywords = campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                }

                if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                    campData.helpKeywords = campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
                }

                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT *, (IFNULL(rate, 0) + IFNULL(nrc_rates, 0)) totalRates, service_limit From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                obj0.prepare();
                obj0.execute((campError, camp) => {
                    if (campError == 1 && camp.length > 0) {
                        //-- Get SMS Provider 
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = " + sessdata.iduser + " ) AND p.type='sms'";
                        obj1.prepare();
                        obj1.execute((proerr: any, provider: any) => {
                            if (proerr == 1 && provider.length > 0) {

                                let CRate: any = typeof camp[0].totalRates != 'undefined' && camp[0].totalRates > 0 ? camp[0].totalRates : 0
                                let __rate: any = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0
                                let __nrc_rates: any = typeof camp[0].nrc_rates != 'undefined' && camp[0].nrc_rates > 0 ? camp[0].nrc_rates : 0

                                if (CRate > 0) {
                                    let Obj = new ModelRawQuery(req, res);
                                    Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= '" + CRate + "'";
                                    Obj.prepare();
                                    Obj.execute((bErr: any, bRes) => {
                                        if (bErr == 1) {
                                            if (bRes.length > 0) {
                                                let options: any = {
                                                    'method': 'POST',
                                                    'url': apiUrl + 'campaignBuilder',
                                                    'headers': {
                                                        'Content-Type': 'application/json',
                                                        'Authorization': 'Basic ' + authKey
                                                    },
                                                    body: JSON.stringify(campData)
                                                };
                                                request(options, async (error: any, response: any, body: any) => {
                                                    if (!error) {
                                                        try {
                                                            let resData = JSON.parse(response.body);
                                                            if (resData.campaignId) {
                                                                let tmp: any = [];
                                                                Object.entries(resData.mnoMetadata).forEach((ele: any) => {
                                                                    let t = ele[1];
                                                                    t["class"] = ele[0];
                                                                    tmp.push(t);
                                                                });
                                                                let campaignData1 = tmp;
                                                                let obj00 = new ModelRawNonQuery(req, res);
                                                                obj00.nonqrysql = "INSERT INTO `campaign` (`iduser`,`idaccount`,`idbrand`,`campaign_key`, `campaign_name`,`noEmbeddedLink`, `noEmbeddedPhone`,`campaign_description`, `messageFlow`, `optinMessage`,`optinKeywords`, `optoutMessage`,`optoutKeywords`, `helpMessage`,`helpKeywords`, `vertical`, `sample1`, `sample2`, `sample3`, `sample4`, `sample5`, `usecase`, `subUsecases`,`autoRenewal`, `affiliateMarketing`, `termsAndConditions`, `numberPool`,`ageGated`, `directLending`, `did_limit`,`subscriberOptin`,`subscriberOptout`,`subscriberHelp`,`cost`) VALUES(" + sessdata.iduser + "," + sessdata.idaccount + ",'" + campData.brandId + "', '" + resData.campaignId + "','" + campData.campaignName + "', '" + campData.embeddedLink + "', '" + campData.embeddedPhone + "','" + parseBody(campData.description) + "', '" + parseBody(campData.messageFlow) + "', '" + parseBody(campData.optinMessage) + "', '" + parseBody(campData.optinKeywords) + "', '" + parseBody(campData.optoutMessage) + "', '" + parseBody(campData.optoutKeywords) + "', '" + parseBody(campData.helpMessage) + "', '" + parseBody(campData.helpKeywords) + "', '" + campData.vertical + "', '" + parseBody(campData.sample1) + "', '" + parseBody(campData.sample2) + "', '" + parseBody(campData.sample3) + "', '" + parseBody(campData.sample4) + "', '" + parseBody(campData.sample5) + "', '" + campData.usecase + "', '" + campData.subUsecases + "', '" + campData.autoRenewal + "', '" + campData.affiliateMarketing + "', '" + campData.termsAndConditions + "', '" + campData.numberPool + "', '" + campData.ageGated + "', '" + campData.directLending + "', '" + camp[0].service_limit + "','" + campData.subscriberOptin + "','" + campData.subscriberOptout + "','" + campData.subscriberHelp + "', '" + __rate + "')";

                                                                obj00.prepare();
                                                                obj00.execute((_errorr: any, data: any) => {
                                                                    if (_errorr == 1) {
                                                                        //insert mno
                                                                        let campMno = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`campaign_key`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES";
                                                                        campaignData1.forEach((campaignData: any) => {
                                                                            campMno += "(" + sessdata.iduser + "," + sessdata.idaccount + ", '" + resData.campaignId + "', '" + campaignData.class + "'," + campaignData.minMsgSamples + ", '" + campaignData.mno + "', '" + campaignData.mnoReview + "', '" + campaignData.mnoSupport + "', '" + campaignData.msgClass + "','" + campaignData.noEmbeddedLink + "','" + campaignData.noEmbeddedPhone + "','" + campaignData.qualify + "', '" + campaignData.reqSubscriberHelp + "', '" + campaignData.reqSubscriberOptin + "', '" + campaignData.reqSubscriberOptout + "','" + campaignData.brandTier + "','" + campaignData.tpm + "','" + campaignData.mmsTpm + "','" + campaignData.tpmScope + "','" + campaignData.brandDailyCap + "','" + campaignData.surcharge + "','" + campaignData.tpn + "','REGISTERED',0),";
                                                                        });
                                                                        let obj01 = new ModelRawNonQuery(req, res);
                                                                        obj01.nonqrysql = campMno.slice(0, -1);
                                                                        obj01.prepare();
                                                                        obj01.execute((_errorr: any, campMnoData: any) => {

                                                                        })

                                                                        //Update Campaign
                                                                        let fun = new NewCampaign();
                                                                        fun.updateinRegisterCampaign(req, resData.campaignId, res, next);

                                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + resData.campaignId + "', " + __rate + "," + __nrc_rates + ",1,'Campaign Registered')";
                                                                        obj4.prepare();
                                                                        obj4.execute((campErr, __resp) => {
                                                                            if (campErr == 1) {
                                                                                console.log("Campaign Log Updated Successfully.");
                                                                            }
                                                                            else {
                                                                                console.log("Campaign Log Not Updated!");
                                                                            }
                                                                        });
                                                                        // To brand Log Update
                                                                        let obj2 = new ModelRawNonQuery(req, res);
                                                                        obj2.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount`=" + sessdata.idaccount + " ";
                                                                        obj2.prepare();
                                                                        obj2.execute((__error, resp) => {
                                                                            if (__error == 1) {
                                                                                // To Insert Data in wallet_recharge_log 
                                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                                iQry += "`amount`=-" + CRate + ", "
                                                                                iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "
                                                                                iQry += "`status`=1;"
                                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                                objWL.nonqrysql = iQry
                                                                                objWL.prepare()
                                                                                objWL.execute((error: any, result: any) => {
                                                                                    console.log("Transaction response::", result)
                                                                                })
                                                                            }
                                                                            else {
                                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                                iQry += "`amount`=-" + CRate + ", "
                                                                                iQry += "`purpose`='Wallet amount not successfully updated for campaign registration', "
                                                                                iQry += "`status`=2;"
                                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                                objWL.nonqrysql = iQry
                                                                                objWL.prepare()
                                                                                objWL.execute((error: any, result: any) => {
                                                                                    console.log("Transaction response::", result)
                                                                                })
                                                                                console.log("Wallet Not Updated!")
                                                                            }
                                                                        });
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 201, message: "Campaign Registered Successfully!", campaignId: resData.campaignId, data: resData });
                                                                        objv.execute();

                                                                        if (campData.sampleMediaLastId !== undefined && campData.sampleMediaLastId.length > 0) {
                                                                            let payLoad = {
                                                                                campaignId: resData.campaignId,
                                                                                key: campData.campaignKey,
                                                                                sampleMediaLastId: campData.sampleMediaLastId
                                                                            }
                                                                            let camp = new NewCampaign();
                                                                            camp.addCampaignFile(req, res, sessdata, payLoad, (errorr, resp) => {
                                                                            });
                                                                        }

                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Campaign Detail Error.", error: error, status: 502 });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: resData[0].fields + " " + resData[0].description, status: 502 });
                                                                objv.execute();
                                                            }
                                                        }
                                                        catch (e) {
                                                            console.log("Error :: inregisterCampaign ::",e);
                                                            let obj = new RawView(res);
                                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                            obj.execute();
                                                        }

                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ error: bErr, message: "Please add funds to your account or contact support.", status: 503 });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ error: bErr, message: "Something Went Wrong to Fetch Account Balance!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                    iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                    iQry += "`amount`='-" + CRate + "', "
                                    iQry += "`purpose`='Billing prorate should be greater then 0 to register a campaign', "
                                    iQry += "`status`=2;"

                                    let objWL = new ModelRawNonQuery(req, res);
                                    objWL.nonqrysql = iQry
                                    objWL.prepare()
                                    objWL.execute((error: any, result: any) => {
                                        console.log("Transaction response::", result)
                                    })

                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Billing prorate should be greater then 0 to register a campaign!",
                                        error: ""
                                    });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    status: 502,
                                    message: "Service Profile not found!",
                                    error: proerr,
                                    campaignId: null
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Please Select Correct Usecase!",
                            error: camp,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /********************************
    * Campaign Sumbimt to DCA Start 
    */

    public dcaSubmit(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campId: any = req.body.data !== undefined ? JSON.parse(req.body.data).campId : req.query.campaignId;
                let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
                let idaccount: any = req.body.data !== undefined ? JSON.parse(req.body.data).idaccount : sessdata.idaccount;
                let Obj00 = new ModelRawQuery(req, res);
                Obj00.qrysql = "SELECT `deleted` FROM `campaign` WHERE `iduser`=" + iduser + " AND `campaign_key`='" + campId + "' AND `deleted` = 0";
                Obj00.prepare();
                Obj00.execute((_Err: any, campRes) => {
                    if (_Err == 1 && campRes.length > 0) {
                        let Obj0 = new ModelRawQuery(req, res);
                        Obj0.qrysql = "SELECT `idtariff` FROM `user` WHERE `iduser`=" + iduser + " AND `is_deleted` = 0";
                        Obj0.prepare();
                        Obj0.execute((bErr: any, bRes) => {
                            if (bErr == 1 && bRes.length > 0) {
                                let rate = new APIBase;
                                rate.getCampaignRate(req, res, bRes[0].idtariff, "campaign", "campaign_review", (err, rates) => {
                                    let camp_rates: any = Array.isArray(rates) && rates.length > 0 ? rates[0].rate : 0;
                                    // if (camp_rates > 0) {
                                    let Obj = new ModelRawQuery(req, res);
                                    Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + idaccount + " AND `balance` + `credit_limit` >= '" + camp_rates + "'";
                                    Obj.prepare();
                                    Obj.execute((bErr: any, bRes) => {
                                        if (bErr == 1 && bRes.length > 0) {
                                            let obj1 = new ModelRawQuery(req, res);
                                            obj1.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = " + iduser + " ) AND p.type='sms'";
                                            obj1.prepare();
                                            obj1.execute((proerr: any, provider: any) => {
                                                if (proerr == 1 && provider.length > 0) {
                                                    let options: any = {
                                                        'method': 'PUT',
                                                        'url': apiUrl + 'partnerCampaign/' + campId + '/sharing/' + provider[0].username,
                                                        'headers': {
                                                            'Content-Type': 'application/json',
                                                            'Authorization': 'Basic ' + authKey
                                                        }
                                                    };
                                                    request(options, (error: any, response: any, body: any) => {
                                                        if (!error) {
                                                            try {
                                                                let partnerCampaign = JSON.parse(response.body);
                                                                if (partnerCampaign.upstreamCnpId) {
                                                                    let obj2 = new ModelRawNonQuery(req, res);
                                                                    obj2.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-'" + camp_rates + "' WHERE `idaccount`=" + idaccount + " ";
                                                                    obj2.prepare();
                                                                    obj2.execute((__error, resp) => {
                                                                        if (__error == 1) {
                                                                            // To Insert Data in wallet_recharge_log 
                                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                            iQry += "`idaccount`=" + idaccount + ", "
                                                                            iQry += "`amount`=-" + camp_rates + ", "
                                                                            iQry += "`purpose`='Wallet amount successfully updated for campaign DCA Submit', "
                                                                            iQry += "`status`=1;"
                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                            objWL.nonqrysql = iQry
                                                                            objWL.prepare()
                                                                            objWL.execute((error: any, result: any) => {
                                                                                console.log("Transaction response::", result)
                                                                            })
                                                                        }
                                                                        else {
                                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                            iQry += "`idaccount`=" + idaccount + ", "
                                                                            iQry += "`amount`=-" + camp_rates + ", "
                                                                            iQry += "`purpose`='Wallet amount not successfully updated for campaign DCA Submit', "
                                                                            iQry += "`status`=2;"
                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                            objWL.nonqrysql = iQry
                                                                            objWL.prepare()
                                                                            objWL.execute((error: any, result: any) => {
                                                                                console.log("Transaction response::", result)
                                                                            })
                                                                            console.log("Wallet Not Updated!")
                                                                        }
                                                                    });
                                                                    // To Campaign Log Insert
                                                                    let obj4 = new ModelRawNonQuery(req, res);
                                                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES (" + idaccount + ", " + iduser + "','" + campId + ", " + camp_rates + ",'',27,'Campaign DCA Submit Cost')";
                                                                    obj4.prepare();
                                                                    obj4.execute((campErr, __resp) => {
                                                                        if (campErr == 1) {
                                                                            console.log("Campaign Log Updated Successfully.");
                                                                        }
                                                                        else {
                                                                            console.log("Campaign Log Not Updated!");
                                                                        }
                                                                    });
                                                                    // To Campaign Update
                                                                    let obj01 = new ModelRawNonQuery(req, res);
                                                                    obj01.nonqrysql = "UPDATE `campaign` SET `provisioning_status`='1', `downstreamCnpId`='" + partnerCampaign.downstreamCnpId + "', `upstreamCnpId`='" + partnerCampaign.upstreamCnpId + "', `sharingStatus`='" + partnerCampaign.sharingStatus + "', `sharedDate`='" + partnerCampaign.sharedDate + "',`statusDate`='" + partnerCampaign.statusDate + "' WHERE `campaign_key`='" + campId + "' AND `iduser`=" + iduser + " AND `deleted`=0";
                                                                    obj01.prepare();
                                                                    obj01.execute((____error, resp) => {
                                                                        if (____error == 1) {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ status: 200, message: "DCA submitted successfully!" });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ status: 502, message: "Something Went Wrong!" });
                                                                            objv.execute();
                                                                        }
                                                                    })
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: partnerCampaign[0].description, status: partnerCampaign[0].code });
                                                                    objv.execute();
                                                                }
                                                            }
                                                            catch (e) {
                                                                console.log("Error :: DCASubmit ::",e);
                                                                let obj = new RawView(res);
                                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                obj.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: "Something Went Wrong!" });
                                                            objv.execute();
                                                        }
                                                    })
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 502, message: "Something Went Wrong With Service Profile!" });
                                                    objv.execute();
                                                }
                                            })
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Account Balance is Low!", status: 502 });
                                            objv.execute();
                                        }
                                    })
                                    /* }
                                    else{
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Rate Not Found!", status: 503 });
                                        objv.execute();
                                    } */
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went wrong with tariff!", status: 504 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Campaign Expired" });
                        objv.execute();
                    }

                })

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }

        });
    }

    public updateinRegisterCampaign(req: Request, campaignId: any, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let campData: any = req.body;
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campaignId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(campData)
                };
                request(options, (errorr: any, response: any, body: any) => {
                    if (!errorr) {
                        try {
                            let getCamp = JSON.parse(response.body);
                            if (getCamp.campaignId && getCamp.campaignId !== undefined) {
                                let obj01 = new ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `campaign` SET `campaign_status`='" + getCamp.status + "',`nextRenewalOrExpirationDate`='" + getCamp.nextRenewalOrExpirationDate + "',`billedDate`='" + getCamp.billedDate + "',`createDate`='" + getCamp.createDate + "' WHERE `campaign_key`='" + getCamp.campaignId + "' AND `iduser`=" + sessdata.iduser + " AND `deleted`=0";
                                obj01.prepare();
                                obj01.execute((____error, resp) => {
                                    console.log("nextRenewalOrExpirationDate updated");
                                })
                            }
                            else {
                                console.log("nextRenewalOrExpirationDate not updated.");

                            }
                        }
                        catch (e) {
                            console.log("Error :: updateinRegisterCampaign ::",e);
                            console.log("nextRenewalOrExpirationDate not updated!");
                        }
                    }
                    else {
                        console.log("nextRenewalOrExpirationDate not updated!!");
                    }
                });

            }
        })

    }

    public CampaignRegister(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let campData: any = req.body;
                let CRate: any = typeof campData.rate != 'undefined' && campData.rate > 0 ? campData.rate : 0;
                //-- Get SMS Provider 
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT p.`priority`, UPPER(u.`username`)`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='sms'";
                obj1.prepare();
                obj1.execute((proerr: any, provider: any) => {
                    if (proerr == 1 && provider.length > 0) {
                        if (CRate > 0) {
                            let objv = new RawView(res);
                            if (campData.brandId) {
                                var key: any;
                                let options: any = {
                                    'method': 'POST',
                                    'url': apiUrl + 'campaignBuilder',
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        'Authorization': 'Basic ' + authKey
                                    },
                                    body: JSON.stringify(campData)
                                };
                                request(options, (error: any, response: any, body: any) => {
                                    let body2: any = {}
                                    try {
                                        body2 = JSON.parse(body)
                                    } catch {
                                        body2 = body
                                    }
                                    let campaignId: any = typeof body2.campaignId != 'undefined' ? body2.campaignId : ""
                                    if (!error) {
                                        let resData = JSON.parse(response.body);
                                        if (resData.campaignId) {
                                            let tmp: any = [];
                                            let options: any = {
                                                'method': 'PUT',
                                                'url': apiUrl + 'partnerCampaign/' + resData.campaignId + '/sharing/' + provider[0].username,
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                }
                                            };
                                            request(options, (error: any, response: any, body: any) => {
                                                if (!error) {
                                                    try {
                                                        let partnerCampaign = JSON.parse(response.body);
                                                        if (response.body) {
                                                            Object.entries(resData.mnoMetadata).forEach((ele: any) => {
                                                                let t = ele[1];
                                                                t["class"] = ele[0];
                                                                tmp.push(t);
                                                            });
                                                            let campaignData1 = tmp;
                                                            let tmpqurty = "INSERT INTO `campaign` (`iduser`,`idbrand`,`campaign_key`, `campaign_class`, `campaign_name`, `minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`, `surcharge`, `tpn`, `brandTier`, `campaign_description`, `downstreamCnpId`, `upstreamCnpId`, `sharingStatus`, `sharedDate`, `statusDate`,`cost`) VALUES ";
                                                            campaignData1.forEach((campaignData: any) => {
                                                                tmpqurty += "('" + sessdata.iduser + "','" + campData.brandId + "', '" + resData.campaignId + "', '" + campaignData.class + "', '" + campData.campaignName + "', '" + campaignData.minMsgSamples + "', '" + campaignData.mno + "', '" + campaignData.mnoReview + "', '" + campaignData.mnoSupport + "', '" + campaignData.msgClass + "', '" + campaignData.noEmbeddedLink + "', '" + campaignData.noEmbeddedPhone + "', '" + campaignData.qualify + "', '" + campaignData.reqSubscriberHelp + "', '" + campaignData.reqSubscriberOptin + "', '" + campaignData.reqSubscriberOptin + "', '" + campaignData.surcharge + "', '" + campaignData.tpn + "', '" + campaignData.brandTier + "', '" + campData.description + "', '" + partnerCampaign.downstreamCnpId + "', '" + partnerCampaign.upstreamCnpId + "', '" + partnerCampaign.sharingStatus + "', '" + partnerCampaign.sharedDate + "', '" + partnerCampaign.statusDate + "', '" + CRate + "'),";
                                                            });

                                                            let obj = new ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = tmpqurty.slice(0, -1);
                                                            obj.prepare();
                                                            obj.execute((_error: any, data: any) => {
                                                                if (_error == 1) {

                                                                    if (campData.rate) {
                                                                        obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                                        obj.prepare();
                                                                        obj.execute((__error, resp) => {
                                                                            if (__error == 1) {

                                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                                                iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                                                iQry += "`amount`='-" + CRate + "', "

                                                                                iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "

                                                                                iQry += "`status`=1;"

                                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                                objWL.nonqrysql = iQry
                                                                                objWL.prepare()
                                                                                objWL.execute((error: any, result: any) => {
                                                                                    console.log("Transaction response::", result)
                                                                                })
                                                                                let obj3 = new ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`, `campaign_key`,`cost`, `date`, `description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + resData.campaignId + "', " + setToZero(campData.rate) + ", '" + Date.now() + "', 'Campaign_Rate')";
                                                                                obj3.prepare();
                                                                                obj3.execute((___error, resp) => {
                                                                                    if (___error == 1) {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ status: 201, message: "Campaign Register Successfully!", campaignId: resData.campaignId });
                                                                                        objv.execute();
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let obj2 = new ModelRawQuery(req, res);
                                                                        obj2.qrysql = "SELECT * From `campaign_cases` WHERE `name`='" + campData.usecase + "'";
                                                                        obj2.prepare();
                                                                        obj2.execute((campError, camp) => {
                                                                            if (campError == 1) {

                                                                                let CRate: any = typeof camp[0].rate != 'undefined' && camp[0].rate > 0 ? camp[0].rate : 0

                                                                                obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                                                obj.prepare();
                                                                                obj.execute((__error, resp) => {
                                                                                    if (__error == 1) {

                                                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                                                        iQry += "`amount`='-" + CRate + "', "

                                                                                        iQry += "`purpose`='Wallet amount successfully updated for campaign registration', "

                                                                                        iQry += "`status`=1;"

                                                                                        let objWL = new ModelRawNonQuery(req, res);
                                                                                        objWL.nonqrysql = iQry
                                                                                        objWL.prepare()
                                                                                        objWL.execute((error: any, result: any) => {
                                                                                            console.log("Transaction response::", result)
                                                                                        })

                                                                                        let obj3 = new ModelRawNonQuery(req, res);
                                                                                        obj3.nonqrysql = "INSERT INTO `brand_log` (`idaccount`, `iduser`,`campaign_key`,`cost`, `date`, `description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + resData.campaignId + "', " + setToZero(camp[0].rate) + ", '" + Date.now() + "', 'Campaign_Rate')";
                                                                                        obj3.prepare();
                                                                                        obj3.execute((___error, resp) => {
                                                                                            if (___error == 1) {
                                                                                                let objv = new RawView(res);
                                                                                                objv.prepare({ status: 201, message: "Campaign Register Successfully!", campaignId: resData.campaignId });
                                                                                                objv.execute();
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView(res);
                                                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                                objv.execute();
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", campaignId: resData.campaignId });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                                else {
                                                                    objv.prepare({
                                                                        message: "Something Went Wrong With Conection!",
                                                                        error: error,
                                                                        status: 502
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            objv.prepare({
                                                                message: "Something Went Wrong With Connection!",
                                                                error: error,
                                                                status: 502
                                                            });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: CampaignRegister ::",e);
                                                        let obj = new RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let obj = new RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    obj.execute();
                                                }

                                            });
                                        }
                                        else {
                                            objv.prepare({
                                                message: resData[0].field + " " + resData[0].description,
                                                error: "Campaign did not registered!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        objv.prepare({
                                            message: "Something Went Wrong With Connection!",
                                            error: error,
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                objv.prepare({
                                    err: 401,
                                    message: "brandId is mendatory field!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        }
                        else {
                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                            iQry += "`idaccount`=" + sessdata.idaccount + ", "

                            iQry += "`amount`='-" + CRate + "', "

                            iQry += "`purpose`='Billing prorate should be greater then 0 to register a campaign', "

                            iQry += "`status`=2;"

                            let objWL = new ModelRawNonQuery(req, res);
                            objWL.nonqrysql = iQry
                            objWL.prepare()
                            objWL.execute((error: any, result: any) => {
                                console.log("Transaction response::", result)
                            })

                            let objv = new RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Billing prorate should be greater then 0 to register a campaign!",
                                error: ""
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Service Profile not found!",
                            error: proerr,
                            campaignId: null
                        });
                        objv.execute();
                    }
                });
            }
        });
    }


    /*********************
    * Campaign MNO Detail
    */
    public mnoIddetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/mno',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "MNO Details Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With MNO Details Fetched!", error: error, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: mnoIdDetails ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************************************
    * get campaign details based on campaign id  *
    *********************************************/

    public getCampDetailById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let iduser: any = sessdata.type == 1 ? sdata.iduser : sessdata.iduser;
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT b.brandId,b.brand_name,c.iduser,c.idaccount,c.reqSubscriberOptin,c.reqSubscriberOptout,c.reqSubscriberHelp,c.campaign_key,c.usecase,c.start_date,c.sharedDate,c.statusDate,c.subUsecases,c.campaign_description,c.sample1,c.sample2,c.sample3,c.sample4,c.sample5,c.messageFlow,c.helpMessage,c.optinMessage,c.optoutMessage,c.optinKeywords,c.optoutKeywords,c.helpKeywords,c.autoRenewal,c.noEmbeddedLink,c.noEmbeddedPhone,c.affiliateMarketing,c.termsAndConditions,c.numberPool,c.ageGated,c.directLending,c.subscriberOptin,c.subscriberOptout,c.subscriberHelp,c.nextRenewalOrExpirationDate FROM `campaign`c INNER JOIN `brand`b ON b.brandId = c.idbrand WHERE `campaign_key`='" + sdata.campId + "' AND c.`iduser` = '" + sdata.iduser + "' AND c.`deleted` = 0 GROUP BY campaign_key";
                obj.qrysql = "SELECT b.brandId,b.brand_name,b.deleted `brand_deleted`,b.identityStatus,c.iduser,c.idaccount,c.reqSubscriberOptin,c.reqSubscriberOptout,c.reqSubscriberHelp,c.campaign_key,c.usecase,c.start_date,c.sharedDate,c.statusDate,c.subUsecases,c.campaign_description,c.sample1,c.sample2,c.sample3,c.sample4,c.sample5,c.messageFlow,c.helpMessage,c.optinMessage,c.optoutMessage,c.optinKeywords,c.optoutKeywords,c.helpKeywords,c.autoRenewal,c.noEmbeddedLink,c.noEmbeddedPhone,c.affiliateMarketing,c.termsAndConditions,c.numberPool,c.ageGated,c.directLending,c.subscriberOptin,c.subscriberOptout,c.subscriberHelp,c.nextRenewalOrExpirationDate,c.deleted,c.provisioning_status FROM `campaign`c INNER JOIN `brand`b ON b.brandId = c.idbrand WHERE `campaign_key`='" + sdata.campId + "' AND c.`iduser` = " + iduser + " GROUP BY campaign_key";

                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    /*********************************************
    * get campaign Mno details based on campaign id  *
    *********************************************/

    public getMnoMetaDataDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,usecase,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE brandDailyCap END )`brandDailyCap` FROM `campaign` WHERE `campaign_key`='" + sdata.campId + "' AND `iduser`=" + sdata.iduser + " ";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Mno Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Mno Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    public getCampMnoMetaDataDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE brandDailyCap END )`brandDailyCap` FROM `campaign_mno` WHERE `campaign_key`='" + sdata.campId + "' AND `iduser`='" + sdata.iduser + "'";

                obj.qrysql = "SELECT iduser,campaign_class,mno,mnoReview,mnoSupport, (CASE WHEN msgClass ='undefined' THEN 'N/A' ELSE msgClass END )`msgClass` ,qualify,reqSubscriberOptin,reqSubscriberOptout,reqSubscriberHelp,noEmbeddedLink,noEmbeddedPhone,tpn,(CASE WHEN brandTier ='undefined' THEN 'N/A' ELSE brandTier END )`brandTier`,(CASE WHEN tpm ='undefined' THEN 'N/A' ELSE tpm END)`tpm`,(CASE WHEN mmsTpm ='undefined' THEN 'N/A' ELSE mmsTpm END )`mmsTpm`,(CASE WHEN tpmScope ='undefined' THEN 'N/A' ELSE tpmScope END )`tpmScope`,(CASE WHEN brandDailyCap ='undefined' THEN 'N/A' ELSE CASE WHEN brandDailyCap ='null' THEN 'No' ELSE brandDailyCap END END )`brandDailyCap`,`mno_status`,`dca_elect` FROM `campaign_mno` WHERE `campaign_key`='" + sdata.campId + "' AND `iduser`=" + sdata.iduser + " ";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Mno Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Campaign Mno Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getMnoMetaDataForRegister(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let brandId: any = data.type !== undefined ? JSON.parse(data.type).brandId : data.brandId;
                let usecase: any = data.type !== undefined ? JSON.parse(data.type).usecase : data.usecase;

                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaignBuilder/brand/' + brandId + '/usecase/' + usecase,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let data = JSON.parse(response.body);
                            if (data.mnoMetadata && data.mnoMetadata != undefined) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Mno Meta Details Records Fetched!", data: data.mnoMetadata, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: data[0].field + " " + data[0].description, status: data[0].code });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getMnoDataForRegister ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With API!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public brandQualifyAllUseCases(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let brandId: any = data.type !== undefined ? JSON.parse(data.type).brandId : data.brandId;

                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaignBuilder/brand/' + brandId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let data = JSON.parse(response.body);
                            if (data && data != undefined) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Use Case Records Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: data[0].field + " " + data[0].description, status: data[0].code });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: BrandQualifyAllUseCases ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Use Case!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /********************************************************************
    * Check NON Profit Brand and CV vetting appllied on NON Profit Brand*
    * CV = Campaign Verify Token of Vetting Partner 
    ********************************************************************/
       public checkNonProfitBrand(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT b.`entityType`, b.`einIssuingCountry`, bv.`evpId` FROM `brand` b  INNER JOIN `brand_vetting` bv ON b.`brandId` = bv.`brandId` WHERE b.`brandId` = '" + data.type + "' AND b.`entityType` = 'NON_PROFIT' AND bv.`evpId` = 'CV' AND b.`idaccount` = " + sessdata.idaccount + "";
                obj.prepare();
                obj.execute((errBrand: any, resultBrand: any) => {
                    if (errBrand == 1 && resultBrand.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ error: errBrand, data:resultBrand, message: "Non Profit Brand Vetting Verified CV Imported Vetting Data Found!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: errBrand, message: "Brand CV Vetting Does Not Exist!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getConnPartnersDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/cnp',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Connectivity Partners Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getConnParnterDetails ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getResellerDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'reseller/RAP07Z4',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };

                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "Reseller Records Fetched!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Reseller Records Not Fetched!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getResellerDetails ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getMNOList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let options: any = {
                    'method': 'Get',
                    'url': apiUrl + 'enum/mno',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "MNO ID's Fetched Successfully!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Fetched MNO ID's!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getMNOList ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetched MNO ID's!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public mnoMetaData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campId = req.query;
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaign/' + campId.campaignId + '/mnoMetadata',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if (response.body) {
                                let data = JSON.parse(response.body);
                                let objv = new RawView(res);
                                objv.prepare({ message: "MNO MetaData Fetched successfully!", data: data, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "MNO MetaData Not Fetched!", error: error, status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: mnoMetaData ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "MNO MetaData Not Fetched!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public getCampDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campId = req.query;
                let options: any = {
                    'method': 'GET',
                    'url': apiUrl + 'campaign/' + campId.campaignId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let data = JSON.parse(response.body);
                            delete data.cspId;
                            delete data.mock;
                            delete data.resellerId;
                            if (data.campaignId && data.campaignId !== undefined) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Campaign Details Fetched successfully!", data: data, status: 200 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: data[0].field + " " + data[0].description, error: data, status: data[0].code });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getCampDetails ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Campaign Detail!", error: error, status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /****************
    * 's AutoRenual * 
    ****************/
    public updateCamapign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let reqData: any = req.body.data !== undefined ? JSON.parse(req.body.data).mainData : req.body;
            let campId: any = req.body.data !== undefined ? JSON.parse(req.body.data).campId : req.query.campaignId;
            let iduser: any = req.body.data !== undefined ? JSON.parse(req.body.data).iduser : sessdata.iduser;
            var resultAllCampaign = [];
            for (var i in reqData) {
                // reqData[i] !== '' &&
                if (reqData[i] !== 'undefined') {
                    resultAllCampaign.push([i, reqData[i]]);
                }
            }
            let campData = Object.fromEntries(resultAllCampaign);
            if (campData.optinKeywords && campData.optinKeywords !== null && campData.optinKeywords !== undefined) {
                campData.optinKeywords = campData.optinKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
            }
            if (campData.optoutKeywords && campData.optoutKeywords !== null && campData.optoutKeywords !== undefined) {
                campData.optoutKeywords = campData.optoutKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
            }

            if (campData.helpKeywords && campData.helpKeywords !== null && campData.helpKeywords !== undefined) {
                campData.helpKeywords = campData.helpKeywords.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, ' ').replace(/\s+/g, ',').replace(/,*$/, '');
            }


            if (error == 1) {
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(campData)
                }
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let resData = JSON.parse(response.body);
                            if (resData.campaignId && resData.campaignId !== undefined) {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `campaign` SET `campaign_description`='" + parseBody(resData.description) + "',`sample1`='" + parseBody(resData.sample1) + "',`sample2`='" + parseBody(resData.sample2) + "',`sample3`='" + parseBody(resData.sample3) + "',`sample4`='" + parseBody(resData.sample4) + "',`sample5`='" + parseBody(resData.sample5) + "',`messageFlow`='" + parseBody(resData.messageFlow) + "',`helpMessage`='" + parseBody(resData.helpMessage) + "',`optinKeywords`='" + parseBody(resData.optinKeywords) + "',`optoutKeywords`='" + parseBody(resData.optoutKeywords) + "',`helpKeywords`='" + parseBody(resData.helpKeywords) + "',`optinMessage`='" + parseBody(resData.optinMessage) + "',`optoutMessage`='" + parseBody(resData.optoutMessage) + "',`autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "',`subscriberOptin`='" + resData.subscriberOptin + "',`subscriberOptout`='" + resData.subscriberOptout + "',`subscriberHelp`='" + resData.subscriberHelp + "',`noEmbeddedLink`='" + resData.embeddedLink + "',`noEmbeddedPhone`='" + resData.embeddedPhone + "',`termsAndConditions`='" + resData.termsAndConditions + "',`numberPool`='" + resData.numberPool + "',`ageGated`='" + resData.ageGated + "',`directLending`='" + resData.directLending + "',`affiliateMarketing`='" + resData.affiliateMarketing + "',`nextRenewalOrExpirationDate`='" + resData.nextRenewalOrExpirationDate + "',`billedDate`='" + resData.billedDate + "',`createDate`='" + resData.createDate + "' WHERE `campaign_key`='" + campId + "' AND `iduser`=" + iduser + " AND `deleted`=0";
                                obj.prepare();
                                obj.execute((___error, resp) => {
                                    if (!error) {
                                        delete resData.cspId;
                                        delete resData.mock;
                                        delete resData.resellerId;
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 200, message: "Campaign details Updated Successfully!", data: resData });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Campaign details Not updated!", data: resData, status: 501 });
                                        objv.execute();
                                    }
                                })

                                // To Campaign Log Update
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + campId + "', '','',3,'Campaign Updated')";
                                obj4.prepare();
                                obj4.execute((campErr, __resp) => {
                                    if (campErr == 1) {
                                        console.log("Campaign Log Updated Successfully.");
                                    }
                                    else {
                                        console.log("Campaign Log Not Updated!");
                                    }
                                });
                            }
                            else {
                                // To Campaign Log Update
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + campId + "', '','',4,'Campaign Update Failed')";
                                obj4.prepare();
                                obj4.execute((campErr, __resp) => {
                                    if (campErr == 1) {
                                        console.log("Campaign Log Updated Successfully.");
                                    }
                                    else {
                                        console.log("Campaign Log Not Updated!");
                                    }
                                });

                                let objv = new RawView(res);
                                objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: updateCampaign ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*******************************
    *  Update Campaign's AutoRenual*
    *******************************/

    public updateAutoRenualCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let reqData: any = req.body;
                let campId: any = req.query.campaignId;
                let iduser: any = sessdata.iduser;
                var reqCampaign = [];
                for (var i in reqData) {
                    if (reqData[i] !== '' && reqData[i] !== 'undefined') {
                        reqCampaign.push([i, reqData[i]]);
                    }
                }
                let campData = Object.fromEntries(reqCampaign);

                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campId,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify(campData)
                }
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            let resData = JSON.parse(response.body);
                            if (resData.campaignId && resData.campaignId !== undefined) {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `campaign` SET `autoRenewal`='" + resData.autoRenewal + "',`campaign_status`='" + resData.status + "' WHERE `campaign_key`='" + campId + "' AND `iduser`=" + iduser + " AND `deleted`=0";
                                obj.prepare();
                                obj.execute((___error, resp) => {
                                    if (!error) {
                                        delete resData.cspId;
                                        delete resData.mock;
                                        delete resData.resellerId;
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 200, message: "Auto Renewal Updated Successfully!", data: resData });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Auto Renewal Not updated", data: resData, status: 501 });
                                        objv.execute();
                                    }
                                })
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: resData[0].field + " " + resData[0].description, error: resData, status: resData[0].code });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: updateAutoRenualCampaign ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: error, message: "Something Went Wrong With Request!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public deleteCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let campID = req.query.id && req.query.id !== undefined ? req.query.id : req.query.campaignId;
                let options: any = {
                    'method': 'DELETE',
                    'url': apiUrl + 'campaign/' + campID,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (error: any, response: any, body: any) => {
                    if (!error) {
                        try {
                            if ((response.statusCode == 204 && response.statusCode !== undefined) || (JSON.parse(body)[0].code == 502 && JSON.parse(body)[0].code !== undefined)) {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `campaign` SET `deleted`=1, `delete_date`=NOW() WHERE `campaign_key`='" + campID + "' AND `iduser`= " + sessdata.iduser + " ";
                                obj.prepare();
                                obj.execute((__error: any, camp: any) => {
                                    if (__error == 1) {
                                        obj.nonqrysql = "DELETE FROM `brand_log` WHERE `campaign_key`='" + campID + "' ";
                                        obj.prepare();
                                        obj.execute((__error: any, lastid: any) => {
                                            if (__error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Campaign Deleted Successfully!", campaignId: campID, status: 201 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                objv.execute();
                                            }
                                        });

                                        // To Campaign Log Update
                                        let obj4 = new ModelRawNonQuery(req, res);
                                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campID + "', '','','7','Camapaign Removed')";
                                        obj4.prepare();
                                        obj4.execute((campErr, __resp) => {
                                            if (campErr == 1) {
                                                console.log("Campaign Log Updated Successfully.");
                                            }
                                            else {
                                                console.log("Campaign Log Not Updated!");
                                            }
                                        });
                                    }
                                    else {
                                        // To Campaign Log Update
                                        let obj4 = new ModelRawNonQuery(req, res);
                                        obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES ('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + campID + "', '','','8','Camapaign Remove Failed')";
                                        obj4.prepare();
                                        obj4.execute((campErr, __resp) => {
                                            if (campErr == 1) {
                                                console.log("Campaign Log Updated Successfully.");
                                            }
                                            else {
                                                console.log("Campaign Log Not Updated!");
                                            }
                                        });

                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Campaign Not Deleted!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let data = JSON.parse(body);
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: data[0].field + ' ' + data[0].description,
                                    status: data[0].code
                                });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: deleteCampaign ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Campaign Not Deleted!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************************************
       *Start Resubmit Campaign  *
       *********************************************/
    public resubmitCampaign(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = JSON.parse(req.body.data);
                let campID = sdata.campId;
                // let mnoDetail:any =[];
                let mnoDetail = sdata.mnodetail;
                //  let resultAllBrand:any = [];
                // mnoDetail.forEach((campaignmnoData: any) => {
                //     resultAllBrand.push(campaignmnoData.campaign_class); 
                // })
                // let mnoData = resultAllBrand;
                let options: any = {
                    'method': 'PUT',
                    'url': apiUrl + 'campaign/' + campID + '/resubmit',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    },
                    body: JSON.stringify({ 'mnoIds': mnoDetail })
                };
                request(options, (err: any, response: any, body: any) => {
                    if (!err) {
                        try {
                            let resData = JSON.parse(response.body);
                            if (resData.campaignId) {
                                let tmp: any = [];
                                Object.entries(resData.mnoMetadata).forEach((ele: any) => {
                                    let t = ele[1];
                                    t["class"] = ele[0];
                                    tmp.push(t);
                                });
                                let campaignMNOData1 = tmp;
                                campaignMNOData1.forEach((mnoData: any) => {
                                    let obj0 = new ModelRawQuery(req, res);
                                    obj0.qrysql = "SELECT `campaign_class` FROM `campaign_mno` WHERE `campaign_key`='" + campID + "' AND `campaign_class`='" + mnoData.class + "' AND `iduser`=" + sessdata.iduser + " ";
                                    obj0.prepare();
                                    obj0.execute((_error: any, result: any) => {
                                        if (result.length > 0) {

                                            let obj = new ModelRawNonQuery(req, res);
                                            // obj.nonqrysql = "UPDATE `campaign` SET `tpmScope`='" + mnoData.tpmScope + "', `minMsgSamples`='" + mnoData.minMsgSamples + "',`msgClass`='" + mnoData.msgClass + "',`reqSubscriberOptout`='" + mnoData.reqSubscriberOptout + "',`mnoReview`='" + mnoData.mnoReview + "',`mmsTpm`='" + mnoData.mmsTpm + "',`noEmbeddedPhoneForMNO`='" + mnoData.noEmbeddedPhone + "',`mno`='" + mnoData.mno + "',`tpm`='" + mnoData.tpm + "',`reqSubscriberHelp`='" + mnoData.reqSubscriberHelp + "',`reqSubscriberOptin`='" + mnoData.reqSubscriberOptin + "',`mnoSupport`='" + mnoData.mnoSupport + "',`noEmbeddedLinkForMNO`='" + mnoData.noEmbeddedLink + "',`qualify`='" + mnoData.qualify + "',`campaign_class`='" + mnoData.class + "',`brandDailyCap`='" + mnoData.brandDailyCap + "',`brandTier`='" + mnoData.brandTier + "' WHERE `campaign_key`='" + campID + "' AND `campaign_class`='" + mnoData.class + "' AND `iduser`='" + sessdata.iduser + "'";
                                            obj.nonqrysql = "UPDATE `campaign_mno` SET `campaign_class`='" + mnoData.class + "',`minMsgSamples`='" + mnoData.minMsgSamples + "',`mno`='" + mnoData.mno + "',`mnoReview`='" + mnoData.mnoReview + "',`mnoSupport`='" + mnoData.mnoSupport + "',`msgClass`='" + mnoData.msgClass + "',`noEmbeddedLink`='" + mnoData.noEmbeddedLink + "',`noEmbeddedPhone`='" + mnoData.noEmbeddedPhone + "',`qualify`='" + mnoData.qualify + "',`reqSubscriberHelp`='" + mnoData.reqSubscriberHelp + "',reqSubscriberOptin='" + mnoData.reqSubscriberOptin + "',reqSubscriberOptout='" + mnoData.reqSubscriberOptout + "',`brandTier`='" + mnoData.brandTier + "',`tpm`='" + mnoData.tpm + "',`mmsTpm`='" + mnoData.mmsTpm + "',`tpmScope`='" + mnoData.tpmScope + "',`brandDailyCap`='" + mnoData.brandDailyCap + "'  WHERE `campaign_key`='" + campID + "' AND `campaign_class`='" + mnoData.class + "' AND `iduser`=" + sessdata.iduser + " ";
                                            // obj.nonqrysql = obj.slice(0, -1);
                                            obj.prepare();
                                            obj.execute((_errorr: any, data: any) => {
                                                if (_errorr == 1) {
                                                    console.log("Mno Update Successfully");
                                                }
                                                else {
                                                    console.log("Mno Not Updated");
                                                }
                                            })
                                        } else {

                                            let obj01 = new ModelRawNonQuery(req, res);
                                            obj01.nonqrysql = "INSERT INTO `campaign_mno` (`iduser`,`idaccount`,`campaign_key`, `campaign_class`,`minMsgSamples`,`mno`, `mnoReview`, `mnoSupport`, `msgClass`, `noEmbeddedLink`, `noEmbeddedPhone`,`qualify`,`reqSubscriberHelp`, `reqSubscriberOptin`, `reqSubscriberOptout`,`brandTier`,`tpm`,`mmsTpm`,`tpmScope`,`brandDailyCap`,`surcharge`,`tpn`,`mno_status`,`dca_elect`) VALUES(" + sessdata.iduser + "," + sessdata.idaccount + ", '" + campID + "', '" + mnoData.class + "','" + mnoData.minMsgSamples + "', '" + mnoData?.mno + "', '" + mnoData?.mnoReview + "', '" + mnoData?.mnoSupport + "', '" + mnoData?.msgClass + "','" + mnoData?.noEmbeddedLink + "','" + mnoData?.noEmbeddedPhone + "','" + mnoData?.qualify + "', '" + mnoData?.reqSubscriberHelp + "', '" + mnoData?.reqSubscriberOptin + "', '" + mnoData?.reqSubscriberOptout + "','" + mnoData?.brandTier + "','" + mnoData?.tpm + "','" + mnoData?.mmsTpm + "','" + mnoData?.tpmScope + "','" + mnoData?.brandDailyCap + "'," + mnoData?.surcharge + "," + mnoData?.tpn + ",'REGISTERED',0)"
                                            obj01.prepare();
                                            obj01.execute((_errorr: any, campMnoData: any) => {

                                            })
                                        }

                                    })
                                    let obj4 = new ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + campID + "','','',5,'Campaign Re-Submitted')";
                                    obj4.prepare();
                                    obj4.execute((campErr, __resp) => {
                                        if (campErr == 1) {
                                            console.log("Campaign Log Updated Successfully.");
                                        }
                                        else {
                                            console.log("Campaign Log Not Updated!");
                                        }
                                    });
                                })
                                let objv = new RawView(res);
                                objv.prepare({ message: "Campaign Resubmit Successfully!", campaignId: campID, status: 201 });
                                objv.execute();
                            }
                            else {
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `campaign_log` (`idaccount`, `iduser`, `campaign_key`,`cost`,`nrc_rates`,`event_type`,`description`) VALUES (" + sessdata.idaccount + ", " + sessdata.iduser + ",'" + campID + "', '','',6,'Campaign Re-Submit Failed')";
                                obj4.prepare();
                                obj4.execute((campErr, __resp) => {
                                    if (campErr == 1) {
                                        console.log("Campaign Log Updated Successfully.");
                                    }
                                    else {
                                        console.log("Campaign Log Not Updated!");
                                    }
                                });

                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: resubmitCampaign ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }

                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }

        });
    }

    /*************************************************************************
    *******************************Campaign Event Log*************************
    **************************************************************************/

    public getCampaignEvents(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idaccount, iduser, campaign_key, date, event_type, webhook_event_type, webhook_description_detail FROM `campaign_log` WHERE `request_type` != '0' AND `campaign_key`= '" + sdata.campId + "' ORDER BY `idcampaign_log` DESC";
                // obj.qrysql = "SELECT cl.idaccount, cl.iduser, cl.campaign_key, cl.date, cl.webhook_event_type, cl.webhook_description_detail,c.provisioning_status FROM `campaign_log` cl JOIN `campaign` c ON c.campaign_key=cl.campaign_key WHERE cl.request_type = '1' AND cl.campaign_key= '" + sdata.campId + "' ORDER BY `idcampaign_log` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Campaign Events Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "No Event Fetched!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /*************************************************************************
    * End Campaign Functionality *********************************************
    **************************************************************************/


    /*********************************************
    *Start get Tariff details based on TariffId  *
    *********************************************/

    public getSubscriptionPlan(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = JSON.parse(data.type);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT u.idtariff,t.name FROM `user`u INNER JOIN `tariff`t ON u.idtariff = t.idtariff WHERE u.`iduser`=" + sdata.iduser + " AND u.`idaccount` = " + sdata.idaccount + " ";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Tariff Detail Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Fetched Tariff Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************************************
    *End get Tariff details based on TariffId    *
    *********************************************/
    // Start Create Campaign File Sample
    public createCampaignFile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let campFileData: any = req.body.data;
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `campaign_file` (`mimeType`,`fileName`) VALUES ('" + campFileData.mimeType + "', '" + campFileData.fileName + "')";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT fileName FROM `campaign_file` WHERE `camp_file_id`=" + result.insertId + " ";
                        obj1.prepare();
                        obj1.execute((__error: any, CamFileRes: any) => {
                            if (__error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    data: CamFileRes,
                                    message: "Image Insert Successfully!",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Record not found!",
                                    status: 502
                                });
                                objv.execute();
                            }

                        })
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Insert Campaign File Detail!",
                            status: 502
                        });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }



    appealRequest(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((errsess: any, sessdata) => {
            if (errsess == 1) {
                let sdata = JSON.parse(req.body.payload);
                let files: any = req.files.length
                let Obj = new ModelRawQuery(req, res);
                Obj.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 10";
                Obj.prepare();
                Obj.execute((walletError: any, wallet: any) => {
                    if (walletError == 1 && wallet.length > 0) {
                        if (files > 0) {
                            let Obj_ap = new ModelRawQuery(req, res);
                            Obj_ap.qrysql = "SELECT `iduser`,`idaccount`,`identityStatus`, `brandId` FROM `brand` WHERE `idaccount`=" + sessdata.idaccount + " AND `brandId`= '" + sdata.brandId + "'";
                            Obj_ap.prepare();
                            Obj_ap.execute((result_appeal: any, result_ap: any) => {
                                if (result_appeal == 1 && result_ap.length > 0) {
                                    if (result_ap[0].identityStatus !== "VERIFIED") {
                                        let evidence = new NewCampaign();
                                        evidence.evidenceRequest(req, res, sessdata, 'BrandAppeal', (errorr, resp) => {
                                            if (resp.status == 200) {
                                                let obj1 = new ModelRawQuery(req, res);
                                                obj1.qrysql = "SELECT uuid from `evidence_files` WHERE `iduser`=" + sessdata.iduser + " AND `key`='" + resp.key + "' AND `brandId`='" + sdata.brandId + "'"
                                                obj1.prepare();
                                                obj1.execute((uuid_error, uuid_success) => {
                                                    let Resuuids: any = [];
                                                    Resuuids = JSON.parse(JSON.stringify(uuid_success));
                                                    const uuids = Resuuids.map((item: { uuid: any; }) => item.uuid);
                                                    if (uuid_error == 1) {
                                                        var options = {
                                                            'method': 'POST',
                                                            'url': apiUrl + 'brand/' + sdata.brandId + '/appeal',
                                                            'headers': {
                                                                'Content-Type': 'application/json',
                                                                'Authorization': 'Basic ' + authKey
                                                            },
                                                            body: JSON.stringify({
                                                                "appealCategories": sdata.category,
                                                                "attachmentUuids": uuids,
                                                                "explanation": sdata.explanation
                                                            })
                                                        };
                                                        request(options, function (error: any, response: any) {
                                                            if (!error) {
                                                                try {
                                                                    // let appealRequest = JSON.parse(response.body);
                                                                    let appealRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                                                    //if (error == null) {
                                                                    if (appealRequest == null || appealRequest == '') {
                                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                                        obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',10,'Pending',1,'Brand Appeal Requested Successfully')";
                                                                        obj4.prepare();
                                                                        obj4.execute((_err: any, result: any) => {
                                                                            console.log("Brand Appeal Log Updated");
                                                                        });
                                                                        let obj2 = new ModelRawNonQuery(req, res);
                                                                        obj2.nonqrysql = "INSERT INTO `brand_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`attachmentUuids`,`explanation`,`vetting_status`,`key`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',10,'" + sdata.category + "','" + uuids + "','" + parseBody(sdata.explanation) + "','Pending','" + resp.key + "')";
                                                                        obj2.prepare();
                                                                        obj2.execute((_err: any, result: any) => {
                                                                            if (_err == 1) {
                                                                                let obj3 = new ModelRawNonQuery(req, res);
                                                                                obj3.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-10 WHERE `idaccount`=" + sessdata.idaccount + " "
                                                                                obj3.prepare();
                                                                                obj3.execute((wallet_error, wallet_success) => {
                                                                                    if (wallet_error == 1) {
                                                                                        // To update the wallet transaction log
                                                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                                        iQry += "`amount`=-10, "
                                                                                        iQry += "`purpose`='Wallet amount successfully updated for Brand Appeal Request', "
                                                                                        iQry += "`status`=1;"

                                                                                        let objWL = new ModelRawNonQuery(req, res);
                                                                                        objWL.nonqrysql = iQry
                                                                                        objWL.prepare()
                                                                                        objWL.execute((res_error: any, res_result: any) => {
                                                                                            console.log("Wallet Updated for Brand Appeal Request", '-10');
                                                                                        });
                                                                                    }
                                                                                    else {
                                                                                        // To update the wallet transaction log
                                                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                                        iQry += "`amount`=-10, "
                                                                                        iQry += "`purpose`='Wallet amount not updated for Brand Appeal Request', "
                                                                                        iQry += "`status`=2;"

                                                                                        let objWL = new ModelRawNonQuery(req, res);
                                                                                        objWL.nonqrysql = iQry
                                                                                        objWL.prepare();
                                                                                        objWL.execute((res_error: any, res_result: any) => {
                                                                                            console.log("Wallet Not Updated for Brand Appeal Request", '-10');
                                                                                        });
                                                                                    }
                                                                                });
                                                                                console.log("Brand Appeal Requested Successfully!");
                                                                                let objh = new RawView(res);
                                                                                objh.prepare({ status: 200, message: "Brand Appeal Requested Successfully!" });
                                                                                objh.execute();
                                                                            }
                                                                            else {
                                                                                console.log("Appeal Request Not Saved Successfully!!!");
                                                                                let objh = new RawView(res);
                                                                                objh.prepare({ status: 200, message: "Brand Appeal Request Raised But Not Saved!" });
                                                                                objh.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let obj = new ModelRawNonQuery(req, res);
                                                                        obj.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Appeal Request Failed')";
                                                                        obj.prepare();
                                                                        obj.execute((_err: any, result: any) => {
                                                                            console.log("Brand Log Updated");
                                                                        });
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 502, message: appealRequest[0].description });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                catch (e) {
                                                                    console.log("Error :: appealRequest ::",e);
                                                                    let obj = new RawView(res);
                                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                    obj.execute();
                                                                }
                                                            } else {
                                                                let obj = new RawView(res);
                                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                obj.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objk = new RawView(res);
                                                        objk.prepare({ status: 404, message: "UUID not found!" });
                                                        objk.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: resp.status, message: resp.message });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objk = new RawView(res);
                                        objk.prepare({ status: 405, message: "Appeals are limited to the entities with UNVERIFIED identity status" });
                                        objk.execute();
                                    }
                                }
                                else {
                                    let objk = new RawView(res);
                                    objk.prepare({ status: 406, message: "Brand Id Not Found!" });
                                    objk.execute();
                                }
                            });
                        }
                        else {
                            const options = {
                                'method': 'POST',
                                'url': apiUrl + 'brand/' + sdata.brandId + '/appeal',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                },
                                body: JSON.stringify({
                                    "appealCategories": sdata.category,
                                    "explanation": sdata.explanation
                                })
                            };
                            request(options, function (error: any, response: any) {
                                if (!error) {
                                    try {
                                        //let payloadResp = JSON.parse(response.body);
                                        let payloadResp = response.body == '' ? response.body : JSON.parse(response.body);
                                        //if (error == null) {
                                        if (payloadResp == null || payloadResp == '') {
                                            let obj4 = new ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',10,'Pending',1,'Brand Appeal Requested Successfully')";
                                            obj4.prepare();
                                            obj4.execute((_err: any, result: any) => {
                                                console.log("Brand Appeal Log Updated");
                                            });
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `brand_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`explanation`,`vetting_status`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',10,'" + sdata.category + "','" + parseBody(sdata.explanation) + "','Pending')";
                                            obj.prepare();
                                            obj.execute((_err: any, result: any) => {
                                                if (_err == 1) {
                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-10 WHERE `idaccount`=" + sessdata.idaccount + " "
                                                    obj3.prepare();
                                                    obj3.execute((wallet_error, wallet_success) => {
                                                        if (wallet_error == 1) {
                                                            // To update the wallet transaction log
                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                            iQry += "`amount`=-10, "
                                                            iQry += "`purpose`='Wallet amount successfully updated for Brand Appeal Request', "
                                                            iQry += "`status`=1;"

                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = iQry
                                                            objWL.prepare()
                                                            objWL.execute((res_error: any, res_result: any) => {
                                                                console.log("Wallet Updated for Brand Appeal Request", '-10');
                                                            });
                                                        }
                                                        else {
                                                            // To update the wallet transaction log
                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                            iQry += "`amount`=-10, "
                                                            iQry += "`purpose`='Wallet amount not updated for Brand Appeal Request', "
                                                            iQry += "`status`=2;"

                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = iQry
                                                            objWL.prepare();
                                                            objWL.execute((res_error: any, res_result: any) => {
                                                                console.log("Wallet Not Updated for Brand Appeal Request", '-10');
                                                            });
                                                        }
                                                    });
                                                    console.log("Brand Appeal Requested Successfully!");
                                                    let objh = new RawView(res);
                                                    objh.prepare({ status: 200, message: "Brand Appeal Requested Successfully!" });
                                                    objh.execute();
                                                }
                                                else {
                                                    console.log("Brand Appeal Request Not Saved Successfully!!!");
                                                    let objh = new RawView(res);
                                                    objh.prepare({ status: 200, message: "Brand Appeal Request Raised But Not Saved. We will Fix it Soon!" });
                                                    objh.execute();
                                                }
                                            });
                                        } else {
                                            let obj4 = new ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Pending',4,'Brand Appeal Request Failed')";
                                            obj4.prepare();
                                            obj4.execute((_err: any, result: any) => {
                                                console.log("Brand Appeal Log Updated");
                                            });

                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: payloadResp[0].description });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error :: appealRequest ::",e);
                                        let obj = new RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: walletError, message: "Account Balance is Low!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 402 });
                objv.execute();
            }
        });
    }

    appealVettingRequest(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((errsess: any, sessdata) => {
            if (errsess == 1) {
                let sdata = JSON.parse(req.body.payload);
                let files: any = req.files.length
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount + " AND `balance` + `credit_limit` >= 10"
                obj1.prepare();
                obj1.execute((walletError: any, wallet: any) => {
                    if (walletError == 1 && wallet.length > 0) {
                        if (files > 0) {
                            let evidence = new NewCampaign();
                            evidence.evidenceRequest(req, res, sessdata, 'BrandVettingAppeal', (errorr, resp) => {
                                if (resp.status == 200) {
                                    let objv = new ModelRawQuery(req, res);
                                    objv.qrysql = "SELECT uuid from `evidence_files` WHERE `iduser`=" + sessdata.iduser + " AND `key`='" + resp.key + "' AND `brandId`='" + sdata.brandId + "'";
                                    objv.prepare();
                                    objv.execute((uuid_error, uuid_success) => {
                                        let Resuuids: any = [];
                                        Resuuids = JSON.parse(JSON.stringify(uuid_success));
                                        const uuids = Resuuids.map((item: { uuid: any; }) => item.uuid);
                                        if (uuid_error == 1) {
                                            var options = {
                                                'method': 'POST',
                                                'url': apiUrl + 'brand/' + sdata.brandId + '/externalVetting/appeal',
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    'Authorization': 'Basic ' + authKey
                                                },
                                                body: JSON.stringify({
                                                    "evpId": sdata.evpId,
                                                    "vettingId": sdata.vettingId,
                                                    "appealCategories": sdata.category,
                                                    "attachmentUuids": uuids,
                                                    "explanation": sdata.explanation,
                                                })
                                            };
                                            request(options, function (error: any, response: any) {
                                                if (!error) {
                                                    try {
                                                        let appealVettingRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                                        if (appealVettingRequest == null || appealVettingRequest == '') {
                                                            let obj4 = new ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`vettingId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + sdata.vettingId + "',10,'Pending',1,'Brand Vetting Appeal Requested Successfully')";
                                                            obj4.prepare();
                                                            obj4.execute((_err: any, result: any) => {
                                                                console.log("Brand Vetting Appeal Log Updated");
                                                            });
                                                            let obj = new ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "INSERT INTO `brand_vetting_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`attachmentUuids`,`explanation`,`vetting_status`,`key`,`evpId`,`vettingId`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','10','" + sdata.category + "','" + uuids + "','" + parseBody(sdata.explanation) + "','Pending','" + resp.key + "','" + sdata.evpId + "','" + sdata.vettingId + "')";
                                                            obj.prepare();
                                                            obj.execute((_err: any, result: any) => {
                                                                if (_err == 1) {
                                                                    let objv = new ModelRawNonQuery(req, res);
                                                                    objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-10 WHERE `idaccount`=" + sessdata.idaccount + " "
                                                                    objv.prepare();
                                                                    objv.execute((wallet_error, wallet_success) => {
                                                                        if (wallet_error == 1) {
                                                                            // To update the wallet transaction log
                                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                            iQry += "`amount`=-10, "
                                                                            iQry += "`purpose`='Wallet amount successfully updated for Brand Vetting Appeal Request', "
                                                                            iQry += "`status`=1;"

                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                            objWL.nonqrysql = iQry
                                                                            objWL.prepare()
                                                                            objWL.execute((res_error: any, res_result: any) => {
                                                                                console.log("Wallet Updated for Brand Vetting Appeal Request", '-10');
                                                                            });
                                                                        }
                                                                        else {
                                                                            // To update the wallet transaction log
                                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                            iQry += "`amount`=-10, "
                                                                            iQry += "`purpose`='Wallet amount not updated for Brand Appeal Request', "
                                                                            iQry += "`status`=2;"

                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                            objWL.nonqrysql = iQry
                                                                            objWL.prepare()
                                                                            objWL.execute((res_error: any, res_result: any) => {
                                                                                console.log("Wallet Not Updated for Brand Vetting Appeal Request", '-10');
                                                                            });
                                                                        }
                                                                    });
                                                                    console.log("Brand Vetting Appeal Request sent Successfully!");
                                                                    let objh = new RawView(res);
                                                                    objh.prepare({ status: 200, message: "Appeal Request sent Successfully!" });
                                                                    objh.execute();
                                                                }
                                                                else {
                                                                    console.log("Brand Vetting Appeal Request Not Saved Successfully!");
                                                                    let objh = new RawView(res);
                                                                    objh.prepare({ status: 200, message: "New Appeal Request Raised But Not Saved. We Will Fix it Soon!" });
                                                                    objh.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let obj4 = new ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Vetting Appeal Requested Failed')";
                                                            obj4.prepare();
                                                            obj4.execute((_err: any, result: any) => {
                                                                console.log("Brand Vetting Appeal Log Updated");
                                                            });
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: appealVettingRequest[0].description });
                                                            objv.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: appealVettingRequest ::",e);
                                                        let obj = new RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let obj = new RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    obj.execute();
                                                }

                                            });
                                        }
                                        else {
                                            let objk = new RawView(res);
                                            objk.prepare({ status: 404, message: "UUID not found!" });
                                            objk.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: resp.status, message: resp.message });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            var options = {
                                'method': 'POST',
                                'url': apiUrl + 'brand/' + sdata.brandId + '/externalVetting/appeal',
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Authorization': 'Basic ' + authKey
                                },

                                body: JSON.stringify({
                                    "evpId": sdata.evpId,
                                    "vettingId": sdata.vettingId,
                                    "appealCategories": sdata.category,
                                    "explanation": sdata.explanation,
                                })
                            };
                            request(options, function (error: any, response: any) {
                                if (!error) {
                                    try {
                                        let appealVettingRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                        if (appealVettingRequest == null || appealVettingRequest == '') {
                                            let obj4 = new ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`vettingId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + sdata.vettingId + "',10,'Pending',1,'Brand Vetting Appeal Requested Successfully')";
                                            obj4.prepare();
                                            obj4.execute((_err: any, result: any) => {
                                                console.log("Brand Log Updated");
                                            });
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `brand_vetting_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`explanation`,`vetting_status`,`evpId`,`vettingId`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',10,'" + sdata.category + "','" + parseBody(sdata.explanation) + "','Pending','" + sdata.evpId + "','" + sdata.vettingId + "')";
                                            obj.prepare();
                                            obj.execute((_err: any, result: any) => {
                                                if (_err == 1) {
                                                    let objv = new ModelRawNonQuery(req, res);
                                                    objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-10 WHERE `idaccount`=" + sessdata.idaccount + " "
                                                    objv.prepare();
                                                    objv.execute((wallet_error, wallet_success) => {
                                                        if (wallet_error == 1) {
                                                            // To update the wallet transaction log
                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                            iQry += "`amount`=-10, "
                                                            iQry += "`purpose`='Wallet amount successfully updated for Brand Vetting Appeal Request', "
                                                            iQry += "`status`=1;"

                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = iQry
                                                            objWL.prepare()
                                                            objWL.execute((res_error: any, res_result: any) => {
                                                                console.log("Wallet Updated for Brand Vetting Appeal Request", '-10');
                                                            });
                                                        }
                                                        else {
                                                            // To update the wallet transaction log
                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                            iQry += "`amount`=-10, "
                                                            iQry += "`purpose`='Wallet amount not updated for Brand Vetting Appeal Request', "
                                                            iQry += "`status`=2;"

                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = iQry
                                                            objWL.prepare()
                                                            objWL.execute((res_error: any, res_result: any) => {
                                                                console.log("Wallet Not Updated for Brand Vetting Appeal Request", '-10');
                                                            });
                                                        }
                                                    });
                                                    console.log("Appeal Request sent Successfully!");
                                                    let objh = new RawView(res);
                                                    objh.prepare({ status: 200, message: "Appeal Request sent Successfully!" });
                                                    objh.execute();
                                                }
                                                else {
                                                    console.log("Brand Vetting Appeal Request Not Saved Successfully!!");
                                                    let objh = new RawView(res);
                                                    objh.prepare({ status: 200, message: "New Appeal Request Raised But Not Saved!" });
                                                    objh.execute();
                                                }
                                            });

                                        }
                                        else {  
                                            let obj4 = new ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Vetting Appeal Requested Failed')";
                                            obj4.prepare();
                                            obj4.execute((_err: any, result: any) => {
                                                console.log("Brand Vetting Appeal Log Updated");
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: appealVettingRequest[0].description });
                                            objv.execute();
                                        }
                                    }
                                    catch (e) {
                                        console.log("Error :: AppealVettingRequest ::",e);
                                        let obj = new RawView(res);
                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                    obj.execute();
                                }

                            });
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error_code: 0, error: wallet, message: "Please add funds to your account or contact support.", status: 503 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 402 });
                objv.execute();
            }
        });
    }

    public evidenceRequest(req: Request, res: Response, sessdata: any, type: any, callback: (err: any, data: any) => void) {
        let sdata = JSON.parse(req.body.payload);
        let files: any = [];
        files = req.files;
        let fileSizes: any = [];
        let key = Math.random().toString(36).slice(2);
        files.forEach((element: any, index: any) => {
            fileSizes.push(element.size)
        });
        const maxTotalFileSizeBytes = 30 * 1024 * 1024;
        const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
        const totalFiles = fileSizes.length;
        const totalFileSizeBytes = fileSizes.reduce((acc: any, fileSize: any) => acc + fileSize, 0);
        if (totalFiles <= 10 && totalFileSizeBytes <= maxTotalFileSizeBytes) {
            const individualFileLimitReached = fileSizes.every((fileSize: any) => fileSize <= maxIndividualFileSizeBytes);

            if (individualFileLimitReached) {
                var fs = require('fs');
                files.forEach((element: any, index: any) => {
                    let options = {
                        'method': 'POST',
                        'url': apiUrl + 'brand/' + sdata.brandId + '/appeal/evidence',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        formData: {
                            'file': {
                                'value': fs.createReadStream(element.path),
                                'options': {
                                    'filename': element.filename,
                                    'contentType': null
                                }
                            }
                        }
                    };
                    request(options, function (error: any, response: any) {
                        if (error == null) {
                            try {
                                let resp = JSON.parse(response.body)
                                let value = appealEvidence.fileEvidence + resp.fileName;
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `evidence_files` (`iduser`,`idaccount`,`brandId`,`uuid`,`key`,`mimeType`,`fileName`,`path`,`evidence_type`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + resp.uuid + "','" + key + "','" + resp.mimeType + "','" + resp.fileName + "' ,'" + value + "', '" + type + "')";
                                obj.prepare();
                                obj.execute((_err: any, result: any) => {
                                    if (files.length - 1 == index) {
                                        if (_err == 1) {
                                            console.log("Data inserted Successfully");
                                            callback(1, { data: resp, status: 200, key: key })
                                        }
                                        else {
                                            console.log("Something Went wrong data not inserted");
                                            callback(0, { message: "Something Went wrong data not inserted", status: 502 })
                                        }
                                    }
                                });
                            }
                            catch (e) {
                                console.log("Error :: evidenceRequest ::",e);
                                console.log("Something Went wrong data not inserted");
                                callback(0, { error_code: 0, status: 503, message: "Something went wrong!" })
                            }
                        } else {
                            console.log("response description");
                            callback(0, { message: response[0].description, status: response.code })
                        }
                    });
                })
            } else {
                console.log("Individual file size limit exceeded.");
                callback(0, { message: "Individual file size limit exceeded.", status: 504 })
            }
        } else {
            console.log("Total file count or total file size limit exceeded.");
            callback(0, { message: "Total file count or total file size limit exceeded.", status: 505 })
        }
    }

    public getBranAppeal(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                let brandId: any = data.brandId;
                let iduser: any = sessData.type == 1 ? data.iduser : sessData.iduser;
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT iduser,idaccount,brandID,appealCategories,attachmentUuids,explanation,vetting_status,`key`,`created_at`,`vetting_status_updated_at` FROM `brand_appeal` WHERE brandId='" + brandId + "' AND iduser='" + data.iduser + "'";
                obj.qrysql = "SELECT iduser,idaccount,brandID,appealCategories,attachmentUuids,explanation,vetting_status,`key`,vetting_status_update_at,created_at FROM `brand_appeal` WHERE brandId='" + brandId + "' AND iduser=" + iduser + " ";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Brand Appeal Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "", status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    public getBranAppealFiles(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                let iduser: any = sessData.type == 1 ? data.iduser : sessData.iduser;
                let brandId: any = data.brandId;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT uuid, fileName, `key`, `path`, `mimeType`,`evidence_type` FROM `evidence_files` WHERE `iduser`=" + iduser + " AND `brandId`='" + brandId + "' AND `key`='" + data.key + "'";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Brand Appeal Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO appeal available in this Appeal Request!", status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    public getVettingAppealDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                let brandId: any = data.brandId;
                let iduser: any = sessData.type == 1 ? data.iduser : sessData.iduser;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT ba.brandId, ba.appealCategories, ba.explanation, ba.vetting_status,ba.vetting_status_update_at,ba.created_at,ef.uuid, ef.fileName, ef.key, ef.path,ef.mimeType FROM `brand_vetting_appeal`ba LEFT JOIN `evidence_files` ef ON ef.key=ba.key WHERE ba.`iduser`=" + iduser + " AND ba.`brandId`='" + brandId + "' ORDER BY `created_at` DESC";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Brand Vetting Appeal Fatched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Vetting Appeal Detail!", status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    /********************************
  * Upload Campaign File Panel + Swagger
  */


    public campaignFileUploader(req: Request, res: Response, sessdata: any, campaignId: any, callback: (err: any, data: any) => void) {
        if (campaignId) {
            let files: any = [];
            files = req.files;
            let fileSizes: any = [];
            let key = Math.random().toString(36).slice(2);
            files.forEach((element: any, index: any) => {
                fileSizes.push(element.size)
            });
            const maxTotalFileSizeBytes = 30 * 1024 * 1024;
            const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
            const totalFiles = fileSizes.length;
            const totalFileSizeBytes = fileSizes.reduce((acc: any, fileSize: any) => acc + fileSize, 0);
            if (totalFiles <= 10 && totalFileSizeBytes <= maxTotalFileSizeBytes) {
                const individualFileLimitReached = fileSizes.every((fileSize: any) => fileSize <= maxIndividualFileSizeBytes);
                if (individualFileLimitReached) {
                    var fs = require('fs');
                    files.forEach((element: any, index: any) => {
                        const isValid = MIME_TYPE_MAP[element.mimetype]
                        if (!isValid) {
                            console.log("File type " + element.filename.split('.').pop() + " not accepted");
                            let objv = new RawView(res);
                            objv.prepare({ message: "File type " + element.filename.split('.').pop() + " not accepted", status: 402 });
                            objv.execute();
                            return;
                        }
                        let options = {
                            'method': 'POST',
                            'url': apiUrl + 'campaign/' + campaignId + '/mms',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': 'Basic ' + authKey
                            },
                            formData: {
                                'file': {
                                    'value': fs.createReadStream(element.path),
                                    'options': {
                                        'filename': element.filename,
                                        'contentType': null
                                    }
                                }
                            }
                        };
                        request(options, function (error: any, response: any) {
                            if (!error) {
                                try {
                                    let resp = JSON.parse(response.body);
                                    let value = appealEvidence.campaignFile + resp.fileName;
                                    if (resp.uuid) {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `campaign_sample_file` (`iduser`,`idaccount`,`campaignId`,`uuid`,`key`,`mimeType`,`fileName`,`path`,`evidence_type`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + campaignId + "','" + resp.uuid + "','" + key + "','" + resp.mimeType + "','" + resp.fileName + "' ,'" + value + "','CampaignMMSSampleFile')";
                                        obj.prepare();
                                        obj.execute((_err: any, result: any) => {
                                            if (files.length - 1 == index) {
                                                if (_err == 1) {
                                                    callback(1, { message: 'Campaign File Upload Successfully', data: resp, status: 200 })
                                                }
                                                else {
                                                    callback(0, { message: "Something went wrong!", status: 505 })

                                                }
                                            }
                                        });
                                    }
                                    else {
                                        callback(0, { message: resp[0].description, status: resp[0].code })

                                    }

                                }
                                catch (e) {
                                    console.log("Error :: CampaignFileUploader ::",e);
                                    callback(0, { error_code: 0, status: 502, message: "Something went wrong!" })
                                }
                            } else {
                                console.log(response[0].description, response[0].code);
                                callback(0, { message: response[0].description, status: response[0].code })

                            }

                        });
                    })
                } else {
                    console.log("Individual file size limit exceeded.");
                    callback(0, { message: 'Individual file size limit exceeded.', status: 200 })

                }
            } else {

                console.log("Total file count or total file size limit exceeded.");
                callback(0, { message: 'Total file count or total file size limit exceeded', status: 200 })

            }
        }
        else {
            console.log("Campaign Id not Found");
            callback(0, { message: 'Campaign Id not Found', status: 200 })

        }
    }

    public addCampaignFile(req: Request, res: Response, sessdata: any, payLoad: any, callback: (err: any, data: any) => void) {
        if (payLoad.campaignId) {
            let campaignId: any = "";
            let ucKey: any;
            ucKey = payLoad.key;
            campaignId = payLoad.campaignId
            var fs = require('fs');
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT `id`, `fileName`, `key`, `path`,`mimeType` FROM `campaign_sample_file` WHERE `key`='" + ucKey + "'";
            obj.prepare();
            obj.execute((err: any, results: any) => {
                results.forEach((element: any, index: any) => {
                    let filePath = appealDir.CAMPAIGNUPLOAD + '/' + element.fileName;
                    let options = {
                        'method': 'POST',
                        'url': apiUrl + 'campaign/' + campaignId + '/mms',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + authKey
                        },
                        formData: {
                            'file': {
                                'value': fs.createReadStream(filePath),
                                'options': {
                                    'filename': element.fileName,
                                    'contentType': null
                                }
                            }
                        }
                    };
                    request(options, function (error: any, response: any) {
                        if (!error) {
                            try {
                                let resp = JSON.parse(response.body);
                                let value = appealEvidence.campaignFile + resp.fileName;

                                if (resp.uuid) {
                                    let sampleId: any = [];
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `campaign_sample_file` SET `campaignId` = '" + campaignId + "' ,`uuid`= '" + resp.uuid + "',`mimeType`='" + resp.mimeType + "',`fileName`='" + resp.fileName + "', `path`='" + value + "'  WHERE `iduser`=" + sessdata.iduser + " AND `idaccount` = " + sessdata.idaccount + " AND `id` = '" + element.id + "'";
                                    obj.prepare();
                                    obj.execute((_err: any, result: any) => {
                                        if (results.length - 1 == index) {
                                            if (_err == 1) {
                                                callback(1, { message: 'Campaign File Upload Successfully', data: resp, status: 200 })
                                            }
                                            else {
                                                callback(0, { message: "Something went wrong!", status: 505 })

                                            }
                                        }
                                    });
                                }
                                else {
                                    callback(0, { message: resp[0].description, status: resp[0].code })
                                }
                            }
                            catch (e) {
                                console.log("Error :: addCampaignFile ::",e);
                                callback(0, { error_code: 0, status: 502, message: "Something went wrong!" })
                            }
                        } else {
                            callback(0, { message: response[0].description, status: response[0].code })

                        }

                    });
                })
            })
        } else {
            console.log("Total file count or total file size limit exceeded.");
            callback(0, { message: 'Total file count or total file size limit exceeded', status: 200 })
        }
    }

    public campaignPanelFileUploader(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {

                let key: any = "";
                let files: any;
                files = req.files;
                key = req.body.key;
                let fileSize: any;
                fileSize = files[0].size;
                const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
                if (fileSize <= maxIndividualFileSizeBytes) {
                    const isValid = MIME_TYPE_MAP[files[0].mimetype]
                    if (!isValid) {
                        console.log("File type " + files[0].filename.split('.').pop() + " not accepted");
                        let objv = new RawView(res);
                        objv.prepare({ message: "File type " + files[0].filename.split('.').pop() + " not accepted", status: 402 });
                        objv.execute();
                        return;
                    }
                    let value = appealEvidence.campaignFile + files[0].filename;
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `campaign_sample_file` (`iduser`,`idaccount`,`campaignId`,`uuid`,`key`,`mimeType`,`fileName`,`path`,`evidence_type`) VALUES (" + sessData.iduser + ", " + sessData.idaccount + ",'','','" + key + "','" + files[0].mimetype + "','" + files[0].filename + "' ,'" + value + "','CampaignMMSSampleFile')";
                    obj.prepare();
                    obj.execute((_err: any, result: any) => {
                        if (_err == 1) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `id`,`fileName`, `key`, `path`,`mimeType` FROM `campaign_sample_file` WHERE `key`='" + key + "' AND `id`='" + result.insertId + "'";
                            obj.prepare();
                            obj.execute((err: any, results: any) => {
                                let objv = new RawView(res);
                                objv.prepare({ message: 'Campaign File Upload Successfully', data: results, lastId: result.insertId, status: 200 });
                                objv.execute();
                            })
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 505 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: 'Total file count or total file size limit exceeded', status: 200 });
                    objv.execute();
                }
            }
        })

    }
    public campaignMultimediaFileUpload(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body;
                if (req.files) {
                    let camp = new NewCampaign();
                    camp.campaignFileUploader(req, res, sessdata, sdata.campaignId, (errorr, resp) => {
                        if (errorr == 1) {
                            console.log(resp.message);
                            let objv = new RawView(res);
                            objv.prepare({ message: resp.message, data: resp.data, status: resp.status });
                            objv.execute();
                        }
                        else {
                            console.log(resp.message);
                            let objv = new RawView(res);
                            objv.prepare({ message: resp.message, status: resp.status });
                            objv.execute();
                        }

                    });
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        })
    }

    /*********************************************
         * get campaign File details based on campaign id  *
         *********************************************/

    public getCampaignsFileById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let sdata: any = req.query.type ? JSON.parse(data.type) : data;
                let iduser: any = sessdata.type == 1 ? sdata.iduser : sessdata.iduser;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT uuid, fileName, `key`, `path`, `mimeType`,`evidence_type` FROM `campaign_sample_file` WHERE `campaignId`='" + sdata.campId + "' AND `iduser` = " + iduser + " ";
                obj.prepare();
                obj.execute((err: any, result: any) => {
                    if (err == 1) {
                        try {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ message: 'Campaign File Fatched Successfully!', data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "NO Campaign File available!", status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getCampaignFilesById ::",e);
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went Wrong!", status: 502 });
                            objv.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO Campaign File available!", status: 502 });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public deleteAddCampFile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `id`=" + data.id + " AND `iduser`=" + sessdata.iduser + " ";
                obj.prepare();
                obj.execute((__err: any, delRes: any) => {
                    let obj = new RawView(res);
                    obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                    obj.execute();
                })
            }
            else {
                let obj = new RawView(res);
                obj.prepare({ status: 502, message: "Something went wrong with Campaign File Delete!" });
                obj.execute();
            }
        });
    }
    /* Delete campaign file Panel + Swagger*
    ****************/
    public deleteCampFile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let data: any = req.query;
                let attachmentId: any = data.attachmentId !== undefined ? data.attachmentId : data.id;
                let attachmentIds: any = attachmentId.replace('/', '%2F').replace('/', '%2F');

                let options: any = {
                    'method': 'DELETE',
                    'url': apiUrl + 'attachment/' + attachmentIds,
                    'headers': {
                        'Content-Type': 'application/json',
                        'Authorization': 'Basic ' + authKey
                    }
                };
                request(options, (__error: any, response: any, body: any) => {
                    if (!__error) {
                        try {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "DELETE FROM `campaign_sample_file` WHERE `UUID`='" + attachmentId + "' AND `iduser`= " + sessdata.iduser + " ";
                            obj.prepare();
                            obj.execute((__err: any, delRes: any) => {
                                let obj = new RawView(res);
                                obj.prepare({ status: 200, message: "Campaign File Deleted Successfully" });
                                obj.execute();
                            })
                        }
                        catch (e) {
                            console.log("Error :: deleteCampFile ::",e);
                            let obj = new RawView(res);
                            obj.prepare({ status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something went wrong!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /* Get campaign files from Swagger*/

    public getCampFile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (req.query.campaignId) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `uuid`, `fileName`, `mimeType` FROM `campaign_sample_file` WHERE campaignId='" + req.query.campaignId + "' AND idaccount=" + sessdata.idaccount + " ";
                    obj.prepare();
                    obj.execute((err: any, result: any) => {
                        if (err == 1) {
                            if (result.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ message: 'Campaign Multimedia files fetched successfully.', data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "NO Campaign Multimedia file in this Campaign!", status: 404 });
                                objv.execute();
                            }

                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong with get campaign multimedia files!", status: 502 });
                            objv.execute();
                        }
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Please enter a valid Campaign ID!", status: 504 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    /*********************************************
    *Start get CDR details based on User Id  *
    *********************************************/

    // public getSummeryCDRList(req: Request, res: Response, next: NextFunction) {
    //     //  let sdata: any = req.query;
    //     //  let data: any = JSON.parse(sdata.type);
    //     //  let iduser: any = data.iduser;
    //     let days: any = 'L7D';
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let con:any ;
    //             let currentDate=new Date().toISOString().split('T')[0];
    //             if(days=='L7D')
    //             {   
    //                 const sevenDaysBeforeDate = new Date(new Date().setDate(new Date().getDate() - 7)).toISOString().split('T')[0];
    //                 con  +=  sevenDaysBeforeDate
    //             }
    //             if(days=='This week')
    //             {   
    //                 const sevenDaysBeforeDate = new Date(new Date().setDate(new Date().getDate() - 7)).toISOString().split('T')[0];
    //                 con  +=  "BETWEEN '"+sevenDaysBeforeDate+"' AND '"+currentDate+"'sevenDaysBeforeDate"
    //             }
    //             if(days=='Last week')
    //             {   
    //                 const sevenDaysBeforeDate = new Date(new Date().setDate(new Date().getDate() - 7)).toISOString().split('T')[0];
    //                 con  +=  "BETWEEN '"+sevenDaysBeforeDate+"' AND '"+currentDate+"'sevenDaysBeforeDate"
    //             }
    //             if(days=='This Month')
    //             {

    //             }
    //             if(days=='Last Month')
    //             {

    //             }

    //         //     let obj = new ModelRawQuery(req, res);
    //         //     obj.qrysql = "SELECT direction,start_stamp FROM `cdr` WHERE start_stamp "+con+" AND iduser='" + '287' + "'";
    //         //     obj.prepare();
    //         //     obj.execute((err: any, result: any) => {
    //         //     if (err == 1 && result.length > 0) { 
    //         //         let objv = new RawView(res);
    //         //         objv.prepare({ message: 'CDR Fatched Successfully!', data: result, status: 200 });
    //         //         objv.execute();
    //         //     }
    //         //     else {
    //         //         let objv = new RawView(res);
    //         //         objv.prepare({ message: "NO CDR available", data: [], status: 502 });
    //         //         objv.execute();
    //         //     }
    //         // })


    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Authorization!", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }

    /*********************************************
    *End CDR details based on User Id  *
    *********************************************/

    /** start createMockCvToken */

    //  public createMockCvToken(req: Request, res: Response, next: NextFunction) {
    //     let vettingData: any = req.body;
    //     let vettingData1: any = req.query;
    //     let brandId: any = vettingData1.brandId !== undefined ? vettingData1.brandId : vettingData.brandId;
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let options: any = {
    //                 'method': 'POST',
    //                 'url': apiUrl + 'brand/'+brandId+'/externalVetting/mockCvToken',
    //                 'headers': {
    //                     'Content-Type': 'application/json',
    //                     'Authorization': 'Basic ' + authKey
    //                 },
    //                 body: JSON.stringify(brandId)


    //             };
    //             request(options, (error: any, response: any, body: any) => {


    //             })
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    /** end createMockCvToken */




}
exports.NewCampaign = NewCampaign;


class BrandManager {
    constructor() { }
    /*********************
    * Send OTP For Brand *
    *********************/
    public smsOTPBrand(req: Request, res: Response, brandId: string, callback: (err: any, data: any) => void) {
        let otpdata: any;
        otpdata = {
            pinSms: "Please reply @OTP_YES@ to confirm your SMS Brand Registration",
            successSms: "Your SMS Brand Registration has been confirmed successfully"
        }
        let options: any = {
            'method': 'POST',
            'url': apiUrl + 'brand/' + brandId + '/smsOtp',
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': 'Basic ' + authKey
            },
            body: JSON.stringify(otpdata)
        };
        request(options, (error: any, response: any, body: any) => {
            if (!error) {
                try {
                    let resData = JSON.parse(response.body);
                    if (resData.referenceId && resData.referenceId !== undefined) {
                        callback(1, {
                            message: 'Message to be sent to the mobile phone of registered brand !', data: resData, status: 201
                        })
                    }
                    else {
                        callback(0, {
                            message: resData[0].field + ' ' + resData[0].description, status: resData[0].code
                        })
                    }
                }
                catch (e) {
                    console.log("Error :: smsOTPBrand ::",e);
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                callback(0, {
                    message: "smsOtp is Not Working!", status: 502
                })
            }

        });
    }
}

exports.BrandManager = BrandManager;
