import { Request, Response, NextFunction } from "express";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { Res406 } from "../lib/view/406";
import { Res403 } from "../lib/view/403";
import { modAgent } from "../config/module.config";
import { ModelLogin } from "../lib/model/ModelLogin";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { CSPApiConfig } from "../config/setting.config";
import { NewCampaign } from "./newcampaign.class";
import { VoiceRates } from "./common.lib";
import { Number } from "./numberApi";
import { APIBase } from "./APIBase";

const request = require("request");


const Str = require('@supercharge/strings');

const makeNumber = (length: number) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}
const makeChar = (length: number) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const makeRanChar = (length: number) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const generatePassword = () => {
    let result: any = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
}

export class SwaggerApi {
    constructor() {
    }

    public BuyTollfree(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let swag = new SwaggerApi();
                    swag.CreateGroupOrder(req, res, sessdata, (error, response) => {
                        if (error == 1) {
                            const sdata = req.query
                            if (sdata.Quantity) {
                                let groupID = response.data.id_grouporder;
                                let numberapi = new Number();
                                numberapi.BuyTollfreeNumber(req, res, groupID, err => {
                                    if (err == 0) {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: "200", message: "Tollfree Number Buy Successfully!" });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 503, message: "Service Unavailable!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 507, message: "Quantity is required" });
                                objv.execute();
                            }
                        } else {
                            let objv = new RawView(res)
                            objv.prepare({ status: 201, message: "Group Order is not Created!" })
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public CreateGroupOrder(req: Request, res: Response, sessdata: any, callback: (err: any, data: any) => void) {
        let checkService = new APIBase();
        checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
            if (resp.status == 200) {
                const sdata = req.body.data ? req.body.data : req.query
                let obj = new ModelRawNonQuery(req, res);
                let totalDID: any = sdata.total_dids ? sdata.total_dids : sdata.Quantity
                let process_dids: number;
                if (sdata.number)
                    process_dids = sdata.total_dids <= 10 ? sdata.total_dids : 0
                else
                    process_dids = 0

                obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + sdata.name + "', total_dids=" + totalDID + ", process_dids=" + process_dids + ", numbers='" + sdata.numbers + "', routing='" + sdata.routing + "', in_routing='" + sdata.in_routing + "', out_routing='" + sdata.out_routing + "', campaign='" + sdata.campaign + "';"

                obj.prepare();
                obj.execute((error: any, result: any) => {
                    callback(1, {
                        status: 202,
                        message: "Group successfully created.",
                        data: {
                            id_grouporder: result.insertId
                        }
                    });
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({
                    error: 1,
                    status: resp.status,
                    message: resp.message.replace(/::SN::/g, "DID Buy")
                });
                objv.execute();
            }
        });
    }

}

