"use strict";
const multer1 = require('multer');
import { UploadDirectory } from '../config/setting.config';
let upload = new UploadDirectory();
const MIME_TYPE_MAP1: any = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx',
    'application/zip': 'zip'
};
const MIME_TYPE_MAP2: any = {
    // images
    'image/png': 'png',
    'image/jpg': 'jpg',
    'image/jpeg': 'jpeg',
    'image/svg+xml': 'svg',
    'image/heic' :'heic',
    'image/webp': 'webp',
    'image/gif': 'gif',
    'image/gif; version="87a"': 'gif',
    'image/gif; version="89a"': 'gif',
    'image/avif': 'avif',
    'image/bmp': 'bmp',
    'image/dib': 'dib',
    'image/x-icon': 'ico',
    'image/pjpeg': 'pjpeg',
    
    // videos 
    'video/mp4': 'mp4',
    'video/mp4v-es': 'mp4',
    'video/mp4-es': 'mp4',
    'video/mpeg': 'mpeg',
    'video/webm': 'webm',
    'video/3gpp': '3gp',
    'video/x-msvideo': 'avi',
    'video/x-flv': 'flv',
    'video/m1v': 'm1v',
    'video/mpg': 'mpg',
    'video/quicktime': 'qt',
    'video/x-ms-wmv': 'wmv',
    'video/h263': 'h263',
    'video/h264': 'h264',
    'video/jpeg': 'jpgv',
    'video/3gpp2': '3g2',

    // audio
    'audio/x-mp3': 'mp3',
    'audio/webm': 'weba',
    'audio/x-wav': 'wav',
    'audio/3gpp': '3ga',
    'audio/amr': 'amr',
    'audio/wav': 'wav',
    'audio/flac': 'flac',
    'audio/mpeg': 'mp3',
    'audio/m2a': 'm2a',
    'audio/x-m4a': 'm4a',
    'audio/m4b': 'm4b',
    'audio/x-ms-wma': 'mpa',
    'audio/qcelp': 'qcelp',
    'audio/QCELP': 'qcp',
    'audio/midi': 'midi',
    'audio/mid': 'mid',
    'audio/aac': 'aac',
    'audio/aacp': 'aacp',
    'audio/vnd.dlna.adts': 'aac',
    
    // others
    'text/csv': 'csv',
    'text/plain': 'txt',
    'text/css': 'css',
    'text/rtf': 'rtf',
    'text/html':'html',
    'text/javascript': 'js',
    'text/x-vcard': 'vcf',

    //application
    'application/x-bzip2': 'bz2',
    'application/calendar': 'cal',
    'application/x-gzip': 'gz',
    'application/javascript': 'js',
    'application/json': 'json',
    'application/pdf': 'pdf',
    'application/xml': 'xml',
    'application/zip': 'zip',
    'application/x-zip-compressed': 'zip',
    'application/x-msdownload' : 'exe',
    'application/vnd.ms-excel': 'xls',
    'application/octet-stream': 'rar',
    'application/vnd.ms-powerpoint': 'ppt',
    'application/msword': 'doc',
    'application/x-freearc': 'arc',
    'application/java-archive': 'jar',
    'application/vnd.openxmlformats-officedocument.presentationml.presentation': 'pptx',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx',
    'application/gzip': 'gz',
    'application/rtf': 'rtf',
   
};


const storage1 = multer1.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        let store: any;
        if (req.route.path == "/savenotifyemail") {
            store = upload.EMAILNOTIFICATION;            
            const isValid = MIME_TYPE_MAP2[file.mimetype];
            let error: any = "";
            if (!isValid) {
                error = new Error("Invalid file type");
            }
            cb(error, store);
        } else {
            store = upload.TOLLFREEUPLOADS;
            const isValid = MIME_TYPE_MAP1[file.mimetype];
            let error: any = "";
            if (!isValid) {
                error = new Error("Invalid file type");
            }
            cb(error, store);
        }
    },
    filename: (req: any, file: any, cb: any) => {
        const name = file.originalname.toLowerCase().split(' ').join('_');
        let ext: any;
        if (req.route.path == "/savenotifyemail") {
            ext = MIME_TYPE_MAP2[file.mimetype];
        } else {
            ext = MIME_TYPE_MAP1[file.mimetype];
        }
        cb(null, Date.now() + '.' + ext);
    }
});



//module.exports = multer1({ storage: storage1 }).single('ATTACHMENT');
module.exports = [multer1({ storage: storage1 }).array('ATTACHMENTS')];
