import { APIBase } from "./APIBase";
import { Request, Response, NextFunction } from "express";
import { Number } from "./numberApi";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { OsrApi } from "./Osr";
import { SinchApi } from "./SinchSubmitNumber";
import { parseBody, setToZero } from "./markError";
var request = require('request');
const crypto = require('crypto');
import { inteliqunt } from "../config/setting.config";
import { DIDSearchHMData } from "../server";
const intelli = new inteliqunt();
export class InteliquentAPI extends APIBase {
    /* private key: string; */
    private secret: string;
    private priority: string;
    private sessdata: any;
    private timekey: string;
    /* private URL: string;
    private privateKey: string;
    private sendSMSKey: string;
    private sendTFSMSUrl: string; */

    constructor(proirity: string, sessdata: string, timekey: string) {
        super();
        // Production key
        /* this.key = "eFluR1hOVERZZGY3dHc5Tno4dzFaemhtbFpnQzpEendnQjZCMVVKc2JwaUZxRXBieW9MODY0dFR3";
        this.URL = 'https://services.inteliquent.com/Services/1.0.0'
        this.privateKey = 'xYnGXNTDYdf7tw9Nz8w1ZzhmlZgC' 
        this.sendTFSMSUrl ='https://messagebroker.inteliquent.com/msgbroker/rest'
        this.sendSMSKey = 'hfnm95ALNW3MjCcJHM7MwmfnzCKEJNcH'
        */

        //SandBox key
        /* this.key = "ZVFzdGdKaHZsa3UwMldLMDBzRnhDN3ZNVHdLTjo2ZllFSDlISklqVTFRWkJTODU3cXlVNXVaQldQ";
        this.URL = 'https://services-sandbox.inteliquent.com/Services/1.0.0'
        this.privateKey = 'eQstgJhvlku02WK00sFxC7vMTwKN'
        this.sendTFSMSUrl = 'https://messagebroker.inteliquent.com/msgbroker/rest'
        this.sendSMSKey = 'hfnm95ALNW3MjCcJHM7MwmfnzCKEJNcH' */

        this.timekey = timekey,
        this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }

    public rpad(name: any, size: number) {
        let ret = name;
        for (let i = name.length; i < size; i++)
            ret += "x";
        return ret;
    }

    public getNpaNxx(req: Request, res: Response, pLoad:any, callback: (err: any, data: any) => void): void {
        if (this.priority == "100") {
            console.log("Exit from InteliquentAPI");
            callback('', '');
        } else {
            const sdata = req.query;
            let tnMask: any;
            if (sdata.NXX == "null" || sdata.NXX == null || sdata.NXX == undefined) {
                tnMask = this.rpad(sdata.NPA, 10);
            }
            if (sdata.NXX !== undefined && sdata.NXX !== 'null') {
                tnMask = this.rpad(sdata.NPA + "" + sdata.NXX, 10);
            }
            var options = {
                'method': 'POST',
                //'url': this.URL + '/tnInventory',
                'url': intelli.Url + '/tnInventory',
                'headers': {
                    'Content-Type': 'application/json',
                    // 'Authorization': 'Basic ' + this.key
                    'Authorization': 'Basic ' + intelli.key
                },
                body: JSON.stringify({
                    // 'privateKey': this.privateKey,
                    'privateKey': intelli.privateKey,
                    "tnMask": tnMask,
                    "quantity": pLoad.searchqty
                }),
            };
            request(options, (error: any, response: any) => {
                if (!error) {
                    try {
                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let ddata = JSON.parse(response.body);
                            if (ddata.statusCode == 200) {
                                if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                    let str = ddata.tnResult;
                                    let path = this.sessdata.path ? this.sessdata.path : 'false';
                                    let hsmpData:any= [];
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`idaccount`, `phone_number`, `lata`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`,`portout_pin_supported`,`billing_frequency`) VALUE ";
                                    str.forEach((ele: any) => {
                                        let hmp:any = {
                                            phone_number: ele.telephoneNumber,
                                            rate_center: parseBody(ele.rateCenter),
                                            state: parseBody(ele.province),
                                            supplier_tier: parseBody(ele.rateCenterTier)
                                        };
                                        hsmpData.push(hmp)
                                        qrystr += "('" + this.sessdata.idaccount + "', '" + ele.telephoneNumber + "', '" + ele.lata + "', '" + ele.rateCenter + "', '" + parseBody(ele.province) + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + parseBody(ele.city) + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + setToZero(this.priority) + "','NN','" + parseBody(ele.rateCenterTier) + "','" + pLoad.rate + "','" + sdata.CampaignId + "','" + path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "','" + ele.rateCenterTier + "','" + setToZero(pLoad.billingfreq) + "'),";
                                    });
                                    this.saveHmp(this.timekey, 'inteliQ', hsmpData);
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', ddata);
                                }
                            } else {
                                callback('', ddata);
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    } catch (e) {
                        console.log("Error :: Inteliquent->getNpaNxx::", e);
                        callback(error, '');
                    }
                } else {
                    callback(error, '');
                }
            });
        }
    }

    public getByRate(req: Request, res: Response, pLoad:any, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            console.log("Exit from InteliquentAPI");
            callback('', '')
        } else {
            const sdata = req.query;
            var options = {
                'method': 'POST',
                // 'url': this.URL + '/tnInventory',
                'url': intelli.Url + '/tnInventory',
                'headers': {
                    'Content-Type': 'application/json',
                    // 'Authorization': 'Basic ' + this.key
                    'Authorization': 'Basic ' + intelli.key
                },
                body: JSON.stringify({
                    // 'privateKey': this.privateKey,
                    'privateKey': intelli.privateKey,
                    "tnMask": "**********",
                    "tnWildcard": "***********",
                    "rateCenter": sdata.RateCenter,
                    "province": sdata.State,
                    "quantity": pLoad.searchqty
                }),
            };
            request(options, (error: any, response: any) => {
                if (!error) {
                    try {
                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let ddata = JSON.parse(response.body);
                            if (ddata.statusCode == 200) {
                                if (ddata.tnResult != undefined && ddata.tnResult.length > 0) {
                                    let str = ddata.tnResult;
                                    let hsmpData:any= [];
                                    let path = this.sessdata.path ? this.sessdata.path : 'false';
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`idaccount`, `phone_number`, `lata`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`rates`,`camp_registry`,`path`,`idapi`,`key`,`portout_pin_supported`,`billing_frequency`) VALUE ";
                                    str.forEach((ele: any) => {
                                        let hmp:any = {
                                            phone_number: ele.telephoneNumber,
                                            rate_center: parseBody(ele.rateCenter),
                                            state: parseBody(ele.province),
                                            supplier_tier: parseBody(ele.rateCenterTier)
                                        };
                                        hsmpData.push(hmp)
                                        qrystr += "('" + this.sessdata.idaccount + "', '" + ele.telephoneNumber + "', '" + ele.lata + "', '" + parseBody(ele.rateCenter) + "', '" + parseBody(ele.province) + "', '" + ele.countryCode + "', 'cnamAllowed:" + ele.cnamAllowed + ",dlAllowed:" + ele.dlAllowed + ",e911Allowed:" + ele.e911Allowed + ",msgAllowed:" + ele.msgAllowed + "', '" + parseBody(ele.city) + "', '" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + setToZero(this.priority) + "','NN','" + ele.rateCenterTier + "','" + pLoad.rate + "','" + sdata.CampaignId + "','" + path + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "','" + ele.rateCenterTier + "','" + setToZero(pLoad.billingfreq) + "'),";
                                    });
                                    this.saveHmp(this.timekey, 'inteliQ', hsmpData);
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                } else {
                                    callback('', ddata);
                                }
                            } else {
                                callback('', ddata);
                            }
                        }
                        else {
                            callback(error, '');
                        }

                    } catch (e) {
                        console.log("Error :: Inteliquent->getByRate::", e);
                        callback(error, '');
                    }
                } else {
                    callback(error, '');
                }
            });
        }
    }

    public getTollFree(req: Request, res: Response, callback: (err: any, data: any) => void) {
        if (this.priority == "100") {
            callback('', '');
        } else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "VN", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    let data1: any = req.query;
                    let cbody: any = '';
                    if (data1.quantity != '' && data1.tnMask1 != 'null') {
                        cbody = JSON.stringify({
                            // "privateKey": this.privateKey,
                            "privateKey": intelli.privateKey,
                            "tnMask": data1.tnMask1 + data1.tnMask2 + data1.tnMask3,
                            "sequential": data1.sequential,
                            "quantity": data1.quantity
                        })
                    }
                    if (data1.wildcard != '' && data1.quantity != '') {
                        cbody = JSON.stringify({
                            // "privateKey": this.privateKey,
                            "privateKey": intelli.privateKey,
                            "tnWildcard": data1.wildcard,
                            "sequential": data1.sequential,
                            "quantity": data1.quantity
                        });
                    }
                    var options = {
                        'method': 'POST',
                        // 'url': this.URL + '/tfInventory',
                        'url': intelli.Url + '/tfInventory',
                        'headers': {
                            'Content-Type': 'application/json',
                            // 'Authorization': 'Basic ' + this.key,
                            'Authorization': 'Basic ' + intelli.key,
                        },
                        body: cbody
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try {
                                if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                    let ddata = JSON.parse(response.body);
                                    if (ddata.statusCode == 200) {
                                        if (ddata.tfList.tfItem != undefined && ddata.tfList.tfItem.length > 0) {
                                            let str = ddata.tfList.tfItem;
                                            let obj1 = new ModelRawNonQuery(req, res);
                                            let qrystr = "INSERT INTO `did_search` (`idaccount`,`phone_number`, `provider`, `iduser`, `priorty`,`type`,`rates`,`path`,`idapi`,`key`,`did_sub_type`) VALUE ";
                                            str.forEach((ele: any) => {
                                                qrystr += "('" + this.sessdata.idaccount + "', '" + ele.tn + "','" + "inteliQ" + "', '" + this.sessdata.iduser + "', '" + setToZero(this.priority) + "','TF','" + voice_rate[0].rate + "','" + parseBody(this.sessdata.path) + "','" + setToZero(this.sessdata.idapi) + "','" + this.timekey + "','1'),";
                                            });
                                            obj1.nonqrysql = qrystr.slice(0, -1);
                                            obj1.prepare();
                                            obj1.execute((err, data) => {
                                                callback(err, data);
                                            });
                                        } else {
                                            callback('', ddata);
                                        }
                                    } else {
                                        callback('', ddata);
                                    }
                                }
                                else {
                                    callback(error, '');
                                }
                            } catch (e) {
                                console.log("Error :: Inteliquent->getTollFree::", e);
                                callback(error, '');
                            }
                        } else {
                            callback(error, '');
                        }
                    });
                } else {
                    callback(err, voice_rate);
                }
            });
        }
    }

    public tfRequest(req: Request, res: Response, groupId: any, callback: (err: any, data: any) => void) {
        let sdata: any = req.body.data ? req.body.data : req.query;
        let quantity: any = sdata && sdata.cdata && sdata.cdata.Qty ? sdata.cdata.Qty : sdata.Quantity;
        let fun = new Number();
        fun.prorationGet(req, res, 'TF', 0, this.sessdata.idtariff, (error: any, proration: any) => {
            if (error == 1) {
                this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                    let rate = new APIBase();
                    rate.prorateCalculator(req, res, proration.proration, voice_rate[0].rate, proration.setup_cost, (pc_err, prorate1) => {
                        if (pc_err == 1) {
                            let fullrates = parseFloat(voice_rate[0].rate) + parseFloat(proration.setup_cost);
                            let prorate: any = typeof prorate1 != 'undefined' && prorate1 > 0 ? prorate1 : 0 
                            let RateS:any = (parseFloat(prorate) * quantity).toFixed(3);
                            console.log("Fullrates ::> ",fullrates);
                            console.log("Final ProRate with quantity multiplied ::> ",RateS);
                            
                            let rate = new APIBase();
                            rate.checkBalance(req, res, this.sessdata.idaccount, RateS, (walletError, wallet) => {
                                if (walletError == 1) {
                                    rate.calculateNextBillingDate(req, res, voice_rate[0].billing_frequency, (billingError, billing) => {
                                        if (billingError == 1) {
                                            // let privateKey = this.privateKey;
                                            let privateKey = intelli.privateKey;
                                            let customerOrderReference = "b1f86e6a5e0d";
                                            let respOrgId = "LQX01";
                                            let routingLabel = "NTDAL-4927-8XX-950";
                                            const formattedDate = new Date(new Date().getTime() + (4 * 24 * 60 * 60 * 1000)).toISOString().split('T')[0];
                                            var options = {
                                                'method': 'POST',
                                                // 'url': this.URL + '/tfRequest',
                                                'url': intelli.Url + '/tfRequest',
                                                'headers': {
                                                    'Content-Type': 'application/json',
                                                    // 'Authorization': 'Basic ' + this.key,
                                                    'Authorization': 'Basic ' + intelli.key,
                                                },
                                                body: JSON.stringify({
                                                    "privateKey": privateKey,
                                                    "customerOrderReference": customerOrderReference,
                                                    "desiredDueDate": formattedDate,
                                                    "quantity": quantity,
                                                    "respOrgId": respOrgId,
                                                    "routingLabel": routingLabel
                                                })
                                            };
                                            request(options, (error: any, response: any) => {
                                                if (!error) {
                                                    try {
                                                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                                        
                                                            let sdata1 = JSON.parse(response.body);
                                                            if (sdata1.statusCode == 200 && sdata1.status == 'Success') {

                                                                let objv6 = new ModelRawNonQuery(req, res);
                                                                objv6.nonqrysql = "INSERT INTO `tollfree_request` (`iduser`, `idaccount`, `privateKey`, `customerOrderReference`,`respOrgId`,`routingLabel`,`status`,`statusCode`,`orderId`,`quantity`,`order_status`,`rates`,`pro_rates`,`type`,`id_grouporder`,`billing_frequency`,`nextbilling_cycle`) VALUE('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + privateKey + "','" + customerOrderReference + "','" + respOrgId + "','routingLabel','" + sdata1.status + "','" + sdata1.statusCode + "','" + sdata1.orderId + "','" + quantity + "','0','" + fullrates + "','" + prorate + "','TF','" + groupId + "','" + setToZero(voice_rate[0].billing_frequency) + "', '"+billing+"')";
                                                                objv6.prepare();
                                                                objv6.execute((tol_error, tf_req) => {
                                                                    if (tol_error == 1) {
                                                                        // To update the wallet amount
                                                                        let objv = new ModelRawNonQuery(req, res);

                                                                        objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + RateS + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                                        objv.prepare();
                                                                        objv.execute((wallet_error, wallet_success) => {
                                                                            // To update the wallet transaction log
                                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                            iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                                            iQry += "`amount`='-" + RateS + "', "
                                                                            iQry += "`purpose`='Wallet amount successfully updated for Toll-Free Order', "
                                                                            iQry += "`status`=1;"

                                                                            let objWL = new ModelRawNonQuery(req, res);
                                                                            objWL.nonqrysql = iQry
                                                                            objWL.prepare()
                                                                            objWL.execute((error: any, result: any) => {
                                                                                if (error == 1) {
                                                                                    let objv = new RawView(res);
                                                                                    objv.prepare({ status: 200, message: "You have created your order successfully. Your Order will take 3 to 4 Business Days. Order ID is: (" + sdata1.orderId + ")" });
                                                                                    objv.execute();
                                                                                } else {
                                                                                    let objv = new RawView(res);
                                                                                    objv.prepare({ status: 404, message: "Order is not Placed!" });
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        });
                                                                    }
                                                                    else {
                                                                        let obj = new RawView(res);
                                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with connection!" });
                                                                        obj.execute()
                                                                    }
                                                                });
                                                                let objn = new ModelRawNonQuery(req, res);
                                                                objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`provider`,`status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'44','DID Order created successfully from provider','Inteliquent','" + sdata1.status + "','" + response.body + "')"
                                                                objn.prepare();
                                                                objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                                                    console.log("DID Order created successfully from provider.");
                                                                });
                                                            }
                                                            else {
                                                                let objn = new ModelRawNonQuery(req, res);
                                                                objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`provider`,`status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'45','DID Order creation failed from provider','Inteliquent','Failed','" + response.body + "')"
                                                                objn.prepare();
                                                                objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                                                    console.log("DID Order creation failed from provider!");
                                                                });

                                                                let obj = new RawView(res);
                                                                obj.prepare({ status: 502, message: "Toll-Free DID Order failed!" });
                                                                obj.execute();
                                                            }
                                                        }
                                                        else {
                                                            let obj = new RawView(res);
                                                            obj.prepare({ status: 501, message: "Toll-Free Order not created successfully!" });
                                                            obj.execute();
                                                        }
                                                    } catch (e) {
                                                        console.log("Error :: Inteliquent->tfRequest::", e);
                                                        let obj = new RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with DID Order!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let obj = new RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong DID Buy!" });
                                                    obj.execute()
                                                }
                                            });
                                        }
                                        else{
                                            let obj = new RawView(res);
                                            obj.prepare(billing);
                                            obj.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        error_code: 0,
                                        error: walletError,
                                        message: "Please add funds to your account or contact support.",
                                        status: 503
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error_code: 0,
                                error: 'Wallet Issue',
                                message: "Something Went Wrong to Fetch Account Balance.",
                                status: 503
                            });
                            objv.execute();
                        }
                    }); 
                    /* let dateObj = new Date();
                    let day = dateObj.getUTCDate();
                    let nDate: any = new Date()
                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                    let totalDays = (lDate - day) + 1;
                    let prorate: any;
                    if (proration.proration == "true")
                        prorate = ((totalDays * voice_rate[0].rate) / lDate) + proration.setup_cost;
                    else
                        prorate = (voice_rate[0].rate) + proration.setup_cost;

                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0 */
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({
                    error_code: 0,
                    status: 502,
                    message: "Something went wrong with connection!"
                });
                objv.execute();
            }
        });
    }

    public buyDID(req: Request, res: Response, did_details: any, other_data: any, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6)
        let id_grouporder: number = other_data.id_grouporder;
        let sub_type: number = other_data.sub_type;
        let days:any = other_data.days;  
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : ''
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : ''
            // To get the proration status
            /* let objv0 = new ModelRawQuery(req, res);
            // objv0.qrysql = "SELECT t.`proration`,t.`day_num` FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.qrysql = "SELECT t.`day_num`, DATE_FORMAT(IF(DATE_ADD(NOW(),INTERVAL t.day_num DAY) >NOW(), DATE_ADD(NOW(),INTERVAL t.day_num DAY),LAST_DAY(NOW())),'%Y-%m-%d %H:%i:%s') AS subscription_end_date FROM `user`u INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE u.iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((days_err, days) => {
                if (days_err == 1) { */
                    // let proration_status = days[0].proration;
                    let frates:number = other_data.fullrates;
                    let did_dis_days = days[0].day_num > 0 ? days[0].day_num : 0;
                    let prorate = typeof other_data.prorate != 'undefined' && other_data.prorate > 0 ? other_data.prorate : 0

                    // To purchase the toll free number
                    if (did_details[0].type == "TF") {
                        var options = {
                            'method': 'POST',
                            // 'url': this.URL + '/tfOrder',
                            'url': intelli.Url + '/tfOrder',
                            'headers': {
                                'Content-Type': 'application/json',
                                // 'Authorization': 'Basic ' + this.key
                                'Authorization': 'Basic ' + intelli.key
                            },
                            body: JSON.stringify({
                                // "privateKey": this.privateKey,
                                "privateKey": intelli.privateKey,
                                 "productAbbr": "8XXAVAIL",
                                "tfOrder": {
                                    "tnList": {
                                        "tnItem": [
                                            {
                                                "tn": sdata.DID.trim(),
                                                "resporgId": "LQX01",
                                                "routingLabel": "NTDAL-4927-8XX-950",
                                                "trunkGroup": "CHCGIL24IPL_4649"
                                            }
                                        ]
                                    }
                                }
                            })
                        }
                        request(options, (error: any, response: any) => {
                            if (!error) {
                                try {
                                    if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                        let sdata1 = JSON.parse(response.body);
                                        //If order success
                                        if (sdata1.statusCode == 200 && sdata1.status == 'Success') {

                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`,`did_sub_type`,`subscription_end_date`,`billing_frequency`,`nextbilling_cycle`) VALUE('" + this.sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + frates + "','" + setToZero(this.sessdata.idapi) + "','" + prorate + "','" + did_dis_days + "','" + frates + "','" + sub_type + "','" + days[0].subscription_end_date + "','" + setToZero(other_data.billing_frequency) + "','" + other_data.nextbilling_cycle + "')";
                                            obj.prepare();
                                            obj.execute((err, data) => {
                                                if (err == 1) {
                                                    // To update the wallet amount
                                                    let objv = new ModelRawNonQuery(req, res);
                                                    objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                    objv.prepare();
                                                    objv.execute((wallet_error, wallet_success) => {

                                                        // To update the wallet transaction log
                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                        iQry += "`amount`='-" + prorate + "', "
                                                        iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                        iQry += "`status`=1;"

                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {
                                                            console.log("Transaction response::", result)
                                                        })

                                                        // To create the DID log
                                                        let objv1 = new ModelRawNonQuery(req, res);
                                                        objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`,`full_log`) VALUE('" + this.sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + frates + "','" + setToZero(this.sessdata.idapi) + "','" + prorate + "','1','DID Buy','" + response.body + "')"
                                                        objv1.prepare();
                                                        objv1.execute((log_error, did_log) => { });

                                                        // To delete the DID from cart
                                                        let obj5 = new ModelRawNonQuery(req, res);
                                                        obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                        obj5.prepare();
                                                        obj5.execute((walletError: any, wallet: any) => { });

                                                        // To update the process count of group order
                                                        let objk = new ModelRawNonQuery(req, res)
                                                        objk.nonqrysql = "UPDATE `did_group_order` SET `status`='1' WHERE `id_grouporder`=" + id_grouporder + ";"
                                                        objk.prepare()
                                                        objk.execute((error, result) => {
                                                            console.log("GroupOrder process count::\n", result)
                                                        })

                                                        // To create the did_order
                                                        let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                                        let obj = new ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'TF', '" + frates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                        obj.prepare();
                                                        obj.execute((did_err, did_data) => {
                                                            // To update the other data on current order
                                                            if (did_err == 1) {
                                                                let id_order: number = did_data.insertId
                                                                let orderID: string = "SORD" + id_order.toString()

                                                                let log_error: string = ""
                                                                let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                                let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                                obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                                obj.prepare();
                                                                obj.execute((error, result) => { })
                                                            }
                                                        });
                                                        // Leave the successfull output
                                                        let objV = new RawView(res);
                                                        objV.prepare({ error_code: 1, status: 201, message: "DID buy successfully.", result: [{ "did": sdata.DID.trim() }] });
                                                        objV.execute()

                                                    });
                                                    // update end subscription date
                                                    // let obj0 = new ModelRawQuery(req, res);
                                                    // obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                                    // obj0.prepare();
                                                    // obj0.execute((dids_err, didRes) => {
                                                    //     let dates = didRes[0].subscription_end_date;
                                                    //     let isoDate = new Date(dates);
                                                    //     let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                    //     let obj01 = new ModelRawNonQuery(req, res);
                                                    //     obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                    //     obj01.prepare();
                                                    //     obj01.execute((error, result) => { })
                                                    // })
                                                }
                                                else {
                                                    let obj = new RawView(res);
                                                    obj.prepare({
                                                        error_code: 0,
                                                        status: 502,
                                                        message: "Something went wrong with connection!"
                                                    });
                                                    obj.execute()
                                                }
                                            });
                                            /* let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
                                            let nDate: any = new Date()
                                            let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                            let totalDays = (lDate - day) + 1;
                                            let prorate: any;
                                            if (other_data.proration == "true") {
                                                prorate = ((totalDays * did_details[0].rates) / lDate) + other_data.setup_cost;
                                            }
                                            else {
                                                prorate = (did_details[0].rates) + other_data.setup_cost;
                                            } */
                                        }

                                        // If order failed
                                        else {
                                            // To delete the DID from cart
                                            let obj5 = new ModelRawNonQuery(req, res);
                                            obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                            obj5.prepare();
                                            obj5.execute((walletError: any, wallet: any) => { });

                                            let I1: any = sdata1.status.indexOf("Waiting on internal port")
                                            let I2: any = sdata1.status.indexOf("TN is on a pending order")
                                            let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                            let obj = new ModelRawNonQuery(req, res);

                                            // To update the status of group order
                                            let objk = new ModelRawNonQuery(req, res)
                                            objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";"
                                            objk.prepare()
                                            objk.execute((error, result) => {
                                                console.log("Failed")
                                            });

                                            // It will check, if order goes into pending
                                            if (I1 > -1 || I2 > -1) {
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`, `ordConf`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "', '0')";
                                            }
                                            else {
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '4', 'TF', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                            }

                                            let objn = new ModelRawNonQuery(req, res);
                                            objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                                            objn.prepare();
                                            objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                                console.log("DID Buy failed from provider");
                                            });

                                            obj.prepare();
                                            obj.execute((did_err, did_data) => {
                                                // To update the other data on current order
                                                if (did_err == 1) {
                                                    let id_order: number = did_data.insertId
                                                    let orderID: string = "SORD" + id_order.toString()

                                                    let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                    let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                    let log_result: string = ""

                                                    obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                    obj.prepare();
                                                    obj.execute((error, result) => { })
                                                }
                                            });

                                            let objV = new RawView(res);
                                            objV.prepare({
                                                error_code: 0,
                                                status: sdata1.statusCode,
                                                message: sdata1.status
                                            });
                                            objV.execute()
                                        }
                                    }
                                    else {
                                        console.log("Inteliquent->buyDID::");
                                        let obj = new RawView(res);
                                        obj.prepare({ status: 502, message: "Something went wrong with DID buy!" });
                                        obj.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: Inteliquent->buyDID::", e);
                                    let obj = new RawView(res);
                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong DID Buy!" });
                                    obj.execute();
                                }
                            }
                            else {
                                let obj = new RawView(res);
                                obj.prepare({ status: 400, error: error });
                                obj.execute()
                            }
                        });
                    }

                    // To purchase the local number
                    else {
                        let objvv = new ModelRawQuery(req, res);
                        objvv.qrysql = "SELECT `portoutpin` FROM `account` WHERE idaccount= '" + this.sessdata.idaccount + "'";
                        objvv.prepare();
                        objvv.execute((portpin_error, portpin) => {
                            if (portpin_error == 1) {
                                let pinportout: any = '';
                                let cbody: any = '';
                                if (did_details[0].portout_pin_supported == '0' || did_details[0].portout_pin_supported == '1' || did_details[0].portout_pin_supported == 'HI') {
                                    pinportout = portpin[0].portoutpin;
                                    cbody = JSON.stringify({
                                        // "privateKey": this.privateKey,
                                        "privateKey": intelli.privateKey,
                                        "tnOrder": {
                                            "tnList": {
                                                "tnItem": [
                                                    {
                                                        "tn": sdata.DID.trim(),
                                                        "trunkGroup": "CHCGIL24IPL_4648",
                                                        "portOutPin": pinportout,
                                                    }
                                                ]
                                            }
                                        }
                                    });

                                }
                                else {
                                    pinportout = '';
                                    cbody = JSON.stringify({
                                        // "privateKey": this.privateKey,
                                        "privateKey": intelli.privateKey,
                                        "tnOrder": {
                                            "tnList": {
                                                "tnItem": [
                                                    {
                                                        "tn": sdata.DID.trim(),
                                                        "trunkGroup": "CHCGIL24IPL_4648",
                                                    }
                                                ]
                                            }
                                        }
                                    })
                                }
                                var options = {
                                    'method': 'POST',
                                    // 'url': this.URL + '/tnOrder',
                                    'url': intelli.Url + '/tnOrder',
                                    'headers': {
                                        'Content-Type': 'application/json',
                                        // 'Authorization': 'Basic ' + this.key
                                        'Authorization': 'Basic ' + intelli.key
                                    },
                                    body: cbody
                                }
                                request(options, (error: any, response: any) => {
                                    if (!error) {
                                        try {
                                            if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                                let sdata1 = JSON.parse(response.body);
                                                // If order success
                                                if (sdata1.statusCode == 200 && sdata1.status == 'Success') {
                                                    
                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`,`portoutpin`,`subscription_end_date`,`billing_frequency`,`nextbilling_cycle`) VALUE('" + this.sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + frates + "','" + setToZero(this.sessdata.idapi) + "','" + prorate + "','" + did_dis_days + "','" + frates + "','" + pinportout + "','" + days[0].subscription_end_date + "','" + setToZero(other_data.billing_frequency) + "','" + other_data.nextbilling_cycle + "')";
                                                    obj.prepare();
                                                    obj.execute((err, data) => {
                                                        if (err == 1) {
                                                            // To update the wallet amount
                                                            let objv = new ModelRawNonQuery(req, res);
                                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                            objv.prepare();
                                                            objv.execute((wallet_error, wallet_success) => {

                                                                // To update the wallet transaction log
                                                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                                iQry += "`amount`='-" + prorate + "', "
                                                                iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                                iQry += "`status`=1;"

                                                                let objWL = new ModelRawNonQuery(req, res);
                                                                objWL.nonqrysql = iQry
                                                                objWL.prepare()
                                                                objWL.execute((error: any, result: any) => {
                                                                    console.log("Transaction response::", result)
                                                                })

                                                                // To create the DID log
                                                                let objv1 = new ModelRawNonQuery(req, res);
                                                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`,`full_log`) VALUE('" + this.sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','inteliQ','" + sdata1.orderId + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + frates + "','" + setToZero(this.sessdata.idapi) + "','" + prorate + "','1','DID Buy','" + response.body + "')"
                                                                objv1.prepare();
                                                                objv1.execute((log_error, did_log) => { });

                                                                // To delete the DID from cart
                                                                let obj5 = new ModelRawNonQuery(req, res);
                                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                                obj5.prepare();
                                                                obj5.execute((walletError: any, wallet: any) => { });

                                                                // To update the process count of group order
                                                                let objk = new ModelRawNonQuery(req, res)
                                                                objk.nonqrysql = "UPDATE `did_group_order` SET `status`='1' WHERE `id_grouporder`=" + id_grouporder + ";"
                                                                objk.prepare()
                                                                objk.execute((error, result) => {
                                                                    console.log("GroupOrder process count::\n", result)
                                                                })

                                                                // To create the did_order
                                                                let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                                                let obj = new ModelRawNonQuery(req, res);
                                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'NN', '" + frates + "', 'Order successfully created.', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                                obj.prepare();
                                                                obj.execute((did_err, did_data) => {
                                                                    // To update the other data on current order
                                                                    if (did_err == 1) {
                                                                        let id_order: number = did_data.insertId
                                                                        let orderID: string = "SORD" + id_order.toString()

                                                                        let log_error: string = ""
                                                                        let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                                        let log_result: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')

                                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                                        obj.prepare();
                                                                        obj.execute((error, result) => { })
                                                                    }
                                                                });

                                                                // To submit the number on OSR
                                                                /* if (sdata.CampaignId) {
                                                                    let osr = new OsrApi(this.priority, this.sessdata)
                                                                    osr.updateNumber(req, res, data.insertId, (error, responce) => { })
                                                                }
                                                                else { */
                                                                let obj0 = new RawView(res);
                                                                obj0.prepare({
                                                                    error_code: 1,
                                                                    status: 201,
                                                                    message: "DID buy successfully.",
                                                                    result: [
                                                                        {
                                                                            "did": sdata.DID.trim()
                                                                        }
                                                                    ]
                                                                });
                                                                obj0.execute()
                                                                /* } */
                                                            });
                                                            // update end subscription date
                                                            // let obj0 = new ModelRawQuery(req, res);
                                                            // obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                                            // obj0.prepare();
                                                            // obj0.execute((dids_err, didRes) => {
                                                            //     let dates = didRes[0].subscription_end_date;
                                                            //     let isoDate = new Date(dates);
                                                            //     let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                            //     let obj01 = new ModelRawNonQuery(req, res);
                                                            //     obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                            //     obj01.prepare();
                                                            //     obj01.execute((error, result) => { })
                                                            // })
                                                        }
                                                        else {
                                                            let obj = new RawView(res);
                                                            obj.prepare({
                                                                error_code: 0,
                                                                status: 502,
                                                                message: "Something went wrong with connection!"
                                                            });
                                                            obj.execute()
                                                        }
                                                    });
                                                    /* let dateObj = new Date();
                                                    let day = dateObj.getUTCDate();
                                                    let nDate: any = new Date()
                                                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                                    let totalDays = (lDate - day) + 1;
                                                    let prorate: any;
                                                    if (other_data.proration == "true") {
                                                        prorate = ((totalDays * did_details[0].rates) / lDate) + other_data.setup_cost;
                                                    }
                                                    else {
                                                        prorate = (did_details[0].rates) + other_data.setup_cost;
                                                    }
                                                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0 */
                                                }

                                                // If order failed
                                                else {
                                                    // To delete the DID from cart
                                                    let obj5 = new ModelRawNonQuery(req, res);
                                                    obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'"
                                                    obj5.prepare();
                                                    obj5.execute((walletError: any, wallet: any) => { });

                                                    let providerOrderId: any = typeof sdata1.orderId != 'undefined' && sdata1.orderId ? sdata1.orderId : ''

                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`, `providerOrderId`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + sdata.DID + "', '2', 'NN', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1, '" + providerOrderId + "')";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        // To update the other data on current order
                                                        if (did_err == 1) {
                                                            let id_order: number = did_data.insertId
                                                            let orderID: string = "SORD" + id_order.toString()

                                                            let log_error: string = JSON.stringify(sdata1).replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                            let log_message: string = sdata1.status.replace(/'/g, "\\'").replace(/"/g, '\\"')
                                                            let log_result: string = ""

                                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='" + sdata1.statusCode + "', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='inteliQ' WHERE `id_order`=" + id_order + ";"
                                                            obj.prepare();
                                                            obj.execute((error, result) => { })
                                                        }
                                                    });

                                                    // To update the status of group order
                                                    let objk = new ModelRawNonQuery(req, res)
                                                    objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";"
                                                    objk.prepare()
                                                    objk.execute((error, result) => {
                                                        console.log("Failed")
                                                    });

                                                    let objn = new ModelRawNonQuery(req, res);
                                                    objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                                                    objn.prepare();
                                                    objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                                        console.log("DID Buy failed from provider");
                                                    });

                                                    let objV = new RawView(res);
                                                    objV.prepare({
                                                        error_code: 0,
                                                        status: sdata1.statusCode,
                                                        message: sdata1.status
                                                    });
                                                    objV.execute()
                                                }
                                            }
                                            else {
                                                console.log("Inteliquent->buyDID");
                                                let obj = new RawView(res);
                                                obj.prepare({ status: 502, message: "Something went wrong with DID buy!" });
                                                obj.execute();
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: Inteliquent->buyDID::", e);
                                            let obj = new RawView(res);
                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                            obj.execute();
                                        }

                                    }
                                    else {
                                        let obj = new RawView(res);
                                        obj.prepare({
                                            error_code: 0,
                                            status: 400,
                                            error: error
                                        });
                                        obj.execute()
                                    }
                                });
                            }
                            else {
                                let obj = new RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 502,
                                    message: "Something went wrong with get portoutpin!"
                                });
                                obj.execute();
                            }
                        })
                    }
                /* }
                else {
                    let obj = new RawView(res);
                    obj.prepare({
                        error_code: 0,
                        status: 502,
                        message: "Something went wrong with get proration!"
                    });
                    obj.execute();
                }
            }); */
        });
    }

    disconnectDID(req: Request, res: Response, payload: any, callback: (err: any, data: any) => void) {
        const sdata = req.body;
        let iduser: number = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let idaccount: number = (typeof sdata.idaccount != 'undefined' && sdata.idaccount > 0) ? sdata.idaccount : this.sessdata.idaccount;
        // To release the toll-free number
        if (payload.type == "TF") {
            var options = {
                'method': 'POST',
                // 'url': this.URL + '/tfDisconnect',
                'url': intelli.Url + '/tfDisconnect',
                'headers': {
                    'Content-Type': 'application/json',
                    // 'Authorization': 'Basic ' + this.key
                    'Authorization': 'Basic ' + intelli.key
                },
                body: JSON.stringify({
                    // "privateKey": this.privateKey,
                    "privateKey": intelli.privateKey,
                    "tnList": {
                        "tnItem": [
                            {
                                "tn": sdata.DID.trim()
                            }
                        ]
                    }
                })
            };
            request(options, (error: any, response: any) => {
                if (!error) {
                    try {
                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let data = JSON.parse(response.body);
                            if (data.status == 'Success') {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='0',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `account_id`='" + idaccount + "'";
                                obj.prepare();
                                obj.execute((error: any, resp: any) => {
                                    if (error == 1) {
                                        // To  update updated_at date in did log
                                        let obj = new ModelRawNonQuery(req, res);
                                        //obj.nonqrysql = "UPDATE `did_log` SET `updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                        obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','Disconnect DID from provider','" + sdata.DID.trim() + "')"
                                        obj.prepare();
                                        obj.execute((errorDiDLg: any, resDiDLg: any) => { });

                                        // To release the final output
                                        let objv = new RawView(res)
                                        objv.prepare({ status: 201, message: "DID Disconnected Successfully" })
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        objv.execute();
                                    }
                                })
                            }
                            else {
                                let objn = new ModelRawNonQuery(req, res);
                                objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'39','DID disconnect failed from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                                objn.prepare();
                                objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                    console.log("DID disconnect failed FROM provider");
                                });

                                let objv = new RawView(res);
                                objv.prepare({ status: data.statusCode, message: data.status });
                                objv.execute()
                            }
                        }
                        else {
                            console.log("Inteliquent->disconnectDID");
                            let objv = new RawView(res);
                            objv.prepare({ status: 402, message: "Something went wrong with disconnect DID!" });
                            objv.execute()
                        }
                    }
                    catch (e) {
                        console.log("Error :: Inteliquent->disconnectDID::", e);
                        let obj = new RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }

                }
                else {
                    console.log("Inteliquent :::::::::::::::::::");
                    let objv = new RawView(res);
                    objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                    objv.execute()
                }
            });
        }
        // To release the local number
        else {
            var options = {
                'method': 'POST',
                // 'url': this.URL + '/tnDisconnect',
                'url': intelli.Url + '/tnDisconnect',
                'headers': {
                    'Content-Type': 'application/json',
                    // 'Authorization': 'Basic ' + this.key
                    'Authorization': 'Basic ' + intelli.key
                },
                body: JSON.stringify({
                    // "privateKey": this.privateKey,
                    "privateKey": intelli.privateKey,
                    "tnList": {
                        "tnItem": [
                            {
                                "tn": sdata.DID.trim()
                            }
                        ]
                    }
                })
            };
            request(options, (error: any, response: any) => {
                if (!error) {
                    try {
                        if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let data = JSON.parse(response.body);
                            if (data.status == 'Success' || data.statusCode == '425') {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `account_id`='" + idaccount + "'";
                                obj.prepare();
                                obj.execute((error: any, resp: any) => {
                                    if (error == 1) {
                                        // To  update updated_at date in did log
                                        let obj = new ModelRawNonQuery(req, res);
                                        //obj.nonqrysql = "UPDATE `did_log` SET `event_type`='5',`description`='DID Disconnected Successfully from Intelliquent',`updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                        obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + iduser + "',NOW(),'5','DID Disconnected Successfully','" + sdata.DID.trim() + "','" + response.body + "')"
                                        obj.prepare();
                                        obj.execute((errorDiDLg: any, resDiDLg: any) => { });

                                        // To delete the number from OSR
                                        let payLoad: any = {
                                            DID: sdata.DID.trim(),
                                            campaign: payload.campaign,
                                            iduser: iduser,
                                            idaccount: idaccount,
                                            type: payload.type,                                            
                                            did_sub_type: payload.did_sub_type,
                                        }
                                        let osr = new OsrApi(this.priority, this.sessdata)
                                        osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                            if (error == 1) {
                                                if (payload.sms_provider && payload.sms_provider.toLowerCase() == 'sinch') {
                                                    // To delete the number from Sinch
                                                    let osr = new SinchApi(this.priority, this.sessdata)
                                                    osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                                    })
                                                } else {
                                                    // To delete the number from Syniverse
                                                    let osr = new SinchApi(this.priority, this.sessdata)
                                                    osr.deleteNumberM2fromSyniverse(req, res, payLoad, (error, response) => {
                                                    })
                                                }
                                            }
                                        })

                                        // To release the final output
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 201, message: "DID Disconnected Successfully" })
                                        objv.execute()
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 502, message: "Something Went Wrong" });
                                        objv.execute();
                                    }
                                })
                            }
                            else {
                                let objn = new ModelRawNonQuery(req, res);
                                objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'39','DID disconnect failed from provider','" + sdata.DID.trim() + "','" + response.body + "')"
                                objn.prepare();
                                objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                    console.log("DID disconnect failed FROM provider");
                                });

                                let objv = new RawView(res);
                                objv.prepare({ status: data.statusCode, message: data.status });
                                objv.execute()
                            }
                        }
                        else {
                            console.log("Inteliquent->disconnectDID");
                            let objv = new RawView(res);
                            objv.prepare({ status: 402, message: "Something went wrong with disconnect DID!" });
                            objv.execute()
                        }
                    }
                    catch (e) {
                        console.log("Error :: Inteliquent->disconnectDID::", e);
                        let obj = new RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 400, error: error });
                    objv.execute()
                }
            });
        }

    }
    public EnableTFSMS(req: Request, res: Response, callback: (err: any, data: any) => void) {
        console.log("Toll-Free Number Enable SMS Process");
        const sdata = JSON.parse(req.body.data);
        let iduser: any = this.sessdata.type == 1 ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = this.sessdata.type == 1 ? sdata.idaccount : this.sessdata.idaccount;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + iduser + "'";
        obj.prepare();
        obj.execute((error: any, result: any) => {
            if(error ==1){
                let FullName = result[0].firstname + ' ' + result[0].lastname;
                if (sdata.sinch_status === '0') {
                    let rate = new APIBase();
                    rate.getMessageRate(req, res, this.sessdata.idtariff, "message_activation", "TF", (err, message_rate) => {
                        if (err == 1) {
                            let nrcMsgRate: any = message_rate.length > 0 && message_rate[0].nrc !== undefined ? message_rate[0].nrc : 0,
                                mrcMsgRate: any = message_rate.length > 0 && message_rate[0].mrc !== undefined ? message_rate[0].mrc : 0;
        
                            rate.checkBalance(req, res, idaccount, nrcMsgRate, (errorR, resR) => {
                                if (errorR == 1) {
                                    var options = {
                                        'method': 'POST',
                                        // 'url': this.URL + '/tfFeatureOrder',
                                        'url': intelli.Url + '/tfFeatureOrder',
                                        'headers': {
                                            'Content-Type': 'application/json',
                                            // 'Authorization': 'Basic ' + this.key,
                                            'Authorization': 'Basic ' + intelli.key,
                                            'Cookie': '__cf_bm=kLWM48QBIMVsXKCwoYpoO0Yx9yDUc5rz4pH2d..0vrg-1699441378-0-AZQ5AnHYIYAr4fcquQ3l3/aapkg+bqmn4hHGlCuS8LnswSB8xiwldZdXsfCQOio177BNIpUV8PAKmYKVeKc4JV0='
                                        },
                                        body: JSON.stringify({
                                            // "privateKey": this.privateKey,
                                            "privateKey": intelli.privateKey,
                                            "tfFeatureOrder": {
                                                "customerOrderReference": "b1f86e6a5e0d",
                                                "tnList": {
                                                    "tnItem": [
                                                        {
                                                            "tn": sdata.DID.trim(),
                                                            "tnFeature": {
                                                                "messaging": {
                                                                    "messageClass": "A2P8XX",
                                                                    "messageType": "SMSMMS_ALT",
                                                                    "removeTnFeature": "N"
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            }
                                        })
                                    };                            
                                    request(options, (error: any, response: any) => {                                
                                        if (!error) {
                                            try {
                                                if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                                    let data = JSON.parse(response.body);                                            
                                                    if (data.statusCode == 200) {
                                                        // To Set Webhook URL on Toll Free Number
                                                        let intel = new InteliquentAPI("", this.sessdata, '');
                                                        intel.setWebhookUrlOnTF(req, res, (errorr, resp) => { });
        
                                                        if (nrcMsgRate > 0) {
                                                            // To deduct SMS Enable charges
                                                            let obj0 = new ModelRawNonQuery(req, res);
                                                            obj0.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + nrcMsgRate + " WHERE `idaccount`='" + idaccount + "'"
                                                            obj0.prepare();
                                                            obj0.execute((wallet_error, wallet_success) => {
                                                                if (wallet_error == 1) {
                                                                    let objWL = new ModelRawNonQuery(req, res);
                                                                    objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount successfully updated for TF EnableSMS', `status`=1"
                                                                    objWL.prepare()
                                                                    objWL.execute((error: any, result: any) => {
                                                                        console.log("Wallet amount successfully updated for TF EnableSMS :: ", nrcMsgRate);
                                                                    });
                                                                }
                                                                else {
                                                                    let objWL = new ModelRawNonQuery(req, res);
                                                                    objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount not updated for TF  EnableSMS', `status`=2"
                                                                    objWL.prepare()
                                                                    objWL.execute((error: any, result: any) => {
                                                                        console.log("Wallet amount not updated for TF EnableSMS :: ", nrcMsgRate);
                                                                    });
                                                                }
                                                            });
        
                                                            // To Insert nrc
                                                            let obj4 = new ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `sms_enabled_charges_log`(`iduser`,`idaccount`,`did`,`nrc`) VALUES ('" + iduser + "','" + idaccount + "','" + sdata.DID.trim() + "','" + nrcMsgRate + "')";
                                                            obj4.prepare();
                                                            obj4.execute((osr_err, resp) => {
                                                                console.log("TF EnableSMS Charges Log Inserted :: ", nrcMsgRate);
                                                            });
                                                        }
        
                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'28','DID provisioned to INTELLIQUENT','" + sdata.DID.trim() + "','15','" + response.body + "')";
                                                        obj1.prepare();
                                                        obj1.execute((err1, resp1) => {
                                                            console.log("DID log inserted for TF EnableSMS");
                                                        });
        
                                                        let obj2 = new ModelRawNonQuery(req, res);
                                                        obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='15', `sms_mrc`='" + mrcMsgRate + "' WHERE account_id = '" + idaccount + "' AND `did`='" + sdata.DID.trim() + "'";
                                                        obj2.prepare();
                                                        obj2.execute((err2, resp2) => {
                                                            console.log("DID buy updated for TF EnableSMS");
                                                        });
        
                                                        let obj0 = new ModelRawNonQuery(req, res);
                                                        obj0.nonqrysql = "UPDATE verified_sender SET status = '3',username = '" + parseBody(FullName) + "', awaiting_downstream_date = NOW() WHERE idaccount = '" + idaccount + "' AND unique_request_id = '" + sdata.request_id + "'";
                                                        obj0.prepare();
                                                        obj0.execute((err1, resp1) => {
                                                            console.log("Update the status");
                                                        });
        
                                                        let obj3 = new ModelRawNonQuery(req, res);
                                                        obj3.nonqrysql = "INSERT INTO `tollfree_assigned_number` (`idaccount`,`iduser`,`did`,`tf_status`,`statusCode`,`orderId`,`requestId`) VALUES('" + idaccount + "','" + iduser + "','" + sdata.DID.trim() + "','" + data.request_id + "','" + data.statusCode + "','" + data.orderId + "','" + sdata.request_id + "')";
                                                        obj3.prepare();
                                                        obj3.execute((err3, resp3) => {
                                                            console.log("tollfree_sms_response for TF EnableSMS successfully inserted!");
                                                        });
        
                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + iduser + "', '" + idaccount + "', '3', 'AWATING_DOWNSTREAM_PROCESS', 'Awaiting Downstream Process', '" + sdata.request_id + "')";
                                                        obj4.prepare();
                                                        obj4.execute((err4: any, resp4: any) => { });
        
                                                        callback(1, { status: 200, message: "SMS enabled successfully!" });
                                                    }
                                                    else {
                                                        console.log("Response ::==>> ", data);
                                                        let obj4 = new ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'29','DID provisioning failed to INTELLIQUENT','" + sdata.DID.trim() + "','0','" + response.body + "')";
                                                        obj4.prepare();
                                                        obj4.execute((err4, resp4) => { });
        
                                                        callback(0, { status: 502, message: "SMS is not enabled!" });
                                                    }
                                                }
                                                else {
                                                    callback(0, { message: "SMS is not enabled!", status: 507 });
                                                }
                                            } catch (e) {
                                                console.log("Error :: Inteliquent->EnableTFSMS::", e);
                                                callback(0, { message: "Something Went Wrong with the server!", status: 508 });
                                            }
                                        }
                                        else {
                                            callback(0, { status: 506, message: "Something went wrong with service!" });
                                        }
                                    });
                                }
                                else {
                                    callback(0, { message: "Please add funds to your account or contact support.", status: 504 });
                                }
                            });
                        }
                        else {
                            callback(0, { status: 505, message: "Rates not Found!" });
                        }
                    });
                }
                else if (sdata.sinch_status === '16') {
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE did_buy SET sinch_status = 15 WHERE did = '" + sdata.DID + "' AND account_id = " + idaccount + " AND `type`='TF'";
                    obj1.prepare();
                    obj1.execute((err1, resp1) => {
                    });
        
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "UPDATE verified_sender SET status = '3',username = '" + parseBody(FullName) + "', awaiting_downstream_date = NOW() WHERE idaccount = '" + idaccount + "' AND unique_request_id = '" + sdata.request_id + "'";
                    obj0.prepare();
                    obj0.execute((err1, resp1) => {
                        console.log("Update the status");
                    });
        
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE tollfree_assigned_number SET requestId = '" + sdata.request_id + "' WHERE did = '" + sdata.DID + "' AND idaccount = '" + idaccount + "'";
                    obj2.prepare();
                    obj2.execute((err2, resp2) => {
                    });
                    
                    let obj3 = new ModelRawNonQuery(req, res);
                    obj3.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`) VALUES ('" + iduser + "', '" + idaccount + "', '3', 'AWATING_DOWNSTREAM_PROCESS', 'Awaiting Downstream Process', '" + sdata.request_id + "')";
                    obj3.prepare();
                    obj3.execute((_error: any, result: any) => { });
        
                    callback(1, { status: 200, message: "SMS enabled successfully!" });
                } else {
                    callback(0, { status: 503, message: "SMS enabling Service not available!" });
                }
            }else{
                callback(0, { status: 502, message: "Something Went Wrong!" });
            }
        })
    }
    public setWebhookUrlOnTF(req: Request, res: Response, callback: (err: any, data: any) => void) {
        console.log("Set Toll-Free Webhook URL");
        const sdata = JSON.parse(req.body.data);
        let iduser: any = this.sessdata.type == 1 ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = this.sessdata.type == 1 ? sdata.idaccount : this.sessdata.idaccount;
        var options = {
            'method': 'POST',
            // 'url': this.sendTFSMSUrl + '/configureAuthorization',
            'url': intelli.sendTFSMSUrl + '/configureAuthorization',
            'headers': {
                'Content-Type': 'application/json',
                // 'Authorization': 'Bearer ' + this.sendSMSKey,
                'Authorization': 'Bearer ' + intelli.sendSMSKey,
            },
            body: JSON.stringify({
                "authorizations": [
                    {
                        "inboundAuth": true,
                        // "webhookUrl": "https://api.signalmash.com/intelequent_tollfreewebhook",
                        "webhookUrl": intelli.webhookUrl,
                        "tn": "1" + sdata.DID.trim().slice(-10)
                    }
                ]
            })
        };
        request(options, function (error: any, response: any) {
            if (!error) {
                try {
                    if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                        let data = JSON.parse(response.body)
                        let event_type: any = '', description: any = '';
                        if (data.success == true) {
                            event_type = '32';
                            description = 'Toll Free Webhook Url Set Successfully';
                            console.log("Toll Free webhook URL set successfully");
                        }
                        else {
                            event_type = '33';
                            description = 'Toll Free Webhook Url Not Set'
                            console.log("Toll-Free webhook URL not set!");
                        }
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + idaccount + "','" + iduser + "',NOW(),'" + event_type + "','" + description + "','" + sdata.DID.trim() + "','" + response.body + "')";
                        obj1.prepare();
                        obj1.execute((err1, resp1) => {
                            console.log("DID Log Inserted for Set Toll-Free Webhook URL");
                        });
                    }
                    else {
                        console.log("Toll-free webhook URL not set successfully!");
                    }

                } catch (e) {
                    console.log("Error :: Inteliquent->setWebhookUrlOnTF::", e);
                    console.log("Something Went Wrong with the server!");
                }
            }
            else {
                console.log("Something went wrong!");
            }
        });
    }

    public disableTFSMS(req: Request, res: Response, callback: (err: any, data: any) => void) {
        console.log("Toll-Free Number Disable SMS Process");
        const sdata = JSON.parse(req.body.data);
        let iduser: any = this.sessdata.type == 1 ? sdata.iduser : this.sessdata.iduser;
        let idaccount: any = this.sessdata.type == 1 ? sdata.idaccount : this.sessdata.idaccount;
        var options = {
            'method': 'POST',
            // 'url': this.URL + '/tfFeatureOrder',
            'url': intelli.Url + '/tfFeatureOrder',
            'headers': {
                'Content-Type': 'application/json',
                // 'Authorization': 'Basic ' + this.key,
                'Authorization': 'Basic ' + intelli.key,
                'Cookie': '__cf_bm=kLWM48QBIMVsXKCwoYpoO0Yx9yDUc5rz4pH2d..0vrg-1699441378-0-AZQ5AnHYIYAr4fcquQ3l3/aapkg+bqmn4hHGlCuS8LnswSB8xiwldZdXsfCQOio177BNIpUV8PAKmYKVeKc4JV0='
            },
            body: JSON.stringify({
                // "privateKey": this.privateKey,
                "privateKey": intelli.privateKey,
                "tfFeatureOrder": {
                    "customerOrderReference": "b1f86e6a5e0d",
                    "tnList": {
                        "tnItem": [
                            {
                                "tn": sdata.DID.trim(),
                                "tnFeature": {
                                    "messaging": {
                                        "messageClass": "A2P8XX",
                                        "messageType": "SMSMMS_ALT",
                                        "removeTnFeature": "Y"
                                    }
                                }
                            }
                        ]
                    }
                }
            })
        };
        request(options, function (error: any, response: any) {
            if (!error) {
                try {
                    if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                        let data = JSON.parse(response.body);
                        if (data.statusCode == 200) {
                            let obj0 = new ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`) VALUES('" + idaccount + "','" + iduser + "',NOW(),'30','DID provisioning MARK_DELETE to INTELLIQUENT','" + sdata.DID.trim() + "','0','" + response.body + "')";
                            obj0.prepare();
                            obj0.execute((err4, resp4) => { });

                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0' WHERE  iduser = '" + iduser + "' AND `did`=" + sdata.DID.trim() + "";
                            obj1.prepare();
                            obj1.execute((err1, resp1) => { });

                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "DELETE FROM `tollfree_assigned_number` WHERE iduser = '" + iduser + "' AND requestId = '" + sdata.request_ID + "' AND did = '" + sdata.DID + "'";
                            obj2.prepare();
                            obj2.execute((err2, resp2) => {
                                console.log("SMS Service Disabled successfully!");
                                callback(1, { status: 200, message: "SMS Service Disabled successfully!" });
                            });
                        }
                        else {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUES('" + idaccount + "','" + iduser + "',NOW(),'31','DID provisioning DELETE failed to INTELLIQUENT','" + sdata.DID.trim() + "','','0','" + response.body + "')";
                            obj3.prepare();
                            obj3.execute((err4, resp4) => {
                                callback(0, { status: 501, message: "SMS Service Not Disabled successfully!" });
                            });
                        }
                    }
                    else {
                        callback(0, { status: 503, message: "SMS disabling Service not available!" });
                    }
                } catch (e) {
                    console.log("Error :: Inteliquent->disableTFSMS::", e);
                    callback(0, { message: "Something Went Wrong with the server!", status: 502 });
                }
            } else {
                callback(0, { message: "Something Went Wrong with the service!", status: 502 });
            }
        });
    }
    getId() {
        return [2, 2, 2, 6].reduce((prev, len) => prev + '-' + crypto.randomBytes(len).toString('hex'), crypto.randomBytes(4).toString('hex'))
    }
    sendTFSMS(req: Request, res: Response, sessData: any, DIDData: any, callback: (err: any, data: any) => void) {

        let uuid: any = this.getId();
        let sdata = req.body;
        let TO = sdata.TO.replace(/\D/g, '').slice(-10);
        let FROM = sdata.FROM.replace(/\D/g, '').slice(-10);
        let iduser: any = sessData.type == 1 ? sdata.iduser : sessData.iduser;
        let idaccount: any = sessData.type == 1 ? sdata.idaccount : sessData.idaccount;
        let rate = new APIBase();
        rate.getTollfreeSMSRate(req, res, sessData.idtariff, "SMS", "toll_free", (err, message_rate) => {
            if (err == 1 && message_rate.length > 0) {
                let msgcount = Math.ceil((sdata.BODY.length) / 159);
                let cost = msgcount * (message_rate[0].MT_rates + DIDData.dLergDt.rates);
                let MT_rates: any = msgcount * message_rate[0].MT_rates;
                let MT_surcharge: any = msgcount * DIDData.dLergDt.rates;
                let msg_data = sdata.BODY;

                rate.checkBalance(req, res, idaccount, cost, (errorR, resR) => {
                    if (errorR == 1) {
                        var options = {
                            'method': 'POST',
                            // 'url': this.sendTFSMSUrl + '/publishMessages',
                            'url': intelli.sendTFSMSUrl + '/publishMessages',
                            'headers': {
                                'Content-Type': 'application/json',
                                // 'Authorization': 'Bearer ' + this.sendSMSKey,
                                'Authorization': 'Bearer ' + intelli.sendSMSKey,
                            },
                            body: JSON.stringify({
                                "from": '1' + FROM,
                                "text": sdata.BODY,
                                "to": ["1" + TO]
                            })
                        };
                        request(options, function (error: any, response: any) {
                            if (!error) {
                                try {
                                    //if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                    if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                        let data = JSON.parse(response.body)
                                        if (data.success == true) {
                                            //let msg_data = sdata.BODY.replace(/"/g, '\\"').replace(/'/g, "\\'");
                                            // To update the wallet amount
                                            let objv = new ModelRawNonQuery(req, res);
                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + cost + " WHERE `idaccount`='" + idaccount + "'"
                                            objv.prepare();
                                            objv.execute((wallet_error, wallet_success) => {
                                            });

                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`is_billable`) VALUES('" + data.result.referenceId + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + parseBody(msg_data) + "',1,'" + idaccount + "','" + iduser + "','toll_free','1','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + setToZero(sessData.idapi) + "','" + MT_surcharge + "','" + setToZero(DIDData.dLergDt.idoperator) + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "',1)";
                                            obj0.prepare();
                                            obj0.execute((error: any, result: any) => {
                                                if (error == 1) {
                                                    console.log("Message Send Successfully!");
                                                    callback(1, { status: 201, message: "SMS Submit Successfully", batch_id: data.result.referenceId })
                                                }
                                                else {
                                                    console.log("Message Send Successfully But Something Went Wrong With Insertion!");
                                                    callback(1, { status: 401, message: "Something went wrong!", batch_id: data.result.referenceId })
                                                }
                                            });

                                            let obj1 = new ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`status`,`reason`,`detail`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + data.result.referenceId + "','1','" + data.result.resultResponses[0].status + "','" + data.reason + "','" + data.detail + "','" + data.result.referenceId + "','" + FROM + "','" + TO + "','" + parseBody(msg_data) + "')";
                                            obj1.prepare();
                                            obj1.execute((error: any, result: any) => { });

                                        }
                                        else {
                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`) VALUES('" + uuid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + parseBody(msg_data) + "',2,'" + idaccount + "','" + iduser + "','toll_free','1','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + setToZero(sessData.idapi) + "','" + MT_surcharge + "','" + setToZero(DIDData.dLergDt.idoperator) + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "')";
                                            obj0.prepare();
                                            obj0.execute((error: any, result: any) => {
                                                console.log("Something Went Wrong!");
                                                callback(0, { status: 402, message: "SMS not Sent!" })
                                            });

                                            let obj1 = new ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`reason`,`detail`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + uuid + "','1','" + data.reason + "','" + data.detail + "','" + uuid + "','" + FROM + "','" + TO + "','" + parseBody(msg_data) + "')";
                                            obj1.prepare();
                                            obj1.execute((error: any, result: any) => { });
                                        }
                                    }
                                    else {
                                        callback(0, { message: "SMS not Sent Successfully!", status: 507 })
                                    }

                                }
                                catch (e) {
                                    console.log("Error :: Inteliquent->sendTFSMS::", e);
                                    callback(0, { message: "Something Went Wrong with the server!", status: 504 })
                                }
                            }
                            else {
                                callback(0, { message: "Something went wrong!", status: 502 })
                            }
                        });
                    }
                    else {
                        callback(0, { message: "Please add funds to your account or contact support.", status: 503 })
                    }
                });
            }
            else {
                callback(0, { status: 502, message: "MT Rates not Found!" })
            }
        });
    }

    sendTFMMS(req: Request, res: Response, sessData: any, DIDData: any, callback: (err: any, data: any) => void) {
        let uuid: any;
        let restatus: any;
        let dlr_status: any;
        let mediaurl: any = DIDData.fileUrl;
        let sdata = req.body;
        let iduser: any = sessData.type == 1 ? sdata.iduser : sessData.iduser;
        let idaccount: any = sessData.type == 1 ? sdata.idaccount : sessData.idaccount;
        let TO = sdata.TO.trim().slice(-10);
        let FROM = sdata.FROM.trim().slice(-10);
        let rate = new APIBase();
        rate.getTollfreeSMSRate(req, res, sessData.idtariff, "MMS", "toll_free", (err, message_rate) => {
            if (err == 1 && message_rate.length > 0) {

                // let msgcount = Math.ceil((sdata.BODY.length) / 159);
                let msgcount = 1;
                let cost = msgcount * (message_rate[0].MT_rates + DIDData.dLergDt.rates);
                let MT_rates: any = msgcount * message_rate[0].MT_rates;
                let MT_surcharge: any = msgcount * DIDData.dLergDt.rates;
                let msg_data = sdata.BODY;

                rate.checkBalance(req, res, idaccount, cost, (errorR, resR) => {
                    if (errorR == 1) {
                        var options = {
                            'method': 'POST',
                            // 'url': this.sendTFSMSUrl + '/publishMessages',
                            'url': intelli.sendTFSMSUrl + '/publishMessages',
                            'headers': {
                                'Content-Type': 'application/json',
                                // 'Authorization': 'Bearer ' + this.sendSMSKey,
                                'Authorization': 'Bearer ' + intelli.sendSMSKey,
                            },
                            body: JSON.stringify({
                                "from": '1' + FROM,
                                "text": sdata.BODY,
                                "to": ["1" + TO],
                                "mediaUrls": [DIDData.fileUrl]
                            })
                        };
                        request(options, (error: any, response: any) => {
                            if (!error) {
                                try {
                                    if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {

                                        let send_status: any = '', status_detail: any = '', status_code: any = '', is_billable: any = 0;

                                        let data = JSON.parse(response.body);
                                        // let data = {"detail":"SUCCESS","reason":"SUCCESS","result":{"from":"18776524763","messageType":"MMS","referenceId":"89094be1-f73e-4812-b2a7-b52da4a3f4ed","resultResponses":[{"status":"SUCCESS","to":"18166685957"}],"text":"Test"},"success":true} // Real Third Party Response 
                                        if (data.success == true) {

                                            send_status = 1 // Delivered 
                                            status_detail = 'MMS Sent Successfully';
                                            status_code = 201;
                                            is_billable = 1;
                                            uuid = data.result.referenceId;
                                            restatus = data.result.resultResponses[0].status;
                                            dlr_status = "success";

                                            let obj0 = new ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + cost + " WHERE `idaccount`='" + sessData.idaccount + "'"
                                            obj0.prepare();
                                            obj0.execute((wallet_error, wallet_success) => {
                                                if (wallet_error == 1) {
                                                    console.log("Wallet amount successfully deducted for TF MMS Send :: ", cost);
                                                }
                                                else {
                                                    console.log("Wallet amount not deducted for TF MMS Send :: ", cost);
                                                }
                                            });
                                        }
                                        else {
                                            cost = 0;
                                            send_status = 2; // Failed
                                            status_detail = 'MMS sent failed';
                                            status_code = 400;
                                            is_billable = 0;
                                            uuid = this.getId();
                                            restatus = '';
                                            dlr_status = "Failed";
                                        }

                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `mms_mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`, `slide`,`direction`,`did_provider`,`service_id`,`cost`,`type`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`,`is_billable`) VALUES('" + uuid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + parseBody(msg_data) + "','" + send_status + "','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + idaccount + "','" + iduser + "','toll_free','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + setToZero(sessData.idapi) + "','" + MT_surcharge + "','" + setToZero(DIDData.dLergDt.idoperator) + "','" + DIDData.dLergDt.name + "','" + mediaurl + "','outbound','" + DIDData.DIDProvider + "','" + DIDData.camp_registry + "','" + cost + "','2',NOW(),NOW(),NOW(),NOW()," + is_billable + ")";
                                        obj.prepare();
                                        obj.execute((errorr: any, responce: any) => {
                                            if (errorr == 1) {

                                                let resData: any = data.success == true ? { status: status_code, message: status_detail, batch_id: uuid } : { status: status_code, message: status_detail }
                                                callback(1, resData);
                                            }
                                            else {
                                                callback(0, { status: 401, message: "Something went wrong with MMS insertion" })
                                            }
                                        });
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `mms_dlr` (`idaccount`,`iduser`,`status`,`from`,`to`,`tracking_id`,`status_details`) VALUES('" + idaccount + "','" + iduser + "','" + dlr_status + "','" + FROM + "','" + TO + "','" + uuid + "','" + status_detail + "')";
                                        obj1.prepare();
                                        obj1.execute((errord: any, responced: any) => {
                                            if (errord == 1) {
                                                console.log("TF mms_dlr Data Inserted Successfully!");
                                            }
                                            else {
                                                console.log("TF mms_dlr Data Not Inserted Successfully!");
                                            }
                                        });
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`status`,`reason`,`detail`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + uuid + "','2','" + restatus + "','" + data.reason + "','" + data.detail + "','" + uuid + "','" + FROM + "','" + TO + "','" + parseBody(msg_data) + "')";
                                        obj2.prepare();
                                        obj2.execute((error: any, result: any) => { });

                                    }
                                    else {
                                        callback(0, { status: 402, message: "MMS Sent Failed!" })
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: Inteliquent->sendTFMMS::", e);
                                    callback(0, { status: 403, message: "MMS Sent Failed!" })
                                }
                            }
                            else {
                                callback(0, { status: 405, message: "MMS Sent Failed!" })
                            }
                        });
                    }
                    else {
                        callback(0, { status: 504, message: "Please add funds to your account or contact support." })
                    }
                });
            }
            else {
                callback(0, { status: 502, result: "MT Rates Not Found!" })
            }
        });
    }

}