import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { Socket } from "net";
import { VoiceServer } from "../config/setting.config";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { VoiceRates } from "./common.lib"
import { voicerates } from "../server";
import { LergApi } from "./lrnApi";
import { APIBase } from "./APIBase";

const vs_server = new VoiceServer();
const prefix = vs_server.Prefix;


export class Call extends APIBase {

  constructor() {
    super();
  }

  public repTest(req: Request, res: Response, next: NextFunction) {
    let sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (sdata.FROM.length == 10) {
        if (sdata.CALLER == '' || sdata.CALLER == 'undefined' || sdata.CALLER == null) {
          sdata.CALLER = sdata.FROM
        }
        sdata.TO = sdata.CALLEE;
        let vrate: VoiceRates;
        if (voicerates.has(sessdata.authkey)) {
          let tmp = voicerates.get(sessdata.authkey);
          if (tmp !== undefined) {
            vrate = tmp;
          }
          else {
            vrate = new VoiceRates();
            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
              voicerates.set(sessdata.authkey, vrate);
            });
          }
        }
        else {
          vrate = new VoiceRates();
          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
            voicerates.set(sessdata.authkey, vrate);
          });
        }
        if (error == 1) {
          if (vrate.count() > 0) {
            let PayLoad: any = {
              TO: sdata.TO
            }
            let lerg = new LergApi("", "");
            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
              let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
              let baseapi = new APIBase();
              baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                if (lerg_info.length > 0) {
                  baseapi.DialCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {

                    if (call_result != undefined) {
                      let objv = new RawView(res);
                      objv.prepare(call_result);
                      objv.execute();
                    } else {
                      let objv = new RawView(res);
                      objv.prepare(call_err);
                      objv.execute();
                    }

                  })
                } else {
                  let objv = new RawView(res);
                  objv.prepare("Lerg Info Not Found");
                  objv.execute();
                }
              })
            })
          } else {
            let objv = new RawView(res);
            objv.prepare("Data Not Found");
            objv.execute();
          }
        } else {
          let objv = new Res406(res);
          objv.prepare("No session data there");
          objv.execute();
        }
      } else {
        let objv = new RawView(res);
        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
        objv.execute();
      }
    });
  }

  public MakeOutboundCallToNumber(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if(error==1){
        let sdata = req.body;
        let checkService = new APIBase();
        checkService.serviceActivation(req, res, sessdata, "3", (err, resp) => {
          if(resp.status==200){
            if (sdata.FROM.length == 10) {
              if (sdata.CALLER == '' || sdata.CALLER == 'undefined' || sdata.CALLER == null) {
                sdata.CALLER = sdata.FROM
              }
              sdata.TO = sdata.CALLEE;
              let vrate: VoiceRates;
              if (voicerates.has(sessdata.authkey)) {
                let tmp = voicerates.get(sessdata.authkey);
                if (tmp !== undefined) {
                  vrate = tmp;
                }
                else {
                  vrate = new VoiceRates();
                  vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                    voicerates.set(sessdata.authkey, vrate);
                  });
                }
              }
              else {
                vrate = new VoiceRates();
                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                  voicerates.set(sessdata.authkey, vrate);
                });
              }
              if (vrate.count() > 0) {
                let PayLoad: any = {
                  TO: sdata.TO
                }
                let lerg = new LergApi("", "");
                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                  let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                  let baseapi = new APIBase();
                  baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                    if (lerg_info.length > 0) {
                      baseapi.DialCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {

                        if (call_result != undefined) {
                          let objv = new RawView(res);
                          objv.prepare(call_result);
                          objv.execute();
                        } else {
                          let objv = new RawView(res);

                          objv.prepare(call_err);
                          objv.execute();
                        }

                      })
                    } 
                    else {
                      let objv = new RawView(res);
                      objv.prepare("Lerg Info Not Found");
                      objv.execute();
                    }
                  })
                })
              } 
              else {
                let objv = new RawView(res);
                objv.prepare("Data Not Found");
                objv.execute();
              }
            } 
            else {
              let objv = new RawView(res);
              objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
              objv.execute();
            }         
          }
          else{
            let objv = new RawView(res);
            objv.prepare({
              error_code: err,
              status: resp.status,
              message: resp.message.replace(/::SN::/g, "Call")
            });
            objv.execute();
          }
        }); 
      }
      else{
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }           
    });
  }

  public MakeCall(req: Request, res: Response, next: NextFunction) {
    let sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let checkService = new APIBase();
        checkService.serviceActivation(req, res, sessdata, "3", (err, resp) => {
          if(resp.status==200){
            let vrate: VoiceRates;
            if (sdata.FROM.length == 10 && sdata.TO.length == 10) {
              if (voicerates.has(sessdata.authkey)) {
                let tmp = voicerates.get(sessdata.authkey);
                if (tmp != undefined) {
                  vrate = tmp;
                }
                else {
                  vrate = new VoiceRates();
                  vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                    voicerates.set(sessdata.authkey, vrate);
                  });
                }
              }
              else {
                vrate = new VoiceRates();
                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                  voicerates.set(sessdata.authkey, vrate);
                });
              }
              if (vrate.count() > 0) {
                let lergLogin = new LergApi("", "");
                let PayLoad: any = {
                  TO: sdata.TO
                }
                let lerg = new LergApi("", "");
                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                  let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                  let baseapi = new APIBase();
                  baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                    if (lerg_info.length > 0) {
                      baseapi.makeCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                        if (call_result != undefined) {
                          let objv = new RawView(res);
                          objv.prepare(call_result);
                          objv.execute();
                        } else {
                          let objv = new RawView(res);
                          objv.prepare(call_err);
                          objv.execute();
                        }
                      })
                    } else {
                      let objv = new RawView(res);
                      objv.prepare("Lerg Info Not Found");
                      objv.execute();
                    }
                  })
                })
              } else {
                let objv = new RawView(res);
                objv.prepare("Data Not Found");
                objv.execute();
              }              
            } else {
              let objv = new RawView(res);
              objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
              objv.execute();
            }
          } 
          else{
            let objv = new RawView(res);
            objv.prepare({
              error_code: err,
              status: resp.status,
              message: resp.message.replace(/::SN::/g, "Make Call")
            });
            objv.execute();
          }
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public MakeCallviaMedia(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      let sdata = req.body;
      let checkService = new APIBase();
      checkService.serviceActivation(req, res, sessdata, "3", (err, resp) => {
        if(resp.status==200){
          if (sdata.FROM.length == 10 && sdata.TO.length == 10) {
            let vrate: VoiceRates;
            if (voicerates.has(sessdata.authkey)) {
              let tmp = voicerates.get(sessdata.authkey);
              if (tmp != undefined) {
                vrate = tmp;
              }
              else {
                vrate = new VoiceRates();
                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                  voicerates.set(sessdata.authkey, vrate);
                });
              }
            }
            else {
              vrate = new VoiceRates();
              vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                voicerates.set(sessdata.authkey, vrate);

              });
            }
            if (error == 1) {
              if (vrate.count() > 0) {
                let lergLogin = new LergApi("", "");
                let PayLoad: any = {
                  TO: sdata.TO
                }
                let lerg = new LergApi("", "");
                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                  let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                  let baseapi = new APIBase();
                  baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                    if (lerg_info.length > 0) {
                      baseapi.makeCallviaMedia(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                        if (call_result != undefined) {
                          let objv = new RawView(res);
                          objv.prepare(call_result);
                          objv.execute();
                        } else {
                          let objv = new RawView(res);
                          objv.prepare(call_err);
                          objv.execute();
                        }
                      })
                    } else {
                      let objv = new RawView(res);
                      objv.prepare("Lerg Info Not Found");
                      objv.execute();
                    }
                  })
                })
              } else {
                let objv = new RawView(res);
                objv.prepare("Data Not Found");
                objv.execute();
              }
            } else {
              let objv = new Res406(res);
              objv.prepare("No session data there");
              objv.execute();
            }
          } else {
            let objv = new RawView(res);
            objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
            objv.execute();
          }
        }
        else{
          let objv = new RawView(res);
          objv.prepare({
            error_code: err,
            status: resp.status,
            message: resp.message.replace(/::SN::/g, "Make Call Via Media")
          });
          objv.execute();
        }
      });
    });
  }

  public sendDtmf(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let digit: any;
        digit = req.body.TONE;
        let client = new Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
          console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
          client.write('auth ' + vs_server.PASS + '\n\n');
          console.log("Password : " + vs_server.PASS);
          client.write('api uuid_send_dtmf ' + req.body.UUID + " " + digit + '\n\n');
          client.on("data", (respon) => {
            let tmp = respon.toString().split("\n");
            tmp.forEach((elem: any) => {
              if (elem != undefined) {
                if (elem.length > 0) {
                  console.log(elem);
                  let t1 = elem.split("OK");
                  if (t1.length == 2) {
                    console.log(t1);
                    if (t1[0] == "+") {
                      res.status(200).send(t1[1].trim());
                      client.end();
                    }
                  }
                }
              }
            });
          });

          client.on("error", (e) => {
            console.log(e);
          })

          client.on("end", () => {

          })
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public recvDtmf(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let digit: any;
        digit = req.body.TONE;
        let client = new Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
          console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
          client.write('auth ' + vs_server.PASS + '\n\n');
          console.log("Password : " + vs_server.PASS);
          client.write('api uuid_recv_dtmf ' + req.body.UUID + " " + digit + '\n\n');
          client.on("data", (respon) => {
            let tmp = respon.toString().split("\n");
            tmp.forEach((elem: any) => {
              if (elem != undefined) {
                if (elem.length > 0) {
                  console.log(elem);
                  let t1 = elem.split("OK");
                  if (t1.length == 2) {
                    console.log(t1);
                    if (t1[0] == "+") {
                      res.status(200).send(t1[1].trim());
                      client.destroy();
                    }
                  }
                }
              }
            });
          });

          client.on("error", (e) => {
            console.log(e);
          })

          client.on("end", () => {

          })
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public ThreeWayCall(req: Request, res: Response, next: NextFunction) {
    let sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (sdata.Number.length == 10) {
        let vrate: VoiceRates;
        if (voicerates.has(sessdata.authkey)) {
          let tmp = voicerates.get(sessdata.authkey);
          if (tmp !== undefined) {
            vrate = tmp;
          }
          else {
            vrate = new VoiceRates();
            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
              voicerates.set(sessdata.authkey, vrate);
              //let objv = new Res406(res);
              //objv.prepare("No session data there");
              //objv.execute();
            });
          }
        }
        else {
          vrate = new VoiceRates();
          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
            voicerates.set(sessdata.authkey, vrate);
            //let objv = new Res406(res);
            //objv.prepare("No session data there");
            //objv.execute();
          });
        }
        if (error == 1) {
          if (vrate.count() > 0) {
            let rate = vrate.getCallRate(req.body.Number);
            let PayLoad: any = {
              TO: sdata.Number
            }
            let lerg = new LergApi("", "");
            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
              let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
              let baseapi = new APIBase();
              baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                if (lerg_info.length > 0) {
                  baseapi.ThreeWayCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                    if (call_result != undefined) {
                      let objv = new RawView(res);
                      objv.prepare(call_result);
                      objv.execute();
                    } else {
                      let objv = new RawView(res);
                      objv.prepare(call_err);
                      objv.execute();
                    }
                  })
                } else {
                  let objv = new RawView(res);
                  objv.prepare("Lerg Info Not Found");
                  objv.execute();
                }
              })
            })

          } else {
            let objv = new RawView(res);
            objv.prepare("Data Not Found");
            objv.execute();
          }
        } else {
          let objv = new Res406(res);
          objv.prepare("No session data there");
          objv.execute();
        }
      } else {
        let objv = new RawView(res);
        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
        objv.execute();
      }
    });
  }


  public Hangup(req: Request, res: Response, next: NextFunction) {
    console.log("Req==>" + JSON.stringify(req.body));
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let socketData = req.body.UUID;
        let client = new Socket();
        let state: string = "";
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
          console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
          client.write('auth ' + vs_server.PASS + '\n\n');
          console.log("Password : " + vs_server.PASS);
          console.log(socketData);
          client.write('api uuid_kill ' + socketData + '\n\n');
          res.status(200).send();
          client.on("data", (respon) => {
            console.log(respon.toString());
            let tmp = respon.toString().split("\n");
            tmp.forEach((elem: any) => {
              if (elem != undefined) {
                if (elem.length > 0) {
                  console.log(elem);
                  let t1 = elem.split("OK");
                  if (t1.length == 2) {
                    console.log(t1);
                    if (t1[0] == "+") {
                      state = "Hangup Channel";
                      client.end();
                    }
                  }
                }
              }
            });
          });

          client.on("error", (e) => {
            console.log(e);
          })
          client.on("end", () => {
            console.log(state);
            if (state.length > 0) {
              let tmp = state;
              state = "";
              res.status(200).send(tmp);
            }
          })
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public Barge(req: Request, res: Response, next: NextFunction) {
    let sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let vrate: VoiceRates;
        console.log(sessdata)
        if (sdata.Number.length == 10) {
          if (voicerates.has(sessdata.authkey)) {
            let tmp = voicerates.get(sessdata.authkey);
            if (tmp !== undefined) {
              vrate = tmp;
            }
            else {
              vrate = new VoiceRates();
              vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                voicerates.set(sessdata.authkey, vrate);
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
              });
            }
          }
          else {
            vrate = new VoiceRates();
            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
              voicerates.set(sessdata.authkey, vrate);
              let objv = new Res406(res);
              objv.prepare("No session data there");
              objv.execute();
            });
          }
          if (vrate.count() > 0) {
            let PayLoad: any = {
              TO: sdata.Number
            }
            let lerg = new LergApi("", "");
            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
              let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
              let baseapi = new APIBase();
              baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                if (lerg_info.length > 0) {
                  baseapi.Barge(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                    if (call_result != undefined) {
                      let objv = new RawView(res);
                      objv.prepare(call_result);
                      objv.execute();
                    } else {
                      let objv = new RawView(res);
                      objv.prepare(call_err);
                      objv.execute();
                    }
                  })
                } else {
                  let objv = new RawView(res);
                  objv.prepare("Lerg Info Not Found");
                  objv.execute();
                }
              })
            })
          } else {
            let objv = new RawView(res);
            objv.prepare("Data Not Found");
            objv.execute();
          }
        } else {
          let objv = new RawView(res);
          objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
          objv.execute();
        }
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public Hold(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let socketData = req.body.UUID;
        let cmd = "";
        if (req.body.Type == "Start") {
          cmd = "api uuid_hold " + socketData;
        } else if (req.body.Type == "Stop") {
          cmd = "api uuid_hold off " + socketData;
        } else {
          cmd = "api uuid_hold toggle " + socketData;
        }
        console.log("cmd==>" + cmd);
        let client = new Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
          console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
          client.write('auth ' + vs_server.PASS + '\n\n');
          console.log("Password : " + vs_server.PASS);
          client.write(cmd + '\n\n');
          client.on("data", (respon) => {
            let tmp = respon.toString().split("\n");
            tmp.forEach((elem: any) => {
              if (elem != undefined) {
                if (elem.length > 0) {
                  console.log(elem);
                  let t1 = elem.split("OK");
                  if (t1.length == 2) {
                    console.log(t1);
                    if (t1[0] == "+") {
                      res.status(200).send(t1[1].trim());
                      client.destroy();
                    }
                  }
                }
              }
            });
          });

          client.on("error", (e) => {
            console.log(e);
          })

          client.on("end", () => {

          })
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public Recording(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let vrate: VoiceRates;
        console.log(sessdata)
        if (voicerates.has(sessdata.authkey)) {
          console.log("hii");
          let tmp = voicerates.get(sessdata.authkey);
          if (tmp !== undefined) {
            vrate = tmp;
          }
          else {
            vrate = new VoiceRates();
            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
              voicerates.set(sessdata.authkey, vrate);
              //let objv = new Res406(res);
              //objv.prepare("No session data there");
              //objv.execute();
            });
          }
        }
        else {
          vrate = new VoiceRates();
          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
            voicerates.set(sessdata.authkey, vrate);
            //let objv = new Res406(res);
            //objv.prepare("No session data there");
            //objv.execute();
          });
        }
        let cmd = "";
        console.log("vrate", vrate);
        let rate = vrate.RecordRate("true");
        console.log("Rate", rate);
        if (req.body.Recording == "Start") {
          cmd = "api uuid_record " + req.body.UUID + " start /usr/local/freeswitch/recording/" + req.body.UUID;
        } else {
          cmd = "api uuid_record " + req.body.UUID + " stop /usr/local/freeswitch/recording/" + req.body.UUID;
        }
        console.log("Req==>" + cmd);
        let client = new Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
          console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
          client.write('auth ' + vs_server.PASS + '\n\n');
          client.write(cmd + '\n\n');
          client.on("data", (respon) => {
            let tmp = respon.toString().split("\n");
            tmp.forEach((elem: any) => {
              if (elem != undefined) {
                if (elem.length > 0) {
                  console.log("Ele", elem);
                  let t1 = elem.split("OK");
                  if (t1.length == 2) {
                    console.log("T1", t1);
                    if (t1[0] == "+") {
                      console.log("api uuid_setvar " + req.body.UUID + " rec_rate " + rate + '\n\n');
                      client.write("api uuid_setvar " + req.body.UUID + " rec_rate " + rate + '\n\n');
                      res.status(200).send(t1[1].trim());
                      client.destroy();
                    }
                  }
                }
              }
            });
          });

          client.on("error", (e) => {
            console.log(e);
          })

          client.on("end", () => {

          })
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  public CallTransfer(req: Request, res: Response, next: NextFunction) {
    let sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let vrate: VoiceRates;
        if (sdata.Number.length == 10) {
          if (voicerates.has(sessdata.authkey)) {
            let tmp = voicerates.get(sessdata.authkey);
            if (tmp !== undefined) {
              vrate = tmp;
            }
            else {
              vrate = new VoiceRates();
              vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                voicerates.set(sessdata.authkey, vrate);
                // let objv = new Res406(res);
                // objv.prepare("No session data there");
                // objv.execute();
              });
            }
          }
          else {
            vrate = new VoiceRates();
            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
              // voicerates.set(sessdata.authkey, vrate);
              // let objv = new Res406(res);
              // objv.prepare("No session data there");
              // objv.execute();
            });
          }
          if (vrate.count() > 0) {
            let rate = vrate.getCallRate(req.body.Number);
            let PayLoad: any = {
              TO: sdata.Number
            }
            let lerg = new LergApi("", "");
            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
              let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
              let baseapi = new APIBase();
              baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                if (lerg_info.length > 0) {
                  baseapi.CallTransfer(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                    if (call_result != undefined) {
                      let objv = new RawView(res);
                      objv.prepare(call_result);
                      objv.execute();
                    } else {
                      let objv = new RawView(res);
                      objv.prepare(call_err);
                      objv.execute();
                    }
                  })
                } else {
                  let objv = new RawView(res);
                  objv.prepare("Lerg Info Not Found");
                  objv.execute();
                }
              })
            })
          } else {
            let objv = new RawView(res);
            objv.prepare("Data Not Found");
            objv.execute();
          }
        } else {
          let objv = new RawView(res);
          objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
          objv.execute();
        }
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }

  // public blindTransfer(req: Request, res: Response, next: NextFunction) {
  //   let session = new SessionManagment(req, res, next);
  //   session.GetSession((error: any, sessdata: any) => {
  //     if (error == 1) {
  //       let client = new Socket();
  //       client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
  //         client.write('auth ' + vs_server.PASS + '\n\n');
  //         console.log("api uuid_transfer " + req.body.UUID.trim() + " -bleg 88791" + req.body.NUMBER.trim() + " XML default \n\n");
  //         client.write("api uuid_transfer " + req.body.UUID.trim() + " -bleg 88791" + req.body.NUMBER.trim() + " XML default \n\n");
  //         client.on("data", (respon) => {
  //           let tmp = respon.toString().split("\n");
  //           tmp.forEach((elem: any) => {
  //             if (elem != undefined) {
  //               if (elem.length > 0) {
  //                 console.log(elem);
  //                 let t1 = elem.split("OK");
  //                 if (t1.length == 2) {
  //                   console.log(t1);
  //                   if (t1[0] == "+") {
  //                     res.status(200).send({ message: "Call Connected Successfully", uuid: t1[1].trim() });
  //                     client.destroy();
  //                   }
  //                 }
  //               }
  //             }
  //           });
  //         });

  //         client.on("error", (e) => {
  //           console.log(e);
  //         })

  //         client.on("end", () => {

  //         })
  //       });
  //     } else {
  //       let objv = new Res406(res);
  //       objv.prepare("No session data there");
  //       objv.execute();
  //     }
  //   });
  // }

  public getChannelList(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT *  FROM `channels` WHERE `accountcode`='" + sessdata.idaccount + "'";
        obj.prepare();
        obj.execute((err: any, resp: any) => {
          if (resp.length > 0) {
            let objv = new RawView(res);
            objv.prepare({ message: "Channels List", data: resp });
            objv.execute();
          } else {
            let objv = new RawView(res);
            objv.prepare("Data Not Found");
            objv.execute();
          }
        });
      } else {
        let objv = new Res406(res);
        objv.prepare("No session data there");
        objv.execute();
      }
    });
  }
}