import { Request, Response, NextFunction } from "express";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { Res406 } from "../lib/view/406";
import { Res403 } from "../lib/view/403";
import { modAgent } from "../config/module.config";
import { ModelLogin } from "../lib/model/ModelLogin";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { CSPApiConfig } from "../config/setting.config";
import { NewCampaign } from "./newcampaign.class";
import { VoiceRates } from "./common.lib";
import { Number } from "./numberApi";
import { APIBase } from "./APIBase";
import { setToZero } from "./markError";

const request = require("request");


const Str = require('@supercharge/strings');

const makeNumber = (length: number) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}
const makeChar = (length: number) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const makeRanChar = (length: number) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const generatePassword = () => {
    let result: any = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
}

export class SwaggerApi {
    constructor() {
    }

    public BuyTollfree(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    const sdata = req.query
                    if (sdata.Quantity) {
                        let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT e.idendpoint, e.connection_key, i.inbound_key, o.outbound_key FROM `endpoint` e JOIN `inbound` i ON e.idendpoint = i.idendpoint JOIN `outbound` o ON e.idendpoint = o.idendpoint WHERE e.`isDefault`='true' AND e.`iduser`= '" + sessdata.iduser + "'";
                        obj0.prepare();
                        obj0.execute((connErr: any, connRes: any) => {
                            if(connErr == 1){
                                let connKey : any = connRes.length > 0 ? connRes[0].connection_key : ''; 
                                let inbounKey : any = connRes.length > 0 ? connRes[0].inbound_key : ''; 
                                let outboundKey : any = connRes.length > 0 ? connRes[0].outbound_key : ''; 

                                let GOpayload: any = {
                                    name: "SOD" + String(new Date().getTime()),
                                    total_dids: sdata.Quantity,
                                    numbers: '',
                                    routing: connKey,
                                    in_routing: inbounKey,
                                    out_routing: outboundKey,
                                    campaign: '',
                                    sessdata : sessdata
                                }                                
                                let swag = new SwaggerApi();
                                swag.CreateGroupOrder(req, res, GOpayload, (error, response) => {
                                    if (error == 1) {
                                            let groupID = response.data.id_grouporder;
                                            let numberapi = new Number();
                                            numberapi.BuyTollfreeNumber(req, res, groupID, err => {
                                                if (err == 0) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: "200", message: "Tollfree Order Created Successfully!" });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                                                    objv.execute();
                                                }
                                            });
                                        
                                    } else {
                                        let objv = new RawView(res)
                                        objv.prepare({ status: 201, message: "Group Order is not Created!" })
                                        objv.execute();
                                    }
                                });
                            }
                            else{
                                let objv = new RawView(res);
                                objv.prepare({status: 502, message: "Something Went Wrong With Connection!" });
                                objv.execute();
                            }
                        });  
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 507, message: "Quantity is required" });
                        objv.execute();
                    }
                } else {
                    let objv = new RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public CreateGroupOrder(req: Request, res: Response, GOpayload: any, callback: (err: any, data: any) => void) {
        let checkService = new APIBase();
        checkService.serviceActivation(req, res, GOpayload.sessdata, "5", (err, resp) => {
            if (resp.status == 200) {        
                let obj = new ModelRawNonQuery(req, res);
                let totalDID: any = GOpayload.total_dids
                let process_dids: number = 0;
                obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + GOpayload.sessdata.iduser + ", idaccount=" + GOpayload.sessdata.idaccount + ", name='" + GOpayload.name + "', total_dids=" + setToZero(totalDID) + ", process_dids=" + setToZero(process_dids) + ", numbers='" + GOpayload.numbers + "', routing='" + GOpayload.routing + "', in_routing='" + GOpayload.in_routing + "', out_routing='" + GOpayload.out_routing + "', campaign='" + GOpayload.campaign + "';"

                obj.prepare();
                obj.execute((error: any, result: any) => {
                    callback(1, {
                        status: 202,
                        message: "Group successfully created.",
                        data: {
                            id_grouporder: result.insertId
                        }
                    });
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({
                    error: 1,
                    status: resp.status,
                    message: resp.message.replace(/::SN::/g, "DID Buy")
                });
                objv.execute();
            }
        });
    }

}

