import e, { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
// import { AppRoute } from "../lib/AppRoute";
import { ModelPdfUpload } from "../lib/model/ModelPdfUpload";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { SubscriptionManagement } from "./SubscriptionManagement";
const Str = require('@supercharge/strings');
// var nodemailer = require("nodemailer");
const jwt = require('jsonwebtoken');
const request = require("request");

import { sessiondata, login_logout, invalidsessdata } from '../server';
// import { sessiondata, login_logout, setservicedata, invalidsessdata } from '../server';
// import md5 from "md5";
// import { Connection } from './connections'
import * as bcrypt from 'bcrypt'
import { EmailSettingForSupport, LinkVerify, Profile, SMTPDetails, TemplateURl, UploadDirectory, Notes } from "../config/setting.config";
import { parseBody, ipAddressAndBrowser, setToZero, setEnum } from "./markError";
import { APIBase } from "./APIBase";
import { AccountDelete } from "./AccountDelete";

let URLlink = new LinkVerify();
let profile_pic = new Profile();
const emailSetting = new EmailSettingForSupport();
const supportEmail = emailSetting.EMAIL;
const templateURL = new TemplateURl();
const FromSmtpMail = new SMTPDetails();
const FromEmail = FromSmtpMail.from;
const uploadDirectory = new UploadDirectory();
const note = new Notes();

const makeNumber = (length: number) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}
const makeChar = (length: number) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const makeRanChar = (length: number) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const generatePassword = () => {
    let result: any = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
}

const MIME_TYPE_MAPs: any = {
    'text/csv': 'csv',//re
    'audio/3gpp': '3ga',
    'video/3gpp': '3gp',
    'text/plain': 'txt',
    'audio/amr': 'amr',
    'video/x-msvideo': 'avi',
    'image/bmp': 'bmp',
    'application/x-bzip2': 'bz2',
    'application/calendar': 'cal',
    'text/css': 'css',
    'image/dib': 'dib',
    'audio/flac': 'flac',
    'video/x-flv': 'flv',
    'image/gif': 'gif',
    'application/x-gzip': 'gz',
    'image/x-icon': 'ico',
    'image/jpeg': 'jpeg',//re
    'image/jpg': 'jpg',//re
    'application/javascript': 'js',
    'application/json': 'json',
    'audio/mpeg': 'm1a',
    'video/m1v': 'm1v',
    'audio/m2a': 'm2a',
    'audio/x-m4a': 'm4a',
    'audio/m4b': 'm4b',
    'audio/x-mp3': 'mp3',//re
    'video/mp4': 'mp4',//re
    'audio/x-ms-wma': 'mpa',
    'video/mpeg': 'mpeg',
    'video/mpg': 'mpg',
    'application/pdf': 'pdf',//re
    'image/pjpeg': 'pjpeg',
    'image/png': 'png',//jj
    'video/quicktime': 'qt',
    'text/rtf': 'rtf',
    'audio/x-wav': 'wav',
    'video/webm': 'webm',
    'image/webp': 'webp',
    'video/x-ms-wmv': 'wmv',
    'application/xml': 'xml',
    'application/zip': 'zip'

};

export class UserManagement {
    constructor() {
        // super();
    }

    makeNumber(len: any) {
        var result = '';
        var characters = '09876543212346543098765123456789';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
    }

    makeChar(len: any) {
        var result = '';
        var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
    }

    makeRanChar(len: any) {
        var result = '';
        var characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }

        return result;
    }

    /**
     * To authenticate user with TimeZone
     */

    getMorphingSession(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let pData: any = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, kyc_verify_status,`isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time`,`country` FROM `session` WHERE `authkey` = '" + pData.key + "'";
                obj.prepare();
                obj.execute((error: any, resSession: any) => {
                    let data: any = resSession[0];
                    let objup = new ModelRawQuery(req, res);
                    objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + resSession[0].iduser + "'";
                    objup.prepare();
                    objup.execute((__errorE: any, emailE: any) => {
                        let obj7 = new ModelRawQuery(req, res);
                        obj7.qrysql = "SELECT country FROM billing_address WHERE idaccount='" + resSession[0].idaccount + "'";
                        obj7.prepare();
                        obj7.execute((error: any, result1: any) => {
                            let addresdata = result1[0]?.country !== '' && result1[0]?.country !== undefined && result1[0]?.country !== 'undefined' ? result1[0].country : '';
                            let temp2: string = "{\"country\": \"" + addresdata + "\"}";
                            let country = JSON.parse(temp2);
                            let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                            let emType = JSON.parse(tmp);
                            let result: any = Object.assign(data, emType, country);
                            if (error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Session Data Fetch Successfully!", status: 200, data: [result] });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong to Fetch Session", status: 502, result: result });
                                objv.execute();
                            }
                        });
                    });
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getLogin(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.body.data;
        if (sdata && sdata !== 'undefined' && sdata !== undefined && sdata !== '') {
            let pass1: any = sdata.password;
            let obj: any = new ModelRawQuery(req, res)
            let iQry: string = "SELECT us.iduser, us.idaccount, us.username, us.password, us.type, us.default, us.idtariff, us.isEmailVerify, us.isMobileVerify, us.isPlan, us.isAddress,us.isCard,us.newUser_status, '-08:00' client_time, IF(us.is_deleted = 0, 9, us.is_deleted) acc_status, us.kyc_verify_status, us.resetPassword FROM user us\n"
            iQry += "WHERE us.`username`='" + parseBody(sdata.username) + "';"
            obj.qrysql = iQry;
            if (obj.prepare()) {
                obj.execute((error: any, result: any) => {
                    if (result.length > 0) {
                        let objup = new ModelRawQuery(req, res);
                        objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + result[0].iduser + "'";
                        objup.prepare();
                        objup.execute((__errorE: any, emailE: any) => {
                            let emails = emailE[0].email !== '' && emailE[0].email !== undefined && emailE[0].email !== 'undefined' ? emailE[0].email : ''
                            if ((bcrypt.compareSync(pass1, result[0].password))) {
                                if (result[0].type == 1 || result[0].type == 2 || result[0].type == 22 || result[0].type == 201 || result[0].type == 202 || result[0].type == 203 || result[0].type == 231 || result[0].type == 232) {
                                    let data: any = result[0];
                                    delete data.password;
                                    let tmp: string = "{\"sessionType\": \"" + sdata.sessionType + "\"}";
                                    let loginType = JSON.parse(tmp);
                                    let Result: any = Object.assign(data, loginType);
                                    if ((data.acc_status == 9) || (sdata.typeCheck && sdata.typeCheck == "admin_checking")) {
                                        delete data.acc_status
                                        let session = new SessionManagment(req, res, next);
                                        session.SetSession(Result, (error: any, sessdata: any) => {
                                            // To set User Login Activity
                                            let sysInfo = ipAddressAndBrowser(req);
                                            let objh = new ModelRawNonQuery(req, res);
                                            objh.nonqrysql = "INSERT INTO `user_login_history`(`iduser`, `idaccount`, `type`, `token`, `ipaddress`, `browser`, `login_time`, `login_type`) VALUES ('" + result[0].iduser + "','" + result[0].idaccount + "','" + result[0].type + "', '" + Result.authkey + "', '" + sysInfo.ipAddress[0] + "', '" + sysInfo.browserName + "', NOW(),'login')";
                                            objh.prepare();
                                            objh.execute((error: any, data: any) => {

                                            });
                                            // To Merge
                                            let obj1 = new ModelRawQuery(req, res);
                                            obj1.qrysql = "SELECT country FROM billing_address WHERE idaccount='" + result[0].idaccount + "'";
                                            obj1.prepare()
                                            obj1.execute((error: any, dataaddres: any) => {
                                                let addresdata = sessdata.type !==1 && dataaddres.length > 0 && dataaddres[0].country !== '' && dataaddres[0].country !== undefined  && dataaddres[0].country !== null && dataaddres[0].country !== 'undefined' && dataaddres[0].country !== 'null' ? dataaddres[0].country : '';
                                                let temp2: string = "{\"country\": \"" + addresdata + "\"}";
                                                let addType = JSON.parse(temp2);
                                                let tmp: string = "{\"email\": \"" + emails + "\"}";
                                                let emType = JSON.parse(tmp);
                                                let data1: any = Object.assign(data, emType, addType);
                                                let objv = new RawView(res);
                                                objv.prepare(data1);
                                                objv.execute();
                                            });
                                        });
                                    }
                                    else {
                                        let errMsg: string = data.acc_status == 1 ? "Your account deletion in under process!" : "Your account has been deleted, If you want to restore kindly contact with customer support!"
                                        let errCode = data.acc_status == 1 ? "DelInProcess" : "Deleted";
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: errMsg, error: errCode
                                        });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 401, message: "You are not Authorized for this Panel!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    status: 404, message: "Invalid Password, Kindly check again!"
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 404, message: "Invalid Username, Kindly check again!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({
                    status: 422, message: "Few parameter are missing in request!"
                });
                objv.execute();
            }
        } else {
            let objv = new RawView(res);
            objv.prepare({ status: 422, message: "Few parameter are missing in request!" });
            objv.execute();
        }
    }
    getMorphingLogin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2) {
                    let sdata: any = req.body.data;
                    if (sdata && sdata !== 'undefined' && sdata !== undefined && sdata !== '') {
                        let obj: any = new ModelRawQuery(req, res)
                        let iQry: string = "SELECT us.iduser, us.idaccount, us.username, us.type, us.default, us.idtariff, us.isEmailVerify, us.isMobileVerify, us.isPlan, us.isAddress,us.isCard,us.newUser_status, '-08:00' client_time, IF(us.is_deleted = 0, 9, us.is_deleted) acc_status, us.kyc_verify_status, us.resetPassword FROM user us\n"
                        iQry += "WHERE us.`username`='" + parseBody(sdata.username) + "';"
                        obj.qrysql = iQry;
                        if (obj.prepare()) {
                            obj.execute((error: any, result: any) => {
                                if (result.length > 0) {
                                    let objup = new ModelRawQuery(req, res);
                                    objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + result[0].iduser + "'";
                                    objup.prepare();
                                    objup.execute((__errorE: any, emailE: any) => {
                                        let objup7 = new ModelRawQuery(req, res);
                                        objup7.qrysql = "SELECT country FROM `billing_address` WHERE `idaccount`='" + result[0].idaccount + "'";
                                        objup7.prepare();
                                        objup7.execute((__errorEE: any, result7: any) => {
                                            let emails = emailE.length > 0 && emailE[0].email ? emailE[0].email : '';
                                            let country = result7.length > 0 && result7[0].country ? result7[0].country.trim() : '';
                                            if (result[0].type == 1 || result[0].type == 2 || result[0].type == 22 || result[0].type == 201 || result[0].type == 202 || result[0].type == 203 || result[0].type == 231 || result[0].type == 232) {  
                                                let data: any = result[0];
                                                let tmp: string = "{\"sessionType\": \"" + sdata.sessionType + "\"}";
                                                let loginType = JSON.parse(tmp);
                                                let Result: any = Object.assign(data, loginType);
                                                if ((data.acc_status == 9) || (sdata.typeCheck && sdata.typeCheck == "admin_checking")) {
                                                    delete data.acc_status
                                                    let session = new SessionManagment(req, res, next);
                                                    session.SetSession(Result, (error: any, sessdata: any) => {
                                                        // To set User Login Activity
                                                        let sysInfo = ipAddressAndBrowser(req);
                                                        let objh = new ModelRawNonQuery(req, res);
                                                        objh.nonqrysql = "INSERT INTO `user_login_history`(`iduser`, `idaccount`, `type`, `token`, `ipaddress`, `browser`, `login_time`, `login_type`) VALUES ('" + result[0].iduser + "','" + result[0].idaccount + "','" + result[0].type + "', '" + Result.authkey + "', '" + sysInfo.ipAddress[0] + "', '" + sysInfo.browserName + "', NOW(),'login')";
                                                        objh.prepare();
                                                        objh.execute((error: any, data: any) => { });
                                                        // To Merge
                                                        let tmp: string = "{\"email\": \"" + emails + "\"}";
                                                        let tmpcountry: string = "{\"country\": \"" + country + "\"}";
                                                        let emType = JSON.parse(tmp);
                                                        let tmpcountryType = JSON.parse(tmpcountry);
                                                        let data1: any = Object.assign(data, emType, tmpcountryType);
                                                        let objv = new RawView(res);
                                                        objv.prepare(data1);
                                                        objv.execute();
                                                    });
                                                }
                                                else {
                                                    let errMsg: string = data.acc_status == 1 ? "Your account deletion in under process!" : "Your account has been deleted, If you want to restore kindly contact with customer support!"
                                                    let errCode = data.acc_status == 1 ? "DelInProcess" : "Deleted";
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        message: errMsg, error: errCode
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 401, message: "You are not Authorized for this Panel!" });
                                                objv.execute();
                                            }
                                        });

                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 404, message: "Invalid Username, Kindly check again!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 422, message: "Few parameter are missing in request!"
                            });
                            objv.execute();
                        }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 422, message: "Few parameter are missing in request!" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not Authorized!", status: 403 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /**
     * To save the system timezone into user's profile
     */
    SaveSysTZ(req: Request, res: Response, next: NextFunction) {
        let sdata: any = null
        try {
            sdata = JSON.parse(req.body.data);
        } catch (e) {
            console.log("Error :: SaveSysTZ::", e);
            sdata = req.body.data;
        }

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj: any = new ModelRawNonQuery(req, res)
                let objr: any = new ModelRawQuery(req, res)
                let objv: any = new RawView(res)

                objr.qrysql = "SELECT id FROM `tbl_timezones` WHERE utc='" + sdata.utc + "' AND tzCode='" + sdata.tzCode + "';"
                objr.prepare()
                objr.execute((error: any, result: any) => {
                    if (error == 1) {
                        let id_tz: number = result.length > 0 ? result[0].id : 0
                        obj.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(" + id_tz + ", " + sessdata.iduser + ");"
                        obj.prepare()
                        obj.execute((error: any, result: any) => {
                            if (error == 1) {
                                /**
                                 * It will update the current user's
                                 * session table + session data
                                 */
                                obj.nonqrysql = "UPDATE `session` SET `client_time`='" + sdata.utc + "' WHERE `authkey`='" + sessdata.authkey + "';"
                                obj.prepare()
                                obj.execute((error: any, result2: any) => {
                                    sessdata.client_time = sdata.utc
                                    sessiondata.set(sessdata.authkey, sessdata)
                                })
                            }
                            else {
                                objv.prepare({
                                    error: 1,
                                    message: "Something went wrong!"
                                })
                                objv.execute()
                            }
                        })
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something went wrong!"
                        })
                        objv.execute()
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    VerifyUrl(req: Request, res: Response, next: NextFunction) {
        let gquery = req.query;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `url`  FROM `signup_referral_link` WHERE `url` = '" + gquery.type + "'";
        obj.prepare();
        obj.execute((_error: any, getUrl: any) => {
            if (_error == 1) {
                if (getUrl.length > 0) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "URL Matched Successfully!", status: 200 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "This Link has been expired!", status: 404 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Somthing went wrong with verifying url!", status: 502 });
                objv.execute();
            }

        });
    }

    signUp(req: Request, res: Response, next: NextFunction) {
        // const ipAddress = req.socket.remoteAddress;
        let sysInfo = ipAddressAndBrowser(req);
        let sdata = req.body.data;
        let data = req.query;
        let reseller_id: any;
        let signup_link_id: any;
        let url: any = data.type;
        let signUpLinkUrl: any = '';
        let filePath: any = URLlink.SIGNALHOST;
        let url1 = url.split('/signup')[1];
        let url2 = url1.split('url=')[1];
        if (url2 == undefined) {
            reseller_id = null;
            signup_link_id = null;
        }
        else {
            let url4 = url.split(filePath + '/#/signup?url=')[1];
            let decodeUrl = Buffer.from(url4, "base64").toString("utf8").replace('_', '=').replace('_', '=');
            let user_id = decodeUrl.split('iduser=')[1];
            reseller_id = user_id.split('&idtariff')[0]
            signup_link_id = decodeUrl.split('&ukey=')[1];
            signUpLinkUrl = signup_link_id.replace(/[^A-Za-z:0-9]/g, "");
        }

        let secret = Str.random(15);
        let validationKey = jwt.sign({
            exp: Math.floor(Date.now() / 1000) + (60 * 60),
            data: sdata.email + ":" + sdata.password
        }, secret);
        var isPlan: Boolean;
        var tariff: any;
        if (sdata.tariff1 == -1 || sdata.tariff1 == 0) {
            isPlan = false;
            tariff = '-1';
        }
        else {
            isPlan = true;
            tariff = sdata.tariff1;
        } if (sdata.imgUrl) {
            sdata.imgUrl = sdata.imgUrl;
        }
        else {
            sdata.imgUrl = "https://portal.signalmash.com/assets/img/icon.png";
        }
        let ustatus: any = sdata.status ? true : false;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `email` = '" + sdata.email + "' OR `first_name` = '" + parseBody(sdata.firstName).trim() + "' OR `last_name` = '" + parseBody(sdata.lastName).trim() + "' OR `domain_name` = '" + sdata.email.split('@')[1] + "'";
        obj.prepare();
        obj.execute((_errDomainBlk: any, getDomainBlock: any) => {
            if (_errDomainBlk == 1 && getDomainBlock.length > 0) {

                let errMsg = '';
                if (getDomainBlock[0].email == sdata.email)
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].domain_name == sdata.email.split('@')[1])
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].first_name == sdata.firstName)
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].last_name == sdata.lastName)
                    errMsg = "Invalid Account Registration!";
                else if (getDomainBlock[0].ipAddress == sdata.ipAddress)
                    errMsg = "Invalid Account Registration!";
                else
                    errMsg = "You Can't Register With Invalid Details!";

                let objv = new RawView(res);
                objv.prepare({
                    message: errMsg,
                    status: 501
                });
                objv.execute();
            }
            else {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE email = '" + sdata.email + "' OR username = '" + sdata.email + "'";
                obj.prepare();
                obj.execute((_error: any, getEmail: any) => {
                    if (_error == 1) {
                        if (getEmail.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Email Or Username Already Exists!",
                                status: 404
                            });
                            objv.execute();
                        }
                        else {
                            let objp = new ModelRawQuery(req, res);
                            let Qry: any = '';
                            if (reseller_id) {
                                Qry = "SELECT `idservice` FROM `reseller` WHERE iduser=" + reseller_id + "";
                            }
                            else {
                                Qry = "SELECT `idservice` FROM `service` WHERE iduser=1 AND `is_default`='true'";
                            }
                            objp.qrysql = Qry;
                            objp.prepare();
                            objp.execute((errservp: any, _resp: any) => {
                                let service_id = _resp[0].idservice ? _resp[0].idservice : 0;
                                //hash password 
                                let password1 = bcrypt.hashSync(sdata.password, 10)
                                let obj2 = new ModelRawNonQuery(req, res);

                                obj2.nonqrysql = "CALL AddUser(-1, -1, '" + sdata.email + "','" + parseBody(password1) + "','2','" + parseBody(sdata.firstName).trim() + "','" + parseBody(sdata.lastName).trim() + "','" + sdata.email + "',' ','" + sdata.imgUrl + "','1', " + setToZero(tariff) + ", " + setToZero(sdata.tariff2) + ", '" + ustatus + "', " + setToZero(service_id) + ", 0)";
                                obj2.prepare();
                                obj2.execute((__error: any, __res: any) => {
                                    let iduser = __res[0];
                                    if (__error == 1) {
                                        const numeric = '0123456789';
                                        let popin = '';
                                        for (let i = 0; i < 4; i++) {
                                            popin += numeric[Math.floor(Math.random() * numeric.length)];
                                        }
                                        popin = popin.split('').sort(() => Math.random() - 0.5).join('');
                                        // To Update User
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `user` SET `trust_score`='1',`validationKey`='" + validationKey + "', `secret`='" + secret + "', `isPlan`='" + isPlan + "', `idtariff`=" + setToZero(tariff) + ",`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`ext_name`='" + parseBody(sdata.password) + "',`resetPassword`='1',`reseller_iduser`=" + setToZero(reseller_id) + ",`signup_link_id`='" + signUpLinkUrl + "',`newUser_status`='1',`email_verification_date`=NOW() WHERE `iduser`=" + iduser[0].userid + "";
                                        obj3.prepare();
                                        obj3.execute((_err: any, __result: any) => {
                                            if (_err == 1) {
                                                console.log("User Updated Successfully!");
                                            }
                                            else {
                                                console.log("Error With Update User!");
                                            }
                                        });
                                        // To Update Account
                                        let objA = new ModelRawNonQuery(req, res);
                                        objA.nonqrysql = "UPDATE `account` SET `san`=(100000000 + " + iduser[0].account + "),`portoutpin`='" + popin + "' WHERE `idaccount`=" + iduser[0].account + "";
                                        objA.prepare();
                                        objA.execute((_errAccount: any, __resultAccount: any) => {
                                            if (_errAccount == 1) {
                                                console.log("San Number Updated.");
                                            }
                                            else {
                                                console.log("Error With SAN Number!");
                                            }
                                        });

                                        // To Insert Account owner category 
                                        let obj5 = new ModelRawNonQuery(req, res);
                                        obj5.nonqrysql = "INSERT INTO `notification_subscriber_email`(`idaccount`,`iduser`,`nec_id`,`email`) VALUES (" + iduser[0].account + "," + iduser[0].userid + ",5,'" + sdata.email + "')";
                                        obj5.prepare();
                                        obj5.execute((_err: any, __result: any) => {
                                            if (_err == 1) {
                                                console.log("Email Inserted Successfully!");
                                            }
                                            else {
                                                console.log("Error With insert Email!");
                                            }
                                        });

                                        // To Insert Account Services 
                                        const um = new UserManagement();
                                        um.accountServices(req, res, iduser[0].account, (errorr, resp) => {
                                            if (resp.status == 200) {
                                                console.log("Services Inserted Successfully.");
                                            }
                                            else {
                                                console.log("Something went wrong in account service insertion!");
                                            }
                                        });

                                        // To save search api_rate
                                        let data: any = { iduser: iduser[0].userid, idaccount: iduser[0].account, req_type: 1, type: 2 };
                                        um.saveApiRate(req, res, data, (errorr, resp) => {
                                        });

                                        // To Create Connection
                                        const connection_key = Str.random(30);
                                        const randDigit = connection_key.slice(4, 12);
                                        var rdata: any = [];
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.filter = null;
                                        const val = Math.floor(1000 + Math.random() * 9000);
                                        let username = Math.random().toString(36).substr(2, 11);
                                        let password = generatePassword();
                                        const inbound_key = Str.random(30);
                                        const outbound_key = Str.random(30);
                                        const val1 = Math.floor(1000 + Math.random() * 9000);
                                        const connName = parseBody(sdata.firstName).trim() + val1;
                                        obj2.qrysql = "CALL addconnection(" + iduser[0].account + ", " + iduser[0].userid + ", '" + parseBody(connName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                        obj2.prepare();
                                        obj2.execute((__error: any, allcamp: any) => {
                                            if (__error == 1) {
                                                console.log("Connection Created Successfully.");
                                            }
                                            else {
                                                console.log("Registered Successfully! But Default Connection Not Created!");
                                            }
                                        });
                                        // To Update Billing Address
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`,`customerType`, `businessName`, `ein`, `website`, `title`, `groupExmpt_number`) VALUES ('" + iduser[0].account + "', '" + parseBody(sdata.first_name).trim() + "', '" + parseBody(sdata.last_name).trim() + "', '" + sdata.contact_number + "', '" + sdata.email + "', '" + parseBody(sdata.address1) + "', '" + parseBody(sdata.address2) + "', '" + parseBody(sdata.city) + "', '" + parseBody(sdata.state) + "', '" + parseBody(sdata.postal_code) + "', '" + sdata.country + "', '" + sdata.customerType + "', '" + parseBody(sdata.businessName) + "', '" + parseBody(sdata.ein) + "', '" + parseBody(sdata.website) + "', '" + parseBody(sdata.title) + "', " + setToZero(sdata.groupExmpt_number) + ")";
                                        obj.prepare();
                                        obj.execute((_error: any, data: any) => {
                                            if (__error == 1) {
                                                console.log("Billing Address Added Successfully.");
                                            }
                                            else {
                                                console.log("Billing Address Not Added!");
                                            }
                                        });


                                        // To Update Timezone
                                        let objTime = new ModelRawNonQuery(req, res);
                                        objTime.nonqrysql = "INSERT INTO `tbl_timezone_config` SET `id_timezone`=16, id_user=" + iduser[0].userid + "";
                                        objTime.prepare();
                                        objTime.execute((errTime: any, sTime: any) => {
                                            if (errTime == 1) {
                                                console.log("Time Zone Updated!");
                                            }
                                            else {
                                                console.log("Registered Successfully! But Default Time Zone has error!");
                                            }
                                        });
                                        // To Send Mail To Support
                                        let objsup = new ModelRawQuery(req, res);
                                        objsup.qrysql = "SELECT `subject`,`template`,`cc`,`bcc` FROM `email_template` WHERE type='signup_notification_to_support'";
                                        objsup.prepare();
                                        objsup.execute((emlErr: any, emlRes: any) => {
                                            if (emlErr == 1) {
                                                if (emlRes.length > 0) {
                                                    let objsu = new ModelRawQuery(req, res);
                                                    objsu.qrysql = "SELECT rp.firstname, rp.lastname, r.organization_name FROM reseller_profile rp JOIN reseller r ON rp.iduser = r.iduser WHERE rp.iduser = '" + reseller_id + "';";
                                                    objsu.prepare();
                                                    objsu.execute((err: any, resp: any) => {
                                                        let tmpDataSup = emlRes[0].template;
                                                        let san = Math.floor(Math.floor(100000000) + Math.floor(iduser[0].account));
                                                        tmpDataSup = tmpDataSup.replace(/{SAN_NUMBER}/g, san);
                                                        tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, sdata.firstName);
                                                        tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, sdata.lastName);
                                                        tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, sdata.email);
                                                        if (reseller_id) {
                                                            if (err == 1) {
                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, 'Reseller Organization');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, resp[0].organization_name);
                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, 'Reseller Contact');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, resp[0].firstname);
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, resp[0].lastname);
                                                                tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, 'Registration Link Name');
                                                                tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, signUpLinkUrl);
                                                            }
                                                            else {
                                                                console.log("Data fetching error for reselelr")
                                                            }
                                                        } else {
                                                            tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, '');
                                                            tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, '');
                                                            tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, '');
                                                            tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, '');
                                                            tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, '');
                                                            tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, '');
                                                            tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, '');
                                                        }

                                                        let obj10 = new ModelRawNonQuery(req, res);
                                                        // obj10.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + iduser[0].userid + "','" + iduser[0].account + "','" + FromEmail + "','" + supportEmail + "', '" + parseBody(emlRes[0].subject) + "','New User Signup', '" + parseBody(tmpDataSup) + "','New User Signup','1')";

                                                        const Spmail = supportEmail.split(",");
                                                        let qry = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES";
                                                        for (let i = 0; i < Spmail.length; i++) {
                                                            let entry = Spmail[i];
                                                            qry += "(" + iduser[0].userid + "," + iduser[0].account + ",'" + FromEmail + "','" + entry + "', '" + parseBody(emlRes[0].subject) + "','New User Signup', '" + parseBody(tmpDataSup) + "','New User Signup','1','" + emlRes[0].cc + "','" + emlRes[0].bcc + "'),";
                                                        }
                                                        obj10.nonqrysql = qry.slice(0, -1)

                                                        obj10.prepare();
                                                        obj10.execute((_err: any, __result: any) => {
                                                            if (_err == 1) {
                                                                console.log("Mail successfully sent to support.")
                                                            }
                                                            else {
                                                                console.log("Mail not sent to support.");
                                                            }
                                                        });
                                                    })
                                                }
                                                else {
                                                    console.log("No Email Template Available For Support Notification.");
                                                }
                                            }
                                            else {
                                                console.log("Something Went Wrong With Get Email Template.");
                                            }
                                        });

                                        let obj4 = new ModelRawQuery(req, res);
                                        obj4.qrysql = "SELECT body, otp_digit, tmp_type  FROM `2fa_template` WHERE iduser=1 AND tmp_type='sms' AND `default`='1'";
                                        obj4.prepare();
                                        obj4.execute((errOtp: any, _res: any) => {
                                            let message = "";
                                            let otp_digit = "";
                                            let temp_type = "";
                                            let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
                                            let temp_key = '';
                                            let charactersLength = characters.length;
                                            for (let i = 0; i < 25; i++) {
                                                temp_key += characters.charAt(Math.floor(Math.random() * charactersLength));
                                            }
                                            if (_res.length > 0) {
                                                message = _res[0].body;
                                                otp_digit = _res[0].otp_digit;
                                                temp_type = _res[0].tmp_type;
                                            }
                                            else {
                                                message = "Your One time Password is {OTP}";
                                                otp_digit = "5";
                                                temp_type = "sms";
                                            }
                                            let objTime = new ModelRawNonQuery(req, res);
                                            objTime.nonqrysql = "INSERT INTO `2fa_template`(`iduser`, `otp_digit`,`body`, `tmp_type`,`template_key`,`default`) VALUES (" + iduser[0].userid + "," + setToZero(otp_digit) + ",'" + parseBody(message) + "', '" + temp_type + "','" + temp_key + "','1')";
                                            objTime.prepare();
                                            objTime.execute((err: any, sTime: any) => {
                                                if (err == 1) {
                                                    let obj4 = new ModelRawQuery(req, res);
                                                    obj4.qrysql = "SELECT `subject`,`template`,`cc`,`bcc` FROM `email_template` WHERE type='email_verification'";
                                                    obj4.prepare();
                                                    obj4.execute((emlErr: any, emlRes: any) => {
                                                        if (emlErr == 1) {
                                                            if (emlRes.length > 0) {
                                                                let tmpData = emlRes[0].template;
                                                                tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.firstName);
                                                                tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.lastName);
                                                                tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);

                                                                let obj11 = new ModelRawNonQuery(req, res);
                                                                obj11.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES (" + iduser[0].userid + "," + iduser[0].account + ",'" + FromEmail + "','" + sdata.email + "', '" + parseBody(emlRes[0].subject) + "','Thank You For Registration', '" + parseBody(tmpData) + "','Thank You For Registration','2','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                                obj11.prepare();
                                                                obj11.execute((_err: any, __result: any) => {
                                                                    if (_err == 1) {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ result: sdata, key: validationKey, iduser: iduser[0].userid, status: 201, message: "Congratulations on your well-deserved success. Account Successfully Created And Email Sent To Your " + sdata.email });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 401, message: "Registered Successfully But verification Email Not Send. Kindly Contact With Support!" });
                                                                        objv.execute();
                                                                        console.log("Error In Updating Password!");
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: "Registered Successfully. Email Template Not Available!", status: 502 });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Registered But Error With Fetching Email Data!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Template not Inserted Successfully!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong with Signup!", status: 502 });
                                        objv.execute();
                                    }
                                });

                            });


                            // res.status(200).json({data: result, message: "Signup Successfully!"});
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went with Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
        });
    }

    accountServices(req: Request, res: Response, idaccount: any, callback: (err: any, data: any) => void) {
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `fs_id`,`fs_name` FROM `feature_service`";
        obj.prepare();
        obj.execute((_error: any, result: any) => {

            let qry = "INSERT INTO `account_service` (`idaccount`,`fs_id`,`as_status`) VALUES";
            result.forEach((ele: any) => {
                qry += "(" + idaccount + "," + ele.fs_id + ",'1'),";
            });

            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = qry.slice(0, -1);
            obj.prepare();
            obj.execute((_err: any, data: any) => {
                if (_err == 1) {
                    callback(1, { message: "Account services inserted successfully!", status: 200 })
                }
                else {
                    callback(0, { message: "Something went wrong!", status: 502 })
                }
            });
        });
    }

    saveApiRate(req: Request, res: Response, data: any, callback: (err: any, data: any) => void) {
        let obj = new ModelRawNonQuery(req, res);
        obj.nonqrysql = "INSERT INTO `api_rate_limit` (`iduser`, `idaccount`, `req_type`, `type`) VALUES (" + data.iduser + "," + data.idaccount + "," + data.req_type + "," + data.type + ")";
        obj.prepare();
        obj.execute((err: any, dataa: any) => {
            if (err == 1) {
                console.log(1, { status: 200, message: "API Rate saved successfully!" })
            }
            else {
                console.log(0, { status: 502, message: "API Rate not saved!" })
            }
        });
    }

    public AdminSave(req: Request, res: Response, next: NextFunction) {
        // const ipAddress = req.socket.remoteAddress;
        let sysInfo = ipAddressAndBrowser(req);
        let sdataa: any;
        let subscriptiondata:any;
        let sdata: any;
        let filePath: any = "https://portal.signalmash.com/assets/img/icon.png";
        try {
            sdataa = JSON.parse(req.body.data);
            sdata = sdataa.cdata
            subscriptiondata = sdataa.subscriptionid;
           
        } catch (e) {
            console.log("Error :: AdminSave::", e);
            sdataa = JSON.parse(req.body.data);
            sdata = sdataa.cdata
            subscriptiondata = sdataa.subscriptionid;
        };
        if (req.file) {
            const fileName = req.file.filename;
            filePath = 'https://api.signalmash.com' + '/uploads/' + fileName;
        }
        if (sdata.profile_pic) {
            filePath = sdata.profile_pic
        }
        let session = new SessionManagment(req, res, next);
        let msg = "";
        let ustatus: any = sdata.status ? true : false;
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sdata.idaccount == -1) {
                    /**
                     * To add/save customer from admin side
                     */
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + parseBody(sdata.user_name) + "' OR email = '" + sdata.email + "'";
                    obj.prepare();
                    obj.execute((_error: any, getUser: any) => {
                        if (_error == 1) {
                            if (getUser.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    message: "Username or Email Already Exists!",
                                    status: 404
                                });
                                objv.execute();
                            }
                            else {
                                let planVerify: any = sdata.tariff1 ? 'true' : 'false';
                                let obj1 = new ModelRawNonQuery(req, res);
                                let password1 = bcrypt.hashSync(sdata.password, 10);
                                obj1.nonqrysql = "CALL AddUser(-1, -1, '" + parseBody(sdata.user_name) + "','" + parseBody(password1) + "','" + sdata.type + "','" + parseBody(sdata.first_name) + "','" + parseBody(sdata.last_name) + "','" + sdata.email + "','" + sdata.contact_number + "','" + filePath + "','1', " + setToZero(sdata.tariff1) + ", " + setToZero(sdata.tariff2) + ", '" + ustatus + "', " + setToZero(sdata.service) + ", " + setToZero(sdata.credit_limit) + ")";
                                if (sdata.type == 2) {
                                    msg = "Customer Added Successfully.";
                                }
                                if (sdata.type == 3) {
                                    msg = "Supplier Added Successfully.";
                                }
                                obj1.prepare();
                                obj1.execute((__error: any, result: any) => {
                                    if (__error == 1) {
                                        let newRes = result[0];
                                        // To Create Customer
                                        const connection_key = Str.random(30);
                                        const randDigit = connection_key.slice(4, 12);
                                        var rdata: any = [];
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.filter = null;
                                        const val = Math.floor(1000 + Math.random() * 9000);
                                        let username = Math.random().toString(36).substr(2, 11);
                                        let password = generatePassword();
                                        const inbound_key = Str.random(30);
                                        const outbound_key = Str.random(30);
                                        const val1 = Math.floor(1000 + Math.random() * 9000);
                                        const connName = parseBody(sdata.first_name) + val1;
                                        obj2.qrysql = "CALL addconnection(" + newRes[0].account + ", " + newRes[0].userid + ", '" + parseBody(connName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                        obj2.prepare();
                                        obj2.execute((__error: any, allcamp: any) => {
                                            if (__error == 1) {
                                                console.log("Connection Created Successfully.");
                                            }
                                            else {
                                                console.log("Connection Not Created!");
                                            }
                                        });

                                        // To Update Billing Address
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`,`customerType`, `businessName`, `ein`, `website`, `title`, `groupExmpt_number`) VALUES ('" + newRes[0].account + "', '" + parseBody(sdata.first_name) + "', '" + parseBody(sdata.last_name) + "', '" + sdata.contact_number + "', '" + sdata.email + "', '" + parseBody(sdata.address1) + "', '" + parseBody(sdata.address2) + "', '" + parseBody(sdata.city) + "', '" + parseBody(sdata.state) + "', '" + parseBody(sdata.postal_code) + "', '" + sdata.country + "', '" + sdata.customerType + "', '" + parseBody(sdata.businessName) + "', '" + parseBody(sdata.ein) + "', '" + parseBody(sdata.website) + "', '" + parseBody(sdata.title) + "', " + setToZero(sdata.groupExmpt_number) + ")";
                                        obj.prepare();
                                        obj.execute((_error: any, data: any) => {
                                            if (__error == 1) {
                                                console.log("Billing Address Added Successfully.");
                                            }
                                            else {
                                                console.log("Billing Address Not Added!");
                                            }
                                        });

                                        const numeric = '0123456789';
                                        let popin = '';
                                        for (let i = 0; i < 4; i++) {
                                            popin += numeric[Math.floor(Math.random() * numeric.length)];
                                        }
                                        popin = popin.split('').sort(() => Math.random() - 0.5).join('');
                                        // To Update User
                                        let obj11 = new ModelRawNonQuery(req, res);
                                        obj11.nonqrysql = "UPDATE `user` SET `trust_score`='1',`isEmailVerify`='" + sdata.isEmailVerify + "',`isMobileVerify`='" + sdata.isMobileVerify + "', `isPlan`= '" + planVerify + "', `isAddress`='" + sdata.isAddress + "', `ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`ext_name`='" + parseBody(sdata.password) + "',`isCard`='false',`newUser_status`='1',`resetPassword`='1',`reseller_iduser`=" + setToZero(sdata.reseller_id) + " WHERE `idaccount`=" + newRes[0].account + "";
                                        obj11.prepare();
                                        obj11.execute((_errorrr: any, resultt: any) => {
                                            if (_errorrr == 1) {
                                                console.log("User Updated Successfully.");
                                            }
                                            else {
                                                console.log("User Not Updated!");
                                            }
                                        });
                                        let obj15 = new UserManagement();
                                        obj15.sendEmailVerify(req, res, sdata, newRes, next);
                                        // To Update Account
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `account` SET `san`=(100000000 + " + newRes[0].account + "),`portoutpin`='" + popin + "' WHERE `idaccount`=" + newRes[0].account + "";
                                        obj3.prepare();
                                        obj3.execute((_uperr: any, __result: any) => {
                                            if (_uperr == 1) {
                                                console.log("Account Updated Successfully.");
                                            }
                                            else {
                                                console.log("Account Not Updated!");
                                            }
                                        });

                                        //  To insert Account owner category
                                        let obj12 = new ModelRawNonQuery(req, res);
                                        obj12.nonqrysql = "INSERT INTO `notification_subscriber_email`(`idaccount`,`iduser`,`nec_id`,`email`) VALUES (" + newRes[0].account + "," + newRes[0].userid + ",5,'" + sdata.email + "')";
                                        obj12.prepare();
                                        obj12.execute((_err: any, __result: any) => {
                                            if (_err == 1) {
                                                console.log("Email Inserted Successfully!");
                                            }
                                            else {
                                                console.log("Error With insert Email!");
                                            }
                                        });

                                        // To Insert Account Services 
                                        const um = new UserManagement();
                                        um.accountServices(req, res, newRes[0].account, (errorr, resp) => {
                                            if (resp.status == 200) {
                                                console.log("Services Inserted Successfully.");
                                            }
                                            else {
                                                console.log("Something went wrong in account service insertion!");
                                            }
                                        });

                                        // To save search api_rate
                                        let data: any = { iduser: newRes[0].userid, idaccount: newRes[0].account, req_type: 1, type: 2 };
                                        um.saveApiRate(req, res, data, (errorr, resp) => {
                                        });

                                        if (subscriptiondata !== null && subscriptiondata !== undefined) {
                                            let subscriptionmap = new SubscriptionManagement();
                                            subscriptionmap.Savesuscriptioncontrolmapping(req, res, subscriptiondata, newRes[0].account, (err: any) => {
                                                if (err == 0) {
                                                    console.log("Something went Wrong");
                                                } else {
                                                    console.log("Subscription Data Saved");
                                                }
                                            });
                                        }

                                        // To Insert Timezone Config
                                        let objTime = new ModelRawNonQuery(req, res);
                                        objTime.nonqrysql = "INSERT INTO `tbl_timezone_config` SET `id_timezone`=16, id_user=" + newRes[0].userid + "";
                                        objTime.prepare();
                                        objTime.execute((errTime: any, sTime) => {
                                            if (errTime == 1) {
                                                console.log("Time Zone Inserted Successfully.");
                                            }
                                            else {
                                                console.log("Time Zone Not Inserted!");
                                            }
                                        });

                                        let obj4 = new ModelRawQuery(req, res);
                                        obj4.qrysql = "SELECT body, otp_digit, tmp_type  FROM `2fa_template` WHERE iduser=1 AND tmp_type='sms' AND `default`='1'";
                                        obj4.prepare();
                                        obj4.execute((sessdata: any, _res: any) => {
                                            let message = "";
                                            let otp_digit = "";
                                            let temp_type = "";
                                            let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
                                            let temp_key = '';
                                            let charactersLength = characters.length;
                                            for (let i = 0; i < 25; i++) {
                                                temp_key += characters.charAt(Math.floor(Math.random() * charactersLength));
                                            }
                                            if (_res.length > 0) {
                                                message = _res[0].body;
                                                otp_digit = _res[0].otp_digit;
                                                temp_type = _res[0].tmp_type;
                                            } else {
                                                message = "Your One time Password is {OTP}";
                                                otp_digit = "5";
                                                temp_type = "sms";
                                            }
                                            let objTime = new ModelRawNonQuery(req, res);
                                            objTime.nonqrysql = "INSERT INTO `2fa_template`(`iduser`, `otp_digit`,`body`, `tmp_type`,`template_key`,`default`) VALUES (" + newRes[0].userid + "," + setToZero(otp_digit) + ",'" + parseBody(message) + "', '" + temp_type + "','" + temp_key + "','1')";
                                            objTime.prepare();
                                            objTime.execute((err: any, sTime: any) => {
                                                if (err == 1) {
                                                    console.log("Default Template Created.");
                                                }
                                                else {
                                                    console.log("Template Not Created!");
                                                }
                                            });
                                        });
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result[0], message: "Customer Created Successfully!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result[0], message: "Customer Not Created!", status: 502 });
                                        objv.execute();
                                    }
                                });

                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    /**
                     * To add/save subcustomer of customer from admin side
                     */
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + parseBody(sdata.user_name) + "' OR email = '" + sdata.email + "'";
                    obj.prepare();
                    obj.execute((_error: any, getUser: any) => {
                        if (_error == 1) {
                            if (getUser.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Username or Email Already Exists!", status: 404 });
                                objv.execute();
                            } else {
                                let obj1 = new ModelRawNonQuery(req, res);
                                let password1 = bcrypt.hashSync(sdata.password, 10);
                                obj1.nonqrysql = "CALL AddUser('" + sdata.idaccount + "', -1, '" + parseBody(sdata.user_name) + "','" + parseBody(password1) + "','" + sdata.type + "','" + parseBody(sdata.first_name) + "','" + parseBody(sdata.last_name) + "','" + sdata.email + "','" + sdata.contact_number + "','" + filePath + "','0', " + setToZero(sdata.tariff1) + "," + setToZero(sdata.tariff2) + ", '" + ustatus + "', " + setToZero(sdata.service) + ", " + setToZero(sdata.credit_limit) + ")";
                                if (sdata.type == 2) {
                                    msg = "Customer Updated Successfully";
                                }
                                if (sdata.type == 3) {
                                    msg = "Supplier Updated Successfully";
                                }
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let newRes = result[0];
                                        // To Create Customer
                                        const connection_key = Str.random(30);
                                        const randDigit = connection_key.slice(4, 12);
                                        var rdata: any = [];
                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.filter = null;
                                        const val = Math.floor(1000 + Math.random() * 9000);
                                        let username = Math.random().toString(36).substr(2, 11);
                                        let password = generatePassword();
                                        const inbound_key = Str.random(30);
                                        const outbound_key = Str.random(30);
                                        const val1 = Math.floor(1000 + Math.random() * 9000);
                                        const connName = parseBody(sdata.first_name) + val1;
                                        obj2.qrysql = "CALL addconnection(" + newRes[0].account + ", " + newRes[0].userid + ", '" + parseBody(connName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                        obj2.prepare();
                                        obj2.execute((__error: any, allcamp: any) => {
                                            if (__error == 1) {
                                                console.log("Connection Created Successfully.");
                                            }
                                            else {
                                                console.log("Connection Not Created!");
                                            }
                                        });

                                        // To save search api_rate
                                        const um = new UserManagement();
                                        let data: any = { iduser: newRes[0].userid, idaccount: newRes[0].account, req_type: 1, type: 22 };
                                        um.saveApiRate(req, res, data, (errorr, resp) => {
                                        });

                                        if (subscriptiondata !== null && subscriptiondata !== undefined) {
                                            let subscriptionmap = new SubscriptionManagement();
                                            subscriptionmap.Savesuscriptioncontrolmapping(req, res, subscriptiondata, newRes[0].account, (err: any) => {
                                                if (err == 0) {
                                                    console.log("Something went Wrong");
                                                } else {
                                                    console.log("Subscription Data Saved");
                                                }
                                            });
                                        }

                                        if (sdata.type == 22) {
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = " + sdata.idaccount + "";
                                            obj0.prepare();
                                            obj0.execute((_errorser: any, getSer: any) => {
                                                if (_errorser == 1) {
                                                    let service = getSer[0].idservice;
                                                    let idtariff = getSer[0].idtariff;
                                                    let obj11 = new ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "UPDATE `user` SET `idtariff`=" + setToZero(idtariff) + ",`idservice`=" + setToZero(service) + ",`isAddress`='true',`isCard`='true',`newUser_status`='" + sdata.newUser_status + "',`resetPassword`='1', `ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "', `ext_name`='" + parseBody(sdata.password) + "' WHERE `iduser`=" + newRes[0].userid + "";
                                                    obj11.prepare();
                                                    obj11.execute((_errorrr: any, resultt: any) => {
                                                        if (_errorrr == 1) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ data: resultt[0], message: "Sub Customer Created Successfully!", status: 201 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ data: resultt, message: "Something Went Wrong With Connection!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong With Tarif And Service!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ data: result[0], message: "Profile Updated Successfully!", status: 201 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }


    public SaveUser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sysInfo = ipAddressAndBrowser(req);
                let sdata: any;
                let filePath: any = "https://portal.signalmash.com/assets/img/icon.png";
                try {
                    sdata = JSON.parse(req.body.data);
                } catch (e) {
                    sdata = req.body.data;
                }
                if (req.file) {
                    const fileName = req.file.filename;
                    // var filePath = req.protocol + '://' + req.get("host") + "/uploads/" + fileName;
                    filePath = 'https://api.signalmash.com' + '/uploads/' + fileName;
                }
                if (sdata.profile_pic != null || sdata.profile_pic != undefined) {
                    filePath = sdata.profile_pic
                }
                let obj = new ModelRawNonQuery(req, res);
                let ustatus: any = sdata.status ? true : false
                let objj1 = new ModelRawQuery(req, res);
                objj1.qrysql = "SELECT `ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `email` = '" + sdata.email + "' OR `first_name` = '" + parseBody(sdata.first_name).trim() + "' OR `last_name` = '" + parseBody(sdata.last_name).trim() + "' OR `domain_name` = '" + sdata.email.split('@')[1] + "' OR `contact`='" + sdata.contact_number + "'";
                objj1.prepare();
                objj1.execute((_errDomainBlk: any, getDomainBlock: any) => {
                    if (_errDomainBlk == 1 && getDomainBlock.length > 0) {

                        let errMsg = '';
                        if (getDomainBlock[0].email == sdata.email)
                            errMsg = "Invalid Account Registration!";
                        else if (getDomainBlock[0].domain_name == sdata.email.split('@')[1])
                            errMsg = "Invalid Account Registration!";
                        else if (getDomainBlock[0].first_name == sdata.first_name)
                            errMsg = "Invalid Account Registration!";
                        else if (getDomainBlock[0].last_name == sdata.last_name)
                            errMsg = "Invalid Account Registration!";
                        else if (getDomainBlock[0].ipAddress == sdata.ipAddress)
                            errMsg = "Invalid Account Registration!";
                        else if (getDomainBlock[0].contact == sdata.contact_number)
                            errMsg = "Invalid Account Registration!";
                        else
                            errMsg = "You Can't Register With Invalid Details!";

                        let objv = new RawView(res);
                        objv.prepare({
                            message: errMsg,
                            status: 501
                        });
                        objv.execute();
                    } else {
                        if (sdata.iduser == -1) {
                            /**
                             * To save/add subcustomer of customer from customer side
                             */
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + parseBody(sdata.user_name) + "'";
                            obj1.prepare();
                            obj1.execute((_error: any, result: any) => {
                                console.log("Same User Data :::::",result)
                                let username: any = (result.length > 0) ? result[0].username : ''
                                if (_error == 1) {
                                    // if(result.length > 0){
                                    if (username == sdata.user_name) {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: "Username Already Exists!",
                                            status: 404
                                        });
                                        objv.execute();
                                        return;
                                    }
                                    else {
                                        let type: any = (Array.isArray(sdata.type) && sdata.type.length > 0 && sdata.type[0].hasOwnProperty('user_type')) ? sdata.type[0].user_type : sdata.type;
                                        
                                        console.log("Add Section :::: ", type);


                                        let obj0 = new ModelRawQuery(req, res);
                                        obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = " + sdata.idaccount + " LIMIT 1";
                                        obj0.prepare();
                                        obj0.execute((_errorser: any, getSer: any) => {
                                            if (_errorser == 1) {
                                                let service = getSer[0].idservice ? getSer[0].idservice : 0;
                                                let idtariff = getSer[0].idtariff ? getSer[0].idtariff : 0;
                                  
                                                let obj12 = new ModelRawNonQuery(req, res);
                                                obj12.nonqrysql ="INSERT INTO `user` SET `idaccount`='" + sessdata.idaccount + "',  `username`='" + parseBody(sdata.user_name) + "', `type`='"+type+"', `default`='0', idtariff=" + setToZero(idtariff) + ",`idservice`=" + setToZero(service) + ",`isAddress`='true', `status`= '"+ustatus+"',  `isEmailVerify`='true', `isMobileVerify`='true', `isPlan`='true', isCard='true',`newUser_status`='1',`resetPassword`='1',`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "'";
                                                obj12.prepare();
                                                obj12.execute((errorrr: any, resultt: any) => {
                                                    if (errorrr == 1) {
                                                        let iduser = resultt.insertId
                                                        let obj13 = new ModelRawNonQuery(req, res);
                                                        obj13.nonqrysql = "INSERT INTO  `user_profile` SET `iduser`='"+iduser+"',`account_id` = '" + sessdata.idaccount + "',`firstname`='" + parseBody(sdata.first_name) + "', `lastname`='" + parseBody(sdata.last_name) + "', `email`='" + sdata.email + "', `phone`='" + sdata.contact_number + "',`profile_pic`='"+filePath+"'";
                                                       obj13.prepare();
                                                       obj13.execute((errup: any, resup: any) => {
                                                           if (errup == 1) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ data: resultt[0], message: "Customer Created Successfully!", status: 201 });
                                                                objv.execute();
                                                           }
                                                           else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ data: resultt[0], message: "Customer created successfully but profile not created!", status: 505 });
                                                                objv.execute();
                                                           }
                                                       });                                                   
                                                    
                                                        let obj5 = new ModelRawQuery(req, res);
                                                        obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='multi_user_password_setup'";
                                                        obj5.prepare();
                                                        obj5.execute((emlErr: any, emlRes: any) => {
                                                            if (emlErr == 1) {
                                                                if (emlRes.length > 0) {

                                                                    let secret = Str.random(15);
                                                                    let validationKey = jwt.sign({
                                                                        exp: Math.floor(Date.now() / 1000) + (60 * 60),
                                                                        data: sdata.email
                                                                    }, secret);

                                                                    let obj3 = new ModelRawNonQuery(req, res);
                                                                    obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "',`isResetPassword` = 'true'  WHERE `username`='" + parseBody(sdata.user_name) + "' AND `is_deleted`=0";
                                                                    obj3.prepare();
                                                                    obj3.execute((_uperr: any, __result: any) => { })

                                                                    let tmpData = emlRes[0].template;
                                                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.first_name);
                                                                    tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.last_name);
                                                                    tmpData = tmpData.replace(/{PASSWORD_PAGE_LINK}/g, templateURL.URL + '/#/setpassword/' + validationKey);
                                                                    tmpData = tmpData.replace(/{USERNAME}/g, sdata.user_name);

                                                                    let obj1 = new ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + sdata.email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Set User Password.', '" + parseBody(tmpData) + "','Mail Send for Set User Password.','25','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                                    obj1.prepare();
                                                                    obj1.execute((_err: any, __result: any) => {
                                                                        if (_err == 1) {
                                                                            console.log("Email Send Successfully!")
                                                                        }
                                                                        else {
                                                                            console.log("Opps Email Not Sent!");
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    console.log("Template Data Not Found!");
                                                                }
                                                            }
                                                            else {
                                                                console.log("Something Went Wrong with DB!");
                                                            }
                                                        });
                                                    
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ data: resultt[0], message: "Customer Not Created!", status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Get Tariff And Update User.", status: 501 });
                                                objv.execute();
                                            }
                                        });                                       
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result[0], message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            
                            let type: any = (Array.isArray(sdata.type) && sdata.type.length > 0 && sdata.type[0].hasOwnProperty('user_type')) ? sdata.type[0].user_type : sdata.type;
                            
                            console.log("Edit Section :::: ", type);
                            
                            /**
                             * To update subcustomer and customer from customer side and admin side
                             */
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT up.email ,u.username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE u.username = '" + parseBody(sdata.user_name) + "' AND u.iduser != " + sdata.iduser + "";
                            obj1.prepare();
                            obj1.execute((_error: any, result: any) => {
                                let username: any = (result.length > 0) ? result[0].username : ''
                                if (_error == 1) {
                                    console.log(result, "resullttt updatedd")
                                    // if (result.length > 0) {
                                    if (username == sdata.user_name) {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: "Username or Email Already Exists!",
                                            status: 404
                                        });
                                        objv.execute();
                                    } 
                                    else {                                       
                                            
                                        if (type == 2) {
                                            console.log("customer type :::::", type);
                                              
                                            // let password1 = bcrypt.hashSync(sdata.password, 10);
                                            obj.nonqrysql = "CALL AddUser('" + sdata.idaccount + "', " + sdata.iduser + ", '" + parseBody(sdata.user_name) + "','','" + type + "','" + parseBody(sdata.first_name) + "','" + parseBody(sdata.last_name) + "','" + sdata.email + "','" + sdata.contact_number + "','" + filePath + "','0', " + setToZero(sdata.tariff1) + "," + setToZero(sdata.tariff2) + ", '" + ustatus + "', " + setToZero(sdata.service) + ", " + setToZero(sdata.credit_limit) + ")";
                                            obj.prepare();
                                            obj.execute((_error: any, result: any) => {
                                                if (_error == 1) {
                                                    let newRes = result[0];
                                                    let obj0 = new ModelRawQuery(req, res);
                                                    obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = " + sdata.idaccount + "";
                                                    obj0.prepare();
                                                    obj0.execute((_errorser: any, getSer: any) => {
                                                        if (_errorser == 1) {
                                                            let obj11 = new ModelRawNonQuery(req, res);
                                                            obj11.nonqrysql = "UPDATE `billing_address` SET `first_name`='" + parseBody(sdata.first_name) + "',`last_name`='" + parseBody(sdata.last_name) + "', `contact`='" + sdata.contact_number + "',`email`='" + sdata.email + "', `address1`='" + parseBody(sdata.address1) + "', `address2`='" + parseBody(sdata.address2) + "', `city`='" + parseBody(sdata.city) + "', `state`='" + parseBody(sdata.state) + "', `postal_code`='" + parseBody(sdata.postal_code) + "', `country`='" + sdata.country + "',`customerType`='" + sdata.customerType + "', `businessName`='" + parseBody(sdata.businessName) + "', `ein`='" + parseBody(sdata.ein) + "', `website`='" + parseBody(sdata.website) + "', `title`='" + parseBody(sdata.title) + "', `groupExmpt_number`=" + setToZero(sdata.groupExmpt_number) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                            obj11.prepare();
                                                            obj11.execute((_errBil: any, resultBil: any) => {
                                                                if (_errBil == 1) {
                                                                    console.log("Biilling Address Updated Successfully.");
                                                                }
                                                                else {
                                                                    console.log("Biilling Address Not Updated!");
                                                                }
                                                            });
                                                            let service = getSer[0].idservice ? getSer[0].idservice : 0;
                                                            let idtariff = getSer[0].idtariff ? getSer[0].idtariff : 0;
                                                            let planVerify: any = (sdata.tariff1 && sdata.tariff1 !== -1) ? 'true' : 'false';

                                                            // To send the mail
                                                            let obj15 = new UserManagement();
                                                            obj15.sendEmailVerify(req, res, sdata, newRes, next);

                                                            // To Update User table
                                                            let obj12 = new ModelRawNonQuery(req, res);
                                                            obj12.nonqrysql = "UPDATE `user` SET  `isEmailVerify`='" + sdata.isEmailVerify + "',`isMobileVerify`='" + sdata.isMobileVerify + "', `isPlan`= '" + planVerify + "', `isAddress`='" + sdata.isAddress + "',`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`idtariff`=" + setToZero(idtariff) + ",`idservice`=" + setToZero(service) + ",`reseller_iduser`=" + setToZero(sdata.reseller_id) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                            obj12.prepare();
                                                            obj12.execute((_errorrr: any, resultt: any) => {
                                                                if (_errorrr == 1) {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ data: resultt[0], message: "Customer Updated Successfully!", status: 201 });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ data: resultt, message: "Something Went Wrong With Customer Update!", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            });

                                                            // To Update Email
                                                            let obj4 = new ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "UPDATE `notification_subscriber_email` SET `email`= '" + sdata.email + "' WHERE `idaccount`= " + newRes[0].account + " AND `nec_id` = 5";
                                                            obj4.prepare();
                                                            obj4.execute((_uperr: any, __result: any) => {
                                                                if (_uperr == 1) {
                                                                    console.log("Email Updated Successfully.");
                                                                }
                                                                else {
                                                                    console.log("EMail Not Updated!");
                                                                }
                                                            });

                                                            // To Update Session table
                                                            let obj13 = new ModelRawNonQuery(req, res);
                                                            obj13.nonqrysql = "UPDATE `session` SET `idtariff`=" + setToZero(idtariff) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                            obj13.prepare();
                                                            obj13.execute((_errorS: any, resultS: any) => {
                                                                if (_errorS == 1) {
                                                                    // let P=0;
                                                                    // To update Has table
                                                                    let objS = new ModelRawQuery(req, res);
                                                                    objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`=" + sdata.idaccount + "";
                                                                    objS.prepare();
                                                                    objS.execute((errKey: any, delKey: any) => {
                                                                        if (errKey == 1) {
                                                                            if (delKey.length > 0) {
                                                                                for (let x of delKey) {
                                                                                    let currSess = sessiondata.get(x.authKey);
                                                                                    currSess.idtariff = idtariff;
                                                                                    sessiondata.set(x.authKey, currSess);
                                                                                }
                                                                            }
                                                                        }
                                                                    });
                                                                    console.log("idtariff updated successfully in session! :: ", idtariff);
                                                                }
                                                                else {
                                                                    console.log("idtariff not updated in session! :: ", idtariff);
                                                                }
                                                            });

                                                            // To Update API table
                                                            let obj14 = new ModelRawNonQuery(req, res);
                                                            obj14.nonqrysql = "UPDATE `api` SET `idtariff`=" + setToZero(idtariff) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                            obj14.prepare();
                                                            obj14.execute((_errorA: any, resultA: any) => {
                                                                if (_errorA == 1) {
                                                                    console.log("idtariff updated successfully in API! :: ", idtariff);
                                                                }
                                                                else {
                                                                    console.log("idtariff not updated in API table :: ", idtariff);
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Something Went Wrong With Tariff And Service!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                                                    objv.execute();
                                                }
                                            });                                        
                                        }
                                        else {
                                            console.log("customer type ::::", type);

                                            let obj11 = new ModelRawNonQuery(req, res);
                                            obj11.nonqrysql = "UPDATE `user` SET `type`='"+type+"' WHERE `iduser`=" + sdata.iduser + "";
                                            obj11.prepare();
                                            obj11.execute((_errorrr: any, resultt: any) => {
                                                if (_errorrr == 1) {
                                                    console.log("User Type Updated");
                                                }
                                                else {
                                                    console.log("User Type Not Updated!");
                                                }
                                            });
                                            let obj13 = new ModelRawNonQuery(req, res);
                                            obj13.nonqrysql = "UPDATE `user_profile` SET `firstname`='" + parseBody(sdata.first_name) + "', `lastname`='" + parseBody(sdata.last_name) + "', `email`='" + sdata.email + "', `phone`='" + sdata.contact_number + "' WHERE `iduser`='"+sdata.iduser+"'";
                                            obj13.prepare();
                                            obj13.execute((errup: any, resup: any) => {
                                                if (errup == 1) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Customer Updated Successfully.", status: 201 });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({message: "Something Went Wrong With Customer Update.", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }                                            
                                    }
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    sendEmailVerify(req: Request, res: Response, sdata: any, newRes: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let secret = Str.random(15);
                let validationKey = jwt.sign({
                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                    data: sdata.email + sdata.password
                }, secret);
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "', `secret`='" + secret + "', `email_verification_date`=NOW() WHERE `iduser`='" + newRes[0].userid + "' AND  `is_deleted`=0";
                obj3.prepare();
                obj3.execute((_err: any, __result: any) => {
                    if (_err == 1) {
                        if (__result.affectedRows > 0) {
                            let tempType: any;
                            if (sdata.isEmailVerify == 'true' || sdata.isEmailVerify == true) {
                                tempType = "welcome";
                            }
                            if (sdata.isEmailVerify == 'false' || sdata.isEmailVerify == false) {
                                tempType = "email_verification";
                            }
                            let obj5 = new ModelRawQuery(req, res);
                            obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='" + tempType + "'";
                            obj5.prepare();
                            obj5.execute((emlErr: any, emlRes: any) => {

                                if (emlErr == 1) {
                                    if (emlRes.length > 0) {
                                        let tmpData = emlRes[0].template;
                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.first_name);
                                        tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.last_name);
                                        tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);

                                        // var smtpTransport = nodemailer.createTransport({
                                        //     service: "gmail",
                                        //     host: "smtp.gmail.com",
                                        //     port: 587,
                                        //     secure: true,
                                        //     auth: {
                                        //         user: "mailto:donotreply@nglcommunications.com",
                                        //         pass: "yr%5V9GB"
                                        //     }
                                        // });
                                        // var mailOptions = {
                                        //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                        //     to: sdata.email,
                                        //     usernmae: sdata.user_name,
                                        //     email: sdata.email,
                                        //     subject: `${emlRes[0].subject}`,
                                        //     text: "Thank You For Registration",
                                        //     html: `${tmpData}`
                                        // }
                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                        //     if (_emailError) {
                                        //         console.log("Opps Email Not Sent!");
                                        //     } else {
                                        //         console.log("Email Send  Successfully!");
                                        //     }
                                        // });

                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + newRes[0].userid + "','" + newRes[0].account + "','" + FromEmail + "','" + sdata.email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Email Verification.', '" + parseBody(tmpData) + "','Mail Send for Email Verification.','3','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                        obj1.prepare();
                                        obj1.execute((_err: any, __result: any) => {
                                            if (_err == 1) {
                                                console.log("Email Send  Successfully!")
                                            }
                                            else {
                                                console.log("Opps Email Not Sent!");
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Template Data Not Found!");
                                    }
                                }
                                else {
                                    console.log("Something Went Wrong with DB!");
                                }
                            });
                        }
                        else {
                            console.log("Invalid Key/Invalid Account!");
                        }
                    }
                    else {
                        console.log("Something Went Wrong with DB!");
                    }
                });
            }
            else {
                console.log(session);
            }
        });
    }

    UserList(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                if (sdata.type == "main") {
                    obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", -1)";
                }
                // profile = details of account
                else if (sdata.type == "profile") {
                    obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", 1)";
                }
                // detail = profile of user
                else if (sdata.type == "detail") {
                    obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", 2)";
                }
                else if (sdata.type == "edit") {
                    obj.nonqrysql = "CALL ListUser(" + sdata.idaccount + ", " + sdata.iduser + ", 3)";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    // for (const item of result[0]) {
                    //     delete item.password;
                    // }
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    ListUsers(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                if (sdata.type == "profile") {
                    obj.nonqrysql = "CALL ListUser(" + sdata.idaccount + ", " + sdata.iduser + ", 1)";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            for (const item of result[0]) {
                                delete item.password;
                            }
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Profile Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    singleUser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser = req.query.type;
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT u.iduser, u.idaccount, u.idtariff, u.idservice, u.type, u.created, u.isEmailVerify, u.isMobileVerify, u.isAddress, u.isCard, u.isPlan, u.is_deleted, u.newUser_status, u.restore_date, u.kyc_verify_status, u.volt_status, u.federal_status ,uf.firstname,uf.lastname,uf.email,u.resetPassword,u.username FROM `user`u inner join `user_profile`uf on u.iduser=uf.iduser WHERE u.`iduser`='" + sessdata.iduser + "'";
                obj1.prepare();
                obj1.execute((_error1: any, result1: any) => {
                    if (_error1 == 1 && result1.length > 0) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT a.subscription_payment, b.idaccount, b.address1, b.address2, b.city, b.state, b.contact, b.postal_code, b.country, b.customerType, b.title, b.ein, b.website, b.groupExmpt_number, b.businessName, w.balance, w.credit_limit FROM `billing_address` b JOIN `wallet` w ON w.idaccount = b.idaccount JOIN `account` a ON a.idaccount = b.idaccount WHERE  `b`.idaccount=" + result1[0].idaccount + "";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let sessData1 = {
                                    authkey: sessdata.authkey,
                                    type: result1[0].type,
                                    iduser: result1[0].iduser,
                                    username: result1[0].username,
                                    idaccount: result1[0].idaccount,
                                    isEmailVerify: result1[0].isMobileVerify,
                                    isMobileVerify: result1[0].isMobileVerify,
                                    isAddress: result1[0].isAddress,
                                    isPlan: result1[0].isPlan,
                                    isCard: result1[0].isCard,
                                    newUser_status: result1[0].newUser_status,
                                    idtariff: result1[0].idtariff,
                                    kyc_verify_status: result1[0].kyc_verify_status,
                                    country: (result.length > 0 && result[0].country) ? result[0].country : ''
                                };

                                let objv = new RawView(res);
                                objv.prepare({ data: result, data1: result1, sessdata: [sessData1], message: "Profile Fetched Successfully!", status: 200 });
                                objv.execute();

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong List User", status: 502, error: _error });
                                objv.execute();
                            }
                        });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With User", status: 502, error: _error1 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getSingleUsersForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser = req.query.type;
                if (sessdata.type == 1 || sessdata.type == 2) {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT u.iduser, u.idaccount, u.idtariff, u.idservice, u.type, u.created, u.isEmailVerify, u.isMobileVerify, u.isAddress, u.isCard, u.isPlan, u.is_deleted, u.newUser_status, u.restore_date, u.kyc_verify_status, u.volt_status, u.federal_status ,uf.firstname,uf.lastname,uf.email FROM `user`u inner join `user_profile`uf on u.iduser=uf.iduser WHERE u.`iduser`=" + iduser + "";
                    obj1.prepare();
                    obj1.execute((_error1: any, result1: any) => {
                        if (_error1 == 1 && result1.length > 0) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT b.idaccount, b.address1, b.address2, b.city, b.state, b.contact, b.postal_code, b.country, b.customerType, b.title, b.ein, b.website, b.groupExmpt_number, b.businessName, w.balance, w.credit_limit FROM `billing_address` b JOIN `wallet` w ON w.idaccount = b.idaccount WHERE `b`.idaccount=" + result1[0].idaccount + "";
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, data1: result1, message: "Profile Fetched Successfully!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong List User", status: 502, error: _error });
                                    objv.execute();
                                }
                            });
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User", status: 502, error: _error1 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not Authorized!", status: 403 });
                    objv.execute();
                }

            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    subCustomerList(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,idaccount,username,idtariff,status FROM `user` WHERE `idaccount`=" + sessdata.idaccount + " AND `is_deleted`='0'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Sub Customer Fetched!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    // getAllUsers(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let Qry: any = '';
    //             let obj = new ModelRawQuery(req, res);
    //             //Qry += "SET SESSION group_concat_max_len = 1000000;\n"
    //             // Qry += `SELECT c.idaccount, c.iduser, c.idtariff, c.type, ac.san, CONCAT(up.firstname,' ',up.lastname) name, CONCAT( '[',( SELECT GROUP_CONCAT( CONCAT( '{"idaccount":"', s.idaccount, '","iduser":"', s.iduser, '","idtariff":"', s.idtariff, '","type":"', s.type, '","name":"', REPLACE(REPLACE(REPLACE(REPLACE(CONCAT(uu.firstname, ' ', uu.lastname), '"', '\\"'), "'", "\\'"), '\n', '\\n'), "\\'", "\\'"), '"', '}' ) SEPARATOR ',') FROM user s LEFT JOIN user_profile uu ON uu.iduser = s.iduser INNER JOIN account a ON a.idaccount = s.idaccount WHERE s.type = 22 AND s.idaccount = c.idaccount ), ']') AS customer_data FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE c.type = 2 AND c.is_deleted=0 GROUP BY c.idaccount;`


    //             Qry += `SELECT c.idaccount, MAX(c.iduser) AS iduser, MAX(c.idtariff) AS idtariff, c.type, ac.san, CONCAT(MAX(up.firstname),' ',MAX(up.lastname)) AS name,CONCAT( '[',(SELECT GROUP_CONCAT(CONCAT('{"idaccount":"', s.idaccount, '","iduser":"', s.iduser, '","idtariff":"', s.idtariff, '","type":"', s.type, '","name":"', REPLACE(REPLACE(REPLACE(REPLACE(CONCAT(uu.firstname, ' ', uu.lastname), '"', '\"'), "'", "\'"), '\n', '\n'), "'", "\'"), '"', '}' ) SEPARATOR ',' ) FROM user s LEFT JOIN user_profile uu ON uu.iduser = s.iduser INNER JOIN account a ON a.idaccount = s.idaccount WHERE s.type = 22 AND s.idaccount = c.idaccount), ']') AS customer_data FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE c.type = 2 AND c.is_deleted = 0 GROUP BY c.idaccount;`;

    //             obj.qrysql = Qry;
    //             obj.prepare();
    //             obj.execute((_error: any, result: any) => {
    //                 if (_error == 1) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ data: result, message: "Sub Customer Fetched!", status: 201 });
    //                     objv.execute();
    //                 }
    //                 else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
    //                     objv.execute();
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare({ status: 401, message: "Unauthorized User!" });
    //             objv.execute();
    //         }
    //     });
    // }

    // getAllUsers(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawQuery(req, res);

    //             // Fetch Customers
    //             let customerQry: string = `SELECT c.idaccount, c.iduser, c.idtariff, c.type, ac.san, CONCAT(up.firstname, ' ', up.lastname) AS name FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE c.type = 2 AND c.is_deleted = 0;`;
    //             obj.qrysql = customerQry;
    //             obj.prepare();
    //             obj.execute((custError: any, customerResult: any) => {
    //                 if (custError == 1) {
    //                     // Fetch Sub-Customers
    //                     let obj1 = new ModelRawQuery(req, res);
    //                     let subCustomerQry: string = `SELECT s.idaccount, s.iduser, s.idtariff, s.type, CONCAT(up.firstname, ' ', up.lastname) AS name FROM user s LEFT JOIN user_profile up ON s.iduser = up.iduser INNER JOIN account a ON a.idaccount = s.idaccount WHERE s.type = 22 AND s.is_deleted = 0;`;
    //                     obj1.qrysql = subCustomerQry;
    //                     obj1.prepare();
    //                     obj1.execute((subError: any, subCustomerResult: any) => {
    //                         if (subError == 1) {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ customers: customerResult, subCustomers: subCustomerResult, message: "Customers and Sub-Customers Fetched!", status: 201 });
    //                             objv.execute();
    //                         } else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ customers: [], subCustomers: [], message: "Failed to Fetch Sub-Customers", status: 502 });
    //                             objv.execute();
    //                         }
    //                     });
    //                 } else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ customers: [], subCustomers: [], message: "Failed to Fetch Customers", status: 502 });
    //                     objv.execute();
    //                 }
    //             });
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare({ status: 401, message: "Unauthorized User!" });
    //             objv.execute();
    //         }
    //     });
    // }

    getAllUsers(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                let customerAndSubCustomerQry: string = `SELECT c.idaccount,c.iduser,c.idservice,c.idtariff,c.type,ac.san, CONCAT(up.firstname, ' ', up.lastname) AS name FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE (c.type = 2 OR c.type = 22) AND c.is_deleted = 0;`;
                obj.qrysql = customerAndSubCustomerQry;
                obj.prepare();
                obj.execute((custError: any, result: any) => {
                    if (custError == 1) {
                        let customers = result.filter((user: any) => user.type === 2);
                        let subCustomers = result.filter((user: any) => user.type === 22);

                        let objv = new RawView(res);
                        objv.prepare({
                            customers: customers,
                            subCustomers: subCustomers,
                            message: "Customers and Sub-Customers Fetched!",
                            status: 201
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ customers: [], subCustomers: [], message: "Failed to Fetch Users", status: 502 });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    updateProfilePic(req: Request, res: Response, next: NextFunction) {
        let filePath: any;
        if (req.file) {
            const fileName = req.file.filename;
            //filePath = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
            filePath = profile_pic.profile_pic + '/uploads/' + fileName;
        }
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj6 = new ModelRawNonQuery(req, res);
                obj6.nonqrysql = "UPDATE `user_profile` SET `profile_pic`='" + filePath + "' WHERE `iduser`=" + sessdata.iduser + "";
                obj6.prepare();
                obj6.execute((_error: any, result: any) => {

                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Profile Picture Update Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    removeProfilePic(req: Request, res: Response, next: NextFunction) {
        let filePath: any = req.protocol + '://' + req.get('host') + '/uploads/default.jpg';

        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj6 = new ModelRawNonQuery(req, res);
                obj6.nonqrysql = "UPDATE `user_profile` SET `profile_pic`='" + filePath + "' WHERE `iduser`=" + sessdata.iduser + "";
                obj6.prepare();
                obj6.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Profile Picture Remove Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getGeoCode(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.body.data;
                let options = {
                    'method': 'POST',
                    'url': 'https://communicationsua.avalara.net/api/v2/geo/geocode',
                    'headers': {
                        'client_id': '2221',
                        'Authorization': 'Basic dmlrYXNAZ3ZlbnR1cmUubmV0OmshR3BBdDNKNU5GTUt3UA==',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify([
                        {
                            "ref": "Address Request",
                            "cass": true,
                            "addr": sdata.address1,
                            "city": sdata.city,
                            "st": sdata.state,
                            "zip": sdata.postal_code
                        }
                    ])
                };
                request(options, function (error: any, response: any) {
                    if (!error) {
                        try {
                            let Data: any = JSON.parse(response.body);
                            if (Data[0].err == undefined && Data[0].pcd !== undefined && Data[0].pcd > 0) {
                                let objv = new RawView(res);
                                // objv.prepare({ message: "Geocode Fetched Successfully!", data: { "giocode": Data[0].pcd }, status: 200 });
                                objv.prepare({ data: { "giocode": Data[0].pcd }, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: 'Please Enter a Validate Address', status: 502 });
                                objv.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: getGeoCode::", e);
                            let obj = new RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                            obj.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: 'Please Enter a Validate Address', status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    addBillingAddress(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `first_name`,`last_name`,`idaccount` FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((_erro: any, datachk: any) => {
                    let sdata = req.body.data
                    if (datachk.length > 0) {
                        let obj00 = new ModelRawNonQuery(req, res);
                        obj00.nonqrysql = "UPDATE `billing_address` SET `address1`='" + parseBody(sdata.address1) + "',`address2`='" + parseBody(sdata.address2) + "',`city`='" + parseBody(sdata.city) + "',`state`='" + parseBody(sdata.state) + "',`postal_code`='" + parseBody(sdata.postal_code) + "',`country`='" + sdata.country + "', `first_name`='" + parseBody(sdata.first_name) + "', `last_name`='" + parseBody(sdata.last_name) + "', `email`='" + parseBody(sdata.email) + "', `title`='" + parseBody(sdata.title) + "',`ein`='" + parseBody(sdata.ein) + "',`website`='" + parseBody(sdata.website) + "',`groupExmpt_number`=" + setToZero(sdata.groupExmpt_number) + ",`customerType`='" + sdata.customerType + "',`businessName`='" + parseBody(sdata.businessName) + "' WHERE `idaccount`='" + sessdata.idaccount + "'";
                        obj00.prepare();
                        obj00.execute((_uerro: any, updateBa: any) => {
                            if (_uerro == 1) {
                                let umc = new UserManagement();
                                umc.inBillingAdd(req, res, updateBa, next);
                            }
                        })
                    }
                    else {
                        let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `firstname`,`lastname` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                        obj0.prepare();
                        obj0.execute((_erro: any, resultIn: any) => {
                            if (resultIn.length > 0) {
                                let rdata: any = req.body.data;
                                let first_name = ''
                                let last_name = ''
                                if (!rdata.first_name) {
                                    first_name = resultIn[0].firstname
                                } else {
                                    first_name = rdata.first_name
                                }
                                if (!rdata.last_name) {
                                    last_name = resultIn[0].lastname
                                } else {
                                    last_name = rdata.last_name
                                }
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`,`groupExmpt_number`,`businessName`,`customerType`) VALUES ('" + sessdata.idaccount + "', '" + parseBody(first_name) + "', '" + parseBody(last_name) + "', '" + rdata.email + "', '" + parseBody(rdata.address1) + "', '" + parseBody(rdata.address2) + "', '" + parseBody(rdata.city) + "', '" + parseBody(rdata.state) + "', '" + parseBody(rdata.postal_code) + "', '" + rdata.country + "','" + parseBody(rdata.title) + "','" + parseBody(rdata.ein) + "','" + parseBody(rdata.website) + "'," + setToZero(rdata.groupExmpt_number) + ",'" + parseBody(rdata.businessName) + "','" + parseBody(rdata.customerType) + "')";
                                obj.prepare();
                                obj.execute((_error: any, data: any) => {
                                    if (_error == 1) {
                                        let umc = new UserManagement();
                                        umc.inBillingAdd(req, res, data, next);
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Data not found!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    inBillingAdd(req: Request, res: Response, data: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let countryobj = req.body.data.country;
                let obj4 = new ModelRawNonQuery(req, res);
                obj4.nonqrysql = "UPDATE `user` SET `isAddress`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                obj4.prepare();
                obj4.execute((_error: any, user: any) => {
                    if (_error == 1) {
                        console.log("User's isAddress Updated Successfully!");
                    }
                    else {
                        console.log("User's isAddress Not Updated!");
                    }

                });
                let obj5 = new ModelRawNonQuery(req, res);
                obj5.nonqrysql = "UPDATE `session` SET `isAddress`='true', `country`='" + countryobj + "' WHERE `iduser`='" + sessdata.iduser + "'";
                obj5.prepare();
                obj5.execute((_err: any, user: any) => {
                    if (_err == 1) {
                        console.log("Session Updated Successfully!");
                    }
                    else {
                        console.log("Session Not Updated!");
                    }
                    let obj6 = new ModelRawQuery(req, res);
                    obj6.qrysql = "SELECT `authkey`,`type`,`iduser`,`username`,`idaccount`,`isEmailVerify`,`isMobileVerify`,`isAddress`,`isPlan`,`isCard`,`newUser_status`,`idtariff`,`kyc_verify_status` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                    obj6.prepare();
                    obj6.execute((_sessError: any, sessData: any) => {
                        if (_sessError == 1) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `kyc_verify_status` FROM `user` WHERE `iduser` = '" + sessdata.iduser + "'";
                            obj.prepare();
                            obj.execute((errorr: any, getUser: any) => {
                                if (errorr == 1 && getUser.length > 0) {
                                    let temp1 = "{\"country\": \"" + countryobj + "\"}";
                                    let getUser1 = "{\"kyc_verify_status\": \"" + getUser[0].kyc_verify_status + "\"}";
                                    let temp2 = JSON.parse(temp1);
                                    let getUser2 = JSON.parse(getUser1);
                                    let data1: any = Object.assign(sessData[0], temp2, getUser2);
                                    let objv = new RawView(res);
                                    objv.prepare({ session: [data1], data: [data1], iduser: sessdata.iduser, message: "Address Saved Successfully!", status: 201 });
                                    objv.execute();
                                }
                            });

                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                            objv.execute();
                        }
                    });
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /* * * * * * * * * * * *
     * To send mail to support and customer
     */
    sendOnboardingComplateMail(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj7 = new ModelRawQuery(req, res);
                obj7.qrysql = "SELECT `username`,`idtariff`,`reseller_iduser`,`signup_link_id` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "' AND `isEmailVerify`='true' AND `isMobileVerify`='true' AND `isAddress`='true' AND `isPlan`='true' AND `is_deleted`=0";
                obj7.prepare();
                obj7.execute((userErr: any, userRes: any) => {
                    let userResData = userRes[0];
                    if (userErr == 1 && userRes.length > 0) {
                        let objT = new ModelRawQuery(req, res);
                        objT.qrysql = "SELECT `name` FROM `tariff` WHERE `idtariff`=" + userResData.idtariff + "";
                        objT.prepare();
                        objT.execute((trfErr: any, terRes: any) => {
                            let trfName = trfErr == 1 && terRes.length > 0 && terRes[0].name ? terRes[0].name : 'CUSTOM PLAN';
                            let obj7 = new ModelRawQuery(req, res);
                            obj7.qrysql = "SELECT `san` FROM `account` WHERE `idaccount`=" + sessdata.idaccount + "";
                            obj7.prepare();
                            obj7.execute((accErr: any, accRes: any) => {
                                let accResData = accRes[0];
                                if (accErr == 1 && accRes.length > 0) {
                                    let obj7 = new ModelRawQuery(req, res);
                                    obj7.qrysql = "SELECT `firstname`,`lastname`,`phone`,`email` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj7.prepare();
                                    obj7.execute((bErr: any, billingRes: any) => {
                                        let getUser = billingRes[0];
                                        if (bErr == 1 && billingRes.length > 0) {
                                            // To send mail to customer
                                            let obj9 = new ModelRawQuery(req, res);
                                            obj9.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='onboarding_complete_notification_to_customer'";
                                            obj9.prepare();
                                            obj9.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Thank You For Complete Registration Send Mail to Customer', '" + parseBody(tmpData) + "','Thank You For Complete Onboarding Process','4','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";

                                                        obj1.prepare();
                                                        obj1.execute((_err: any, __result: any) => {
                                                            if (_err == 1) {
                                                                console.log("Email Send Succesfully!")
                                                            }
                                                            else {
                                                                console.log("Email Not Sent!");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Data!");
                                                }
                                            });
                                            // To send mail to support
                                            let obj8 = new ModelRawQuery(req, res);
                                            obj8.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='onboarding_complete_notification_to_support'";
                                            obj8.prepare();
                                            obj8.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    // To send mail to support
                                                    if (emlRes.length > 0) {
                                                        let tmpDataSup = emlRes[0].template;
                                                        let objsu = new ModelRawQuery(req, res);
                                                        tmpDataSup = tmpDataSup.replace(/{SAN_NUMBER}/g, accResData.san);
                                                        tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, getUser.email);
                                                        tmpDataSup = tmpDataSup.replace(/{PHONE}/g, getUser.phone);
                                                        tmpDataSup = tmpDataSup.replace(/{TARIFF}/g, trfName);
                                                        objsu.qrysql = "SELECT rp.firstname, rp.lastname, r.organization_name FROM reseller_profile rp JOIN reseller r ON rp.iduser = r.iduser WHERE rp.iduser = '" + userResData.reseller_iduser + "';";
                                                        objsu.prepare();
                                                        objsu.execute((err: any, resp: any) => {
                                                            if (userResData.reseller_iduser !== 0) {
                                                                if (err == 1) {
                                                                    tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, 'Reseller Organization');
                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, resp[0].organization_name);
                                                                    tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, 'Reseller Contact');
                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, resp[0].firstname);
                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, resp[0].lastname);
                                                                    tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, 'Registration Link Name');
                                                                    tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, userResData.signup_link_id);
                                                                } else {
                                                                    console.log("Error fetching in reseller data")
                                                                }
                                                            } else {
                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, '');
                                                            }

                                                            let obj1 = new ModelRawNonQuery(req, res);
                                                            // obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + supportEmail + "', 'New Signalmash Customer','Thank You For Complete Registration Send Mail to Support', '" + parseBody(tmpDataSup) + "','Thank You For Complete Onboarding Process','4')";

                                                            const Spmail = supportEmail.split(",");
                                                            let qry = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES";
                                                            for (let i = 0; i < Spmail.length; i++) {
                                                                let entry = Spmail[i];
                                                                qry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + entry + "', 'New Signalmash Customer','Thank You For Complete Registration Send Mail to Support', '" + parseBody(tmpDataSup) + "','Thank You For Complete Onboarding Process','4','" + emlRes[0].cc + "','" + emlRes[0].bcc + "'),";
                                                            }
                                                            obj1.nonqrysql = qry.slice(0, -1)
                                                            obj1.prepare();
                                                            obj1.execute((_err: any, __result: any) => {
                                                                if (_err == 1) {
                                                                    console.log("Email Send Succesfully!")
                                                                }
                                                                else {
                                                                    console.log("Email Not Sent!");
                                                                }
                                                            });
                                                        })
                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Data!");
                                                }
                                            });

                                            // To send welcome email to customer 
                                            let obj7 = new ModelRawQuery(req, res);
                                            obj7.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='welcome_email'";
                                            obj7.prepare();
                                            obj7.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        // var mailOptions = {
                                                        //     from: 'Signalmash <donotreply@signalmash.com>',
                                                        //     to: `${getUser.email}`,
                                                        //     usernmae: userResData.username,
                                                        //     email: getUser.email,
                                                        //     subject: `${emlRes[0].subject}`,
                                                        //     text: "Welcome Email",
                                                        //     html: `${tmpData}`
                                                        // }
                                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                        //     if (_emailError) {
                                                        //         console.log("Welcome Email Not Sent!");
                                                        //     }
                                                        //     else {
                                                        //         console.log("Welcome Email Send Succesfully!");
                                                        //     }
                                                        // });

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Welcome Email', '" + parseBody(tmpData) + "','Welcome Email','16','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                        obj1.prepare();
                                                        obj1.execute((_err: any, __result: any) => {
                                                            if (_err == 1) {
                                                                console.log("Welcome Email Send Succesfully!")
                                                            }
                                                            else {
                                                                console.log("Welcome Email Not Sent");
                                                            }
                                                        });


                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Welcome Email Data!");
                                                }
                                            });
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Welcome Mail Sent Successfully!", status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            console.log("User Information Not Avalilable!");
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "User Information Not Avalilable!", status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    console.log("Account Data Not Available!");
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Account Data Not Available!", status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        });
                    }
                    else {
                        console.log("Onboarding Not Complete or Account Not Available/Invalid Account!");
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Onboarding Not Complete or Account Not Available/Invalid Account!", status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                console.log("Session Not Available!");
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public getBillingAddress(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                // obj.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.idaccount= (SELECT idaccount from user where iduser='" + sessdata.iduser + "') WHERE up.`iduser` = '" + sessdata.iduser + "'";
                obj.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, ba.ein, ba.website, ba.groupExmpt_number, ba.businessName, ba.customerType, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.idaccount= (SELECT idaccount from user where iduser=" + sessdata.iduser + ") WHERE up.`iduser` = " + sessdata.iduser + "";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: result,
                            message: msg,
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public getInvoice(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            let sdata = req.query;
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idinvoice`,`idaccount`,`invoice_number`,`created_at`,`san`,`first_name`,`last_name`,`address1`,`address2`,`city`,`state`,`postal_code`,`country`,`email`,`phone`,`customer_name`,`mrc_cost`,`commission_amount` FROM invoice";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: 0,
                            data: result,
                            message: msg,
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            error: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public updateBillingAddress(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, _sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawNonQuery(req, res);
                let sdata = [];
                sdata = req.body.data;
                let rdata: any = [];
                rdata = req.body.data;
                obj2.nonqrysql = "UPDATE `billing_address` SET `address1`='" + parseBody(rdata.address1) + "', `address2`='" + parseBody(rdata.address2) + "', `city`='" + parseBody(rdata.city) + "', `state`='" + parseBody(rdata.state) + "', `postal_code`='" + rdata.postal_code + "', `country`='" + rdata.country + "' WHERE `idbilling_address` = '" + rdata.idbilling_address + "'";
                obj2.prepare();
                obj2.execute((error: any, allcamp: any) => {
                    if (error == 1) {
                        let obj4 = new ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "UPDATE `user` SET `isAddress`='true' WHERE `iduser`='" + _sessdata.iduser + "'";
                        obj4.prepare();
                        obj4.execute((_error: any, user: any) => {
                            if (_error == 1) {
                                let obj5 = new ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `session` SET `isAddress`='true' WHERE `iduser`='" + _sessdata.iduser + "'";
                                obj5.prepare();
                                obj5.execute((_err: any, user: any) => {
                                    if (_err == 1) {
                                        let obj6 = new ModelRawQuery(req, res);
                                        obj6.qrysql = "SELECT `authkey`,`type`,`iduser`,`username`,`idaccount`,`isEmailVerify`,`isMobileVerify`,`isAddress`,`isPlan`,`isCard`,`newUser_status`,`idtariff` FROM `session` WHERE `authkey`='" + _sessdata.authkey + "'";
                                        obj6.prepare();
                                        obj6.execute((_sessError: any, sessData: any) => {
                                            if (_sessError == 1) {
                                                let obj = new ModelRawQuery(req, res);
                                                obj.qrysql = "SELECT `kyc_verify_status` FROM `user` WHERE `iduser` = '" + _sessdata.iduser + "'";
                                                obj.prepare();
                                                obj.execute((errorr: any, getUser: any) => {
                                                    if (errorr == 1 && getUser.length > 0) {
                                                        let temp1 = "{\"country\": \"" + rdata.country + "\"}";
                                                        let temp2 = JSON.parse(temp1);
                                                        let getUser1 = "{\"kyc_verify_status\": \"" + getUser[0].kyc_verify_status + "\"}";
                                                        let getUser2 = JSON.parse(getUser1);
                                                        let data1: any = Object.assign(sessData[0], temp2, getUser2);
                                                        let objv = new RawView(res);
                                                        objv.prepare({ session: [data1], data: [data1], iduser: _sessdata.iduser, message: "Address Updated Successfully!!", status: 201 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Address Updated Successfully Error With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Address Updated Successfully Error With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: error,
                            message: "Something went wrong with Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public getSupplier(req: Request, res: Response, next: NextFunction) {

        /* let sdata = req.query;
        if (sdata.type == "detail") {
            super.getMethod(req, res, next);
        }
        else { */
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL getSupplier(" + sessdata.iduser + ")";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: msg, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }

                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
        /* } */
    }

    public getSuppliers(req: Request, res: Response, next: NextFunction) {
        /* let sdata = req.query;
        if (sdata.type == "detail") {
            super.getMethod(req, res, next);
        }
        else { */
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, _sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idaccount` as `key`, `username`, `selected`,`did`, `sms`, `voice` FROM `user` WHERE `type`=3";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        /* for (const item of result) {
                            delete item.value;
                        } */
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Supplier Fatched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: _error, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
        /* } */
    }


    // Upload File
    public UploadDocuments(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let objfile = new ModelPdfUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new ModelRawNonQuery(req, res);
                let fileName = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'");
                const filePath = req.protocol + '://' + req.get("host") + "/uploads/" + fileName;
                obj.nonqrysql = "INSERT INTO `upload` (`filename`,`destination_path`,`filetype`,`UserID`)VALUES ('" + fileName + "', '" + filePath + "', '" + req.file.mimetype + "','" + sessdata.iduser + "')";

                obj.prepare();
                obj.execute((_error: any, lastid: any) => {
                    let objv = new RawView(res);
                    let filepath = req.file.filename + fileName;
                    objv.prepare({ message: "File Uploaded Successfully.", insertedid: lastid.insertId, filename: filepath });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /**
     * 
     * 
     * api
     */

    getCompanyProfile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idcompany`,`idaccount`,`company_name`,`ein`,`address`,`city`,`state`,`postal_code`,`website`,`country`,`email`,`phone` FROM `company` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Company Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Profile Details!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        })
    }

    updateCompanyProfile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                if (rdata.idcompany != "") {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `company` SET `company_name`='" + parseBody(rdata.company_name) + "', `ein`='" + parseBody(rdata.ein) + "', `address`='" + parseBody(rdata.address) + "', `city`='" + parseBody(rdata.city) + "', `state`='" + parseBody(rdata.state) + "', `postal_code`='" + parseBody(rdata.postal_code) + "', `website`='" + parseBody(rdata.website) + "', `country`='" + rdata.country + "', `email`='" + rdata.email + "', `phone`='" + rdata.phone + "' WHERE `idcompany` = '" + rdata.idcompany + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                        if (error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({
                                data: allcamp,
                                message: "Company Profile Updated Successfully!",
                                status: 201
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                error: error,
                                message: "Something went wrong With Company Profile Details!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `company` (`idaccount`, `company_name`, `ein`, `phone`, `email`, `address`, `city`, `state`, `country`, `postal_code`, `website`) VALUES ('" + sessdata.idaccount + "', '" + parseBody(rdata.company_name) + "', '" + parseBody(rdata.ein) + "', '" + rdata.phone + "', '" + rdata.email + "', '" + parseBody(rdata.address) + "', '" + parseBody(rdata.city) + "', '" + parseBody(rdata.state) + "', '" + rdata.country + "', '" + rdata.postal_code + "', '" + parseBody(rdata.website) + "')";
                    obj.prepare();
                    obj.execute((_error: any, data: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Company Profile Saved Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong With Company Profile Details!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public ChangePassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = JSON.parse(req.body.data);
                if (sdata.old_password == 'undefined' || sdata.old_password == null) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Password Not Found.", "error": 0 });
                    objv.execute();
                }
                let obj0 = new ModelRawQuery(req, res);
                //obj0.qrysql = "SELECT `password` FROM `user` WHERE `iduser`='" + sessdata.iduser + "' AND `password`='" + sdata.old_password + "'";
                obj0.qrysql = "SELECT `password` FROM `user` WHERE `iduser`='" + sessdata.iduser + "'";
                obj0.prepare();
                obj0.execute((_error: any, result: any) => {
                    let pass1: any = sdata.old_password
                    if (result[0] !== undefined && bcrypt.compareSync(pass1, result[0].password)) {
                        let password1 = bcrypt.hashSync(sdata.confirm_password, 10);
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "CALL ChangePassword(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + result[0].password + "','" + password1 + "')";
                        obj.prepare();
                        obj.execute((__error: any, result: any) => {
                            if (__error == 1) {
                                let obj4 = new ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "UPDATE `user` SET `ext_name`='" + parseBody(sdata.confirm_password) + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj4.prepare();
                                obj4.execute((__error: any, user: any) => {
                                    let obj1 = new ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT up.firstname, up.lastname, up.email,u.username FROM `user` u JOIN user_profile up ON u.iduser = up.iduser WHERE u.iduser = '" + sessdata.iduser + "'";
                                    obj1.prepare();
                                    obj1.execute((Err: any, Res: any) => {
                                        if (Err == 1) {
                                            let obj5 = new ModelRawQuery(req, res);
                                            obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='reset_password'";
                                            obj5.prepare();
                                            obj5.execute((emlErr: any, emlRes: any) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                                        // var smtpTransport = nodemailer.createTransport({
                                                        //     service: "gmail",
                                                        //     host: "smtp.gmail.com",
                                                        //     port: 587,
                                                        //     secure: true,
                                                        //     auth: {
                                                        //         user: "mailto:donotreply@nglcommunications.com",
                                                        //         pass: "yr%5V9GB"
                                                        //     }
                                                        // });
                                                        // var mailOptions = {
                                                        //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                                        //     to: Res[0].email,
                                                        //     usernmae: Res[0].username,
                                                        //     email: Res[0].email,
                                                        //     subject: `${emlRes[0].subject}`,
                                                        //     text: "Thank You For Registration",
                                                        //     html: `${tmpData}`
                                                        // }
                                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                        //     if (_emailError) {
                                                        //         console.log("Opps Email Not Sent!", _emailError);
                                                        //     } else {
                                                        //         console.log("Email Send  Successfully!");
                                                        //         let objv = new RawView(res);
                                                        //         objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                        //         objv.execute();
                                                        //     }
                                                        // });

                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + Res[0].email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Change Password', '" + parseBody(tmpData) + "','Your Password Changed Successfully','5','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                        obj1.prepare();
                                                        obj1.execute((_err: any, __result: any) => {
                                                            console.log("Email Send  Successfully!")
                                                            if (_err == 1) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                console.log("Oops Email Not Sent!");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Template Data Not Found!");
                                                        let objv0 = new RawView(res);
                                                        objv0.prepare({ status: 402, msg: "Template Data Not Found!" });
                                                        objv0.execute();
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with DB!");
                                                    let objv0 = new RawView(res);
                                                    objv0.prepare({ status: 403, msg: "Something Went Wrong with DB!" });
                                                    objv0.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv0 = new RawView(res);
                                            objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                            objv0.execute();
                                        }
                                    });
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    _error: _error,
                                    message: "Something Went Wrong With Connection!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "The old password you have entered is incorrect!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public deleteUserSingleData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from user WHERE iduser = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                if (_error == 1) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "User Deleted Successfully!", data: lastid[0], status: 201 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Connection!", error: _error, status: 502 });
                    objv.execute();
                }
            });
        });
    }

    public deleteUser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, _sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query.id;
                let dData = JSON.parse(sdata);
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL DeleteUser('" + dData.idaccount + "', '" + dData.iduser + "')";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Delete User Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    // Admin Side Delete and Restore
    DeleteCustomerAccount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.body.data ? req.body.data : req.body;
                let isDeleted: any = req.body.data && req.body.data !== undefined ? sdata.isDeleted : '1';
                //let type: any = req.body.data && req.body.data !== undefined ? 'panel' : 'swagger';
                let sesidaccount: any = req.body.data && req.body.data !== undefined ? sdata.sesidaccount : sessdata.idaccount;
                var disDID: any = []; disDID.length = 0; disDID.splice(0, disDID.length);
                var disDIDid: any = []; disDIDid.length = 0; disDIDid.splice(0, disDIDid.length);
                var notdisDID: any = []; notdisDID.length = 0; notdisDID.splice(0, notdisDID.length);
                var notdisDIDid: any = []; notdisDIDid.length = 0; notdisDIDid.splice(0, notdisDIDid.length);
                /* let arrStr: any = '';
                let TotalDays: any; */
                let con: any = "";
                if (isDeleted == 0) // restore
                    con = "`restore_date`=NOW()";
                if (isDeleted == 1) // delete
                    con = "`pending_deleted_date`=NOW()";

                // from panel side hit -> restore account
                if (isDeleted == 0) {
                    let allDID: any = [];
                    let allDIDId: any = [];
                    let allBrandId: any = [];
                    let allCampaign: any = [];
                    let allIdUsers: any = [];
                    // Delete DID
                    let obj0 = new ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='2'";
                    obj0.prepare();
                    obj0.execute((_errorDID: any, resultDID: any) => {
                        if (_errorDID == 1) {
                            
                            let obj11 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `did_log` (`account_id`, `did`, `subscription_auto_renew`, `iduser`, `disconnect_did_status`, `event_type`, `description`) VALUE ";

                            for (let d of resultDID) {
                                allDIDId.push(d.iddid);
                                allDID.push(d.did);
                                qrystr += "('" + sessdata.idaccount + "', '" + d.did + "', 'true', '" + sessdata.iduser + "', 1, 59, 'Bulk DID Deleted Restored'),";
                            }
                            if (allDIDId.length > 0) {
                                // To create bulk log
                                obj11.nonqrysql = qrystr.slice(0, -1);
                                obj11.prepare();
                                obj11.execute((err, data) => {
                                });
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '1', `subscription_auto_renew`='true' WHERE `iddid` IN(" + allDIDId + ")";
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        console.log("All DID Restored", allDIDId);
                                    }
                                });
                            }
                        }
                    });

                    let obju = new ModelRawQuery(req, res);
                    obju.qrysql = "SELECT `iduser` FROM user WHERE `idaccount`=" + sdata.sesidaccount + "";
                    obju.prepare();
                    obju.execute((_uerror: any, iduserRes: any) => {
                        if (iduserRes.length > 0) {
                            for (let u of iduserRes) {
                                allIdUsers.push(u.iduser)
                            }

                            if (allIdUsers.length > 0) {
                                // Delete Campaign
                                let objc = new ModelRawQuery(req, res);
                                objc.qrysql = "SELECT `id_campaign` from campaign WHERE `deleted`= 2 AND `iduser` IN(" + allIdUsers + ")";
                                objc.prepare();
                                objc.execute((_cerror: any, campaignRes: any) => {
                                    if (campaignRes.length > 0) {
                                        for (let c of campaignRes) {
                                            allCampaign.push(c.id_campaign)
                                        }
                                        let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '0' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                        obj1.prepare();
                                        obj1.execute((_errorCamp: any, resultCamp: any) => {
                                            if (resultCamp.length > 0) {
                                                console.log("All Campaign Removed", allCampaign);
                                            }
                                        });
                                    }
                                });
                                // Delete Brand
                                /* let objb = new ModelRawQuery(req, res);
                                objb.qrysql = "SELECT `idbrand` from brand WHERE `deleted`= 2 AND `iduser` IN(" + allIdUsers + ")";
                                objb.prepare();
                                objb.execute((_errB: any, brandRe: any) => {
                                    if (brandRe.length > 0) {
                                        for (let b of brandRe) {
                                            allBrandId.push(b.idbrand)
                                        }
                                        let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '0' WHERE `idbrand` IN(" + allBrandIDs + ")";
                                        obj2.prepare();
                                        obj2.execute((_errorBrand: any, resultBrand: any) => {
                                            if (resultBrand.length > 0) {
                                                console.log("All Brand Removed", allBrandId);
                                            }
                                        });
                                    }
                                }) */
                            }
                        }
                    })

                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `session` SET `isDeleted` = '0' WHERE `idaccount` = " + sesidaccount + "";
                    obj.prepare();
                    obj.execute((__error: any, delSessRes: any) => {
                        console.log("All Session Restored");
                        let obj00 = new ModelRawQuery(req, res);
                        obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sesidaccount + "";
                        obj00.prepare();
                        obj00.execute((____error: any, resultIdEnPoints: any) => {

                            let endPointId: any = [];
                            for (let i of resultIdEnPoints) {
                                endPointId.push(i.idendpoint)
                            }
                            let endPointIds = endPointId.length > 0 ? endPointId : "''";
                            let obj01 = new ModelRawNonQuery(req, res);
                            obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj01.prepare();
                            obj01.execute((_____error: any, resInbound: any) => {
                                console.log("Inbound Restored");
                            })
                            let obj02 = new ModelRawNonQuery(req, res);
                            obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj02.prepare();
                            obj02.execute((_____error: any, resOutbound: any) => {
                                console.log("Outbound Restored");
                            })
                            let obj03 = new ModelRawNonQuery(req, res);
                            obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj03.prepare();
                            obj03.execute((_____error: any, resIp: any) => {
                                console.log("IP Address Removed");
                            })
                            let obj04 = new ModelRawNonQuery(req, res);
                            obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj04.prepare();
                            obj04.execute((_____error: any, resRoute: any) => {
                                console.log("Routing Removed");
                            })
                            let obj05 = new ModelRawNonQuery(req, res);
                            obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                            obj05.prepare();
                            obj05.execute((_____error: any, resHook: any) => {
                                console.log("Hooksetting Removed");
                            })
                        })
                        let obj0 = new ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "UPDATE `api` SET `isDeleted` = '0' WHERE `idaccount` = " + sesidaccount + "";
                        obj0.prepare();
                        obj0.execute((___error: any, delApiRes: any) => {
                            console.log("Api Details Restored");
                            let obj2 = new ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '0' WHERE `idaccount` = " + sesidaccount + "";
                            obj2.prepare();
                            obj2.execute((____error: any, result: any) => {
                                console.log("All Connection Restored");
                                // updation for both side (panel hit and swagger hit)
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = " + sesidaccount + "";
                                obj3.prepare();
                                obj3.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        // if (sdata.selectedoption == "deleteWithAccounting") {
                                        //     let fun = new AccountDelete();
                                        //     fun.closingInvoice(req, res, sdata, next);
                                        // }
                                        // if (sdata.checkbox == true && sdata.selectedoption == "deleteWithoutAccounting") {
                                        //     let mail = new UserManagement();
                                        //     mail.EmailSend(req, res, sdata, next)
                                        // }
                                        // if (sdata.selectedoption == "deleteWithoutAccounting") {
                                        //     let objv = new RawView(res);
                                        //     objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                        //     objv.execute();
                                        // }
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            })
                        })
                    })
                }
                else {
                    // from swagger and panel side hit delete account
                    let objS = new ModelRawQuery(req, res);
                    objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`=" + sesidaccount + "";
                    objS.prepare();
                    objS.execute((errKey: any, delKey: any) => {
                        if (errKey == 1) {
                            if (delKey.length > 0) {
                                for (let x of delKey) {
                                    sessiondata.delete(x.authKey)
                                }
                            }
                        }
                    });
                    if (sessdata.type == 1) {
                        let obj7 = new ModelRawNonQuery(req, res);
                        obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                        obj7.prepare();
                        obj7.execute((__error: any, delSessRes: any) => {
                            console.log("All Session Removed");
                            let obj00 = new ModelRawQuery(req, res);
                            obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sesidaccount + "";
                            obj00.prepare();
                            obj00.execute((____error: any, resultIdEnPoint: any) => {
                                let endPointId: any = [];
                                for (let i of resultIdEnPoint) {
                                    endPointId.push(i.idendpoint)
                                }
                                let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                let obj01 = new ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj01.prepare();
                                obj01.execute((_____error: any, resInbound: any) => {
                                    console.log("Inbound Removed");
                                })
                                let obj02 = new ModelRawNonQuery(req, res);
                                obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj02.prepare();
                                obj02.execute((_____error: any, resOutbound: any) => {
                                    console.log("Outbound Removed");
                                })

                                let obj03 = new ModelRawNonQuery(req, res);
                                obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj03.prepare();
                                obj03.execute((_____error: any, resIp: any) => {
                                    console.log("IP Address Removed");
                                })
                                let obj04 = new ModelRawNonQuery(req, res);
                                obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj04.prepare();
                                obj04.execute((_____error: any, resRoute: any) => {
                                    console.log("Routing Removed");
                                })
                                let obj05 = new ModelRawNonQuery(req, res);
                                obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj05.prepare();
                                obj05.execute((_____error: any, resHook: any) => {
                                    console.log("Hooksetting Removed");
                                })
                            })

                            let obj8 = new ModelRawNonQuery(req, res);
                            obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                            obj8.prepare();
                            obj8.execute((___error: any, delApiRes: any) => {
                                console.log("Api Details Removed");
                                let obj9 = new ModelRawNonQuery(req, res);
                                obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                obj9.prepare();
                                obj9.execute((____error: any, result: any) => {
                                    console.log("All Connection Removed");
                                })
                            })
                        })
                        //updation for both side (panel hit and swagger hit)
                        let obj10 = new ModelRawNonQuery(req, res);
                        obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = " + sesidaccount + "";
                        obj10.prepare();
                        obj10.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                if (sdata.selectedoption == "deleteWithAccounting") {
                                    let fun = new AccountDelete();
                                    fun.closingInvoice(req, res, sdata, next);
                                }
                                if (sdata.checkbox == true && sdata.selectedoption == "deleteWithoutAccounting") {
                                    let mail = new UserManagement();
                                    mail.EmailSend(req, res, sdata, next)
                                }
                                if (sdata.selectedoption == "deleteWithoutAccounting") {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else if (sessdata.type == 2) {
                        let Obj4 = new ModelRawQuery(req, res);
                        Obj4.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount`=" + sesidaccount + " AND (`balance` + `credit_limit`) >= 0";
                        Obj4.prepare();
                        Obj4.execute((crErr: any, crRes) => {
                            if (crErr == 1 && crRes.length > 0) {
                                let obj5 = new ModelRawQuery(req, res);
                                obj5.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sesidaccount + "' AND `disconnect_did_status`='1'";
                                obj5.prepare();
                                obj5.execute((_errorDID: any, resultDID: any) => {
                                    let DIDIds: any = [];
                                    for (let x of resultDID) {
                                        DIDIds.push(x.iddid)
                                    }
                                    let didid = DIDIds.length > 0 ? DIDIds : "''";
                                    let obj6 = new ModelRawQuery(req, res);
                                    obj6.qrysql = "SELECT t.day_num,d.iddid,d.created_at,d.did,d.did_disconnect_days, DATEDIFF(NOW(), d.`created_at`) AS remaining_days FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid IN(" + didid + ")";
                                    obj6.prepare();
                                    obj6.execute((errday: any, resday: any) => {
                                        if (errday == 1) {
                                            if (resday.length > 0) {
                                                for (let y of resday) {
                                                    /* let did_buy_date = y.created_at;
                                                    let today_date: any = new Date();
                                                    const oneDay = 1000 * 60 * 60 * 24;
                                                    const diffInTime = today_date.getTime() - did_buy_date.getTime();
                                                    TotalDays = Math.round(diffInTime / oneDay);
                                                    if (TotalDays) {
                                                        if (TotalDays > y.day_num) {
                                                            disDID.push(y.did);
                                                            disDIDid.push(y.iddid);
                                                        } else {
                                                            notdisDID.push(y.did);
                                                            notdisDIDid.push(y.iddid);
                                                        }
                                                    } */
                                                    if (y.remaining_days >= y.did_disconnect_days) {
                                                        disDID.push(y.did);
                                                        disDIDid.push(y.iddid);
                                                    } else {
                                                        notdisDID.push(y.did);
                                                        notdisDIDid.push(y.iddid);
                                                    }
                                                }
                                                if (notdisDIDid.length > 0) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        status: 502, message: "This account cannot be deleted because [" + notdisDID.length + "] DIDs Are Active and [" + disDIDid.length + "] DIDs are inActive.",
                                                        data: { notDisconnectDid: { message: "Not Disconnected DIDs Data", didCount: notdisDID.length, did: notdisDID }, disconnectDid: { message: "Disconnected DIDs Data", didCount: disDID.length, did: disDID } }
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let obj7 = new ModelRawNonQuery(req, res);
                                                obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                                obj7.prepare();
                                                obj7.execute((__error: any, delSessRes: any) => {
                                                    console.log("All Session Removed");
                                                    let obj00 = new ModelRawQuery(req, res);
                                                    obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sesidaccount + "";
                                                    obj00.prepare();
                                                    obj00.execute((____error: any, resultIdEnPoint: any) => {
                                                        let endPointId: any = [];
                                                        for (let i of resultIdEnPoint) {
                                                            endPointId.push(i.idendpoint)
                                                        }
                                                        let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                                        let obj01 = new ModelRawNonQuery(req, res);
                                                        obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj01.prepare();
                                                        obj01.execute((_____error: any, resInbound: any) => {
                                                            console.log("Inbound Removed");
                                                        })
                                                        let obj02 = new ModelRawNonQuery(req, res);
                                                        obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj02.prepare();
                                                        obj02.execute((_____error: any, resOutbound: any) => {
                                                            console.log("Outbound Removed");
                                                        })
                                                        let obj03 = new ModelRawNonQuery(req, res);
                                                        obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj03.prepare();
                                                        obj03.execute((_____error: any, resIp: any) => {
                                                            console.log("IP Address Removed");
                                                        })
                                                        let obj04 = new ModelRawNonQuery(req, res);
                                                        obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj04.prepare();
                                                        obj04.execute((_____error: any, resRoute: any) => {
                                                            console.log("Routing Removed");
                                                        })
                                                        let obj05 = new ModelRawNonQuery(req, res);
                                                        obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                        obj05.prepare();
                                                        obj05.execute((_____error: any, resHook: any) => {
                                                            console.log("Hooksetting Removed");
                                                        })
                                                    })

                                                    let obj8 = new ModelRawNonQuery(req, res);
                                                    obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                                    obj8.prepare();
                                                    obj8.execute((___error: any, delApiRes: any) => {
                                                        console.log("Api Details Removed");
                                                        let obj9 = new ModelRawNonQuery(req, res);
                                                        obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                                        obj9.prepare();
                                                        obj9.execute((____error: any, result: any) => {
                                                            console.log("All Connection Removed");
                                                        })
                                                    })
                                                })
                                                //updation for both side (panel hit and swagger hit)
                                                let obj10 = new ModelRawNonQuery(req, res);
                                                obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = " + sesidaccount + "";
                                                obj10.prepare();
                                                obj10.execute((_error: any, result: any) => {
                                                    if (_error == 1) {
                                                        if (sdata.selectedoption == "deleteWithAccounting") {
                                                            let fun = new AccountDelete();
                                                            fun.closingInvoice(req, res, sdata, next);
                                                        }
                                                        if (sdata.checkbox == true && sdata.selectedoption == "deleteWithoutAccounting") {
                                                            let mail = new UserManagement();
                                                            mail.EmailSend(req, res, sdata, next)
                                                        }
                                                        if (sdata.selectedoption == "deleteWithoutAccounting") {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "DID Not Fetched!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                });

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Account Balance is Low!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "You have not access to Delete Account!", status: 502 });
                        objv.execute();
                    }
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    EmailSend(req: Request, res: Response, sdata: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession(async (error: any, sessdata: any) => {
            if (error == 1) {
                let objem = new ModelRawQuery(req, res);
                objem.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type` = 'close_account'";
                objem.prepare();
                objem.execute((____errorem: any, _resultem: any) => {
                    if (____errorem == 1 && _resultem.length > 0) {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT firstname , lastname, email FROM `user_profile` WHERE iduser = '" + sdata.sesiduser + "'";
                        obj1.prepare();
                        obj1.execute((____errorup: any, _resultup: any) => {
                            if (____errorup == 1) {
                                const formattedTemplate = _resultem[0].template
                                    .replace('{FIRST_NAME}', _resultup[0].firstname)
                                    .replace('{LAST_NAME}', _resultup[0].lastname)

                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sdata.sesiduser + "','" + sdata.sesidaccount + "','" + FromEmail + "','" + _resultup[0].email + "', '" + parseBody(_resultem[0].subject) + "','" + parseBody(formattedTemplate) + "','Account Deleted From Admin','26','" + _resultem[0].cc + "','" + _resultem[0].bcc + "')";
                                obj1.prepare();
                                obj1.execute((_err: any, __result: any) => {
                                    if (_err == 1) {
                                        console.log("Email Sent Succesfully!");
                                    }
                                    else {
                                        console.log("Opps Email Not Sent!");
                                    }
                                });
                            }
                            else {
                                console.log('Account Profile Not Found at the Time Closing Invoice');
                            }
                        });
                    }
                    else {
                        console.log('Live Payment Email Template Not Found at the Time Closing Invoice');
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    DeleteAccount(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let allDID: any = [];
                let allDIDId: any = [];
                let allBrandId: any = [];
                let allCampaign: any = [];
                let allIdUsers: any = [];

                // Delete DID
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='1'";
                obj0.prepare();
                obj0.execute((_errorDID: any, resultDID: any) => {
                    if (_errorDID == 1) {
                        for (let d of resultDID) {
                            allDIDId.push(d.iddid);
                            allDID.push(d.did);
                        }
                        if (allDIDId.length > 0) {
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '2' WHERE `iddid` IN(" + allDIDId + ")";
                            obj1.prepare();
                            obj1.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    console.log("All DID Removed", allDIDId);
                                }
                            });
                        }
                    }
                });


                let obju = new ModelRawQuery(req, res);
                obju.qrysql = "SELECT `iduser` from user WHERE `idaccount`='" + sdata.sesidaccount + "'";
                obju.prepare();
                obju.execute((_uerror: any, iduserRes: any) => {
                    if (iduserRes.length > 0) {
                        for (let u of iduserRes) {
                            allIdUsers.push(u.iduser)
                        }

                        if (allIdUsers.length > 0) {
                            // Delete Campaign
                            let objc = new ModelRawQuery(req, res);
                            objc.qrysql = "SELECT `id_campaign` from campaign WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objc.prepare();
                            objc.execute((_cerror: any, campaignRes: any) => {
                                if (campaignRes.length > 0) {
                                    for (let c of campaignRes) {
                                        allCampaign.push(c.id_campaign)
                                    }
                                    let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '2' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                    obj1.prepare();
                                    obj1.execute((_errorCamp: any, resultCamp: any) => {
                                        if (resultCamp.length > 0) {
                                            console.log("All Campaign Removed", allCampaign);
                                        }
                                    });
                                }
                            });
                            // Delete Brand
                            let objb = new ModelRawQuery(req, res);
                            objb.qrysql = "SELECT `idbrand` from brand WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objb.prepare();
                            objb.execute((_errB: any, brandRe: any) => {
                                if (brandRe.length > 0) {
                                    for (let b of brandRe) {
                                        allBrandId.push(b.idbrand)
                                    }
                                    let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                    let obj2 = new ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '2' WHERE `idbrand` IN(" + allBrandIDs + ")";
                                    obj2.prepare();
                                    obj2.execute((_errorBrand: any, resultBrand: any) => {
                                        if (resultBrand.length > 0) {
                                            console.log("All Brand Removed", allBrandId);
                                        }
                                    });
                                }
                            })
                        }
                    }
                })


                // add here delete feature for session,api and connection.
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `session` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                obj.prepare();
                obj.execute((__error: any, delSessRes: any) => {
                    console.log("All Session Remove");
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                    obj0.prepare();
                    obj0.execute((___error: any, delApiRes: any) => {
                        console.log("Api Details Remove");
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                        obj1.prepare();
                        obj1.execute((____error: any, result: any) => {
                            console.log("All Connection Remove");
                        })
                    })
                })

                // closed here
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + sdata.isDeleted + "', `deleted_date`=NOW() WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                obj2.prepare();
                obj2.execute((_errorDEL: any, resultDEL: any) => {
                    if (_errorDEL == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: allDID, message: "Account Successfully Deleted!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Release DID From Account Delete Process!", status: 502 });
                        objv.execute();
                    }
                });

                let obj00 = new ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                obj00.prepare();
                obj00.execute((____error: any, resultIdEnPoint: any) => {
                    let endPointId: any = [];
                    for (let i of resultIdEnPoint) {
                        endPointId.push(i.idendpoint)
                    }
                    let endPointIds = endPointId.length > 0 ? endPointId : "''";
                    let obj01 = new ModelRawNonQuery(req, res);
                    obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj01.prepare();
                    obj01.execute((_____error: any, resInbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Inbound Restored");
                        }
                        else {
                            console.log("Inbound Removed");
                        }
                    })
                    let obj02 = new ModelRawNonQuery(req, res);
                    obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj02.prepare();
                    obj02.execute((_____error: any, resOutbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Outbound Restored");
                        }
                        else {
                            console.log("OutBound Removed");
                        }
                    })
                })
                let obj03 = new ModelRawNonQuery(req, res);
                obj03.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                obj03.prepare();
                obj03.execute((____error: any, result: any) => {

                })



            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /* * * * * * * * * *
     * To check balance 
     */
    checkBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((errorSes: any, sessData: any) => {
            if (errorSes == 1) {
                let data: any = req.query;
                let um = new UserManagement();
                um.getSessData(req, res, data.apiKey, next, (err, idacc) => {
                    if (err == 1 && idacc) {
                        let base = new APIBase();
                        base.checkSwaggerBalance(req, res, idacc, (errorR, resR) => {
                            if (errorR == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ status: 200, message: "Available Balance", data: { balance: resR.balance } });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 403, message: "Balance not found!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 404, message: "apiKey not found!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        })
    }

    getSessData(req: Request, res: Response, akey: any, next: NextFunction, callback: (error: any, data: any) => void) {
        if (sessiondata.has(akey)) {
            let currSess = sessiondata.get(akey);
            callback(1, currSess.idaccount)
        }
        else {
            if (invalidsessdata.has(akey)) {
                callback(0, '')
            }
            else {
                let obj00 = new ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `isCard`, `newUser_status`, `idapi`, `isAddress`, `isPlan`, `tz_diff`, `server_time`, `client_time`, `sessionType`, `authkey` FROM `session` WHERE `isDeleted`=0 AND `authkey` = '" + akey + "'";
                obj00.prepare();
                obj00.execute((err: any, res: any) => {
                    if (err == 1 && res.length > 0) {
                        sessiondata.set(akey, res[0]);
                        callback(1, res[0].idaccount)
                    }
                    else {
                        invalidsessdata.set(akey, '');
                        callback(0, '')
                    }
                });
            }
        }
    }

    // public TaxAuthentication(req: Request, res: Response, next: NextFunction) {
    //     console.log(req.body.data);
    //     let sdata = req.body.data
    //     var request = require('request');
    //     var options = {
    //         'method': 'POST',
    //         'url': sdata.url,
    //         'headers': {
    //             'Content-Type': 'application/json'
    //         },
    //         body: JSON.stringify(sdata.data)
    //     };
    //     request(options, function (error: any, response: any) {
    //         console.log(response.body)
    //         let objv = new RawView(res);
    //         objv.prepare(response.body);
    //         objv.execute();
    //     });
    // }

    public TaxCalculation(req: Request, res: Response, _next: NextFunction) {
        let sdata = req.body.data
        var request = require('request');
        var options = {
            'method': 'POST',
            'url': 'http://localhost/avatax/php/trunk/charges/cal_taxaxtion',
            'headers': {
                'Content-Type': 'application/json',
                'Cookie': 'AuthToken=' + sdata.data.token
            },
            body: JSON.stringify(sdata.data)
        };
        request(options, function (_error: any, response: any) {
            if (!_error) {
                try {
                    let objv = new RawView(res);
                    objv.prepare(response.body);
                    objv.execute();
                }
                catch (e) {
                    console.log("Error :: TaxCalculation::", e);
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawView(res);
                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                obj.execute();
            }
        });
    }

    /* public detailsCDR(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT * FROM cdr WHERE date1 = '" + sdata.from_date + "' AND date2= '" + sdata.to_date + "' AND ani= '" + sdata.from_ani + "' AND did= '" + sdata.to_did + "' AND callid= '" + sdata.call_id + "' ";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                let objv = new RawView(res);
                objv.prepare({ message: "Fetched Data Successfully!", data: lastid[0] });
                objv.execute();
            });
        });
    } */

    public apiToken(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const key = Str.random(30);
                var rdata: any = req.body.data;
                let rStatus: any = rdata.status == '' || rdata.status == 'Null' || rdata.status == null ? false : rdata.status;
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `name`,`key` FROM `api` where `name` = '" + parseBody(rdata.name) + "' AND `iduser` = '" + rdata.user + "'";
                obj1.prepare();
                obj1.execute((_error: any, getConn: any) => {
                    if (getConn[0]) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Token Already Exists at This Account!",
                            status: 404
                        });
                        objv.execute();
                    }
                    else {
                        let iduser: any = (sessdata.type == 2 || sessdata.type == 201) ? rdata.user : sessdata.iduser;
                        let idaccount: any = (sessdata.type == 2 || sessdata.type == 201) ? rdata.account : sessdata.idaccount;
                        let idtariff: any = (sessdata.type == 2 || sessdata.type == 201) && rdata.idtariff !== undefined && rdata.idtariff !== null ? rdata.idtariff : sessdata.idtariff;

                        if (idtariff < 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "There is no tariff selected in this account. please contact to administration.", status: 501
                            });
                            objv.execute();
                            return;
                        }
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `password`, `type`, `default`, `idtariff`, `isEmailVerify`, `isMobileVerify`, `isAddress`, `isPlan`, `isCard`,  `newUser_status`, `resetPassword`, `kyc_verify_status`, `is_deleted`,`status` FROM `user` WHERE `iduser` = '" + iduser + "'";
                        obj.prepare();
                        obj.execute((errorr: any, getUser: any) => {
                            if (errorr == 1 && getUser.length > 0) {
                                let Status: any = getUser[0].status == '' || getUser[0].status == 'Null' || getUser[0].status == null ? false : getUser[0].status;
                                let obj5 = new ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "INSERT INTO `api` (`idaccount`, `iduser`, `idtariff`, `name`, `key`, `path`,`isDeleted`) VALUES(" + idaccount + ", " + iduser + ", " + setToZero(idtariff) + " ,'" + parseBody(rdata.name) + "', '" + key + "', '" + rStatus + "', '" + getUser[0].is_deleted + "')";
                                obj5.prepare();
                                obj5.execute((eerror: any, result: any) => {
                                    if (eerror == 1) {
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "INSERT INTO `session` (`iduser`, `idaccount`, `username`,`password`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`,  `newUser_status`, `resetPassword`, `kyc_verify_status`, `isDeleted`, `tz_diff`, `server_time`, `client_time`, `sessionType`) VALUES(" + iduser + ", " + idaccount + ", '" +parseBody(getUser[0].username) + "', '" + getUser[0].password + "', '" + getUser[0].type + "', '" + getUser[0].default + "', " + setToZero(idtariff) + ", '" + key + "', '" + Status + "', '" + getUser[0].isEmailVerify + "', '" + getUser[0].isMobileVerify + "', '" + setToZero(result.insertId) + "', '" + getUser[0].isAddress + "', '" + getUser[0].isPlan + "', '" + getUser[0].isCard + "', '" + getUser[0].newUser_status + "', '" + getUser[0].resetPassword + "', '" + getUser[0].kyc_verify_status + "', '" + getUser[0].is_deleted + "', '" + sessdata.tz_diff + "', '" + sessdata.server_time + "', '" + sessdata.client_time + "', 'API')";
                                        obj2.prepare();
                                        obj2.execute((error: any, resultSess: any) => {
                                            if (error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: 201, message: "Token Saved Successfully."
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: 503, message: "Token Not Saved!"
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            status: 502, message: "Something Went Wrong With API Token!"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        });
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public getApiToken(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj5 = new ModelRawQuery(req, res);

                let con: any = '';
                if (sessdata.type == 22)
                    con += "`iduser`=" + sessdata.iduser + " AND ";
                if (sessdata.type == 2 || sessdata.type == 201)
                    con += "`idaccount`=" + sessdata.idaccount + " AND ";
                if (sessdata.type == 1)
                    con = '';

                obj5.qrysql = "SELECT `idapi`,`name`,`key`,`created` FROM `api` WHERE " + con + " isDeleted='0'";
                obj5.prepare();
                obj5.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Token Fetched Successfully!",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "No Data Found!",
                                status: 404
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });

            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public deleteApiToken(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessData: any) => {
            if (error == 1) {
                let data: any = req.query.id;
                sessiondata.delete(data.split('@')[1]); // deleting key from sessiondata
                let obj1 = new ModelRawNonQuery(req, res);
                obj1.nonqrysql = "delete from `session` where `authKey` = (select `key` from `api` where `idapi`='" + data.split('@')[0] + "')";
                obj1.prepare();
                obj1.execute((_errorKey: any, resultKey: any) => {
                    if (_errorKey) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "delete from `api` WHERE `idapi` = '" + data.split('@')[0] + "'";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Api Key Deleted Successfully!", data: result, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Data not deleted!", data: result, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Data not deleted from session", status: 502 });
                        objv.execute();
                    }

                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    saveTheme(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "INSERT into `theme` (`idaccount`, `brandName`, `domain`, `customLogo`, `email`, `phone`, `support_url`, `header_color`, `navbar_color`, `sidebar_color`, `ssl_certificate`, `ssl_key`) VALUES('" + sessdata.idaccount + "', '" + rdata.brandName + "', '" + rdata.domain + "', '" + rdata.custom_logo + "', '" + rdata.email + "', '" + rdata.phone + "', '" + rdata.support_url + "', '" + rdata.header_color + "', '" + rdata.navbar_color + "', '" + rdata.sidebar_color + "', '" + rdata.ssl_certificate + "', '" + rdata.ssl_key + "')";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Theme Saved Successfully!" });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Successfully!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    updateTheme(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let filePath: any;
                let rdata: any = [];
                rdata = JSON.parse(req.body.data);
                if (req.file) {
                    const fileName = req.file.filename;
                    filePath = "https://api.signalmash.com/uploads/" + fileName;
                }
                else if (rdata.logo == undefined || rdata.logo == null) {
                    filePath = "./assets/img/logo.png";
                }
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.filter = null;
                obj2.nonqrysql = "UPDATE `theme` SET `brandName`='" + rdata.brandName + "', `domain`='" + rdata.domain + "', `customLogo`='" + filePath + "', `email`='" + rdata.email + "', `phone`='" + rdata.phone + "', `support_url`='" + rdata.support_url + "', `header_color`='" + rdata.header_color + "', `navbar_color`='" + rdata.navbar_color + "', `sidebar_color`='" + rdata.sidebar_color + "', `ssl_certificate`='" + rdata.ssl_certificate + "', `ssl_key`='" + rdata.ssl_key + "' WHERE `id_theme`='" + rdata.id_theme + "'";
                obj2.prepare();
                obj2.execute((error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        error: 0,
                        data: allcamp,
                        message: "Theme Updated Successfully"
                    })
                    objv.execute();
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getThemes(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id_theme`,`idaccount`,`brandName`,`domain`,`customLogo`,`email`,`phone`,`support_url`,`header_color`,`navbar_color`,`navbar_color`,`sidebar_color`,`ssl_certificate`,`ssl_key` FROM `theme` WHERE `idaccount` = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Theme data Fetched!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "NO Data Found!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getTheme(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "select `id_theme`,`idaccount`,`brandName`,`domain`,`customLogo`,`email`,`phone`,`support_url`,`header_color`,`navbar_color`,`navbar_color`,`sidebar_color`,`ssl_certificate`,`ssl_key` from theme where id_theme='" + req.query.type + "' AND idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Theme data Fetched!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    deleteTheme(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "delete from `theme` WHERE `id_theme` = '" + req.query.id + "' AND idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Theme Deleted Successfully!", data: result });
                    objv.execute();
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    saveOtp(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sysInfo = ipAddressAndBrowser(req);
                let sdata = req.body;

                let verification_through: any
                let verification_via: any = 0;
                if (sdata.otp) {
                    verification_through = 1;
                } else {
                    verification_through = 0;
                }

                let otp = Math.floor(100000 + Math.random() * 900000);
                sdata.otp = otp;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `ip_address`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `contact` = '" + sdata.TO.trim() + "'";
                obj.prepare();
                obj.execute((_errDomainBlk: any, getDomainBlock: any) => {
                    if (_errDomainBlk == 1 && getDomainBlock.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Invalid Account Registration!",
                            status: 501
                        });
                        objv.execute();
                    }
                    else {
                        let obj4 = new ModelRawQuery(req, res);
                        obj4.qrysql = "SELECT `firstname`,`lastname` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                        obj4.prepare();
                        obj4.execute((_error: any, user: any) => {
                            let getUser = user[0];
                            if (error == 1) {
                                let obj5 = new ModelRawQuery(req, res);
                                obj5.qrysql = "SELECT `body` FROM `sms_template` WHERE type='mobile_verification'";
                                obj5.prepare();
                                obj5.execute((emlErr: any, emlRes: any) => {
                                    if (emlErr == 1 && emlRes.length > 0) {
                                        let BODY = emlRes[0].body;
                                        BODY = BODY.replace(/{FIRST_NAME}/g, getUser.firstname);
                                        BODY = BODY.replace(/{LAST_NAME}/g, getUser.lastname);
                                        BODY = BODY.replace(/{OTP}/g, sdata.otp);
                                        let key = Str.random(30);
                                        var headers = {
                                            'accept': '*/*',
                                            'Authorization': 'qzcLAGsUh-V8J57xNrFOJiBpZQCHEz',
                                            'Content-Type': 'application/x-www-form-urlencoded'
                                        };
                                        var dataString = 'FROM=' + sdata.FROM.trim() + '&TO=' + sdata.TO.trim() + '&BODY=' + BODY + '&Connection=&OutboundSMS=';
                                        var options = {
                                            url: 'https://api.signalmash.com/sms',
                                            method: 'POST',
                                            headers: headers,
                                            body: dataString
                                        }
                                        request(options, (sms_err: any, sms_responce: any) => {
                                            let sms_resp = JSON.parse(sms_responce.body);
                                            if (sms_resp.status == 201) {
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `two_factor_auth` (`iduser`, `otp`, `from`, `to`, `session_id`) VALUES(" + sessdata.iduser + ", " + setToZero(sdata.otp) + ", '" + sdata.FROM + "', '" + sdata.TO + "', '" + key + "')";
                                                obj.prepare();
                                                obj.execute((mdr_err: any, mdr_resp: any) => {
                                                    if (mdr_err == 1) {
                                                        let obj = new RawView(res);
                                                        obj.prepare({ result: "Success", data: mdr_resp, message: "OTP Sent Successfully", status: 201 });
                                                        obj.execute();
                                                    }
                                                    else {
                                                        let obj = new RawView(res);
                                                        obj.prepare({ result: "Failed", message: "Something Went Wrong with Connection!", status: 502 });
                                                        obj.execute();
                                                    }
                                                })
                                            }
                                            else {
                                                let obj = new RawView(res);
                                                obj.prepare({ message: sms_resp.message, status: 503 });
                                                obj.execute();
                                            }
                                        });
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare("SMS Template not Fateched Successfully!");
                                        objv.execute();
                                    }
                                })
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare("User not Fateched Successfully!");
                                objv.execute();
                            }
                        })
                    }
                });


                let objj0 = new ModelRawNonQuery(req, res);
                objj0.nonqrysql = "INSERT INTO `phone_verification_log` (`iduser`,`idaccount`,`did`,`ipaddress`,`verification_through`,`verification_via`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + sdata.TO.trim() + "','" + sysInfo.ipAddress[0] + "','" + setToZero(verification_through) + "','" + setToZero(verification_via) + "')";
                objj0.prepare();
                objj0.execute((_error: any, getresotp: any) => {
                    console.log("Log Inserted Successfully!");
                });

            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /* verifyOtp(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                //obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = '" + sessdata.iduser + "' AND `otp`='" + sdata.otp + "' AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300";
                obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = " + sessdata.iduser + " AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300 ORDER BY id DESC LIMIT 1";
                obj.prepare();
                obj.execute((error: any, getEmail: any) => {
                    if (error == 1) {
                        if (getEmail.length > 0 && getEmail[0].otp == sdata.otp) {
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`= 'true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                            obj1.prepare();
                            obj1.execute((_error: any, success: any) => {
                                if (_error == 1) {
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj5.prepare();
                                    obj5.execute((_sessErr: any, sessRes: any) => {
                                        if (_sessErr == 1) {
                                            let obj6 = new ModelRawNonQuery(req, res);
                                            obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                            obj6.prepare();
                                            obj6.execute((_sessError: any, sessData: any) => {
                                                let objup = new ModelRawQuery(req, res);
                                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                                objup.prepare();
                                                objup.execute((__errorE: any, emailE: any) => {
                                                    if (_sessError == 1) {
                                                        let obj7 = new ModelRawQuery(req, res);
                                                        obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                        obj7.prepare();
                                                        obj7.execute((sError: any, sData: any) => {
                                                            if (sError == 1) {

                                                                let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                                                                let emType = JSON.parse(tmp);
                                                                let sData1: any = Object.assign(sData, emType);
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    message: "OTP Verified Successfully!",
                                                                    status: 200,
                                                                    session: sData1
                                                                });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    message: "OTP verified error with connection!",
                                                                    status: 502
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            message: "Mobile number not verified!",
                                                            status: 500
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                errMessage: "Mobile number not verified!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Mobile number not verified!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "You have enter wrong OTP!",
                                status: 502
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something went wrong with connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    } */
    verifyOtp(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err === 1) {
                let sdata = req.body;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `country` FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_err: any, result: any) => {
                    if (_err === 1) {
                        let country = result[0]?.country || '';
                        if (!['US', 'CA', 'USA', 'UNITED STATES', 'CANADA'].includes(country)) {
                            let objup = new ModelRawQuery(req, res);
                            objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                            objup.prepare();
                            objup.execute((__errorE: any, emailE: any) => {
                                if (__errorE === 1) {
                                    let obj7 = new ModelRawQuery(req, res);
                                    obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                    obj7.prepare();
                                    obj7.execute((sError: any, sData: any) => {
                                        if (sError === 1) {
                                            let emails = emailE[0]?.email || '';
                                            let data1 = { ...sData[0], email: emails, country };
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Your address is updated from admin side, refresh your page.",
                                                status: 505,
                                                session: data1
                                            });
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Session data retrieval failed!",
                                                status: 505
                                            });
                                            objv.execute();
                                        }
                                    });
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Email retrieval error!",
                                        status: 505
                                    });
                                    objv.execute();
                                }
                            });

                        } else {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = " + sessdata.iduser + " AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300 ORDER BY id DESC LIMIT 1";
                            obj.prepare();
                            obj.execute((error: any, getEmail: any) => {
                                if (error === 1 && getEmail.length > 0 && getEmail[0].otp == sdata.otp) {
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`='true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj1.prepare();
                                    obj1.execute((_error: any, success: any) => {
                                        if (_error === 1) {
                                            let obj5 = new ModelRawNonQuery(req, res);
                                            obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                            obj5.prepare();
                                            obj5.execute((_sessErr: any, sessRes: any) => {
                                                if (_sessErr === 1) {
                                                    let obj6 = new ModelRawNonQuery(req, res);
                                                    obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                                    obj6.prepare();
                                                    obj6.execute((_sessError: any, sessData: any) => {
                                                        if (_sessError === 1) {
                                                            let objup = new ModelRawQuery(req, res);
                                                            objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                                            objup.prepare();
                                                            objup.execute((__errorE: any, emailE: any) => {
                                                                if (__errorE === 1) {
                                                                    let obj7 = new ModelRawQuery(req, res);
                                                                    obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                                    obj7.prepare();
                                                                    obj7.execute((sError: any, sData: any) => {
                                                                        if (sError === 1) {
                                                                            let emType = { email: emailE[0].email };
                                                                            let sData1 = Object.assign(sData[0], emType);
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({
                                                                                message: "OTP Verified Successfully!",
                                                                                status: 200,
                                                                                session: sData1
                                                                            });
                                                                            objv.execute();
                                                                        } else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({
                                                                                message: "OTP verified error with connection!",
                                                                                status: 502
                                                                            });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                } else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({
                                                                        message: "Failed to retrieve email!",
                                                                        status: 502
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({
                                                                message: "Mobile number update failed!",
                                                                status: 502
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        message: "Mobile number not verified!",
                                                        status: 502
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Failed to update user verification status!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Invalid or expired OTP!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });

                        }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Failed to fetch country!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    resendEmail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let secret = Str.random(15);
                let validationKey = jwt.sign({
                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                    data: sessdata.email + sessdata.password
                }, secret);
                let obj3 = new ModelRawNonQuery(req, res);
                obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "', `secret`='" + secret + "', `email_verification_date`=NOW() WHERE `iduser`='" + sessdata.iduser + "' AND  `is_deleted`=0";
                obj3.prepare();
                obj3.execute((_err: any, __result: any) => {
                    if (_err == 1) {
                        if (__result.affectedRows > 0) {
                            let obj4 = new ModelRawQuery(req, res);
                            obj4.qrysql = "SELECT `firstname`,`lastname`,`email` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";

                            obj4.prepare();
                            obj4.execute((_error: any, user: any) => {
                                let getUser = user[0];
                                if (_err == 1) {
                                    let obj5 = new ModelRawQuery(req, res);
                                    obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE type='email_verification'";
                                    obj5.prepare();
                                    obj5.execute((emlErr: any, emlRes: any) => {
                                        if (emlErr == 1) {
                                            if (emlRes.length > 0) {
                                                let tmpData = emlRes[0].template;
                                                tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                                                // var smtpTransport = nodemailer.createTransport({
                                                //     service: "gmail",
                                                //     host: "smtp.gmail.com",
                                                //     port: 587,
                                                //     secure: true,
                                                //     auth: {
                                                //         user: "donotreply@nglcommunications.com",
                                                //         pass: "yr%5V9GB"
                                                //     }
                                                // });
                                                // var mailOptions = {
                                                //     from: 'Signalmash <donotreply@signalmash.com>',
                                                //     to: getUser.email,
                                                //     usernmae: getUser.email,
                                                //     email: getUser.email,
                                                //     subject: `${emlRes[0].subject}`,
                                                //     text: "Thank You For Registration",
                                                //     html: `${tmpData}`
                                                // }
                                                // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                //     if (_emailError) {
                                                //         let objv = new RawView(res);
                                                //         objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!", error: _emailError });
                                                //         objv.execute();
                                                //     } else {
                                                //         let objv = new RawView(res);
                                                //         objv.prepare({ iduser: sessdata.iduser, status: 201, data: emailRes, message: "Email Send Succesfully!" });
                                                //         objv.execute();
                                                //     }
                                                // });
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Resend Mail Send for Not Getting Mail Previously', '" + parseBody(tmpData) + "','Resend Mail Send successfully','6','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                obj1.prepare();
                                                obj1.execute((_err: any, __result: any) => {
                                                    console.log("Email Send Succesfully!")
                                                    if (_err == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ iduser: sessdata.iduser, status: 201, message: "Email Send Succesfully!" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        console.log("Error In Updating Password!");
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 401, errMessage: "Templating Data Not Found!" });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ errMessage: "Invalid Key/Invalid Account!", status: 401 });
                            objv.execute();
                        }

                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    updateTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let sdata = req.body.data;
                let subscriptiondata = sdata.subscriptionid;
                let obj4 = new ModelRawNonQuery(req, res);
                //obj4.nonqrysql = "UPDATE `user` LEFT JOIN `account` ON `user`.`idaccount`=`account`.`idaccount` SET `idtariff`='" + sdata.tariff1 + "', `idtariff1`='" + sdata.tariff1 + "', `isPlan`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                obj4.nonqrysql = "UPDATE `user` LEFT JOIN `account` ON `user`.`idaccount`=`account`.`idaccount` SET `idtariff`=" + setToZero(sdata.tariff1) + ", `idtariff1`=" + setToZero(sdata.tariff1) + ", `isPlan`='true' WHERE `user`.`idaccount`=" + sessdata.idaccount + "";
                obj4.prepare();
                obj4.execute((error: any, user: any) => {
                    if (error == 1) {
                        let obj5 = new ModelRawNonQuery(req, res);
                        //obj5.nonqrysql = "UPDATE `session` SET `isPlan`='true', `idtariff`='" + sdata.tariff1 + "' WHERE `iduser`='" + sessdata.iduser + "'";
                        obj5.nonqrysql = "UPDATE `session` SET `isPlan`='true', `idtariff`=" + setToZero(sdata.tariff1) + " WHERE `idaccount`=" + sessdata.idaccount + "";
                        obj5.prepare();
                        obj5.execute((_err: any, user: any) => {
                            if (_err == 1) {

                                if (subscriptiondata !== null && subscriptiondata !== undefined) {
                                    let subscriptionmap = new SubscriptionManagement();
                                    subscriptionmap.Savesuscriptioncontrolmapping(req, res, subscriptiondata, sessdata.idaccount, (err: any) => {
                                        if (err == 0) {
                                            console.log("Something went Wrong");
                                        } else {
                                            console.log("Subscription Data Saved");
                                        }
                                    });
                                }

                                let objup = new ModelRawQuery(req, res);
                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                objup.prepare();
                                objup.execute((errorE: any, emailE: any) => {

                                    let currSess = sessiondata.get(req.headers.authorization);
                                    currSess.idtariff = sdata.tariff1;
                                    currSess.isPlan = "true";
                                    sessiondata.set(req.headers.authorization, currSess);
                                    let obj6 = new ModelRawQuery(req, res);
                                    obj6.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                    obj6.prepare();
                                    obj6.execute((seserr: any, sessionData: any) => {
                                        if (seserr == 1) {
                                            let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                                            let emType = JSON.parse(tmp);
                                            let sessionData1: any = Object.assign(sessionData, emType);

                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Tariff Updated Successfully!", status: 201, session: sessionData1 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Tariff Updated Error With Connection!", status: 502, error: sessionData });
                                            objv.execute();
                                        }
                                    });

                                });

                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Tariff Updated Error With Connection! ", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    currentSession(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + req.query.authkey + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Session Fetched Successfully!", status: 200, session: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Session Not Fetched DB Error!", status: 502, error: sessdata });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }


    /**
     * To get the list of TimeZones
     */
    GetTimeZones(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let objv = new RawView(res);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT id, label utc FROM `tbl_timezones`;";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (error == 1) {
                        result = result || []
                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something Went Wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        })
    }


    /**
     * To get the user's TimeZone
     */
    GetUserTimeZone(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let iduser: any = sessdata.iduser
                let iQry: string = "SELECT a.id, a.id_timezone, b.label utc FROM `tbl_timezone_config` a\n"
                iQry += "INNER JOIN `tbl_timezones` b ON b.id=a.id_timezone\n"
                iQry += "WHERE a.id_user=" + iduser + ";"

                let objv = new RawView(res);
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = iQry;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (error == 1) {
                        result = Array.isArray(result) && result.length > 0 ? result[0] : null
                        objv.prepare({
                            error: 0,
                            message: "Record fetched successfully.",
                            data: result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something Went Wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        })
    }


    /**
     * To update the user's TimeZone
     */
    UpdateUserTimeZone(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = req.body.data

                let objv = new RawView(res);
                if (typeof rdata.timezone != 'undefined' && rdata.timezone) {
                    let obj1 = new ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(" + rdata.timezone + ", " + sessdata.iduser + ");"
                    obj1.prepare()
                    obj1.execute((error: any, result: any) => {
                        if (error == 1) {
                            /**
                             * Update the TimeZone in user's session data
                             */
                            /* let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT `iduser`, `password`,ext_name FROM `user` WHERE iduser>0 AND iduser<=200";
                            obj2.prepare();
                            obj2.execute((error, result) => {
                                if (error == 1 && Array.isArray(result) && result.length > 0) {
                                    result.forEach(ele => {                                       
                                        let pwt12 = bcrypt.hashSync(ele.ext_name, 10);
                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `user` SET `password`='" + pwt12 + "' WHERE `iduser`='" + ele.iduser + "';";
                                        obj3.prepare();
                                        obj3.execute((error, result2) => {console.log("Users:: "+pwt12+" :: ", ele)});
                                    });                                    
                                }
                            }); */

                            /* let obj2 = new ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT a.utc client_time FROM tbl_timezones a WHERE a.id=" + rdata.timezone + ";"
                            obj2.prepare()
                            obj2.execute((error: any, result: any) => {
                                if (error == 1 && Array.isArray(result) && result.length > 0) {
                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "UPDATE `session` SET `client_time`='" + result[0].client_time + "' WHERE `authkey`='" + sessdata.authkey + "';"
                                    obj3.prepare()
                                    obj3.execute((error: any, result2: any) => {
                                        sessdata.client_time = result[0].client_time
                                        sessiondata.set(sessdata.authkey, sessdata)
                                    })
                                }
                            }) */

                            objv.prepare({
                                error: 0,
                                message: "Successfully saved."
                            });
                            objv.execute();
                        }
                        else {
                            objv.prepare({
                                error: 1,
                                message: "Something Went Wrong!"
                            });
                            objv.execute();
                        }
                    })
                }
                else {
                    objv.prepare({
                        error: 1,
                        message: "Invalid data!"
                    });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**************************
    *  Forgot Password start  *
    **************************/
    public sendMailForForgetPass(req: Request, res: Response, next: NextFunction) {
        let sdataa: any = req.query.type;
        let sdata: any = sdataa ? (sdataa.startsWith("{") ? JSON.parse(sdataa) : { sdataa: sdataa }) : null;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT u.iduser,u.idaccount,us.email, us.firstname, us.lastname, u.username FROM user_profile us JOIN `user` u ON us.iduser=u.iduser WHERE us.`email`='" + sdata.email + "' AND u.username='" + sdata.username + "' AND u.`is_deleted`=0";
        obj.prepare();
        obj.execute((_error: any, user: any) => {
            if (_error == 1) {
                if (user.length > 0) {
                    if (sdata.email.toLowerCase() == user[0].email.toLowerCase() && sdata.username.toLowerCase() == user[0].username.toLowerCase()) {
                        let getUser = user[0];
                        let obj4 = new ModelRawQuery(req, res);
                        obj4.qrysql = "SELECT template, subject,`cc`,`bcc` FROM `email_template` WHERE type='forgot_password'";
                        obj4.prepare();
                        obj4.execute((emlErr: any, emlRes: any) => {
                            if (emlErr == 1) {
                                if (emlRes.length > 0) {
                                    let secret = Str.random(15);
                                    let validationKey = jwt.sign({
                                        exp: Math.floor(Date.now() / 1000) + (60 * 60),
                                        data: sdata.email
                                    }, secret);

                                    let obj3 = new ModelRawNonQuery(req, res);
                                    obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "',`isResetPassword` = 'true'  WHERE `username`='" + parseBody(getUser.username) + "' AND `is_deleted`=0";
                                    obj3.prepare();
                                    obj3.execute((_uperr: any, __result: any) => {
                                        if (_uperr == 1) {
                                            let tmpData = emlRes[0].template;
                                            tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                            tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                            tmpData = tmpData.replace(/{TYPE}/g, 'Signalmash');
                                            tmpData = tmpData.replace(/{URL}/g, templateURL.URL + '/#/password/reset-password/' + validationKey);
                                            let obj1 = new ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + getUser.iduser + "','" + getUser.idaccount + "','" + FromEmail + "','" + getUser.email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Forget Password  ', '" + parseBody(tmpData) + "','Mail Send for Forget Password','7','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                            obj1.prepare();
                                            obj1.execute((_err: any, __result: any) => {
                                                console.log("Data Inserted In DB!")
                                                if (_err == 1) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 201, message: "Password Reset Email Sent!", message1: "Please Check your email and follow the included link to finish resetting your password." });
                                                    objv.execute();
                                                }
                                                else {
                                                    console.log("Error In Updating Password!");
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 401, message: "Opps Email Not Sent!" });
                                                    objv.execute();
                                                }
                                            });
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something went Wrong!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Verification Email not Send!", status: 502 });
                                    objv.execute();
                                }
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Error With Fetching Email Data!", status: 502 });
                                objv.execute();
                            }
                        });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 404, message: "Email and Username not matched!" });
                        objv.execute();
                    }
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: "Email Not Found/Invalid Account!" });
                    objv.execute();
                }
            } else {
                let objv = new RawView(res);
                objv.prepare({ status: 502, message: "Something Went Wrong to Fetch Email!" });
                objv.execute();
            }
        });
    }

    public VerifyToken(req: Request, res: Response, next: NextFunction) {
        let key = req.query.type;
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT `isResetPassword` FROM `user` WHERE validationKey='" + key + "' AND `is_deleted`=0";
        obj.prepare();
        obj.execute((error: any, result: any) => {
            if (result.length > 0) {
                if (result[0].isResetPassword == 'true') {
                    if (error == 1 && result.length > 0) {
                        let obj4 = new ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "UPDATE `user` SET `isResetPassword`='false' WHERE validationKey='" + key + "' AND `is_deleted`=0";
                        obj4.prepare();
                        obj4.execute((emlErr: any, emlRes: any) => {
                            if (emlErr == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ error: 0, status: 201, message: "Successfull Verified Please Enter Your New Password!", data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ error: 0, status: 502, message: "Successfull Verified Status Not Changed!", data: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv.execute();
                    }
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ error: 1, status: 502, message: "The Link You Followed Has Expired!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ error: 1, status: 404, message: "Invalid Account!" });
                objv.execute();
            }
        });
    }

    public updatePassword(req: Request, res: Response, next: NextFunction) {
        let alldata = req.body.data;
        let password1 = bcrypt.hashSync(alldata.password, 10)
        let obj0 = new ModelRawNonQuery(req, res);
        obj0.nonqrysql = "UPDATE `user` SET `password`='" + password1 + "',`ext_name`='" + parseBody(alldata.password) + "', `isResetPassword`='true' WHERE `validationKey`= '" + alldata.key + "' AND `is_deleted`=0";
        obj0.prepare();
        obj0.execute((error: any, result: any) => {
            if (result.affectedRows > 0) {
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT up.firstname, up.lastname, up.email, u.username , u.iduser , u.idaccount FROM `user` u JOIN `user_profile` up ON u.iduser = up.iduser WHERE u.validationKey = '" + alldata.key + "';";
                obj1.prepare();
                obj1.execute((Err: any, Res: any) => {
                    if (Err == 1) {
                        let obj5 = new ModelRawQuery(req, res);
                        obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='reset_password'";
                        obj5.prepare();
                        obj5.execute((emlErr: any, emlRes: any) => {
                            if (emlErr == 1) {
                                if (emlRes.length > 0) {
                                    let tmpData = emlRes[0].template;
                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                    tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                    // var smtpTransport = nodemailer.createTransport({
                                    //     service: "gmail",
                                    //     host: "smtp.gmail.com",
                                    //     port: 587,
                                    //     secure: true,
                                    //     auth: {
                                    //         user: "mailto:donotreply@nglcommunications.com",
                                    //         pass: "yr%5V9GB"
                                    //     }
                                    // });
                                    // var mailOptions = {
                                    //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                    //     to: Res[0].email,
                                    //     usernmae: Res[0].username,
                                    //     email: Res[0].email,
                                    //     subject: `${emlRes[0].subject}`,
                                    //     text: "Thank You For Registration",
                                    //     html: `${tmpData}`
                                    // }
                                    // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                    //     if (_emailError) {
                                    //         let objv = new RawView(res);
                                    //         objv.prepare({ message: "Opps Email Not Sent!", status: 502 });
                                    //         objv.execute();
                                    //     } else {
                                    //         let objv = new RawView(res);
                                    //         objv.prepare({ message: "Password Reset Successfully!", status: 201 });
                                    //         objv.execute();
                                    //     }
                                    // });
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + Res[0].iduser + "','" + Res[0].idaccount + "','" + FromEmail + "','" + Res[0].email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send to Update Password.', '" + parseBody(tmpData) + "','Thank You for Updating Your Password. ','8','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                    obj1.prepare();
                                    obj1.execute((_err: any, __result: any) => {
                                        if (_err == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 201, message: "Password Updated Successfully!" });
                                            objv.execute();
                                        }
                                        else {
                                            console.log("Error In Updating Password!");
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 401, message: "Opps Email Not Sent!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    console.log("Template Data Not Found!");
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something went wrong with find temlate!", status: 503 });
                                    objv.execute();
                                }
                            }
                            else {
                                console.log("Something Went Wrong with DB!");
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something went wrong with find temlate.", status: 504 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 505, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Password Verification Key has expired/Invalid Account!", status: 401 });
                objv.execute();
            }
        });
    }
    /************************
    *  Forgot Password end  *
    ************************/

    /* added here query for usersCustomer list for dropdown */
    customerList(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                //obj.qrysql = "SELECT a.san,u.username,u.iduser FROM `user`u INNER JOIN account a ON a.idaccount=u.idaccount WHERE a.`idaccount`= '" + sessdata.idaccount + "'";
                obj.qrysql = "SELECT a.san,u.username,u.iduser, up.firstname, up.lastname FROM `user`u LEFT JOIN account a ON a.idaccount=u.idaccount RIGHT JOIN user_profile up ON u.iduser=up.iduser WHERE u.`is_deleted`= 0 AND a.`idaccount`= '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Customer Fetched!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    billingEnableOrDisable(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `account` SET `is_billing`='" + setToZero(sdata.bVal) + "' WHERE `idaccount`=" + sdata.idaccount + "";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 0, status: 201, message: "Successfully Updated." });
                        objv0.execute();
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    kycUpdateStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body.data;
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "UPDATE `user` SET `kyc_verify_status`='1' WHERE `idaccount`='" + sdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((error: any, result: any) => {
                    if (error == 1) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `know_your_customer` SET `approve_date`= NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((errors: any, result: any) => {
                            if (errors == 1) {
                                let objv0 = new RawView(res);
                                objv0.prepare({ error: 0, status: 201, message: "KYC Successfully Verified." });
                                objv0.execute();
                            }
                            else {
                                let objv0 = new RawView(res);
                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        })
                    } else {
                        let objv0 = new RawView(res);
                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                        objv0.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }


    /** start onBoardingVerification */
    onBoardingVerification(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = JSON.parse(req.body.data);
                let arrData: any;
                if (rdata.email) {
                    arrData = '`isEmailVerify`=' + rdata.email;
                }
                if (rdata.phone) {
                    arrData = '`isMobileVerify`=' + rdata.phone;
                }
                if (rdata.isAddress) {
                    arrData = '`isAddress`=' + rdata.isAddress;
                }
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.filter = null;
                obj0.nonqrysql = "UPDATE `user` SET '" + arrData + "'  WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((_error: any, bvRes: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res)
                        objv.prepare({
                            message: "onBoarding Verification Updated Successfully",
                            status: 200
                        })
                        objv.execute();
                    }

                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Brand Update!", status: 502 });
                        objv.execute();
                    }


                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }


    /**Inset query for Domain Block */
    domainBlock(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var rdata: any = [];
                rdata = req.body.data;
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "INSERT INTO `domain_block` (`ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact`) VALUES('" + rdata.ip + "', '" + rdata.email + "', '" + rdata.specific_domain + "', '" + parseBody(rdata.first_name) + "', '" + parseBody(rdata.last_name) + "', '" + rdata.contact + "')";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, message: "Domain Block Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Domain Blocke Not Created Successfully!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /**GET query for Domain Block */
    getDomainBlk(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `domain_block_id`,`ip_address`,`email`,`domain_name`,`first_name`,`last_name`,`contact`, `created_at` FROM `domain_block` ORDER BY `domain_block_id` DESC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Domain Block Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Domain Block List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /**PUT query for Domain Block */
    updateDomainBlock(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.body.data;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `domain_block` SET `ip_address`='" + sdata.ip + "', `email`='" + sdata.email + "', `domain_name`='" + parseBody(sdata.specific_domain) + "', `first_name`='" + parseBody(sdata.first_name) + "', `last_name`='" + parseBody(sdata.last_name) + "', `contact`='" + sdata.contact + "'  WHERE `domain_block_id`='" + sdata.domen_id + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Domain Block Updated Successfully!", data: result, status: 200 });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /*DELETE query for Domain block*/
    deleteDomainBlock(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `domain_block` WHERE `domain_block_id`='" + req.query.domain_block_id + "'";
                obj.prepare();
                obj.execute((_err: any, result: any) => {
                    if (_err == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Domain Block Deleted Successfully!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    /* public compairePassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let nullPassword: any = [];
                let matchedPassword: any = [];
                let notmatchedPassword: any = [];
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `password`, `ext_name`, `username`,`idaccount`,`iduser` FROM `user`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        for (let i of result) {

                            if (i.ext_name && i.password) {
                                let ext = bcrypt.compareSync(i.ext_name, i.password);
                                if (ext) {
                                    matchedPassword.push({ status: ext, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                                }
                                else {
                                    notmatchedPassword.push({ status: ext, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                                }
                            }
                            else {
                                nullPassword.push({ status: null, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                            }
                        }
                        if (matchedPassword.length > 0 || notmatchedPassword.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data Fetched Successfully!", status: 200, data: { matchedPassword: matchedPassword, notmatchedPassword: notmatchedPassword, nullPassword: nullPassword } });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data Not Fetched!", status: 502, data: { matchedPassword: [], notmatchedPassword: [], nullExtPassword: [] } });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    } */

    getResellerUsers(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `reseller_iduser`,`signup_link_id`,`validationKey` from `user` where `iduser`= '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Reseller Users Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Reseller Users List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getResellerTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let data: any = JSON.parse(sdata.type);
                if (data.iduser != '0' && data.iduser != null && data.key != null) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `url`,`key`,`name` as iname FROM `signup_referral_link` WHERE `key`='" + data.key + "' AND `iduser` ='" + data.iduser + "' ";
                    obj.prepare();
                    obj.execute((_error: any, result1: any) => {
                        if (_error == 1) {
                            if (result1.length > 0) {
                                let url = result1[0].url;
                                let url1 = url.split('/#/signup?url=')[1];
                                let decodeUrl = Buffer.from(url1, "base64").toString("utf8");
                                let idtariff = decodeUrl.split('idtariff=')[1];
                                let idtarifff = idtariff.split('&ukey=')[0];
                                let obj1 = new ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT `idtariff`,`idaccount`,`name`,`description`,`type`,`day_num`,`proration` FROM `tariff` WHERE idtariff IN (" + idtarifff + ")";
                                obj1.prepare();
                                obj1.execute((_error: any, result: any) => {
                                    if (_error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, data1: result1, message: "Tariff Fetched Successfully!", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "No Url Found!", status: 503 });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objh = new RawView(res);
                    objh.prepare({ message: "No Data found for this Account!", status: 502 });
                    objh.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        })
    }

    public getUserStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query.type;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `newUser_status` FROM `user` WHERE `iduser` ='" + sdata + "'";
                obj.prepare();
                obj.execute((__error, result) => {
                    if (__error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetch User Status Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went wrong!", status: 501 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /**GET data by id */
    kycVerifyHeader(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT  `iduser`,`idaccount`,`kyc_verify_status` FROM `user` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Kyc Details Fatched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With KYC Verification!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    public resetPassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.body;
                if (sdata.old_password == 'undefined' || sdata.old_password == null) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Password Not Found.", error: 0 });
                    objv.execute();
                }
                else {
                    let obj0 = new ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `password` FROM `user` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj0.prepare();
                    obj0.execute((_error: any, result: any) => {
                        let pass1: any = sdata.old_password
                        if (result[0] && result[0] !== undefined && (bcrypt.compareSync(pass1, result[0].password))) {
                            let password1 = bcrypt.hashSync(sdata.confirm_password, 10);
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "CALL ChangePassword(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + result[0].password + "','" + password1 + "')";
                            obj.prepare();
                            obj.execute((__error: any, result: any) => {
                                if (__error == 1) {
                                    let obj4 = new ModelRawNonQuery(req, res);
                                    obj4.nonqrysql = "UPDATE `user` SET `ext_name`='" + parseBody(sdata.confirm_password) + "',`resetPassword`='1' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj4.prepare();
                                    obj4.execute((__error: any, user: any) => {
                                        let obj1 = new ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT up.firstname, up.lastname, up.email,u.username FROM `user` u JOIN user_profile up ON u.iduser = up.iduser WHERE u.iduser = '" + sessdata.iduser + "'";
                                        obj1.prepare();
                                        obj1.execute((Err: any, Res: any) => {
                                            if (Err == 1) {
                                                let obj5 = new ModelRawQuery(req, res);
                                                obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='reset_password'";
                                                obj5.prepare();
                                                obj5.execute((emlErr: any, emlRes: any) => {
                                                    if (emlErr == 1) {
                                                        if (emlRes.length > 0) {
                                                            let tmpData = emlRes[0].template;
                                                            tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                                            tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                                            // var smtpTransport = nodemailer.createTransport({
                                                            //     service: "gmail",
                                                            //     host: "smtp.gmail.com",
                                                            //     port: 587,
                                                            //     secure: true,
                                                            //     auth: {
                                                            //         user: "mailto:donotreply@nglcommunications.com",
                                                            //         pass: "yr%5V9GB"
                                                            //     }
                                                            // });
                                                            // var mailOptions = {
                                                            //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                                            //     to: Res[0].email,
                                                            //     usernmae: Res[0].username,
                                                            //     email: Res[0].email,
                                                            //     subject: `${emlRes[0].subject}`,
                                                            //     text: "Thank You For Registration",
                                                            //     html: `${tmpData}`
                                                            // }
                                                            // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                            //     if (_emailError) {
                                                            //         console.log("Opps Email Not Sent!", _emailError);
                                                            //     } else {
                                                            //         console.log("Email Send  Successfully!");
                                                            //         let objv = new RawView(res);
                                                            //         objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                            //         objv.execute();
                                                            //     }
                                                            // });

                                                            let obj1 = new ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + Res[0].email + "', '" + parseBody(emlRes[0].subject) + "','Mail Send for Reset Password', '" + parseBody(tmpData) + "','Mail Send for Reset Password','9','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                            obj1.prepare();
                                                            obj1.execute((_err: any, __result: any) => {
                                                                console.log("Email Send  Successfully!")
                                                                if (_err == 1) {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ result: result, message: "Password Changed Successfully!", status: 201 });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    console.log("Error In Updating Password!");
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            console.log("Template Data Not Found!");
                                                        }
                                                    }
                                                    else {
                                                        console.log("Something Went Wrong with DB!");
                                                    }
                                                });
                                            }
                                            else {
                                                let objv0 = new RawView(res);
                                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                                objv0.execute();
                                            }
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        _error: _error,
                                        message: "Something Went Wrong With Connection!",
                                        status: 503
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objw = new RawView(res);
                            objw.prepare({
                                message: "The old password you have entered is incorrect!",
                                status: 504
                            });
                            objw.execute();
                        }
                    });
                }

            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }

    getfeatureService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT fs_id, fs_name_code, fs_name FROM feature_service";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1 && result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Feature Details Fatched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data not Available!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }

    getSuspendedService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount` FROM `account_service` WHERE `as_status`='0' GROUP BY idaccount";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1 && result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Details Fatched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }

    getfeatureServiceById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let idaccount: any = req.query.type;
                    /* if (setservicedata.has(idaccount.toString())) {
                        console.log("comming form hashMap")
                        let objv = new RawView(res);
                        objv.prepare({ message: "Feature Details Fatched!", data: setservicedata.get(idaccount.toString()), status: 200 });
                        objv.execute();
                    } else { */
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT fs_id, idaccount, as_status From account_service where idaccount ='" + idaccount + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1 && result.length > 0) {
                            console.log("comming from database")
                            let objv = new RawView(res);
                            objv.prepare({ message: "Feature Details Fatched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", data: result, status: 500, error: result });
                            objv.execute();
                        }
                    });
                    /* } */
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 501 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }

    getfeatureServiceStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `fs_id`,`as_status` FROM `account_service` WHERE `idaccount`='" + sessdata.idaccount + "' AND `as_status` = '1'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Details Fatched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }

    updateSuspendedService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let rdata: any = [];
                    rdata = req.body.data;
                    rdata.forEach((element: any, index: any) => {
                        /* let idaccount = String(element.idaccount)
                        if (setservicedata.has(idaccount.toString())) {
                            let hashMapData: any;
                            hashMapData = setservicedata.get(idaccount.toString())
                            let index = hashMapData.findIndex((obj: any) => obj.fs_id === element.fs_id);
                            if (index !== -1) {
                                hashMapData[index].as_status = element.as_status;
                                setservicedata.set(idaccount.toString(), hashMapData);
                            }
                        } */
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `account_service` SET `as_status`='" + element.as_status + "' WHERE `idaccount`='" + element.idaccount + "' AND `fs_id`='" + element.fs_id + "'";
                        obj2.prepare();
                        obj2.execute((error: any, result: any) => {
                            if (error == 1) {
                                if (result.affectedRows > 0) {
                                    console.log("data updated Successfully for ", element.fs_id);
                                }
                                else {
                                    console.log("data Not updated Successfully", element.fs_id);
                                }
                            }
                            else {
                                console.log("Something went wrong with update");
                            }
                        });
                    });
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service updated Successfully!", status: 200 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "You are not accessible.", status: 501 });
                    objv.execute();
                }

            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    suspendAllServices(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = req.body;
                if (sessdata.type == 1 || sessdata.type == 2) {
                    let ida = '';
                    if (sessdata.type == 1)
                        ida = rdata.idaccount;
                    else
                        ida = sessdata.idaccount;

                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `account_service` SET `as_status`='0' WHERE `idaccount`=" + ida + "";
                    obj2.prepare();
                    obj2.execute((error: any, result: any) => {
                        if (error == 1) {
                            if (result.affectedRows > 0) {
                                console.log("Service Suspended Successfully!");
                            }
                            else {
                                console.log("Service Not Suspended Successfully");
                            }
                        }
                        else {
                            console.log("Something went wrong with update");
                        }
                    });
                }
                else {
                    console.log("You are not accessible.");
                }
            }
            else {
                console.log("Invalid Session!");
            }
        });
    }

    Payment_status(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (sessData.type == 1) {
                    let sdata = JSON.parse(req.body.data);
                    let objj1 = new ModelRawNonQuery(req, res);
                    objj1.nonqrysql = "UPDATE `user` set `trust_score`='" + sdata.trustscore + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                    objj1.prepare();
                    objj1.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv2 = new RawView(res);
                            objv2.prepare({ message: 'Payment Status Update Successfully!', data: result, status: 200 });
                            objv2.execute();
                        } else {
                            let objv2 = new RawView(res);
                            objv2.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv2.execute();
                        }
                    })
                } else {
                    let objvv = new RawView(res);
                    objvv.prepare({ message: "Service Unavailable!", status: 503 });
                    objvv.execute();
                }
            }
            else {
                let objv2 = new Res406(res);
                objv2.prepare({ status: 401, message: "Unauthorized User!" });
                objv2.execute();
            }
        })
    }

    trust_score(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (sessData.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT score , description FROM `stripe_trust_score`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: 'Trust Score Fetch Successfully!', data: result, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    })
                } else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        })
    }


    /**CSP Configuration OBNSystme **/

    getcpsdata(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT (100000000 + a.idaccount) AS san,a.idaccount, a.cps, u.username FROM account a JOIN user u ON u.idaccount = a.idaccount WHERE a.account_type = '2' AND u.type = '2' ORDER BY a.idaccount DESC";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "CPS List Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    updatecpsdata(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `account` SET cps = '" + setToZero(sdata.cps) + "' WHERE idaccount = '" + sdata.san + "'"
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "CPS Data Updated Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getsiptrunking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idsipts`,`sip_ip`,`sip_prefix`,`sip_name`,`created_at` FROM `sip_trunking_setting` ORDER BY idsipts DESC";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "SIP Trunking Setting Fetched Successfully!", status: 201 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    addsiptrunking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    // let objj = new ModelRawQuery(req, res);
                    // objj.qrysql = "SELECT `sip_ip`,`sip_prefix`,`sip_name` FROM `sip_trunking_setting` where `sip_ip` = '" + parseBody(sdata.sipip) + "' OR `sip_prefix`='" + parseBody(sdata.sipprefix.trim()) + "' OR `sip_name`='" + parseBody(sdata.sipname.trim()) + "'";
                    // objj.prepare();
                    // objj.execute((_error: any, getres: any) => {
                    //     if (getres.length > 0) {
                    //         let message = "";
                    //         let sipIpExists = getres.some((item: any) => item.sip_ip === parseBody(sdata.sipip));
                    //         let sipPrefixExists = getres.some((item: any) => item.sip_prefix === parseBody(sdata.sipprefix.trim()));
                    //         let sipNameExists = getres.some((item: any) => item.sip_name === parseBody(sdata.sipname.trim()));

                    //         if (sipIpExists && sipPrefixExists && sipNameExists) {
                    //             message = "All Data SIP Trunking Setting Already Exists";
                    //         } else if (sipIpExists) {
                    //             message = "SIP IP Already Exists";
                    //         } else if (sipPrefixExists) {
                    //             message = "SIP Prefix Already Exists";
                    //         } else if (sipNameExists) {
                    //             message = "SIP Name Already Exists";
                    //         }
                    //         let objv = new RawView(res);
                    //         objv.prepare({ message: message, status: 404 });
                    //         objv.execute();
                    //     } else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `sip_trunking_setting` (`sip_ip`, `sip_name`, `sip_prefix`) VALUES('" + parseBody(sdata.sipip) + "', '" + parseBody(sdata.sipname.trim()) + "', '" + parseBody(sdata.sipprefix.trim()) + "')";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (result) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "SIP Trunking Setting Saved Successfully!", status: 201 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                    // }
                    // })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable.", status: 501 });
                    objv.execute();
                }
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }

    editsiptrunk(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data
                    // let objj = new ModelRawQuery(req, res);
                    // objj.qrysql = "SELECT `sip_ip`,`sip_prefix`,`sip_name` FROM `sip_trunking_setting` where (`sip_ip` = '" + sdata.data.sipip + "' OR `sip_prefix`='" + parseBody(sdata.data.sipprefix.trim()) + "' OR `sip_name`='" + parseBody(sdata.data.sipname.trim()) + "') AND `idsipts` != '" + sdata.id + "'";
                    // objj.prepare();
                    // objj.execute((_error: any, getres: any) => {
                    //     if (getres.length > 0) {
                    //         let message = "";
                    //         let sipIpExists = getres.some((item: any) => item.sip_ip === parseBody(sdata.data.sipip));
                    //         let sipPrefixExists = getres.some((item: any) => item.sip_prefix === parseBody(sdata.data.sipprefix.trim()));
                    //         let sipNameExists = getres.some((item: any) => item.sip_name === parseBody(sdata.data.sipname.trim()));

                    //         if (sipIpExists && sipPrefixExists && sipNameExists) {
                    //             message = "All Data SIP Trunking Setting Already Exists";
                    //         } else if (sipIpExists) {
                    //             message = "SIP IP Already Exists";
                    //         } else if (sipPrefixExists) {
                    //             message = "SIP Prefix Already Exists";
                    //         } else if (sipNameExists) {
                    //             message = "SIP Name Already Exists";
                    //         }
                    //         let objv = new RawView(res);
                    //         objv.prepare({ message: message, status: 404 });
                    //         objv.execute();
                    // } else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `sip_trunking_setting` SET sip_ip = '" + sdata.data.sipip + "',sip_prefix = '" + parseBody(sdata.data.sipprefix.trim()) + "',sip_name = '" + parseBody(sdata.data.sipname.trim()) + "' WHERE idsipts = '" + sdata.id + "'";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            // To update sip trunking profile
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `sip_override` SET `sip_override_ip`='" + sdata.data.sipip + "',`sip_override_prefix`='" + parseBody(sdata.data.sipprefix.trim()) + "' WHERE `idsipts`='" + sdata.id + "'";
                            obj1.prepare();
                            obj1.execute((_error: any, result: any) => {
                                console.log("Data Updated Successfully!");
                            });

                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "SIP Trunking Data Updated Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                    // }
                    // })

                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    deletesiptrunk(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM `sip_trunking_setting` WHERE `idsipts` = '" + req.query.ID + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 201, message: "SIP Trunking Setting Deleted Successfully!" });
                            objv.execute();

                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 503, message: "Something Went Wrong!" });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });

    }

    Getsiptrunkdetail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "Select so.`idsipts`,so.`idaccount`,so.`idoverride`,so.`sip_override_ip`,so.`sip_override_prefix`,sts.`sip_name`,so.`created_at` From `sip_override` so JOIN `sip_trunking_setting` sts ON so.`idsipts` = sts.`idsipts`";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "SIP Trunking Profile List Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    saveSIPtrunking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata: any = [];
                    sdata = req.body.data;
                    let sipIP = sdata.sip_name[0].sipIP;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount` FROM `sip_override` where `idaccount` = '" + sdata.selectuser[0].idaccount + "'";
                    obj.prepare();
                    obj.execute((_error: any, getSip: any) => {
                        if (getSip[0]) {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "SIP Trunking Profile Already Exists",
                                status: 404
                            });
                            objv.execute();
                        } else {
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "Select `sip_ip`,`sip_prefix` From `sip_trunking_setting` WHERE `idsipts` = '" + sipIP + "'";
                            obj1.prepare();
                            obj1.execute((error: any, result: any) => {
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "INSERT into `sip_override` (`idsipts`,`idaccount`,`sip_override_ip`,`sip_override_prefix`) VALUES('" + sipIP + "','" + sdata.selectuser[0].idaccount + "','" + parseBody(result[0].sip_ip) + "','" + parseBody(result[0].sip_prefix) + "')";
                                obj2.prepare();
                                obj2.execute((_error: any, result: any) => {
                                    if (result) {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, message: "SIP Trunking Profile Created Successfully!", status: 201 });
                                        objv.execute();
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                                        objv.execute();
                                    }
                                });
                            })
                        }
                    })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable.", status: 501 });
                    objv.execute();
                }
            } else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }

    updateSIPtrunking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata: any = JSON.parse(req.body.data);
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "Select `sip_ip`,`sip_prefix` From `sip_trunking_setting` WHERE `idsipts` = '" + sdata.idsipIP + "'";
                    obj1.prepare();
                    obj1.execute((error: any, result: any) => {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `sip_override` SET `idsipts`='" + sdata.idsipIP + "',`sip_override_ip`='" + parseBody(result[0].sip_ip) + "',`sip_override_prefix`='" + parseBody(result[0].sip_prefix) + "' WHERE `idoverride` = '" + sdata.IDsip + "'";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "SIP Trunking Profile Updated Successfully", status: 201 });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Data!", status: 502 });
                                objv.execute();
                            }
                        });
                    })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    deleteSIPtrunking(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                if (sessdata.type == 1) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE From `sip_override` WHERE `idoverride` = '" + req.query.ID + "'";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "SIP Trunking Profile Deleted Successfully!", data: result, status: 201 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Data!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getfilterdetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let data = req.body.data;
                    let conditions: string[] = [];
                    let obj = new ModelRawQuery(req, res);

                    if (data.sipname) {
                        // conditions.push('sts.`sip_name` LIKE "%' + parseBody(data.sipname.trim()) + '%"');
                        conditions.push('sts.`sip_name` = "' + parseBody(data.sipname[0].sipName) + '"');
                    }

                    if (data.sipoverrideprefix) {
                        conditions.push('so.`sip_override_prefix` LIKE "%' + parseBody(data.sipoverrideprefix.trim()) + '%"');
                    }

                    if (data.sipip) {
                        conditions.push('so.`sip_override_ip` = "' + parseBody(data.sipip) + '"');
                    }

                    if (data.san && data.san.length > 0) {
                        conditions.push('so.`idaccount` = "' + data.san[0].idaccount + '"');
                    }

                    if (data.from_date && data.to_date) {
                        conditions.push('so.`created_at` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59"');
                    }

                    let condition = conditions.length > 0 ? ' WHERE ' + conditions.join(' AND ') : '';

                    obj.qrysql = "Select so.`idsipts`,so.`idaccount`,so.`idoverride`,so.`sip_override_ip`,so.`sip_override_prefix`,sts.`sip_name`,so.`created_at` From `sip_override` so JOIN `sip_trunking_setting` sts ON so.`idsipts` = sts.`idsipts`" + condition;

                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result, message: "SIP Trunking Profile List Fetched Successfully!", status: 201
                            });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With List!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getcount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let data = req.query.type;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT COUNT(*) AS total_count FROM `sip_override` WHERE `idsipts` = '" + data + "'";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Total Count Sip Trunking Profile Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    closingInvoiceDetail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.query;
                    let condition: any = "";
                    let obj = new ModelRawQuery(req, res);
                    if (sdata.selectedUser || (sdata.to_date && sdata.from_date)) {
                        if (sdata.from_date && sdata.to_date && !sdata.selectedUser) {
                            condition += 'a.`created_at` BETWEEN "' + sdata.from_date + ' 00:00:00" AND "' + sdata.to_date + ' 23:59:59"';
                        }
                        if (sdata.selectedUser && !(sdata.to_date && sdata.from_date)) {
                            condition += 'a.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        if (sdata.selectedUser && sdata.from_date && sdata.to_date) {
                            condition += 'a.created_at BETWEEN "' + sdata.from_date + ' 00:00:00" AND "' + sdata.to_date + ' 23:59:59" AND a.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        obj.qrysql = "SELECT `a`.`san`,`a`.`idinvoice`,`a`.`path`,`a`.`idaccount`, `a`.`invoice_number`, a.customer_name, DATE_FORMAT(`a`.`created_at`, '%Y-%m-%d')`created_at`, `ai`.`total_amount`,`ai`.`tax` FROM `account_invoice` `a` INNER JOIN `account_invoice_closing` `ai` ON `a`.`idinvoice`=`ai`.`idinvoice`  WHERE " + condition + "   GROUP BY `a`.`idinvoice` ORDER BY `a`.`created_at` DESC"
                    }
                    else {
                        obj.qrysql = "SELECT `a`.`san`,`a`.`idinvoice`,`a`.`path`,`a`.`idaccount`, `a`.`invoice_number`, a.customer_name, DATE_FORMAT(`a`.`created_at`, '%Y-%m-%d')`created_at`, `ai`.`total_amount`,`ai`.`tax` FROM `account_invoice` `a` INNER JOIN `account_invoice_closing` `ai` ON `a`.`idinvoice`=`ai`.`idinvoice`   GROUP BY `a`.`idinvoice` ORDER BY `a`.`created_at` DESC"
                    }
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Closing Invoice Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    userFilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let qdata: any = req.query.type;
                    var sdata = JSON.parse(qdata);
                    let iQry: string = "",
                        iQN: number = 0,
                        cond: string = "";
                    iQry = "SELECT DISTINCT u.kyc_verify_status,u.volt_status,u.trust_score,u.federal_status,u.card_pdf,a.san,u.reseller_iduser,a.is_billing,u.isEmailVerify,w.balance,w.credit_limit,u.isMobileVerify,u.isAddress, 1 `utype`,u.isPlan, u.iduser, u.idaccount, u.`username` `user_name`, u.type,u.is_deleted,u.deleted_date , u.pending_deleted_date , isCard,newUser_status,ba.title, u.created , up.firstname `first_name`, up.lastname `last_name`, up.email, up.phone `contact_number`,IF(LENGTH(up.profile_pic)=0 || up.profile_pic='undefined' || up.profile_pic IS NULL, CONCAT(CEIL(1+RAND()*7),'.jpg'), up.profile_pic) profile_pic, u.idtariff, u.idservice FROM `user` u LEFT JOIN `account` a ON a.idaccount=u.idaccount LEFT JOIN `user_profile` up ON u.iduser=up.iduser LEFT JOIN `wallet` w ON w.idaccount = u.idaccount LEFT JOIN `billing_address` ba ON ba.idaccount = u.idaccount  WHERE u.type = 2 "

                    // iQry = "SELECT * FROM `user` \n"
                    if ((Array.isArray(sdata.idaccount) && sdata.idaccount.length > 0 && sdata.idaccount[0].userdata)) {
                        cond += "AND u.idaccount='" + sdata.idaccount[0].userdata + "' "
                        iQN++
                    }

                    if (sdata.from_date != '' && sdata.from_date && !sdata.to_date) {
                        cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' "
                        iQN++
                    }

                    if (sdata.to_date != '' && sdata.to_date && !sdata.from_date) {
                        cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' "
                        iQN++
                    }

                    if (sdata.from_date && sdata.to_date) {
                        cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' "
                        iQN++
                    }

                    if ((Array.isArray(sdata.service) && sdata.service.length > 0 && sdata.service[0].preferid)) {
                        cond += "AND u.idservice='" + sdata.service[0].preferid + "' ";
                        iQN++;
                    }

                    if ((Array.isArray(sdata.regTariff) && sdata.regTariff.length > 0 && sdata.regTariff[0].regid)) {
                        cond += "AND u.idtariff='" + sdata.regTariff[0].regid + "' "
                        iQN++
                    }
                    if (iQN > 0) {
                        iQry += cond
                        iQry = iQry.slice(0, -1) + "\n"
                    }
                    iQry += "ORDER BY `created`;"
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = iQry
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "User Fetched Successfully.",
                                status: 201
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Something Went Wrong!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    /* permanentDeleteAccount(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    // let mmessage:any='Customer Account Deleted Successfully.!', mstatus:any=201;
                    //Delete From User table
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `iduser`, `idaccount`, `idtariff`, `idservice`, `username`, `password`, `type`, `default`, `selected`, `did`, `sms`, `voice`, `status`, DATE_FORMAT(`created`, '%Y-%m-%d %H:%i:%s') as `created`, `isEmailVerify`, `isMobileVerify`, `validationKey`, `secret`, `isAddress`, `isCard`, `isPlan`, `isResetPassword`, `is_deleted`, `newUser_status`, DATE_FORMAT(`pending_deleted_date`, '%Y-%m-%d %H:%i:%s') as `pending_deleted_date`, DATE_FORMAT(`deleted_date`, '%Y-%m-%d %H:%i:%s') as `deleted_date`, DATE_FORMAT(`restore_date`, '%Y-%m-%d %H:%i:%s') as `restore_date`, `ipAddress`, `browser`, `ext_name`, `signup_link_id`, `reseller_iduser`, `email_verification_date`, `card_pdf`, `kyc_verify_status`, `volt_status`, `federal_status`, `resetPassword`, `trust_score` FROM `user` WHERE `idaccount` = '" + sdata.idaccount + "'";
                    obj.prepare();
                    obj.execute((error: any, userRes: any) => {
                        if (error == 1 && userRes.length > 0) {
                            let obj2 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_user` (`iduser`, `idaccount`, `idtariff`, `idservice`, `username`, `password`, `type`, `default`, `selected`, `did`, `sms`, `voice`, `status`, `created`, `isEmailVerify`, `isMobileVerify`, `validationKey`, `secret`, `isAddress`, `isCard`, `isPlan`, `isResetPassword`, `is_deleted`, `newUser_status`, `pending_deleted_date`, `deleted_date`, `restore_date`, `ipAddress`, `browser`, `ext_name`, `signup_link_id`, `reseller_iduser`, `email_verification_date`, `card_pdf`, `kyc_verify_status`, `volt_status`, `federal_status`, `resetPassword`, `trust_score`) VALUES";
                            userRes.forEach((ele: any) => {
                                qrystr += "('" + ele.iduser + "','" + ele.idaccount + "','" + setToZero(ele.idtariff) + "','" + setToZero(ele.idservice) + "','" + parseBody(ele.username) + "','" + parseBody(ele.password) + "','" + ele.type + "','" + ele.default + "','" + setEnum(ele.selected) + "','" + ele.did + "','" + ele.sms + "','" + ele.voice + "','" + setEnum(ele.status) + "','" + ele.created + "','" + setEnum(ele.isEmailVerify) + "','" + setEnum(ele.isMobileVerify) + "','" + ele.validationKey + "','" + ele.secret + "','" + setEnum(ele.isAddress) + "','" + setEnum(ele.isCard) + "','" + setEnum(ele.isPlan) + "','" + ele.isResetPassword + "','" + ele.is_deleted + "','" + ele.newUser_status + "','" + ele.pending_deleted_date + "','" + ele.deleted_date + "','" + ele.restore_date + "','" + ele.ipAddress + "','" + ele.browser + "','" + parseBody(ele.ext_name) + "','" + ele.signup_link_id + "','" + setToZero(ele.reseller_iduser) + "','" + ele.email_verification_date + "','" + ele.card_pdf + "','" + setToZero(ele.kyc_verify_status) + "','" + setToZero(ele.volt_status) + "','" + setToZero(ele.federal_status) + "','" + ele.resetPassword + "','" + setToZero(ele.trust_score) + "'),"
                            });
                            obj2.nonqrysql = qrystr.slice(0, -1);
                            obj2.prepare();
                            obj2.execute((err_user: any, user_res: any) => {
                                console.log("Data Inserted Successfully!");
                                if (err_user == 1) {
                                    console.log("Data Inserted Successfully!");
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "DELETE FROM `user` WHERE `idaccount`='" + sdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in archive_user!", status: 503 });
                                }

                            });
                        } else {
                            console.log({ mmessage: "Data not found from user", mstatus: 504 })
                        }
                    });

                    // Delete From User Profile Table
                    let obj3 = new ModelRawQuery(req, res);
                    obj3.qrysql = "SELECT `idsupplier`, `iduser`, `firstname`, `lastname`, `email`, `phone`, `profile_pic`, `domain`, `secret`, `key`, `account_id`, `auth_token`, `uploaded_file` FROM `user_profile` WHERE  `account_id` = '" + sdata.idaccount + "'";
                    obj3.prepare();
                    obj3.execute((error: any, userProfRes: any) => {
                        if (error == 1 && userProfRes.length > 0) {
                            let obj4 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_user_profile` (`idsupplier`, `iduser`, `firstname`, `lastname`, `email`, `phone`, `profile_pic`, `domain`, `secret`, `key`, `account_id`, `auth_token`, `uploaded_file`) VALUES";
                            userProfRes.forEach((ele: any) => {
                                qrystr += "('" + ele.idsupplier + "','" + ele.iduser + "','" + parseBody(ele.firstname) + "','" + parseBody(ele.lastname) + "','" + ele.email + "','" + ele.phone + "','" + ele.profile_pic + "','" + ele.domain + "','" + ele.secret + "','" + ele.key + "','" + ele.account_id + "','" + ele.auth_token + "','" + ele.uploaded_file + "'),"
                            });
                            obj4.nonqrysql = qrystr.slice(0, -1);
                            obj4.prepare();
                            obj4.execute((err_userPro: any, user_res: any) => {
                                if (err_userPro == 1) {
                                    console.log("Data Inserted Successfully!");
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "DELETE FROM `user_profile` WHERE `account_id`='" + sdata.idaccount + "'";
                                    obj5.prepare();
                                    obj5.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in user_profile!", status: 503 });
                                }
                            });
                        } else {
                            console.log({ message: "Data not found from account!", status: 504 });
                        }
                    });


                    // Delete From Account Table
                    let obj6 = new ModelRawQuery(req, res);
                    obj6.qrysql = "SELECT `idaccount`, `san`, `idtariff1`, `idtariff2`, `account_type`, `balance`, `credit`, `deleted`, DATE_FORMAT(`created`, '%Y-%m-%d %H:%i:%s') as `created`, `csp_id`, `is_billing`, `ib_channel`, `ob_channel`, `cps` FROM `account` WHERE `idaccount` = '" + sdata.idaccount + "'";
                    obj6.prepare();
                    obj6.execute((error: any, accRes: any) => {
                        if (error == 1 && accRes.length > 0) {
                            let obj7 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_account` (`idaccount`, `san`, `idtariff1`, `idtariff2`, `account_type`, `balance`, `credit`, `deleted`, `created`, `csp_id`, `is_billing`, `ib_channel`, `ob_channel`, `cps`) VALUES";
                            accRes.forEach((ele: any) => {
                                qrystr += "('" + ele.idaccount + "','" + ele.san + "','" + setToZero(ele.idtariff1) + "','" + setToZero(ele.idtariff2) + "','" + ele.account_type + "','" + setToZero(ele.balance) + "','" + setToZero(ele.credit) + "','" + setToZero(ele.deleted) + "','" + ele.created + "','" + setToZero(ele.csp_id) + "','" + setToZero(ele.is_billing) + "','" + setToZero(ele.ib_channel) + "','" + setToZero(ele.ob_channel) + "','" + setToZero(ele.cps) + "'),";
                            });
                            obj7.nonqrysql = qrystr.slice(0, -1);
                            obj7.prepare();
                            obj7.execute((err_userPro: any, user_res: any) => {
                                if (err_userPro == 1) {
                                    console.log("Data Inserted Successfully!");

                                    let iQry: string = "SET FOREIGN_KEY_CHECKS = 0;\n";
                                    iQry += "DELETE FROM `account` WHERE `idaccount`='" + sdata.idaccount + "';\n";
                                    iQry += "SET FOREIGN_KEY_CHECKS = 1;";
                                    let obj8 = new ModelRawNonQuery(req, res);
                                    obj8.nonqrysql = iQry;
                                    obj8.prepare();
                                    obj8.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in archive_account!", status: 503 });
                                }
                            });
                        } else {
                            console.log({ message: "Data not found from account!", status: 504 });
                        }
                    });

                    // Delete From Billing Address Table
                    let obj9 = new ModelRawQuery(req, res);
                    obj9.qrysql = "SELECT `idbilling_address`, `idaccount`, `customerType`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`, `legal_name`, `groupExmpt_number`, `businessName`, `is_valid` FROM `billing_address` WHERE `idaccount` ='" + sdata.idaccount + "'";
                    obj9.prepare();
                    obj9.execute((error: any, billRes: any) => {
                        if (error == 1 && billRes.length > 0) {
                            let obj10 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_billing_address` (`idbilling_address`, `idaccount`, `customerType`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`, `legal_name`, `groupExmpt_number`, `businessName`, `is_valid`) VALUES";
                            billRes.forEach((ele: any) => {
                                qrystr += "('" + ele.idbilling_address + "','" + ele.idaccount + "','" + ele.customerType + "','" + parseBody(ele.first_name) + "','" + parseBody(ele.last_name) + "','" + ele.contact + "','" + ele.email + "','" + parseBody(ele.address1) + "','" + parseBody(ele.address2) + "','" + parseBody(ele.city) + "','" + parseBody(ele.state) + "','" + parseBody(ele.postal_code) + "','" + parseBody(ele.country) + "','" + parseBody(ele.title) + "','" + parseBody(ele.ein) + "','" + parseBody(ele.website) + "','" + parseBody(ele.legal_name) + "','" + setToZero(ele.groupExmpt_number) + "','" + parseBody(ele.businessName) + "','" + setToZero(ele.is_valid) + "'),";
                            });
                            obj10.nonqrysql = qrystr.slice(0, -1);
                            obj10.prepare();
                            obj10.execute((err_userPro: any, user_res: any) => {
                                if (err_userPro == 1) {
                                    console.log("Data Inserted Successfully!");
                                    let obj11 = new ModelRawNonQuery(req, res);
                                    obj11.nonqrysql = "DELETE FROM `billing_address` WHERE `idaccount`='" + sdata.idaccount + "'";
                                    obj11.prepare();
                                    obj11.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in archive_billing_address!", status: 503 });
                                }
                            });
                        } else {
                            console.log({ message: "Data not found from billing_address!", status: 504 });
                        }
                    });

                    // Delete Connections 
                    let obj00 = new ModelRawQuery(req, res);
                    obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sdata.idaccount + "";
                    obj00.prepare();
                    obj00.execute((error: any, resultIdEnPoints: any) => {
                        if (error == 1) {
                            // Data Removed from Endpoint Table for Connection
                            let obj13 = new ModelRawNonQuery(req, res);
                            obj13.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`='" + sdata.idaccount + "'";
                            obj13.prepare();
                            obj13.execute((____error: any, result: any) => {
                                console.log("All Connection Data Deleted");
                            })

                            // Data Removed from inbound Table for Connection
                            let obj14 = new ModelRawNonQuery(req, res);
                            let qrystr = "";
                            resultIdEnPoints.forEach((ele: any) => {
                                qrystr += "DELETE FROM `inbound` WHERE `idendpoint`='" + ele.idendpoint + "';\n";
                            });
                            obj14.nonqrysql = qrystr.slice(0, -1);
                            obj14.prepare();
                            obj14.execute((____error: any, result: any) => {
                                console.log("All inbound Data Deleted");
                            })


                            // Data Removed from outbound Table for Connection
                            let obj15 = new ModelRawNonQuery(req, res);
                            let qrystr1 = "";
                            resultIdEnPoints.forEach((ele: any) => {
                                qrystr1 += "DELETE FROM `outbound` WHERE `idendpoint`='" + ele.idendpoint + "';\n";
                            });
                            obj15.nonqrysql = qrystr1.slice(0, -1);
                            obj15.prepare();
                            obj15.execute((____error: any, result: any) => {
                                console.log("All outbound Data Deleted");
                            })

                            // Data Removed from hooksetting Table for Connection
                            let obj16 = new ModelRawNonQuery(req, res);
                            obj16.nonqrysql = "DELETE FROM `hooksetting` WHERE `idaccount`='" + sdata.idaccount + "'";
                            obj16.prepare();
                            obj16.execute((____error: any, result: any) => {
                                console.log("All hooksetting Data Deleted");
                            })

                            // Data Removed from ip_address Table for Connection
                            let obj17 = new ModelRawNonQuery(req, res);
                            let qrystr2 = "";
                            resultIdEnPoints.forEach((ele: any) => {
                                qrystr2 += "DELETE FROM `ip_address` WHERE `idendpoint`='" + ele.idendpoint + "';\n";
                            });
                            obj17.nonqrysql = qrystr2.slice(0, -1);
                            obj17.prepare();
                            obj17.execute((____error: any, result: any) => {
                                console.log("All IP Address Data Deleted");
                            })

                            // Data Removed from ip_address Table for Connection
                            let obj18 = new ModelRawNonQuery(req, res);
                            let qrystr3 = "";
                            resultIdEnPoints.forEach((ele: any) => {
                                qrystr3 += "DELETE FROM `routing_profile` WHERE `idendpoint`='" + ele.idendpoint + "';\n";
                            });
                            obj18.nonqrysql = qrystr3.slice(0, -1);
                            obj18.prepare();
                            obj18.execute((____error: any, result: any) => {
                                console.log("All Routing Profile Data Deleted");
                            })

                        } else {
                            console.log({ message: "Data not found from endpoint!", status: 504 });
                        }

                    });

                    //Data Removed from Session Table
                    let obj18 = new ModelRawNonQuery(req, res);
                    obj18.nonqrysql = "DELETE FROM `session` WHERE `idaccount`='" + sdata.idaccount + "'";
                    obj18.prepare();
                    obj18.execute((__error: any, delSessRes: any) => {
                        console.log("All Session Data Deleted");
                    })

                    //Data API from Session Table
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`=" + sdata.idaccount + " ";
                    obj0.prepare();
                    obj0.execute((___error: any, delApiRes: any) => {
                        console.log("All API Data Deleted");
                    });

                    let obj19 = new RawView(res);
                    obj19.prepare({ message: 'Customer Account Deleted Successfully.!', status: 201 });
                    obj19.execute();
                }
                else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }*/
    
    permanentDeleteAccount(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    // let mmessage:any='Customer Account Deleted Successfully.!', mstatus:any=201;
                    //Delete From User table
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `iduser`, `idaccount`, `idtariff`, `idservice`, `username`, `password`, `type`, `default`, `selected`, `did`, `sms`, `voice`, `status`, DATE_FORMAT(`created`, '%Y-%m-%d %H:%i:%s') as `created`, `isEmailVerify`, `isMobileVerify`, `validationKey`, `secret`, `isAddress`, `isCard`, `isPlan`, `isResetPassword`, `is_deleted`, `newUser_status`, DATE_FORMAT(`pending_deleted_date`, '%Y-%m-%d %H:%i:%s') as `pending_deleted_date`, DATE_FORMAT(`deleted_date`, '%Y-%m-%d %H:%i:%s') as `deleted_date`, DATE_FORMAT(`restore_date`, '%Y-%m-%d %H:%i:%s') as `restore_date`, `ipAddress`, `browser`, `ext_name`, `signup_link_id`, `reseller_iduser`, `email_verification_date`, `card_pdf`, `kyc_verify_status`, `volt_status`, `federal_status`, `resetPassword`, `trust_score` FROM `user` WHERE `idaccount` = '" + sdata.idaccount + "'";
                    obj.prepare();
                    obj.execute((error: any, userRes: any) => {
                        if (error == 1 && userRes.length > 0) {
                            let obj2 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_user` (`iduser`, `idaccount`, `idtariff`, `idservice`, `username`, `password`, `type`, `default`, `selected`, `did`, `sms`, `voice`, `status`, `created`, `isEmailVerify`, `isMobileVerify`, `validationKey`, `secret`, `isAddress`, `isCard`, `isPlan`, `isResetPassword`, `is_deleted`, `newUser_status`, `pending_deleted_date`, `deleted_date`, `restore_date`, `ipAddress`, `browser`, `ext_name`, `signup_link_id`, `reseller_iduser`, `email_verification_date`, `card_pdf`, `kyc_verify_status`, `volt_status`, `federal_status`, `resetPassword`, `trust_score`) VALUES";
                            userRes.forEach((ele: any) => {
                                qrystr += "('" + ele.iduser + "','" + ele.idaccount + "','" + setToZero(ele.idtariff) + "','" + setToZero(ele.idservice) + "','" + parseBody(ele.username) + "','" + parseBody(ele.password) + "','" + ele.type + "','" + ele.default + "','" + setEnum(ele.selected) + "','" + ele.did + "','" + ele.sms + "','" + ele.voice + "','" + setEnum(ele.status) + "','" + ele.created + "','" + setEnum(ele.isEmailVerify) + "','" + setEnum(ele.isMobileVerify) + "','" + ele.validationKey + "','" + ele.secret + "','" + setEnum(ele.isAddress) + "','" + setEnum(ele.isCard) + "','" + setEnum(ele.isPlan) + "','" + ele.isResetPassword + "','" + ele.is_deleted + "','" + ele.newUser_status + "','" + ele.pending_deleted_date + "','" + ele.deleted_date + "','" + ele.restore_date + "','" + ele.ipAddress + "','" + ele.browser + "','" + parseBody(ele.ext_name) + "','" + ele.signup_link_id + "','" + setToZero(ele.reseller_iduser) + "','" + ele.email_verification_date + "','" + ele.card_pdf + "','" + setToZero(ele.kyc_verify_status) + "','" + setToZero(ele.volt_status) + "','" + setToZero(ele.federal_status) + "','" + ele.resetPassword + "','" + setToZero(ele.trust_score) + "'),"
                            });
                            obj2.nonqrysql = qrystr.slice(0, -1);
                            obj2.prepare();
                            obj2.execute((err_user: any, user_res: any) => {
                                if (err_user == 1) {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "DELETE FROM `user` WHERE `idaccount`='" + sdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in archive_user!", status: 503 });
                                }

                            });
                        } else {
                            console.log({ mmessage: "Data not found from user", mstatus: 504 })
                        }
                    });

                    // Delete From User Profile Table
                    let obj3 = new ModelRawQuery(req, res);
                    obj3.qrysql = "SELECT `idsupplier`, `iduser`, `firstname`, `lastname`, `email`, `phone`, `profile_pic`, `domain`, `secret`, `key`, `account_id`, `auth_token`, `uploaded_file` FROM `user_profile` WHERE  `account_id` = '" + sdata.idaccount + "'";
                    obj3.prepare();
                    obj3.execute((error: any, userProfRes: any) => {
                        if (error == 1 && userProfRes.length > 0) {
                            let obj4 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_user_profile` (`idsupplier`, `iduser`, `firstname`, `lastname`, `email`, `phone`, `profile_pic`, `domain`, `secret`, `key`, `account_id`, `auth_token`, `uploaded_file`) VALUES";
                            userProfRes.forEach((ele: any) => {
                                qrystr += "('" + ele.idsupplier + "','" + ele.iduser + "','" + parseBody(ele.firstname) + "','" + parseBody(ele.lastname) + "','" + ele.email + "','" + ele.phone + "','" + ele.profile_pic + "','" + ele.domain + "','" + ele.secret + "','" + ele.key + "','" + ele.account_id + "','" + ele.auth_token + "','" + ele.uploaded_file + "'),"
                            });
                            obj4.nonqrysql = qrystr.slice(0, -1);
                            obj4.prepare();
                            obj4.execute((err_userPro: any, user_res: any) => {
                                if (err_userPro == 1) {
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "DELETE FROM `user_profile` WHERE `account_id`='" + sdata.idaccount + "'";
                                    obj5.prepare();
                                    obj5.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in user_profile!", status: 503 });
                                }
                            });
                        } else {
                            console.log({ message: "Data not found from account!", status: 504 });
                        }
                    });


                    // Delete From Account Table
                    let obj6 = new ModelRawQuery(req, res);
                    obj6.qrysql = "SELECT `idaccount`, `san`, `idtariff1`, `idtariff2`, `account_type`, `balance`, `credit`, `deleted`, DATE_FORMAT(`created`, '%Y-%m-%d %H:%i:%s') as `created`, `csp_id`, `is_billing`, `ib_channel`, `ob_channel`, `cps` FROM `account` WHERE `idaccount` = '" + sdata.idaccount + "'";
                    obj6.prepare();
                    obj6.execute((error: any, accRes: any) => {
                        if (error == 1 && accRes.length > 0) {
                            let obj7 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_account` (`idaccount`, `san`, `idtariff1`, `idtariff2`, `account_type`, `balance`, `credit`, `deleted`, `created`, `csp_id`, `is_billing`, `ib_channel`, `ob_channel`, `cps`) VALUES";
                            accRes.forEach((ele: any) => {
                                qrystr += "('" + ele.idaccount + "','" + ele.san + "','" + setToZero(ele.idtariff1) + "','" + setToZero(ele.idtariff2) + "','" + ele.account_type + "','" + setToZero(ele.balance) + "','" + setToZero(ele.credit) + "','" + setToZero(ele.deleted) + "','" + ele.created + "','" + setToZero(ele.csp_id) + "','" + setToZero(ele.is_billing) + "','" + setToZero(ele.ib_channel) + "','" + setToZero(ele.ob_channel) + "','" + setToZero(ele.cps) + "'),";
                            });
                            obj7.nonqrysql = qrystr.slice(0, -1);
                            obj7.prepare();
                            obj7.execute((err_userPro: any, user_res: any) => {
                                if (err_userPro == 1) {
                                    let iQry: string = "SET FOREIGN_KEY_CHECKS = 0;\n";
                                    iQry += "DELETE FROM `account` WHERE `idaccount`='" + sdata.idaccount + "';\n";
                                    iQry += "SET FOREIGN_KEY_CHECKS = 1;";
                                    let obj8 = new ModelRawNonQuery(req, res);
                                    obj8.nonqrysql = iQry;
                                    obj8.prepare();
                                    obj8.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in archive_account!", status: 503 });
                                }
                            });
                        } else {
                            console.log({ message: "Data not found from account!", status: 504 });
                        }
                    });

                    // Delete From Billing Address Table
                    let obj9 = new ModelRawQuery(req, res);
                    obj9.qrysql = "SELECT `idbilling_address`, `idaccount`, `customerType`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`, `legal_name`, `groupExmpt_number`, `businessName`, `is_valid` FROM `billing_address` WHERE `idaccount` ='" + sdata.idaccount + "'";
                    obj9.prepare();
                    obj9.execute((error: any, billRes: any) => {
                        if (error == 1 && billRes.length > 0) {
                            let obj10 = new ModelRawNonQuery(req, res);
                            let qrystr = "INSERT INTO `archive_billing_address` (`idbilling_address`, `idaccount`, `customerType`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`, `legal_name`, `groupExmpt_number`, `businessName`, `is_valid`) VALUES";
                            billRes.forEach((ele: any) => {
                                qrystr += "('" + ele.idbilling_address + "','" + ele.idaccount + "','" + ele.customerType + "','" + parseBody(ele.first_name) + "','" + parseBody(ele.last_name) + "','" + ele.contact + "','" + ele.email + "','" + parseBody(ele.address1) + "','" + parseBody(ele.address2) + "','" + parseBody(ele.city) + "','" + parseBody(ele.state) + "','" + parseBody(ele.postal_code) + "','" + parseBody(ele.country) + "','" + parseBody(ele.title) + "','" + parseBody(ele.ein) + "','" + parseBody(ele.website) + "','" + parseBody(ele.legal_name) + "','" + setToZero(ele.groupExmpt_number) + "','" + parseBody(ele.businessName) + "','" + setToZero(ele.is_valid) + "'),";
                            });
                            obj10.nonqrysql = qrystr.slice(0, -1);
                            obj10.prepare();
                            obj10.execute((err_userPro: any, user_res: any) => {
                                if (err_userPro == 1) {
                                    let obj11 = new ModelRawNonQuery(req, res);
                                    obj11.nonqrysql = "DELETE FROM `billing_address` WHERE `idaccount`='" + sdata.idaccount + "'";
                                    obj11.prepare();
                                    obj11.execute((error: any, deluserRes: any) => { });
                                } else {
                                    console.log({ message: "Data not Inserted Successfully in archive_billing_address!", status: 503 });
                                }
                            });
                        } else {
                            console.log({ message: "Data not found from billing_address!", status: 504 });
                        }
                    });

                    // Delete Connections 

                    let obj00 = new ModelRawQuery(req, res);
                    obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sdata.idaccount + "";
                    obj00.prepare();
                    obj00.execute((error: any, resultIdEnPoints: any) => {
                        if (error == 1 && resultIdEnPoints.length > 0) {
                            let ids:any = resultIdEnPoints.map((ele: any) => `'${ele.idendpoint}'`).join(",");
                            // Data Removed from Endpoint Table for Connection
                            let obj13 = new ModelRawNonQuery(req, res);
                            obj13.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`='" + sdata.idaccount + "'";
                            obj13.prepare();
                            obj13.execute((____error: any, result: any) => {
                                console.log("All Connection Data Deleted");
                            })
                           
                            let obj14 = new ModelRawNonQuery(req, res);
                            obj14.nonqrysql = "DELETE FROM `inbound` WHERE `idendpoint` IN (" + ids + ")";
                            obj14.prepare();
                            obj14.execute((____error: any, result: any) => {
                                console.log("All inbound Data Deleted");
                            });

                            // Data Removed from outbound Table for Connection
                            let obj15 = new ModelRawNonQuery(req, res);
                            obj15.nonqrysql = "DELETE FROM `outbound` WHERE `idendpoint` IN (" + ids + ")";

                            obj15.prepare();
                            obj15.execute((____error: any, result: any) => {
                                console.log("All outbound Data Deleted");
                            })

                            // Data Removed from hooksetting Table for Connection
                            let obj16 = new ModelRawNonQuery(req, res);
                            obj16.nonqrysql = "DELETE FROM `hooksetting` WHERE `idaccount`='" + sdata.idaccount + "'";
                            obj16.prepare();
                            obj16.execute((____error: any, result: any) => {
                                console.log("All hooksetting Data Deleted");
                            })

                            // Data Removed from ip_address Table for Connection
                            let obj17 = new ModelRawNonQuery(req, res);
                            obj17.nonqrysql = "DELETE FROM `ip_address` WHERE `idendpoint` IN (" + ids + ")";
                            obj17.prepare();
                            obj17.execute((____error: any, result: any) => {
                                console.log("All IP Address Data Deleted");
                            })

                            // Data Removed from ip_address Table for Connection
                            let obj18 = new ModelRawNonQuery(req, res);
                            obj18.nonqrysql = "DELETE FROM `routing_profile` WHERE `idendpoint` IN (" + ids + ")";
                            obj18.prepare();
                            obj18.execute((____error: any, result: any) => {
                                console.log("All Routing Profile Data Deleted");
                            })

                        } else {
                            console.log({ message: "Data not found from endpoint!", status: 504 });
                        }

                    });

                    //Data Removed from Session Table
                    let obj18 = new ModelRawNonQuery(req, res);
                    obj18.nonqrysql = "DELETE FROM `session` WHERE `idaccount`='" + sdata.idaccount + "'";
                    obj18.prepare();
                    obj18.execute((__error: any, delSessRes: any) => {
                        console.log("All Session Data Deleted");
                    })

                    //Data API from Session Table
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`=" + sdata.idaccount + " ";
                    obj0.prepare();
                    obj0.execute((___error: any, delApiRes: any) => {
                        console.log("All API Data Deleted");
                    });

                    let obj19 = new RawView(res);
                    obj19.prepare({ message: 'Customer Account Deleted Successfully.!', status: 201 });
                    obj19.execute();
                }
                else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    CustomerCount(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata: any = req.query.type;
                    let data = JSON.parse(sdata);
                    let idUser: any = data.iduser;
                    let IDAccount: any = data.idaccount;

                    // brand 
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT SUM(CASE WHEN identityStatus = '' AND deleted = 0 THEN 1 ELSE 0 END) AS pending_brand, SUM(CASE WHEN identityStatus = 'VERIFIED' AND deleted = 0 THEN 1 ELSE 0 END) AS verified, SUM(CASE WHEN identityStatus = 'VETTED_VERIFIED' AND deleted = 0 THEN 1 ELSE 0 END) AS vetted_verified, SUM(CASE WHEN identityStatus = 'UNVERIFIED' AND deleted = 0 THEN 1 ELSE 0 END) AS unverified, SUM(CASE WHEN identityStatus = 'SELF_DECLARED' AND deleted = 0 THEN 1 ELSE 0 END) AS self_declared, SUM(CASE WHEN deleted = 1 THEN 1 ELSE 0 END) AS deleted FROM brand WHERE STATUS = 0 AND `idaccount` = '" + IDAccount + "'";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            // campaign
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 7 AND c.deleted = 0 THEN 1 ELSE 0 END) AS pending_campaign, SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 1 AND c.deleted = 0 THEN 1 ELSE 0 END) AS campaign_shared, SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 0 AND c.deleted = 0 THEN 1 ELSE 0 END) AS approved_campaign, SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 5 AND c.deleted = 0 THEN 1 ELSE 0 END) AS rejected,SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 3 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_complete,SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 4 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_failed,SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 3 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_redundant_complete,SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 4 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_redundant_failed,SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 7 AND c.deleted = 0 THEN 1 ELSE 0 END) AS pending_redundant_campaign, SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 1 AND c.deleted = 0 THEN 1 ELSE 0 END) AS campaign_shared_redundant, SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 0 AND c.deleted = 0 THEN 1 ELSE 0 END) AS approved_redundant_campaign, SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 5 AND c.deleted = 0 THEN 1 ELSE 0 END) AS rejected_redundant_campaign, SUM(CASE WHEN c.STATUS = '2' OR c.STATUS = '0' THEN 1 ELSE 0 END) AS total_camp, SUM(CASE WHEN (c.STATUS = '2' ) AND c.deleted = 1 THEN 1 ELSE 0 END) AS deleted_camp,SUM(CASE WHEN ( c.STATUS = '0') AND c.deleted = 1 THEN 1 ELSE 0 END) AS deleted_redundant_camp FROM brand b INNER JOIN campaign c ON c.idbrand = b.brandId WHERE c.`idaccount` = '" + IDAccount + "'";
                            obj1.prepare();
                            obj1.execute((err: any, resultcam: any) => {
                                if (err == 1) {
                                    let obj2 = new ModelRawQuery(req, res);
                                    obj2.qrysql = "SELECT COUNT(*) AS total_conn, (SELECT name FROM endpoint WHERE iduser =  '" + idUser + "' AND isdefault = true LIMIT 1) AS default_name,(SELECT connection_key FROM endpoint WHERE iduser =  '" + idUser + "' AND isdefault = true LIMIT 1) AS connection_key FROM endpoint WHERE `iduser` = '" + idUser + "'";
                                    obj2.prepare();
                                    obj2.execute((errr: any, resultcon: any) => {
                                        if (errr == 1) {
                                            // tarrif  reselelr and etc
                                            let obj3 = new ModelRawQuery(req, res);
                                            obj3.qrysql = "SELECT COALESCE(u.kyc_verify_status, NULL) AS kyc_verify_status, COALESCE(u.federal_status, NULL) AS federal_status, COALESCE(t.name, NULL) AS tariff_name, COALESCE(s.name, NULL) AS service_name FROM user u LEFT JOIN tariff t ON u.idtariff = t.idtariff LEFT JOIN service s ON u.idservice = s.idservice WHERE u.iduser = '" + idUser + "' AND u.idaccount = '" + IDAccount + "'";
                                            obj3.prepare();
                                            obj3.execute((eror: any, resulttr: any) => {
                                                if (eror == 1) {
                                                    // subcustomer
                                                    let obj4 = new ModelRawQuery(req, res);
                                                    obj4.qrysql = "SELECT COUNT(*) AS total_subCust FROM user WHERE type = 22 AND `idaccount` = '" + IDAccount + "'";
                                                    obj4.prepare();
                                                    obj4.execute((erorr: any, resultsc: any) => {
                                                        if (erorr == 1) {
                                                            // credit cards 
                                                            let obj5 = new ModelRawQuery(req, res);
                                                            obj5.qrysql = "SELECT COALESCE(active_card, NULL) AS active_card, COALESCE(deleted_card, NULL) AS deleted_card, exp_year, last4, exp_month FROM (SELECT (SELECT COUNT(*) FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND isdeleted = '0') AS active_card, (SELECT COUNT(*) FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND isdeleted = '1') AS deleted_card, exp_year, last4, exp_month FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND `default` = true LIMIT 1) AS subquery UNION ALL SELECT NULL AS active_card, NULL AS deleted_card, NULL AS exp_year, NULL AS last4, NULL AS exp_month WHERE NOT EXISTS (SELECT 1 FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND `default` = true)";
                                                            obj5.prepare();
                                                            obj5.execute((errorr: any, resultCar: any) => {
                                                                if (errorr == 1) {

                                                                    // billing adre
                                                                    let obj6 = new ModelRawQuery(req, res);
                                                                    obj6.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, ba.ein, ba.website, ba.groupExmpt_number, ba.businessName, ba.customerType, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.`idaccount` = '" + IDAccount + "' WHERE up.`iduser` = '" + idUser + "'"
                                                                    obj6.prepare();
                                                                    obj6.execute((eroor: any, resultba: any) => {
                                                                        if (eroor == 1) {

                                                                            // Wallert 
                                                                            let obj4 = new ModelRawQuery(req, res);
                                                                            obj4.qrysql = "SELECT balance , min_balance,credit_limit,topup_amount FROM wallet WHERE `idaccount` = '" + IDAccount + "'";
                                                                            obj4.prepare();
                                                                            obj4.execute((errrr: any, resultw: any) => {
                                                                                if (errrr == 1) {
                                                                                    let obj4 = new ModelRawQuery(req, res);
                                                                                    obj4.qrysql = "SELECT COUNT(CASE WHEN a.as_status = '1' THEN 1 END) AS active_service, COUNT(CASE WHEN a.as_status = '0' THEN 1 END) AS suspended_service, GROUP_CONCAT(CASE WHEN a.as_status = '1' THEN f.fs_name END ORDER BY f.fs_name ASC SEPARATOR ', ') AS active_service_name, GROUP_CONCAT(CASE WHEN a.as_status = '0' THEN f.fs_name END ORDER BY f.fs_name ASC SEPARATOR ', ') AS suspended_service_name FROM account_service a INNER JOIN feature_service f ON a.fs_id = f.fs_id WHERE a.idaccount = '" + IDAccount + "'";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((errorr: any, resultsus: any) => {
                                                                                        if (errorr == 1) {
                                                                                            let obj4 = new ModelRawQuery(req, res);
                                                                                            obj4.qrysql = "SELECT SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' THEN 1 ELSE 0 END) AS active_local_did, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '0' THEN 1 ELSE 0 END) AS disconnect_local_did, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `osr_status` = 'register' AND `sinch_status` = '1' THEN 1 ELSE 0 END) AS active_sms_local, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '0' THEN 1 ELSE 0 END) AS disable_sms_local, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '2' THEN 1 ELSE 0 END) AS provisioning_waiting, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '3' THEN 1 ELSE 0 END) AS provisioning_inprocess, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '4' THEN 1 ELSE 0 END) AS provision_exist, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '5' AND (sinch_retry < '2' OR sinch_retry >= '2' )  THEN 1 ELSE 0 END) AS provision_failed, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' THEN 1 ELSE 0 END) AS active_tollfree_did, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '0' THEN 1 ELSE 0 END) AS disconnect_tollfree_did, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '1' AND `osr_status` = 'register' THEN 1 ELSE 0 END) AS active_sms_tollfree, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '0' THEN 1 ELSE 0 END) AS disable_sms_tollfree, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '15' THEN 1 ELSE 0 END) AS sms_capable_tollfree, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '16' THEN 1 ELSE 0 END) AS smsverification_inprocess_tollfree,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' THEN 1 ELSE 0 END) AS active_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '0' THEN 1 ELSE 0 END) AS disconnect_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '0' THEN 1 ELSE 0 END) AS random_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '1' THEN 1 ELSE 0 END) AS vanity_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '2' THEN 1 ELSE 0 END) AS migrated_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '3' THEN 1 ELSE 0 END) AS cust_migrated_shortcode_did FROM `did_buy` WHERE `account_id` = '" + IDAccount + "' AND iduser = '" + idUser + "'";
                                                                                            obj4.prepare();
                                                                                            obj4.execute((errrrr: any, resultdid: any) => {
                                                                                                if (errrrr == 1) {
                                                                                                    let obj4 = new ModelRawQuery(req, res);
                                                                                                    obj4.qrysql = "SELECT COALESCE(rp.firstname, NULL) AS firstname, COALESCE(rp.lastname, NULL) AS lastname, CASE WHEN u.signup_link_id IS NOT NULL THEN srl.url ELSE NULL END AS signup_url FROM `user` u LEFT JOIN reseller_profile rp ON u.reseller_iduser = rp.iduser LEFT JOIN signup_referral_link srl ON u.signup_link_id = srl.key WHERE u.iduser = '" + idUser + "' AND u.idaccount = '" + IDAccount + "' UNION ALL SELECT NULL AS firstname, NULL AS lastname, NULL AS signup_url WHERE NOT EXISTS (SELECT 1 FROM `user` u WHERE u.iduser = '" + idUser + "' AND u.idaccount = '" + IDAccount + "')";
                                                                                                    obj4.prepare();
                                                                                                    obj4.execute((errorr: any, resultres: any) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView(res);
                                                                                                            objv.prepare({ data: result, data2: resultcam, data3: resultcon, data4: resulttr, data5: resultsc, data6: resultCar, data7: resultba, data8: resultw, data9: resultsus, data10: resultdid, data11: resultres, message: "Customer Data Fetched Successfully", status: 201 });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView(res);
                                                                                                            objv.prepare({ message: "Something Went Wrong With Details!", status: 502 });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    })

                                                                                                } else {
                                                                                                    let objv = new RawView(res);
                                                                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                                                    objv.execute();
                                                                                                }

                                                                                            })

                                                                                        } else {
                                                                                            let objv = new RawView(res);
                                                                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                                            objv.execute();
                                                                                        }

                                                                                    })
                                                                                } else {
                                                                                    let objv = new RawView(res);
                                                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                                    objv.execute();
                                                                                }
                                                                            })
                                                                        } else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    })
                                                                } else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            })

                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    })


                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                    objv.execute();
                                                }

                                            })

                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            })

                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    })


                } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getattachment(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT un.id AS user_note_id,un.iduser,un.idaccount,un.description,un.created_at AS user_note_created_at,GROUP_CONCAT(una.filepath SEPARATOR ', ') AS filepaths,GROUP_CONCAT(una.filename SEPARATOR ', ') AS filenames FROM user_notes AS un LEFT JOIN user_notes_attachment AS una ON un.id = una.id WHERE un.iduser = '" + req.query.type + "' GROUP BY un.id, un.iduser, un.idaccount, un.description, un.created_at";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Notes fetched successfully",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
        });
    }

    SendUserNotes(req: Request, res: Response, next: NextFunction) {
        const session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error === 1) {
                const sssdata = req.body.data;
                const lastInsertion = JSON.parse(sssdata.lastId);
                const obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `user_notes` (`iduser`, `idaccount`,`description`, `created_at`) VALUES ('" + sssdata.iduser + "','" + sssdata.idaccount + "','" + parseBody(sssdata.note) + "', NOW())";
                obj.prepare();
                obj.execute((errr: any, result: any) => {
                    if (errr === 1) {
                        let insertedId = result.insertId;
                        let updateCount = 0;
                        if (lastInsertion.length === 0) {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 200,
                                message: "User Notes Saved Successfully",
                            });
                            objv.execute();
                            return;
                        }
                        lastInsertion.forEach((id: string) => {
                            let obj3 = new ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE `user_notes_attachment` SET `id` = '" + insertedId + "' WHERE `id_una` = '" + id + "'";
                            obj3.prepare();
                            obj3.execute((err: any, result: any) => {
                                updateCount++;
                                if (updateCount === lastInsertion.length) {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 200,
                                        message: "User Notes Saved Successfully",
                                    });
                                    objv.execute();
                                }

                                if (err !== 1) {
                                    console.error("Failed to update attachment:", id);
                                }
                            });
                        });
                    } else {
                        let objv = new Res406(res);
                        objv.prepare({ status: 401, message: "Unable To insert User Notes!" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getRecentAttechment(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let ssdata = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id_una`,`id`,`unique_upload_id`,`filename`,`filepath`,`created_at` FROM `user_notes_attachment` WHERE `unique_upload_id`='" + ssdata.type + "' ORDER BY `created_at` DESC LIMIT 1";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "File Upload Successfully",
                            data: sData[0]
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something wwent wrong while uploading file"
                        });
                        objv.execute();
                    }
                });
            }
        });
    }
    deleteUserNotes(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let ssdata = req.query;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `user_notes_attachment` WHERE `id_una`='" + ssdata.id + "'";
                obj.prepare();
                obj.execute((err: any, delRes: any) => {
                    if (err == 1) {
                        let obj = new RawView(res);
                        obj.prepare({ status: 201, message: " Notes File Deleted Successfully" });
                        obj.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something wwent wrong while deleting file"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    saveUserNoteFile(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let ssdata = req.body;
                let file = req.files;
                let uploadedFile: any;
                let fileSize: any;
                if (Array.isArray(file)) {
                    uploadedFile = file[0];
                } else {
                    uploadedFile = file && file['ATTACHMENTS'] ? file['ATTACHMENTS'][0] : undefined;
                }
                if (!uploadedFile) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "No file uploaded", status: 400 });
                    objv.execute();
                    return;
                }
                fileSize = uploadedFile.size;
                const maxIndividualFileSizeBytes = 5 * 1024 * 1024;
                if (fileSize <= maxIndividualFileSizeBytes) {
                    const isValid = MIME_TYPE_MAPs[uploadedFile.mimetype];
                    if (!isValid) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "File type " + uploadedFile.filename.split('.').pop() + " not accepted", status: 402 });
                        objv.execute();
                        return;
                    }
                    let value = note.Notescsv + uploadedFile.filename;
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `user_notes_attachment` (`unique_upload_id`, `filename`, `filepath`, `created_at`) VALUES ('" + ssdata.UNKEY + "', '" + uploadedFile.filename + "', '" + value + "', NOW())";
                    obj.prepare();
                    obj.execute((_err: any, result: any) => {
                        if (_err == 1) {
                            let lastid = result.insertId;
                            let objv = new RawView(res);
                            objv.prepare({ message: 'Notes File Uploaded Successfully', data: result, lastId: lastid, status: 200 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 505 });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: 'File size limit exceeded', status: 200 });
                    objv.execute();
                }
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    phoneVerification(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err === 1) {
                const sdata = req.body.data;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `country` FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_err: any, result: any) => {
                    if (_err === 1) {
                        let country = result[0].country;
                        if (!['US', 'CA', 'USA', 'UNITED STATES', 'CANADA'].includes(country)) {
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`= 'true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                            obj1.prepare();
                            obj1.execute((_error: any, success: any) => {
                                if (_error === 1) {
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj5.prepare();
                                    obj5.execute((_sessErr: any, sessRes: any) => {
                                        if (_sessErr === 1) {
                                            let obj6 = new ModelRawNonQuery(req, res);
                                            obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                            obj6.prepare();
                                            obj6.execute((_sessError: any, sessData: any) => {
                                                if (_sessError === 1) {
                                                    let objup = new ModelRawQuery(req, res);
                                                    objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                                    objup.prepare();
                                                    objup.execute((__errorE: any, emailE: any) => {
                                                        let emails = emailE[0].email !== '' && emailE[0].email !== undefined && emailE[0].email !== 'undefined' ? emailE[0].email : '';
                                                        if (__errorE === 1) {
                                                            let obj7 = new ModelRawQuery(req, res);
                                                            obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                            obj7.prepare();
                                                            obj7.execute((sError: any, sData: any) => {
                                                                if (sError === 1) {
                                                                    let tmp: string = "{\"email\": \"" + emails + "\"}";
                                                                    let emType = JSON.parse(tmp);
                                                                    let temp1 = "{\"country\": \"" + country + "\"}";
                                                                    let temp2 = JSON.parse(temp1);
                                                                    let data1: any = Object.assign(sData[0], emType, temp2);
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({
                                                                        message: "Phone Number Updated Successfully!",
                                                                        status: 200,
                                                                        session: data1
                                                                    });
                                                                    objv.execute();
                                                                } else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({
                                                                        message: "Phone verified error with connection!",
                                                                        status: 502
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({
                                                                message: "Unable to fetch email!",
                                                                status: 500
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        message: "Phone number update failed!",
                                                        status: 502
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                errMessage: "Mobile verification session update failed!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "User update failed!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        } else {
                            let objup = new ModelRawQuery(req, res);
                            objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                            objup.prepare();
                            objup.execute((__errorE: any, emailE: any) => {
                                let emails = emailE[0].email !== '' && emailE[0].email !== undefined && emailE[0].email !== 'undefined' ? emailE[0].email : '';
                                if (__errorE === 1) {
                                    let obj7 = new ModelRawQuery(req, res);
                                    obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                    obj7.prepare();
                                    obj7.execute((sError: any, sData: any) => {
                                        if (sError === 1) {
                                            let tmp: string = "{\"email\": \"" + emails + "\"}";
                                            let emType = JSON.parse(tmp);
                                            let temp1 = "{\"country\": \"" + country + "\"}";
                                            let temp2 = JSON.parse(temp1);
                                            let data1: any = Object.assign(sData[0], emType, temp2);
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Your address is updated from admin side we have to refresh your page",
                                                status: 505,
                                                session: data1
                                            });
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Something went wrong!",
                                                status: 505
                                            });
                                            objv.execute();
                                        }
                                    });
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Something went wrong!",
                                        status: 505
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Failed to fetch country!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    userFilterfornonus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let qdata: any = req.query.type;
                    var sdata = JSON.parse(qdata);
                    let iQry: string = "",
                        iQN: number = 0,
                        cond: string = "";
                    iQry = "SELECT DISTINCT u.kyc_verify_status,u.volt_status,u.trust_score,u.federal_status,u.card_pdf,a.san,u.reseller_iduser,a.is_billing,u.isEmailVerify,w.balance,w.credit_limit,u.isMobileVerify,u.isAddress, 1 `utype`,u.isPlan, u.iduser, u.idaccount, u.`username` `user_name`, u.type,u.is_deleted,u.deleted_date , u.pending_deleted_date , isCard,newUser_status,ba.title, u.created , up.firstname `first_name`, up.lastname `last_name`, up.email, up.phone `contact_number`,IF(LENGTH(up.profile_pic)=0 || up.profile_pic='undefined' || up.profile_pic IS NULL, CONCAT(CEIL(1+RAND()*7),'.jpg'), up.profile_pic) profile_pic, u.idtariff, u.idservice ,ba.country FROM `user` u LEFT JOIN `account` a ON a.idaccount=u.idaccount LEFT JOIN `user_profile` up ON u.iduser=up.iduser LEFT JOIN `wallet` w ON w.idaccount = u.idaccount LEFT JOIN `billing_address` ba ON ba.idaccount = u.idaccount  WHERE u.type = 2 "

                    // iQry = "SELECT * FROM `user` \n"
                    if ((Array.isArray(sdata.san) && sdata.san.length > 0 && sdata.san[0].userdata)) {
                        cond += cond += "AND u.idaccount='" + sdata.san[0].userdata + "' "
                        iQN++
                    }

                    if (sdata.from_date != '' && sdata.from_date && !sdata.to_date) {
                        cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' "
                        iQN++
                    }

                    if (sdata.to_date != '' && sdata.to_date && !sdata.from_date) {
                        cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' "
                        iQN++
                    }

                    if (sdata.from_date && sdata.to_date) {
                        cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' "
                        iQN++
                    }

                    if (sdata.emailid != '' && sdata.emailid) {
                        cond += "AND up.email ='" + sdata.emailid + "' "
                        iQN++
                    }
                    if (sdata.customername != '' && sdata.customername) {
                        cond += "AND CONCAT(up.firstname, ' ', up.lastname) COLLATE utf8mb4_general_ci LIKE '%" + parseBody(sdata.customername) + "%' ";
                        iQN++;
                    }
                    if (iQN > 0) {
                        iQry += cond
                        iQry = iQry.slice(0, -1) + "\n"
                    }
                    iQry += "ORDER BY `created`;"
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = iQry
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "User Fetched Successfully.",
                                status: 201
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Something Went Wrong!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getUserType(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `id_user_type` , `user_type` , `user_type_name` FROM `sm_user_type`";
                obj1.prepare();
                obj1.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, message: "User Type Fetched Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    setUserPassword(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.body.data;
        let password1 = bcrypt.hashSync(sdata.password, 10)
        let obj = new ModelRawNonQuery(req, res);
        obj.nonqrysql = "UPDATE `user` SET `password` = '" + password1 + "',`ext_name`='" + sdata.password + "',`resetPassword`='1' WHERE `validationKey`= '" + sdata.key + "' AND `is_deleted`=0";
        obj.prepare();
        obj.execute((error: any, result: any) => {
            if (error == 1) {
                let obj1 = new RawView(res);
                obj1.prepare({ message: 'Password set successfully!', status: 201 });
                obj1.execute();
            }
            else {
                let obj2 = new RawView(res);
                obj2.prepare({ message: 'Something went wrong with setting password!', status: 502 });
                obj2.execute();
            }
        });
    }

    getPermissions(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT rp.`id_role`, rp.`feature_id`, rp.`module_id`, rp.`read`, rp.`write`, rp.`id_user_type`, f.`feature_name`, m.`module_name` FROM `sm_roles_and_permissions` rp JOIN `sm_user_type` ut ON rp.`id_user_type` = ut.`id_user_type` JOIN `sm_features` f ON rp.`feature_id` = f.`feature_id` JOIN `sm_modules` m ON rp.`module_id` = m.`module_id` WHERE ut.`user_type` = " + sessdata.type + "";
                obj1.prepare();
                obj1.execute((error: any, result: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 200, message: "User Permissions Fetched Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getmultiuser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT up.firstname AS user_firstname, up.lastname AS user_lastname, u.created, up.email, u.username, u.iduser, u.idaccount,u.password, u.type, up_main.firstname AS account_firstname, up_main.lastname AS account_lastname, up.phone FROM `user` u LEFT JOIN `user_profile` up ON up.iduser = u.iduser LEFT JOIN `user_profile` up_main ON up_main.iduser = (SELECT up_sub.iduser FROM `user` u_sub JOIN `user_profile` up_sub  ON up_sub.iduser = u_sub.iduser WHERE u_sub.idaccount = u.idaccount ORDER BY u_sub.created ASC LIMIT 1) WHERE u.type IN (22, 201, 202, 203, 231, 232);";

                    obj1.prepare();
                    obj1.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, message: "Multi-User list Fetched Successfully!", data: result });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong with multiuser!" });
                            objv.execute();
                        }
                    })
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    multiuserfilter(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let data: any = req.query.type;
                    let sdata: any = JSON.parse(data);
                    let condition: any = "";
                    let obj = new ModelRawQuery(req, res);

                    if (sdata.customername) {
                        condition += " AND `u`.`idaccount` = '" + sdata.customername + "'";
                    }

                    if (sdata.email) {
                        condition += ' AND `up`.`email` = "' + parseBody(sdata.email) + '" ';

                    }
                    if (sdata.usertype) {
                        condition += ' AND `u`.`type` = "' + sdata.usertype + '"';
                    }

                    if (data.from_date && data.to_date) {
                        condition += ' AND `u`.`created` BETWEEN "' + sdata.from_date + ' 00:00:00" AND "' + sdata.to_date + ' 23:59:59"';
                    }

                    if (sdata.additionaluser) {
                        condition += ' AND `u`.`iduser` = "' + sdata.additionaluser + '"';
                    }

                    obj.qrysql = "SELECT up.firstname AS user_firstname, up.lastname AS user_lastname, u.created, up.email, u.username, u.iduser, u.idaccount,u.password, u.type, up_main.firstname AS account_firstname, up_main.lastname AS account_lastname, up.phone FROM `user` u LEFT JOIN `user_profile` up ON up.iduser = u.iduser LEFT JOIN `user_profile` up_main ON up_main.iduser = (SELECT up_sub.iduser FROM `user` u_sub JOIN `user_profile` up_sub  ON up_sub.iduser = u_sub.iduser WHERE u_sub.idaccount = u.idaccount ORDER BY u_sub.created ASC LIMIT 1) WHERE u.type IN (22, 201, 202, 203, 231, 232) " + condition + "";

                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                data: result,
                                message: "MultiUser List Fetched Successfully!",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "Something Went Wrong With List!",
                                status: 502,
                                error: result
                            });
                            objv.execute();
                        }
                    });
                } else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

}

export class TZ {
    /**
     * To create the default TimeZone of user
     */
    CreateTZ(req: Request, res: Response, next: NextFunction, callback: (error: any, data: any) => void) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj1 = new ModelRawNonQuery(req, res);
                obj1.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(192, " + sessdata.iduser + ");"
                obj1.prepare()
                obj1.execute((error: any, result: any) => {
                    if (error == 1) {
                        /**
                         * Update the TimeZone in user's session data
                         */
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT a.utc client_time FROM tbl_timezones a WHERE a.id=192;"
                        obj2.prepare()
                        obj2.execute((error: any, result: any) => {
                            if (error == 1 && Array.isArray(result) && result.length > 0) {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `session` SET `client_time`='" + result[0].client_time + "' WHERE `authkey`='" + sessdata.authkey + "';"
                                obj3.prepare()
                                obj3.execute((error: any, result2: any) => {
                                    sessdata.client_time = result[0].client_time
                                    sessiondata.set(sessdata.authkey, sessdata)
                                    callback(error, result)
                                })
                            }
                            else {
                                callback(error, result)
                            }
                        })
                    }
                    else {
                        callback(error, result)
                    }
                })
            }
            else {
                callback(error, { status: 401, message: "Unauthorized User!" })
            }
        });
    }
}