"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountDelete = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const markError_1 = require("./markError");
// import { AppRoute } from "../lib/AppRoute";
const RawQuery_1 = require("../lib/model/RawQuery");
const setting_config_1 = require("../config/setting.config");
const request = require("request");
const server_1 = require("../server");
const stripeApi_1 = require("./stripeApi");
const newcampaign_class_1 = require("./newcampaign.class");
const APIBase_1 = require("./APIBase");
const Str = require('@supercharge/strings');
// var nodemailer = require("nodemailer");
const jwt = require('jsonwebtoken');
const appealEvidence = new setting_config_1.AppealEvidence();
const cspSetting = new setting_config_1.CSPApiConfig();
const authKey = cspSetting.AUTHKEY;
// const apiUrl = cspSetting.APIURL;
const avalaraTax = new setting_config_1.AvalaraTax();
const urlLogin = avalaraTax.URLLOGIN;
const apiusername = avalaraTax.APIUSERNAME;
const apipassword = avalaraTax.APIPASSWORD;
// const urlPcode = avalaraTax.URLPCODE;
const urlGeoCode = avalaraTax.URLGEOCODE;
const urlCal_tacx = avalaraTax.URLCALTACX;
const urlcommit = avalaraTax.URLCOMMIT;
const FromSmtpMail = new setting_config_1.SMTPDetails();
const FromEmail = FromSmtpMail.from;
let walletlog = new APIBase_1.APIBase();
class AccountDelete {
    constructor() {
        // super();
    }
    getLastInvoiceId(req, res, idaccount, cmon, next) {
        return new Promise((resolve, reject) => {
            console.log(":::::::::::::::::::::::Invoice generation Started ::::::::::::::::::::::");
            let inName = "IN", randNo = Math.floor(10000000 + Math.random() * 90000000).toString();
            let invoice_number = inName.toUpperCase() + randNo;
            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
            obj1.qrysql = "SELECT idinvoice, invoice_number FROM `invoice` WHERE `idaccount`='" + idaccount + "' AND DATE_FORMAT(`created_at`, '%Y-%m')='" + cmon + "' AND `ai_status`='0' AND invoice_type=1 ORDER BY idinvoice DESC LIMIT 1";
            obj1.prepare();
            obj1.execute(async (_error, result1) => {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `san`,`first_name`,`last_name`, CONCAT_WS(' ', first_name, last_name) AS customer_name, `address1`,`address2`,`city`,`state`,`postal_code`,country,`email`,`contact` FROM `billing_address` ba JOIN `account` a ON ba.idaccount = a.idaccount  WHERE ba.`idaccount`=" + idaccount + "";
                obj.prepare();
                obj.execute(async (error, result) => {
                    if (error == 1) {
                        if (result.length > 0) {
                            if (result1.length == 0) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `invoice`(`idaccount`,`invoice_number`,`san`,`first_name`,`last_name`,`address1`,`address2`,`city`,`state`,`postal_code`,`country`,`email`,`phone`,`customer_name`, `invoice_type`) VALUES ('" + idaccount + "','" + invoice_number + "','" + result[0].san + "','" + (0, markError_1.parseBody)(result[0].first_name) + "','" + (0, markError_1.parseBody)(result[0].last_name) + "','" + (0, markError_1.parseBody)(result[0].address1) + "','" + (0, markError_1.parseBody)(result[0].address2) + "','" + (0, markError_1.parseBody)(result[0].city) + "','" + result[0].state + "','" + result[0].postal_code + "','" + result[0].country + "','" + (0, markError_1.parseBody)(result[0].email) + "','" + result[0].contact + "','" + (0, markError_1.parseBody)(result[0].customer_name) + "', 1)";
                                obj1.prepare();
                                obj1.execute((__error, data) => {
                                    if (__error == 1) {
                                        let dataRes = Object.assign(result[0], { invoice_number: invoice_number, last_invoice: data.insertId });
                                        console.log("dataRes :: ", dataRes);
                                        resolve(dataRes);
                                        console.log("insert successfully");
                                    }
                                    else {
                                        console.log("something went wrong");
                                        reject(0);
                                    }
                                });
                            }
                            else {
                                let dataRes = Object.assign(result[0], { invoice_number: result1[0].invoice_number, last_invoice: result1[0].idinvoice });
                                resolve(dataRes);
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Billing Address not available!", status: 401 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something went wrong with billing address!", status: 501 });
                        objv.execute();
                    }
                });
            });
        });
    }
    // Fetching MRC Local Number data
    /* DIDMrcCharged(req: Request, res: Response, idaccount: any, cmon: any, last_invoice: any, totalamt: any, taxlData:any, toInvoiceData:any, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let obj00 = new ModelRawQuery(req, res);

            obj00.qrysql = "SELECT t.type, IFNULL(d.dids, 0) AS dids, IFNULL(d.cost, 0) AS cost FROM (SELECT 'NN' AS type UNION SELECT 'TF') AS t LEFT JOIN (SELECT `type`, COUNT(*) AS dids, SUM(pro_rates) AS cost FROM did_buy WHERE `type` IN ('NN', 'TF') AND iduser IN (SELECT iduser FROM `user` WHERE idaccount = " + idaccount + ") AND DATE_FORMAT(created_at, '%Y-%m') = '" + cmon + "' AND `disconnect_did_status` = 1 GROUP BY `type`) AS d ON t.type = d.type";

            obj00.prepare();
            obj00.execute((error: any, currMRC: any) => {
                let mrccost=0;
                if (error ==1 &&  currMRC.length > 0) {
                    let qry = 'INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUE ';
                    
                    currMRC.forEach((elm:any) => {
                        let dids = elm?.dids ?? 0, cost = elm?.cost ?? 0, key='', label='', subcat=0;
                        switch (elm.type) {
                            case 'NN':
                                key = 'pre_dids_nn'; label = 'US/CAN Local Number - Tier 1'; subcat=0;
                                break;
                            case 'TF':
                                key = 'pre_dids_tf'; label = 'US/CAN Tollfree Number - Tier 1'; subcat=1;
                                break;
                        }
                        
                        taxlData.push({[key]:{key:key, qty:dids, total:cost}})

                        console.log("DIDMrcCharged Total Amt : " + totalamt + " mrccost : " + mrccost + " cost : " + cost + " = " + (totalamt + cost) + " Key Data : ["+  key, dids, cost + ']')
                        // To Full Sum
                        totalamt += cost;
                        mrccost += cost;

                        qry += `('${last_invoice}', '${key}', '${dids}', '${cost}', '5', '${subcat}', '${label}'),`;

                        toInvoiceData.push({idinvoice:last_invoice, key:key, value:dids, cost:cost, category:5, subcategory:subcat, label:label})
                        
                    });
                    
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = qry.slice(0, -1);
                    obj0.prepare();
                    obj0.execute((__error: any, data: any) => {
                        console.log("DIDs Current MRC Inserted Successfully");
                    });
                    resolve({ mrccost, totalamt });
                }
                else{
                    resolve({ mrccost, totalamt });
                    console.log("Something went wrong with DIDs Current MRC Insertion");
                }
            });
        });
    } */
    // Fetching MRC Campaign data
    /* getMrcCampData(req: Request, res: Response, idaccount: any, cmon: any, last_invoice: any, totalamt: any, taxlData:any, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let obj0004 = new ModelRawQuery(req, res);
            // obj0004.qrysql = "SELECT SUM(IF(campaign_key IS NOT NULL, 1, 0)) `campaigns`, SUM(IF(campaign_key IS NOT NULL, cost, 0)) `cost` FROM brand_log  WHERE idaccount='" + sessdata.idaccount + "' AND DATE_FORMAT(`current_date`,'%Y-%m')='" + cmon + "'";
            obj0004.qrysql = "SELECT COUNT(*)`campaigns`, SUM(`cost`)`cost` FROM (SELECT * FROM `campaign` WHERE `deleted`=0 AND `status`=0 GROUP BY `campaign_key`)`cc` WHERE cc.idaccount='" + idaccount + "' AND DATE_FORMAT(`current_date`,'%Y-%m')='" + cmon + "'";
            obj0004.prepare();
            obj0004.execute((___error: any, ibprecamp: any) => {
                let campaigns = ibprecamp[0].campaigns !== undefined && ibprecamp[0].campaigns !== null && ibprecamp[0].campaigns ? ibprecamp[0].campaigns : 0;
                let cost = ibprecamp[0].cost !== undefined && ibprecamp[0].cost !== null && ibprecamp[0].cost ? ibprecamp[0].cost : 0;
                let objb = new ModelRawNonQuery(req, res);
                objb.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'pre_campaign','"
                    + campaigns + "','" + cost + "','6','0','Campaigns')";
                objb.prepare();
                objb.execute((__error: any, data: any) => {
                });

                taxlData.push({pre_campaign:{key: 'pre_campaign', qty:campaigns, total:cost}})

                if (ibprecamp.length > 0) {
                    totalamt += cost
                    resolve({ ibprecamp, totalamt });
                } else {
                    resolve({ ibprecamp, totalamt });
                }
            });
        });
    } */
    //Fetching MRC Redundant Campaign data
    campaignRedundant(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
            obj0004.qrysql = "SELECT COUNT(*)`campaigns`,SUM(cl.`cost`)`ccost` FROM `campaign_log` cl JOIN campaign c ON c.`campaign_key`=cl.`campaign_key` WHERE cl.idaccount='" + idaccount + "' AND DATE_FORMAT(cl.`date`,'%Y-%m')='" + cmon + "' AND c.`deleted`=0 AND c.`status` = 2 AND cl.event_type=1";
            obj0004.prepare();
            obj0004.execute((error, redcamp) => {
                let campaigns = redcamp[0]?.campaigns ?? 0, cost = redcamp[0]?.ccost ?? 0;
                let qry = 'INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ';
                // To red MRC calculation
                qry += `('${last_invoice}', 'red_campaign', '${campaigns}', '${cost}', '6', '1', 'Redundant Campaign'),`;
                toInvoiceData.push({ idinvoice: last_invoice, key: 'red_campaign', value: campaigns, cost: cost, category: 6, subcategory: 1, label: 'Redundant Campaign' });
                taxlData.push({ red_campaign: { key: 'red_campaign', qty: campaigns, total: cost } });
                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj0.nonqrysql = qry.slice(0, -1);
                obj0.prepare();
                obj0.execute((__error, data) => {
                    console.log("Redundant Inserted Successfully");
                });
                /* //  To Full Sum of registerd and mrc redundant campaign
                // totalamt += cost + cost;
                // /  To Sum of registerd redundant campaign */
                console.log("campaignRedundant Total Amt : " + totalamt + " + cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ red_campaign", campaigns, cost + ']');
                totalamt += cost;
                // resolve({ mrccost:cost, totalamt });
                resolve(totalamt);
            });
        });
    }
    //Fetching Redunant Campaign Registration
    /* fetchRedCampaignData(req: any, res: any, idaccount: any, cmon: any, last_invoice: any, totalamt: any, next: any) {
        return new Promise((resolve, reject) => {
            let obj0001 = new ModelRawQuery(req, res);

            obj0001.qrysql = "SELECT COUNT(*)`campaigns`,SUM(cl.`cost`)`ccost` FROM `campaign_log` cl JOIN campaign c ON c.`campaign_key`=cl.`campaign_key` WHERE cl.idaccount='" + idaccount + "' AND DATE_FORMAT(cl.`date`,'%Y-%m')='" + cmon + "' AND c.`deleted`=0 AND c.`status` = 2 AND cl.event_type=1";
            obj0001.prepare();
            obj0001.execute((___error: any, ibbrand: any) => {
                let ibcampaigns = ibbrand[0].campaigns !== undefined && ibbrand[0].campaigns !== null && ibbrand[0].campaigns ? ibbrand[0].campaigns : 0;
                let cost = ibbrand[0].ccost !== undefined && ibbrand[0].ccost !== null && ibbrand[0].ccost ? ibbrand[0].ccost : 0;
                let objc = new ModelRawNonQuery(req, res);
                objc.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'red_camp_reg','"
                    + ibcampaigns + "','" + cost + "','4','2','Redundant Campaign')";
                objc.prepare();
                objc.execute((__error: any, data: any) => {
                });
                if (ibbrand.length > 0) {
                    totalamt += cost
                    resolve(parseFloat(totalamt));
                } else {
                    resolve(parseFloat(totalamt))
                }
            });
        });
    } */
    // Fetching MRC Local Phone Number SMS Enablement data
    /* getPhoneNoSmsEnablement(req: Request, res: Response, idaccount: any, cmon: any, last_invoice: any, totalamt: any, taxlData:any, toInvoiceData:any, next: NextFunction) {
        return new Promise((resolve, reject) => {
            let obj0003 = new ModelRawQuery(req, res);
            obj0003.qrysql = "SELECT iduser, COUNT(*) AS dids, SUM(sms_mrc) AS cost FROM did_buy WHERE sms_mrc > 0 AND iduser IN (SELECT iduser FROM user WHERE idaccount = '" + idaccount + "')  AND disconnect_did_status = 1";
            obj0003.prepare();
            obj0003.execute((error: any, smsenable: any) => {
                let dids = smsenable[0]?.dids ?? 0;
                let cost = smsenable[0]?.cost ?? 0;
                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "','sms_enable_mrc','" + dids + "','" + cost + "','5','2','Phone Number SMS Enablement')";
                obj0.prepare();
                obj0.execute((error: any, data: any) => {
                });

                console.log("getPhoneNoSmsEnablement Total Amt : " + totalamt + " + mrccost : " + cost + " Key Data : [ sms_enable_mrc" , dids, cost + ']')
                
                totalamt += cost
                
                taxlData.push({sms_enable_mrc : {key: 'sms_enable_mrc', qty:dids, total:cost}})

                toInvoiceData.push({idinvoice:last_invoice, key:'sms_enable_mrc', value:dids, cost:cost, category:5, subcategory:2, label:'Phone Number SMS Enablement'})

                resolve({ mrccost:cost, totalamt });

            });
        });
    } */
    //  Fetching loop api data
    getlookupApiData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
            obj0004.qrysql = "SELECT IFNULL(COUNT(*),0) AS `api`, IFNULL(SUM(`cost`), 0) AS cost FROM `api_charges_log` WHERE idaccount='" + idaccount + "' AND DATE_FORMAT(`created_at`,'%Y-%m')='" + cmon + "'";
            obj0004.prepare();
            obj0004.execute((error, lookupRes) => {
                let api = lookupRes[0]?.api ?? 0;
                let cost = lookupRes[0]?.cost ?? 0;
                let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                objb.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'lookup','"
                    + api + "','" + cost + "','8','0','Lookup - Number Details')";
                objb.prepare();
                objb.execute((error, data) => {
                });
                console.log("getlookupApiData Total Amt : " + totalamt + " cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ lookup", api, cost + ']');
                totalamt += cost;
                taxlData.push({ lookup: { key: 'lookup', qty: api, total: cost } });
                toInvoiceData.push({ idinvoice: last_invoice, key: 'lookup', value: api, cost: cost, category: 8, subcategory: 0, label: 'Lookup - Number Details' });
                resolve(totalamt);
            });
        });
    }
    //  Fetching Subscription Charges data
    getSubscriptionData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
            obj0004.qrysql = "SELECT a.idaccount, a.quantity, (a.quantity * b.mrc)`cost`, b.description FROM `subscription_account` a INNER JOIN `subscription` b ON a.subscription_id=b.subscription_id WHERE idaccount='" + idaccount + "' AND DATE_FORMAT(`end_date`,'%Y-%m')='" + cmon + "' OR DATE_FORMAT(end_date, '%Y-%m') = '0000-00' AND status = 1";
            obj0004.prepare();
            obj0004.execute((error, subsRes) => {
                let ct = 0;
                let subcost = 0;
                let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                if (subsRes.length > 0) {
                    let qry = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES";
                    subsRes.forEach((ele) => {
                        ct++;
                        let skey = 'sub_' + ct;
                        console.log("getSubscriptionData Total Amt : " + totalamt + " + mrccost : " + subcost + " Key Data : [ skey", ele.quantity, ele.cost + ']');
                        totalamt += ele.cost ?? 0;
                        subcost += ele.cost ?? 0;
                        taxlData.push({ [skey]: { key: skey, qty: ele.quantity, total: ele.cost } });
                        qry += "('" + last_invoice + "' ,'" + skey + "','" + (0, markError_1.setToZero)(ele.quantity) + "','" + (0, markError_1.setToZero)(ele.cost) + "','7','1','" + (0, markError_1.parseBody)(ele.description) + "'),";
                        toInvoiceData.push({ idinvoice: last_invoice, key: skey, value: ele.quantity, cost: (0, markError_1.setToZero)(ele.cost), category: 7, subcategory: 1, label: (0, markError_1.parseBody)(ele.description) });
                    });
                    objb.nonqrysql = qry.slice(0, -1);
                    objb.prepare();
                    objb.execute((_error, result) => { });
                    resolve({ mrccost: subcost, totalamt });
                }
                else {
                    resolve({ mrccost: subcost, totalamt });
                }
            });
        });
    }
    //Fetching Campaign Review data
    campaignReview(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
            obj0004.qrysql = "SELECT COUNT(*)`campaigns`, SUM(`cost`)`ccost` FROM campaign_log  WHERE idaccount='" + idaccount + "' AND event_type='27' AND DATE_FORMAT(`date`,'%Y-%m')='" + cmon + "'";
            obj0004.prepare();
            obj0004.execute((error, campReviewRes) => {
                let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let campaigns = campReviewRes[0]?.campaigns ?? 0, cost = campReviewRes[0]?.ccost ?? 0;
                objb.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'campaign_review','"
                    + campaigns + "','" + cost + "','4','0','Campaign Review')";
                objb.prepare();
                objb.execute((error, data) => {
                });
                console.log("campaignReview Total Amt : " + totalamt + " + cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ campaign_review", campaigns, cost + ']');
                totalamt += cost;
                taxlData.push({ campaign_review: { key: 'campaign_review', qty: campaigns, total: cost } });
                toInvoiceData.push({ idinvoice: last_invoice, key: 'campaign_review', value: campaigns, cost: cost, category: 4, subcategory: 0, label: 'Campaign Review' });
                resolve(totalamt);
            });
        });
    }
    callInAndOutData(req, res, idaccount, cmon, totalamt, last_invoice, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj02 = new RawQuery_1.ModelRawQuery(req, res);
            obj02.qrysql = "SELECT directions.direction, zones.zone, IFNULL(SUM(invoice_cdr.duration), 0) AS duration, IFNULL(SUM(invoice_cdr.cost), 0) AS callcost FROM (SELECT 'inbound' AS direction UNION ALL SELECT 'outbound') AS directions CROSS JOIN (SELECT 'toll_free' AS zone UNION ALL SELECT 'Zone 1' AS zone UNION ALL SELECT 'Zone 2' AS zone UNION ALL SELECT 'Zone 3' AS zone UNION ALL SELECT 'Zone 4' AS zone UNION ALL SELECT 'Zone 5' AS zone) AS zones LEFT JOIN invoice_cdr ON invoice_cdr.direction = directions.direction AND ((zones.zone = 'toll_free' AND invoice_cdr.zone IN ('toll_free', '800')) OR (zones.zone = 'Zone 1' AND invoice_cdr.zone IN ('Zone 1', '1')) OR (zones.zone = 'Zone 2' AND invoice_cdr.zone IN ('Zone 2', '2')) OR (zones.zone = 'Zone 3' AND invoice_cdr.zone IN ('Zone 3', '3')) OR (zones.zone = 'Zone 4' AND invoice_cdr.zone IN ('Zone 4', '4')) OR (zones.zone = 'Zone 5' AND invoice_cdr.zone IN ('Zone 5', '5'))) AND invoice_cdr.iduser IN (SELECT iduser FROM `user` WHERE idaccount = " + idaccount + ") AND DATE_FORMAT(invoice_cdr.start_stamp, '%Y-%m') = '" + cmon + "' GROUP BY directions.direction, zones.zone ORDER BY directions.direction, CASE WHEN zones.zone = 'toll_free' THEN 2 ELSE 1 END, zones.zone";
            obj02.prepare();
            obj02.execute((error, ibcall) => {
                if (error == 1 && ibcall.length > 0) {
                    let qry = 'INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUE ';
                    ibcall.forEach((element) => {
                        let key = '', cat = '1', subcat = '0', tzone = '', drsn = element?.duration ?? 0, cost = element?.callcost ?? 0;
                        switch (element.direction) {
                            case 'inbound':
                                subcat = '1';
                                switch (element.zone) {
                                    case 'Zone 1':
                                    case '1':
                                        key = 'call_ib_t1';
                                        tzone = 'USA Tier 1';
                                        break;
                                    case 'Zone 2':
                                    case '2':
                                        key = 'call_ib_t2';
                                        tzone = 'USA Tier 2';
                                        break;
                                    case 'Zone 3':
                                    case '3':
                                        key = 'call_ib_t3';
                                        tzone = 'USA Tier 3';
                                        break;
                                    case 'Zone 4':
                                    case '4':
                                        key = 'call_ib_t4';
                                        tzone = 'USA Tier 4';
                                        break;
                                    case 'Zone 5':
                                    case '5':
                                        key = 'call_ib_t5';
                                        tzone = 'USA Tier 5';
                                        break;
                                    case 'toll_free':
                                    case 800:
                                        key = 'call_ib_tf';
                                        tzone = 'Toll Free';
                                        break;
                                }
                                // To use of tax calculation
                                taxlData.push({ [key]: { key: key, qty: drsn, total: cost } });
                                break;
                            case 'outbound':
                                subcat = '2';
                                switch (element.zone) {
                                    case 'Zone 1':
                                    case '1':
                                        key = 'call_ob_t1';
                                        tzone = 'USA Tier 1';
                                        break;
                                    case 'Zone 2':
                                    case '2':
                                        key = 'call_ob_t2';
                                        tzone = 'USA Tier 2';
                                        break;
                                    case 'Zone 3':
                                    case '3':
                                        key = 'call_ob_t3';
                                        tzone = 'USA Tier 3';
                                        break;
                                    case 'Zone 4':
                                    case '4':
                                        key = 'call_ob_t4';
                                        tzone = 'USA Tier 4';
                                        break;
                                    case 'Zone 5':
                                    case '5':
                                        key = 'call_ob_t5';
                                        tzone = 'USA Tier 5';
                                        break;
                                    case 'toll_free':
                                    case 800:
                                        key = 'call_ob_tf';
                                        tzone = 'Toll Free';
                                        break;
                                }
                                // To use of tax calculation
                                taxlData.push({ [key]: { key: key, qty: drsn, total: cost } });
                                break;
                        }
                        console.log("callInAndOutData Total Amt : " + totalamt + " + cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ " + key, drsn, cost + ']');
                        //  To Full Sum
                        totalamt += cost;
                        qry += `('${last_invoice}', '${key}', '${drsn}', '${cost}', '${cat}', '${subcat}', '${tzone}'),`;
                        toInvoiceData.push({ idinvoice: last_invoice, key: key, value: drsn, cost: cost, category: cat, subcategory: subcat, label: tzone });
                    });
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = qry.slice(0, -1);
                    obj0.prepare();
                    obj0.execute((__error, data) => {
                        console.log("CDR Information  Inserted Successfully");
                    });
                    // Respond  
                    resolve(parseFloat(totalamt));
                }
                else {
                    console.log("Something went wrong invoice_cdr");
                    resolve(totalamt);
                }
            });
        });
    }
    smsInAndOutData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj007 = new RawQuery_1.ModelRawQuery(req, res);
            obj007.qrysql = `SELECT directions.direction, IFNULL(SUM(mdr.msg_count), 0) AS msg, IFNULL(SUM(mdr.rates), 0) AS rate, IFNULL(SUM(mdr.surcharge), 0) AS sur FROM (SELECT 'inbound' AS direction UNION ALL SELECT 'outbound') AS directions LEFT JOIN invoice_mdr mdr ON mdr.direction = directions.direction AND mdr.iduser IN (SELECT iduser FROM user WHERE idaccount = ${idaccount}) AND DATE_FORMAT(mdr.created_at, '%Y-%m') = '${cmon}' GROUP BY directions.direction;`;
            obj007.prepare();
            obj007.execute((error, ibsms) => {
                if (error == 1 && ibsms.length > 0) {
                    let qry = 'INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ';
                    ibsms.forEach((elm) => {
                        let cost = elm?.rate ?? 0, sur = elm?.sur ?? 0, msg = elm?.msg ?? 0, label = '', ccost = 0, smsIbtc;
                        switch (elm.direction) {
                            case 'inbound':
                                // Inbound charges
                                qry += `('${last_invoice}', 'mdrs_ib_tc', '${msg}', '${cost}', '2', '1', 'Transit Charge'),`;
                                toInvoiceData.push({ idinvoice: last_invoice, key: 'mdrs_ib_tc', value: msg, cost: cost, category: 2, subcategory: 1, label: 'Transit Charge' });
                                smsIbtc = { key: 'mdrs_ib_tc', qty: msg, total: ccost };
                                taxlData.push({ mdrs_ib_tc: smsIbtc });
                                qry += `('${last_invoice}', 'mdrs_ib_sc', '${msg}', '${sur}', '2', '1', 'Surcharge'),`;
                                toInvoiceData.push({ idinvoice: last_invoice, key: 'mdrs_ib_sc', value: msg, cost: sur, category: 2, subcategory: 1, label: 'Surcharge' });
                                taxlData.push({ mdrs_ib_sc: { key: 'mdrs_ib_sc', qty: msg, total: sur } });
                                console.log("smsInAndOutData Total Amt : " + totalamt + " sur : " + sur + " cost : " + cost + " = " + (totalamt + cost + sur) + " Key Data : [ mdrs_ib_tc/mdrs_ib_sc", msg, cost + ']');
                                totalamt += cost + sur;
                                break;
                            case 'outbound':
                                // Outbound charges
                                qry += `('${last_invoice}', 'mdrs_ob_tc', '${msg}', '${cost}', '2', '2', 'Transit Charge'),`;
                                toInvoiceData.push({ idinvoice: last_invoice, key: 'mdrs_ob_tc', value: msg, cost: cost, category: 2, subcategory: 2, label: 'Transit Charge' });
                                taxlData.push({ mdrs_ob_tc: { key: 'mdrs_ob_tc', qty: msg, total: cost } });
                                qry += `('${last_invoice}', 'mdrs_ob_sc', '${msg}', '${sur}', '2', '2', 'Surcharge'),`;
                                toInvoiceData.push({ idinvoice: last_invoice, key: 'mdrs_ob_sc', value: msg, cost: sur, category: 2, subcategory: 2, label: 'Surcharge' });
                                taxlData.push({ mdrs_ob_sc: { key: 'mdrs_ob_sc', qty: msg, total: sur } });
                                console.log("smsInAndOutData Total Amt : " + totalamt + " sur : " + sur + " cost : " + cost + " = " + (totalamt + cost + sur) + " Key Data : [ mdrs_ob_tc/mdrs_ob_sc", msg, cost + ']');
                                totalamt += cost + sur;
                                break;
                        }
                    });
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = qry.slice(0, -1);
                    obj0.prepare();
                    obj0.execute((__error, data) => {
                        console.log("Surcharge/Transit Charge Inserted Successfully");
                    });
                    // Respond
                    resolve(parseFloat(totalamt));
                }
                else {
                    console.log("Something went wrong with in mdr");
                    resolve(totalamt);
                }
            });
        });
    }
    DIDData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj009 = new RawQuery_1.ModelRawQuery(req, res);
            obj009.qrysql = `SELECT categories.category, categories.type, categories.did_sub_type_group AS did_sub_type, COALESCE(COUNT(did_buy.iduser), 0) AS dids, COALESCE(SUM(did_buy.pro_rates), 0) AS cost FROM  (SELECT 'toll_free_number' AS category, 'TF' AS TYPE, 0 AS did_sub_type_group UNION ALL SELECT 'vanity_number', 'TF', 1 UNION ALL SELECT 'local_number', 'NN', 0 UNION ALL SELECT 'imported_ott_mash', 'NN', 1 UNION ALL SELECT 'short_code_lease', 'SC', 0 UNION ALL SELECT 'vanity_short_code', 'SC', 1 UNION ALL SELECT 'migrated_short_code', 'SC', 2) AS categories LEFT JOIN did_buy ON categories.type = did_buy.type AND ((categories.did_sub_type_group = did_buy.did_sub_type) OR (categories.did_sub_type_group = 2 AND did_buy.did_sub_type IN (2, 3))) AND did_buy.account_id = ${idaccount} AND DATE_FORMAT(did_buy.created_at, '%Y-%m') = '${cmon}' AND did_buy.disconnect_did_status = 1 GROUP BY categories.category, categories.type, categories.did_sub_type_group ORDER BY CASE WHEN categories.category = 'local_number' THEN 1 WHEN categories.category = 'imported_ott_mash' THEN 2 WHEN categories.category = 'toll_free_number' THEN 3 WHEN categories.category = 'vanity_number' THEN 4 WHEN categories.category = 'short_code_lease' THEN 5 WHEN categories.category = 'vanity_short_code' THEN 6 WHEN categories.category = 'migrated_short_code' THEN 7 ELSE 8 END;`;
            obj009.prepare();
            obj009.execute((error, ibdid) => {
                if (error == 1) {
                    let qry = 'INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ';
                    ibdid.forEach((elm) => {
                        let dids = elm?.dids ?? 0, cost = elm?.cost ?? 0, key = '', subcat = 0, label = '';
                        switch (elm.category) {
                            case 'toll_free_number':
                                key = 'did_tf';
                                subcat = 1;
                                label = '**US/CAN Tollfree Number - Tier 1';
                                break;
                            case 'vanity_number':
                                key = 'did_tf_vn';
                                subcat = 4;
                                label = 'US/CAN Tollfree Number - Vanity';
                                break;
                            case 'local_number':
                                key = 'did_nn';
                                subcat = 0;
                                label = '**US/CAN Local Number - Tier 1';
                                break;
                            case 'imported_ott_mash':
                                key = 'imported_ott_mash';
                                subcat = 8;
                                label = 'Imported OTT Mash';
                                break;
                            case 'short_code_lease':
                                key = 'short_code_rn';
                                subcat = 5;
                                label = 'Short Code Lease  - Random';
                                break;
                            case 'vanity_short_code':
                                key = 'short_code_vn';
                                subcat = 6;
                                label = 'Short Code Lease  - Vanity';
                                break;
                            case 'migrated_short_code':
                                key = 'short_code_mg';
                                subcat = 7;
                                label = 'Short Code Lease  - Migrated';
                                break;
                        }
                        console.log("DIDData Total Amt : " + totalamt + " + cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ " + key, dids, cost + ']');
                        totalamt += cost;
                        taxlData.push({ [key]: { key: key, qty: dids, total: cost } });
                        qry += `('${last_invoice}', '${key}', '${dids}', '${cost}', '3', '${subcat}', '${label}'),`;
                        toInvoiceData.push({ idinvoice: last_invoice, key: key, value: dids, cost: cost, category: 3, subcategory: subcat, label: label });
                    });
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = qry.slice(0, -1);
                    obj0.prepare();
                    obj0.execute((__error, data) => {
                        console.log("DIDData Inserted Successfully");
                    });
                    resolve(parseFloat(totalamt));
                }
                else {
                    console.log("Something went wrong with DID data");
                    resolve(totalamt);
                }
            });
        });
    }
    getSubscriptionAnnData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
            obj0004.qrysql = "SELECT a.`idaccount`, COUNT(*) AS `quantity`, SUM(a.`cost`) AS cost, b.`description` FROM `subscription_log` a INNER JOIN `subscription` b ON a.`subscription_id`=b.`subscription_id` WHERE a.`idaccount`='" + idaccount + "' AND DATE_FORMAT(a.`created_at`, '%Y-%m')='" + cmon + "' GROUP BY b.`description`";
            obj0004.prepare();
            obj0004.execute((error, subsRes) => {
                let ct = 0;
                let subcost = 0;
                let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                if (subsRes.length > 0) {
                    let qry = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES";
                    subsRes.forEach((ele) => {
                        ct++;
                        let skey = 'ann_sub_' + ct;
                        let subcat = ct - 1;
                        console.log("getSubscriptionData Total Amt : " + totalamt + " + mrccost : " + subcost + " Key Data : [ skey", ele.quantity, ele.cost + ']');
                        totalamt += ele.cost ?? 0;
                        taxlData.push({ [skey]: { key: skey, qty: ele.quantity, total: ele.cost } });
                        qry += "('" + last_invoice + "' ,'" + skey + "','" + (0, markError_1.setToZero)(ele.quantity) + "','" + (0, markError_1.setToZero)(ele.cost) + "','10','" + subcat + "','" + (0, markError_1.parseBody)(ele.description) + "'),";
                        toInvoiceData.push({ idinvoice: last_invoice, key: skey, value: ele.quantity, cost: (0, markError_1.setToZero)(ele.cost), category: 10, subcategory: subcat, label: (0, markError_1.parseBody)(ele.description) });
                    });
                    objb.nonqrysql = qry.slice(0, -1);
                    objb.prepare();
                    objb.execute((_error, result) => { });
                    resolve(totalamt);
                }
                else {
                    resolve(totalamt);
                }
            });
        });
    }
    brandData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            const date = new Date();
            let obj0001 = new RawQuery_1.ModelRawQuery(req, res);
            obj0001.qrysql = "SELECT COUNT(*)`brands`, SUM(`cost`)`bcost` FROM `brand_log` WHERE `event_type` IN (1,7) AND idaccount='" + idaccount + "' AND DATE_FORMAT(`current_date`,'%Y-%m')='" + cmon + "'";
            obj0001.prepare();
            obj0001.execute((error, ibbrand) => {
                let ibbrands = ibbrand[0]?.brands ?? 0, bcost = ibbrand[0]?.bcost ?? 0;
                let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                objb.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'brand','"
                    + ibbrands + "','" + bcost + "','4','0','Brand Registration')";
                objb.prepare();
                objb.execute((error, data) => {
                });
                console.log("brandData Total Amt : " + totalamt + " + cost : " + bcost + " = " + (totalamt + bcost) + " Key Data : [ brand ", ibbrands, bcost + ']');
                totalamt += bcost;
                taxlData.push({ brand: { key: 'brand', qty: ibbrands, total: bcost } });
                toInvoiceData.push({ idinvoice: last_invoice, key: 'brand', value: ibbrands, cost: bcost, category: 4, subcategory: 0, label: 'Brand Registration' });
                resolve(parseFloat(totalamt));
            });
        });
    }
    campaignData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            const date = new Date();
            let obj0001 = new RawQuery_1.ModelRawQuery(req, res);
            obj0001.qrysql = "SELECT COUNT(*)`campaigns`,SUM(cl.`cost`)`ccost` FROM `campaign_log` cl JOIN campaign c ON c.`campaign_key`=cl.`campaign_key` WHERE cl.idaccount='" + idaccount + "' AND DATE_FORMAT(cl.`date`,'%Y-%m')='" + cmon + "' AND c.`deleted`=0 AND c.`status` = 0 AND cl.event_type=1";
            obj0001.prepare();
            obj0001.execute((error, ibbrand) => {
                let ibcampaigns = ibbrand[0]?.campaigns ?? 0;
                let cost = ibbrand[0]?.ccost ?? 0;
                let qry = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ";
                // To campaign data
                qry += "('" + last_invoice + "' ,'campaign','" + ibcampaigns + "','" + (0, markError_1.setToZero)(cost) + "','4','0', 'Campaign Registration'),";
                taxlData.push({ campaign: { key: 'campaign', qty: ibcampaigns, total: cost } });
                toInvoiceData.push({ idinvoice: last_invoice, key: 'campaign', value: ibcampaigns, cost: cost, category: 4, subcategory: 0, label: 'Campaign Registration' });
                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj0.nonqrysql = qry.slice(0, -1);
                obj0.prepare();
                obj0.execute((error, data) => {
                    console.log("Campaign/Campaign MRC Inserted Successfully");
                });
                totalamt += cost;
                console.log("campaignData Total Amt : " + totalamt + " + cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ campaign ", ibcampaigns, cost + ']');
                resolve(parseFloat(totalamt));
            });
        });
    }
    //Fetching brand vetting data
    brandVetting(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
            obj0004.qrysql = "SELECT COUNT(*)`brands`, SUM(`priceDeducted`)`bcost` FROM `brand_vetting` WHERE idaccount='" + idaccount + "' AND DATE_FORMAT(`createdDate`,'%Y-%m')='" + cmon + "'";
            obj0004.prepare();
            obj0004.execute((error, brandVett) => {
                let ibrandv = brandVett[0]?.brands ?? 0;
                let cost = brandVett[0]?.bcost ?? 0;
                let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                objb.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'brand_vetting','" + ibrandv + "','" + cost + "','4','1','Brand Vetting')";
                objb.prepare();
                objb.execute((error, data) => {
                });
                totalamt += cost;
                taxlData.push({ brand_vetting: { key: 'brand_vetting', qty: ibrandv, total: cost } });
                toInvoiceData.push({ idinvoice: last_invoice, key: 'brand_vetting', value: ibrandv, cost: cost, category: 4, subcategory: 1, label: 'Brand Vetting' });
                console.log("brandVetting Total Amt : " + totalamt + " + cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ brand_vetting ", ibrandv, cost + ']');
                resolve(totalamt);
            });
        });
    }
    // Fetching Brand Appeal data
    brandAppeal(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            const date = new Date();
            let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
            obj0004.qrysql = "SELECT SUM(IF(brandId IS NOT NULL, 1, 0)) `brands`, SUM(IF(brandId IS NOT NULL, cost, 0)) `cost` FROM brand_appeal_log  WHERE idaccount='" + idaccount + "' AND DATE_FORMAT(`created_at`,'%Y-%m')='" + cmon + "' AND event_type=1";
            obj0004.prepare();
            obj0004.execute((error, brandAppeal) => {
                let iBrandA = brandAppeal[0].brands ?? 0;
                let cost = brandAppeal[0].cost ?? 0;
                let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                objb.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'brand_appeal','"
                    + iBrandA + "','" + cost + "','4','0','Brand Appeal')";
                objb.prepare();
                objb.execute((error, data) => {
                });
                taxlData.push({ brand_appeal: { key: 'brand_appeal', qty: iBrandA, total: cost } });
                toInvoiceData.push({ idinvoice: last_invoice, key: 'brand_appeal', value: iBrandA, cost: cost, category: 4, subcategory: 0, label: 'Brand Appeal' });
                totalamt += cost;
                console.log("brandAppeal Total Amt : " + totalamt + " + cost : " + cost + " = " + (totalamt + cost) + " Key Data : [ brand_appeal ", iBrandA, cost + ']');
                resolve(totalamt);
            });
        });
    }
    // Fetching wallet data
    getwalletData(req, res, last_invoice, deductTotalAmt, sdata, next) {
        return new Promise((resolve, reject) => {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                let idaccount = sdata.sesidaccount ?? sessdata.idaccount;
                const date = new Date();
                let bmon = null;
                bmon = `${date.getFullYear()}-${date.getMonth() + 1}`;
                let obj0004 = new RawQuery_1.ModelRawQuery(req, res);
                obj0004.qrysql = "SELECT balance FROM wallet WHERE idaccount='" + idaccount + "'";
                obj0004.prepare();
                obj0004.execute((___error, walletRes) => {
                    let outstanding_amount = 0;
                    let minimum_amount = 0;
                    if (walletRes[0].balance >= deductTotalAmt) {
                        outstanding_amount = walletRes[0].balance - deductTotalAmt;
                        // let obj = new ModelRawNonQuery(req, res);
                        // obj.nonqrysql = "UPDATE wallet SET `balance`=" + outstanding_amount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                        // obj.prepare();
                        // obj.execute((_error: any, wallet: any) => {
                        //     if (_error == 1) {
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'getwalletData',
                                logName: 'Wallet Update'
                            },
                            data: {
                                balance: outstanding_amount
                            },
                            connWhere: {
                                idaccount: sessdata.idaccount
                            }
                        };
                        walletlog.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            if (log_error1 == 1) {
                                // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                // iQry += "`idaccount`=" + idaccount + ", "
                                // iQry += "`amount`='+" + walletRes[0].balance + "', "
                                // iQry += "`purpose`='Wallet amount successfully updated for invoice closing', "
                                // iQry += "`status`=1;"
                                // let objWL = new ModelRawNonQuery(req, res);
                                // objWL.nonqrysql = iQry
                                // objWL.prepare()
                                // objWL.execute((error: any, result: any) => {
                                //     console.log("Transaction response::", result)
                                // })
                                let logPayload1 = {
                                    funDetail: {
                                        tableName: 'wallet_recharge_log',
                                        functionName: 'getwalletData',
                                        logName: 'wallet'
                                    },
                                    data: {
                                        idaccount: idaccount,
                                        amount: '+' + walletRes[0].balance,
                                        purpose: 'Wallet amount successfully updated for invoice closing',
                                        status: 1,
                                    }
                                };
                                walletlog.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                    console.log("Transaction response::", did_log);
                                });
                            }
                            else {
                                // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                // iQry += "`idaccount`=" + idaccount + ", "
                                // iQry += "`amount`='+" + walletRes[0].balance + "', "
                                // iQry += "`purpose`='Wallet amount successfully not updated for invoice closing', "
                                // iQry += "`status`=2;"
                                // let objWL = new ModelRawNonQuery(req, res);
                                // objWL.nonqrysql = iQry
                                // objWL.prepare()
                                // objWL.execute((error: any, result: any) => {
                                //     console.log("Transaction response::", result)
                                // })
                                let logPayload1 = {
                                    funDetail: {
                                        tableName: 'wallet_recharge_log',
                                        functionName: 'getwalletData',
                                        logName: 'wallet'
                                    },
                                    data: {
                                        idaccount: idaccount,
                                        amount: '+' + walletRes[0].balance,
                                        purpose: 'Wallet amount successfully not updated for invoice closing',
                                        status: 2,
                                    }
                                };
                                walletlog.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                    console.log("Transaction response::", did_log);
                                });
                            }
                            console.log("customer account updated");
                        });
                        resolve({ remainingWellet: outstanding_amount, previousDue: 0 });
                    }
                    else {
                        let obj04 = new RawQuery_1.ModelRawQuery(req, res);
                        obj04.qrysql = "SELECT ai.`san`,ai.`first_name`,ai.`last_name`,ai.`email`,ai.`address1`,ai.`address2`,ai.`city`,ai.`state`,ai.`postal_code`,ai.`country`,ai.`phone` AS contact, sc.customer_id FROM `invoice` ai JOIN `stripe_card` sc ON sc.`idaccount`= ai.`idaccount` WHERE ai.`idaccount`='" + idaccount + "' AND ai.`invoice_type`=1 AND sc.default = true ORDER BY idinvoice DESC LIMIT 1";
                        obj04.prepare();
                        obj04.execute((___error, invoiceRes) => {
                            if (invoiceRes.length > 0) {
                                let payLoad;
                                minimum_amount = deductTotalAmt - walletRes[0].balance;
                                payLoad = Object.assign(invoiceRes[0], { amount: minimum_amount.toFixed(2) }, { generateInvoice: true });
                                if (payLoad.amount >= .50) {
                                    let stp = new stripeApi_1.StripeApi();
                                    stp.balanceDeduct(req, res, sessdata, payLoad, sdata, (error, resp) => {
                                        console.log("customer wallet deduction called");
                                    });
                                }
                                else {
                                    console.log("customer wallet was lower then .50 :: ", payLoad.amount);
                                }
                                // let obj = new ModelRawNonQuery(req, res);
                                // obj.nonqrysql = "UPDATE wallet SET `balance`=0 WHERE `idaccount` = '" + idaccount + "'";
                                // obj.prepare();
                                // obj.execute((_error: any, wallet: any) => {
                                //     console.log("customer account updated", wallet);
                                // });
                                let logPayload = {
                                    funDetail: {
                                        tableName: 'wallet',
                                        functionName: 'getwalletData',
                                        logName: 'Wallet Update'
                                    },
                                    data: {
                                        balance: 0
                                    },
                                    connWhere: {
                                        idaccount: idaccount
                                    }
                                };
                                walletlog.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                    console.log("customer account updated", did_log1);
                                });
                                (walletRes[0].balance < 0) ? resolve({ remainingWellet: 0, previousDue: walletRes[0].balance * -1 }) : resolve({ remainingWellet: 0, previousDue: 0 });
                            }
                            else {
                                resolve({ remainingWellet: 0, previousDue: 0 });
                            }
                        });
                    }
                });
            });
        });
    }
    dateDiffInDays(dateFrom, dateTo) {
        const oneDay = 24 * 60 * 60 * 1000;
        const utcDateFrom = Date.UTC(dateFrom.getFullYear(), dateFrom.getMonth(), dateFrom.getDate());
        const utcDateTo = Date.UTC(dateTo.getFullYear(), dateTo.getMonth(), dateTo.getDate());
        const diffDays = Math.floor((utcDateTo - utcDateFrom) / oneDay);
        return diffDays;
    }
    getExtraDidMrc(req, res, idaccount, cmon, last_invoice, taxlData, toInvoiceData, next) {
        return new Promise((resolve, reject) => {
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT categories.category, categories.type, categories.did_sub_type_group AS did_sub_type, COALESCE(COUNT(did_buy.iduser), 0) AS dids, COALESCE(SUM(did_buy.pro_rates), 0) AS cost, COALESCE(SUM(CASE WHEN DATE_FORMAT(did_buy.subscription_end_date, '%Y-%m') = DATE_FORMAT(NOW(), '%Y-%m') THEN 0 ELSE TIMESTAMPDIFF(MONTH, DATE_FORMAT(NOW(), '%Y-%m-01'), DATE_FORMAT(did_buy.subscription_end_date, '%Y-%m-01')) * did_buy.nrc_rates END), 0) AS extraMrc FROM (SELECT 'toll_free_number' AS category, 'TF' AS TYPE, 0 AS did_sub_type_group UNION ALL SELECT 'vanity_number', 'TF', 1 UNION ALL SELECT 'local_number', 'NN', 0 UNION ALL SELECT 'imported_ott_mash', 'NN', 1 UNION ALL SELECT 'short_code_lease', 'SC', 0 UNION ALL SELECT 'vanity_short_code', 'SC', 1 UNION ALL SELECT 'migrated_short_code', 'SC', 2) AS categories LEFT JOIN did_buy ON categories.type = did_buy.type AND ((categories.did_sub_type_group = did_buy.did_sub_type) OR (categories.did_sub_type_group = 2 AND did_buy.did_sub_type IN (2, 3))) AND did_buy.account_id = " + idaccount + " AND did_buy.disconnect_did_status = 1 AND DATE_FORMAT(did_buy.subscription_end_date, '%Y-%m-%d') > DATE_FORMAT(NOW(), '%Y-%m-%d') GROUP BY categories.category, categories.type, categories.did_sub_type_group ORDER BY CASE WHEN categories.category = 'local_number' THEN 1 WHEN categories.category = 'imported_ott_mash' THEN 2 WHEN categories.category = 'toll_free_number' THEN 3 WHEN categories.category = 'vanity_number' THEN 4 WHEN categories.category = 'short_code_lease' THEN 5 WHEN categories.category = 'vanity_short_code' THEN 6 WHEN categories.category = 'migrated_short_code' THEN 7 END;";
            obj.prepare();
            obj.execute((error, extDidRes) => {
                let totalExtraDIDMrc = 0, didcount = 0;
                let qry = 'INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ';
                extDidRes.forEach((elm) => {
                    let extraMrc = elm?.extraMrc ?? 0, dids = elm?.dids ?? 0, key = '', subcat = 0, label = '';
                    switch (elm.category) {
                        case 'toll_free_number':
                            key = 'pre_dids_tf';
                            subcat = 1;
                            label = 'US/CAN Tollfree Number - Tier 1';
                            break;
                        case 'vanity_number':
                            key = 'pre_did_tf_vn';
                            subcat = 4;
                            label = 'US/CAN Tollfree Number - Vanity';
                            break;
                        case 'local_number':
                            key = 'pre_dids_nn';
                            subcat = 0;
                            label = 'US/CAN Local Number - Tier 1';
                            break;
                        case 'imported_ott_mash':
                            key = 'pre_imported_ott_mash';
                            subcat = 8;
                            label = 'Imported OTT Mash';
                            break;
                        case 'short_code_lease':
                            key = 'pre_short_code_rn';
                            subcat = 5;
                            label = 'Short Code Lease  - Random';
                            break;
                        case 'vanity_short_code':
                            key = 'pre_short_code_vn';
                            subcat = 6;
                            label = 'Short Code Lease  - Vanity';
                            break;
                        case 'migrated_short_code':
                            key = 'pre_short_code_mg';
                            subcat = 7;
                            label = 'Short Code Lease  - Migrated';
                            break;
                    }
                    console.log("getExtraDidMrc extraMrc : " + extraMrc + " Key Data : [ " + key, dids, extraMrc + ']');
                    totalExtraDIDMrc += extraMrc;
                    didcount += dids;
                    taxlData.push({ [key]: { key: key, qty: dids, total: extraMrc } });
                    qry += `('${last_invoice}', '${key}', '${dids}', '${extraMrc}', '5', '${subcat}', '${label}'),`;
                    toInvoiceData.push({ idinvoice: last_invoice, key: key, value: dids, cost: extraMrc, category: 5, subcategory: subcat, label: label });
                });
                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj0.nonqrysql = qry.slice(0, -1);
                obj0.prepare();
                obj0.execute((__error, data) => {
                    console.log("getExtraDidMrc Inserted Successfully");
                });
                resolve({ did_qty: didcount, cost: totalExtraDIDMrc });
                /* let didcount = extDidRes[0]?.didcount ?? 0, extraMrc = extDidRes[0]?.extraMrc ?? 0;

                console.log("Count: " + didcount + " + extraMrc : " + extraMrc)

                let obj0 = new ModelRawNonQuery(req, res);
                obj0.nonqrysql = "INSERT INTO `invoice_monthly` (`idinvoice`, `key`, `value`, `cost`, `category`, `subcategory`, `label`) VALUES ('" + last_invoice + "' ,'extra_did','" + didcount + "','" + extraMrc + "','5','0','EXTRA DIDs')";
                obj0.prepare();
                obj0.execute((error: any, data: any) => {
                });
                taxlData.push({extra_did : {key: 'extra_did', qty:didcount, total:extraMrc}})

                toInvoiceData.push({idinvoice:last_invoice, key:'extra_did', value:didcount, cost:extraMrc, category:5, subcategory:0, label:'EXTRA DIDs'})
                resolve({ did_qty: didcount, cost: extraMrc });
                */
            });
        });
    }
    geTotalTax(req, res, cmon, idinvoice, idaccount, taxlData, billingAddress, next) {
        console.log("billingAddress ::: ", billingAddress);
        return new Promise((resolve, reject) => {
            let idinvoiceObj = new AccountDelete();
            const date = new Date();
            let cday = date.getDate();
            let mday = date.getMonth() + 1;
            let yday = date.getFullYear();
            let crnt_date = mday + '/' + cday + '/' + yday;
            let localToken, invoNumber = billingAddress.invoice_number;
            var options = {
                'method': 'POST',
                'url': urlLogin,
                'headers': {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    "apiusername": apiusername,
                    "apipassword": apipassword
                })
            };
            request(options, function (err, response) {
                if (!err) {
                    try {
                        if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                            let data1 = JSON.parse(response.body);
                            localToken = data1.result.token;
                            /* let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT ai.idaccount, ai.invoice_number, ai.city, ai.state, ai.postal_code, ai.country, ai.email, ai.idinvoice, ai.created_at, ai.address1 FROM `invoice` AS ai JOIN `invoice_monthly` AS ci ON ai.idinvoice = ci.idinvoice WHERE ai.`invoice_type`=1 AND ai.`created_at` LIKE '%" + cmon + "%' GROUP BY ai.idaccount";
                            obj.prepare();
                            obj.execute((_error: any, invoceRes: any) => {
                                if (_error == 1) {
                                    if (invoceRes.length > 0) { */
                            let city = billingAddress.city, postal_code = billingAddress.postal_code, state = billingAddress.state, addr = billingAddress.address1, email = billingAddress.email;
                            /** To Check GeoCode*/
                            var options = {
                                'method': 'POST',
                                'url': urlGeoCode,
                                'headers': {
                                    'Content-Type': 'application/json',
                                    'Cookie': 'AuthToken=' + localToken
                                },
                                body: JSON.stringify({
                                    "ref": "Address Request",
                                    "cass": true,
                                    "addr": addr,
                                    "city": city,
                                    "st": state,
                                    "zip": postal_code
                                })
                            };
                            console.log("pCode option :: ", options);
                            request(options, async function (__error, response) {
                                let dataGeo = JSON.parse(response.body);
                                console.log("dataGeo :: ", dataGeo);
                                let pCode = dataGeo.result[0].pcd;
                                if (pCode) {
                                    let items = [];
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['pre_dids_nn', 'pre_imported_ott_mash'], 'mrc_nn', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['pre_dids_tf', 'pre_did_tf_vn'], 'mrc_tf', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['red_campaign'], 'camp_mrc', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['mdrs_ib_tc'], 'sms_ibtc', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['mdrs_ib_sc'], 'sms_ibsr', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['mdrs_ob_tc'], 'sms_obtc', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['mdrs_ob_sc'], 'sms_obsr', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['ncaNn'], 'nca_nn', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['nca_tf'], 'nca_tf', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['brand'], 'a2ppac_nrcbrnd', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['campaign'], 'a2ppac_nrcmp', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['call_ob_tf'], 'obcall_tollfree', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['call_ib_tf'], 'ibcall_tollfree', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['call_ib_t1', 'call_ib_t2', 'call_ib_t3', 'call_ib_t4', 'call_ib_t5'], 'ibcall_usatier', items);
                                    await idinvoiceObj.calculateSum(req, res, taxlData, ['call_ob_t1', 'call_ob_t2', 'call_ob_t3', 'call_ob_t4', 'call_ob_t5'], 'obcall_usatier', items);
                                    console.log("Items List", items);
                                    if (invoNumber) {
                                        let Post_Fields = JSON.stringify({
                                            "token": authKey,
                                            "country": "USA",
                                            "state": state,
                                            "city": city,
                                            "zip": postal_code,
                                            "pcode": pCode,
                                            "document": 'doc_' + invoNumber,
                                            "invoice": 'doc' + invoNumber,
                                            "idinvoice": idinvoice,
                                            "date": crnt_date,
                                            "account_ref": idaccount,
                                            "customer_ref": email,
                                            "company_identy": "Gventure",
                                            "itms": items
                                        });
                                        /** To Tax Calculation*/
                                        var options = {
                                            'method': 'POST',
                                            'url': urlCal_tacx,
                                            'headers': {
                                                'Content-Type': 'application/json',
                                                'Cookie': 'AuthToken=' + localToken
                                            },
                                            body: Post_Fields
                                        };
                                        console.log("Invoice Options :: ", options);
                                        request(options, async function (error, response) {
                                            //To Update Invoice Tax
                                            let ava_data = JSON.parse(response.body);
                                            console.log("ava_data :: ", ava_data);
                                            if (error == null) {
                                                let sales_tax = ava_data.result?.sales_tax ?? '0.00', bussiness_tax = ava_data.result?.bussiness_tax ?? '0.00', grt_tax = ava_data.result?.grt_tax ?? '0.00', excise_tax = ava_data.result.excise_tax ?? '0.00', ucf_tax = ava_data.result.ucf_tax ?? '0.00', fcc_tax = ava_data.result.fcc_tax ?? '0.00', e911_tax = ava_data.result.e911_tax ?? '0.00', utility_user_tax = ava_data.result.utility_user_tax ?? '0.00', rwf_tax = ava_data.result.rwf_tax ?? '0.00', comm_service_tax = ava_data.result.comm_service_tax ?? '0.00', crf_tax = ava_data.result.crf_tax ?? '0.00', reserve_tax = ava_data.result.reserve_tax ?? '0.00', va_tax = ava_data.result.va_tax ?? '0.00', all_tax_sum = ava_data.result.all_tax_sum ?? '0.00';
                                                console.log("sales_tax " + sales_tax + " bussiness_tax " + bussiness_tax + " grt_tax " + grt_tax + " excise_tax " + excise_tax + " ucf_tax " + ucf_tax + " fcc_tax " + fcc_tax + " e911_tax " + e911_tax + " utility_user_tax " + utility_user_tax + " rwf_tax " + rwf_tax + " comm_service_tax " + comm_service_tax + " crf_tax " + crf_tax + " reserve_tax " + reserve_tax + " va_tax " + va_tax + " all_tax_sum " + all_tax_sum);
                                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "UPDATE `invoice_monthly` SET `tax`='" + all_tax_sum + "' WHERE `idinvoice`='" + idinvoice + "'";
                                                obj2.prepare();
                                                obj2.execute((errs, data) => {
                                                    // To Commit Invoice Tax
                                                    if (errs == 1) {
                                                        resolve(all_tax_sum);
                                                    }
                                                    else {
                                                        console.log("Invoice Monthly tax not updated ::" + invoNumber);
                                                    }
                                                });
                                            }
                                            else {
                                                console.log("Invoice tax not updated 123 ::" + invoNumber);
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Invalid Invoice Detail at this account ::" + invoNumber);
                                    }
                                }
                                else {
                                    console.log("No Geo Code Available ::" + invoNumber);
                                }
                            });
                            /* }
                            else {
                                console.log("Record Not Found");
                            }
                        }
                        else {
                            console.log("something went wrong");
                        }
                    }); */
                        }
                        else {
                            console.log("Something Went Wrong");
                        }
                    }
                    catch (e) {
                        console.log("Error :: AccountDelete->geTotalTax::", e);
                    }
                }
                else {
                    console.log("Something Went Wrong With Connection!");
                }
            });
        });
    }
    calculateSum(req, res, taxlData, filterKeys, type, items) {
        const filteredData = taxlData.filter((item) => {
            const key = Object.keys(item)[0];
            return filterKeys.includes(key);
        });
        const result = filteredData.reduce((acc, item) => {
            const values = Object.values(item)[0];
            const qty = values?.qty ?? 0;
            const total = values?.total ?? 0;
            acc.qty += qty;
            acc.total += total;
            return acc;
        }, { qty: 0, total: 0 });
        items.push({ "type": type, "amount": result.total, "quantity": result.qty });
        return result;
    }
    closingInvoice(req, res, sdata, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession(async (error, sessdata) => {
            if (error == 1) {
                let idaccount = sdata.sesidaccount ?? sessdata.idaccount;
                let idinvoiceObj = new AccountDelete();
                if (sessdata.type == 2 || sessdata.type == 1) {
                    const date = new Date();
                    let cday = date.getDate(), mday = date.getMonth() + 1, yday = date.getFullYear();
                    if (mday <= 9)
                        mday = '0' + mday;
                    if (cday <= 9)
                        cday = '0' + cday;
                    let cmon = yday + '-' + mday; /* current month */
                    let pt1 = `${mday}-01-${date.getFullYear()}`, pt2 = `${mday}`, pty2 = `${date.getFullYear()}`;
                    let daysCount = new Date(yday, mday - 1, 0).getDate(), daysCount_pt = new Date(pty2, pt2, 0).getDate();
                    let mrcDate = `${mday}-${cday}-${yday} to ${mday}-${daysCount}-${yday}`, lastDate = `${pt1} to ${pt2}-${daysCount_pt}-${pty2}`;
                    let billingAddress = await idinvoiceObj.getLastInvoiceId(req, res, idaccount, cmon, next);
                    console.log("billingAddress", billingAddress);
                    let last_invoice = billingAddress.last_invoice;
                    if (last_invoice > 0) {
                        var totalamt = 0, taxlData = [];
                        var toInvoiceData = [];
                        /* // Fetching Call data for current monthwise // getTotalCallCostAmt */
                        totalamt = await idinvoiceObj.callInAndOutData(req, res, idaccount, cmon, totalamt, last_invoice, taxlData, toInvoiceData, next); /* // Done 12 */
                        console.log("callInAndOutData total:: ", totalamt);
                        /* // Fetching SMS data for current monthwise */
                        totalamt = await idinvoiceObj.smsInAndOutData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next); /* // 2 */
                        console.log("smsInAndOutData total:: ", totalamt);
                        /* // Fetching Brand & Campaign data for current monthwise */
                        totalamt = await idinvoiceObj.brandData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next);
                        console.log("brandData total:: ", totalamt);
                        /* // Fetching Brand Vetting data */
                        totalamt = await idinvoiceObj.brandVetting(req, res, idaccount, cmon, last_invoice, parseFloat(totalamt), taxlData, toInvoiceData, next);
                        console.log("brandVetting total:: ", totalamt);
                        /* // Fetching Brand Vetting data */
                        totalamt = await idinvoiceObj.brandAppeal(req, res, idaccount, cmon, last_invoice, parseFloat(totalamt), taxlData, toInvoiceData, next);
                        console.log("brandAppeal total:: ", totalamt);
                        totalamt = await idinvoiceObj.campaignData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next);
                        console.log("campaignData total:: ", totalamt);
                        /* // Fetching Campaign Review data */
                        totalamt = await idinvoiceObj.campaignReview(req, res, idaccount, cmon, last_invoice, parseFloat(totalamt), taxlData, toInvoiceData, next);
                        console.log("campaignReview total:: ", totalamt);
                        /* // Fetching MRC Redundant Campaign */
                        totalamt = await idinvoiceObj.campaignRedundant(req, res, idaccount, cmon, last_invoice, parseFloat(totalamt), taxlData, toInvoiceData, next);
                        console.log("campaignRedundant total:: ", totalamt);
                        /* // Lookup API charge log */
                        totalamt = await idinvoiceObj.getlookupApiData(req, res, idaccount, cmon, last_invoice, parseFloat(totalamt), taxlData, toInvoiceData, next);
                        console.log("getlookupApiData total:: ", totalamt);
                        /* // Fetching MRC Local SMS enable data */
                        /* // stop
                        let getPhoneNoSmsEnablement: any = {};
                        getPhoneNoSmsEnablement = await idinvoiceObj.getPhoneNoSmsEnablement(req, res, idaccount, cmon, last_invoice, parseFloat(totalamt), taxlData, toInvoiceData, next)
                        console.log("getPhoneNoSmsEnablement total:: ", totalamt); */
                        /* //Fetching Local Number data for current monthwise */
                        totalamt = await idinvoiceObj.DIDData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next); /* // Done 10 */
                        console.log("DIDData total:: ", totalamt);
                        /* //Fetching get subscription annivarsary data */
                        totalamt = await idinvoiceObj.getSubscriptionAnnData(req, res, idaccount, cmon, last_invoice, totalamt, taxlData, toInvoiceData, next); /* // Done 7 */
                        console.log("getSubscriptionAnnData total:: ", totalamt);
                        /* // Fetching MRC Local Number data */ /* // no need of total */
                        /* let DIDsCurntMnthMRCData: any = {};
                        DIDsCurntMnthMRCData = await idinvoiceObj.DIDMrcCharged(req, res, idaccount, cmon, last_invoice, parseFloat(totalamt), taxlData, toInvoiceData, next)
                        console.log("DIDMrcCharged mrc:: ", DIDsCurntMnthMRCData.mrccost); */
                        /* // Subscription Charges */
                        let getextradidMrcCost = {};
                        getextradidMrcCost = await idinvoiceObj.getExtraDidMrc(req, res, idaccount, cmon, last_invoice, taxlData, toInvoiceData, next);
                        console.log("getextradidMrcCost mrc:: ", getextradidMrcCost.cost);
                        /* // Fetching TAX calculation  data */
                        console.log("taxlData :: ", taxlData);
                        let taxes = 0;
                        taxes = await idinvoiceObj.geTotalTax(req, res, cmon, last_invoice, idaccount, taxlData, billingAddress, next);
                        /* // totalamt = getextradidMrc.cost; */
                        let deductTotalAmt = +taxes + +getextradidMrcCost.cost;
                        /* // Update MRC Cost */
                        let mrccost = 0;
                        if (getextradidMrcCost.cost > 0) {
                            mrccost += getextradidMrcCost.cost;
                        }
                        /* let mrccost: any = 0;
                        if (DIDsCurntMnthMRCData.mrccost > 0) {
                            mrccost = mrccost + DIDsCurntMnthMRCData.mrccost;
                        }
                        // stop
                        if (getPhoneNoSmsEnablement.mrccost > 0) {
                            mrccost = mrccost + getPhoneNoSmsEnablement.mrccost;
                        }
                        if (getSubscriptionData.mrccost > 0) {
                            mrccost = mrccost + getSubscriptionData.mrccost;
                        }*/
                        let obj0005 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0005.nonqrysql = "UPDATE `invoice_monthly` SET `total_amount`='" + parseFloat(totalamt + getextradidMrcCost.cost) + "', `last_date`='" + lastDate + "', `mrc_date`='" + mrcDate + "' WHERE idinvoice='" + last_invoice + "'";
                        obj0005.prepare();
                        obj0005.execute((errro, data) => {
                        });
                        /* // Fetching wallet data */
                        let wallet = await idinvoiceObj.getwalletData(req, res, last_invoice, parseFloat(deductTotalAmt), sdata, next);
                        console.log("walletwallet=>", wallet);
                        let obj0006 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0006.nonqrysql = "UPDATE `invoice` SET `mrc_cost`= '" + parseFloat(mrccost) + "' WHERE idinvoice='" + last_invoice + "'";
                        obj0006.prepare();
                        obj0006.execute((ers, data) => {
                        });
                        // let toDate = `${mday}-01-${yday}`, fromDate = `${mday}-${daysCount}-${yday}`;
                        // idinvoiceObj.geTFinalAccountSummary(req, res, fromDate, toDate, last_invoice, (errorr, resp) => {
                        toInvoiceData.forEach((element) => {
                            element.created_at = date;
                        });
                        console.log("toInvoiceData :: ", toInvoiceData);
                        // return;
                        if (toInvoiceData.length > 0) {
                            /* // To Delete Account */
                            idinvoiceObj.closeCustomerAccount(req, res, last_invoice, sdata, next);
                            let rmessage = '';
                            let rstatus = '';
                            if (sessdata.type == 1) {
                                rmessage = "Account And Other Data Deleted!";
                                rstatus = 201;
                            }
                            else {
                                rmessage = 'Copy of final Invoice send to register mail & Final invoice charges will deducted from your Credit card successfully!';
                                rstatus = 200;
                            }
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: rmessage, data: toInvoiceData, billingAddress: billingAddress, finalCharge: mrccost, totalamt: parseFloat(totalamt), previousDue: wallet.previousDue, remainingWallet: wallet.remainingWellet, taxes: taxes, getextradidMrc: getextradidMrcCost, status: rstatus });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: 'something went wrong.' });
                            objv.execute();
                        }
                        // });
                    }
                    else {
                        console.log("Invoice record did not found for current month");
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Invoice record did not found for current month!", status: 503 });
                        objv.execute();
                    }
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }
    /*     geTFinalAccountSummary(req: Request, res: Response, fromDate: any, toDate: any, last_invoice: any, callback: (err: any, data: any) => void) {
            let obj01 = new ModelRawQuery(req, res);
            obj01.qrysql = "SELECT `idinvoice`, `created_at`, `key`, `value`, `cost`, `category`, `subcategory`, `status`, `label`, `total_amount`, `tax`, `mrc_date`, `last_date` FROM `invoice_monthly` WHERE `idinvoice`='" + last_invoice + "' AND status = '0'";
            obj01.prepare();
            obj01.execute((__error: any, resInv: any) => {
                if (resInv.length > 0) {
                    callback(0, { data: resInv, status: 200 })
                }
                else {
                    callback(0, { message: 'something went wrong.', status: 502 })
                }
            });
        } */
    sendInvoicePdf(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sdata = req.body.data ? JSON.parse(req.body.data) : req.body;
                let objR = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let idaccount = sdata.idaccount ?? sessdata.idaccount;
                let iduser = sdata.iduser ?? sessdata.iduser;
                objR.nonqrysql = "SELECT up.email,u.password FROM user u JOIN invoice ai ON u.idaccount = ai.idaccount JOIN user_profile up ON u.iduser = up.iduser WHERE ai.`invoice_type`=1 AND ai.idinvoice = '" + sdata.invoice + "' LIMIT 1";
                objR.prepare();
                objR.execute((err, resp) => {
                    if (err == 1) {
                        let value = appealEvidence.closeAccountFile + req.file.filename;
                        let path = req.file.path;
                        path = req.file.path.replace(/\\/g, '/');
                        let secret = Str.random(15);
                        let validationKey = jwt.sign({
                            exp: Math.floor(Date.now() / 1000) + (60 * 60),
                            data: resp[0].email + resp[0].password
                        }, secret);
                        let tmpData = '<p>Click the link below:</p> <a href=' + path + '>' + path + '</a>';
                        tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `invoice` SET `invoice_pdf`= '" + req.file.filename + "',`path`= '" + value + "' WHERE idinvoice = '" + sdata.invoice + "'";
                        obj.prepare();
                        obj.execute((__ers, data) => {
                            console.log("invoice update successfully");
                        });
                        if ((sessdata.type == 1 && sdata.checkbox == true) || sessdata.type == 2) {
                            let objem = new RawQuery_1.ModelRawQuery(req, res);
                            objem.qrysql = "SELECT `template`,`subject` FROM `email_template` WHERE `type` = 'close_account'";
                            objem.prepare();
                            objem.execute((____errorem, _resultem) => {
                                if (____errorem == 1 && _resultem.length > 0) {
                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT firstname , lastname, email FROM `user_profile` WHERE iduser = '" + iduser + "'";
                                    obj1.prepare();
                                    obj1.execute((____errorup, _resultup) => {
                                        if (____errorup == 1) {
                                            const formattedTemplate = _resultem[0].template
                                                .replace('{FIRST_NAME}', _resultup[0].firstname)
                                                .replace('{LAST_NAME}', _resultup[0].lastname);
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`html`,`type`,`status`,`file`) VALUES ('" + iduser + "','" + idaccount + "','" + (0, markError_1.parseBody)(FromEmail) + "','" + (0, markError_1.parseBody)(_resultup[0].email) + "', '" + (0, markError_1.parseBody)(_resultem[0].subject) + "','" + (0, markError_1.parseBody)(formattedTemplate) + "','Invoice PDF sent','18','" + value + "')";
                                            obj1.prepare();
                                            obj1.execute((_err, __result) => {
                                                if (_err == 1) {
                                                    console.log("Email Sent Succesfully!");
                                                }
                                                else {
                                                    console.log("Opps Email Not Sent!");
                                                }
                                            });
                                        }
                                        else {
                                            console.log('Account Profile Not Found at the Time Closing Invoice');
                                        }
                                    });
                                }
                                else {
                                    console.log('Live Payment Email Template Not Found at the Time Closing Invoice');
                                }
                            });
                        }
                        else {
                            console.log("Email not send because checkbox is uncehcked");
                        }
                    }
                    else {
                        console.log("Data not found on the invoice");
                    }
                });
            }
            else {
                console.log("Session Error :: ", session);
            }
        });
    }
    closeCustomerAccount(req, res, last_invoice, sdata, next) {
        return new Promise((resolve, reject) => {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let con = "";
                    let idaccount = sdata.sesidaccount ?? sessdata.idaccount;
                    con = "`pending_deleted_date`=NOW()";
                    if (sessdata.type == 2 || sessdata.type == 1) {
                        let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = '" + idaccount + "'";
                        obj7.prepare();
                        obj7.execute((__error, delSessRes) => {
                            console.log("All Session Removed");
                            let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                            obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + idaccount + "'";
                            obj00.prepare();
                            obj00.execute((____error, resultIdEnPoint) => {
                                let endPointId = [];
                                for (let i of resultIdEnPoint) {
                                    endPointId.push(i.idendpoint);
                                }
                                let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj01.prepare();
                                obj01.execute((error, resInbound) => {
                                    console.log("Inbound Removed");
                                });
                                let obj02 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj02.prepare();
                                obj02.execute((error, resOutbound) => {
                                    console.log("Outbound Removed");
                                });
                                let obj03 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj03.prepare();
                                obj03.execute((error, resIp) => {
                                    console.log("IP Address Removed");
                                });
                                let obj04 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj04.prepare();
                                obj04.execute((error, resRoute) => {
                                    console.log("Routing Removed");
                                });
                                let obj05 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                obj05.prepare();
                                obj05.execute((error, resHook) => {
                                    console.log("Hooksetting Removed");
                                });
                            });
                            let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = '" + idaccount + "'";
                            obj8.prepare();
                            obj8.execute((___error, delApiRes) => {
                                console.log("Api Details Removed");
                                let obj9 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = '" + idaccount + "'";
                                obj9.prepare();
                                obj9.execute((____error, result) => {
                                    console.log("All Connection Removed");
                                });
                            });
                        });
                        let obj10 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '1', " + con + " WHERE `idaccount` = '" + idaccount + "'";
                        obj10.prepare();
                        obj10.execute((_error, result) => {
                            if (_error == 1) {
                                resolve({ message: 'Account And Other Data Deleted!', status: 200 });
                            }
                            else {
                                resolve({ message: 'Something Went Wrong With Delete Customer!', status: 502 });
                            }
                        });
                        let obj009 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj009.nonqrysql = "UPDATE `invoice_monthly` SET `status` = '1' WHERE `idinvoice` = '" + last_invoice + "'";
                        obj009.prepare();
                        obj009.execute((error, resInbound) => {
                            console.log("Update closing invoice status");
                        });
                        let obj010 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj010.nonqrysql = "UPDATE `invoice` SET `ai_status` = '1' WHERE `idinvoice` = '" + last_invoice + "'";
                        obj010.prepare();
                        obj010.execute((error, resInbound) => {
                            console.log("Update Account invoice status");
                        });
                        let obj22 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj22.nonqrysql = "UPDATE `subscription_account` SET `status` = '0' WHERE idaccount ='" + idaccount + "'";
                        obj22.prepare();
                        obj22.execute((error, resOutbound) => {
                            console.log("subscription account inactive");
                        });
                    }
                    else {
                        console.log("You have not access to Delete Account!");
                    }
                }
                else {
                    console.log("Session", session);
                }
            });
        });
    }
    ClosingInvoice(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession(async (error, sessdata) => {
            if (error == 1) {
                let sdata = {
                    idaccount: sessdata.idaccount,
                    iduser: sessdata.iduser,
                };
                let fun = new AccountDelete();
                fun.closingInvoice(req, res, sdata, next);
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }
    deleteCusAccount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let objS = new RawQuery_1.ModelRawQuery(req, res);
                req.query = {};
                objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`='" + sessdata.idaccount + "'";
                objS.prepare();
                objS.execute((errKey, delKey) => {
                    if (errKey == 1) {
                        if (delKey.length > 0) {
                            for (let x of delKey) {
                                server_1.sessiondata.delete(x.authKey);
                            }
                        }
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Your Acoount Deleted Successfully!", status: 200 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }
    adminCloseCustomerAccount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let localToken;
                    let invoNumber;
                    if (sdata.checkvalue) {
                        var options = {
                            'method': 'POST',
                            'url': urlLogin,
                            'headers': {
                                'Content-Type': 'application/json',
                            },
                            body: JSON.stringify({
                                "apiusername": apiusername,
                                "apipassword": apipassword
                            })
                        };
                        request(options, function (err, response) {
                            if (response.body) {
                                let data1 = JSON.parse(response.body);
                                localToken = data1.result.token;
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT idaccount, invoice_number, idinvoice FROM `invoice` WHERE `invoice_type`=1 AND idaccount ='" + sdata.sesidaccount + "' AND ai_status ='1' ORDER BY idinvoice DESC LIMIT 1";
                                obj.prepare();
                                obj.execute((_error, invoceRes) => {
                                    if (_error == 1) {
                                        if (invoceRes.length > 0) {
                                            invoNumber = invoceRes[0].invoice_number;
                                            /** To Check tax comit*/
                                            let pstFld;
                                            pstFld = JSON.stringify({
                                                "billingtype": "billed",
                                                "document": "doc_" + invoNumber,
                                                "invoice": "doc_" + invoNumber
                                            });
                                            let options = {
                                                "method": "POST",
                                                "url": urlcommit,
                                                "headers": {
                                                    "content-type": "application/json",
                                                    "Cookie": 'AuthToken=' + localToken
                                                },
                                                body: pstFld
                                            };
                                            request(options, function (___error, response) {
                                                if (___error == null) {
                                                    console.log("Invoice tax calculation updated and committed successfully for ::" + invoNumber);
                                                    let fun = new AccountDelete();
                                                    fun.DeleteAccount(req, res, sdata, next);
                                                }
                                                else {
                                                    console.log("Invoice tax not committed ::" + invoNumber);
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Invoice tax not committed for!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Record Not Found!", status: 501 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went wrong with Record Found!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                console.log("Not Logged In ::" + invoNumber);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Tax not committed!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let fun = new AccountDelete();
                        fun.DeleteAccount(req, res, sdata, next);
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }
    getInvoicePdfForAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idinvoice`,`idaccount`,`path`,`invoice_pdf` FROM `invoice` WHERE `invoice_type`=1";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Invoice Fetched Successfully", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Getting Invoice!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }
    /* DeleteAccount(req: Request, res: Response, sdata: any, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let allDID: any = [];
                let allDIDId: any = [];
                let allBrandId: any = [];
                let allCampaign: any = [];
                let allIdUsers: any = [];
                // Delete DID
                let obj0 = new ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='1'";
                obj0.prepare();
                obj0.execute((_errorDID: any, resultDID: any) => {
                    if (_errorDID == 1) {
                        
                        let obj11 = new ModelRawNonQuery(req, res);
                        let qrystr = "INSERT INTO `did_log` (`account_id`, `did`, `subscription_auto_renew`,`iduser`, `disconnect_did_status`, `event_type`, `description`) VALUE ";
                        for (let d of resultDID) {
                            allDIDId.push(d.iddid);
                            allDID.push(d.did);
                            qrystr += "('" + sessdata.idaccount + "', '" + d.did + "', 'false', '" + sessdata.iduser + "', 2, 31, 'Bulk DID Delete Initiated When Deleting an Account'),";
                        }

                        if (allDIDId.length > 0) {

                            // To create bulk log
                            obj11.nonqrysql = qrystr.slice(0, -1);
                            obj11.prepare();
                            obj11.execute((err, data) => {
                            });

                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '2', `subscription_auto_renew` = 'false' WHERE `iddid` IN(" + allDIDId + ")";
                            obj1.prepare();
                            obj1.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    console.log("All DID Removed", allDIDId);
                                }
                            });
                        }
                    }
                });

                let obju = new ModelRawQuery(req, res);
                obju.qrysql = "SELECT `iduser` from user WHERE `idaccount`=" + sdata.sesidaccount + "";
                obju.prepare();
                obju.execute((_uerror: any, iduserRes: any) => {
                    if (iduserRes.length > 0) {
                        for (let u of iduserRes) {
                            allIdUsers.push(u.iduser)
                        }
                        if (allIdUsers.length > 0) {
                            // Delete Campaign
                            let objc = new ModelRawQuery(req, res);
                            objc.qrysql = "SELECT `id_campaign` FROM campaign WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objc.prepare();
                            objc.execute((_cerror: any, campaignRes: any) => {
                                if (campaignRes.length > 0) {
                                    for (let c of campaignRes) {
                                        allCampaign.push(c.id_campaign)
                                    }
                                    let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                    let obj1 = new ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '2' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                    obj1.prepare();
                                    obj1.execute((_errorCamp: any, resultCamp: any) => {
                                        if (resultCamp.length > 0) {
                                            console.log("All Campaign Removed", allCampaign);
                                        }
                                    });
                                }
                            });
                            // Delete Brand
                            // let objb = new ModelRawQuery(req, res);
                            // objb.qrysql = "SELECT `idbrand` FROM brand WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            // objb.prepare();
                            // objb.execute((_errB: any, brandRe: any) => {
                            //     if (brandRe.length > 0) {
                            //         for (let b of brandRe) {
                            //             allBrandId.push(b.idbrand)
                            //         }
                            //         let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                            //         let obj2 = new ModelRawNonQuery(req, res);
                            //         obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '2' WHERE `idbrand` IN(" + allBrandIDs + ")";
                            //         obj2.prepare();
                            //         obj2.execute((_errorBrand: any, resultBrand: any) => {
                            //             if (resultBrand.length > 0) {
                            //                 console.log("All Brand Removed", allBrandId);
                            //             }
                            //         });
                            //     }
                            // })
                        }
                    }
                })
                // add here delete feature for session,api and connection.
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `session` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '" + sdata.isDeleted + "'";
                obj.prepare();
                obj.execute((__error: any, delSessRes: any) => {
                    console.log("All Session Remove");
                    let obj0 = new ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '" + sdata.isDeleted + "'";
                    obj0.prepare();
                    obj0.execute((___error: any, delApiRes: any) => {
                        console.log("Api Details Remove");
                        // let obj1 = new ModelRawNonQuery(req, res);
                        // obj1.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '" + sdata.isDeleted + "'";
                        // obj1.prepare();
                        // obj1.execute((____error: any, result: any) => {
                        //     console.log("All Connection Remove");
                        // })
                    })
                })

                // closed here
                let obj2 = new ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + sdata.isDeleted + "', `deleted_date`=NOW() WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj2.prepare();
                obj2.execute((_errorDEL: any, resultDEL: any) => {
                    if (_errorDEL == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: [], message: "Account Successfully Deleted!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Release DID From Account Delete Process!", status: 502 });
                        objv.execute();
                    }
                });

                let obj00 = new ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj00.prepare();
                obj00.execute((____error: any, resultIdEnPoint: any) => {
                    let endPointId: any = [];
                    for (let i of resultIdEnPoint) {
                        endPointId.push(i.idendpoint)
                    }
                    let endPointIds = endPointId.length > 0 ? endPointId : "''";
                    let obj01 = new ModelRawNonQuery(req, res);
                    obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj01.prepare();
                    obj01.execute((error: any, resInbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Inbound Restored");
                        }
                        else {
                            console.log("Inbound Removed");
                        }
                    })
                    let obj02 = new ModelRawNonQuery(req, res);
                    obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj02.prepare();
                    obj02.execute((error: any, resOutbound: any) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Outbound Restored");
                        }
                        else {
                            console.log("OutBound Removed");
                        }
                    })

                    let obj03 = new ModelRawNonQuery(req, res);
                    obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj03.prepare();
                    obj03.execute((error: any, resIp: any) => {
                        console.log("IP Address Removed");
                    })
                    let obj04 = new ModelRawNonQuery(req, res);
                    obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj04.prepare();
                    obj04.execute((error: any, resRoute: any) => {
                        console.log("Routing Removed");
                    })
                    let obj05 = new ModelRawNonQuery(req, res);
                    obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj05.prepare();
                    obj05.execute((error: any, resHook: any) => {
                        console.log("Hooksetting Removed");
                    })
                })
                let obj03 = new ModelRawNonQuery(req, res);
                obj03.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj03.prepare();
                obj03.execute((____error: any, result: any) => {

                })
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    } */
    DeleteAccount(req, res, sdata, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let allDID = [];
                let allDIDId = [];
                let allBrandId = [];
                let allCampaign = [];
                let allCampaignkey = [];
                let allIdUsers = [];
                // Delete DID
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `iddid`, `did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='1'";
                obj0.prepare();
                obj0.execute((_errorDID, resultDID) => {
                    if (_errorDID == 1) {
                        let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        let qrystr = "INSERT INTO `did_log` (`account_id`, `did`, `iduser`, `disconnect_did_status`, `event_type`, `description`) VALUE ";
                        for (let d of resultDID) {
                            allDIDId.push(d.iddid);
                            allDID.push(d.did);
                            qrystr += "('" + sessdata.idaccount + "', '" + d.did + "', '" + sessdata.iduser + "', 2, 31, 'Bulk DID Delete Initiated When Deleting an Account'),";
                        }
                        if (allDIDId.length > 0) {
                            // To create bulk log
                            obj11.nonqrysql = qrystr.slice(0, -1);
                            obj11.prepare();
                            obj11.execute((err, data) => {
                            });
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '2', `subscription_auto_renew` = 'false' WHERE `iddid` IN(" + allDIDId + ")";
                            obj1.prepare();
                            obj1.execute((_error, result) => {
                                if (_error == 1) {
                                    let pAyLoad = {
                                        idaccount: sdata.sesidaccount,
                                        did: allDID
                                    };
                                    walletlog.deleteSipBcidtData(req, res, pAyLoad, (erroR, resulT) => {
                                        if (erroR == 1) {
                                            console.log("Deleted Successfully");
                                        }
                                        else {
                                            console.log("Deleted Not Successfully", resulT.message);
                                        }
                                    });
                                    console.log("All DID Removed", allDIDId);
                                }
                            });
                        }
                    }
                });
                let obju = new RawQuery_1.ModelRawQuery(req, res);
                obju.qrysql = "SELECT `iduser` FROM `user` WHERE `idaccount`=" + sdata.sesidaccount + "";
                obju.prepare();
                obju.execute((_uerror, iduserRes) => {
                    if (iduserRes.length > 0) {
                        for (let u of iduserRes) {
                            allIdUsers.push(u.iduser);
                        }
                        if (allIdUsers.length > 0) {
                            // Delete Campaign
                            let objc = new RawQuery_1.ModelRawQuery(req, res);
                            objc.qrysql = "SELECT `id_campaign`,`campaign_key`,`iduser`,`idaccount` FROM campaign WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                            objc.prepare();
                            objc.execute((_cerror, campaignRes) => {
                                if (campaignRes.length > 0) {
                                    for (let c of campaignRes) {
                                        allCampaign.push(c.id_campaign);
                                        allCampaignkey.push({
                                            iduser: c.iduser,
                                            idaccount: c.idaccount,
                                            campaign_key: c.campaign_key
                                        });
                                    }
                                    let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    // obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '2' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                    obj1.nonqrysql = "UPDATE `campaign` SET `delete_date` = NOW() WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                    obj1.prepare();
                                    obj1.execute((_errorCamp, resultCamp) => {
                                        if (resultCamp.affectedRows > 0) {
                                            let fun = new newcampaign_class_1.NewCampaign();
                                            Promise.all(allCampaignkey.map((item) => {
                                                return new Promise((resolve, reject) => {
                                                    fun.campaignAutoRenewal(req, res, item.campaign_key, item.idaccount, item.iduser, false, (error, resp) => {
                                                        if (error == 1) {
                                                            console.log("Campaign autorenewal false updated successfully:", resp);
                                                            resolve(resp);
                                                        }
                                                        else {
                                                            console.error("Error updating campaign:", error);
                                                            reject(error);
                                                        }
                                                    });
                                                });
                                            })).then(() => {
                                                console.log("All campaigns autorenewal updated successfully.");
                                            }).catch(err => {
                                                console.error("Some campaigns failed to update:", err);
                                            });
                                            console.log("All Campaign Removed", allCampaign);
                                        }
                                    });
                                }
                            });
                            // Delete Brand
                            let objb = new RawQuery_1.ModelRawQuery(req, res);
                            objb.qrysql = "SELECT `idbrand` FROM `brand` WHERE `deleted`= 0 AND `delete_date` IS NULL AND `iduser` IN(" + allIdUsers + ")";
                            objb.prepare();
                            objb.execute((_errB, brandRe) => {
                                if (brandRe.length > 0) {
                                    for (let b of brandRe) {
                                        allBrandId.push(b.idbrand);
                                    }
                                    let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    // obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '2' WHERE `idbrand` IN(" + allBrandIDs + ")";
                                    obj2.nonqrysql = "UPDATE `brand` SET `delete_date` = NOW() WHERE `idbrand` IN(" + allBrandIDs + ")";
                                    obj2.prepare();
                                    obj2.execute((_errorBrand, resultBrand) => {
                                        if (resultBrand.length > 0) {
                                            console.log("All Brand Removed", allBrandId);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
                // add here delete feature for session,api and connection.
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `session` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '1'";
                obj.prepare();
                obj.execute((__error, delSessRes) => {
                    console.log("All Session Remove");
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '1'";
                    obj0.prepare();
                    obj0.execute((error, delApiRes) => {
                        console.log("Api Details Remove");
                        // let obj1 = new ModelRawNonQuery(req, res);
                        // obj1.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`=" + sdata.sesidaccount + " AND `isDeleted` = '" + sdata.isDeleted + "'";
                        // obj1.prepare();
                        // obj1.execute((____error: any, result: any) => {
                        //     console.log("All Connection Remove");
                        // })
                    });
                });
                // closed here
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + sdata.isDeleted + "', `deleted_date`=NOW() WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj2.prepare();
                obj2.execute((_errorDEL, resultDEL) => {
                    if (_errorDEL == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: [], message: "Account Successfully Deleted!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Release DID From Account Delete Process!", status: 502 });
                        objv.execute();
                    }
                });
                let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj00.prepare();
                obj00.execute((error, resultIdEnPoint) => {
                    let endPointId = [];
                    for (let i of resultIdEnPoint) {
                        endPointId.push(i.idendpoint);
                    }
                    let endPointIds = endPointId.length > 0 ? endPointId : "''";
                    let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj01.prepare();
                    obj01.execute((error, resInbound) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Inbound Restored");
                        }
                        else {
                            console.log("Inbound Removed");
                        }
                    });
                    let obj02 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj02.prepare();
                    obj02.execute((error, resOutbound) => {
                        if (sdata.isDeleted == 0) {
                            console.log("Outbound Restored");
                        }
                        else {
                            console.log("OutBound Removed");
                        }
                    });
                    let obj03 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj03.prepare();
                    obj03.execute((error, resIp) => {
                        console.log("IP Address Removed");
                    });
                    let obj04 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj04.prepare();
                    obj04.execute((error, resRoute) => {
                        console.log("Routing Removed");
                    });
                    let obj05 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                    obj05.prepare();
                    obj05.execute((error, resHook) => {
                        console.log("Hooksetting Removed");
                    });
                });
                let obj03 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj03.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE `idaccount` = " + sdata.sesidaccount + "";
                obj03.prepare();
                obj03.execute((error, result) => {
                });
                let obj22 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj22.nonqrysql = "UPDATE `subscription_account` SET `status` = '0' WHERE idaccount ='" + sdata.sesidaccount + "'";
                obj22.prepare();
                obj22.execute((error, resOutbound) => {
                    console.log("subscription account inactive");
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 504 });
                objv.execute();
            }
        });
    }
}
exports.AccountDelete = AccountDelete;
