"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customerGroup = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
// import { AppRoute } from "../lib/AppRoute";
const RawQuery_1 = require("../lib/model/RawQuery");
// const request = require("request");
const markError_1 = require("./markError");
class customerGroup {
    constructor() {
        // super();
    }
    saveCustomerGroup(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    if (sdata.group_name && /^\s/.test(sdata.group_name)) {
                        sdata.group_name = sdata.group_name.trimLeft();
                    }
                    if (sdata.description && /^\s/.test(sdata.description)) {
                        sdata.description = sdata.description.trimLeft();
                    }
                    let objS = new RawQuery_1.ModelRawQuery(req, res);
                    objS.qrysql = "SELECT `group_name` , `cgid` , `description` , `groupid`  FROM `customer_group` WHERE `group_name` = '" + (0, markError_1.parseBody)(sdata.group_name) + "' AND `status` = '0'";
                    objS.prepare();
                    objS.execute((err, result) => {
                        if (err == 1) {
                            if (result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Group name already exists!", status: 400 });
                                objv.execute();
                            }
                            else {
                                let group_id = "";
                                const alphabet = '0123456789';
                                const alphabetLength = alphabet.length;
                                const length = 7;
                                group_id = 'CG';
                                for (let i = 0; i < length; i++) {
                                    const randomIndex = Math.floor(Math.random() * alphabetLength);
                                    const isDigit = randomIndex >= 52;
                                    group_id += isDigit ? alphabet[randomIndex] : alphabet.charAt(randomIndex);
                                }
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `customer_group`(`groupid`,`iduser`,`idaccount`,`group_name`,`description`) VALUES ('" + group_id + "'," + sessdata.iduser + "," + sessdata.idaccount + ",'" + (0, markError_1.parseBody)(sdata.group_name) + "','" + (0, markError_1.parseBody)(sdata.description) + "')";
                                obj.prepare();
                                obj.execute((err, result) => {
                                    if (err == 1) {
                                        let insertedGroupId = group_id;
                                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                                        obj.qrysql = "SELECT `cgid` FROM `customer_group` WHERE `groupid` = '" + insertedGroupId + "'";
                                        obj.prepare();
                                        obj.execute((err, result) => {
                                            if (err == 1 && result.length > 0) {
                                                let insertedData = result[0];
                                                let objGroupUpdate = new RawQuery_1.ModelRawQuery(req, res);
                                                objGroupUpdate.qrysql = "UPDATE `customer_group` SET `updated_date` = NOW() WHERE `cgid` = " + insertedData.cgid + "";
                                                objGroupUpdate.prepare();
                                                objGroupUpdate.execute((error, resGroupUpdate) => { });
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Customer Group Saved Successfully!", data: insertedData.cgid, status: 200 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Failed to retrieve inserted customer group data!", status: 500 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went wrong With Customer Group Details!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Failed to check for duplicate group name!", status: 500 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateCustomerGroup(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data.data;
                    let cgID = req.body.data.cgID;
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "UPDATE `customer_group` SET `group_name`='" + (0, markError_1.parseBody)(sdata.group_name).trim() + "' , `description` = '" + (0, markError_1.parseBody)(sdata.description) + "',`updated_date` = NOW() WHERE `cgid`= " + cgID + "";
                    obj0.prepare();
                    obj0.execute((error, resUser) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Customer Group Updated Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    saveCustomerMapping(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let qry = "INSERT INTO `customer_group_mapping`(`cgid`,`master_iduser`,`master_idaccount`,`slave_idaccount` ,`slave_iduser`) VALUES";
                    sdata.slaveaccount.forEach((slaveAccount, index) => {
                        let slaveIdUser = sdata.slave_iduser[index];
                        qry += "(" + sdata.cgid + "," + sdata.master_iduser + "," + sdata.masteraccount + "," + slaveAccount + "," + slaveIdUser + "),";
                    });
                    obj.nonqrysql = qry.slice(0, -1);
                    obj.prepare();
                    obj.execute((err, result) => {
                        if (err === 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Customer Mapping Saved Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong With Customer Mapping Details!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateCustomerMapping(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let cgID = req.body.data.cgID;
                    let condition = '';
                    if (sdata.masterIdUser) {
                        condition += ",`master_iduser` = " + sdata.masterIdUser + "";
                    }
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `cmid`, `slave_idaccount` FROM `customer_group_mapping` WHERE `cgid` = " + cgID + "";
                    obj0.prepare();
                    obj0.execute((error, resCM) => {
                        if (resCM.length > 0) {
                            let objGroupUpdate = new RawQuery_1.ModelRawQuery(req, res);
                            objGroupUpdate.qrysql = "UPDATE `customer_group` SET `updated_date` = NOW() WHERE `cgid` = " + cgID;
                            objGroupUpdate.prepare();
                            objGroupUpdate.execute((error, resGroupUpdate) => { });
                            let objQuery = new RawQuery_1.ModelRawQuery(req, res);
                            let deleteQuery = `DELETE FROM customer_group_mapping WHERE cgid = ${cgID}`;
                            objQuery.qrysql = deleteQuery;
                            objQuery.prepare();
                            objQuery.execute((deleteError, deleteResult) => {
                                if (deleteError !== 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went Wrong!", status: 502 });
                                    objv.execute();
                                    return;
                                }
                                let masterId = Array.isArray(sdata.masterId) && sdata.masterId[0]?.idField ? sdata.masterId[0].idField : sdata.masterId;
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qry = "INSERT INTO `customer_group_mapping`(`cgid`,`master_idaccount`,`master_iduser`,`slave_idaccount` ,`slave_iduser`) VALUES";
                                sdata.slaveIds.forEach((slaveId, index) => {
                                    let slaveIdUser = sdata.slaveUsers[index];
                                    if (typeof slaveId === 'object' && slaveId.idField2) {
                                        slaveId = slaveId.idField2;
                                    }
                                    qry += "(" + cgID + "," + masterId + "," + sdata.masterIdUser + "," + slaveId + "," + slaveIdUser + "),";
                                });
                                obj.nonqrysql = qry.slice(0, -1);
                                obj.prepare();
                                obj.execute((insertError, insertResult) => {
                                    if (insertError == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Customer Mapping Updated Successfully!", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went Wrong!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            });
                        }
                        else {
                            // If no existing records, insert all
                            let masterId;
                            if (typeof sdata.masterId[0] === 'object' && sdata.masterId[0].hasOwnProperty('idField')) {
                                masterId = sdata.masterId[0].idField;
                            }
                            else {
                                masterId = sdata.masterId;
                            }
                            let objGroupUpdate = new RawQuery_1.ModelRawQuery(req, res);
                            objGroupUpdate.qrysql = "UPDATE `customer_group` SET `updated_date` = NOW() WHERE `cgid` = " + cgID;
                            objGroupUpdate.prepare();
                            objGroupUpdate.execute((error, resGroupUpdate) => { });
                            let insertValues = sdata.slaveIds.map((slaveId, index) => {
                                let slaveUser;
                                if (typeof slaveId === 'object' && slaveId.hasOwnProperty('idField2')) {
                                    slaveId = slaveId.idField2;
                                    slaveUser = sdata.slaveUsers[index];
                                }
                                else {
                                    slaveUser = sdata.slaveUsers[index];
                                }
                                return `(${cgID}, ${slaveId}, ${slaveUser}, ${masterId}, ${sdata.masterIdUser})`;
                            }).join(", ");
                            let insertQuery = `INSERT INTO customer_group_mapping (cgid, slave_idaccount, slave_iduser, master_idaccount, master_iduser) 
                                       VALUES ${insertValues}`;
                            let objInsert = new RawQuery_1.ModelRawQuery(req, res);
                            objInsert.qrysql = insertQuery;
                            objInsert.prepare();
                            objInsert.execute((error, resInsert) => {
                                if (error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Customer Mapping Updated Successfully!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateUserList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "UPDATE `user` SET `group_status`='" + sdata.group_status + "' WHERE `idaccount`=" + sdata.idaccount + "";
                    obj0.prepare();
                    obj0.execute((error, resUser) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Update Customer List Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getCustomerGroups(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "SELECT DISTINCT cg.`cgid`,cg.`groupid`, cg.`group_name`, cg.`description`,cg.`created_date`,cg.`updated_date`, cm.`master_idaccount` FROM `customer_group` cg LEFT JOIN `customer_group_mapping` cm ON cg.`cgid` = cm.`cgid` WHERE cg.`status` = 0;";
                    obj.prepare();
                    obj.execute((err, result) => {
                        if (err == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Customer Group Data Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    applyGroupFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let condition = "";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                if (data.groupid)
                    condition += 'cg.`groupid` LIKE "%' + (0, markError_1.parseBody)(data.groupid) + '%" AND ';
                if (data.groupname)
                    condition += 'cg.`group_name` LIKE "%' + (0, markError_1.parseBody)(data.groupname) + '%" AND ';
                // if (data.master)
                //     condition += 'cm.`master_idaccount` LIKE "%' + data.master + '%" AND ';
                if (Array.isArray(data.master) && data.master.length > 0 && data.master[0].idaccount) {
                    condition += 'cm.`master_idaccount` LIKE "%' + data.master[0].idaccount + '%" AND ';
                }
                if (data.from_date && data.to_date) {
                    condition += ' cg.`created_date` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59" AND';
                }
                obj.qrysql = "SELECT DISTINCT cg.`cgid`,cg.`groupid`,cg.`group_name`,cg.`description`,cm.`master_idaccount`,cg.`created_date` FROM  `customer_group` cg LEFT JOIN  `customer_group_mapping` cm ON cg.`cgid` = cm.`cgid` WHERE  " + condition + " cg.`status`=0";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Groups Fetched Successfully!",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getCustomerGroup(req, res, next) {
        let cgID = req.query.cgID;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "SELECT cg.`cgid`,cg.`groupid`, cg.`group_name`, cg.`description`, cm.`master_idaccount` , cm.`master_iduser` FROM `customer_group` cg LEFT JOIN `customer_group_mapping` cm ON cg.`cgid` = cm.`cgid` WHERE cg.`cgid`='" + cgID + "' AND cg.`status` = 0;";
                    obj.prepare();
                    obj.execute((err, result) => {
                        if (err == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Customer Group Data Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getSlaveAccount(req, res, next) {
        let masterID = req.query.masterID;
        let cgID = req.query.cgID;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "SELECT DISTINCT `slave_idaccount` FROM `customer_group_mapping`  WHERE `cgid`='" + cgID + "' ";
                    obj.prepare();
                    obj.execute((err, result) => {
                        if (err == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Slave Account Data Fetched Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteCustomerGroup(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                if (sessdata.type == 1) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql =
                        "SELECT `slave_idaccount`,`master_idaccount` FROM `customer_group_mapping` WHERE `cgid`='" +
                            sdata.cgID +
                            "' AND `cm_status`= 0 ";
                    obj.prepare();
                    obj.execute((err, result) => {
                        if (err == 1) {
                            if (result && result.length > 0 && typeof result[0].master_idaccount !== "undefined") {
                                let slaveIds = result.map((row) => row.slave_idaccount);
                                let masterId = result[0].master_idaccount;
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql =
                                    "SELECT DISTINCT  `slave_idaccount`, `master_idaccount`,`cgid` FROM `customer_group_mapping` WHERE `cgid`!='" +
                                        sdata.cgID +
                                        "' AND `cm_status`= 0 ";
                                obj1.execute((err, res) => {
                                    let groupedMasterIds = res.reduce((acc, row) => {
                                        let existingGroup = acc.find((group) => group.cgid === row.cgid);
                                        if (existingGroup) {
                                            let existingMaster = existingGroup.data.find((master) => master.master_idaccount === row.master_idaccount);
                                            if (existingMaster) {
                                                existingMaster.slave_idaccounts.push(row.slave_idaccount);
                                            }
                                            else {
                                                existingGroup.data.push({
                                                    master_idaccount: row.master_idaccount,
                                                    slave_idaccounts: [row.slave_idaccount],
                                                });
                                            }
                                        }
                                        else {
                                            acc.push({
                                                cgid: row.cgid,
                                                data: [
                                                    {
                                                        master_idaccount: row.master_idaccount,
                                                        slave_idaccounts: [row.slave_idaccount],
                                                    },
                                                ],
                                            });
                                        }
                                        return acc;
                                    }, []);
                                    // groupedMasterIds.forEach((group: any) => {
                                    //     console.log(`cgid: ${group.cgid}`);
                                    //     group.data.forEach((obj: any) => {
                                    //         console.log(obj);
                                    //     });
                                    // });
                                    let matchingGroup = groupedMasterIds.filter((group) => {
                                        return group.data.some((master) => master.master_idaccount === masterId);
                                    });
                                    if (matchingGroup.length > 0) {
                                        let allSlaveIds = [];
                                        matchingGroup.forEach((group) => {
                                            group.data.forEach((obj) => {
                                                obj.slave_idaccounts.forEach((slaveId) => {
                                                    if (!allSlaveIds.includes(slaveId)) {
                                                        allSlaveIds.push(slaveId);
                                                    }
                                                });
                                            });
                                        });
                                        let notFoundSlaveIds = [];
                                        slaveIds.forEach((slaveId) => {
                                            if (!allSlaveIds.includes(slaveId)) {
                                                notFoundSlaveIds.push(slaveId);
                                            }
                                        });
                                        // let allDids: any=[];
                                        if (notFoundSlaveIds.length > 0) {
                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj2.nonqrysql =
                                                "SELECT `campaign_key` FROM `campaign` WHERE `idaccount` IN ('" +
                                                    notFoundSlaveIds.join("', '") +
                                                    "') AND `provisioning_status` = 3";
                                            obj2.prepare();
                                            obj2.execute((error, allcamp) => {
                                                let campaignKeys = allcamp.map((row) => row.campaign_key);
                                                if (campaignKeys.length > 0) {
                                                    campaignKeys.forEach((element) => {
                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj3.nonqrysql =
                                                            "SELECT `did` from `did_buy` WHERE `camp_registry`='" +
                                                                element +
                                                                "'";
                                                        obj3.prepare();
                                                        obj3.execute((err, dids) => {
                                                            if (dids.length > 0) {
                                                                let allDids = dids.map((row) => row.did);
                                                                allDids.forEach((did) => {
                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj4.nonqrysql =
                                                                        "UPDATE `did_buy` SET `osr_status` = 'unregister',`sms_provider` = '',`camp_registry` = '', `sms_mrc`=0,`sinch_status`=0 WHERE `did`='" +
                                                                            did +
                                                                            "' ";
                                                                    obj4.prepare();
                                                                    obj4.execute((err, result) => {
                                                                        let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj5.nonqrysql =
                                                                            "UPDATE  `campaign` SET `did_count` = `did_count`-1 WHERE  `campaign_key` = '" +
                                                                                element +
                                                                                "' ";
                                                                        obj5.prepare();
                                                                        obj5.execute((err, ress) => {
                                                                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj6.nonqrysql =
                                                                                "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                                                    sdata.cgID +
                                                                                    "' ";
                                                                            obj6.prepare();
                                                                            obj6.execute((err, result) => { });
                                                                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj7.nonqrysql =
                                                                                "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                                                    sdata.cgID +
                                                                                    "' ";
                                                                            obj7.prepare();
                                                                            obj7.execute((err, result) => { });
                                                                        });
                                                                    });
                                                                });
                                                            }
                                                            else {
                                                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj6.nonqrysql =
                                                                    "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                                        sdata.cgID +
                                                                        "' ";
                                                                obj6.prepare();
                                                                obj6.execute((err, result) => { });
                                                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj7.nonqrysql =
                                                                    "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                                        sdata.cgID +
                                                                        "' ";
                                                                obj7.prepare();
                                                                obj7.execute((err, result) => { });
                                                            }
                                                        });
                                                    });
                                                }
                                                else {
                                                    let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj6.nonqrysql =
                                                        "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                            sdata.cgID +
                                                            "' ";
                                                    obj6.prepare();
                                                    obj6.execute(() => { });
                                                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj7.nonqrysql =
                                                        "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                            sdata.cgID +
                                                            "' ";
                                                    obj7.prepare();
                                                    obj7.execute((err, result) => { });
                                                }
                                            });
                                        }
                                        else {
                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj2.nonqrysql =
                                                "SELECT `campaign_key` FROM `campaign` WHERE `idaccount` IN ('" +
                                                    slaveIds.join("', '") +
                                                    "') AND `provisioning_status` = 3";
                                            obj2.prepare();
                                            obj2.execute((error, allcamp) => {
                                                let campaignKeys = allcamp.map((row) => row.campaign_key);
                                                if (campaignKeys.length > 0) {
                                                    campaignKeys.forEach((element) => {
                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj3.nonqrysql =
                                                            "SELECT `did` from `did_buy` WHERE `camp_registry`='" +
                                                                element +
                                                                "'";
                                                        obj3.prepare();
                                                        obj3.execute((err, dids) => {
                                                            if (dids.length > 0) {
                                                                let allDids = dids.map((row) => row.did);
                                                                allDids.forEach((did) => {
                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj4.nonqrysql =
                                                                        "UPDATE `did_buy` SET `osr_status` = 'unregister',`sms_provider` = '',`camp_registry` = '', `sms_mrc`=0,`sinch_status`=0 WHERE `did`='" +
                                                                            did +
                                                                            "' ";
                                                                    obj4.prepare();
                                                                    obj4.execute((err, result) => {
                                                                        let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj5.nonqrysql =
                                                                            "UPDATE  `campaign` SET `did_count` = `did_count`-1 WHERE  `campaign_key` = '" +
                                                                                element +
                                                                                "' ";
                                                                        obj5.prepare();
                                                                        obj5.execute((err, ress) => {
                                                                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj6.nonqrysql =
                                                                                "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                                                    sdata.cgID +
                                                                                    "' ";
                                                                            obj6.prepare();
                                                                            obj6.execute(() => { });
                                                                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj7.nonqrysql =
                                                                                "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                                                    sdata.cgID +
                                                                                    "' ";
                                                                            obj7.prepare();
                                                                            obj7.execute((err, result) => { });
                                                                        });
                                                                    });
                                                                });
                                                            }
                                                            else {
                                                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj6.nonqrysql =
                                                                    "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                                        sdata.cgID +
                                                                        "' ";
                                                                obj6.prepare();
                                                                obj6.execute((err, ress) => { });
                                                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj7.nonqrysql =
                                                                    "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                                        sdata.cgID +
                                                                        "' ";
                                                                obj7.prepare();
                                                                obj7.execute((err, result) => { });
                                                            }
                                                        });
                                                    });
                                                }
                                                else {
                                                    let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj6.nonqrysql =
                                                        "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                            sdata.cgID +
                                                            "' ";
                                                    obj6.prepare();
                                                    obj6.execute((err, ress) => { });
                                                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj7.nonqrysql =
                                                        "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                            sdata.cgID +
                                                            "' ";
                                                    obj7.prepare();
                                                    obj7.execute((err, result) => { });
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj2.nonqrysql =
                                            "SELECT `campaign_key` FROM `campaign` WHERE `idaccount` IN ('" +
                                                slaveIds.join("', '") +
                                                "') AND `provisioning_status` = 3";
                                        obj2.prepare();
                                        obj2.execute((error, allcamp) => {
                                            let campaignKeys = allcamp.map((row) => row.campaign_key);
                                            if (campaignKeys.length > 0) {
                                                campaignKeys.forEach((element) => {
                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql =
                                                        "SELECT `did` from `did_buy` WHERE `camp_registry`='" +
                                                            element +
                                                            "'";
                                                    obj3.prepare();
                                                    obj3.execute((err, dids) => {
                                                        if (dids.length > 0) {
                                                            let allDids = dids.map((row) => row.did);
                                                            allDids.forEach((did) => {
                                                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj4.nonqrysql =
                                                                    "UPDATE `did_buy` SET `osr_status` = 'unregister',`sms_provider` = '',`camp_registry` = '', `sms_mrc`=0,`sinch_status`=0 WHERE `did`='" +
                                                                        did +
                                                                        "' ";
                                                                obj4.prepare();
                                                                obj4.execute((err, result) => {
                                                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj5.nonqrysql =
                                                                        "UPDATE  `campaign` SET `did_count` = `did_count`-1 WHERE  `campaign_key` = '" +
                                                                            element +
                                                                            "' ";
                                                                    obj5.prepare();
                                                                    obj5.execute((err, ress) => {
                                                                        let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj6.nonqrysql =
                                                                            "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                                                sdata.cgID +
                                                                                "' ";
                                                                        obj6.prepare();
                                                                        obj6.execute(() => { });
                                                                        let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj7.nonqrysql =
                                                                            "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                                                sdata.cgID +
                                                                                "' ";
                                                                        obj7.prepare();
                                                                        obj7.execute((err, result) => { });
                                                                    });
                                                                });
                                                            });
                                                        }
                                                        else {
                                                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj6.nonqrysql =
                                                                "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                                    sdata.cgID +
                                                                    "' ";
                                                            obj6.prepare();
                                                            obj6.execute((err, ress) => {
                                                            });
                                                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj7.nonqrysql =
                                                                "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                                    sdata.cgID +
                                                                    "' ";
                                                            obj7.prepare();
                                                            obj7.execute((err, result) => { });
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj6.nonqrysql =
                                                    "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                                        sdata.cgID +
                                                        "' ";
                                                obj6.prepare();
                                                obj6.execute((err, ress) => { });
                                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj7.nonqrysql =
                                                    "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                                        sdata.cgID +
                                                        "' ";
                                                obj7.prepare();
                                                obj7.execute((err, result) => { });
                                            }
                                        });
                                    }
                                });
                                let objv1 = new RawView_1.RawView(res);
                                objv1.prepare({
                                    message: "Customer Group Deleted Successfully",
                                    status: 200,
                                });
                                objv1.execute();
                            }
                            else {
                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj6.nonqrysql =
                                    "UPDATE  `customer_group` SET `status` = 1 WHERE  `cgid` = '" +
                                        sdata.cgID +
                                        "' ";
                                obj6.prepare();
                                obj6.execute(() => {
                                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj7.nonqrysql =
                                        "UPDATE  `customer_group_mapping` SET `cm_status` = 1 WHERE  `cgid` = '" +
                                            sdata.cgID +
                                            "' ";
                                    obj7.prepare();
                                    obj7.execute((err, result) => { });
                                    let objv1 = new RawView_1.RawView(res);
                                    objv1.prepare({
                                        message: "Customer Group Deleted Successfully",
                                        status: 200,
                                    });
                                    objv1.execute();
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.customerGroup = customerGroup;
