"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Twillio = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const setting_config_1 = require("../config/setting.config");
const markError_1 = require("./markError");
const APIBase_1 = require("./APIBase");
const numberApi_1 = require("./numberApi");
let insertdid = new APIBase_1.APIBase();
const twilio = new setting_config_1.Twilio();
const crypto = require('crypto');
var request = require('request');
class Twillio extends APIBase_1.APIBase {
    sessdata;
    constructor(sessdata) {
        super();
        this.sessdata = sessdata;
    }
    createSubaccount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession(async (sessErr, sessData) => {
            if (sessErr == 1) {
                if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                    const sdata = JSON.parse(req.body.data);
                    let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                    let datasess = {
                        iduser: sessData.iduser,
                        idaccount: sessData.idaccount,
                        ipAddress: sysInfo.ipAddress[0],
                    };
                    let funDetail = {
                        tableName: 'did_log',
                        functionName: 'createSubaccount',
                        logName: 'DID'
                    };
                    const options = {
                        method: 'POST',
                        url: `${twilio.accounturl}/Accounts`,
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        auth: {
                            user: twilio.Username,
                            pass: twilio.Password
                        },
                        form: {
                            FriendlyName: sessData.username,
                        },
                    };
                    console.log("createSubaccount Request :: ", options);
                    request(options, async (error, response) => {
                        try {
                            let combinedLog = response.data + ',' + JSON.stringify(datasess);
                            if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                let data = JSON.parse(response.body);
                                // console.log("createSubaccount Response :: ", data);
                                if (data.sid) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `verified_sender` SET `subaccount_sid`='" + data.sid + "' WHERE `unique_request_id`='" + sdata.request_id + "' AND `idaccount`='" + sessData.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((err5, resp5) => { });
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `twillio_subaccount` (`sid`,`friendly_name`,`status`,`auth_token`,`date_created`,`date_updated`,`owner_account_sid`,`uri`,`subresource_uris`,`full_res`) VALUES ('" + data.sid + "','" + data.friendly_name + "','" + data.status + "','" + data.auth_token + "','" + data.date_created + "','" + data.date_updated + "','" + data.owner_account_sid + "','" + data.uri + "','" + JSON.stringify(data.subresource_uris) + "','" + combinedLog + "')";
                                    obj1.prepare();
                                    obj1.execute((err5, resp5) => { });
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sessData.idaccount,
                                            iduser: sessData.iduser,
                                            did: sdata.DID.trim(),
                                            provider: 'twillio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '66',
                                            description: 'SUB Account Created',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    });
                                    let twillio = new Twillio(sessData);
                                    await twillio.movenumbermain2sub(req, res, next, data, sdata.request_id, sdata.incoming_phone_number_sid, sdata.DID.trim(), async (error, resp) => {
                                        if (error == 1) {
                                            await twillio.VerifyProfile(req, res, next, sdata, resp, data, (err, resp) => {
                                                if (err == 1) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 200, message: "SMS Enable Facility is in Process! It take 2-3 days for verification!" });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 501, message: "Something Went Wrong!" });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 501, message: "Something Went Wrong!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sessData.idaccount,
                                            iduser: sessData.iduser,
                                            did: sdata.DID.trim(),
                                            provider: 'twillio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '67',
                                            description: 'SUB Account Not Created',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    });
                                    console.log({ status: 501, message: "Sub Account  is not created!" });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 501, message: "SMS is not Enabled" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 501, message: "SMS is not Enabled!" });
                                objv.execute();
                            }
                        }
                        catch (err) {
                            console.error('createSubaccount Error:', err);
                            // callback(0, 'Not created')
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 501, message: "SMS is not Enabled" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    async movenumbermain2sub(req, res, next, subaccount, requestId, phone_sid, did, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                    let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                    let funDetail = {
                        tableName: 'did_log',
                        functionName: 'movenumbermain2sub',
                        logName: 'DID'
                    };
                    let datasess = {
                        iduser: sessData.iduser,
                        idaccount: sessData.idaccount,
                        ipAddress: sysInfo.ipAddress[0],
                    };
                    // fetch phone number sid and customer sub account 
                    const options = {
                        method: 'POST',
                        url: `${twilio.accounturl}/Accounts/${twilio.Username}/IncomingPhoneNumbers/${phone_sid}.json`,
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        auth: {
                            user: twilio.Username,
                            pass: twilio.Password
                        },
                        form: {
                            AccountSid: subaccount.sid,
                        },
                    };
                    console.log("movenumbermain2sub Request :: ", options);
                    request(options, (error, response) => {
                        try {
                            let combinedLog = response.body + ',' + JSON.stringify(datasess);
                            if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                let data1 = JSON.parse(response.body);
                                if (data1.sid) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `did_buy` SET `order_id`='" + data1.sid + "' WHERE `did`='" + did + "' AND `account_id`='" + sessData.idaccount + "' AND `type` = 'TF'";
                                    obj.prepare();
                                    obj.execute((err5, resp5) => { });
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sessData.idaccount,
                                            iduser: sessData.iduser,
                                            did: did,
                                            provider: 'twillio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '68',
                                            description: 'Move Number From Main Account To SUB Account',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    });
                                    console.log({ status: 201, message: "Number Move Succesfully", data: data1 });
                                    callback(1, 'Number Moved succesfully');
                                }
                                else {
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sessData.idaccount,
                                            iduser: sessData.iduser,
                                            did: did,
                                            provider: 'twillio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '69',
                                            description: 'Number Not Move From Main Account To SUB Account',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    });
                                    console.log({ status: 501, message: "Number Not Move Successfully" });
                                    callback(0, 'Number Not Moved succesfully');
                                }
                            }
                            else {
                                // throw error; // Throw the error to be caught in the catch block
                                callback(0, 'Number Not Moved succesfully');
                                console.error('movenumbermain2sub Error:', error);
                            }
                        }
                        catch (err) {
                            console.error('movenumbermain2sub Error:', err);
                            callback(0, 'Number Not Moved succesfully');
                        }
                    });
                }
                else {
                    console.log({ message: "Service Unavailable!", status: 503 });
                    callback(0, { message: "Service Unavailable!", status: 503 });
                }
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    async VerifyProfile(req, res, next, otherdata, resp, data, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                    let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                    let datasess = {
                        iduser: sessData.iduser,
                        idaccount: sessData.idaccount,
                        ipAddress: sysInfo.ipAddress[0],
                    };
                    let funDetail = {
                        tableName: 'did_log',
                        functionName: 'VerifyProfile',
                        logName: 'DID'
                    };
                    const sdata = otherdata;
                    let objj = new RawQuery_1.ModelRawQuery(req, res);
                    objj.qrysql = "SELECT vs.business_name, vs.address1, vs.address2, vs.city, vs.state, vs.zip, vs.business_country, vs.corporate_website_url, vs.first_name, vs.last_name, vs.business_email, vs.business_phone, vs.notification_email, vs.summarize_usecase, vs.use_case_category, vs.sample_message, vs.opt_in_type, vs.message_volume_per_month, vs.additional_supporting_documentation, vs.external_reference, GROUP_CONCAT(DISTINCT vsl.file_path) AS file_paths FROM `verified_sender` vs JOIN `verified_sender_file` vsl ON vs.unique_request_id = vsl.unique_request_id WHERE vs.unique_request_id = '" + sdata.request_id + "' AND vs.idaccount = '" + sessData.idaccount + "' GROUP BY vs.unique_request_id";
                    objj.prepare();
                    objj.execute((errr, respp) => {
                        if (errr == 1) {
                            const filePaths = respp[0].file_paths ? respp[0].file_paths.split(',') : [];
                            let optInImageUrls = [];
                            if (filePaths.length > 0) {
                                optInImageUrls = filePaths.map((filePath, index) => {
                                    return `${filePath}`;
                                });
                            }
                            const options = {
                                method: 'POST',
                                url: `${twilio.verifyurl}`,
                                headers: {
                                    'Content-Type': 'application/x-www-form-urlencoded',
                                },
                                auth: {
                                    user: data.sid,
                                    pass: data.auth_token
                                },
                                form: {
                                    BusinessName: respp[0].business_name,
                                    BusinessStreetAddress: respp[0].address1,
                                    BusinessStreetAddress2: respp[0].address2,
                                    BusinessCity: respp[0].city,
                                    BusinessStateProvinceRegion: respp[0].state,
                                    BusinessPostalCode: respp[0].zip,
                                    BusinessCountry: respp[0].business_country,
                                    BusinessWebsite: respp[0].corporate_website_url,
                                    BusinessContactFirstName: respp[0].first_name,
                                    BusinessContactLastName: respp[0].last_name,
                                    BusinessContactEmail: respp[0].business_email,
                                    BusinessContactPhone: respp[0].business_phone,
                                    NotificationEmail: respp[0].notification_email,
                                    UseCaseCategories: respp[0].use_case_category,
                                    UseCaseSummary: respp[0].summarize_usecase,
                                    ProductionMessageSample: respp[0].sample_message,
                                    OptInType: respp[0].opt_in_type,
                                    MessageVolume: respp[0].message_volume_per_month,
                                    AdditionalInformation: respp[0].additional_supporting_documentation,
                                    TollfreePhoneNumberSid: resp.sid,
                                    ExternalReferenceId: respp[0].external_reference,
                                    OptInImageUrls: optInImageUrls,
                                },
                            };
                            console.log("VerifyProfile Request :: ", options);
                            request(options, (error, response) => {
                                try {
                                    let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                    console.log("VerifyProfile Error :: ", error);
                                    if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                        let data = JSON.parse(response.body);
                                        console.log("VerifyProfile Response :: ", data);
                                        if (data.sid) {
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `verified_sender` SET `status`= '4',`provider`= '1',`review_date`=NOW() WHERE `idaccount` = '" + sessData.idaccount + "' AND `unique_request_id` = '" + sdata.request_id + "'";
                                            obj.prepare();
                                            obj.execute((err, resp) => {
                                                if (err == 1) {
                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='15' WHERE `account_id` = '" + sessData.idaccount + "' AND `did` = '" + sdata.DID + "' AND `type` = 'TF'";
                                                    obj1.prepare();
                                                    obj1.execute((err1, resp1) => {
                                                        if (err1 == 1) {
                                                            let logPayload = {
                                                                funDetail,
                                                                data: {
                                                                    account_id: sessData.idaccount,
                                                                    iduser: sessData.iduser,
                                                                    did: sdata.DID.trim(),
                                                                    event_type: '64',
                                                                    description: 'Verifying Profile In Process',
                                                                    sinch_status: '15',
                                                                    full_log: combinedLog
                                                                }
                                                            };
                                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                if (log_error == 1) {
                                                                    let objj = new RawQuery_1.ModelRawQuery(req, res);
                                                                    objj.qrysql = "SELECT `did` FROM `tollfree_assigned_number` WHERE  `did`='" + sdata.DID.trim() + "' AND `idaccount`='" + sessData.idaccount + "'";
                                                                    objj.prepare;
                                                                    objj.execute((errj, resp) => {
                                                                        if (resp.length >= 1) {
                                                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj3.nonqrysql = "UPDATE `tollfree_assigned_number` SET `requestId`='" + sdata.request_id + "' WHERE `did`='" + sdata.DID.trim() + "' AND `idaccount`='" + sessData.idaccount + "'";
                                                                            obj3.prepare();
                                                                            obj3.execute((err3, resp3) => { });
                                                                        }
                                                                        else {
                                                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj3.nonqrysql = "INSERT INTO `tollfree_assigned_number`(`idaccount`,`iduser`,`requestId`,`did`,`statusCode`,`orderId`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + sdata.request_id + "','" + sdata.DID + "','" + (0, markError_1.setToZero)(data.statusCode) + "','" + data.incoming_phone_number_sid + "')";
                                                                            obj3.prepare();
                                                                            obj3.execute((err3, resp3) => { });
                                                                        }
                                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj4.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`unique_request_id`,`full_log`) VALUES ('" + sessData.iduser + "', '" + sessData.idaccount + "', '10', 'VERIFYING_PROFILE_STARTED', 'Verifying Profile Process started','" + sdata.request_id + "','" + combinedLog + "')";
                                                                        obj4.prepare();
                                                                        obj4.execute(async (err4, result4) => {
                                                                            if (err4 == 1) {
                                                                                callback(1, "Verify profile succesfully");
                                                                            }
                                                                            else {
                                                                                callback(0, "Verify profile not succesfully");
                                                                            }
                                                                        });
                                                                    });
                                                                }
                                                                else {
                                                                    callback(0, "Verify profile not succesfully");
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            callback(0, "Verify profile not succesfully");
                                                        }
                                                    });
                                                }
                                                else {
                                                    callback(0, "Verify profile not succesfully");
                                                }
                                            });
                                        }
                                        else {
                                            let logPayload = {
                                                funDetail,
                                                data: {
                                                    account_id: sessData.idaccount,
                                                    iduser: sessData.iduser,
                                                    did: sdata.DID.trim(),
                                                    event_type: '65',
                                                    description: 'Verifying Profile Failed From Provider',
                                                    sinch_status: '0',
                                                    full_log: combinedLog
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                            });
                                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj7.nonqrysql = "INSERT INTO `verified_sender_log` (`iduser`, `idaccount`, `event_type`, `event_desc`, `description`, `unique_request_id`,`full_log`) VALUES ('" + sessData.iduser + "', '" + sessData.idaccount + "', '11', 'VERIFYING_PROFILE_FAILED', 'Verifying Profile Failed', '" + sdata.reques_id + "','" + combinedLog + "')";
                                            obj7.prepare();
                                            obj7.execute((err4, resp4) => { });
                                            callback(0, "Verify profile not succesfully");
                                        }
                                    }
                                    else {
                                        // throw error; // Throw the error to be caught in the catch block
                                        callback(0, "Verify profile not succesfully");
                                    }
                                }
                                catch (err) {
                                    console.error('VerifyProfile Caught Error :: ', err);
                                    callback(0, "Verify profile not succesfully");
                                }
                            });
                        }
                        else {
                            callback(0, "Verify profile not succesfully");
                        }
                    });
                }
                else {
                    console.log({ message: "Service Unavailable!", status: 503 });
                    callback(0, { message: "Service Unavailable!", status: 503 });
                }
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    async movenumbersub2main(req, res, next, sdata, DID, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                if (sessData.type == 1) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `order_id` FROM `did_buy` WHERE `account_id` = '" + sdata.idaccount + "' AND `did`='" + DID + "'";
                    obj1.prepare();
                    obj1.execute((err, res) => {
                        if (err == 1 && res.length > 0) {
                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                            let datasess = {
                                iduser: sessData.iduser,
                                idaccount: sessData.idaccount,
                                ipAddress: sysInfo.ipAddress[0],
                            };
                            let funDetail = {
                                tableName: 'did_log',
                                functionName: 'movenumbersub2main',
                                logName: 'DID'
                            };
                            // Twilio API options
                            const options = {
                                method: 'POST',
                                url: `${twilio.accounturl}/Accounts/${sdata.sid}/IncomingPhoneNumbers/${res[0].order_id}.json`,
                                headers: {
                                    'Content-Type': 'application/x-www-form-urlencoded',
                                },
                                auth: {
                                    user: twilio.Username,
                                    pass: twilio.Password
                                },
                                form: {
                                    AccountSid: twilio.Username, // account SID to move the number to
                                },
                            };
                            console.log("movenumbersub2main Request :: ", options);
                            request(options, (error, response) => {
                                try {
                                    let combinedLog = response.body + ',' + JSON.stringify(datasess);
                                    if (error) {
                                        callback(0, "NOT MOVE");
                                    }
                                    else {
                                        let data1 = JSON.parse(response.body);
                                        console.log("movenumbersub2main Response :: ", data1);
                                        if (data1.sid) {
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `did_buy` SET `order_id`='" + data1.sid + "' WHERE `did`='" + DID + "' AND `account_id`='" + sdata.idaccount + "' AND `type` = 'TF'";
                                            obj.prepare();
                                            obj.execute((err5, resp5) => { });
                                            let logPayload = {
                                                funDetail,
                                                data: {
                                                    account_id: sdata.idaccount,
                                                    iduser: sdata.iduser,
                                                    did: DID,
                                                    provider: 'twillio',
                                                    type: 'TF',
                                                    disconnect_did_status: '1',
                                                    event_type: '68',
                                                    description: 'Move Number From Sub Account To Main Account',
                                                    full_log: combinedLog
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                            });
                                            let logPayload1 = {
                                                funDetail,
                                                data: {
                                                    account_id: sdata.idaccount,
                                                    iduser: sdata.iduser,
                                                    did: DID,
                                                    provider: 'twillio',
                                                    type: 'TF',
                                                    disconnect_did_status: '1',
                                                    event_type: '70',
                                                    description: 'SMS service Disable Process Started',
                                                    full_log: combinedLog
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                            });
                                            let twillio = new Twillio(sessData);
                                            twillio.SuspendSubaccount(req, res, next, sdata, data1.sid, DID, (error, resp) => {
                                                if (error == 1) {
                                                    callback(1, "Suspenede suceesfully");
                                                }
                                                else {
                                                    callback(0, "Not SUSPENDED");
                                                }
                                            });
                                            console.log({ status: 201, message: "Number moved successfully" });
                                        }
                                        else {
                                            let logPayload = {
                                                funDetail,
                                                data: {
                                                    account_id: sdata.idaccount,
                                                    iduser: sdata.iduser,
                                                    did: sdata.DID,
                                                    provider: 'twillio',
                                                    type: 'TF',
                                                    disconnect_did_status: '1',
                                                    event_type: '69',
                                                    description: 'Number Not Move From Sub Account To Main Account',
                                                    full_log: combinedLog
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                            });
                                            callback(0, "Not MOVE");
                                        }
                                    }
                                }
                                catch (err) {
                                    console.error("movenumbersub2main Error:", err);
                                    callback(0, "Not MOVE");
                                }
                            });
                        }
                        else {
                            callback(0, 'Data NOT FOund');
                        }
                    });
                }
                else {
                    callback(0, { status: 501, message: "Service Unavaialbe!" });
                }
            }
            else {
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    SuspendSubaccount(req, res, next, sdata, subAccountSid, did, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                if (sessData.type == 1) {
                    let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                    let datasess = {
                        iduser: sessData.iduser,
                        idaccount: sessData.idaccount,
                        ipAddress: sysInfo.ipAddress[0],
                    };
                    let funDetail = {
                        tableName: 'did_log',
                        functionName: 'SuspendSubaccount',
                        logName: 'DID'
                    };
                    const options = {
                        method: 'POST',
                        url: `${twilio.accounturl}/Accounts/${subAccountSid}.json`,
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        auth: {
                            user: twilio.Username,
                            pass: twilio.Password
                        },
                        form: {
                            Status: 'suspended', // or 'active' depending on use-case
                        },
                    };
                    request(options, (error, response) => {
                        try {
                            let combinedLog = response.body + ',' + JSON.stringify(datasess);
                            if (error) {
                                callback(0, null);
                            }
                            else {
                                const body = JSON.parse(response.body);
                                console.log("SuspendSubaccount Request :: ", body);
                                if (body.sid) {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `verified_sender` SET `subaccount_sid`='' WHERE `unique_request_id`='" + sdata.id + "' AND `idaccount`='" + sdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((err5, resp5) => { });
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `twillio_subaccount` (`sid`,`friendly_name`,`status`,`auth_token`,`date_created`,`date_updated`,`owner_account_sid`,`uri`,`subresource_uris`,`full_res`) VALUES ('" + body.sid + "','" + body.friendly_name + "','" + body.status + "','" + body.auth_token + "','" + body.date_created + "','" + body.date_updated + "','" + body.owner_account_sid + "','" + body.uri + "','" + JSON.stringify(body.subresource_uris) + "','" + combinedLog + "')";
                                    obj1.prepare();
                                    obj1.execute((err5, resp5) => { });
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sdata.idaccount,
                                            iduser: sdata.iduser,
                                            did: did,
                                            provider: 'twillio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '71',
                                            description: 'SUB Account Suspended',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    });
                                    console.log({ status: 200, message: "Subaccount status Suspended successfully!" });
                                    callback(1, { status: 200, message: "Subaccount status Suspended successfully!" });
                                }
                                else {
                                    let logPayload = {
                                        funDetail,
                                        data: {
                                            account_id: sdata.idaccount,
                                            iduser: sdata.iduser,
                                            did: did,
                                            provider: 'twillio',
                                            type: 'TF',
                                            disconnect_did_status: '1',
                                            event_type: '72',
                                            description: 'SUB Account Not Suspended',
                                            full_log: combinedLog
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                    });
                                    console.error("Twilio Error Response:", body);
                                    callback(0, null);
                                }
                            }
                        }
                        catch (err) {
                            console.error("SuspendSubaccount Error:", err);
                            callback(0, null);
                        }
                    });
                }
                else {
                    console.log({ message: "Service Unavailable!", status: 503 });
                    callback(0, { message: "Service Unavailable!", status: 503 });
                }
            }
            else {
                console.log({ status: 401, message: "Unauthorized User!" });
                callback(0, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
    tfRequest(req, res, groupId, callback) {
        let sdata = req.body.data ? req.body.data : req.query;
        let quantity = sdata && sdata.cdata && sdata.cdata.Qty ? sdata.cdata.Qty : sdata.Quantity;
        let fun = new numberApi_1.Number();
        fun.prorationGet(req, res, 'TF', 0, this.sessdata.idtariff, (error, proration) => {
            if (error == 1) {
                this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                    let rate = new APIBase_1.APIBase();
                    rate.prorateCalculator(req, res, proration.proration, voice_rate[0].rate, proration.setup_cost, (pc_err, prorate1) => {
                        if (pc_err == 1) {
                            let fullrates = parseFloat(voice_rate[0].rate) + parseFloat(proration.setup_cost);
                            let prorate = typeof prorate1 != 'undefined' && prorate1 > 0 ? prorate1 : 0;
                            let RateS = (parseFloat(prorate) * quantity).toFixed(3);
                            console.log("Fullrates ::> ", fullrates);
                            console.log("Final ProRate with quantity multiplied ::> ", RateS);
                            let rate = new APIBase_1.APIBase();
                            rate.checkBalance(req, res, this.sessdata.idaccount, RateS, (walletError, wallet) => {
                                if (walletError == 1) {
                                    rate.calculateNextBillingDate(req, res, voice_rate[0].billing_frequency, (billingError, billing) => {
                                        const orderId = `${Math.floor(1000000 + Math.random() * 9000000)}`;
                                        let objv6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        objv6.nonqrysql = "INSERT INTO `tollfree_request` (`iduser`, `idaccount`,`status`,`statusCode`,`orderId`,`quantity`,`order_status`,`rates`,`pro_rates`,`type`,`id_grouporder`,`billing_frequency`,`nextbilling_cycle`,`provider`) VALUE('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','0','200','" + orderId + "','" + quantity + "','0','" + fullrates + "','" + prorate + "','TF','" + groupId + "','" + (0, markError_1.setToZero)(voice_rate[0].billing_frequency) + "', '" + billing + "','1')";
                                        objv6.prepare();
                                        objv6.execute((tol_error, tf_req) => {
                                            if (tol_error == 1) {
                                                let logPayload2 = {
                                                    funDetail: {
                                                        tableName: 'wallet',
                                                        functionName: 'tfRequest',
                                                        logName: 'Wallet Update'
                                                    },
                                                    data: {
                                                        balance: '`balance`' + '-' + RateS
                                                    },
                                                    connWhere: {
                                                        idaccount: this.sessdata.idaccount
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload2, (log_error1, did_log1) => {
                                                    let logPayload1 = {
                                                        funDetail: {
                                                            tableName: 'wallet_recharge_log',
                                                            functionName: 'tfRequest',
                                                            logName: 'wallet'
                                                        },
                                                        data: {
                                                            idaccount: this.sessdata.idaccount,
                                                            amount: '-' + RateS,
                                                            purpose: 'Wallet amount successfully updated for Toll-Free Order',
                                                            status: 1,
                                                        }
                                                    };
                                                    insertdid.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                        if (log_error == 1) {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 200, message: "You have created your order successfully. Your Order will take 3 to 4 Business Days. Order ID is: (" + orderId + ")" });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 404, message: "Order is not Placed!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong with connection!" });
                                                obj.execute();
                                            }
                                        });
                                        let logPayload = {
                                            funDetail: {
                                                tableName: 'did_log',
                                                functionName: 'tfRequest',
                                                logName: 'DID'
                                            },
                                            data: {
                                                account_id: this.sessdata.idaccount,
                                                status: '200',
                                                full_log: "'DID Order created successfully from provider from twilio",
                                                iduser: this.sessdata.iduser,
                                                event_type: 44,
                                                description: 'DID Order created successfully from provider',
                                                provider: 'twillio',
                                            }
                                        };
                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                            console.log("DID Order created successfully from provider.");
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: 0,
                                        error: walletError,
                                        message: "You have insufficient funds in your account. Kindly add funds to your account!",
                                        status: 503
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error_code: 0,
                                error: 'Wallet Issue',
                                message: "Something Went Wrong to Fetch Account Balance.",
                                status: 503
                            });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error_code: 0,
                    status: 502,
                    message: "Something went wrong with connection!"
                });
                objv.execute();
            }
        });
    }
    getId() {
        return [2, 2, 2, 6].reduce((prev, len) => prev + '-' + crypto.randomBytes(len).toString('hex'), crypto.randomBytes(4).toString('hex'));
    }
    sendTFSMS(req, res, sessData, DIDData, callback) {
        let uuid = this.getId();
        let sdata = req.body;
        let TO = sdata.TO.replace(/\D/g, '').slice(-10);
        let FROM = sdata.FROM.replace(/\D/g, '').slice(-10);
        let iduser = sessData.type == 1 ? sdata.iduser : sessData.iduser;
        let idaccount = sessData.type == 1 ? sdata.idaccount : sessData.idaccount;
        let rate = new APIBase_1.APIBase();
        rate.getTollfreeSMSRate(req, res, sessData.idtariff, "SMS", "toll_free", (err, message_rate) => {
            if (err == 1 && message_rate.length > 0) {
                let msgcount = Math.ceil((sdata.BODY.length) / 159);
                let cost = msgcount * (message_rate[0].MT_rates + DIDData.dLergDt.rates);
                let MT_rates = msgcount * message_rate[0].MT_rates;
                let MT_surcharge = msgcount * DIDData.dLergDt.rates;
                let msg_data = sdata.BODY;
                rate.checkBalance(req, res, idaccount, cost, (errorR, resR) => {
                    if (errorR == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `order_id` FROM `did_buy` WHERE `account_id` = '" + idaccount + "' AND `did`='" + FROM + "'";
                        obj.prepare();
                        obj.execute((errr, ress) => {
                            if (errr == 1 && ress.length > 0) {
                                // subaccountdta
                                var options = {
                                    'method': 'POST',
                                    'url': `${twilio.accounturl}/Accounts/${ress[0].order_id}/Messages.json`,
                                    headers: {
                                        'Content-Type': 'application/x-www-form-urlencoded',
                                    },
                                    auth: {
                                        user: twilio.Username,
                                        pass: twilio.Password
                                    },
                                    form: {
                                        From: '+1' + FROM,
                                        To: '+1' + TO,
                                        Body: sdata.BODY
                                    }
                                };
                                console.log("Twillio Tollfree SMS Request :: ", options);
                                request(options, function (error, response) {
                                    if (!error) {
                                        try {
                                            //if (response && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                            if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                                                let data = JSON.parse(response.body);
                                                console.log("Twillio Tollfree SMS Response :: ", data);
                                                if (data.sid) {
                                                    let logPayload = {
                                                        funDetail: {
                                                            tableName: 'wallet',
                                                            functionName: 'sendTFSMS',
                                                            logName: 'Wallet Update'
                                                        },
                                                        data: {
                                                            balance: '`balance`' + '-' + cost
                                                        },
                                                        connWhere: {
                                                            idaccount: idaccount
                                                        }
                                                    };
                                                    insertdid.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                        if (log_error1 == 1) {
                                                            console.log("Wallet amount successfully deducted for TF SMS Send :: ", cost);
                                                        }
                                                        else {
                                                            console.log("Wallet amount not deducted for TF SMS Send :: ", cost);
                                                        }
                                                    });
                                                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj0.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`is_billable`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`) VALUES('" + data.sid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "',1,'" + idaccount + "','" + iduser + "','toll_free','1','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + (0, markError_1.setToZero)(sessData.idapi) + "','" + MT_surcharge + "','" + (0, markError_1.setToZero)(DIDData.dLergDt.idoperator) + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "',1,NOW(),NOW(),NOW(),NOW())";
                                                    obj0.prepare();
                                                    obj0.execute((error, result) => {
                                                        if (error == 1) {
                                                            console.log("Message Send Successfully!");
                                                            callback(1, { status: 201, message: "SMS Submit Successfully", batch_id: data.sid });
                                                        }
                                                        else {
                                                            console.log("Message Send Successfully But Something Went Wrong With Insertion!");
                                                            callback(1, { status: 401, message: "Something went wrong!", batch_id: data.sid });
                                                        }
                                                    });
                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`status`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + data.sid + "','1','" + data.status + "','" + data.sid + "','" + FROM + "','" + TO + "','" + (0, markError_1.parseBody)(msg_data) + "')";
                                                    obj1.prepare();
                                                    obj1.execute((error, result) => { });
                                                }
                                                else {
                                                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj0.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`type`,`direction`,`did_provider`,`dca`, `cost`, `msg_count`,`npa`,`state`,`ocn`,`lata`,`category`,`mobility`,`idapi`,`MT_surcharge`,`idoperator`,`operator`,`connection_key`,`sms_outbound_key`,`message_accepted_by_signalmash`, `message_delivered_to_operator`, `delivery_receipt_received_by_singnalmash`, `delivery_receipt_delivered`) VALUES('" + uuid + "','" + TO + "','" + MT_rates + "','" + FROM + "','" + (0, markError_1.parseBody)(msg_data) + "',2,'" + idaccount + "','" + iduser + "','toll_free','1','outbound','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "', '" + cost + "', '" + msgcount + "','" + DIDData.dLergDt.npa + "','" + DIDData.dLergDt.state + "','" + DIDData.dLergDt.ocn + "','" + DIDData.dLergDt.lata + "','" + DIDData.dLergDt.category + "','" + DIDData.dLergDt.co_name_spec_c + "','" + (0, markError_1.setToZero)(sessData.idapi) + "','" + MT_surcharge + "','" + (0, markError_1.setToZero)(DIDData.dLergDt.idoperator) + "','" + DIDData.dLergDt.name + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "',NOW(),NOW(),NOW(),NOW())";
                                                    obj0.prepare();
                                                    obj0.execute((error, result) => {
                                                        console.log("Something Went Wrong!");
                                                        callback(0, { status: 402, message: "SMS not Sent!" });
                                                    });
                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = "INSERT INTO `send_tollfreeSMS_response` (`idaccount`,`iduser`,`batch_id`,`type`,`referenceId`,`from`,`to`,`text`) VALUES('" + idaccount + "','" + iduser + "','" + uuid + "','1','" + uuid + "','" + FROM + "','" + TO + "','" + (0, markError_1.parseBody)(msg_data) + "')";
                                                    obj1.prepare();
                                                    obj1.execute((error, result) => { });
                                                }
                                            }
                                            else {
                                                callback(0, { message: "SMS not Sent Successfully!", status: 507 });
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: Twilio->sendTFSMS::", e);
                                            callback(0, { message: "Something Went Wrong with the server!", status: 504 });
                                        }
                                    }
                                    else {
                                        callback(0, { message: "Something went wrong!", status: 502 });
                                    }
                                });
                            }
                            else {
                                callback(0, { message: "Something Went Wrong! Subaccount ID not Found", status: 503 });
                            }
                        });
                    }
                    else {
                        callback(0, { message: "Please add funds to your account or contact support.", status: 503 });
                    }
                });
            }
            else {
                callback(0, { status: 502, message: "MT Rates not Found!" });
            }
        });
    }
}
exports.Twillio = Twillio;
