"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const log_1 = require("./log");
const setting_config_1 = require("../../config/setting.config");
class Database {
    connection;
    log;
    _data;
    user;
    pass;
    hostip;
    dbase;
    dbport;
    _sql;
    _last = -1;
    constructor() {
        this.log = new log_1.Log();
        let db = new setting_config_1.DataBaseConfig();
        this.user = db.USER;
        this.pass = db.PASS;
        this.hostip = db.HOST;
        this.dbase = db.NAME;
        this.dbport = parseInt(db.PORT);
        this._sql = "";
    }
    get data() {
        return this._data;
    }
    set data(val) {
        this._data = val;
    }
    get last() {
        return this._last;
    }
    get sql() {
        return this._sql;
    }
    set sql(val) {
        this._sql = val;
    }
    get username() {
        return this.user;
    }
    set username(val) {
        this.user = val;
    }
    get password() {
        return this.pass;
    }
    set password(val) {
        this.pass = val;
    }
    get host() {
        return this.hostip;
    }
    set host(val) {
        this.hostip = val;
    }
    get port() {
        return this.dbport;
    }
    set port(val) {
        this.dbport = val;
    }
    get database() {
        return this.dbase;
    }
    set database(val) {
        this.dbase = val;
    }
}
exports.Database = Database;
