"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PeerlessAPI = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const markError_1 = require("./markError");
const setting_config_1 = require("../config/setting.config");
var request = require('request');
var convert = require('xml-js');
let insertdid = new APIBase_1.APIBase();
const getPeerlessRecords = new setting_config_1.GetPeerlessDIDRecord();
class PeerlessAPI extends APIBase_1.APIBase {
    // private url: string;
    // private customer: string;
    // private passCode: string;
    // private userId: string;
    soapenv;
    pub;
    key;
    secret;
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        /* Staging Details */
        // this.customer = "TRAYTECKdba";
        // this.passCode = "F6EBSVEJ";
        // this.userId = "jeremy.kelley_stg@iplinktelecom.com";
        this.soapenv = "http://schemas.xmlsoap.org/soap/envelope/";
        this.pub = "http://publicapi.api.s2.peerless.com/";
        // this.url = "https://aniweb02.peerlessnetwork.com:8181/public/APIService?wsdl";
        /* Production Details */
        /*this.customer = "TrayteckLLC";
        this.passCode = "0JURS5TZ";
        this.userId = "api@iplinktelecom.com";

        this.soapenv = "http://schemas.xmlsoap.org/soap/envelope/";
        this.pub = "http://publicapi.api.s2.peerless.com/";
        this.url = "https://animate.peerlessnetwork.com:8181/public/APIService?wsdl"; */
        this.priority = proirity;
        this.key = "";
        this.secret = "";
        this.timekey = timekey,
            this.sessdata = sessdata;
    }
    getNpaNxx(req, res, pLoad, callback) {
        if (this.priority == "100") {
            console.log("Exit from PeerlessAPI");
            callback('', '');
        }
        else {
            let condition = "";
            if (req.query.NPA && (req.query.NXX == '' || req.query.NXX == 'null')) {
                condition = '<npas><npa>' + req.query.NPA + '</npa></npas>';
            }
            else if (req.query.NPA && req.query.NXX) {
                condition = '<npas><npa>' + req.query.NPA + '</npa></npas><nxxs><nxx>' + req.query.NXX + '</nxx></nxxs>';
            }
            const qty = pLoad.searchqty;
            // let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><filters>' + condition + '<quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
            let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + getPeerlessRecords.PeerlessCustomer + '</customer><passCode>' + getPeerlessRecords.PeerlessPassCode + '</passCode><userId>' + getPeerlessRecords.PeerlessUserId + '</userId></authentication><filters>' + condition + '<quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
            let options = {
                'method': 'POST',
                'url': getPeerlessRecords.PeerlessUrl,
                'body': data,
                'headers': {
                    'Content-Type': 'text/xml',
                    'SOAPAction': 'searchNumbers'
                },
            };
            request(options, (error, response, body) => {
                if (!error) {
                    try {
                        if (body) {
                            let tmp = body;
                            var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                            var res1 = result1 !== undefined ? JSON.parse(result1) : '';
                            if (res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]) {
                                let check = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["tnCount"];
                                if (check._text > '0') {
                                    let ddata = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["result"]["tn"];
                                    if (!ddata.length) {
                                        ddata = [ddata];
                                    }
                                    if (ddata !== undefined && ddata.length > 0) {
                                        let str = ddata;
                                        let hsmpData = [];
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`phone_number`, `provider`,`iduser`,`idaccount`, `priorty`,`key`,`type`,`rates`,`billing_frequency`) VALUE ";
                                        str.forEach((ele) => {
                                            let hmp = {
                                                phone_number: ele.number._text,
                                                rate_center: '',
                                                state: '',
                                                supplier_tier: '',
                                                provider: 'Peerless',
                                                rates: pLoad.rate
                                            };
                                            hsmpData.push(hmp);
                                            qrystr += "('" + ele.number._text + "','" + "Peerless" + "','" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '" + (0, markError_1.setToZero)(this.priority) + "','" + this.timekey + "','NN','" + pLoad.rate + "','" + (0, markError_1.setToZero)(pLoad.billingfreq) + "'),";
                                        });
                                        this.saveHmp(this.timekey, 'Peerless', hsmpData);
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        callback('', ddata);
                                    }
                                }
                                else {
                                    callback('', error);
                                }
                            }
                            else {
                                callback('', error);
                            }
                        }
                        else {
                            callback('', error);
                        }
                    }
                    catch (e) {
                        console.log("Error :: Peerless->getNpaNxx::", e);
                        callback('', error);
                    }
                }
                else {
                    callback('', error);
                }
            });
        }
    }
    getByRate(req, res, pLoad, callback) {
        if (this.priority == "100") {
            console.log("Exit from PeerlessAPI");
            callback('', '');
        }
        else {
            const state = req.query.State;
            const rate_center = req.query.RateCenter;
            const qty = pLoad.searchqty;
            // let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><filters><states><state>' + state + '</state></states><rateCenters><rateCenter>' + rate_center + '</rateCenter></rateCenters><quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
            let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + getPeerlessRecords.PeerlessCustomer + '</customer><passCode>' + getPeerlessRecords.PeerlessPassCode + '</passCode><userId>' + getPeerlessRecords.PeerlessUserId + '</userId></authentication><filters><states><state>' + state + '</state></states><rateCenters><rateCenter>' + rate_center + '</rateCenter></rateCenters><quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
            let options = {
                'method': 'POST',
                'url': getPeerlessRecords.PeerlessUrl,
                'body': data,
                'headers': {
                    'Content-Type': 'text/xml',
                    'SOAPAction': 'searchNumbers'
                },
            };
            request(options, (error, response, body) => {
                if (!error) {
                    try {
                        if (body) {
                            let tmp = body;
                            var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                            var res1 = JSON.parse(result1);
                            if (res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]) {
                                var check = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["tnCount"];
                                if (check._text > '0') {
                                    var ddata = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["result"]["tn"];
                                    if (!ddata.length) {
                                        ddata = [ddata];
                                    }
                                    let rateCenter = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["rateCenters"]["rateCenter"]["_text"];
                                    let state = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["states"]["state"]["_text"];
                                    if (ddata !== undefined && ddata.length > 0) {
                                        let str = ddata;
                                        let hsmpData = [];
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`iduser`, `phone_number`, `rate_center`, `state`, `provider`, `idaccount`, `priorty`,`key`,`type`,`rates`,`billing_frequency`) VALUE ";
                                        str.forEach((ele) => {
                                            let hmp = {
                                                phone_number: ele.number,
                                                rate_center: (0, markError_1.parseBody)(rateCenter),
                                                state: (0, markError_1.parseBody)(state),
                                                supplier_tier: '',
                                                provider: 'Peerless',
                                                rates: pLoad.rate
                                            };
                                            hsmpData.push(hmp);
                                            qrystr += "('" + this.sessdata.iduser + "', '" + ele.number._text + "', '" + (0, markError_1.parseBody)(rateCenter) + "','" + (0, markError_1.parseBody)(state) + "', '" + "Peerless" + "', '" + this.sessdata.idaccount + "', '" + (0, markError_1.setToZero)(this.priority) + "','" + this.timekey + "','NN','" + pLoad.rate + "','" + (0, markError_1.setToZero)(pLoad.billingfreq) + "'),";
                                        });
                                        this.saveHmp(this.timekey, 'Peerless', hsmpData);
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        callback('', ddata);
                                    }
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: 502, message: "No DID Found!" });
                                    obj.execute();
                                }
                            }
                            else {
                                callback('', error);
                                console.log({ status: 503, message: "No DID Found from Peerless!" });
                            }
                        }
                        else {
                            callback('', error);
                        }
                    }
                    catch (e) {
                        console.log("Error :: Peerless->getByRate::", e);
                        callback('', error);
                    }
                }
                else {
                    callback('', error);
                }
            });
        }
    }
    getTollFree(req, res, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            const tollfree = req.query.TF_PREFIX;
            const qty = req.query.Qty;
            /** For testing purpose */
            this.getRate(req, res, this.sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                let condition = "";
                condition = '<npas><npa>' + tollfree + '</npa></npas>';
                const qty = req.query.Qty;
                // let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><filters>' + condition + '<quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
                let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:searchNumbers><authentication><customer>' + getPeerlessRecords.PeerlessCustomer + '</customer><passCode>' + getPeerlessRecords.PeerlessPassCode + '</passCode><userId>' + getPeerlessRecords.PeerlessUserId + '</userId></authentication><filters>' + condition + '<quantity>' + qty + '</quantity><consecutive>1</consecutive><vanityDigits>?</vanityDigits><categories><category>1</category><category>2</category></categories><selectedTN><tn>?</tn></selectedTN></filters></pub:searchNumbers></soapenv:Body></soapenv:Envelope>';
                let options = {
                    'method': 'POST',
                    'url': getPeerlessRecords.PeerlessUrl,
                    'body': data,
                    'headers': {
                        'Content-Type': 'text/xml',
                        'SOAPAction': 'searchNumbers'
                    },
                };
                request(options, (error, response, body) => {
                    if (!error) {
                        try {
                            if (body) {
                                let tmp = body;
                                var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                                var res1 = JSON.parse(result1);
                                if (res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]) {
                                    let check = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["tnCount"];
                                    if (check._text > '0') {
                                        let ddata = res1["S:Envelope"]["S:Body"]["ns2:searchNumbersResponse"]["return"]["result"]["tn"];
                                        if (!ddata.length) {
                                            ddata = [ddata];
                                        }
                                        if (ddata !== undefined && ddata.length > 0) {
                                            let str = ddata;
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            let qrystr = "INSERT INTO `did_search` (`phone_number`, `provider`,`iduser`,`idaccount`, `priorty`,`key`,`type`,`rates`) VALUE ";
                                            str.forEach((ele) => {
                                                qrystr += "('" + ele.number._text + "', '" + "Peerless" + "','" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '" + (0, markError_1.setToZero)(this.priority) + "','" + this.timekey + "','TF','" + voice_rate[0].rate + "'),";
                                            });
                                            obj1.nonqrysql = qrystr.slice(0, -1);
                                            obj1.prepare();
                                            obj1.execute((err, data) => {
                                                callback(err, data);
                                            });
                                        }
                                        else {
                                            callback('', ddata);
                                        }
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 502, message: "No DID Found!" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    callback('', error);
                                    console.log({ status: 503, message: "No DID Found from Peerless!" });
                                }
                            }
                            else {
                                callback('', error);
                            }
                        }
                        catch (e) {
                            console.log("Error :: Peerless->getTollFree::", e);
                            callback('', error);
                        }
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 502, message: "No DID Found!" });
                        obj.execute();
                    }
                });
            });
            // let options: any = {
            //     'method': 'POST',
            //     'url': 'https://devapi.coretel.net/cgi-bin/xmlnumberdb.pl',
            //     'body': "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?><RequestType>VanitySearch</RequestType><Purpose>SIP</Purpose><Quantity>" + qty + "</Quantity><Tollfree>" + tollfree + "</Tollfree><BillingAccount>" + this.key + "</BillingAccount><Password>" + this.secret + "</Password></xml>",
            //     rejectUnauthorized: false,
            //     requestCert: true,
            //     agent: false
            // };
            // console.log("Peerless Http::", options)
            // request(options, (error: any, response: any, body: any) => {
            //     console.log("Peerless::\n", body)
            //     if (!error) {
            //         let tmp: string = body;
            //         let valid_xml = tmp.slice(0, -6)
            //         console.log(valid_xml);
            //         var result1 = convert.xml2json(valid_xml, { compact: true, spaces: 4 });
            //         var res1 = JSON.parse(result1);
            //         let ddata = res1.xml.SearchResult;
            //         console.log("Data==>", ddata);
            //         if (ddata !== undefined && ddata.length > 0) {
            //             let str: any = ddata;
            //             let obj1 = new ModelRawNonQuery(req, res);
            //             let qrystr = "INSERT INTO `did_search` (`friendly_name`, `phone_number`, `lata`, `locality`, `rate_center`, `state`, `postal_code`, `capabilities` ,`city`, `provider`, `idaccount`, `priorty`, `type`) VALUE ";
            //             str.forEach((ele: any) => {
            //                 console.log(ele.Number._text);
            //                 qrystr += "('','" + ele.Number._text + "', '', '', '" + ele.RateCenter._text + "', '', '', '', '' ,'" + "coreTel" + "', '" + this.sessdata.idaccount + "', '" + this.priority + "', 'TF'),";
            //             });
            //             obj1.nonqrysql = qrystr.slice(0, -1);
            //             obj1.prepare();
            //             obj1.execute((err, data) => {
            //                 callback(err, data);
            //             });
            //         } else {
            //             callback('', ddata);
            //         }
            //     } else {
            //         callback('', error);
            //     }
            // });
        }
    }
    buyDID(req, res, did_details, other_data, callback) {
        const sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let id_grouporder = other_data.id_grouporder;
        let sub_type = other_data.sub_type;
        let days = other_data.days;
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : '';
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : '';
            // To get the proration status
            /* let objv0 = new ModelRawQuery(req, res);
            // objv0.qrysql = "SELECT t.`proration`,t.`day_num` FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + this.sessdata.iduser + "'";
            objv0.qrysql = "SELECT t.`day_num`, DATE_FORMAT(IF(DATE_ADD(NOW(),INTERVAL t.day_num DAY) >NOW(), DATE_ADD(NOW(),INTERVAL t.day_num DAY),LAST_DAY(NOW())),'%Y-%m-%d %H:%i:%s') AS subscription_end_date FROM `user`u INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE u.iduser= '" + this.sessdata.iduser + "'";
            objv0.prepare();
            objv0.execute((days_err, days) => {
                if (days_err == 1) { */
            // let proration_status = days[0].proration;
            let frates = other_data.fullrates;
            let did_dis_days = days[0].day_num > 0 ? days[0].day_num : 0;
            let prorate = typeof other_data.prorate != 'undefined' && other_data.prorate > 0 ? other_data.prorate : 0;
            // To purchase the toll-free number
            if (did_details[0].type == "TF") {
                // let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:placeTFOrder><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><TFNOrder><orderType>TF</orderType><respOrgId>PNN01</respOrgId><defaultAos>US</defaultAos><defaultDestination>TF_TTTF_02</defaultDestination><defaultPayPhoneBlocking>1</defaultPayPhoneBlocking><tollFreeOrderNumbers><tollFreeOrderNumbers><tn>' + sdata.DID.trim() + '</tn><aos>US</aos><destination>TF_TTTF_02</destination><cnamDelivery>true</cnamDelivery><payPhoneBlocking>true</payPhoneBlocking></tollFreeOrderNumbers></tollFreeOrderNumbers></TFNOrder></pub:placeTFOrder></soapenv:Body></soapenv:Envelope>';
                let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:placeTFOrder><authentication><customer>' + getPeerlessRecords.PeerlessCustomer + '</customer><passCode>' + getPeerlessRecords.PeerlessPassCode + '</passCode><userId>' + getPeerlessRecords.PeerlessUserId + '</userId></authentication><TFNOrder><orderType>TF</orderType><respOrgId>PNN01</respOrgId><defaultAos>US</defaultAos><defaultDestination>TF_TTTF_02</defaultDestination><defaultPayPhoneBlocking>1</defaultPayPhoneBlocking><tollFreeOrderNumbers><tollFreeOrderNumbers><tn>' + sdata.DID.trim() + '</tn><aos>US</aos><destination>TF_TTTF_02</destination><cnamDelivery>true</cnamDelivery><payPhoneBlocking>true</payPhoneBlocking></tollFreeOrderNumbers></tollFreeOrderNumbers></TFNOrder></pub:placeTFOrder></soapenv:Body></soapenv:Envelope>';
                let options = {
                    'method': 'POST',
                    'url': getPeerlessRecords.PeerlessUrl,
                    'headers': {
                        'Content-Type': 'text/xml',
                        'SOAPAction': 'placeTFOrder'
                    },
                    body: data,
                };
                request(options, (error, response, body) => {
                    if (!error) {
                        try {
                            if (body) {
                                let tmp = body;
                                var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                                let res1 = JSON.parse(result1);
                                // If order placed successfully
                                if (typeof res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"] != 'undefined') {
                                    let providerOrderId = typeof res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"]["return"] != 'undefined' && res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"]["return"]["_text"] ? res1["S:Envelope"]["S:Body"]["ns2:placeTFOrderResponse"]["return"]["_text"] : '';
                                    let order = providerOrderId;
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`,`did_sub_type`, `subscription_end_date`,`billing_frequency`,`nextbilling_cycle`) VALUE('" + this.sessdata.idaccount + "', 'completed','" + sdata.DID.trim() + "','Peerless','" + order + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + frates + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + prorate + "','" + did_dis_days + "','" + frates + "','" + sub_type + "','" + days[0].subscription_end_date + "','" + (0, markError_1.setToZero)(other_data.billing_frequency) + "','" + other_data.nextbilling_cycle + "')";
                                    obj.prepare();
                                    obj.execute((err, data) => {
                                        if (err == 1) {
                                            // let objv = new ModelRawNonQuery(req, res);
                                            // objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                            // objv.prepare();
                                            // objv.execute((wallet_error, wallet_success) => {
                                            let logPayload = {
                                                funDetail: {
                                                    tableName: 'wallet',
                                                    functionName: 'buyDID',
                                                    logName: 'Wallet Update'
                                                },
                                                data: {
                                                    balance: '`balance`' + '-' + prorate
                                                },
                                                connWhere: {
                                                    idaccount: this.sessdata.idaccount
                                                }
                                            };
                                            insertdid.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                // To update the wallet transaction log
                                                // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                // iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                // iQry += "`amount`='-" + prorate + "', "
                                                // iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                // iQry += "`status`=1;"
                                                // let objWL = new ModelRawNonQuery(req, res);
                                                // objWL.nonqrysql = iQry
                                                // objWL.prepare()
                                                // objWL.execute((error: any, result: any) => {
                                                // })
                                                let logPayload1 = {
                                                    funDetail: {
                                                        tableName: 'wallet_recharge_log',
                                                        functionName: 'buyDID',
                                                        logName: 'wallet'
                                                    },
                                                    data: {
                                                        idaccount: this.sessdata.idaccount,
                                                        amount: '-' + prorate,
                                                        purpose: 'Wallet amount successfully updated for buy a new DID',
                                                        status: 1,
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                });
                                                // To create the DID log
                                                // let objv1 = new ModelRawNonQuery(req, res);
                                                // objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`,`full_log`) VALUE('" + this.sessdata.idaccount + "', 'completed','" + sdata.DID.trim() + "','Peerless','" + order + "','TF','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + frates + "','" + setToZero(this.sessdata.idapi) + "','" + prorate + "','1','DID Buy','" + res1 + "')";
                                                // objv1.prepare();
                                                // objv1.execute((log_error, did_log) => { });
                                                let logPayload = {
                                                    funDetail: {
                                                        tableName: 'did_log',
                                                        functionName: 'buyDID',
                                                        logName: 'DID'
                                                    },
                                                    data: {
                                                        account_id: this.sessdata.idaccount,
                                                        status: 'completed',
                                                        provider: 'Peerless',
                                                        did: sdata.DID.trim(),
                                                        order_id: order,
                                                        type: 'TF',
                                                        npa: npa,
                                                        nxx: nxx,
                                                        state: state,
                                                        disconnect_did_status: 1,
                                                        iduser: this.sessdata.iduser,
                                                        ratecenter: ratecenter,
                                                        rates: frates,
                                                        idapi: this.sessdata.idapi,
                                                        pro_rates: prorate,
                                                        full_log: res1,
                                                        description: 'DID Buy',
                                                        event_type: 1
                                                    }
                                                };
                                                insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { });
                                                // To delete the DID from cart
                                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                obj5.prepare();
                                                obj5.execute((walletError, wallet) => { });
                                                // To update the process count of group order
                                                let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objk.nonqrysql = "UPDATE `did_group_order` SET `status`='1' WHERE `id_grouporder`=" + id_grouporder + ";";
                                                objk.prepare();
                                                objk.execute((error, result) => {
                                                    console.log("GroupOrder process count::\n", result);
                                                });
                                                // To create the did_order
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`,`error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201', '" + sdata.DID + "', '2', 'TF', '" + frates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                obj.prepare();
                                                obj.execute((did_err, did_data) => {
                                                    // To update the other data on current order
                                                    if (did_err == 1) {
                                                        let id_order = did_data.insertId;
                                                        let orderID = "SORD" + id_order.toString();
                                                        let log_error = "";
                                                        let log_message = "Order successfully created.";
                                                        let log_result = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                        obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                        obj.prepare();
                                                        obj.execute((error, result) => { });
                                                    }
                                                    let objV = new RawView_1.RawView(res);
                                                    objV.prepare({
                                                        error_code: 1,
                                                        status: 201,
                                                        message: "DID buy successfully.",
                                                        result: [
                                                            {
                                                                "did": did
                                                            }
                                                        ]
                                                    });
                                                    objV.execute();
                                                });
                                            });
                                            /* // update end subscription date
                                            let obj0 = new ModelRawQuery(req, res);
                                            obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                            obj0.prepare();
                                            obj0.execute((dids_err, didRes) => {
                                                let dates = didRes[0].subscription_end_date;
                                                let isoDate = new Date(dates);
                                                let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                let obj01 = new ModelRawNonQuery(req, res);
                                                obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                obj01.prepare();
                                                obj01.execute((error, result) => { })
                                            }) */
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            obj.execute();
                                        }
                                    });
                                    /* let dateObj = new Date();
                                    let day = dateObj.getUTCDate();
                                    let nDate: any = new Date()
                                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                    let totalDays = (lDate - day) + 1;
                                    let prorate: any;
                                    if (other_data.proration == "true") {
                                        prorate = ((totalDays * did_details[0].rates) / lDate) + other_data.setup_cost;
                                    }
                                    else {
                                        prorate = (did_details[0].rates) + other_data.setup_cost;
                                    }
                                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0 */
                                }
                                // If order failed
                                else if (typeof res1["S:Envelope"]["S:Body"]["S:Fault"] != 'undefined') {
                                    let Fault = res1["S:Envelope"]["S:Body"]["S:Fault"];
                                    let providerOrderId = '';
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + did + "', '4', 'TF', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                    obj.prepare();
                                    obj.execute((did_err, did_data) => {
                                        // To update the other data on current order
                                        if (did_err == 1) {
                                            let id_order = did_data.insertId;
                                            let orderID = "SORD" + id_order.toString();
                                            let log_error = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_message = (Fault['faultcode'] + ' - ' + Fault['faultstring']).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                            let log_result = "";
                                            obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='501', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                            obj.prepare();
                                            obj.execute((error, result) => { });
                                        }
                                    });
                                    // To update the status of group order
                                    let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";";
                                    objk.prepare();
                                    objk.execute((error, result) => {
                                        console.log("Failed");
                                    });
                                    // let objn = new ModelRawNonQuery(req, res);
                                    // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + res1 + "')"
                                    // objn.prepare();
                                    // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                    //     console.log("DID Buy failed from provider");
                                    // });
                                    let logPayload = {
                                        funDetail: {
                                            tableName: 'did_log',
                                            functionName: 'buyDID',
                                            logName: 'DID'
                                        },
                                        data: {
                                            account_id: this.sessdata.idaccount,
                                            did: sdata.DID.trim(),
                                            full_log: res1,
                                            iduser: this.sessdata.iduser,
                                            event_type: 40,
                                            description: 'DID Buy failed from provider',
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        console.log("DID Buy failed from provider");
                                    });
                                    let objV = new RawView_1.RawView(res);
                                    objV.prepare({
                                        error_code: 0,
                                        status: 502,
                                        message: Fault['faultstring'],
                                        error: Fault['faultcode'] + ' - ' + Fault['faultstring']
                                    });
                                    objV.execute();
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({
                                        error_code: 0,
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    obj.execute();
                                }
                            }
                            else {
                                console.log("Peerless->buyDID");
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 502, message: "Something went wrong with DID buy!" });
                                obj.execute();
                            }
                        }
                        catch (e) {
                            console.log("Error :: Peerless->buyDID::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({
                                error_code: 0,
                                status: 502,
                                message: "Something Went Wrong"
                            });
                            obj.execute();
                        }
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({
                            error_code: 0,
                            status: 404,
                            message: "DID not Available!"
                        });
                        obj.execute();
                    }
                });
            }
            // To purchase the local number
            else {
                let objvv = new RawQuery_1.ModelRawQuery(req, res);
                objvv.qrysql = "SELECT `portoutpin` FROM `account` WHERE idaccount= '" + this.sessdata.idaccount + "'";
                objvv.prepare();
                objvv.execute((portpin_error, portpin) => {
                    if (portpin_error == 1) {
                        let pinportout = portpin[0].portoutpin;
                        // let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:placeOrder><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><order><orderType>NN</orderType><orderNumbers><popin>' + pinportout + '</popin><number><tn>' + sdata.DID.trim() + '</tn><mou>1000</mou><routeLabel>TRAYTECH_03</routeLabel><peerlessMsgProvisioning>?</peerlessMsgProvisioning></number></orderNumbers></order></pub:placeOrder></soapenv:Body></soapenv:Envelope>';
                        let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:placeOrder><authentication><customer>' + getPeerlessRecords.PeerlessCustomer + '</customer><passCode>' + getPeerlessRecords.PeerlessPassCode + '</passCode><userId>' + getPeerlessRecords.PeerlessUserId + '</userId></authentication><order><orderType>NN</orderType><orderNumbers><number><tn>' + sdata.DID.trim() + '</tn><mou>1000</mou><routeLabel>TRAYTECH_03</routeLabel><peerlessMsgProvisioning>?</peerlessMsgProvisioning></number></orderNumbers></order></pub:placeOrder></soapenv:Body></soapenv:Envelope>';
                        let options = {
                            'method': 'POST',
                            'url': getPeerlessRecords.PeerlessUrl,
                            'headers': {
                                'Content-Type': 'text/xml',
                                'SOAPAction': 'placeOrder'
                            },
                            body: data,
                        };
                        request(options, (error, response, body) => {
                            if (!error) {
                                try {
                                    if (body) {
                                        let tmp = body;
                                        var result1 = convert.xml2json(tmp, { compact: true, spaces: 4 });
                                        let res1 = JSON.parse(result1);
                                        // If order placed successfully
                                        if (typeof res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"] != 'undefined') {
                                            let providerOrderId = typeof res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"]["return"] != 'undefined' && res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"]["return"]["_text"] ? res1["S:Envelope"]["S:Body"]["ns2:placeOrderResponse"]["return"]["_text"] : '';
                                            let order = providerOrderId;
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`idapi`,`pro_rates`,`did_disconnect_days`,`nrc_rates`,`portoutpin`, `subscription_end_date`,`billing_frequency`,`nextbilling_cycle`) VALUE('" + this.sessdata.idaccount + "', 'completed','" + sdata.DID.trim() + "','Peerless','" + order + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + frates + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + prorate + "','" + did_dis_days + "','" + frates + "','" + pinportout + "','" + days[0].subscription_end_date + "','" + (0, markError_1.setToZero)(other_data.billing_frequency) + "','" + other_data.nextbilling_cycle + "')";
                                            obj.prepare();
                                            obj.execute((err, data) => {
                                                if (err == 1) {
                                                    // let objv = new ModelRawNonQuery(req, res);
                                                    // objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + prorate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'"
                                                    // objv.prepare();
                                                    // objv.execute((wallet_error, wallet_success) => {
                                                    let logPayload = {
                                                        funDetail: {
                                                            tableName: 'wallet',
                                                            functionName: 'buyDID',
                                                            logName: 'Wallet Update'
                                                        },
                                                        data: {
                                                            balance: '`balance`' + '-' + prorate
                                                        },
                                                        connWhere: {
                                                            idaccount: this.sessdata.idaccount
                                                        }
                                                    };
                                                    insertdid.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                        // To update the wallet transaction log
                                                        // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                        // iQry += "`idaccount`=" + this.sessdata.idaccount + ", "
                                                        // iQry += "`amount`='-" + prorate + "', "
                                                        // iQry += "`purpose`='Wallet amount successfully updated for buy a new DID', "
                                                        // iQry += "`status`=1;"
                                                        // let objWL = new ModelRawNonQuery(req, res);
                                                        // objWL.nonqrysql = iQry
                                                        // objWL.prepare()
                                                        // objWL.execute((error: any, result: any) => {
                                                        // })
                                                        let logPayload1 = {
                                                            funDetail: {
                                                                tableName: 'wallet_recharge_log',
                                                                functionName: 'buyDID',
                                                                logName: 'wallet'
                                                            },
                                                            data: {
                                                                idaccount: this.sessdata.idaccount,
                                                                amount: '-' + prorate,
                                                                purpose: 'Wallet amount successfully updated for buy a new DID',
                                                                status: 1,
                                                            }
                                                        };
                                                        insertdid.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                        });
                                                        // To create the DID log
                                                        // let objv1 = new ModelRawNonQuery(req, res);
                                                        // objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`rates`,`idapi`,`pro_rates`,`event_type`,`description`,`full_log`) VALUE('" + this.sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','Peerless','" + order + "','NN','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + frates + "','" + setToZero(this.sessdata.idapi) + "','" + prorate + "','1','DID Buy','" + res1 + "')";
                                                        // objv1.prepare();
                                                        // objv1.execute((log_error, did_log) => { });
                                                        let logPayload = {
                                                            funDetail: {
                                                                tableName: 'did_log',
                                                                functionName: 'buyDID',
                                                                logName: 'DID'
                                                            },
                                                            data: {
                                                                account_id: this.sessdata.idaccount,
                                                                status: 'completed',
                                                                provider: 'Peerless',
                                                                did: sdata.DID.trim(),
                                                                order_id: order,
                                                                type: 'NN',
                                                                npa: npa,
                                                                nxx: nxx,
                                                                state: state,
                                                                disconnect_did_status: 1,
                                                                iduser: this.sessdata.iduser,
                                                                ratecenter: ratecenter,
                                                                rates: frates,
                                                                idapi: this.sessdata.idapi,
                                                                pro_rates: prorate,
                                                                full_log: res1,
                                                                description: 'DID Buy',
                                                                event_type: 1
                                                            }
                                                        };
                                                        insertdid.insertLog(req, res, logPayload, (log_error, did_log) => { });
                                                        // To delete the DID from cart
                                                        let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj5.nonqrysql = "DELETE FROM `did_cart` WHERE did='" + sdata.DID + "'";
                                                        obj5.prepare();
                                                        obj5.execute((walletError, wallet) => { });
                                                        // To update the process count of group order
                                                        let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objk.nonqrysql = "UPDATE `did_group_order` SET `status`='1' WHERE `id_grouporder`=" + id_grouporder + ";";
                                                        objk.prepare();
                                                        objk.execute((error, result) => {
                                                            console.log("GroupOrder process count::\n", result);
                                                        });
                                                        // To create the did_order
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`,`error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '201','" + sdata.DID + "', '2', 'NN', '" + frates + "', 'Order successfully created.', " + id_grouporder + ", 1)";
                                                        obj.prepare();
                                                        obj.execute((did_err, did_data) => {
                                                            // To update the other data on current order
                                                            if (did_err == 1) {
                                                                let id_order = did_data.insertId;
                                                                let orderID = "SORD" + id_order.toString();
                                                                let log_error = "";
                                                                let log_message = "Order successfully created.";
                                                                let log_result = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                                obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='200', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=0, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                                obj.prepare();
                                                                obj.execute((error, result) => { });
                                                            }
                                                            /* if (sdata.CampaignId) {
                                                                let osr = new OsrApi(this.priority, this.sessdata);
                                                                osr.updateNumber(req, res, data.insertId, (error, responce) => { })
                                                            }
                                                            else { */
                                                            let obj0 = new RawView_1.RawView(res);
                                                            obj0.prepare({
                                                                error_code: 1,
                                                                status: 201,
                                                                message: "DID buy successfully.",
                                                                result: [
                                                                    {
                                                                        "did": did
                                                                    }
                                                                ]
                                                            });
                                                            obj0.execute();
                                                            /* } */
                                                        });
                                                    });
                                                    /* // update end subscription date
                                                    let obj0 = new ModelRawQuery(req, res);
                                                    obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                                    obj0.prepare();
                                                    obj0.execute((dids_err, didRes) => {
                                                        let dates = didRes[0].subscription_end_date;
                                                        let isoDate = new Date(dates);
                                                        let subscriptionEndDate = isoDate.toJSON().slice(0, 19).replace('T', ' ');
                                                        let obj01 = new ModelRawNonQuery(req, res);
                                                        obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + subscriptionEndDate + "' WHERE `iddid`=" + didRes[0].iddid + ";"
                                                        obj01.prepare();
                                                        obj01.execute((error, result) => { })
                                                    }) */
                                                }
                                                else {
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({
                                                        error_code: 0,
                                                        status: 502,
                                                        message: "Something went wrong with connection!"
                                                    });
                                                    obj.execute();
                                                }
                                            });
                                            /* let dateObj = new Date();
                                            let day = dateObj.getUTCDate();
                                            let nDate: any = new Date()
                                            let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                            let totalDays = (lDate - day) + 1;
                                            let prorate: any;
                                            if (other_data.proration == "true") {
                                                prorate = ((totalDays * did_details[0].rates) / lDate) + other_data.setup_cost;
                                            }
                                            else {
                                                prorate = (did_details[0].rates) + other_data.setup_cost;
                                            }
                                            prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0 */
                                        }
                                        // If order failed
                                        else if (typeof res1["S:Envelope"]["S:Body"]["S:Fault"] != 'undefined') {
                                            let Fault = res1["S:Envelope"]["S:Body"]["S:Fault"];
                                            let providerOrderId = '';
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `did_order` (`iduser`, `idaccount`, `status`, `did`, `error_code`, `type`, `cost`, `description`, `id_grouporder`, `is_process`) VALUE('" + this.sessdata.iduser + "', '" + this.sessdata.idaccount + "', '501', '" + did + "', '4', 'TF', '" + frates + "', 'Order creation failed!', " + id_grouporder + ", 1)";
                                            obj.prepare();
                                            obj.execute((did_err, did_data) => {
                                                // To update the other data on current order
                                                if (did_err == 1) {
                                                    let id_order = did_data.insertId;
                                                    let orderID = "SORD" + id_order.toString();
                                                    let log_error = JSON.stringify(res1).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                    let log_message = (Fault['faultcode'] + ' - ' + Fault['faultstring']).replace(/'/g, "\\'").replace(/"/g, '\\"');
                                                    let log_result = "";
                                                    obj.nonqrysql = "UPDATE `did_order` SET `order_no`='" + orderID + "', `log_statusCode`='501', `log_error`='" + log_error + "', `log_message`='" + log_message + "', `log_result`='" + log_result + "', `log_status`=1, `provider`='Peerless', `providerOrderId`='" + providerOrderId + "' WHERE `id_order`=" + id_order + ";";
                                                    obj.prepare();
                                                    obj.execute((error, result) => { });
                                                }
                                            });
                                            // To update the status of group order
                                            let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            objk.nonqrysql = "UPDATE `did_group_order` SET `status`='3' WHERE `id_grouporder`=" + id_grouporder + ";";
                                            objk.prepare();
                                            objk.execute((error, result) => {
                                                console.log("Failed");
                                            });
                                            // let objn = new ModelRawNonQuery(req, res);
                                            // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'40','DID Buy failed from provider','" + sdata.DID.trim() + "','" + res1 + "')"
                                            // objn.prepare();
                                            // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                                            //     console.log("DID Buy failed from provider");
                                            // });
                                            let logPayload = {
                                                funDetail: {
                                                    tableName: 'did_log',
                                                    functionName: 'buyDID',
                                                    logName: 'DID'
                                                },
                                                data: {
                                                    account_id: this.sessdata.idaccount,
                                                    did: sdata.DID.trim(),
                                                    full_log: res1,
                                                    iduser: this.sessdata.iduser,
                                                    event_type: 40,
                                                    description: 'DID Buy failed from provider',
                                                }
                                            };
                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                console.log("DID Buy failed from provider");
                                            });
                                            let objV = new RawView_1.RawView(res);
                                            objV.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: Fault['faultstring'],
                                                error: Fault['faultcode'] + ' - ' + Fault['faultstring']
                                            });
                                            objV.execute();
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something Went Wrong"
                                            });
                                            obj.execute();
                                        }
                                    }
                                    else {
                                        console.log("Peerless->buyDID::");
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 502, message: "Something went wrong with DID buy!" });
                                        obj.execute();
                                    }
                                }
                                catch (e) {
                                    console.log("Error :: Peerless->buyDID::", e);
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({
                                        error_code: 0,
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    obj.execute();
                                }
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({
                                    error_code: 0,
                                    status: 404,
                                    message: "DID not Available!"
                                });
                                obj.execute();
                            }
                        });
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({
                            error_code: 0,
                            status: 502,
                            message: "Portoutpin not found!"
                        });
                        obj.execute();
                    }
                });
            }
            /* }
            else {
                let obj = new RawView(res);
                obj.prepare({
                    error_code: 0,
                    status: 502,
                    message: "Something went wrong with get proration!"
                });
                obj.execute();
            }
        }); */
        });
    }
    disconnectDID(req, res, payload, userPayLoad, callback) {
        const sdata = req.body;
        // let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:disconnectOrder><authentication><customer>' + this.customer + '</customer><passCode>' + this.passCode + '</passCode><userId>' + this.userId + '</userId></authentication><disconnectOrderRequest><pon>?</pon><tns><tn>' + sdata.DID.trim() + '</tn><discoType>1</discoType></tns></disconnectOrderRequest></pub:disconnectOrder></soapenv:Body></soapenv:Envelope>';
        let data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:pub="http://publicapi.api.s2.peerless.com/"><soapenv:Body><pub:disconnectOrder><authentication><customer>' + getPeerlessRecords.PeerlessCustomer + '</customer><passCode>' + getPeerlessRecords.PeerlessPassCode + '</passCode><userId>' + getPeerlessRecords.PeerlessUserId + '</userId></authentication><disconnectOrderRequest><pon>?</pon><tns><tn>' + sdata.DID.trim() + '</tn><discoType>1</discoType></tns></disconnectOrderRequest></pub:disconnectOrder></soapenv:Body></soapenv:Envelope>';
        var options = {
            'method': 'POST',
            'url': getPeerlessRecords.PeerlessUrl,
            'headers': {
                'Content-Type': 'text/xml',
                'SOAPAction': 'disconnectOrder'
            },
            'body': data,
        };
        request(options, (error, response, body) => {
            if (!error) {
                try {
                    if (body) {
                        var result1 = convert.xml2json(body, { compact: true, spaces: 4 });
                        let res1 = JSON.parse(result1);
                        // let data = res1["S:Envelope"]["S:Body"]["ns2:disconnectOrderResponse"]["return"]["_text"];
                        let data = '';
                        if (res1["S:Envelope"]["S:Body"]["ns2:disconnectOrderResponse"]) {
                            data = res1["S:Envelope"]["S:Body"]["ns2:disconnectOrderResponse"]["return"]["_text"];
                        }
                        if (data) {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='3',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `account_id`='" + userPayLoad.idaccount + "'";
                            obj.prepare();
                            obj.execute((error, resp) => {
                                if (error == 1) {
                                    // To  update updated_at date in did log
                                    // let obj = new ModelRawNonQuery(req, res);
                                    //obj.nonqrysql = "UPDATE `did_log` SET `event_type`='5',`description`='DID Disconnect Successfully',`updated_at`=NOW(), `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "' AND `iduser`='" + iduser + "' ORDER BY `iddidlog` DESC LIMIT 1"
                                    // obj.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'41','Requested to Disconnect DID from Peerless','" + sdata.DID.trim() + "','" + res1 + "')"
                                    // obj.prepare();
                                    // obj.execute((errorDiDLg: any, resDiDLg: any) => {
                                    //     console.log("Requested to Disconnect DID from Peerless");
                                    // });
                                    let logPayload = {
                                        funDetail: {
                                            tableName: 'did_log',
                                            functionName: 'disconnectDID',
                                            logName: 'DID'
                                        },
                                        data: {
                                            account_id: userPayLoad.idaccount,
                                            did: sdata.DID.trim(),
                                            full_log: res1,
                                            iduser: userPayLoad.iduser,
                                            event_type: 41,
                                            description: 'Requested to Disconnect DID from Peerless',
                                        }
                                    };
                                    insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                        console.log("Requested to Disconnect DID from Peerless");
                                    });
                                    // To delete the number from Final Step/OSR/Sinch
                                    // Now The final disconnect response will be received by the webhook
                                    let pAyLoad = {
                                        idaccount: userPayLoad.idaccount,
                                        did: sdata.DID.trim()
                                    };
                                    insertdid.deleteSipBcidtData(req, res, pAyLoad, (erroR, resulT) => {
                                        if (erroR == 1) {
                                            console.log("Deleted Successfully");
                                        }
                                        else {
                                            console.log("Deleted Not Successfully", resulT.message);
                                        }
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something Went Wrong" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            // let objn = new ModelRawNonQuery(req, res);
                            // objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`) VALUE('" + userPayLoad.idaccount + "','" + userPayLoad.iduser + "',NOW(),'42','Request Failed to Disconnect DID from Peerless','" + sdata.DID.trim() + "','" + res1 + "')"
                            // objn.prepare();
                            // objn.execute((errorDiDLg: any, resDiDLg: any) => {
                            //     console.log("Request Failed to Disconnect DID from Peerless");
                            // });
                            let logPayload = {
                                funDetail: {
                                    tableName: 'did_log',
                                    functionName: 'disconnectDID',
                                    logName: 'DID'
                                },
                                data: {
                                    account_id: userPayLoad.idaccount,
                                    did: sdata.DID.trim(),
                                    full_log: res1,
                                    iduser: userPayLoad.iduser,
                                    event_type: 42,
                                    description: 'Request Failed to Disconnect DID from Peerless',
                                }
                            };
                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                console.log("Requested to Disconnect DID from Peerless");
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "DID disconnect failed!" });
                            objv.execute();
                        }
                    }
                    else {
                        console.log("Peerless->disconnectDID");
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 402, message: "Something went wrong with disconnect DID!" });
                        objv.execute();
                    }
                }
                catch (e) {
                    console.log("Error :: Peerless->disconnectDID::", e);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 401, message: "DID not Disconnected!!" });
                    objv.execute();
                }
            }
            else {
                console.log("Peerless :::::::::::::::::::");
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 400, error: error, message: "DID not Disconnected!" });
                objv.execute();
            }
        });
    }
}
exports.PeerlessAPI = PeerlessAPI;
