"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Call = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const net_1 = require("net");
const setting_config_1 = require("../config/setting.config");
const RawQuery_1 = require("../lib/model/RawQuery");
const common_lib_1 = require("./common.lib");
const server_1 = require("../server");
const lrnApi_1 = require("./lrnApi");
const APIBase_1 = require("./APIBase");
const vs_server = new setting_config_1.VoiceServer();
const prefix = vs_server.Prefix;
class Call extends APIBase_1.APIBase {
    constructor() {
        super();
    }
    repTest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body;
                let msg = '';
                if (!sdata.FROM && sdata.FROM == null && sdata.FROM == undefined) {
                    msg = "FROM not found!";
                }
                if (!sdata.CALLEE && sdata.CALLEE == null && sdata.CALLEE == undefined) {
                    msg = "CALLEE not found!";
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    sdata.FROM = sdata.FROM.replace(/\D/g, '');
                    sdata.CALLEE = sdata.CALLEE.replace(/\D/g, '');
                    let ratenserv = new APIBase_1.APIBase();
                    ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                        if (errorR == 1) {
                            ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                if (resp.status == 200) {
                                    if (sdata.FROM.length == 10) {
                                        if (sdata.CALLER == '' || sdata.CALLER == 'undefined' || sdata.CALLER == null) {
                                            sdata.CALLER = sdata.FROM;
                                        }
                                        sdata.TO = sdata.CALLEE;
                                        let vrate;
                                        if (server_1.voicerates.has(sessdata.authkey)) {
                                            let tmp = server_1.voicerates.get(sessdata.authkey);
                                            if (tmp !== undefined) {
                                                vrate = tmp;
                                            }
                                            else {
                                                vrate = new common_lib_1.VoiceRates();
                                                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                    server_1.voicerates.set(sessdata.authkey, vrate);
                                                });
                                            }
                                        }
                                        else {
                                            vrate = new common_lib_1.VoiceRates();
                                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                server_1.voicerates.set(sessdata.authkey, vrate);
                                            });
                                        }
                                        if (vrate.count() > 0) {
                                            let PayLoad = {
                                                TO: sdata.TO
                                            };
                                            let lerg = new lrnApi_1.LergApi("", "");
                                            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                                let baseapi = new APIBase_1.APIBase();
                                                baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                    if (lerg_info.length > 0) {
                                                        baseapi.DialCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                                            if (call_result != undefined) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare(call_result);
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare(call_err);
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare("Lerg Info Not Found");
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare("Data Not Found");
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: err,
                                        status: resp.status,
                                        message: resp.message.replace(/::SN::/g, "Call")
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    MakeOutboundCallToNumber(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body;
                let msg = '';
                if (!sdata.FROM && sdata.FROM == null && sdata.FROM == undefined) {
                    msg = "FROM not found!";
                }
                if (!sdata.CALLEE && sdata.CALLEE == null && sdata.CALLEE == undefined) {
                    msg = "CALLEE not found!";
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    sdata.FROM = sdata.FROM.replace(/\D/g, '');
                    sdata.CALLEE = sdata.CALLEE.replace(/\D/g, '');
                    if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                        let ratenserv = new APIBase_1.APIBase();
                        ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                            if (errorR == 1) {
                                ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                    if (resp.status == 200) {
                                        if (sdata.FROM.length == 10) {
                                            if (sdata.CALLER == '' || sdata.CALLER == 'undefined' || sdata.CALLER == null) {
                                                sdata.CALLER = sdata.FROM;
                                            }
                                            sdata.TO = sdata.CALLEE;
                                            let vrate;
                                            if (server_1.voicerates.has(sessdata.authkey)) {
                                                let tmp = server_1.voicerates.get(sessdata.authkey);
                                                if (tmp !== undefined) {
                                                    vrate = tmp;
                                                }
                                                else {
                                                    vrate = new common_lib_1.VoiceRates();
                                                    vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                        server_1.voicerates.set(sessdata.authkey, vrate);
                                                    });
                                                }
                                            }
                                            else {
                                                vrate = new common_lib_1.VoiceRates();
                                                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                    server_1.voicerates.set(sessdata.authkey, vrate);
                                                });
                                            }
                                            if (vrate.count() > 0) {
                                                let PayLoad = {
                                                    TO: sdata.TO
                                                };
                                                let lerg = new lrnApi_1.LergApi("", "");
                                                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                    let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                                    let baseapi = new APIBase_1.APIBase();
                                                    baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                        if (lerg_info.length > 0) {
                                                            baseapi.DialCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                                                if (call_result != undefined) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_result);
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_err);
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare("Lerg Info Not Found");
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare("Data Not Found");
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: err,
                                            status: resp.status,
                                            message: resp.message.replace(/::SN::/g, "Call")
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare({ status: 404, message: "Not Permitted" });
                        objvs.execute();
                    }
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    MakeCall(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body;
                let msg = '';
                if (!sdata.FROM && sdata.FROM == null && sdata.FROM == undefined) {
                    msg = "FROM not found!";
                }
                if (!sdata.TO && sdata.TO == null && sdata.TO == undefined) {
                    msg = "TO not found!";
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    sdata.FROM = sdata.FROM.replace(/\D/g, '');
                    sdata.TO = sdata.TO.replace(/\D/g, '');
                    if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                        let ratenserv = new APIBase_1.APIBase();
                        ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                            if (errorR == 1) {
                                ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                    if (resp.status == 200) {
                                        let vrate;
                                        if (sdata.FROM.length == 10 && sdata.TO.length == 10) {
                                            if (server_1.voicerates.has(sessdata.authkey)) {
                                                let tmp = server_1.voicerates.get(sessdata.authkey);
                                                if (tmp != undefined) {
                                                    vrate = tmp;
                                                }
                                                else {
                                                    vrate = new common_lib_1.VoiceRates();
                                                    vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                        server_1.voicerates.set(sessdata.authkey, vrate);
                                                    });
                                                }
                                            }
                                            else {
                                                vrate = new common_lib_1.VoiceRates();
                                                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                    server_1.voicerates.set(sessdata.authkey, vrate);
                                                });
                                            }
                                            if (vrate.count() > 0) {
                                                let lergLogin = new lrnApi_1.LergApi("", "");
                                                let PayLoad = {
                                                    TO: sdata.TO
                                                };
                                                let lerg = new lrnApi_1.LergApi("", "");
                                                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                    let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                                    let baseapi = new APIBase_1.APIBase();
                                                    baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                        if (lerg_info.length > 0) {
                                                            baseapi.makeCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                                                if (call_result != undefined) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_result);
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_err);
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare("Lerg Info Not Found");
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare("Data Not Found");
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: err,
                                            status: resp.status,
                                            message: resp.message.replace(/::SN::/g, "Make Call")
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare({ status: 404, message: "Not Permitted" });
                        objvs.execute();
                    }
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    MakeCallviaMedia(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body;
                let msg = '';
                if (!sdata.FROM && sdata.FROM == null && sdata.FROM == undefined) {
                    msg = "FROM not found!";
                }
                if (!sdata.TO && sdata.TO == null && sdata.TO == undefined) {
                    msg = "TO not found!";
                }
                if (!sdata.mediaID && sdata.mediaID == null && sdata.mediaID == undefined) {
                    msg = "mediaID not found!";
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    sdata.FROM = sdata.FROM.replace(/\D/g, '');
                    sdata.TO = sdata.TO.replace(/\D/g, '');
                    let ratenserv = new APIBase_1.APIBase();
                    ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                        if (errorR == 1) {
                            ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                if (resp.status == 200) {
                                    if (sdata.FROM.length == 10 && sdata.TO.length == 10) {
                                        let vrate;
                                        if (server_1.voicerates.has(sessdata.authkey)) {
                                            let tmp = server_1.voicerates.get(sessdata.authkey);
                                            if (tmp != undefined) {
                                                vrate = tmp;
                                            }
                                            else {
                                                vrate = new common_lib_1.VoiceRates();
                                                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                    server_1.voicerates.set(sessdata.authkey, vrate);
                                                });
                                            }
                                        }
                                        else {
                                            vrate = new common_lib_1.VoiceRates();
                                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                server_1.voicerates.set(sessdata.authkey, vrate);
                                            });
                                        }
                                        if (vrate.count() > 0) {
                                            let lergLogin = new lrnApi_1.LergApi("", "");
                                            let PayLoad = {
                                                TO: sdata.TO
                                            };
                                            let lerg = new lrnApi_1.LergApi("", "");
                                            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                                let baseapi = new APIBase_1.APIBase();
                                                baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                    if (lerg_info.length > 0) {
                                                        baseapi.makeCallviaMedia(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                                            if (call_result != undefined) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare(call_result);
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare(call_err);
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare("Lerg Info Not Found");
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare("Data Not Found");
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Invalid Number. Please enter 10 digit number" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: err,
                                        status: resp.status,
                                        message: resp.message.replace(/::SN::/g, "Make Call Via Media")
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    sendDtmf(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let digit;
                    digit = req.body.TONE;
                    let client = new net_1.Socket();
                    client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
                        console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                        client.write('auth ' + vs_server.PASS + '\n\n');
                        console.log("Password : " + vs_server.PASS);
                        client.write('api uuid_send_dtmf ' + req.body.UUID + " " + digit + '\n\n');
                        client.on("data", (respon) => {
                            let tmp = respon.toString().split("\n");
                            tmp.forEach((elem) => {
                                if (elem != undefined) {
                                    if (elem.length > 0) {
                                        console.log(elem);
                                        let t1 = elem.split("OK");
                                        if (t1.length == 2) {
                                            console.log(t1);
                                            if (t1[0] == "+") {
                                                res.status(200).send(t1[1].trim());
                                                client.end();
                                            }
                                        }
                                    }
                                }
                            });
                        });
                        client.on("error", (e) => {
                            console.log(e);
                        });
                        client.on("end", () => {
                        });
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    recvDtmf(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let digit;
                    digit = req.body.TONE;
                    let client = new net_1.Socket();
                    client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
                        console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                        client.write('auth ' + vs_server.PASS + '\n\n');
                        console.log("Password : " + vs_server.PASS);
                        client.write('api uuid_recv_dtmf ' + req.body.UUID + " " + digit + '\n\n');
                        client.on("data", (respon) => {
                            let tmp = respon.toString().split("\n");
                            tmp.forEach((elem) => {
                                if (elem != undefined) {
                                    if (elem.length > 0) {
                                        console.log(elem);
                                        let t1 = elem.split("OK");
                                        if (t1.length == 2) {
                                            console.log(t1);
                                            if (t1[0] == "+") {
                                                res.status(200).send(t1[1].trim());
                                                client.destroy();
                                            }
                                        }
                                    }
                                }
                            });
                        });
                        client.on("error", (e) => {
                            console.log(e);
                        });
                        client.on("end", () => {
                        });
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    ThreeWayCall(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let sdata = req.body;
                    let msg = '';
                    if (!sdata.Number && sdata.Number == null && sdata.Number == undefined) {
                        msg = "Number not found!";
                    }
                    if (msg) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 404, message: msg });
                        objv.execute();
                        return;
                    }
                    else {
                        sdata.Number = sdata.Number.replace(/\D/g, '');
                        let ratenserv = new APIBase_1.APIBase();
                        ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                            if (errorR == 1) {
                                ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                    if (resp.status == 200) {
                                        if (sdata.Number.length == 10) {
                                            let vrate;
                                            if (server_1.voicerates.has(sessdata.authkey)) {
                                                let tmp = server_1.voicerates.get(sessdata.authkey);
                                                if (tmp !== undefined) {
                                                    vrate = tmp;
                                                }
                                                else {
                                                    vrate = new common_lib_1.VoiceRates();
                                                    vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                        server_1.voicerates.set(sessdata.authkey, vrate);
                                                        //let objv = new Res406(res);
                                                        //objv.prepare({ status: 401, message: "Unauthorized User" });
                                                        //objv.execute();
                                                    });
                                                }
                                            }
                                            else {
                                                vrate = new common_lib_1.VoiceRates();
                                                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                    server_1.voicerates.set(sessdata.authkey, vrate);
                                                    //let objv = new Res406(res);
                                                    //objv.prepare({ status: 401, message: "Unauthorized User" });
                                                    //objv.execute();
                                                });
                                            }
                                            if (vrate.count() > 0) {
                                                let rate = vrate.getCallRate(req.body.Number);
                                                let PayLoad = {
                                                    TO: sdata.Number
                                                };
                                                let lerg = new lrnApi_1.LergApi("", "");
                                                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                    let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                                    let baseapi = new APIBase_1.APIBase();
                                                    baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                        if (lerg_info.length > 0) {
                                                            baseapi.ThreeWayCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                                                if (call_result != undefined) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_result);
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_err);
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare("Lerg Info Not Found");
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare("Data Not Found");
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: err,
                                            status: resp.status,
                                            message: resp.message.replace(/::SN::/g, "Call")
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                                objv.execute();
                            }
                        });
                    }
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    Hangup(req, res, next) {
        console.log("Req==>" + JSON.stringify(req.body));
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let socketData = req.body.UUID;
                    let client = new net_1.Socket();
                    let state = "";
                    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                        console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                        client.write('auth ' + vs_server.PASS + '\n\n');
                        console.log("Password : " + vs_server.PASS);
                        console.log(socketData);
                        client.write('api uuid_kill ' + socketData + '\n\n');
                        res.status(200).send();
                        client.on("data", (respon) => {
                            console.log(respon.toString());
                            let tmp = respon.toString().split("\n");
                            tmp.forEach((elem) => {
                                if (elem != undefined) {
                                    if (elem.length > 0) {
                                        console.log(elem);
                                        let t1 = elem.split("OK");
                                        if (t1.length == 2) {
                                            console.log(t1);
                                            if (t1[0] == "+") {
                                                state = "Hangup Channel";
                                                client.end();
                                            }
                                        }
                                    }
                                }
                            });
                        });
                        client.on("error", (e) => {
                            console.log(e);
                        });
                        client.on("end", () => {
                            console.log(state);
                            if (state.length > 0) {
                                let tmp = state;
                                state = "";
                                res.status(200).send(tmp);
                            }
                        });
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    Barge(req, res, next) {
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let msg = '';
                    if (!sdata.Number && sdata.Number == null && sdata.Number == undefined) {
                        msg = "Number not found!";
                    }
                    if (msg) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 404, message: msg });
                        objv.execute();
                        return;
                    }
                    else {
                        sdata.Number = sdata.Number.replace(/\D/g, '');
                        let ratenserv = new APIBase_1.APIBase();
                        ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                            if (errorR == 1) {
                                ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                    if (resp.status == 200) {
                                        let vrate;
                                        console.log(sessdata);
                                        if (sdata.Number.length == 10) {
                                            if (server_1.voicerates.has(sessdata.authkey)) {
                                                let tmp = server_1.voicerates.get(sessdata.authkey);
                                                if (tmp !== undefined) {
                                                    vrate = tmp;
                                                }
                                                else {
                                                    vrate = new common_lib_1.VoiceRates();
                                                    vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                        server_1.voicerates.set(sessdata.authkey, vrate);
                                                    });
                                                }
                                            }
                                            else {
                                                vrate = new common_lib_1.VoiceRates();
                                                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                    server_1.voicerates.set(sessdata.authkey, vrate);
                                                });
                                            }
                                            if (vrate.count() > 0) {
                                                let PayLoad = {
                                                    TO: sdata.Number
                                                };
                                                let lerg = new lrnApi_1.LergApi("", "");
                                                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                    let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                                    let baseapi = new APIBase_1.APIBase();
                                                    baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                        if (lerg_info.length > 0) {
                                                            baseapi.Barge(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                                                if (call_result != undefined) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_result);
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(call_err);
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare("Lerg Info Not Found");
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare("Data Not Found");
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: err,
                                            status: resp.status,
                                            message: resp.message.replace(/::SN::/g, "Call")
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                                objv.execute();
                            }
                        });
                    }
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    Hold(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let socketData = req.body.UUID;
                    let cmd = "";
                    if (req.body.Type == "Start") {
                        cmd = "api uuid_hold " + socketData;
                    }
                    else if (req.body.Type == "Stop") {
                        cmd = "api uuid_hold off " + socketData;
                    }
                    else {
                        cmd = "api uuid_hold toggle " + socketData;
                    }
                    console.log("cmd==>" + cmd);
                    let client = new net_1.Socket();
                    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                        console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                        client.write('auth ' + vs_server.PASS + '\n\n');
                        console.log("Password : " + vs_server.PASS);
                        client.write(cmd + '\n\n');
                        client.on("data", (respon) => {
                            let tmp = respon.toString().split("\n");
                            tmp.forEach((elem) => {
                                if (elem != undefined) {
                                    if (elem.length > 0) {
                                        console.log(elem);
                                        let t1 = elem.split("OK");
                                        if (t1.length == 2) {
                                            console.log(t1);
                                            if (t1[0] == "+") {
                                                res.status(200).send(t1[1].trim());
                                                client.destroy();
                                            }
                                        }
                                    }
                                }
                            });
                        });
                        client.on("error", (e) => {
                            console.log(e);
                        });
                        client.on("end", () => {
                        });
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    Recording(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let ratenserv = new APIBase_1.APIBase();
                    ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                        if (errorR == 1) {
                            ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                if (resp.status == 200) {
                                    let vrate;
                                    console.log(sessdata);
                                    if (server_1.voicerates.has(sessdata.authkey)) {
                                        console.log("hii");
                                        let tmp = server_1.voicerates.get(sessdata.authkey);
                                        if (tmp !== undefined) {
                                            vrate = tmp;
                                        }
                                        else {
                                            vrate = new common_lib_1.VoiceRates();
                                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                server_1.voicerates.set(sessdata.authkey, vrate);
                                            });
                                        }
                                    }
                                    else {
                                        vrate = new common_lib_1.VoiceRates();
                                        vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                            server_1.voicerates.set(sessdata.authkey, vrate);
                                        });
                                    }
                                    let cmd = "";
                                    console.log("vrate", vrate);
                                    let rate = vrate.RecordRate("true");
                                    console.log("Rate", rate);
                                    if (req.body.Recording == "Start") {
                                        cmd = "api uuid_record " + req.body.UUID + " start /usr/local/freeswitch/recording/" + req.body.UUID;
                                    }
                                    else {
                                        cmd = "api uuid_record " + req.body.UUID + " stop /usr/local/freeswitch/recording/" + req.body.UUID;
                                    }
                                    console.log("Req==>" + cmd);
                                    let client = new net_1.Socket();
                                    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                                        console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                                        client.write('auth ' + vs_server.PASS + '\n\n');
                                        client.write(cmd + '\n\n');
                                        client.on("data", (respon) => {
                                            let tmp = respon.toString().split("\n");
                                            tmp.forEach((elem) => {
                                                if (elem != undefined) {
                                                    if (elem.length > 0) {
                                                        console.log("Ele", elem);
                                                        let t1 = elem.split("OK");
                                                        if (t1.length == 2) {
                                                            console.log("T1", t1);
                                                            if (t1[0] == "+") {
                                                                console.log("api uuid_setvar " + req.body.UUID + " rec_rate " + rate + '\n\n');
                                                                client.write("api uuid_setvar " + req.body.UUID + " rec_rate " + rate + '\n\n');
                                                                res.status(200).send(t1[1].trim());
                                                                client.destroy();
                                                            }
                                                        }
                                                    }
                                                }
                                            });
                                        });
                                        client.on("error", (e) => {
                                            console.log(e);
                                        });
                                        client.on("end", () => {
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: err,
                                        status: resp.status,
                                        message: resp.message.replace(/::SN::/g, "Recording")
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    CallTransfer(req, res, next) {
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let ratenserv = new APIBase_1.APIBase();
                    ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                        if (errorR == 1) {
                            ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                                if (resp.status == 200) {
                                    let vrate;
                                    if (sdata.Number.length == 10) {
                                        if (server_1.voicerates.has(sessdata.authkey)) {
                                            let tmp = server_1.voicerates.get(sessdata.authkey);
                                            if (tmp !== undefined) {
                                                vrate = tmp;
                                            }
                                            else {
                                                vrate = new common_lib_1.VoiceRates();
                                                vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                    server_1.voicerates.set(sessdata.authkey, vrate);
                                                    // let objv = new Res406(res);
                                                    // objv.prepare({ status: 401, message: "Unauthorized User" });
                                                    // objv.execute();
                                                });
                                            }
                                        }
                                        else {
                                            vrate = new common_lib_1.VoiceRates();
                                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                                                server_1.voicerates.set(sessdata.authkey, vrate);
                                                // let objv = new Res406(res);
                                                // objv.prepare({ status: 401, message: "Unauthorized User" });
                                                // objv.execute();
                                            });
                                        }
                                        if (vrate.count() > 0) {
                                            let rate = vrate.getCallRate(req.body.Number);
                                            let PayLoad = {
                                                TO: sdata.Number
                                            };
                                            let lerg = new lrnApi_1.LergApi("", "");
                                            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                                let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                                let baseapi = new APIBase_1.APIBase();
                                                baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                    if (lerg_info.length > 0) {
                                                        baseapi.CallTransfer(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                                            if (call_result != undefined) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare(call_result);
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare(call_err);
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare("Lerg Info Not Found");
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare("Data Not Found");
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error_code: err,
                                        status: resp.status,
                                        message: resp.message.replace(/::SN::/g, "CallTransfer")
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    // public blindTransfer(req: Request, res: Response, next: NextFunction) {
    //   let session = new SessionManagment(req, res, next);
    //   session.GetSession((error: any, sessdata: any) => {
    //     if (error == 1) {
    //       let client = new Socket();
    //       client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
    //         client.write('auth ' + vs_server.PASS + '\n\n');
    //         console.log("api uuid_transfer " + req.body.UUID.trim() + " -bleg 88791" + req.body.NUMBER.trim() + " XML default \n\n");
    //         client.write("api uuid_transfer " + req.body.UUID.trim() + " -bleg 88791" + req.body.NUMBER.trim() + " XML default \n\n");
    //         client.on("data", (respon) => {
    //           let tmp = respon.toString().split("\n");
    //           tmp.forEach((elem: any) => {
    //             if (elem != undefined) {
    //               if (elem.length > 0) {
    //                 console.log(elem);
    //                 let t1 = elem.split("OK");
    //                 if (t1.length == 2) {
    //                   console.log(t1);
    //                   if (t1[0] == "+") {
    //                     res.status(200).send({ message: "Call Connected Successfully", uuid: t1[1].trim() });
    //                     client.destroy();
    //                   }
    //                 }
    //               }
    //             }
    //           });
    //         });
    //         client.on("error", (e) => {
    //           console.log(e);
    //         })
    //         client.on("end", () => {
    //         })
    //       });
    //     } else {
    //       let objv = new Res406(res);
    //       objv.prepare({ status: 401, message: "Unauthorized User" });
    //       objv.execute();
    //     }
    //   });
    // }
    getChannelList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT *  FROM `channels` WHERE `accountcode`='" + sessdata.idaccount + "'";
                    obj.prepare();
                    obj.execute((err, resp) => {
                        if (resp.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Channels List", data: resp });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare("Data Not Found");
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ status: 404, message: "Not Permitted" });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
}
exports.Call = Call;
