"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StripeApi = void 0;
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _404_1 = require("../lib/view/404");
const stripepay = require("stripe");
// import { AppRoute } from "../lib/AppRoute";
const markError_1 = require("./markError");
/* import { sessiondata } from "../server"; */
const setting_config_1 = require("../config/setting.config");
const APIBase_1 = require("./APIBase");
const SubscriptionManagement_1 = require("./SubscriptionManagement");
let rate = new APIBase_1.APIBase();
const kycpdf = new setting_config_1.KYCPDF();
// var nodemailer = require("nodemailer");
const FromSmtpMail = new setting_config_1.SMTPDetails();
const FromEmail = FromSmtpMail.from;
const secret_key = "sk_test_51HAL9TGdXmhCeqBzWbxBTiVUDlCqizGP8NWwxDC8zIRKuef4i9kerhyixCqVZPw5Ik3fmfUe7BR2Wy2cUqrOZdWx00IQ2MEmbO";
//const secret_key = "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";
class StripeApi {
    constructor() {
        // super();
    }
    RechargeByAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body;
                    let CRate = typeof sdata.amount != 'undefined' && sdata.amount > 0 ? sdata.amount : 0;
                    if (CRate > 0) {
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount`=" + sdata.idaccount;
                        obj2.prepare();
                        obj2.execute((_error, customer) => {
                            if (_error == 1) {
                                if (customer.length > 0) {
                                    // let obj = new ModelRawNonQuery(req, res);
                                    let Camount;
                                    if (sdata.paymentType == "3") {
                                        Camount = '-' + CRate;
                                    }
                                    else {
                                        Camount = '+' + CRate;
                                    }
                                    // if (sdata.paymentType == "3") {
                                    //     obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                    // } else {
                                    //     obj.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                    // }
                                    let logPayload = {
                                        funDetail: {
                                            tableName: 'wallet',
                                            functionName: 'RechargeByAdmin',
                                            logName: 'Wallet Update'
                                        },
                                        data: {
                                            balance: '`balance`' + Camount
                                        },
                                        connWhere: {
                                            idaccount: sdata.idaccount
                                        }
                                    };
                                    rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                        // obj.prepare();
                                        // obj.execute((werror: any, _result: any) => {
                                        if (log_error1 == 1) {
                                            // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                            // iQry += "`idaccount`=" + sdata.idaccount + ", "
                                            // if (sdata.paymentType == "3") {
                                            //     iQry += "`amount`='-" + CRate + "', "
                                            // }
                                            // else {
                                            //     iQry += "`amount`='+" + CRate + "', "
                                            // }
                                            // iQry += "`purpose`='Wallet successfully recharged by Admin', "
                                            // iQry += "`description`='" + parseBody(sdata.description.trim()) + "', "
                                            // iQry += "`payment_type`='" + sdata.paymentType + "', "
                                            // iQry += "`status`=1;"
                                            let pType = "Direct";
                                            if (sdata.paymentType == 1) {
                                                pType = "Portal Payment";
                                            }
                                            else if (sdata.paymentType == 2) {
                                                pType = "Manual Credit";
                                            }
                                            else if (sdata.paymentType == 3) {
                                                pType = "Manual Debit";
                                            }
                                            else if (sdata.paymentType == 4) {
                                                pType = "Bank Payment";
                                            }
                                            else if (sdata.paymentType == 5) {
                                                pType = "Credit Card Payment by Admin";
                                            }
                                            // let objWL = new ModelRawNonQuery(req, res);
                                            // objWL.nonqrysql = iQry
                                            // objWL.prepare()
                                            // objWL.execute((error: any, result: any) => {
                                            //     console.log("Transaction response::", result)
                                            // })
                                            let logPayload1 = {
                                                funDetail: {
                                                    tableName: 'wallet_recharge_log',
                                                    functionName: 'RechargeByAdmin',
                                                    logName: 'wallet'
                                                },
                                                data: {
                                                    idaccount: sdata.idaccount,
                                                    amount: Camount,
                                                    purpose: 'Wallet successfully recharged by Admin',
                                                    description: sdata.description.trim(),
                                                    status: 1,
                                                }
                                            };
                                            rate.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                console.log("Transaction response::", did_log);
                                            });
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `amount`, `created`, `description`, `type`,`status`,`is_status`) VALUE('" + sdata.idaccount + "', '" + (0, markError_1.parseBody)(sdata.email) + "', '" + sdata.amount + "', '" + sdata.currentDateTime + "', '" + (0, markError_1.parseBody)(sdata.description.trim()) + "', '" + pType + "','succeeded','1')";
                                            obj1.prepare();
                                            obj1.execute((__error, result) => {
                                                if (__error == 1) {
                                                    let objv1 = new RawView_1.RawView(res);
                                                    let message;
                                                    if (sdata.paymentType == 3) {
                                                        message = "Balance Deducted Successfully!";
                                                    }
                                                    else {
                                                        message = "Balance Credit Successfully!";
                                                    }
                                                    objv1.prepare({ data: result, message: message, status: 201 });
                                                    objv1.execute();
                                                }
                                                else {
                                                    let objv1 = new RawView_1.RawView(res);
                                                    objv1.prepare({ message: "Balance Added Error With Log!", status: 502, error: result });
                                                    objv1.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv1 = new RawView_1.RawView(res);
                                            objv1.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: did_log1 });
                                            objv1.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv1 = new RawView_1.RawView(res);
                                    objv1.prepare({ message: "Customer Detail Not Found!", error: customer, status: 502 });
                                    objv1.execute();
                                }
                            }
                            else {
                                let objv1 = new RawView_1.RawView(res);
                                objv1.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv1.execute();
                            }
                        });
                    }
                    else {
                        let objv1 = new RawView_1.RawView(res);
                        objv1.prepare({
                            message: "Balance amount should be greater then 0!",
                            status: 502,
                            error: ""
                        });
                        objv1.execute();
                    }
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Auth Key!", status: 401 });
                objv.execute();
            }
        });
    }
    getBalance(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idwallet`,`balance`,`min_balance`,`topup_amount`,`webhook_url`,`credit_limit`,`status`,`isEmail`,`isWebhook` FROM `wallet` WHERE idaccount=" + sessdata.idaccount;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    getcustBalance(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `balance` FROM `wallet` WHERE idaccount=" + sdata.idaccount;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    addBalance(req, res, next) {
        let spdata = JSON.parse(req.body.data);
        let stipedata = spdata.pdata;
        let stripeToken = spdata.token;
        const stripe = stripepay(secret_key);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((__error, sessdata) => {
            if (__error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `trust_score` From `user` WHERE `idaccount` = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        stripe.customers.create({
                            email: stripeToken.email,
                            source: stripeToken.id,
                            name: stipedata.first_name + " " + stipedata.last_name,
                            phone: stipedata.contact,
                            metadata: {
                                name: stipedata.first_name + " " + stipedata.last_name,
                                contact: stipedata.contact,
                                city: stipedata.city,
                                san: Math.floor(Math.floor(100000000) + Math.floor(sessdata.idaccount)),
                                email: stipedata.email,
                            },
                            shipping: {
                                name: stipedata.first_name + " " + stipedata.last_name,
                                phone: stipedata.contact,
                                address: {
                                    line1: stipedata.address1,
                                    city: stipedata.city,
                                    country: stipedata.country,
                                    state: stipedata.state,
                                    postal_code: stipedata.postal_code
                                }
                            },
                            address: {
                                line1: stipedata.address1,
                                city: stipedata.city,
                                country: stipedata.country,
                                state: stipedata.state,
                                postal_code: stipedata.postal_code
                            }
                        }, (err, customer) => {
                            if (err) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
                                objv.execute();
                            }
                            else {
                                stripe.charges.create({
                                    customer: customer.id,
                                    amount: stipedata.amount * 100,
                                    currency: 'USD',
                                    description: 'Live Mode',
                                    metadata: {
                                        email: stipedata.email,
                                        san: Math.floor(Math.floor(100000000) + Math.floor(sessdata.idaccount)),
                                        trust_score: result[0].trust_score
                                    },
                                    shipping: {
                                        name: stipedata.first_name + " " + stipedata.last_name,
                                        phone: stipedata.contact,
                                        address: {
                                            line1: stipedata.address1,
                                            city: stipedata.city,
                                            country: stipedata.country,
                                            state: stipedata.state,
                                            postal_code: stipedata.postal_code
                                        }
                                    }
                                }, (err, charge) => {
                                    if (err) {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + (0, markError_1.parseBody)(stipedata.email) + "','', '', '', '" + stipedata.amount + "', NOW(), 'failed','" + (0, markError_1.parseBody)(err.raw.message) + "','Credit Card Payment','0')";
                                        obj.prepare();
                                        obj.execute((serror, result) => {
                                            console.log("Payment failed");
                                        });
                                        /* let obj12 = new ModelRawQuery(req, res);
                                        obj12.qrysql = "SELECT `subject`,`template`, `cc`, `bcc` FROM `email_template` WHERE `type`='recharge_failed'";
                                        obj12.prepare();
                                        obj12.execute((serror: any, result: any) => {
                                            if(serror==1 && result.length>0){
                                                let tmpbody = result[0].template;
                                                tmpbody = tmpbody.replace(/{FIRST_NAME}/g, stipedata.first_name);
                                                tmpbody = tmpbody.replace(/{LAST_NAME}/g, stipedata.last_name);
                                                tmpbody = tmpbody.replace(/{TOPUP_AMOUNT}/g, stipedata.amount);
                                                
                                                let obj21 = new ModelRawNonQuery(req, res);
                                                obj21.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES(" + sessdata.iduser + "," + sessdata.idaccount + ",'donotreply@signalmash.com','" + stipedata.email + "', '" + parseBody(result[0].subject) + "','Signalmash Payment Failure', '" + parseBody(tmpbody) + "','Signalmash Payment Failure','23','" + result[0].cc + "','" + result[0].bcc + "')";
                                                obj21.prepare();
                                                obj21.execute((serror: any, result: any) => {
                                                    console.log("Payment failed");
                                                });
                                            }
                                        }); */
                                        let st = new StripeApi();
                                        st.sendAddBalanceMail(req, res, 'Failed', stipedata.amount, sessdata, stipedata, (error, resp) => {
                                            console.log('Send Failed Email on Customer Email Id');
                                        });
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Wrong Billing Information!", status: 404 });
                                        objv.execute();
                                    }
                                    else {
                                        let obj10 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj10.qrysql = "SELECT `customer_id` FROM `wallet` WHERE idaccount='" + sessdata.idaccount + "'";
                                        obj10.prepare();
                                        obj10.execute((__werror, __wresult) => {
                                            if (__werror == 1) {
                                                if (__wresult.length > 0) {
                                                    if (__wresult[0].customer_id) {
                                                        const amount = stipedata.amount;
                                                        let CAmount = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0;
                                                        // let obj1 = new ModelRawNonQuery(req, res);
                                                        // obj1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + CAmount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                        // obj1.prepare();
                                                        // obj1.execute((__error: any, __result: any) => {
                                                        //     if (__error == 1) {
                                                        let logPayload = {
                                                            funDetail: {
                                                                tableName: 'wallet',
                                                                functionName: 'addBalance',
                                                                logName: 'Wallet Update'
                                                            },
                                                            data: {
                                                                balance: '`balance`' + '+' + CAmount
                                                            },
                                                            connWhere: {
                                                                idaccount: sessdata.idaccount
                                                            }
                                                        };
                                                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                            if (log_error1 == 1) {
                                                                // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                // iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                // iQry += "`amount`='+" + CAmount + "', "
                                                                // iQry += "`purpose`='Wallet successfully recharged by customer', "
                                                                // iQry += "`status`=1;"
                                                                // let objWL = new ModelRawNonQuery(req, res);
                                                                // objWL.nonqrysql = iQry
                                                                // objWL.prepare()
                                                                // objWL.execute((error: any, result: any) => {
                                                                //     console.log("Transaction response::", result)
                                                                // })
                                                                let logPayload1 = {
                                                                    funDetail: {
                                                                        tableName: 'wallet_recharge_log',
                                                                        functionName: 'addBalance',
                                                                        logName: 'wallet'
                                                                    },
                                                                    data: {
                                                                        idaccount: sessdata.idaccount,
                                                                        amount: '+' + CAmount,
                                                                        purpose: 'Wallet successfully recharged by customer',
                                                                        status: 1,
                                                                    }
                                                                };
                                                                rate.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                                    console.log("Transaction response::", did_log);
                                                                });
                                                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`,`charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + (0, markError_1.parseBody)(stripeToken.email) + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + (0, markError_1.parseBody)(charge.description) + "', 'Credit Card Payment','1')";
                                                                obj2.prepare();
                                                                obj2.execute((eerror, result) => {
                                                                    if (eerror == 1) {
                                                                        let key = stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4;
                                                                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                                        obj3.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `key`= '" + key + "'";
                                                                        obj3.prepare();
                                                                        obj3.execute((____error, stripeCard) => {
                                                                            if (____error == 1) {
                                                                                if (stripeCard.length > 0) {
                                                                                    let objv1 = new RawView_1.RawView(res);
                                                                                    objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                    objv1.execute();
                                                                                }
                                                                                else {
                                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    // obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'false')";
                                                                                    obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(stripeToken.email) + "','" + (0, markError_1.parseBody)(stripeToken.card.name) + "','" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "','" + customer.id + "', '" + stripeToken.id + "', '" + stripeToken.card.id + "','" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "','" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "','" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "','" + stripeToken.client_ip + "','" + stripeToken.created + "', 'false', '" + (0, markError_1.parseBody)(stripeToken.card.address_line1) + "','" + (0, markError_1.parseBody)(stripeToken.card.address_city) + "', '" + (0, markError_1.parseBody)(stripeToken.card.country) + "','" + (0, markError_1.parseBody)(customer.address.state) + "','" + stripeToken.card.address_zip + "','" + (0, markError_1.parseBody)(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + (0, markError_1.parseBody)(customer.metadata.city) + "','" + (0, markError_1.parseBody)(customer.metadata.email) + "','" + customer.metadata.san + "','" + (0, markError_1.parseBody)(customer.shipping.name) + "','" + customer.shipping.phone + "','" + (0, markError_1.parseBody)(customer.shipping.address.line1) + "','" + (0, markError_1.parseBody)(customer.shipping.address.city) + "','" + (0, markError_1.parseBody)(customer.shipping.address.country) + "','" + (0, markError_1.parseBody)(customer.shipping.address.state) + "','" + (0, markError_1.parseBody)(customer.shipping.address.postal_code) + "')";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((wwerror, ___result) => {
                                                                                        if (wwerror == 1) {
                                                                                            let objv1 = new RawView_1.RawView(res);
                                                                                            objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                            objv1.execute();
                                                                                        }
                                                                                        else {
                                                                                            let objv = new RawView_1.RawView(res);
                                                                                            objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                            objv.execute();
                                                                                        }
                                                                                    });
                                                                                }
                                                                            }
                                                                            else {
                                                                                let objv1 = new RawView_1.RawView(res);
                                                                                objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                                objv1.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: did_log1 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        const amount = stipedata.amount;
                                                        let CAmount = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0;
                                                        // let obj1 = new ModelRawNonQuery(req, res);
                                                        // obj1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + CAmount + ", `customer_id`='" + charge.customer + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                        // obj1.prepare();
                                                        // obj1.execute((__error: any, __result: any) => {
                                                        //     if (__error == 1) {
                                                        let logPayload = {
                                                            funDetail: {
                                                                tableName: 'wallet',
                                                                functionName: 'addBalance',
                                                                logName: 'Wallet Update'
                                                            },
                                                            data: {
                                                                balance: '`balance`' + '+' + CAmount,
                                                                customer_id: charge.customer
                                                            },
                                                            connWhere: {
                                                                idaccount: sessdata.idaccount
                                                            }
                                                        };
                                                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                            if (log_error1 == 1) {
                                                                // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                                // iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                                // iQry += "`amount`='+" + CAmount + "', "
                                                                // iQry += "`purpose`='Wallet successfully recharged by customer', "
                                                                // iQry += "`status`=1;"
                                                                // let objWL = new ModelRawNonQuery(req, res);
                                                                // objWL.nonqrysql = iQry
                                                                // objWL.prepare()
                                                                // objWL.execute((error: any, result: any) => {
                                                                //     console.log("Transaction response::", result)
                                                                // })
                                                                let logPayload1 = {
                                                                    funDetail: {
                                                                        tableName: 'wallet_recharge_log',
                                                                        functionName: 'addBalance',
                                                                        logName: 'wallet'
                                                                    },
                                                                    data: {
                                                                        idaccount: sessdata.idaccount,
                                                                        amount: '+' + CAmount,
                                                                        purpose: 'Wallet successfully recharged by customer',
                                                                        status: 1,
                                                                    }
                                                                };
                                                                rate.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                                    console.log("Transaction response::", did_log);
                                                                });
                                                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + (0, markError_1.parseBody)(stripeToken.email) + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + (0, markError_1.parseBody)(charge.description) + "', 'Credit Card Payment','1')";
                                                                obj2.prepare();
                                                                obj2.execute((___error, result) => {
                                                                    if (___error == 1) {
                                                                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                                        obj3.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `key` = '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "'";
                                                                        obj3.prepare();
                                                                        obj3.execute((eerror, stripeCard) => {
                                                                            if (eerror == 1) {
                                                                                if (stripeCard.length > 0) {
                                                                                    let objv1 = new RawView_1.RawView(res);
                                                                                    objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                    objv1.execute();
                                                                                }
                                                                                else {
                                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    //obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'true')";
                                                                                    obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(stripeToken.email) + "','" + (0, markError_1.parseBody)(stripeToken.card.name) + "','" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "','" + customer.id + "', '" + stripeToken.id + "', '" + stripeToken.card.id + "','" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "','" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "','" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "','" + stripeToken.client_ip + "','" + stripeToken.created + "', 'true', '" + (0, markError_1.parseBody)(stripeToken.card.address_line1) + "','" + (0, markError_1.parseBody)(stripeToken.card.address_city) + "', '" + (0, markError_1.parseBody)(stripeToken.card.country) + "','" + (0, markError_1.parseBody)(customer.address.state) + "','" + (0, markError_1.parseBody)(stripeToken.card.address_zip) + "','" + (0, markError_1.parseBody)(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + (0, markError_1.parseBody)(customer.metadata.city) + "','" + (0, markError_1.parseBody)(customer.metadata.email) + "','" + customer.metadata.san + "','" + (0, markError_1.parseBody)(customer.shipping.name) + "','" + customer.shipping.phone + "','" + (0, markError_1.parseBody)(customer.shipping.address.line1) + "','" + (0, markError_1.parseBody)(customer.shipping.address.city) + "','" + (0, markError_1.parseBody)(customer.shipping.address.country) + "','" + (0, markError_1.parseBody)(customer.shipping.address.state) + "','" + (0, markError_1.parseBody)(customer.shipping.address.postal_code) + "')";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((__werror, ___result) => {
                                                                                        if (__werror == 1) {
                                                                                            let objv1 = new RawView_1.RawView(res);
                                                                                            objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                            objv1.execute();
                                                                                        }
                                                                                        else {
                                                                                            let objv = new RawView_1.RawView(res);
                                                                                            objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                            objv.execute();
                                                                                        }
                                                                                    });
                                                                                }
                                                                            }
                                                                            else {
                                                                                let objv1 = new RawView_1.RawView(res);
                                                                                objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                                objv1.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: did_log1 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                }
                                                else {
                                                    const amount = stipedata.amount;
                                                    let CAmount = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0;
                                                    // let obj1 = new ModelRawNonQuery(req, res);
                                                    // obj1.nonqrysql = "INSERT INTO `wallet` (`idaccount`, `balance`, `customer_id`) VALUES('" + sessdata.idaccount + "', '" + CAmount + "', '" + charge.customer + "')";
                                                    // obj1.prepare();
                                                    // obj1.execute((__error: any, __result: any) => {
                                                    //     if (__error == 1) {
                                                    let logPayload = {
                                                        funDetail: {
                                                            tableName: 'wallet',
                                                            functionName: 'addBalance',
                                                            logName: 'Wallet Update'
                                                        },
                                                        data: {
                                                            balance: CAmount,
                                                            idaccount: sessdata.idaccount,
                                                            customer_id: charge.customer
                                                        }
                                                    };
                                                    rate.insertLog(req, res, logPayload, (log_error1, did_log1) => {
                                                        if (log_error1 == 1) {
                                                            // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                                            // iQry += "`idaccount`=" + sessdata.idaccount + ", "
                                                            // iQry += "`amount`='+" + CAmount + "', "
                                                            // iQry += "`purpose`='Wallet successfully recharged by customer', "
                                                            // iQry += "`status`=1;"
                                                            // let objWL = new ModelRawNonQuery(req, res);
                                                            // objWL.nonqrysql = iQry
                                                            // objWL.prepare()
                                                            // objWL.execute((error: any, result: any) => {
                                                            //     console.log("Transaction response::", result)
                                                            // })
                                                            let logPayload1 = {
                                                                funDetail: {
                                                                    tableName: 'wallet_recharge_log',
                                                                    functionName: 'addBalance',
                                                                    logName: 'wallet'
                                                                },
                                                                data: {
                                                                    idaccount: sessdata.idaccount,
                                                                    amount: '+' + CAmount,
                                                                    purpose: 'Wallet successfully recharged by customer',
                                                                    status: 1,
                                                                }
                                                            };
                                                            rate.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                                                console.log("Transaction response::", did_log);
                                                            });
                                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + sessdata.idaccount + "', '" + (0, markError_1.parseBody)(stripeToken.email) + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + (0, markError_1.parseBody)(charge.description) + "', 'Credit Card Payment','1')";
                                                            obj2.prepare();
                                                            obj2.execute((eerror, result) => {
                                                                if (eerror == 1) {
                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    //obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'true')";
                                                                    obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(stripeToken.email) + "','" + (0, markError_1.parseBody)(stripeToken.card.name) + "','" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "','" + customer.id + "', '" + stripeToken.id + "', '" + stripeToken.card.id + "','" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "','" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "','" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "','" + stripeToken.client_ip + "','" + stripeToken.created + "', 'true', '" + (0, markError_1.parseBody)(stripeToken.card.address_line1) + "','" + (0, markError_1.parseBody)(stripeToken.card.address_city) + "', '" + (0, markError_1.parseBody)(stripeToken.card.country) + "','" + (0, markError_1.parseBody)(customer.address.state) + "','" + (0, markError_1.parseBody)(stripeToken.card.address_zip) + "','" + (0, markError_1.parseBody)(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + (0, markError_1.parseBody)(customer.metadata.city) + "','" + (0, markError_1.parseBody)(customer.metadata.email) + "','" + customer.metadata.san + "','" + (0, markError_1.parseBody)(customer.shipping.name) + "','" + customer.shipping.phone + "','" + (0, markError_1.parseBody)(customer.shipping.address.line1) + "','" + (0, markError_1.parseBody)(customer.shipping.address.city) + "','" + (0, markError_1.parseBody)(customer.shipping.address.country) + "','" + (0, markError_1.parseBody)(customer.shipping.address.state) + "','" + (0, markError_1.parseBody)(customer.shipping.address.postal_code) + "')";
                                                                    obj4.prepare();
                                                                    obj4.execute((wwerror, ___result) => {
                                                                        if (wwerror == 1) {
                                                                            let objv1 = new RawView_1.RawView(res);
                                                                            objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                            objv1.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: did_log1 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 404 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong", status: 401 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    /* updateBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                let stipedata = spdata.pdata;
                let st = new StripeApi();
                st.balanceDeduct(req, res, sessdata, stipedata,spdata, (error, resp) => {
                    let objv = new RawView(res);
                    objv.prepare({ message: resp.message, status: resp.status });
                    objv.execute();
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    } */
    updateBalance(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                if (spdata.pdata.type && spdata.pdata.type == 'subscharge' && spdata.pdata.type !== '' && spdata.pdata.type !== undefined) {
                    let stipedata = spdata.pdata;
                    let st = new StripeApi();
                    st.subscriptionBalanceDeduct(req, res, sessdata, stipedata, spdata, (error, resp) => {
                        if (error == 1) {
                            let subscriptionmap = new SubscriptionManagement_1.SubscriptionManagement();
                            subscriptionmap.subscriptionlog(req, res, spdata.lodinfo, sessdata.idaccount, sessdata.iduser, (err) => {
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: resp.message, status: resp.status });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: resp.message, status: resp.status });
                            objv.execute();
                        }
                    });
                }
                else {
                    let stipedata = spdata.pdata;
                    let st = new StripeApi();
                    st.balanceDeduct(req, res, sessdata, stipedata, spdata, (error, resp) => {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: resp.message, status: resp.status });
                        objv.execute();
                    });
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    balanceDeduct(req, res, sessdata, stipedata, sdata, callback) {
        const stripe = stripepay(secret_key);
        const finalAmount = parseFloat(stipedata.amount).toFixed(2);
        let idaccount = sdata.sesidaccount ?? sessdata.idaccount;
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT `trust_score` From `user` WHERE `idaccount` = '" + idaccount + "'";
        obj.prepare();
        obj.execute((_error, result) => {
            if (_error == 1) {
                stripe.charges.create({
                    customer: stipedata.customer_id,
                    amount: finalAmount * 100,
                    currency: 'USD',
                    description: 'Live Mode',
                    metadata: {
                        email: stipedata.email,
                        san: Math.floor(100000000 + idaccount),
                        trust_score: result[0].trust_score
                    },
                    shipping: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    }
                }, (err, charge) => {
                    const amount = charge != null ? charge.amount / 100 : stipedata.amount;
                    if (err) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + idaccount + "', '" + (0, markError_1.parseBody)(stipedata.email) + "','', '', '', '" + amount + "', NOW(), 'failed','" + (0, markError_1.parseBody)(err.raw.message) + "','Credit Card Payment','0')";
                        obj.prepare();
                        obj.execute((serror, result) => {
                            if (serror == 1) {
                                console.log("Successfully Insert Record");
                                callback(0, { message: "Payment Failed", status: 504 });
                            }
                            else {
                                console.log("Something Went Wrong with Email Failed");
                                callback(0, { message: "Something Went Wrong with payment failed", status: 505 });
                            }
                        });
                        let st = new StripeApi();
                        st.sendAddBalanceMail(req, res, 'Failed', amount, sessdata, sdata, (error, resp) => {
                            console.log('Send Failed Email on Customer Email Id');
                        });
                    }
                    else {
                        if (stipedata.generateInvoice !== true || stipedata.generateInvoice == undefined) {
                            // let obj = new ModelRawNonQuery(req, res);
                            // obj.nonqrysql = "UPDATE wallet SET `balance`=`balance`+" + amount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                            // obj.prepare();
                            // obj.execute((_error: any, wallet: any) => {
                            //     if (_error == 1) {
                            let logPayload = {
                                funDetail: {
                                    tableName: 'wallet',
                                    functionName: 'balanceDeduct',
                                    logName: 'Wallet Update'
                                },
                                data: {
                                    balance: '`balance`' + '+' + amount
                                },
                                connWhere: {
                                    idaccount: sessdata.idaccount
                                }
                            };
                            rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                if (log_error1 == 1) {
                                    // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                    // iQry += "`idaccount`=" + idaccount + ", "
                                    // iQry += "`amount`='+" + amount + "', "
                                    // iQry += "`purpose`='Wallet amount successfully updated by customer', "
                                    // iQry += "`status`=1;"
                                    // let objWL = new ModelRawNonQuery(req, res);
                                    // objWL.nonqrysql = iQry
                                    // objWL.prepare()
                                    // objWL.execute((error: any, result: any) => {
                                    //     console.log("Transaction response::", result)
                                    // })
                                    let logPayload1 = {
                                        funDetail: {
                                            tableName: 'wallet_recharge_log',
                                            functionName: 'balanceDeduct',
                                            logName: 'wallet'
                                        },
                                        data: {
                                            idaccount: idaccount,
                                            amount: '+' + amount,
                                            purpose: 'Wallet amount successfully updated by customer',
                                            status: 1,
                                        }
                                    };
                                    rate.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                        console.log("Transaction response::", did_log);
                                    });
                                }
                                else {
                                    let purpose = stipedata.generateInvoice == true ? "Amount not deducted by stripe at closing Invoice" : "Wallet amount successfully not updated by customer";
                                    // let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                                    // iQry += "`idaccount`=" + idaccount + ", "
                                    // iQry += "`amount`='+" + amount + "', "
                                    // iQry += "`purpose`='Wallet amount successfully not updated by customer', "
                                    // iQry += "`status`=2;"
                                    // let objWL = new ModelRawNonQuery(req, res);
                                    // objWL.nonqrysql = iQry
                                    // objWL.prepare()
                                    // objWL.execute((error: any, result: any) => {
                                    //     console.log("Transaction response::", result)
                                    // })
                                    let logPayload1 = {
                                        funDetail: {
                                            tableName: 'wallet_recharge_log',
                                            functionName: 'balanceDeduct',
                                            logName: 'wallet'
                                        },
                                        data: {
                                            idaccount: idaccount,
                                            amount: '+' + amount,
                                            purpose: 'Wallet amount successfully not updated by customer',
                                            status: 2,
                                        }
                                    };
                                    rate.insertLog(req, res, logPayload1, (log_error, did_log) => {
                                        console.log("Transaction response::", did_log);
                                    });
                                }
                            });
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + idaccount + "', '" + (0, markError_1.parseBody)(stipedata.email) + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + (0, markError_1.parseBody)(charge.description) + "', 'Credit Card Payment','1')";
                            obj1.prepare();
                            obj1.execute((serror, result) => {
                                if (serror == 1) {
                                    callback(1, { data: [], message: "Balance Updated Successfully!", status: 201 });
                                }
                                else {
                                    callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 502, err: serror });
                                }
                            });
                            let st = new StripeApi();
                            st.sendAddBalanceMail(req, res, 'Success', amount, sessdata, sdata, (error, resp) => {
                                console.log('Email send function called');
                            });
                        }
                        if (stipedata.generateInvoice == true) {
                            let stripePaymentAmt = stipedata.generateInvoice == true ? stipedata.amount : amount;
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`,`is_status`) VALUE('" + idaccount + "', '" + (0, markError_1.parseBody)(stipedata.email) + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + stripePaymentAmt + "', '" + charge.created + "', '" + charge.status + "','" + (0, markError_1.parseBody)(charge.description) + "', 'Credit Card Payment','1')";
                            obj1.prepare();
                            obj1.execute((serror, result) => {
                                if (serror == 1) {
                                    callback(1, { data: [], message: "Balance Updated Successfully!", status: 201 });
                                }
                                else {
                                    callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 502 });
                                }
                            });
                            let st = new StripeApi();
                            st.sendAddBalanceMail(req, res, 'Success', stripePaymentAmt, sessdata, sdata, (error, resp) => {
                                console.log('Email send function called');
                            });
                        }
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something Went Wrong", status: 401 });
                objv.execute();
            }
        });
    }
    sendAddBalanceMail(req, res, msg, amount, sessdata, sdata, callback) {
        let tempType = msg == 'Success' ? 'livemode_payment' : 'recharge_failed';
        let objem = new RawQuery_1.ModelRawQuery(req, res);
        let idaccount = sdata.sesidaccount ?? sessdata.idaccount;
        let iduser = sdata.sesiduser ?? sessdata.iduser;
        objem.qrysql = "SELECT `subject`, `template`, `cc`, `bcc` FROM `email_template` WHERE `type` = '" + tempType + "'";
        objem.prepare();
        objem.execute((errorem, _resultem) => {
            if (errorem == 1 && _resultem.length > 0) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `firstname` , `lastname`, `email` FROM `user_profile` WHERE `iduser` = '" + iduser + "'";
                obj1.prepare();
                obj1.execute((errorup, _resultup) => {
                    if (errorup == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount` = '" + idaccount + "'";
                        obj.prepare();
                        obj.execute((errorw, wallet) => {
                            if (errorw == 1) {
                                let emailTemplate = _resultem[0].template;
                                emailTemplate = emailTemplate.replace('{FIRST_NAME}', _resultup[0].firstname).replace('{LAST_NAME}', _resultup[0].lastname).replace('{BALANCE}', wallet[0].balance).replace('{TOPUP_AMOUNT}', amount);
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`,`subject`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + iduser + "','" + idaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(_resultup[0].email) + "', '" + (0, markError_1.parseBody)(_resultem[0].subject) + "','" + (0, markError_1.parseBody)(emailTemplate) + "','Balance Added','19','" + _resultem[0].cc + "','" + _resultem[0].bcc + "')";
                                obj1.prepare();
                                obj1.execute((_err, __result) => {
                                    if (_err == 1) {
                                        console.log("Email Send Succesfully!");
                                    }
                                    else {
                                        console.log("Opps Email Not Sent!");
                                    }
                                });
                            }
                            else {
                                console.log('Wallet Balance Not Found at the Time Stripe Payment');
                            }
                        });
                    }
                    else {
                        console.log('Account Profile Not Found at the Time Stripe Payment');
                    }
                });
            }
            else {
                console.log('Live Payment Email Template Not Found at the Time Stripe Payment');
            }
        });
    }
    // updateBalance(req: Request, res: Response, next: NextFunction) {
    //     let spdata = JSON.parse(req.body.data);
    //     let stipedata = spdata.pdata;
    //     const stripe = stripepay(secret_key);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             stripe.charges.create({
    //                 customer: stipedata.customer_id,
    //                 amount: stipedata.amount * 100,
    //                 currency: 'USD',
    //                 description: 'Live Mode',
    //                 shipping: {
    //                     name: stipedata.first_name + " " + stipedata.last_name,
    //                     phone: stipedata.contact,
    //                     address: {
    //                         line1: stipedata.address1,
    //                         city: stipedata.city,
    //                         country: stipedata.country,
    //                         state: stipedata.state,
    //                         postal_code: stipedata.postal_code
    //                     }
    //                 }
    //             }, (err: any, charge: any) => {
    //                 if (err) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
    //                     objv.execute();
    //                 }
    //                 else {
    //                     const amount = charge.amount / 100;
    //                     let obj = new ModelRawNonQuery(req, res);
    //                     obj.nonqrysql = "UPDATE wallet SET `balance`= `balance`+ " + stipedata.amount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
    //                     obj.prepare();
    //                     obj.execute((_error: any, wallet: any) => {
    //                         if (_error == 1) {
    //                             let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
    //                             iQry += "`idaccount`=" + sessdata.idaccount + ", "
    //                             iQry += "`amount`='+" + amount + "', "
    //                             iQry += "`purpose`='Wallet amount successfully updated by customer', "
    //                             iQry += "`status`=1;"
    //                             let objWL = new ModelRawNonQuery(req, res);
    //                             objWL.nonqrysql = iQry
    //                             objWL.prepare()
    //                             objWL.execute((error: any, result: any) => {
    //                                 console.log("Transaction response::", result)
    //                             })
    //                             let obj = new ModelRawNonQuery(req, res);
    //                             obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stipedata.email + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
    //                             obj.prepare();
    //                             obj.execute((serror: any, result: any) => {
    //                                 if (serror == 1) {
    //                                     let obj1 = new ModelRawQuery(req, res);
    //                                     obj1.qrysql = "SELECT `customer_id` FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount;
    //                                     obj1.prepare();
    //                                     obj1.execute((____error: any, _result: any) => {
    //                                         if (____error == 1) {
    //                                             let objv1 = new RawView(res);
    //                                             objv1.prepare({ data: [], message: "Balance Updated Successfully!", status: 201 });
    //                                             objv1.execute();
    //                                         } else {
    //                                             let objv1 = new RawView(res);
    //                                             objv1.prepare({ message: "Balance Updated Error With Connection!", status: 502, error: _result });
    //                                             objv1.execute();
    //                                         }
    //                                     });
    //                                 }
    //                                 else {
    //                                     let objv = new RawView(res);
    //                                     objv.prepare({ message: "Balance Updated Error With Connection!", err: error, status: 502 });
    //                                     objv.execute();
    //                                 }
    //                             });
    //                         }
    //                         else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ message: "Error With Updating Balance!", err: error, status: 502 });
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }
    updatePaymentSetting(req, res, next) {
        let spdata = req.body.data;
        let amount;
        let amounttoupdate;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let stripeApi = new StripeApi();
                stripeApi.getTopupuser(req, res, spdata, (err, result) => {
                    if (result) {
                        amount = (parseFloat(result[0].topup_amount || '0') || 0).toFixed(3);
                    }
                    else {
                        console.log('Unable to update ');
                    }
                    // let obj2 = new ModelRawNonQuery(req, res);
                    let str = '';
                    let parsedTopup = parseFloat(spdata.topup_amount || '0') || 0;
                    amounttoupdate = parsedTopup >= 50 ? parsedTopup.toFixed(3) : 50;
                    const topupAmount = (spdata.IsToggled && spdata.IsToggled == true) ? amount : amounttoupdate;
                    let isAutoTopUP = spdata.isAutoPayment == 1 ? 'true' : 'false';
                    // const topupAmount = (parseFloat(spdata.topup_amount || '0') || 0).toFixed(3);
                    if (spdata.isAutoPayment == 0 || spdata.isAutoPayment == 1) {
                        // obj2.nonqrysql = "UPDATE `wallet` SET `status`='" + spdata.isAutoPayment + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                        // obj2.prepare();
                        // obj2.execute((_error: any, result: any) => {
                        //     if (_error == 1) {
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'updatePaymentSetting',
                                logName: 'Wallet Update'
                            },
                            data: {
                                status: spdata.isAutoPayment
                            },
                            connWhere: {
                                idwallet: spdata.idwallet
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            if (log_error1 == 1) {
                                // let objv = new RawView(res);
                                // objv.prepare({ message: "Setting Changed!", result: did_log1, status: 201 });
                                // objv.execute();
                                let tmp = "{\"amount_Update\": \"" + topupAmount + "\"}";
                                let emType = JSON.parse(tmp);
                                let spdataa = Object.assign(spdata, emType);
                                let st = new StripeApi();
                                st.insertAutoPaymentLog(req, res, next, spdataa);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Setting Changed!", result: did_log1, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else if (spdata.isAutoEmail === "true" || spdata.isAutoEmail === "false") {
                        // obj2.nonqrysql = "UPDATE `wallet` SET `isEmail`='" + spdata.isAutoEmail + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                        // obj2.prepare();
                        // obj2.execute((_error: any, result: any) => {
                        //     if (_error == 1) {
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'updatePaymentSetting',
                                logName: 'Wallet Update'
                            },
                            data: {
                                isEmail: spdata.isAutoEmail
                            },
                            connWhere: {
                                idwallet: spdata.idwallet
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            if (log_error1 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Setting Changed!", result: did_log1, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else if (spdata.isAutowebhook === "true" || spdata.isAutowebhook === "false") {
                        // obj2.nonqrysql = "UPDATE `wallet` SET `isWebhook`='" + spdata.isAutowebhook + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                        // obj2.prepare();
                        // obj2.execute((_error: any, result: any) => {
                        //     if (_error == 1) {
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'updatePaymentSetting',
                                logName: 'Wallet Update'
                            },
                            data: {
                                isWebhook: spdata.isAutowebhook
                            },
                            connWhere: {
                                idwallet: spdata.idwallet
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            if (log_error1 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Setting Changed!", result: did_log1, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else if (spdata.defaultamt || topupAmount || spdata.webhook_url) {
                        const minBalance = (parseFloat(spdata.defaultamt || '0') || 0).toFixed(3);
                        // const topupamount = (parseFloat(spdata.topup_amount || '0') || 0).toFixed(3);
                        // obj2.nonqrysql = "UPDATE `wallet` SET `min_balance`='" + minBalance + "', `topup_amount`='" + topupAmount + "', `webhook_url` = '" + parseBody(spdata.webhook_url) + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                        //  obj2.prepare();
                        // obj2.execute((upError: any, result: any) => {
                        //     if (upError == 1) {
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'updatePaymentSetting',
                                logName: 'Wallet Update'
                            },
                            data: {
                                min_balance: minBalance,
                                topup_amount: topupAmount,
                                webhook_url: spdata.webhook_url
                            },
                            connWhere: {
                                idwallet: spdata.idwallet
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            if (log_error1 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Payment Setting Updated!", result: did_log1, status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _404_1.Res404(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    getTopupuser(req, res, spdata, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `idaccount`,`topup_amount` FROM `wallet` WHERE  `idwallet` = '" + spdata.idwallet + "'";
        obj1.prepare();
        obj1.execute((error, result) => {
            if (error == 1) {
                callback(1, result);
            }
            else {
                callback(0, error);
            }
        });
    }
    insertAutoPaymentLog(req, res, next, spdata) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((serr, sessdata) => {
            if (serr == 1) {
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                const topupAmount = (parseFloat(spdata.amount_Update || '0') || 0).toFixed(3);
                obj3.nonqrysql = "INSERT INTO auto_payment_log (status, topup_balance, user_type, iduser, idaccount) VALUES ('" + (0, markError_1.setToZero)(spdata.isAutoPayment) + "', '" + topupAmount + "', '" + sessdata.type + "', '" + sessdata.iduser + "', '" + sessdata.idaccount + "')";
                obj3.prepare();
                obj3.execute((logError, logRes) => {
                    if (logError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Log Created Successfully!", status: 201 });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something went wrong while inserting log!", status: 502 });
                    }
                });
            }
            else {
                let objv = new _404_1.Res404(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    paymentHistory(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                console.log(sdata);
                let condition = "";
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                    if (sdata.selectedUser || (sdata.toDate && sdata.fromDate) || sdata.payment_Status || (sdata.from_amount && sdata.to_amount) || sdata.cardnumber) {
                        if (sdata.fromDate && sdata.toDate && !(sdata.selectedUser && sdata.from_amount && sdata.to_amount && sdata.payment_Status)) {
                            condition += 's.`timestamp` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
                        }
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                            condition += ' AND s.`idaccount`="' + sessdata.idaccount + '"';
                        }
                        if (sdata.selectedUser && !(sdata.toDate && sdata.fromDate && sdata.payment_Status && sdata.from_amount && sdata.to_amount)) {
                            condition += ' AND s.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        if (sdata.selectedUser && sdata.fromDate && sdata.toDate && sdata.payment_Status && sdata.from_amount && sdata.to_amount) {
                            condition += 's.timestamp BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND s.`idaccount`="' + sdata.selectedUser + '" AND s.`status`="' + sdata.payment_Status + '" AND s.`amount` BETWEEN ' + sdata.from_amount + ' AND ' + sdata.to_amount + '';
                        }
                        if (sdata.payment_Status && !(sdata.selectedUser && sdata.toDate && sdata.fromDate && sdata.from_amount && sdata.to_amount)) {
                            condition += ' AND s.`status`="' + sdata.payment_Status + '"';
                        }
                        if (sdata.from_amount && sdata.to_amount && !(sdata.selectedUser && sdata.payment_Status && sdata.fromDate && sdata.toDate)) {
                            condition += ' AND s.`amount` BETWEEN ' + sdata.from_amount + ' AND ' + sdata.to_amount + '';
                        }
                        if ((sdata.toDate && sdata.fromDate && sdata.from_amount && sdata.to_amount && sdata.payment_Status) && !sdata.selectedUser) {
                            condition += ' AND s.timestamp BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND s.`status`="' + sdata.payment_Status + '" AND s.`amount` BETWEEN ' + sdata.from_amount + ' AND ' + sdata.to_amount + '';
                        }
                        if (sdata.cardnumber && !(sdata.fromDate && sdata.toDate)) {
                            condition += ' AND sc.`last4`="' + sdata.cardnumber + '"';
                        }
                        if (sdata.fromDate && sdata.toDate && sdata.cardnumber) {
                            condition += ' AND sc.`last4`="' + sdata.cardnumber + '" AND s.`timestamp` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" ';
                        }
                        obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type`,sc.last4 ,sc.idstripecard, s.`card_last4`, DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id`, `balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN `stripe_card` sc ON s.customer_id=sc.customer_id  LEFT JOIN user_profile b ON s.idaccount = b.account_id  left JOIN `account` acc ON acc.idaccount=b.account_id WHERE " + condition + " GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                    else {
                        obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , s.`card_last4`, DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  LEFT JOIN `account`acc ON acc.idaccount=b.account_id GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                }
                else {
                    obj2.qrysql = "SELECT acc.san, CONCAT(MAX(b.firstname),' ', MAX(b.lastname)) AS `customer_name`, s.email, `amount`, s.`type`,sc.last4, s.`card_last4`, DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN `stripe_card` sc ON s.customer_id=sc.customer_id LEFT JOIN user_profile b ON s.idaccount = b.account_id LEFT JOIN `account`acc ON acc.idaccount=b.account_id WHERE s.idaccount='" + sessdata.idaccount + "' GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                }
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Payment History Fetched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCards(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((serr, sessdata) => {
            if (serr == 1) {
                let condition = '';
                if (sessdata.type == 1)
                    condition += '';
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232)
                    condition += "WHERE idaccount='" + sessdata.idaccount + "' AND `isdeleted`='0'";
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // obj2.qrysql = "SELECT `idstripecard`,`default`,`customer_id`,`card_brand`,`last4`,`exp_month`,`exp_year`,`card_pdf` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj2.qrysql = "SELECT `idstripecard`,`idaccount`,`default`,`name`,`email`,`con_fullname`,`client_ip`,`customer_id`,`created_at`,`authorize_date`,`deleted_at`,`card_brand`,`last4`,`isdeleted`,`exp_month`,`exp_year`,`card_pdf` FROM `stripe_card`  " + condition + "";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    onBoardstripecards(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((serr, sessdata) => {
            if (serr == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `idstripecard`, `name`, `email`, `last4`,`customer_id`,`con_fullname`, `exp_month`, `exp_year`, `client_ip`, `default`, DATE_FORMAT(`created_at`, '%m-%d-%Y') AS `created_at` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "' ORDER BY `idstripecard` DESC";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Cards Not Found!", data: result, status: 400 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCardForAddBalance(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((serr, sessdata) => {
            if (serr == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "'AND `default`='true'";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        if (result == null || result.length < 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            const stripe = stripepay(secret_key);
                            stripe.paymentMethods.list({
                                customer: result[0].customer_id,
                                type: 'card',
                            }, (_err, success) => {
                                if (!_err) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Card Details Fetched Succesfully!", data: success, status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    createCustomerCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let token = req.body.token;
                const stripe = stripepay(secret_key);
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT last4 as card FROM stripe_card WHERE idaccount = '" + sessdata.idaccount + "' AND isdeleted = 0";
                obj1.prepare();
                obj1.execute((error, result) => {
                    if (error == 1) {
                        const cardcount = result;
                        if (cardcount.length < 5) {
                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT u.iduser, u.idaccount, up.firstname, up.lastname, up.email, up.phone, ba.idbilling_address , ba.address1 , ba.address1 , ba.city , ba.state , ba.postal_code , ba.country FROM `user` AS u LEFT JOIN user_profile AS up ON u.iduser=up.iduser LEFT JOIN billing_address AS ba ON u.idaccount=ba.idaccount WHERE u.iduser='" + sessdata.iduser + "'";
                            obj2.prepare();
                            obj2.execute((_error, result) => {
                                if (_error == 1) {
                                    console.log(result);
                                    let obj10 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj10.qrysql = "SELECT `customer_id` FROM `wallet` WHERE idaccount = '" + sessdata.idaccount + "'";
                                    obj10.prepare();
                                    obj10.execute((_werror, __result) => {
                                        if (_werror == 1) {
                                            let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                            // obj3.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `key` = '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                            /* obj3.qrysql = "SELECT `last4` FROM `stripe_card` WHERE idaccount = '" + sessdata.idaccount + "' AND isdeleted = 0";
                                            obj3.prepare();
                                            obj3.execute((____error: any, stripeCard: any) => {
                                                if (____error == 1) {
                                                    //if (stripeCard.length > 0) {
                                                    const cardExists = stripeCard.some((card: any) => card.last4 === token.card.last4);
                                                    if (cardExists) {
                                                        let objv1 = new RawView(res);
                                                        objv1.prepare({ data: result, message: "This Card Already Exist!", status: 401 });
                                                        objv1.execute();
                                                    }
                                                    else { */
                                            stripe.customers.create({
                                                email: token.email,
                                                name: token.card.name,
                                                source: token.id,
                                                address: {
                                                    line1: token.card.address_line1,
                                                    city: token.card.address_city,
                                                    country: token.card.country,
                                                    state: token.card.address_state,
                                                    postal_code: token.card.address_zip
                                                },
                                                metadata: {
                                                    name: token.card.name,
                                                    contact: result[0].phone,
                                                    city: token.card.address_city,
                                                    email: result[0].email,
                                                    san: Math.floor(Math.floor(100000000) + Math.floor(result[0].idaccount))
                                                },
                                                // metadata: {
                                                //     name: result[0].firstname + " " + result[0].lastname,
                                                //     contact: result[0].phone,
                                                //     city: result[0].city
                                                // },
                                                shipping: {
                                                    name: token.card.name,
                                                    phone: result[0].contact,
                                                    address: {
                                                        line1: token.card.address_line1,
                                                        city: token.card.address_city,
                                                        country: token.card.country,
                                                        state: token.card.address_state,
                                                        postal_code: token.card.address_zip
                                                    }
                                                },
                                                // shipping: {
                                                //     name: result[0].firstname + " " + result[0].lastname,
                                                //     phone: result[0].contact,
                                                //     address: {
                                                //         line1: result[0].address1,
                                                //         city: result[0].city,
                                                //         country: result[0].country,
                                                //         state: result[0].state,
                                                //         postal_code: result[0].postal_code
                                                //     }
                                                // },
                                            }, (err, customer) => {
                                                if (!err) {
                                                    if (__result.length > 0) {
                                                        var defaultCard;
                                                        if (__result[0].customer_id) {
                                                            defaultCard = 'false';
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            //obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "','" + token.email + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                            obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(token.email) + "','" + (0, markError_1.parseBody)(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + (0, markError_1.parseBody)(token.card.address_line1) + "','" + (0, markError_1.parseBody)(token.card.address_city) + "', '" + (0, markError_1.parseBody)(token.card.country) + "','" + (0, markError_1.parseBody)(customer.address.state) + "','" + (0, markError_1.parseBody)(token.card.address_zip) + "','" + (0, markError_1.parseBody)(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + (0, markError_1.parseBody)(customer.metadata.city) + "','" + (0, markError_1.parseBody)(customer.metadata.email) + "','" + customer.metadata.san + "','" + (0, markError_1.parseBody)(customer.shipping.name) + "','" + customer.shipping.phone + "','" + (0, markError_1.parseBody)(customer.shipping.address.line1) + "','" + (0, markError_1.parseBody)(customer.shipping.address.city) + "','" + (0, markError_1.parseBody)(customer.shipping.address.country) + "','" + (0, markError_1.parseBody)(customer.shipping.address.state) + "','" + (0, markError_1.parseBody)(customer.shipping.address.postal_code) + "')";
                                                            obj1.prepare();
                                                            obj1.execute((wwerror, ___result) => {
                                                                if (wwerror == 1) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With Save Stripe Card!", status: 502, data: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            defaultCard = 'true';
                                                            // let obj = new ModelRawNonQuery(req, res);
                                                            // obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + customer.id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                            // obj.prepare();
                                                            // obj.execute((werror: any, _result: any) => {
                                                            //     if (werror == 1) {
                                                            let logPayload = {
                                                                funDetail: {
                                                                    tableName: 'wallet',
                                                                    functionName: 'createCustomerCard',
                                                                    logName: 'Wallet Update'
                                                                },
                                                                data: {
                                                                    customer_id: customer.id
                                                                },
                                                                connWhere: {
                                                                    idaccount: sessdata.idaccount
                                                                }
                                                            };
                                                            rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                                if (log_error1 == 1) {
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    // obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                    obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`) VALUES ('" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(token.email) + "','" + (0, markError_1.parseBody)(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + (0, markError_1.parseBody)(token.card.address_line1) + "','" + (0, markError_1.parseBody)(token.card.address_city) + "', '" + token.card.country + "','" + (0, markError_1.parseBody)(customer.address.state) + "','" + token.card.address_zip + "','" + (0, markError_1.parseBody)(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + customer.metadata.city + "','" + (0, markError_1.parseBody)(customer.metadata.email) + "','" + customer.metadata.san + "','" + (0, markError_1.parseBody)(customer.shipping.name) + "','" + customer.shipping.phone + "','" + (0, markError_1.parseBody)(customer.shipping.address.line1) + "','" + (0, markError_1.parseBody)(customer.shipping.address.city) + "','" + customer.shipping.address.country + "','" + customer.shipping.address.state + "','" + (0, markError_1.parseBody)(customer.shipping.address.postal_code) + "')";
                                                                    obj1.prepare();
                                                                    obj1.execute((wwerror, ___result) => {
                                                                        if (wwerror == 1) {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong With Save Card", status: 502, data: result });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With Update Wallet!", status: 502, data: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                    }
                                                    else {
                                                        let objv1 = new RawView_1.RawView(res);
                                                        objv1.prepare({ data: result, message: "Wallet Not Found For This Account", status: 502 });
                                                        objv1.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Invalid Card Detail!", error: err, status: 502, data: result });
                                                    objv.execute();
                                                }
                                            });
                                            /* }
                                        }
                                        else {
                                            let objv1 = new RawView(res);
                                            objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                            objv1.execute();
                                        }
                                    }); */
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Wallet!", status: 502, data: result });
                                            objv.execute();
                                        }
                                    });
                                    //});
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Please Update Billing Address!", status: 401 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "You Can Add Only 5 Cards!", status: 401 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 401 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    onBoardcreateCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let token = req.body.token;
                const stripe = stripepay(secret_key);
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT u.iduser, u.idaccount, up.firstname, up.lastname, up.email, up.phone, ba.idbilling_address , ba.address1 , ba.address1 , ba.city , ba.state , ba.postal_code , ba.country,ba.contact FROM `user` AS u LEFT JOIN user_profile AS up ON u.iduser=up.iduser LEFT JOIN billing_address AS ba ON u.idaccount=ba.idaccount WHERE u.iduser=" + sessdata.iduser + " AND u.is_deleted=0";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1 && result.length > 0) {
                        let obj10 = new RawQuery_1.ModelRawQuery(req, res);
                        obj10.qrysql = "SELECT `customer_id` FROM `wallet` WHERE idaccount = '" + sessdata.idaccount + "'";
                        obj10.prepare();
                        obj10.execute((_werror, __result) => {
                            if (_werror == 1) {
                                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT `name`,`last4` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "' AND isdeleted ='0'";
                                obj2.prepare();
                                obj2.execute((stripeErr, stripeCards) => {
                                    if (stripeErr == 1) {
                                        if (stripeCards.length >= 5) {
                                            let objv1 = new RawView_1.RawView(res);
                                            objv1.prepare({ message: "Card Limit Exceeded!", status: 502 });
                                            objv1.execute();
                                        }
                                        else {
                                            /* let obj3 = new ModelRawQuery(req, res);
                                            obj3.qrysql = "SELECT `name`,`last4`,`exp_month`,`exp_year`,`client_ip`,`created_at` FROM `stripe_card` WHERE `card_brand` = '" + token.card.brand + "' AND `last4`='" + token.card.last4 + "' AND `idaccount`='" + sessdata.idaccount + "' AND `isdeleted` = '0'";
                                            obj3.prepare();
                                            obj3.execute((____error: any, stripeCard: any) => {
                                                if (____error == 1) {
                                                    if (stripeCard.length > 0) {
                                                        let objv1 = new RawView(res);
                                                        objv1.prepare({ data: result, usedData: stripeCard, message: "This Card Already Exist!", status: 401 });
                                                        objv1.execute();
                                                    }
                                                    else { */
                                            stripe.customers.create({
                                                email: token.email,
                                                name: token.card.name,
                                                source: token.id,
                                                address: {
                                                    line1: token.card.address_line1,
                                                    city: token.card.address_city,
                                                    country: token.card.country,
                                                    state: token.card.address_state,
                                                    postal_code: token.card.address_zip
                                                },
                                                metadata: {
                                                    name: token.card.name,
                                                    contact: result[0].phone,
                                                    city: token.card.address_city,
                                                    email: result[0].email,
                                                    san: Math.floor(Math.floor(100000000) + Math.floor(result[0].idaccount))
                                                },
                                                // metadata: {
                                                //     name: result[0].firstname + " " + result[0].lastname,
                                                //     contact: result[0].phone,
                                                //     city: result[0].city
                                                // },
                                                shipping: {
                                                    name: token.card.name,
                                                    phone: result[0].contact,
                                                    address: {
                                                        line1: token.card.address_line1,
                                                        city: token.card.address_city,
                                                        country: token.card.country,
                                                        state: token.card.address_state,
                                                        postal_code: token.card.address_zip
                                                    }
                                                },
                                                // shipping: {
                                                //     name: result[0].firstname + " " + result[0].lastname,
                                                //     phone: result[0].contact,
                                                //     address: {
                                                //         line1: result[0].address1,
                                                //         city: result[0].city,
                                                //         country: result[0].country,
                                                //         state: result[0].state,
                                                //         postal_code: result[0].postal_code
                                                //     }
                                                // },
                                            }, (err, customer) => {
                                                if (!err) {
                                                    if (__result.length > 0) {
                                                        var defaultCard;
                                                        if (__result[0].customer_id) {
                                                            defaultCard = 'false';
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            //obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "','" + token.email + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                            obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`,`authorize_date`) VALUES ('" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(token.email) + "','" + (0, markError_1.parseBody)(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + (0, markError_1.parseBody)(token.card.address_line1) + "','" + (0, markError_1.parseBody)(token.card.address_city) + "', '" + (0, markError_1.parseBody)(token.card.country) + "','" + (0, markError_1.parseBody)(customer.address.state) + "','" + (0, markError_1.parseBody)(token.card.address_zip) + "','" + (0, markError_1.parseBody)(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + (0, markError_1.parseBody)(customer.metadata.city) + "','" + (0, markError_1.parseBody)(customer.metadata.email) + "','" + customer.metadata.san + "','" + (0, markError_1.parseBody)(customer.shipping.name) + "','" + customer.shipping.phone + "','" + (0, markError_1.parseBody)(customer.shipping.address.line1) + "','" + (0, markError_1.parseBody)(customer.shipping.address.city) + "','" + (0, markError_1.parseBody)(customer.shipping.address.country) + "','" + (0, markError_1.parseBody)(customer.shipping.address.state) + "','" + (0, markError_1.parseBody)(customer.shipping.address.postal_code) + "',NOW())";
                                                            obj1.prepare();
                                                            obj1.execute((wwerror, ___result) => {
                                                                if (wwerror == 1) {
                                                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                                    obj2.qrysql = "SELECT sc.`idstripecard`,sc.`customer_id`,sc.`name`,sc.`email`,sc.`exp_month`,sc.`exp_year`,sc.`key`,sc.`last4` ,sc.`client_ip`,DATE_FORMAT(sc.`created_at`, '%Y-%m-%d') AS created_at,DATE_FORMAT(sc.`authorize_date`, '%Y-%m-%d') AS authorize_date, sc.`con_fullname` FROM `stripe_card` AS sc JOIN `user` ON user.`idaccount`= sc.`idaccount` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                    // obj2.qrysql = "SELECT `idstripecard`,`name`,`email`,`exp_month`,`exp_year`,`key`,`last4` FROM `stripe_card` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                    obj2.prepare();
                                                                    obj2.execute((_error, scRes) => {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result, data1: scRes });
                                                                        objv.execute();
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With Save Stripe Card!", status: 502, data: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            defaultCard = 'true';
                                                            // let obj = new ModelRawNonQuery(req, res);
                                                            // obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + customer.id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                            // obj.prepare();
                                                            // obj.execute((werror: any, _result: any) => {
                                                            //     if (werror == 1) {
                                                            let logPayload = {
                                                                funDetail: {
                                                                    tableName: 'wallet',
                                                                    functionName: 'onBoardcreateCard',
                                                                    logName: 'Wallet Update'
                                                                },
                                                                data: {
                                                                    customer_id: customer.id
                                                                },
                                                                connWhere: {
                                                                    idaccount: sessdata.idaccount
                                                                }
                                                            };
                                                            rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                                if (log_error1 == 1) {
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    //obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                    obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`,`address_line1`,`address_city`,`address_country`,`address_state`,`address_postal_code`,`metadata_name`,`metadata_contact`,`metadata_city`,`metadata_email`,`metadata_san`,`shipping_name`,`shipping_phone`,`shipping_address_line1`,`shipping_address_city`,`shipping_address_country`,`shipping_address_state`,`shipping_address_postal_code`,`authorize_date`) VALUES ('" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(token.email) + "','" + (0, markError_1.parseBody)(token.card.name) + "','" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "','" + customer.id + "', '" + token.id + "', '" + token.card.id + "','" + token.card.brand + "', '" + token.card.last4 + "','" + token.card.cvc_check + "', '" + token.card.exp_month + "','" + token.card.exp_year + "', '" + token.card.funding + "','" + token.client_ip + "','" + token.created + "', '" + defaultCard + "', '" + (0, markError_1.parseBody)(token.card.address_line1) + "','" + (0, markError_1.parseBody)(token.card.address_city) + "', '" + (0, markError_1.parseBody)(token.card.country) + "','" + (0, markError_1.parseBody)(customer.address.state) + "','" + (0, markError_1.parseBody)(token.card.address_zip) + "','" + (0, markError_1.parseBody)(customer.metadata.name) + "', '" + customer.metadata.contact + "','" + (0, markError_1.parseBody)(customer.metadata.city) + "','" + (0, markError_1.parseBody)(customer.metadata.email) + "','" + customer.metadata.san + "','" + (0, markError_1.parseBody)(customer.shipping.name) + "','" + customer.shipping.phone + "','" + (0, markError_1.parseBody)(customer.shipping.address.line1) + "','" + (0, markError_1.parseBody)(customer.shipping.address.city) + "','" + (0, markError_1.parseBody)(customer.shipping.address.country) + "','" + (0, markError_1.parseBody)(customer.shipping.address.state) + "','" + (0, markError_1.parseBody)(customer.shipping.address.postal_code) + "',NOW())";
                                                                    obj1.prepare();
                                                                    obj1.execute((wwwerror, ___result) => {
                                                                        if (wwwerror == 1) {
                                                                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                                            obj2.qrysql = "SELECT sc.`idstripecard`,sc.`customer_id`,sc.`name`,sc.`email`,sc.`exp_month`,sc.`exp_year`,sc.`key`,sc.`last4` ,sc.`client_ip`,DATE_FORMAT(sc.`created_at`, '%Y-%m-%d') AS created_at,DATE_FORMAT(sc.`authorize_date`, '%Y-%m-%d') AS authorize_date, sc.`con_fullname` FROM `stripe_card` AS sc JOIN `user` ON user.`idaccount`= sc.`idaccount` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                            // obj2.qrysql = "SELECT `idstripecard`,`name`,`email`,`exp_month`,`exp_year`,`key`,`last4` FROM `stripe_card` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                            obj2.prepare();
                                                                            obj2.execute((_error, scRes) => {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result, data1: scRes });
                                                                                objv.execute();
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong With Save Card", status: 502, data: result });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With Update Wallet!", status: 502, data: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                    }
                                                    else {
                                                        let objv1 = new RawView_1.RawView(res);
                                                        objv1.prepare({ data: result, message: "Wallet Not Found For This Account", status: 502 });
                                                        objv1.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Invalid Card Detail!", error: err, status: 502, data: result });
                                                    objv.execute();
                                                }
                                            });
                                            /* }
                                        }
                                        else {
                                            let objv1 = new RawView(res);
                                            objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                            objv1.execute();
                                        }
                                    }); */
                                        }
                                    }
                                    else {
                                        let objv1 = new RawView_1.RawView(res);
                                        objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                        objv1.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Wallet!", status: 502, data: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "User not Authorized or Please Update Billing Address!", status: 401 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    setDfaultCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `customer_id`='" + req.body.customer_id + "' AND `idaccount` = '" + sessdata.idaccount + "' AND `card_pdf` IS NOT NULL AND `card_pdf` LIKE '%card_pdf%'";
                obj.prepare();
                obj.execute((errCrd, resultCrd) => {
                    if (errCrd == 1 && resultCrd.length > 0) {
                        // let obj = new ModelRawNonQuery(req, res);
                        // obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + req.body.customer_id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                        // obj.prepare();
                        // obj.execute((_err: any, result: any) => {
                        //     if (_err == 1) {
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'setDfaultCard',
                                logName: 'Wallet Update'
                            },
                            data: {
                                customer_id: req.body.customer_id
                            },
                            connWhere: {
                                idaccount: sessdata.idaccount
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            if (log_error1 == 1) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `stripe_card` SET `default`= 'false' WHERE idaccount='" + sessdata.idaccount + "'";
                                obj1.prepare();
                                obj1.execute((___err, wallet) => {
                                    if (___err == 1) {
                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `stripe_card` SET `default`= 'true' WHERE customer_id='" + req.body.customer_id + "'";
                                        obj2.prepare();
                                        obj2.execute((__err, card) => {
                                            if (__err == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Default Card Changed Successfully!", status: 201, data: card });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: card });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: wallet });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: did_log1 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 503, message: "You have to authorized card before make it default card!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    deleteCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                if (sessdata.type == 2 || sessdata.type == 201) {
                    let obj11 = new RawQuery_1.ModelRawQuery(req, res);
                    obj11.qrysql = "SELECT `default` FROM `stripe_card` WHERE `customer_id`='" + req.query.customer_id + "'";
                    obj11.prepare();
                    obj11.execute((error, resultcard) => {
                        if (error == 1) {
                            if (resultcard && String(resultcard[0].default).toLowerCase() === 'false') {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE stripe_card SET isdeleted = 1, deleted_at = NOW() WHERE `customer_id`='" + req.query.customer_id + "' AND `default`='false'";
                                obj.prepare();
                                obj.execute((err, result) => {
                                    console.log("result::", result);
                                    if (err == 1) {
                                        if (result.affectedRows > 0) {
                                            // let obj1 = new ModelRawNonQuery(req, res);
                                            // obj1.nonqrysql = "UPDATE `wallet` SET `customer_id`=NULL WHERE `customer_id`='" + req.query.customer_id + "'";
                                            // obj1.prepare();
                                            // obj1.execute((_err: any, rescard: any) => {
                                            //     console.log("Card Deleted Successfully!");
                                            // });
                                            let logPayload = {
                                                funDetail: {
                                                    tableName: 'wallet',
                                                    functionName: 'deleteCard',
                                                    logName: 'Wallet Update'
                                                },
                                                data: {
                                                    customer_id: 'NULL'
                                                },
                                                connWhere: {
                                                    customer_id: req.query.customer_id
                                                }
                                            };
                                            rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                                                console.log("Card Deleted Successfully!");
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Default Card cannot be deleted!", status: 501, error: result });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Default Card can not be delete!", status: 400 });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong while fetching default card!", status: 500 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Unavialable", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    deleteOnBoardCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `stripe_card` WHERE `customer_id`='" + req.query.customer_id + "'";
                obj.prepare();
                obj.execute((_err, result) => {
                    if (_err == 1) {
                        // let obj1 = new ModelRawNonQuery(req, res);
                        // obj1.nonqrysql = "UPDATE `wallet` SET `customer_id`=NULL WHERE `customer_id`='" + req.query.customer_id + "'";
                        // obj1.prepare();
                        // obj1.execute((_err: any, rescard: any) => {
                        //     console.log("Card Deleted Successfully!");
                        // });
                        let logPayload = {
                            funDetail: {
                                tableName: 'wallet',
                                functionName: 'deleteOnBoardCard',
                                logName: 'Wallet Update'
                            },
                            data: {
                                customer_id: 'NULL'
                            },
                            connWhere: {
                                customer_id: req.query.customer_id
                            }
                        };
                        rate.insertLog1(req, res, logPayload, (log_error1, did_log1) => {
                            console.log("Card Deleted Successfully!");
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    saveCardForm(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let sdata = JSON.parse(req.body.data);
            let formData = sdata.formData;
            let idcard = sdata.idstripecard;
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `user` SET `isCard`='true' WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error, upRes) => {
                    if (_error == 1) {
                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "UPDATE `stripe_card` SET `con_fullname`='" + (0, markError_1.parseBody)(formData.con_fullname) + "',`authorize_date` = NOW() WHERE `idaccount`='" + sessdata.idaccount + "' AND `idstripecard`='" + idcard + "'";
                        obj0.prepare();
                        obj0.execute((__error, upcardRes) => {
                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj5.nonqrysql = "UPDATE `session` SET `isCard`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                            obj5.prepare();
                            obj5.execute((_err, user) => {
                                if (_err == 1) {
                                    console.log("Session Updated Successfully!");
                                }
                                else {
                                    console.log("Session Not Updated!");
                                }
                                let obj6 = new RawQuery_1.ModelRawQuery(req, res);
                                obj6.qrysql = "SELECT `authkey`,`type`,`iduser`,`username`,`idaccount`,`isEmailVerify`,`isMobileVerify`,`isAddress`,`isPlan`,`isCard`,`newUser_status`,`kyc_verify_status` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                obj6.prepare();
                                obj6.execute((_sessError, sessData) => {
                                    let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj7.qrysql = "SELECT `con_fullname` FROM `stripe_card` WHERE `idstripecard`='" + idcard + "'";
                                    obj7.prepare();
                                    obj7.execute((_error, scRes) => {
                                        if (_sessError == 1) {
                                            let objup7 = new RawQuery_1.ModelRawQuery(req, res);
                                            objup7.qrysql = "SELECT country FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                                            objup7.prepare();
                                            objup7.execute((__errorEE, result7) => {
                                                let country = result7.length > 0 && result7[0].country ? result7[0].country.trim() : '';
                                                let tmpcountry = "{\"country\": \"" + country + "\"}";
                                                let ct = JSON.parse(tmpcountry);
                                                let data1 = Object.assign(sessData[0], ct);
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ session: [data1], data: [data1], result: scRes, iduser: sessdata.iduser, message: "Card Saved Successfully!", status: 201 });
                                                objv.execute();
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                });
                            });
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something went wrong!", status: 501 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    saveCardPdf(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = JSON.parse(req.body.payload);
                let idcard = sdata.idstripecard;
                if (req.file) {
                    let value = '';
                    const fileName = req.file.filename; //filename_pdf
                    value = kycpdf.generateCardPDF + fileName;
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
                    obj.prepare();
                    obj.execute((_error, upRes) => {
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
    // public saveCardPdfOnboarding(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let sdata = JSON.parse(req.body.payload);
    //             let idcard = sdata.idstripecard;
    //             if (req.file) {
    //                 let value: any = '';
    //                 const fileName = req.file.filename; 
    //                 value = kycpdf.generateCardPDF + fileName;
    //                 let obj = new ModelRawNonQuery(req, res);
    //                 obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
    //                 obj.prepare();
    //                 obj.execute((_error, upRes) => {
    //                     if (_error == 1) {
    //                         let obj2 = new ModelRawQuery(req, res);
    //                         obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idstripecard`='" +idcard+ "'";
    //                         obj2.prepare();
    //                         obj2.execute((_error: any, result: any) => {
    //                             if (_error == 1) {
    //                                 if (result.length > 0) {
    //                                     let customerId = result[0].customer_id;
    //                                     let temp2: string = "{\"customer_id\": \"" + customerId + "\"}";
    //                                     let addcustumerid = JSON.parse(temp2);
    //                                     let data1: any = Object.assign(sdata.paymentdata, addcustumerid);
    //                                     if (sdata.paymentdata != null && sdata.paymentdata != "" && sdata.paymentdata != "undefined" && sdata.paymentdata.amount > 0) {
    //                                         let spdata = JSON.parse(req.body.payload);
    //                                         let stipedata = data1;
    //                                         let st = new StripeApi();
    //                                         st.subscriptionBalanceDeduct(req, res, sessData, stipedata, spdata, (error, resp) => {
    //                                             if (error == 1) {
    //                                                 console.log("Subscription Balance Deducted Successfully!");
    //                                             }
    //                                         });
    //                                     }
    //                                 }
    //                             } else {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({ message: "Something went wrong!", status: 501 });
    //                                 objv.execute();
    //                             }
    //                         });
    //                     } else {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
    //                         objv.execute();
    //                     }
    //                 });
    //             }
    //         } else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }
    // public saveCardPdfOnboarding(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((sessErr: any, sessData: any) => {
    //         if (sessErr == 1) {
    //             let sdata = JSON.parse(req.body.payload);
    //             let idcard = sdata.idstripecard;
    //             if (req.file) {
    //                 let value: any = '';
    //                 const fileName = req.file.filename; 
    //                 value = kycpdf.generateCardPDF + fileName;
    //                 let obj = new ModelRawNonQuery(req, res);
    //                 obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
    //                 obj.prepare();
    //                 obj.execute((_error, upRes) => {
    //                     if (_error == 1) {
    //                         let obj2 = new ModelRawQuery(req, res);
    //                         obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idstripecard`='" +idcard+ "'";
    //                         obj2.prepare();
    //                         obj2.execute((_error: any, result: any) => {
    //                             if (_error == 1) {
    //                                 if (result.length > 0) {
    //                                   let rate = new APIBase();
    //                                   rate.subscriptionProrationCalculator(req, res, sessData.idaccount, (pc_err, prorate1) => {
    //                                       if(pc_err==1){
    //                                         let finalamount =prorate1;
    //                                         let temp3: string = "{\"amount\": \"" + finalamount + "\"}";
    //                                         let fianlprratedamount = JSON.parse(temp3);
    //                                         let customerId = result[0].customer_id;
    //                                         let temp2: string = "{\"customer_id\": \"" + customerId + "\"}";
    //                                         let addcustumerid = JSON.parse(temp2);
    //                                         let data1: any = Object.assign(sdata.paymentdata, addcustumerid,fianlprratedamount);
    //                                         if (sdata.paymentdata != null && sdata.paymentdata != "" && sdata.paymentdata != "undefined" && sdata.paymentdata.amount > 0) {
    //                                             let spdata = JSON.parse(req.body.payload);
    //                                             let stipedata = data1;
    //                                             let st = new StripeApi();
    //                                             st.subscriptionBalanceDeduct(req, res, sessData, stipedata, spdata, (error, resp) => {
    //                                                 if (error == 1) {
    //                                                     console.log("Subscription Balance Deducted Successfully!");
    //                                                 }
    //                                             });
    //                                         }
    //                                       }else{
    //                                           let objvs = new RawView(res);
    //                                           objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
    //                                            objvs.execute();
    //                                       }
    //                                   });
    //                                 }
    //                             } else {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({ message: "Something went wrong!", status: 501 });
    //                                 objv.execute();
    //                             }
    //                         });
    //                     } else {
    //                         let objv = new RawView(res);
    //                         objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
    //                         objv.execute();
    //                     }
    //                 });
    //             }
    //         } else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }
    saveCardPdfOnboarding(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let sdata = JSON.parse(req.body.payload);
                let idcard = sdata.idstripecard;
                if (req.file) {
                    let value = '';
                    const fileName = req.file.filename;
                    value = kycpdf.generateCardPDF + fileName;
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `stripe_card` SET `card_pdf`='" + value + "' WHERE `idaccount`='" + sessData.idaccount + "' AND `idstripecard`='" + idcard + "'";
                    obj.prepare();
                    obj.execute((_error, upRes) => {
                        if (_error == 1) {
                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idstripecard`='" + idcard + "'";
                            obj2.prepare();
                            obj2.execute((_error, result) => {
                                if (_error == 1) {
                                    if (result.length > 0) {
                                        if (sdata.mapeddata == true) {
                                            let rate = new APIBase_1.APIBase();
                                            rate.subscriptionProrationCalculator(req, res, sessData.idaccount, (pc_err, prorate1, dataprorate3) => {
                                                if (pc_err == 1) {
                                                    let finalamount = prorate1;
                                                    let temp3 = "{\"amount\": \"" + finalamount + "\"}";
                                                    let fianlprratedamount = JSON.parse(temp3);
                                                    let customerId = result[0].customer_id;
                                                    let temp2 = "{\"customer_id\": \"" + customerId + "\"}";
                                                    let addcustumerid = JSON.parse(temp2);
                                                    let data1 = Object.assign(sdata.paymentdata, addcustumerid, fianlprratedamount);
                                                    if (sdata.paymentdata != null && sdata.paymentdata != "" && sdata.paymentdata != "undefined" && sdata.paymentdata.amount > 0) {
                                                        let spdata = JSON.parse(req.body.payload);
                                                        let stipedata = data1;
                                                        let st = new StripeApi();
                                                        st.subscriptionBalanceDeduct(req, res, sessData, stipedata, spdata, (error, resp) => {
                                                            if (error == 1) {
                                                                let subscriptionmap = new SubscriptionManagement_1.SubscriptionManagement();
                                                                subscriptionmap.subscriptionlog(req, res, dataprorate3, sessData.idaccount, sessData.iduser, (err) => {
                                                                    if (err == 0) {
                                                                        console.log("Something went Wrong");
                                                                    }
                                                                    else {
                                                                        console.log("Subscription Log created successfully");
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                }
                                                else {
                                                    let objvs = new RawView_1.RawView(res);
                                                    objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
                                                    objvs.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let obj21 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj21.nonqrysql = "UPDATE account SET subscription_payment = 1 WHERE idaccount = '" + sessData.idaccount + "'";
                                            obj21.prepare();
                                            obj21.execute((_error, result) => {
                                                if (_error == 1) {
                                                    console.log('subscription payment updated success full');
                                                }
                                                else {
                                                    console.log('subscription payment updated failed');
                                                }
                                            });
                                        }
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong!", status: 501 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
    /**GET Card Pdf For Admin */
    getCardPdfForAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.query;
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount`,`card_pdf` FROM `stripe_card`";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Fetch Successfully", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
    deleteCustomerCard(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    const stripe = stripepay(secret_key);
                    let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                    obj3.qrysql = "SELECT `idaccount`, `name`, `confirm_name`, `con_fullname`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`, `email`, `source`, `address_line1`, `address_city`, `address_country`, `address_state`, `address_postal_code`, `metadata_name`, `metadata_email`, `metadata_contact`, `metadata_city`, `metadata_san`, `shipping_name`, `shipping_phone`, `shipping_address_line1`, `shipping_address_city`, `shipping_address_country`, `card_pdf`, `shipping_address_postal_code`, `shipping_address_state`,`authorize_date` FROM `stripe_card` WHERE customer_id = '" + sdata.id + "' AND idaccount = '" + sdata.idaccount + "'";
                    obj3.prepare();
                    obj3.execute((____error, stripeCard) => {
                        if (stripeCard.length > 0) {
                            stripe.customers.del(stripeCard[0].customer_id, (err, customer) => {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `stripe_archive_card` (`idaccount`, `name`, `confirm_name`, `con_fullname`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`, `email`, `source`, `address_line1`, `address_city`, `address_country`, `address_state`, `address_postal_code`, `metadata_name`, `metadata_email`, `metadata_contact`, `metadata_city`, `metadata_san`, `shipping_name`, `shipping_phone`, `shipping_address_line1`, `shipping_address_city`, `shipping_address_country`, `card_pdf`, `shipping_address_postal_code`, `shipping_address_state`,`authorize_date`) VALUES ('" + stripeCard[0].idaccount + "', '" + (0, markError_1.parseBody)(stripeCard[0].name) + "', '" + (0, markError_1.parseBody)(stripeCard[0].confirm_name) + "', '" + (0, markError_1.parseBody)(stripeCard[0].con_fullname) + "', '" + stripeCard[0].key + "', '" + stripeCard[0].customer_id + "', '" + stripeCard[0].token + "', '" + stripeCard[0].card_id + "', '" + stripeCard[0].card_brand + "', '" + stripeCard[0].last4 + "', '" + stripeCard[0].cvc_check + "', '" + stripeCard[0].exp_month + "', '" + stripeCard[0].exp_year + "', '" + stripeCard[0].funding + "', '" + stripeCard[0].client_ip + "', '" + stripeCard[0].created + "', '" + stripeCard[0].default + "', '" + (0, markError_1.parseBody)(stripeCard[0].email) + "', '" + stripeCard[0].source + "', '" + (0, markError_1.parseBody)(stripeCard[0].address_line1) + "', '" + (0, markError_1.parseBody)(stripeCard[0].address_city) + "', '" + (0, markError_1.parseBody)(stripeCard[0].address_country) + "', '" + (0, markError_1.parseBody)(stripeCard[0].address_state) + "', '" + stripeCard[0].address_postal_code + "', '" + (0, markError_1.parseBody)(stripeCard[0].metadata_name) + "', '" + (0, markError_1.parseBody)(stripeCard[0].metadata_email) + "', '" + stripeCard[0].metadata_contact + "', '" + (0, markError_1.parseBody)(stripeCard[0].metadata_city) + "', '" + stripeCard[0].metadata_san + "', '" + (0, markError_1.parseBody)(stripeCard[0].shipping_name) + "', '" + stripeCard[0].shipping_phone + "', '" + (0, markError_1.parseBody)(stripeCard[0].shipping_address_line1) + "', '" + (0, markError_1.parseBody)(stripeCard[0].shipping_address_city) + "', '" + (0, markError_1.parseBody)(stripeCard[0].shipping_address_country) + "', '" + stripeCard[0].card_pdf + "', '" + stripeCard[0].shipping_address_postal_code + "', '" + (0, markError_1.parseBody)(stripeCard[0].shipping_address_state) + "',NOW())";
                                obj1.prepare();
                                obj1.execute((_err, result) => {
                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "DELETE FROM stripe_card WHERE customer_id = '" + sdata.id + "' AND idaccount = '" + sdata.idaccount + "'";
                                    obj2.prepare();
                                    obj2.execute((_err, result) => {
                                        if (_err == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                                            objv.execute();
                                        }
                                    });
                                });
                            });
                        }
                        else {
                            let objv1 = new RawView_1.RawView(res);
                            objv1.prepare({ message: "There is no Stripe Card!", status: 502 });
                            objv1.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Unavailable", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    CustomercardData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT s.`idaccount`,s.`name`,s.`confirm_name`,s.`con_fullname`,s.`key`,s.`customer_id`,s.`token`,s.`card_id`,s.`created_at`,s.`deleted_at`,s.`card_brand`,s.`last4`,s.`cvc_check`,s.`exp_month`,s.`exp_year`,s.`funding`,s.`client_ip`,s.`created`,s.`default`,s.`email`,s.`source`,s.`address_line1`,s.`address_city`,s.`address_country`,s.`address_state`,s.`address_postal_code`,s.`metadata_name`,s.`metadata_email`,s.`metadata_contact`,s.`metadata_city`,s.`metadata_san`,s.`shipping_name`,s.`shipping_phone`,s.`shipping_address_line1`,s.`shipping_address_city`,s.`shipping_address_country`,s.`card_pdf`,s.`shipping_address_postal_code`,s.`shipping_address_state`,`b`.`address1` AS `address11`,`b`.`address2` AS `address21`,`b`.`city` AS `city1`,`b`.`state` AS `state1`,`b`.`postal_code` AS `postal_code1`,`b`.`country` AS `country1`,`up`.`firstname` AS `first_name1`,`up`.`lastname` AS `last_name1`,`up`.`email` AS `email1` FROM `stripe_card` AS s INNER JOIN `billing_address` AS `b` ON s.`idaccount` = `b`.`idaccount` INNER JOIN `user_profile` AS `up` ON `b`.`idaccount` = `up`.`account_id` WHERE s.`idstripecard` = '" + req.query.type + "' GROUP BY s.`customer_id`";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Card Details Fetch Successfully", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
    CustomerStripecardData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    const stripe = stripepay(secret_key);
                    stripe.customers.retrieve(req.query.type, (err, customer) => {
                        if (!err) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Stripe Data Fetched Successfully!", status: 201, data: customer });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: customer });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Not Available!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
    subscriptionBalanceDeduct(req, res, sessdata, stipedata, sdata, callback) {
        const stripe = stripepay(secret_key);
        const finalAmount = parseFloat(stipedata.amount).toFixed(2);
        let idaccount = sdata.sesidaccount ?? sessdata.idaccount;
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT trust_score FROM user WHERE idaccount = '" + idaccount + "'";
        obj.prepare();
        obj.execute((_error, result) => {
            if (_error === 1) {
                stripe.charges.create({
                    customer: stipedata.customer_id,
                    amount: finalAmount * 100,
                    currency: 'USD',
                    description: 'Subscription Payment',
                    metadata: {
                        email: stipedata.email,
                        san: Math.floor(100000000 + idaccount),
                        trust_score: result[0].trust_score
                    },
                    shipping: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    }
                }, (err, charge) => {
                    const amount = charge ? charge.amount / 100 : stipedata.amount;
                    if (err) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO stripe_payment (idaccount, email, charge_id, customer_id, balance_transaction, amount, created, status, description, type, is_status) VALUES ('" + idaccount + "', '" + (0, markError_1.parseBody)(stipedata.email) + "', '', '', '', '" + amount + "', NOW(), 'failed', '" + (0, markError_1.parseBody)(err.raw.message) + "', 'Credit Card Payment', '0')";
                        obj.prepare();
                        obj.execute((serror, result) => {
                            if (serror === 1) {
                                callback(0, { message: "Payment Failed !", status: 504 });
                            }
                            else {
                                callback(0, { message: "Something Went Wrong with payment failed !", status: 505 });
                            }
                        });
                    }
                    else {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO stripe_payment (idaccount, email, charge_id, customer_id, balance_transaction, amount, created, status, description, type, is_status) VALUES ('" + idaccount + "', '" + (0, markError_1.parseBody)(stipedata.email) + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "', '" + (0, markError_1.parseBody)(charge.description) + "', 'Credit Card Payment', '1')";
                        obj1.prepare();
                        obj1.execute((serror1, result) => {
                            if (serror1 == 1) {
                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE account SET subscription_payment = 1 WHERE idaccount = '" + idaccount + "'";
                                obj5.prepare();
                                obj5.execute((serror, result) => {
                                    if (serror == 1) {
                                        let obj9 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj9.nonqrysql = "UPDATE `subscription_account` SET `status` = 1 WHERE idaccount = '" + sessdata.idaccount + "'";
                                        obj9.prepare();
                                        obj9.execute((paymentError, result) => {
                                            if (paymentError == 1) {
                                                callback(1, { message: "Subscription charges deducted successfully !", status: 201 });
                                            }
                                            else {
                                                callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 501 });
                                            }
                                        });
                                    }
                                    else {
                                        callback(0, { message: "Balance Deducted Successfully But Error With Updated!", status: 502, err: serror });
                                    }
                                });
                            }
                            else {
                                callback(0, { message: "Payment update failed", status: 501 });
                            }
                        });
                    }
                });
            }
            else {
                callback(0, { message: "Failed to fetch user trust score", status: 500 });
            }
        });
    }
}
exports.StripeApi = StripeApi;
