"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Importnumber = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const _406_1 = require("../lib/view/406");
const Session_1 = require("../lib/model/Session");
const Osr_1 = require("./Osr");
const SinchSubmitNumber_1 = require("./SinchSubmitNumber");
class Importnumber extends APIBase_1.APIBase {
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        this.timekey = timekey;
        this.sessdata = sessdata;
        this.priority = proirity;
    }
    importNumber(req, res, next) {
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    if (sdata.DID.length == 10) {
                        let type = '';
                        if ((npa == "800" || npa == "811" || npa == "822" || npa == "833" || npa == "844" || npa == "855" || npa == "866" || npa == "877" || npa == "888" || npa == "899")) {
                            console.log("Number Type is ITF");
                            type = "ITF";
                        }
                        else {
                            console.log("Number Type is INN");
                            type = "INN";
                        }
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `status`, `did`,`provider`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`rates`) VALUE('" + sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','Importnumber','" + type + "','" + sessdata.iduser + "','1','" + npa + "','" + nxx + "','0')";
                        obj.prepare();
                        obj.execute((err, data) => {
                            if (err == 1) {
                                // update end subscription date
                                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                obj0.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id,IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date,DATE_FORMAT(d.`created_at`,'%Y-%m-%d %H:%i:%s')`created_at` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN  `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.iddid='" + data.insertId + "' AND disconnect_did_status = '1'";
                                obj0.prepare();
                                obj0.execute((dids_err, didRes) => {
                                    let currentDate = new Date();
                                    currentDate.setMonth(currentDate.getMonth() + 1);
                                    currentDate.setDate(0);
                                    currentDate.setUTCHours(0, 0, 0, 0);
                                    let lastDate = currentDate.toJSON().slice(0, 19).replace('T', ' ');
                                    let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj01.nonqrysql = "UPDATE `did_buy` SET `subscription_end_date`='" + lastDate + "' WHERE `iddid`=" + didRes[0].iddid + ";";
                                    obj01.prepare();
                                    obj01.execute((error, result) => { });
                                });
                                // To create the DID log
                                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                objv1.nonqrysql = "INSERT INTO `did_log` (`account_id`, `status`, `did`,`provider`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`rates`,`pro_rates`,`event_type`,`description`) VALUE('" + sessdata.idaccount + "','completed','" + sdata.DID.trim() + "','Importnumber','" + type + "','" + sessdata.iduser + "','1','" + npa + "','" + nxx + "','0','0','2','Import DID')";
                                objv1.prepare();
                                objv1.execute((log_error, did_log) => {
                                    if (log_error == 1) {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 200, message: "DID Imported Successfully!" });
                                        obj.execute();
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        obj.execute();
                                    }
                                });
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 502, message: "Something went wrong with connection!" });
                                obj.execute();
                            }
                        });
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 502, message: "Please enter 10 digit number!" });
                        obj.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 500, message: "You are not Authorized for this!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    disconnectDID(req, res, payload, callback) {
        const sdata = req.body;
        let iduser = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let idaccount = (typeof sdata.idaccount != 'undefined' && sdata.idaccount > 0) ? sdata.idaccount : this.sessdata.idaccount;
        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj1.nonqrysql = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES('" + idaccount + "','" + iduser + "', '" + sdata.DID.trim() + "','5','Disconnect DID from provider',NOW())";
        obj1.prepare();
        obj1.execute((error, result) => {
            if (error == 1) {
                console.log("Toll-Free Disconnect DID Log From Provider Inserted");
            }
            else {
                console.log("Toll-Free Disconnect DID Log From Provider Not Inserted");
            }
        });
        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `did`='" + sdata.DID.trim() + "'";
        obj2.prepare();
        obj2.execute((errorin, data) => {
            if (errorin == 1) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 201, message: "DID Disconnected Successfully!" });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "DID Not Disconnected Successfully!" });
                objv.execute();
            }
        });
    }
    disconnectDIDOTTMASH(req, res, payload, callback) {
        const sdata = req.body;
        let iduser = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : this.sessdata.iduser;
        let idaccount = (typeof sdata.idaccount != 'undefined' && sdata.idaccount > 0) ? sdata.idaccount : this.sessdata.idaccount;
        if (payload.campaign && payload.campaign.startsWith("C")) {
            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "'";
            obj2.prepare();
            obj2.execute((errorin, data) => {
                if (errorin == 1) {
                    // To delete the number from OSR
                    let payLoad = {
                        DID: sdata.DID.trim(),
                        campaign: payload.campaign,
                        iduser: iduser,
                        type: payload.type,
                        did_sub_type: payload.did_sub_type
                    };
                    let osr = new Osr_1.OsrApi(this.priority, this.sessdata);
                    osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                        if (error == 1) {
                            if (payload.sms_provider && payload.sms_provider == 'sinch') {
                                // To delete the number from Sinch
                                let osr = new SinchSubmitNumber_1.SinchApi(this.priority, this.sessdata);
                                osr.deleteNumberM2(req, res, payLoad, (error, response) => {
                                });
                            }
                            else {
                                // To delete the number from Syniverse
                                let osr = new SinchSubmitNumber_1.SinchApi(this.priority, this.sessdata);
                                osr.deleteNumberM2fromSyniverse(req, res, payLoad, (error, response) => {
                                });
                            }
                        }
                    });
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES('" + idaccount + "','" + iduser + "', '" + sdata.DID.trim() + "','5','Disconnect DID from provider',NOW())";
                    obj1.prepare();
                    obj1.execute((error, result) => {
                        if (error == 1) {
                            console.log("OTT_MASH Disconnect DID Log From Provider Inserted");
                        }
                        else {
                            console.log("OTT_MASH Disconnect DID Log From Provider Not Inserted");
                        }
                    });
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 201, message: "DID Disconnected Successfully!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "DID Not Disconnected Successfully!" });
                    objv.execute();
                }
            });
        }
        else {
            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='3' WHERE `did`='" + sdata.DID.trim() + "'";
            obj2.prepare();
            obj2.execute((errorin, data) => {
                if (errorin == 1) {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES('" + idaccount + "','" + iduser + "', '" + sdata.DID.trim() + "','5','Disconnect DID from provider',NOW())";
                    obj1.prepare();
                    obj1.execute((error, result) => {
                        if (error == 1) {
                            console.log("OTT_MASH Disconnect DID Log From Provider Inserted");
                        }
                        else {
                            console.log("OTT_MASH Disconnect DID Log From Provider Not Inserted");
                        }
                    });
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 201, message: "DID Disconnected Successfully!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "DID Not Disconnected Successfully!" });
                    objv.execute();
                }
            });
        }
    }
}
exports.Importnumber = Importnumber;
