"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShortCodeNumber = void 0;
// import { AppRoute } from "../lib/AppRoute";
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const _406_1 = require("../lib/view/406");
const setting_config_1 = require("../config/setting.config");
const markError_1 = require("./markError");
const APIBase_1 = require("./APIBase");
const numberApi_1 = require("./numberApi");
const SCampaign = new setting_config_1.ShortCodeCampaign();
const SMTP = new setting_config_1.SMTPDetails();
class ShortCodeNumber {
    constructor() {
        // super();
    }
    GetContentType(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "Select `display_name`,`value` From `sc_content_type`";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Content Type Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetMessageType(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "Select `display_name`,`value` From `sc_message_type`";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Message Type Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetSubscriptiomType(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "Select `display_name`,`value` From `sc_subscription_type`";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Message Type Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    SaveShortCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let sdata = JSON.parse(req.body.data);
                    let notes = (sdata.data.notes == null || sdata.data.notes === '') ? '' : (0, markError_1.parseBody)(sdata.data.notes.trim());
                    // let campname = sdata.previosFile ? (sdata.data.campaignInfo + '-copy').trim() : sdata.data.campaignInfo.trim();
                    let campname = (Array.isArray(sdata.previosFile) && sdata.previosFile.length > 0) ? (sdata.data.campaignInfo + '-copy').trim() : sdata.data.campaignInfo.trim();
                    // let randomNum = Math.floor(10000000 + Math.random() * 90000000);
                    // let scId = 'SC' + String(randomNum).padStart(8, '0');
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    const numeric = '0123456789';
                    const alphabetLength = alphabet.length;
                    const numericLength = numeric.length;
                    const length = 5;
                    let scId = 'SC';
                    for (let i = 0; i < length; i++) {
                        const isAlphabetic = Math.random() < 0.5; // Randomly choose alphabetic or numeric
                        const randomIndex = isAlphabetic ? Math.floor(Math.random() * alphabetLength) : Math.floor(Math.random() * numericLength);
                        const charToAdd = isAlphabetic ? alphabet[randomIndex] : numeric[randomIndex];
                        scId += charToAdd;
                    }
                    // const rated = sdata.Carrier.reduce((total: any, carrier: { rate: any; }) => total + carrier.rate, 0);
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        let FullName = result[0].firstname + ' ' + result[0].lastname;
                        if (_error == 1) {
                            // main table
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "INSERT INTO `sc_campaign_profile` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status`,`customer_name`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + scId + "','" + (0, markError_1.parseBody)(campname) + "','" + sdata.data.migrated + "','" + (0, markError_1.parseBody)(sdata.data.campaignview.trim()) + "','" + (0, markError_1.parseBody)(sdata.data.optout.trim()) + "','" + (0, markError_1.parseBody)(sdata.data.optoutmt.trim()) + "','" + (0, markError_1.parseBody)(sdata.data.helpmt.trim()) + "','" + (0, markError_1.parseBody)(sdata.data.email.trim()) + "','" + (0, markError_1.parseBody)(sdata.data.weburl.trim()) + "','" + sdata.data.phone + "','" + (0, markError_1.parseBody)(sdata.data.tcurl.trim()) + "','" + (0, markError_1.parseBody)(sdata.data.tctxt.trim()) + "','" + (0, markError_1.parseBody)(sdata.data.contact) + "','" + (0, markError_1.parseBody)(sdata.data.comemail) + "','" + notes + "','1','" + (0, markError_1.parseBody)(FullName) + "')";
                            obj2.prepare();
                            obj2.execute((_error, result) => {
                                if (_error == 1) {
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "Select `id_profile` From `sc_campaign_profile` WHERE `sc_campaign_unique_id` = '" + scId + "'";
                                    obj.prepare();
                                    obj.execute((error, result) => {
                                        if (error == 1) {
                                            // content definiton
                                            if (sdata.Content.length === 0) {
                                                console.log('No data found for content data');
                                            }
                                            else {
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
                                                for (let i = 0; i < sdata.Content.length; i++) {
                                                    const data = sdata.Content[i];
                                                    qry2 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + (0, markError_1.parseBody)(data.call_to_action.trim()) + "','" + (0, markError_1.parseBody)(data.opt_in_message.trim()) + "','" + (0, markError_1.parseBody)(data.example_message.trim()) + "'),";
                                                }
                                                obj3.nonqrysql = qry2.slice(0, -1);
                                                obj3.prepare();
                                                obj3.execute((error, result) => { });
                                            }
                                            // carrier coverage
                                            // if (sdata.Carrier.length === 0) {
                                            //     console.log("No carrier coverage found")
                                            // } else {
                                            //     let obj4 = new ModelRawNonQuery(req, res);
                                            //     let qry3 = "INSERT INTO `sc_campaign_carrier_coverage` (`iduser`,`idaccount`,`profile_id`,`sc_carrier_coverage`,`rate`) VALUES ";
                                            //     for (let i = 0; i < sdata.Carrier.length; i++) {
                                            //         const data = sdata.Carrier[i];
                                            //         qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + data.display_name + "','" + data.rate + "'),"
                                            //     }
                                            //     obj4.nonqrysql = qry3.slice(0, -1)
                                            //     obj4.prepare();
                                            //     obj4.execute((error: any, result: any) => { })
                                            // }
                                            // Files
                                            if (!sdata.previosFile || sdata.previosFile.length === 0) {
                                                console.log('no data found');
                                            }
                                            else {
                                                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                let qry0 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                                for (let i = 0; i < sdata.previosFile.length; i++) {
                                                    const file = sdata.previosFile[i];
                                                    qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + file.name + "','" + file.file_path + "'),";
                                                }
                                                obj0.nonqrysql = qry0.slice(0, -1);
                                                obj0.prepare();
                                                obj0.execute((_error, result) => {
                                                    console.log("Data Inserted Successfully!");
                                                });
                                            }
                                            if (req.files.length === 0) {
                                                console.log('No Files found');
                                            }
                                            else {
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                let qry1 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                                for (const file of (Array.isArray(req.files) ? req.files : Object.values(req.files))) {
                                                    const filePath = SCampaign.shortcode + file.filename;
                                                    qry1 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + file.filename + "','" + filePath + "'),";
                                                }
                                                obj1.nonqrysql = qry1.slice(0, -1);
                                                obj1.prepare();
                                                obj1.execute((_error, result) => {
                                                    console.log("Data Inserted Successfully!");
                                                });
                                            }
                                            // log
                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','1','REQUEST_CREATED','ShortCode Campaign Request Created Successfully', '" + result[0].id_profile + "')";
                                            obj0.prepare();
                                            obj0.execute((error, result) => {
                                                if (error == 1) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "ShortCode Campaign Created Successfully", status: 201 });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "ShortCode Campaign Not Created!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let condition = '';
                if (sessdata.type == 1)
                    condition += '';
                if (sessdata.type == 2)
                    condition += "WHERE idaccount='" + sessdata.idaccount + "'";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select `id_profile`,`idaccount`,`iduser`,`sc_campaign_unique_id`,`campaign_name`,`shortcode_number`,`created_at`,`status`,`customer_name`,`approved_date`,`reject_date`,`number_mapped_date`,`process_started_date`,`process_rejected_date`,`process_approved_date` , `updated_at` From `sc_campaign_profile` " + condition + "";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "ShortCode Campaign Fetched Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetSCData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error === 1) {
                if (sessdata.type === 2 || sessdata.type === 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `idaccount`,`iduser`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status` FROM `sc_campaign_profile` WHERE `id_profile` = '" + req.query.type + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error === 1) {
                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT `message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message` FROM `sc_content_defination` WHERE `profile_id` = '" + req.query.type + "'";
                            obj1.prepare();
                            obj1.execute((_err, res1) => {
                                if (_err === 1) {
                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj2.qrysql = "SELECT `filename`,`file_path` FROM `sc_campaign_files` WHERE `profile_id` = '" + req.query.type + "' ";
                                    obj2.prepare();
                                    obj2.execute((_errr, result2) => {
                                        if (_errr === 1) {
                                            let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj3.qrysql = "SELECT `event_desc`,`description`,`event_type`,`created_at`,`profile_id` FROM `sc_campaign_profile_log` WHERE `profile_id` = '" + req.query.type + "' ";
                                            obj3.prepare();
                                            obj3.execute((_errr, resul) => {
                                                if (_errr === 1) {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ data: result, data1: res1, data2: result2, data3: resul, message: "Short Code Campaign Details Fetched Successfully!", status: 201 });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    CopySc_ID(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj0.prepare();
                    obj0.execute((_error, result) => {
                        if (_error == 1) {
                            let FullName = result[0].firstname + ' ' + result[0].lastname;
                            // let randomNum = Math.floor(10000000 + Math.random() * 90000000);
                            // let scId = 'SC' + String(randomNum).padStart(8, '0');
                            const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                            const numeric = '0123456789';
                            const alphabetLength = alphabet.length;
                            const numericLength = numeric.length;
                            const length = 5;
                            let scId = 'SC';
                            for (let i = 0; i < length; i++) {
                                const isAlphabetic = Math.random() < 0.5;
                                const randomIndex = isAlphabetic ? Math.floor(Math.random() * alphabetLength) : Math.floor(Math.random() * numericLength);
                                const charToAdd = isAlphabetic ? alphabet[randomIndex] : numeric[randomIndex];
                                scId += charToAdd;
                            }
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            let key = req.body.data;
                            // Campaign Profile
                            obj.qrysql = "SELECT `campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status` FROM `sc_campaign_profile` WHERE `id_profile` = '" + key + "'";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (error == 1) {
                                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj0.nonqrysql = "INSERT INTO `sc_campaign_profile` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status`,`customer_name`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + scId + "','" + (0, markError_1.parseBody)(result[0].campaign_name + '-copy') + "','" + result[0].migrated_campaign + "','" + (0, markError_1.parseBody)(result[0].campaign_overview) + "','" + (0, markError_1.parseBody)(result[0].opt_out_keyword) + "','" + (0, markError_1.parseBody)(result[0].opt_out_mt) + "','" + (0, markError_1.parseBody)(result[0].help_mt) + "','" + (0, markError_1.parseBody)(result[0].email) + "','" + (0, markError_1.parseBody)(result[0].web_url) + "','" + (0, markError_1.parseBody)(result[0].phone_number) + "','" + (0, markError_1.parseBody)(result[0]['t&c_web_url']) + "','" + (0, markError_1.parseBody)(result[0]['t&c_text']) + "','" + (0, markError_1.parseBody)(result[0].contacts) + "','" + (0, markError_1.parseBody)(result[0].compliance_poc_email) + "','" + (0, markError_1.parseBody)(result[0].notes) + "','1','" + (0, markError_1.parseBody)(FullName) + "')";
                                    obj0.prepare();
                                    obj0.execute((_err, result) => {
                                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                                        obj.qrysql = "Select `id_profile` From `sc_campaign_profile` WHERE `sc_campaign_unique_id` = '" + scId + "'";
                                        obj.prepare();
                                        obj.execute((error, result) => {
                                            if (error == 1) {
                                                // Log
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','1','REQUEST_CREATED','ShortCode Campaign Request Created Successfully', '" + result[0].id_profile + "')";
                                                obj1.prepare();
                                                obj1.execute((error, result) => { });
                                                // Content Definition
                                                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj2.qrysql = "SELECT `message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message` FROM `sc_content_defination` WHERE `profile_id` = '" + key + "'";
                                                obj2.prepare();
                                                obj2.execute((err, res1) => {
                                                    if (err == 1) {
                                                        if (res1.length == 0) {
                                                            console.log("No Data Found");
                                                        }
                                                        else {
                                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
                                                            res1.forEach((data) => {
                                                                qry2 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + (0, markError_1.parseBody)(data.call_to_action) + "','" + (0, markError_1.parseBody)(data.opt_in_message) + "','" + (0, markError_1.parseBody)(data.example_message) + "'), ";
                                                            });
                                                            obj2.nonqrysql = qry2.slice(0, -2);
                                                            obj2.prepare();
                                                            obj2.execute((error1, res1) => { });
                                                        }
                                                    }
                                                    else {
                                                        console.log("Issue in getting the data from content definition");
                                                    }
                                                });
                                                // files 
                                                let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj3.qrysql = "SELECT `filename` ,`file_path` FROM `sc_campaign_files` WHERE `profile_id` = '" + key + "' ";
                                                obj3.prepare();
                                                obj3.execute((_errr, result2) => {
                                                    if (_errr == 1) {
                                                        if (result2.length === 0) {
                                                            console.log("No Data Found");
                                                        }
                                                        else {
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            let qry0 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`, `filename`, `file_path`) VALUES";
                                                            result2.forEach((ele) => {
                                                                qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + ele.filename + "','" + ele.file_path + "'),";
                                                            });
                                                            obj4.nonqrysql = qry0.slice(0, -1);
                                                            obj4.prepare();
                                                            obj4.execute((__error, result) => {
                                                                if (__error == 1) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "ShortCode Campaign Copied Successfully", status: 201 });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "ShortCode Campaign Not Created!", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                    }
                                                    else {
                                                        console.log("Issue in getting the data from files");
                                                    }
                                                });
                                                // carrier coverage
                                                // let obj5 = new ModelRawQuery(req, res);
                                                // obj5.qrysql = "SELECT `sc_carrier_coverage`,`rate` FROM `sc_campaign_carrier_coverage` WHERE `profile_id` = '" + key + "' ";
                                                // obj5.prepare();
                                                // obj5.execute((_errr: any, result2: any) => {
                                                //     if (_errr == 1) {
                                                //         if (result2.length === 0) {
                                                //             console.log("No Data Found")
                                                //         } else {
                                                //             let obj6 = new ModelRawNonQuery(req, res);
                                                //             let qry0 = "INSERT INTO `sc_campaign_carrier_coverage` (`iduser`, `idaccount`, `profile_id`, `rate`, `sc_carrier_coverage`) VALUES";
                                                //             result2.forEach((ele: any) => {
                                                //                 qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_profile + "','" + ele.rate + "','" + ele.sc_carrier_coverage + "'),";
                                                //             });
                                                //             obj6.nonqrysql = qry0.slice(0, -1);
                                                //             obj6.prepare();
                                                //             obj6.execute((__error: any, result: any) => {
                                                //                 if (__error == 1) {
                                                //                     let objv = new RawView(res);
                                                //                     objv.prepare({ message: "ShortCode Campaign Copied Successfully", status: 201 });
                                                //                     objv.execute();
                                                //                 } else {
                                                //                     let objv = new RawView(res);
                                                //                     objv.prepare({ message: "ShortCode Campaign Not Created!", status: 502 });
                                                //                     objv.execute();
                                                //                 }
                                                //             })
                                                //         }
                                                //     } else {
                                                //         console.log("Issue in getting the data from carrier")
                                                //     }
                                                // })
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    UpdateCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let sdata = JSON.parse(req.body.data);
                    //const rated = sdata.Carrier.reduce((total: any, carrier: { rate: any; }) => total + carrier.rate, 0);
                    // For Files 
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "DELETE FROM `sc_campaign_files` WHERE `profile_id` = '" + sdata.id + "'";
                    obj0.prepare();
                    obj0.execute((_error, result) => {
                        if (_error == 1) {
                            if (!sdata.previosFile || sdata.previosFile.length === 0) {
                                console.log('no data found');
                            }
                            else {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qry0 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                for (let i = 0; i < sdata.previosFile.length; i++) {
                                    const file = sdata.previosFile[i];
                                    qry0 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + file.name + "','" + file.file_path + "'),";
                                }
                                obj1.nonqrysql = qry0.slice(0, -1);
                                obj1.prepare();
                                obj1.execute((_error, result) => {
                                    console.log("Data Inserted Successfully!");
                                });
                            }
                            if (req.files.length === 0) {
                                console.log('No Files found');
                            }
                            else {
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qry1 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                for (const file of (Array.isArray(req.files) ? req.files : Object.values(req.files))) {
                                    const filePath = SCampaign.shortcode + file.filename;
                                    qry1 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + file.filename + "','" + filePath + "'),";
                                }
                                obj2.nonqrysql = qry1.slice(0, -1);
                                obj2.prepare();
                                obj2.execute((_error, result) => { });
                            }
                        }
                        else {
                            console.log("Issue in deletion of the files");
                        }
                    });
                    // For content definition
                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj3.nonqrysql = "DELETE FROM `sc_content_defination` WHERE `profile_id` = '" + sdata.id + "'";
                    obj3.prepare();
                    obj3.execute((error, result) => {
                        if (error == 1) {
                            if (sdata.Content.length === 0) {
                                console.log('No data found for content data');
                            }
                            else {
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
                                for (let i = 0; i < sdata.Content.length; i++) {
                                    const data = sdata.Content[i];
                                    qry2 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + (0, markError_1.parseBody)(data.call_to_action.trim()) + "','" + (0, markError_1.parseBody)(data.opt_in_message.trim()) + "','" + (0, markError_1.parseBody)(data.example_message.trim()) + "'),";
                                }
                                obj4.nonqrysql = qry2.slice(0, -1);
                                obj4.prepare();
                                obj4.execute((error, result) => { });
                            }
                        }
                        else {
                            console.log("Issue in deletion of the content definition");
                        }
                    });
                    // carrier Coverage
                    // let obj4 = new ModelRawNonQuery(req, res);
                    // obj4.nonqrysql = "DELETE FROM `sc_campaign_carrier_coverage` WHERE `profile_id` = '" + sdata.id + "'";
                    // obj4.prepare();
                    // obj4.execute((error: any, result: any) => {
                    //     if (error == 1) {
                    //         if (sdata.Carrier.length === 0) {
                    //             console.log("No carrier coverage found")
                    //         } else {
                    //             let obj5 = new ModelRawNonQuery(req, res);
                    //             let qry3 = "INSERT INTO `sc_campaign_carrier_coverage` (`iduser`,`idaccount`,`profile_id`,`sc_carrier_coverage`,`rate`) VALUES ";
                    //             for (let i = 0; i < sdata.Carrier.length; i++) {
                    //                 const data = sdata.Carrier[i];
                    //                 qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.id + "','" + data.display_name + "','" + data.rate + "'),"
                    //             }
                    //             obj5.nonqrysql = qry3.slice(0, -1)
                    //             obj5.prepare();
                    //             obj5.execute((error: any, result: any) => { })
                    //         }
                    //     } else {
                    //         console.log("Issue in deletion of the carrier coverage")
                    //     }
                    // })
                    // update main table
                    let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj6.nonqrysql = "UPDATE sc_campaign_profile SET `campaign_name` = '" + (0, markError_1.parseBody)(sdata.data.campaignInfo.trim()) + "', `migrated_campaign` = '" + sdata.data.migrated + "', `campaign_overview` = '" + (0, markError_1.parseBody)(sdata.data.campaignview.trim()) + "', `opt_out_keyword` = '" + (0, markError_1.parseBody)(sdata.data.optout.trim()) + "', `opt_out_mt` = '" + (0, markError_1.parseBody)(sdata.data.optoutmt.trim()) + "', `help_mt` = '" + (0, markError_1.parseBody)(sdata.data.helpmt.trim()) + "', `email` = '" + (0, markError_1.parseBody)(sdata.data.email.trim()) + "', `web_url` = '" + (0, markError_1.parseBody)(sdata.data.weburl.trim()) + "', `phone_number` = '" + (0, markError_1.parseBody)(sdata.data.phone) + "', `t&c_web_url` = '" + (0, markError_1.parseBody)(sdata.data.tcurl.trim()) + "', `t&c_text` = '" + (0, markError_1.parseBody)(sdata.data.tctxt.trim()) + "', `contacts` = '" + (0, markError_1.parseBody)(sdata.data.contact) + "', `compliance_poc_email` = '" + (0, markError_1.parseBody)(sdata.data.comemail) + "', `notes` = '" + (0, markError_1.parseBody)(sdata.data.notes.trim()) + "', `status` = '1'  WHERE `id_profile` = '" + sdata.id + "'";
                    obj6.prepare();
                    obj6.execute((error, result) => { });
                    // log 
                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj7.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','8','REQUEST_UPDATED','ShortCode Campaign Request Updated Successfully', '" + sdata.id + "')";
                    obj7.prepare();
                    obj7.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 201, message: "ShortCode Campaign Updated Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something Went Wrong While updating ShortCode Campaign!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    RejectCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '2',`reject_date`= NOW()  WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.id + "'";
                    obj1.prepare();
                    obj1.execute((errors, result) => {
                        if (errors == 1) {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `email` FROM `user_profile` WHERE `iduser`='" + sdata.iduser + "'";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`type`,`status`,`html`) VALUES ('" + sdata.iduser + "','" + sdata.idaccount + "','" + SMTP.from + "','" + result[0].email + "', '" + (0, markError_1.parseBody)(SMTP.RejectSubject) + "','" + (0, markError_1.parseBody)(sdata.reject_text.trim()) + "','ShortCode Campaign Request Rejected','21','" + (0, markError_1.parseBody)(sdata.reject_text.trim()) + "')";
                                    obj1.prepare();
                                    obj1.execute((_err, __result) => {
                                        if (_err == 1) {
                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','2','REQUEST_REJECTED','" + (0, markError_1.parseBody)(sdata.reject_text.trim()) + "', '" + sdata.id + "')";
                                            obj0.prepare();
                                            obj0.execute((error, result) => {
                                                if (error == 1) {
                                                    let objv0 = new RawView_1.RawView(res);
                                                    objv0.prepare({ status: 201, message: "ShortCode Campaign Rejected  Successfully." });
                                                    objv0.execute();
                                                }
                                                else {
                                                    let objv0 = new RawView_1.RawView(res);
                                                    objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                                                    objv0.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objvs = new RawView_1.RawView(res);
                                            objvs.prepare({ message: "Something Went Wrong While Inserting Data !", status: 503 });
                                            objvs.execute();
                                        }
                                    });
                                }
                                else {
                                    let objvs = new RawView_1.RawView(res);
                                    objvs.prepare({ message: "Something Went Wrong!", status: 503 });
                                    objvs.execute();
                                }
                            });
                        }
                        else {
                            let objvs = new RawView_1.RawView(res);
                            objvs.prepare({ message: "Something Went Wrong!", status: 503 });
                            objvs.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    ApproveCampaign(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    // let obj0 = new ModelRawQuery(req, res);
                    // obj0.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sdata.idaccount + "' AND `balance` + `credit_limit` >= '" + sdata.rates + "'"
                    // obj0.prepare();
                    // obj0.execute((walletError: any, wallet: any) => {
                    //if (walletError == 1 && wallet.length > 0) {
                    //let rate = new APIBase();
                    //rate.checkBalance(req, res, sdata.idaccount, sdata.rates, (walletError, wallet) => {
                    //if (walletError == 1) {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '3',`approved_date`= NOW()  WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.id + "'";
                    obj1.prepare();
                    obj1.execute((errors, result) => {
                        if (errors == 1) {
                            // To update the wallet amount
                            // let objv1 = new ModelRawNonQuery(req, res);
                            // objv1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + sdata.rates + " WHERE `idaccount`='" + sdata.idaccount + "'"
                            // objv1.prepare();
                            // objv1.execute((wallet_error, wallet_success) => {
                            //     // To update the wallet transaction log
                            //     let iQry: string = "INSERT INTO `wallet_recharge_log` SET "
                            //     iQry += "`idaccount`=" + sdata.idaccount + ", "
                            //     iQry += "`amount`='-" + sdata.rates + "', "
                            //     iQry += "`purpose`='Wallet amount successfully updated for shortcode', "
                            //     iQry += "`status`=1;"
                            //     let objWL = new ModelRawNonQuery(req, res);
                            //     objWL.nonqrysql = iQry
                            //     objWL.prepare()
                            //     objWL.execute((error: any, result: any) => {
                            //         console.log("Wallet Updated Successfully!");
                            //     });
                            // });
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','3','REQUEST_APPROVED','ShortCode Campaign Request Approved Successfully', '" + sdata.id + "')";
                            obj0.prepare();
                            obj0.execute((error, result) => {
                                if (error == 1) {
                                    let objv0 = new RawView_1.RawView(res);
                                    objv0.prepare({ status: 201, message: "ShortCode Campaign Approved  Successfully." });
                                    objv0.execute();
                                }
                                else {
                                    let objv0 = new RawView_1.RawView(res);
                                    objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                                    objv0.execute();
                                }
                            });
                        }
                        else {
                            let objvs = new RawView_1.RawView(res);
                            objvs.prepare({ message: "Something Went Wrong!", status: 503 });
                            objvs.execute();
                        }
                    });
                    // } else {
                    //     let objv = new RawView(res);
                    //     objv.prepare({ error_code: 0, error: walletError, message: "Insufficient Balance.", status: 503 });
                    //     objv.execute();
                    // }
                    // });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    ShortCodeFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let condition = "";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== undefined ? " AND scp.`idaccount`='" + data.idaccount + "'" : '';
                }
                if (sessdata.type == 2)
                    conditionU += "scp.`idaccount`=" + sessdata.idaccount + "";
                if (data.requestid) {
                    condition += "scp.`sc_campaign_unique_id` = '" + data.requestid + "' AND ";
                }
                if (data.user) {
                    condition += 'scp.`customer_name` LIKE "%' + (0, markError_1.parseBody)(data.user) + '%" AND ';
                }
                if (data.campaignname) {
                    condition += 'scp.`campaign_name` LIKE "%' + (0, markError_1.parseBody)(data.campaignname) + '%" AND ';
                }
                if (data.status) {
                    condition += 'scp.`status` LIKE "%' + (0, markError_1.parseBody)(data.status) + '%" AND ';
                }
                if (data.from && data.to) {
                    condition += 'scp.`created_at` BETWEEN "' + data.from + ' 00:00:00" AND "' + data.to + ' 23:59:59" AND ';
                }
                if (data.sc_request_id) {
                    condition += "sr.`sc_request_id` = '" + data.sc_request_id + "' AND ";
                }
                if (data.batch_id) {
                    condition += "sbr.`batch_id_unique` = '" + data.batch_id + "'AND ";
                }
                if (data.sc_type) {
                    condition += "sr.`sc_type` = '" + data.sc_type + "' AND ";
                }
                if (data.filter_type == "Pending Review")
                    condition += 'scp.`status`="1" AND ';
                if (data.filter_type == "Rejected")
                    condition += 'scp.`status`="2" AND ';
                if (data.filter_type == "Approved")
                    condition += 'scp.`status`="3" AND ';
                if (data.filter_type == "Shortcode Request Created")
                    condition += 'scp.`status`="4" AND ';
                if (data.filter_type == "SC Campaign Profile Process Started")
                    condition += 'scp.`status`="5" AND ';
                if (data.filter_type == "SC Campaign Profile Approved")
                    condition += 'scp.`status`="6" AND ';
                if (data.filter_type == "SC Campaign Profile Rejected")
                    condition += 'scp.`status`="7" AND ';
                if (data.status == "0")
                    condition += 'scp.`status`="0" AND ';
                if (data.status == "1")
                    condition += 'scp.`status`="1" AND ';
                if (data.status == "2")
                    condition += 'scp.`status`="2" AND ';
                if (data.status == "3")
                    condition += 'scp.`status`="3" AND ';
                if (data.status == "4")
                    condition += 'scp.`status`="4" AND ';
                if (data.status == "5")
                    condition += 'scp.`status`="5" AND ';
                if (data.status == "6")
                    condition += 'scp.`status`="6" AND ';
                if (data.status == "7")
                    condition += 'scp.`status`="7" AND ';
                if (!data.status || data.filter_type == " ")
                    condition += '';
                obj.qrysql = "SELECT scp.idaccount,scp.iduser,scp.sc_campaign_unique_id,scp.campaign_name,scp.id_profile,scp.shortcode_number,scp.created_at,scp.status,scp.customer_name,scp.approved_date,scp.reject_date,scp.number_mapped_date,scp.process_started_date,scp.process_rejected_date,scp.process_approved_date,sr.sc_type,sr.sc_request_id , sbr.batch_id_unique , sr.status AS sc_request_status FROM `sc_campaign_profile` scp LEFT JOIN `sc_request` sr ON  scp.id_profile = sr.profile_id LEFT JOIN `sc_batchid_request` sbr ON scp.id_profile = sbr.sc_campaign_unique_id WHERE " + condition + " " + conditionU;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "ShortCode Campaign List Fetched Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Fetched ShortCode Campaign   List!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    CarrierCoverage(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `display_name`,`rate`,`sc_type` FROM `sc_carrier_coverage`";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    get_scbatchId(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT bid.`batch_id_unique`,bid.`created_at`,bid.`filepath`, sbr.`id_batch`, sbr.`sc_campaign_unique_id` FROM `sc_batch_id` bid LEFT JOIN `sc_batchid_request` sbr ON bid.id_batch = sbr.id_batch ORDER BY bid.`id_batch` DESC";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "ShortCode List Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    sc_numberList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let conditionU = '';
                if (sessData.type == 1)
                    conditionU += '';
                if (sessData.type == 2)
                    conditionU += "did_buy.`account_id`=" + sessData.idaccount + "";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT DISTINCT scp.`iduser`,scp.`idaccount`,scp.`sc_campaign_unique_id`,scp.`shortcode_number`,scp.`customer_name`, scp.`status`, scp.`process_rejected_date`, scp.`process_approved_date`,sr.`sc_type`,sr.`connection`, sbr.`batch_id_unique`, sr.sc_request_id FROM `sc_campaign_profile` scp LEFT JOIN `sc_request` sr ON scp.id_profile = sr.profile_id LEFT JOIN `sc_batchid_request` sbr ON scp.`id_profile` = sbr.`sc_campaign_unique_id` WHERE scp.status='6' AND " + conditionU + "";
                // obj.qrysql = "SELECT DISTINCT COALESCE(did_buy.`iduser`, scp.`iduser`) AS iduser,COALESCE(did_buy.`account_id`, scp.`idaccount`) AS account_id,scp.`sc_campaign_unique_id`,did_buy.`did` AS shortcode_number,scp.shortcode_number AS did,scp.`customer_name`,scp.`status`,scp.`process_rejected_date`,scp.`process_approved_date`,sr.`sc_type`,sr.`connection`,sbr.`batch_id_unique`,sr.`sc_request_id` FROM `did_buy` LEFT JOIN `sc_campaign_profile` scp ON did_buy.`did` = scp.`shortcode_number` LEFT JOIN `sc_request` sr ON scp.`id_profile` = sr.`profile_id` LEFT JOIN `sc_batchid_request` sbr ON scp.`sc_campaign_unique_cid` = sbr.`sc_campaign_unique_id` WHERE did_buy.`type` = 'SC' OR scp.`shortcode_number` IS NOT NULL AND " + conditionU + "";
                obj.qrysql = "SELECT DISTINCT did_buy.`iddid`,did_buy.`iduser`,did_buy.`account_id` as idaccount, COALESCE(scp.`sc_campaign_unique_id`, 'N/A') AS sc_campaign_unique_id, COALESCE(did_buy.`did`, 'N/A') AS shortcode_number, COALESCE(scp.`customer_name`, 'N/A') AS customer_name, COALESCE(did_buy.`sinch_status`, 'N/A') AS status, COALESCE(scp.`process_rejected_date`, 'N/A') AS process_rejected_date, did_buy.`created_at` AS process_approved_date, COALESCE(did_buy.`did_sub_type`, 'N/A') AS sc_type, COALESCE(did_buy.`connection_key`, 'N/A') AS connection, COALESCE(sbr.`batch_id_unique`, 'N/A') AS batch_id_unique, COALESCE(sr.`sc_request_id`, 'N/A') AS sc_request_id FROM `did_buy` LEFT JOIN `sc_campaign_profile` scp ON did_buy.`did` = scp.`shortcode_number` LEFT JOIN `sc_request` sr ON scp.`id_profile` = sr.`profile_id` LEFT JOIN `sc_batchid_request` sbr ON scp.`id_profile` = sbr.`sc_campaign_unique_id` WHERE (did_buy.`type` = 'SC' OR scp.`shortcode_number` IS NOT NULL) AND " + conditionU + "";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'ShortCode Number Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    filterForShortcodeNumber(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let extField;
                let conditionU;
                let conditionC;
                let conditionR;
                let conditionN;
                let conditionB;
                let idaccount;
                if (sessdata.type == 1) {
                    extField = "scp.`customer_name`, sbr.`batch_id_unique`,";
                }
                else if (sessdata.type == 2) {
                    idaccount = "AND did_buy.`account_id` = '" + sessdata.idaccount + "'";
                }
                if (sdata.shortcode_type == 'Customer Provided Migrated Shortcode') {
                    conditionU = "AND did_buy.`did_sub_type` = '2'";
                }
                if (sdata.shortcode_type == 'Customer Provided New Shortcode') {
                    conditionU = "AND did_buy.`did_sub_type` = '3'";
                }
                if (sdata.shortcode_type == 'New Random Shortcode') {
                    conditionU = "AND did_buy.`did_sub_type` = '0'";
                }
                if (sdata.shortcode_type == 'New Vanity Shortcode') {
                    conditionU = "AND did_buy.`did_sub_type` = '1'";
                }
                if (sdata.sc_campaign_unique_id) {
                    conditionC = "AND scp.`sc_campaign_unique_id` = '" + sdata.sc_campaign_unique_id + "'";
                }
                if (sdata.sc_request_id) {
                    conditionR = "AND sr.`sc_request_id` = '" + sdata.sc_request_id + "'";
                }
                if (sdata.shortcode_number) {
                    conditionN = "AND did_buy.`did` = '" + sdata.shortcode_number + "'";
                }
                if (sdata.batchid) {
                    conditionB = "AND sbr.`batch_id_unique` = '" + sdata.batchid + "'";
                }
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT " + extField + " scp.`iduser`,scp.`idaccount` , scp.`sc_campaign_unique_id`,scp.`shortcode_number`, scp.`status`, scp.`process_rejected_date`, scp.`process_approved_date`,sr.`sc_type`,sr.`connection` , sr.sc_request_id FROM `sc_campaign_profile` scp LEFT JOIN `sc_request` sr ON scp.id_profile = sr.profile_id LEFT JOIN `sc_batchid_request` sbr ON scp.`id_profile` = sbr.`sc_campaign_unique_id` WHERE scp.status IN ('6', '7') " + conditionU + " " + conditionC + " " + conditionN + " " + conditionB + " " + conditionR + " " + idaccount + "";
                obj.qrysql = "SELECT did_buy.`iddid`,did_buy.`iduser`,did_buy.`account_id` as idaccount, COALESCE(scp.`sc_campaign_unique_id`, 'N/A') AS sc_campaign_unique_id, COALESCE(did_buy.`did`, 'N/A') AS shortcode_number, COALESCE(scp.`customer_name`, 'N/A') AS customer_name, COALESCE(did_buy.`sinch_status`, 'N/A') AS status, COALESCE(scp.`process_rejected_date`, 'N/A') AS process_rejected_date, did_buy.`created_at` AS process_approved_date, COALESCE(did_buy.`did_sub_type`, 'N/A') AS sc_type, COALESCE(did_buy.`connection_key`, 'N/A') AS connection, COALESCE(sbr.`batch_id_unique`, 'N/A') AS batch_id_unique, COALESCE(sr.`sc_request_id`, 'N/A') AS sc_request_id FROM `did_buy` LEFT JOIN `sc_campaign_profile` scp ON did_buy.`did` = scp.`shortcode_number` LEFT JOIN `sc_request` sr ON scp.`id_profile` = sr.`profile_id` LEFT JOIN `sc_batchid_request` sbr ON scp.`id_profile` = sbr.`sc_campaign_unique_id` WHERE (did_buy.`type` = 'SC' OR scp.`shortcode_number` IS NOT NULL)" + conditionU + " " + conditionC + " " + conditionN + " " + conditionB + " " + conditionR + " " + idaccount + "";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'ShortCode Number Details Fetched Successfully!', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    csvForNumberMap(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    const requestID = "'" + sdata.requestId.join("','") + "'";
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT scp.sc_campaign_unique_id AS SC_Request_ID, scp.campaign_name AS Campaign_Name, scp.shortcode_number AS ShortCode_Number, CASE WHEN scp.migrated_campaign='1' THEN 'Standard rate' WHEN scp.migrated_campaign='2' THEN 'Free-to-end-user' END AS Migrated_Campaign, scp.campaign_overview AS Campaign_Overview, scp.opt_out_keyword AS Opt_Out_Keyword, scp.opt_out_mt AS Opt_Out_MT, scp.help_mt AS Help_MT, scp.email AS Email, scp.web_url AS Web_URL, scp.phone_number AS Phone_Number, scp.`t&c_web_url` AS `T&C_Web_Url`, scp.`t&c_text` AS `T&C_Text`, scp.customer_name AS Customer_Name, scp.notes AS Notes, GROUP_CONCAT(DISTINCT scf.filename) AS Filenames, GROUP_CONCAT(DISTINCT scf.file_path) AS Filepaths, GROUP_CONCAT(DISTINCT CASE WHEN scd.message_type='1' THEN 'SMS' WHEN scd.message_type='2' THEN 'MMS-Audio' WHEN scd.message_type='3' THEN 'MMS-Image' WHEN scd.message_type='4' THEN 'MMS-Video' END ) AS Message_Types, GROUP_CONCAT(DISTINCT CASE WHEN scd.content_type='1' THEN 'Chat' WHEN scd.content_type='2' THEN 'Coupons' WHEN scd.content_type='3' THEN 'Entertainment Alerts' WHEN scd.content_type='4' THEN 'Information Alert' WHEN scd.content_type='5' THEN 'Sweepstakes' WHEN scd.content_type='6' THEN 'Trivia' WHEN scd.content_type='7' THEN 'Two-factor Authentication' WHEN scd.content_type='8' THEN 'Voting/Polling' END ) AS Content_Types, GROUP_CONCAT(DISTINCT CASE WHEN scd.subscription_type='1' THEN 'One Time' WHEN scd.subscription_type='2' THEN 'Subscription' END ) AS Subscription_Types, scd.call_to_Action AS Call_To_Action, scd.opt_in_message AS Opt_In_Message, scd.example_message AS Example_message FROM `sc_campaign_profile` scp LEFT JOIN `sc_campaign_files` scf ON scp.id_profile = scf.profile_id LEFT JOIN `sc_content_defination` scd ON scp.id_profile = scd.profile_id WHERE scp.status='4' AND scp.id_profile IN (" + requestID + ") GROUP BY scp.id_profile;";
                    obj1.prepare();
                    obj1.execute((errors, result1) => {
                        if (errors == 1) {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT id_request FROM sc_request WHERE profile_id IN (" + requestID + ")";
                            obj.prepare();
                            obj.execute((_errors, result) => {
                                if (_errors == 1) {
                                    const idRequests = result.map((row) => row.id_request).join(",");
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT id_request, GROUP_CONCAT(sc_carrier_coverage) AS sc_carrier_coverage FROM sc_request_carrier_coverage WHERE id_request IN (" + idRequests + ") GROUP BY id_request";
                                    ;
                                    obj.prepare();
                                    obj.execute((_errors, result2) => {
                                        if (_errors == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ data: result1, data1: result2, message: "ShortCode List Fetched Successfully!", status: 200 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With ShortCode List!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    sc_sendMail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    try {
                        let sdata = JSON.parse(req.body.data);
                        const requestID = "'" + sdata.requestId.join("','") + "'";
                        let objv = new RawQuery_1.ModelRawQuery(req, res);
                        objv.qrysql = "SELECT `iduser`,`idaccount`,`sc_campaign_unique_id`,`id_profile` from `sc_campaign_profile` WHERE `id_profile` IN (" + requestID + ") ";
                        objv.prepare();
                        objv.execute((errors, result) => {
                            // const Number = result[0].shortcode_number;
                            // const profileId = result[0].id_profile;
                            if (errors == 1) {
                                let data = req.files;
                                const idusers = result.map((row) => row.iduser);
                                const idaccounts = result.map((row) => row.idaccount);
                                let prefix = 'SCBID';
                                let totalLength = 13;
                                let randomDigitsLength = totalLength - prefix.length;
                                let randomNumber = Math.floor(Math.pow(10, randomDigitsLength - 1) + Math.random() * (Math.pow(10, randomDigitsLength) - Math.pow(10, randomDigitsLength - 1)));
                                let batchID = prefix + randomNumber;
                                let filename = data[0].filename;
                                let value = SCampaign.shortcode + filename;
                                let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj00.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`,`subject`,`text`,`type`,`status`,`file`,`html`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + SMTP.from + "','" + SMTP.to + "', 'Mail Send For SC Number Mapping','Mapped ShortCode Campaign','Mail sent to ShortCode Mapping','20', '" + value + "','" + (0, markError_1.parseBody)(SMTP.text) + "')";
                                obj00.prepare();
                                obj00.execute((_err, __result) => {
                                    if (_err == 1) {
                                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj0.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '5',`process_started_date`=NOW() WHERE `idaccount` IN (" + idaccounts + ") AND `iduser` IN (" + idusers + ") AND `id_profile` IN (" + requestID + ")";
                                        obj0.prepare();
                                        obj0.execute((errors, result) => { });
                                        let qry = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES";
                                        result.forEach((ele) => {
                                            qry += "('" + ele.iduser + "', '" + ele.idaccount + "', '5', 'CAMPAIGN_PROFILE_PROCESS_STARTED', 'ShortCode Campaign Profile Process Started', '" + ele.id_profile + "'),";
                                        });
                                        /*did log maintain*/
                                        // let obj21 = new ModelRawNonQuery(req, res);
                                        // obj21.nonqrysql = "UPDATE did_buy SET sinch_status = '2', updated_at=NOW() WHERE `iduser`='" + idusers + "' AND `did`='" + Number + "'";
                                        // obj21.prepare();
                                        // obj21.execute((error: any, data: any) => { });
                                        // let obj22 = new ModelRawNonQuery(req, res);
                                        // obj22.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUES ('" + idaccounts + "','" + idusers + "',NOW(),'41','Number Mapped For Shortcode','" + Number + "')";
                                        // obj22.prepare();
                                        // obj22.execute((_error: any, result: any) => {
                                        //     console.log("Data Inserted Successfully!");
                                        // });
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = qry.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((_error, result) => {
                                            console.log("Email Sent Successfully!");
                                        });
                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "INSERT INTO `sc_batch_id` (`iduser`,`idaccount`,`batch_id_unique`,`filename`,`filepath`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + batchID + "','" + filename + "','" + value + "')";
                                        obj2.prepare();
                                        obj2.execute((errors, result) => {
                                            if (errors == 1) {
                                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                obj.qrysql = "SELECT `id_batch`,`batch_id_unique` from `sc_batch_id` WHERE `batch_id_unique`='" + batchID + "'";
                                                obj.prepare();
                                                obj.execute((_error, result1) => {
                                                    const BatchData = result1[0].batch_id_unique;
                                                    const BatchID = result1[0].id_batch;
                                                    let qry0 = "INSERT INTO `sc_batchid_request`(`idaccount`, `iduser`, `batch_id_unique`,`id_batch`,`sc_campaign_unique_id`) VALUES ";
                                                    for (let i = 0; i < sdata.requestId.length; i++) {
                                                        let requestData = sdata.requestId[i];
                                                        qry0 += "('" + sessdata.idaccount + "', '" + sessdata.iduser + "','" + BatchData + "' ,'" + BatchID + "','" + requestData + "'),";
                                                    }
                                                    let objj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objj1.nonqrysql = qry0.slice(0, -1);
                                                    objj1.prepare();
                                                    objj1.execute((_error, resultIdreq) => {
                                                        console.log("Batch ID Inserted Successfully!");
                                                    });
                                                });
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Email Sent Successfully!", status: 200 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 401, message: "Email is not Sent!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 401, message: "Invalid Details!" });
                                objv.execute();
                            }
                        });
                    }
                    catch (e) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    approveSCStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                if (sessdata.type == 1) {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '6',`process_approved_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.id_profile + "'";
                    obj1.prepare();
                    obj1.execute((errors, result) => {
                        if (errors == 1) {
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "', '6', 'CAMPAIGN_PROFILE_PROCESS_APPROVED','ShortCode Campaign Profile Process Approved','" + sdata.id_profile + "')";
                            obj0.prepare();
                            obj0.execute((_error, result) => { });
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ status: 201, message: "SC Campaign Profile Approved Successfully." });
                            objv0.execute();
                            let obj12 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj12.nonqrysql = "UPDATE sc_request SET status = '1' WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `profile_id`= '" + sdata.id_profile + "'";
                            obj12.prepare();
                            obj12.execute((error, data) => { });
                            // let obj2 = new ModelRawNonQuery(req, res);
                            // obj2.nonqrysql = "UPDATE did_buy SET sinch_status = '1', updated_at=NOW() WHERE `iduser`='" + sdata.iduser + "' AND `did`='" + sdata.number + "'";
                            // obj2.prepare();
                            // obj2.execute((error: any, data: any) => { });
                            // let obj10 = new ModelRawNonQuery(req, res);
                            // obj10.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "',NOW(),'42','SMS fully provisioned For Shortcode','" + sdata.number + "')";
                            // obj10.prepare();
                            // obj10.execute((_error: any, result: any) => {
                            //     console.log("Data Inserted Successfully!");
                            // });
                        }
                        else {
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                            objv0.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    // approveSCrStatus(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let sdata = req.body.data;
    //             console.log("sdatasdatasdatasdatasdatasdatasdatasdatasdata::::",sdata);
    //             console.log("sdatasdatasdatasdatasdatasdatasdatafffffffffffffffffffffffffffffffffffffffsdatasdata::::",sdata);
    //             if (sessdata.type == 1) {
    //                 let obj1 = new ModelRawNonQuery(req, res);
    //                 obj1.nonqrysql = "UPDATE `sc_request` SET `status`= '4',`approved_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `profile_id`= '" + sdata.idprofile + "'";
    //                 obj1.prepare();
    //                 obj1.execute((errors: any, result: any) => {
    //                     if (errors == 1) {
    //                         let objj0 = new ModelRawNonQuery(req, res);
    //                         objj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','3','SHORTCODE_REQUEST_PROCESS_APPROVED','ShortCode Request Process Approved','" + sdata.sc_type + "','" + sdata.idprofile + "')";
    //                         objj0.prepare();
    //                         objj0.execute((_error: any, result: any) => {
    //                             console.log("Log Inserted Successfully!");
    //                         });
    //                         let objj = new ModelRawNonQuery(req, res);
    //                         objj.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','8','SHORTCODE_REQUEST_Carrier_COVERAGE_RATES_DEDUCTED','ShortCode Request Carrier Coverage Rates Deducted Successfully','" + sdata.sc_type + "','" + sdata.idprofile + "','" + sdata.total + "')";
    //                         objj.prepare();
    //                         objj.execute((_error: any, result: any) => {
    //                             console.log("Log Inserted Successfully!");
    //                         });
    //                         let obj2 = new ModelRawNonQuery(req, res);
    //                         obj2.nonqrysql = "INSERT INTO `did_buy` (`iduser`,`account_id`,`did`,`connection_key`,`sms_provider`,`provider`,`type`,`sinch_status`,`did_sub_type`,`camp_registry`,`disconnect_did_status`,`status`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.SC_Number + "','" + sdata.connection + "','sinch','shortcode','SC','1','2','" + sdata.idcamp + "','1','completed')";
    //                         obj2.prepare();
    //                         obj2.execute((_error: any, result: any) => {
    //                             console.log("DID Inserted Successfully!");
    //                         });
    //                         let objv0 = new RawView(res);
    //                         objv0.prepare({ status: 201, message: "SC Request Approved Successfully" });
    //                         objv0.execute();
    //                     }
    //                     else {
    //                         let objv0 = new RawView(res);
    //                         objv0.prepare({ status: 502, message: "Something Went Wrong With SC Request!" });
    //                         objv0.execute();
    //                     }
    //                 })
    //             } else {
    //                 let objvs = new RawView(res);
    //                 objvs.prepare({ message: "Service Unavailable!", status: 503 });
    //                 objvs.execute();
    //             }
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }
    approveSCrStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let did_sub_type = (sdata.sc_type == '1') ? 2 : (sdata.sc_type == '4') ? 3 : 0;
                if (sessdata.type == 1) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `rates` FROM `sc_request` WHERE `sc_request_id` = '" + sdata.sc_req_id + "' ";
                    obj1.prepare();
                    obj1.execute((err, resp) => {
                        if (err == 1) {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `rate`, `proration` , `mo` FROM `voice_rates` where `idtariff` = '" + sdata.idtaiff + "' AND `subtype` = 'message_activation' AND `category`='migrated_short_code'";
                            obj.prepare();
                            obj.execute((err, result) => {
                                let rate = new APIBase_1.APIBase();
                                rate.checkBalance(req, res, sdata.idaccount, sdata.total, (walletError, wallet) => {
                                    if (walletError == 1) {
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `sc_request` SET `status`= '4',`approved_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `profile_id`= '" + sdata.idprofile + "'";
                                        obj1.prepare();
                                        obj1.execute((errors, result) => {
                                            if (errors == 1) {
                                                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj0.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '6',`shortcode_number`='" + sdata.SC_Number + "',`number_mapped_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.idprofile + "'";
                                                obj0.prepare();
                                                obj0.execute((_error, result) => {
                                                    console.log("Number Mapped Successfully!");
                                                });
                                                let objj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','3','SHORTCODE_REQUEST_PROCESS_APPROVED','ShortCode Request Process Approved','" + sdata.sc_type + "','" + sdata.idprofile + "')";
                                                objj0.prepare();
                                                objj0.execute((_error, result) => {
                                                    console.log("Log Inserted Successfully!");
                                                });
                                                let objj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objj.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','8','SHORTCODE_REQUEST_Carrier_COVERAGE_RATES_DEDUCTED','ShortCode Request Carrier Coverage Rates Deducted Successfully','" + sdata.sc_type + "','" + sdata.idprofile + "','" + sdata.total + "')";
                                                objj.prepare();
                                                objj.execute((_error, result) => {
                                                    console.log("Log Inserted Successfully!");
                                                });
                                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "INSERT INTO `did_buy` (`iduser`,`account_id`,`did`,`connection_key`,`sms_provider`,`provider`,`type`,`sinch_status`,`did_sub_type`,`camp_registry`,`disconnect_did_status`,`pro_rates`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.SC_Number + "','" + sdata.connection + "','sinch','shortcode','SC','1','" + did_sub_type + "','" + sdata.sc_req_id + "','1','" + resp[0].rates + "')";
                                                obj2.prepare();
                                                obj2.execute((_error, result) => {
                                                    console.log("DID Inserted Successfully!");
                                                });
                                                let objv0 = new RawView_1.RawView(res);
                                                objv0.prepare({ status: 201, message: "SC Request Approved Successfully" });
                                                objv0.execute();
                                            }
                                            else {
                                                let objv0 = new RawView_1.RawView(res);
                                                objv0.prepare({ status: 502, message: "Something Went Wrong With SC Request!" });
                                                objv0.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ error_code: 0, error: walletError, message: "Insufficient Balance.", status: 503 });
                                        objv.execute();
                                    }
                                });
                            });
                        }
                        else {
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                            objv0.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    rejectSCStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                if (sessdata.type == 1) {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '7',`process_rejected_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.idProfile + "'";
                    obj1.prepare();
                    obj1.execute((errors, result) => {
                        if (errors == 1) {
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "', '7', 'CAMPAIGN_PROFILE_PROCESS_REJECTED','ShortCode Campaign Profile Process Rejected','" + sdata.idProfile + "')";
                            obj0.prepare();
                            obj0.execute((_error, result) => { });
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ status: 201, message: "SC Campaign Profile Rejected Successfully." });
                            objv0.execute();
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE did_buy SET sinch_status = '0', updated_at=NOW() WHERE `iduser`='" + sdata.iduser + "' AND `did`='" + sdata.number + "'";
                            obj2.prepare();
                            obj2.execute((error, data) => { });
                            let obj10 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj10.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "',NOW(),'43','Shortcode Number Rejected','" + sdata.number + "')";
                            obj10.prepare();
                            obj10.execute((_error, result) => {
                                console.log("Data Inserted Successfully!");
                            });
                        }
                        else {
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ status: 502, message: "Something Went Wrong!" });
                            objv0.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    // sendshortcoderequest(req: Request, res: Response, next: NextFunction) {
    //     var sdata: any = JSON.parse(req.body.data);
    //     let userID: any = sdata.data.selectedRequesID.split('-')
    //     let campaignID: any = userID[0]
    //     let ProfileID: any = userID[1]
    //     var sdata1: any = req.files;
    //     const rated = sdata.Carrier.reduce((total: any, carrier: { rate: any; }) => total + carrier.rate, 0);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             if (sessdata.type == 2) {
    //                 const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    //                 const numeric = '0123456789';
    //                 const alphabetLength = alphabet.length;
    //                 const numericLength = numeric.length;
    //                 const length = 7;
    //                 let sc_request_id = 'SR';
    //                 for (let i = 0; i < length; i++) {
    //                     const isAlphabetic = Math.random() < 0.5;
    //                     const randomIndex = isAlphabetic ? Math.floor(Math.random() * alphabetLength) : Math.floor(Math.random() * numericLength);
    //                     const charToAdd = isAlphabetic ? alphabet[randomIndex] : numeric[randomIndex];
    //                     sc_request_id += charToAdd;
    //                 }
    //                 let obj = new ModelRawQuery(req, res);
    //                 obj.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
    //                 obj.prepare();
    //                 obj.execute((_error: any, result: any) => {
    //                     let files: Express.Multer.File[] = req.files as Express.Multer.File[];
    //                     let filename: any;
    //                     let filename1: any;
    //                     let filepath: any;
    //                     let filepath1: any;
    //                     files.forEach((file: Express.Multer.File) => {
    //                         if (file.mimetype === 'text/csv') {
    //                             filename = file.filename;
    //                             filepath = SCampaign.shortcode + file.filename;
    //                         } else {
    //                             filename1 = file.filename;
    //                             filepath1 = SCampaign.shortcode + file.filename;
    //                         }
    //                     });
    //                     let FullName = result[0].firstname + ' ' + result[0].lastname;
    //                     let obj = new ModelRawNonQuery(req, res);
    //                     obj.nonqrysql = "SELECT `sc_campaign_unique_id` FROM sc_request WHERE `profile_id` = '" + ProfileID + "'"
    //                     obj.prepare();
    //                     obj.execute((_error: any, present: any) => {
    //                         if (present.length > 0) {
    //                             let obj = new ModelRawQuery(req, res);
    //                             obj.qrysql = "SELECT `id_profile` , `iduser` , `idaccount` ,`sc_campaign_unique_id` , `campaign_name` , `shortcode_number` , `migrated_campaign` , `campaign_overview` , `opt_out_keyword` , `opt_out_mt` , `help_mt` , `email` , `web_url` , `phone_number` , `t&c_web_url` , `t&c_text` , `contacts` ,`created_at` ,`compliance_poc_email` , `updated_at` , `status` , `notes` , `customer_name` ,`approved_date` , `reject_date` , `number_mapped_date` ,`process_started_date` , `process_rejected_date` ,`process_approved_date` FROM sc_campaign_profile WHERE `id_profile` = '" + ProfileID + "'";
    //                             obj.prepare();
    //                             obj.execute((_error: any, campaignPresent: any) => {
    //                                 const formatDate = (date: any) => {
    //                                     const d = new Date(date);
    //                                     const year = d.getFullYear();
    //                                     const month = String(d.getMonth() + 1).padStart(2, '0');
    //                                     const day = String(d.getDate()).padStart(2, '0');
    //                                     const hours = String(d.getHours()).padStart(2, '0');
    //                                     const minutes = String(d.getMinutes()).padStart(2, '0');
    //                                     const seconds = String(d.getSeconds()).padStart(2, '0');
    //                                     return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
    //                                 };
    //                                 const formattedDate = formatDate(campaignPresent[0].created_at);
    //                                 let obj1 = new ModelRawNonQuery(req, res);
    //                                 obj1.nonqrysql = "INSERT INTO `sc_campaign_profile` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status`,`customer_name`,`created_at`,`updated_at`) VALUES ('" + campaignPresent[0].iduser + "','" + campaignPresent[0].idaccount + "','" + campaignPresent[0].sc_campaign_unique_id + "','" + parseBody(campaignPresent[0].campaign_name) + "','" + campaignPresent[0].migrated_campaign + "','" + parseBody(campaignPresent[0].campaign_overview) + "','" + parseBody(campaignPresent[0].opt_out_keyword) + "','" + parseBody(campaignPresent[0].opt_out_mt) + "','" + parseBody(campaignPresent[0].help_mt) + "','" + parseBody(campaignPresent[0].email) + "','" + parseBody(campaignPresent[0].web_url) + "','" + campaignPresent[0].phone_number + "','" + campaignPresent[0]['t&c_web_url'] + "','" + parseBody(campaignPresent[0]['t&c_text']) + "','" + parseBody(campaignPresent[0].contacts) + "','" + parseBody(campaignPresent[0].compliance_poc_email) + "','" + parseBody(campaignPresent[0].notes) + "','4','" + parseBody(campaignPresent[0].customer_name) + "','" + formattedDate + "',NOW())";
    //                                 obj1.prepare();
    //                                 obj1.execute((_error: any, result: any) => {
    //                                     let extractedFiles: any;
    //                                     let objFile = new ModelRawQuery(req, res);
    //                                     objFile.qrysql = "SELECT `iduser`,`idaccount`,`filename`,`file_path` FROM `sc_campaign_files` WHERE profile_id = '" + ProfileID + "'";
    //                                     objFile.prepare();
    //                                     objFile.execute((_error: any, campFiles: any) => {
    //                                         extractedFiles = campFiles.map((file: any) => ({ ...file }));
    //                                         console.log("extractedFilesextractedFilesextractedFilesextractedFiles:::::",extractedFiles);
    //                                         console.log("campFilescampFilescampFilescampFiles:::::",campFiles);
    //                                         let obj4 = new ModelRawNonQuery(req, res);
    //                                         let qry1 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
    //                                         for (const file of extractedFiles) {
    //                                             console.log("fileeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee:::::",file);
    //                                             qry1 += "('" + file.iduser + "','" + file.idaccount + "','" + result.insertId + "','" + file.filename + "','" + file.file_path + "'),"
    //                                         }
    //                                         // for (const file of extractedFiles) {
    //                                         //     qry1 += "('" + campaignPresent[0].iduser + "','" + campaignPresent[0].idaccount + "','" + result.insertId + "','" + file.filename + "','" + file.file_path + "'),"
    //                                         // }
    //                                         obj4.nonqrysql = qry1.slice(0, -1)
    //                                         obj4.prepare();
    //                                         obj4.execute((_error: any, result1: any) => {
    //                                             console.log("Data Inserted Successfully!");
    //                                             let objk0 = new ModelRawNonQuery(req, res);
    //                                             objk0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + campFiles[0].iduser + "', '" + campFiles[0].idaccount + "','1','REQUEST_CREATED','ShortCode Campaign Request Created Successfully', '" + result.insertId + "')";
    //                                             objk0.prepare();
    //                                             objk0.execute((error: any, result: any) => {
    //                                                 console.log("Data Inserted Successfully!");
    //                                             });
    //                                         });
    //                                     })
    //                                     let objjk = new ModelRawQuery(req, res);
    //                                     objjk.qrysql = "SELECT `message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message` FROM sc_content_defination WHERE `profile_id` = '" + ProfileID + "'";
    //                                     objjk.prepare();
    //                                     objjk.execute((_error: any, campaignPresent: any) => {
    //                                         console.log("defination data", campaignPresent)
    //                                         let data1: any = campaignPresent[0]
    //                                         if (campaignPresent.length === 0) {
    //                                             console.log('No data found for content data')
    //                                         } else {
    //                                             let objjj3 = new ModelRawNonQuery(req, res);
    //                                             let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
    //                                             for (let i = 0; i < campaignPresent.length; i++) {
    //                                                 const data = campaignPresent[i];
    //                                                 console.log("dataaaaaaaaaaaaaaaaaaaa", data)
    //                                                 qry2 += "('" + data1.iduser + "','" + data1.idaccount + "','" + result.insertId + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + parseBody(data.call_to_action.trim()) + "','" + parseBody(data.opt_in_message.trim()) + "','" + parseBody(data.example_message.trim()) + "'),"
    //                                             }
    //                                             objjj3.nonqrysql = qry2.slice(0, -1)
    //                                             objjj3.prepare();
    //                                             objjj3.execute((error: any, result: any) => { })
    //                                         }
    //                                     })
    //                                     let fun = new ShortCodeNumber();
    //                                     fun.insertintoSC(req, res, FullName, filepath, filepath1, filename, filename1, result.insertId, sc_request_id, sdata, campaignID, rated, sessdata);
    //                                 });
    //                             });
    //                         }
    //                         else {
    //                             let obj01 = new ModelRawNonQuery(req, res);
    //                             obj01.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '4' ,`updated_at`= NOW() WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "' AND `id_profile`= '" + ProfileID + "'";
    //                             obj01.prepare();
    //                             obj01.execute((_error: any, result: any) => {
    //                                 console.log("Status Updated Successfully!");
    //                                 let fun = new ShortCodeNumber();
    //                                 fun.insertintoSC(req, res, FullName, filepath, filepath1, filename, filename1, ProfileID, sc_request_id, sdata, campaignID, rated, sessdata);
    //                             });
    //                         }
    //                     })
    //                     // let obj1 = new ModelRawNonQuery(req, res);
    //                     // obj1.nonqrysql = "INSERT INTO `sc_request` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`sc_type`,`sender_id`,`migrated_file_path`,`migrated_filename`,`sc_proof_doc_filepath`,`sc_proof_filename`,`status`,`customer_name`, `shortocde_number`,`profile_id`,`connection`,`carrier_cost`,`sc_request_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + campaignID + "', '" + sdata.data.shortcodetype + "', '" + parseBody(sdata.data.SenderID) + "' ,'" + filepath + "','" + filename + "','" + filepath1 + "','" + filename1 + "','1','" + FullName + "','" + sdata.didnumber + "','" + ProfileID + "','" + (sdata.data.connectionName).trim() + "','" + rated + "','" + sc_request_id + "')";
    //                     // obj1.prepare();
    //                     // obj1.execute((_error: any, result: any) => {
    //                     //     if (_error == 1) {
    //                     //         let obj0 = new ModelRawNonQuery(req, res);
    //                     //         obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','1','SHORTCODE_REQUEST_CREATED','ShortCode Request Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "')";
    //                     //         obj0.prepare();
    //                     //         obj0.execute((_error: any, result: any) => {
    //                     //             console.log("Data Inserted Successfully!");
    //                     //         });
    //                     //         let obj01 = new ModelRawNonQuery(req, res);
    //                     //         obj01.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '4' WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "' AND `id_profile`= '" + ProfileID + "'";
    //                     //         obj01.prepare();
    //                     //         obj01.execute((_error: any, result: any) => {
    //                     //             console.log("Status Updated Successfully!");
    //                     //         });
    //                     //         // Carrier coverage rates
    //                     //         if (sdata.Carrier.length === 0) {
    //                     //             console.log("No carrier coverage found")
    //                     //         } else {
    //                     //             let obj = new ModelRawQuery(req, res);
    //                     //             obj.qrysql = "SELECT `id_request` from `sc_request` WHERE `profile_id`='" + ProfileID + "'";
    //                     //             obj.prepare();
    //                     //             obj.execute((_error: any, result: any) => {
    //                     //                 if (_error == 1) {
    //                     //                     let obj4 = new ModelRawNonQuery(req, res);
    //                     //                     let qry3 = "INSERT INTO `sc_request_carrier_coverage` (`iduser`,`idaccount`,`id_request`,`sc_carrier_coverage`,`rate`) VALUES ";
    //                     //                     for (let i = 0; i < sdata.Carrier.length; i++) {
    //                     //                         const data = sdata.Carrier[i];
    //                     //                         qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_request + "','" + data.display_name + "','" + data.rate + "'),"
    //                     //                     }
    //                     //                     obj4.nonqrysql = qry3.slice(0, -1)
    //                     //                     obj4.prepare();
    //                     //                     obj4.execute((error: any, result: any) => { })
    //                     //                 }
    //                     //             })
    //                     //         }
    //                     //         let objb = new ModelRawNonQuery(req, res);
    //                     //         objb.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','6','SHORTCODE_REQUEST_CARRIER_COVERAGE_RATES','ShortCode Request Carrier Coverage Rates Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "','" + rated + "')";
    //                     //         objb.prepare();
    //                     //         objb.execute((_error: any, result: any) => {
    //                     //             console.log("Log Inserted Successfully!");
    //                     //         });
    //                     //         let objv = new RawView(res);
    //                     //         objv.prepare({ data: result, message: "Shortcode Request Inserted Successfully", status: 200 });
    //                     //         objv.execute();
    //                     //     }
    //                     //     else {
    //                     //         let objv = new RawView(res);
    //                     //         objv.prepare({
    //                     //             message: "Something Went Wrong With Shortcode Request Details!", status: 502, error: result
    //                     //         });
    //                     //         objv.execute();
    //                     //     }
    //                     // })
    //                 });
    //             } else {
    //                 let objvs = new RawView(res);
    //                 objvs.prepare({ message: "Service Unavailable!", status: 503 });
    //                 objvs.execute();
    //             }
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     })
    // }
    sendshortcoderequest(req, res, next) {
        var sdata = JSON.parse(req.body.data);
        let userID = sdata.data.selectedRequesID.split('-');
        let campaignID = userID[0];
        let ProfileID = userID[1];
        var sdata1 = req.files;
        const rated = sdata.Carrier.reduce((total, carrier) => total + carrier.rate, 0);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    const alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    const numeric = '0123456789';
                    const alphabetLength = alphabet.length;
                    const numericLength = numeric.length;
                    const length = 7;
                    let sc_request_id = 'SR';
                    for (let i = 0; i < length; i++) {
                        const isAlphabetic = Math.random() < 0.5;
                        const randomIndex = isAlphabetic ? Math.floor(Math.random() * alphabetLength) : Math.floor(Math.random() * numericLength);
                        const charToAdd = isAlphabetic ? alphabet[randomIndex] : numeric[randomIndex];
                        sc_request_id += charToAdd;
                    }
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `firstname`,`lastname` from `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        let files = req.files;
                        let filename;
                        let filename1;
                        let filepath;
                        let filepath1;
                        files.forEach((file) => {
                            if (file.mimetype === 'text/csv') {
                                filename = file.filename;
                                filepath = SCampaign.shortcode + file.filename;
                            }
                            else {
                                filename1 = file.filename;
                                filepath1 = SCampaign.shortcode + file.filename;
                            }
                        });
                        let FullName = result[0].firstname + ' ' + result[0].lastname;
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "SELECT `sc_campaign_unique_id` FROM sc_request WHERE `profile_id` = '" + ProfileID + "'";
                        obj.prepare();
                        obj.execute((_error, present) => {
                            if (present.length > 0) {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT `id_profile` , `iduser` , `idaccount` ,`sc_campaign_unique_id` , `campaign_name` , `shortcode_number` , `migrated_campaign` , `campaign_overview` , `opt_out_keyword` , `opt_out_mt` , `help_mt` , `email` , `web_url` , `phone_number` , `t&c_web_url` , `t&c_text` , `contacts` ,`created_at` ,`compliance_poc_email` , `updated_at` , `status` , `notes` , `customer_name` ,`approved_date` , `reject_date` , `number_mapped_date` ,`process_started_date` , `process_rejected_date` ,`process_approved_date` FROM sc_campaign_profile WHERE `id_profile` = '" + ProfileID + "'";
                                obj.prepare();
                                obj.execute((_error, campaignPresent) => {
                                    const formatDate = (date) => {
                                        const d = new Date(date);
                                        const year = d.getFullYear();
                                        const month = String(d.getMonth() + 1).padStart(2, '0');
                                        const day = String(d.getDate()).padStart(2, '0');
                                        const hours = String(d.getHours()).padStart(2, '0');
                                        const minutes = String(d.getMinutes()).padStart(2, '0');
                                        const seconds = String(d.getSeconds()).padStart(2, '0');
                                        return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
                                    };
                                    const formattedDate = formatDate(campaignPresent[0].created_at);
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "INSERT INTO `sc_campaign_profile` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`campaign_name`,`migrated_campaign`,`campaign_overview`,`opt_out_keyword`,`opt_out_mt`,`help_mt`,`email`,`web_url`,`phone_number`,`t&c_web_url`,`t&c_text`,`contacts`,`compliance_poc_email`,`notes`,`status`,`customer_name`,`created_at`,`updated_at`) VALUES ('" + campaignPresent[0].iduser + "','" + campaignPresent[0].idaccount + "','" + campaignPresent[0].sc_campaign_unique_id + "','" + (0, markError_1.parseBody)(campaignPresent[0].campaign_name) + "','" + campaignPresent[0].migrated_campaign + "','" + (0, markError_1.parseBody)(campaignPresent[0].campaign_overview) + "','" + (0, markError_1.parseBody)(campaignPresent[0].opt_out_keyword) + "','" + (0, markError_1.parseBody)(campaignPresent[0].opt_out_mt) + "','" + (0, markError_1.parseBody)(campaignPresent[0].help_mt) + "','" + (0, markError_1.parseBody)(campaignPresent[0].email) + "','" + (0, markError_1.parseBody)(campaignPresent[0].web_url) + "','" + campaignPresent[0].phone_number + "','" + campaignPresent[0]['t&c_web_url'] + "','" + (0, markError_1.parseBody)(campaignPresent[0]['t&c_text']) + "','" + (0, markError_1.parseBody)(campaignPresent[0].contacts) + "','" + (0, markError_1.parseBody)(campaignPresent[0].compliance_poc_email) + "','" + (0, markError_1.parseBody)(campaignPresent[0].notes) + "','4','" + (0, markError_1.parseBody)(campaignPresent[0].customer_name) + "','" + formattedDate + "',NOW())";
                                    obj1.prepare();
                                    obj1.execute((_error, result) => {
                                        let extractedFiles;
                                        let objFile = new RawQuery_1.ModelRawQuery(req, res);
                                        objFile.qrysql = "SELECT `iduser`,`idaccount`,`filename`,`file_path` FROM `sc_campaign_files` WHERE profile_id = '" + ProfileID + "'";
                                        objFile.prepare();
                                        objFile.execute((_error, campFiles) => {
                                            extractedFiles = campFiles.map((file) => ({ ...file }));
                                            if (!extractedFiles || extractedFiles.length === 0) {
                                                console.log('no data found');
                                            }
                                            else {
                                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                let qry1 = "INSERT INTO `sc_campaign_files` (`iduser`, `idaccount`, `profile_id`,`filename` ,`file_path`) VALUES";
                                                for (const file of extractedFiles) {
                                                    qry1 += "('" + file.iduser + "','" + file.idaccount + "','" + result.insertId + "','" + file.filename + "','" + file.file_path + "'),";
                                                }
                                                obj4.nonqrysql = qry1.slice(0, -1);
                                                obj4.prepare();
                                                obj4.execute((_error, result1) => {
                                                    console.log("Data Inserted Successfully!");
                                                    let objk0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objk0.nonqrysql = "INSERT INTO `sc_campaign_profile_log` (`iduser`,`idaccount`,`event_type`,`event_desc`,`description`,`profile_id`) VALUES ('" + campFiles[0].iduser + "', '" + campFiles[0].idaccount + "','1','REQUEST_CREATED','ShortCode Campaign Request Created Successfully', '" + result.insertId + "')";
                                                    objk0.prepare();
                                                    objk0.execute((error, result) => {
                                                        console.log("Data Inserted Successfully!");
                                                    });
                                                });
                                            }
                                        });
                                        let objjk = new RawQuery_1.ModelRawQuery(req, res);
                                        objjk.qrysql = "SELECT `iduser`,`idaccount`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message` FROM sc_content_defination WHERE `profile_id` = '" + ProfileID + "'";
                                        objjk.prepare();
                                        objjk.execute((_error, campaignPresent) => {
                                            let data1 = campaignPresent[0];
                                            if (campaignPresent.length === 0) {
                                                console.log('No data found for content data');
                                            }
                                            else {
                                                let objjj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                let qry2 = "INSERT INTO `sc_content_defination` (`iduser`,`idaccount`,`profile_id`,`message_type`,`content_type`,`subscription_type`,`call_to_action`,`opt_in_message`,`example_message`) VALUES ";
                                                for (let i = 0; i < campaignPresent.length; i++) {
                                                    const data = campaignPresent[i];
                                                    qry2 += "('" + data1.iduser + "','" + data1.idaccount + "','" + result.insertId + "','" + data.message_type + "','" + data.content_type + "','" + data.subscription_type + "','" + (0, markError_1.parseBody)(data.call_to_action.trim()) + "','" + (0, markError_1.parseBody)(data.opt_in_message.trim()) + "','" + (0, markError_1.parseBody)(data.example_message.trim()) + "'),";
                                                }
                                                objjj3.nonqrysql = qry2.slice(0, -1);
                                                objjj3.prepare();
                                                objjj3.execute((error, result) => { });
                                            }
                                        });
                                        let fun = new ShortCodeNumber();
                                        fun.insertintoSC(req, res, FullName, filepath, filepath1, filename, filename1, result.insertId, sc_request_id, sdata, campaignID, rated, sessdata);
                                    });
                                });
                            }
                            else {
                                let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj01.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '4' ,`updated_at`= NOW() WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "' AND `id_profile`= '" + ProfileID + "'";
                                obj01.prepare();
                                obj01.execute((_error, result) => {
                                    console.log("Status Updated Successfully!");
                                    let fun = new ShortCodeNumber();
                                    fun.insertintoSC(req, res, FullName, filepath, filepath1, filename, filename1, ProfileID, sc_request_id, sdata, campaignID, rated, sessdata);
                                });
                            }
                        });
                        // let obj1 = new ModelRawNonQuery(req, res);
                        // obj1.nonqrysql = "INSERT INTO `sc_request` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`sc_type`,`sender_id`,`migrated_file_path`,`migrated_filename`,`sc_proof_doc_filepath`,`sc_proof_filename`,`status`,`customer_name`, `shortocde_number`,`profile_id`,`connection`,`carrier_cost`,`sc_request_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + campaignID + "', '" + sdata.data.shortcodetype + "', '" + parseBody(sdata.data.SenderID) + "' ,'" + filepath + "','" + filename + "','" + filepath1 + "','" + filename1 + "','1','" + FullName + "','" + sdata.didnumber + "','" + ProfileID + "','" + (sdata.data.connectionName).trim() + "','" + rated + "','" + sc_request_id + "')";
                        // obj1.prepare();
                        // obj1.execute((_error: any, result: any) => {
                        //     if (_error == 1) {
                        //         let obj0 = new ModelRawNonQuery(req, res);
                        //         obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','1','SHORTCODE_REQUEST_CREATED','ShortCode Request Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "')";
                        //         obj0.prepare();
                        //         obj0.execute((_error: any, result: any) => {
                        //             console.log("Data Inserted Successfully!");
                        //         });
                        //         let obj01 = new ModelRawNonQuery(req, res);
                        //         obj01.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '4' WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "' AND `id_profile`= '" + ProfileID + "'";
                        //         obj01.prepare();
                        //         obj01.execute((_error: any, result: any) => {
                        //             console.log("Status Updated Successfully!");
                        //         });
                        //         // Carrier coverage rates
                        //         if (sdata.Carrier.length === 0) {
                        //             console.log("No carrier coverage found")
                        //         } else {
                        //             let obj = new ModelRawQuery(req, res);
                        //             obj.qrysql = "SELECT `id_request` from `sc_request` WHERE `profile_id`='" + ProfileID + "'";
                        //             obj.prepare();
                        //             obj.execute((_error: any, result: any) => {
                        //                 if (_error == 1) {
                        //                     let obj4 = new ModelRawNonQuery(req, res);
                        //                     let qry3 = "INSERT INTO `sc_request_carrier_coverage` (`iduser`,`idaccount`,`id_request`,`sc_carrier_coverage`,`rate`) VALUES ";
                        //                     for (let i = 0; i < sdata.Carrier.length; i++) {
                        //                         const data = sdata.Carrier[i];
                        //                         qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_request + "','" + data.display_name + "','" + data.rate + "'),"
                        //                     }
                        //                     obj4.nonqrysql = qry3.slice(0, -1)
                        //                     obj4.prepare();
                        //                     obj4.execute((error: any, result: any) => { })
                        //                 }
                        //             })
                        //         }
                        //         let objb = new ModelRawNonQuery(req, res);
                        //         objb.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','6','SHORTCODE_REQUEST_CARRIER_COVERAGE_RATES','ShortCode Request Carrier Coverage Rates Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "','" + rated + "')";
                        //         objb.prepare();
                        //         objb.execute((_error: any, result: any) => {
                        //             console.log("Log Inserted Successfully!");
                        //         });
                        //         let objv = new RawView(res);
                        //         objv.prepare({ data: result, message: "Shortcode Request Inserted Successfully", status: 200 });
                        //         objv.execute();
                        //     }
                        //     else {
                        //         let objv = new RawView(res);
                        //         objv.prepare({
                        //             message: "Something Went Wrong With Shortcode Request Details!", status: 502, error: result
                        //         });
                        //         objv.execute();
                        //     }
                        // })
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    insertintoSC(req, res, FullName, filepath, filepath1, filename, filename1, ProfileID, sc_request_id, sdata, campaignID, rated, sessdata) {
        let category = '';
        if (sdata.data.shortcodetype == '1' || sdata.data.shortcodetype == '4') {
            category = 'migrated_short_code';
        }
        else if (sdata.data.shortcodetype == '2') {
            category = 'short_code_lease';
        }
        else if (sdata.data.shortcodetype == '3') {
            category = 'vanity_short_code';
        }
        let objj3 = new RawQuery_1.ModelRawQuery(req, res);
        objj3.qrysql = "SELECT `rate` , `mo` FROM voice_rates WHERE `category` =  '" + category + "' AND subtype = 'message_activation' AND `idtariff` = '" + sessdata.idtariff + "'";
        objj3.prepare();
        objj3.execute((error4, result8) => {
            let rateR = result8[0].rate, mo = result8[0].mo;
            let ratenumber = rateR + mo;
            let objj4 = new RawQuery_1.ModelRawQuery(req, res);
            objj4.qrysql = "SELECT st.rates,st.display_name FROM sc_shortcode_type st JOIN sc_campaign_profile cp ON st.value = cp.migrated_campaign WHERE cp.sc_campaign_unique_id = '" + campaignID + "'";
            objj4.prepare();
            objj4.execute((error5, resul9) => {
                let totalrateR = ratenumber + resul9[0].rates + rated;
                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj1.nonqrysql = "INSERT INTO `sc_request` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`sc_type`,`sender_id`,`migrated_file_path`,`migrated_filename`,`sc_proof_doc_filepath`,`sc_proof_filename`,`status`,`customer_name`, `shortocde_number`,`profile_id`,`connection`,`carrier_cost`,`sc_request_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + campaignID + "', '" + sdata.data.shortcodetype + "', '" + (0, markError_1.parseBody)(sdata.data.SenderID) + "' ,'" + filepath + "','" + filename + "','" + filepath1 + "','" + filename1 + "','1','" + (0, markError_1.parseBody)(FullName) + "','" + sdata.didnumber + "','" + ProfileID + "','" + (sdata.data.connectionName).trim() + "','" + totalrateR + "','" + sc_request_id + "')";
                obj1.prepare();
                obj1.execute((_error, result) => {
                    if (_error == 1) {
                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','1','SHORTCODE_REQUEST_CREATED','ShortCode Request Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "')";
                        obj0.prepare();
                        obj0.execute((_error, result) => {
                            console.log("Data Inserted Successfully!");
                        });
                        // let obj01 = new ModelRawNonQuery(req, res);
                        // obj01.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '4' WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "' AND `id_profile`= '" + ProfileID + "'";
                        // obj01.prepare();
                        // obj01.execute((_error: any, result: any) => {
                        //     console.log("Status Updated Successfully!");
                        // });
                        // Carrier coverage rates
                        if (sdata.Carrier.length === 0) {
                            console.log("No carrier coverage found");
                        }
                        else {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `id_request` from `sc_request` WHERE `profile_id`='" + ProfileID + "'";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qry3 = "INSERT INTO `sc_request_carrier_coverage` (`iduser`,`idaccount`,`id_request`,`sc_carrier_coverage`,`rate`) VALUES ";
                                    for (let i = 0; i < sdata.Carrier.length; i++) {
                                        const data = sdata.Carrier[i];
                                        qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + result[0].id_request + "','" + data.display_name + "','" + data.rate + "'),";
                                    }
                                    obj4.nonqrysql = qry3.slice(0, -1);
                                    obj4.prepare();
                                    obj4.execute((error, result) => { });
                                }
                            });
                        }
                        let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        objb.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + campaignID + "','6','SHORTCODE_REQUEST_CARRIER_COVERAGE_RATES','ShortCode Request Carrier Coverage Rates Created Successfully','" + sdata.data.shortcodetype + "','" + ProfileID + "','" + rated + "')";
                        objb.prepare();
                        objb.execute((_error, result) => {
                            console.log("Log Inserted Successfully!");
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Shortcode Request Inserted Successfully", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Shortcode Request Details!", status: 502, error: result
                        });
                        objv.execute();
                    }
                });
            });
        });
    }
    updateSCsender(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2) {
                    let sdata = JSON.parse(req.body.data);
                    var sdata1 = req.files;
                    let previousFile = [];
                    const rated = sdata.Carrier.reduce((total, carrier) => total + carrier.rate, 0);
                    const numberDID = sdata.data.shortcodetype == '1' ? sdata.didnumber : '';
                    if (sdata.data.shortcodetype == '1') {
                        previousFile.push(...sdata.previosFile);
                        var filename;
                        var filename1;
                        var filepath;
                        var filepath1;
                        if (req.files.length === 0 || !req.files) {
                            previousFile.forEach((fileObj) => {
                                if (fileObj.name) {
                                    const { file, name } = fileObj;
                                    const extension = name.split('.').pop();
                                    if (extension === 'csv') {
                                        filename = name;
                                        filepath = file;
                                    }
                                    else {
                                        filename1 = name;
                                        filepath1 = file;
                                    }
                                }
                            });
                        }
                        else {
                            let files = req.files;
                            files.forEach((file) => {
                                if (file.mimetype === 'text/csv') {
                                    filename = file.filename;
                                    filepath = SCampaign.shortcode + file.filename;
                                }
                                else {
                                    filename1 = file.filename;
                                    filepath1 = SCampaign.shortcode + file.filename;
                                }
                            });
                        }
                    }
                    else {
                        filename = '';
                        filename1 = '';
                        filepath = '';
                        filepath1 = '';
                    }
                    let objj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    objj11.nonqrysql = "UPDATE sc_request SET `sc_campaign_unique_id`='" + sdata.data.selectedRequesID + "',`sc_type`='" + sdata.data.shortcodetype + "',`sender_id`='" + (0, markError_1.parseBody)(sdata.data.SenderID) + "',`migrated_file_path`='" + filepath + "',`migrated_filename`='" + filename + "',`sc_proof_doc_filepath`='" + filepath1 + "',`sc_proof_filename`='" + filename1 + "',`status`= '1',`shortocde_number`='" + numberDID + "',`connection`='" + (sdata.data.connectionName).trim() + "',`updated_at`=NOW(),`carrier_cost`='" + rated + "' WHERE `profile_id` = '" + sdata.idprofile + "'";
                    objj11.prepare();
                    objj11.execute((_error, result) => {
                        if (_error == 1) {
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + sdata.data.selectedRequesID + "','2','SHORTCODE_REQUEST_UPDATED','ShortCode Request Updated Successfully','" + sdata.data.shortcodetype + "','" + sdata.idprofile + "')";
                            obj0.prepare();
                            obj0.execute((_error, result) => {
                                console.log("Log Inserted Successfully!");
                            });
                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "DELETE FROM `sc_request_carrier_coverage` WHERE `id_request` = '" + sdata.idrequest + "'";
                            obj4.prepare();
                            obj4.execute((error, result) => {
                                if (error == 1) {
                                    if (sdata.Carrier.length === 0) {
                                        console.log("No carrier coverage found");
                                    }
                                    else {
                                        let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qry3 = "INSERT INTO `sc_request_carrier_coverage` (`iduser`,`idaccount`,`id_request`,`sc_carrier_coverage`,`rate`) VALUES ";
                                        for (let i = 0; i < sdata.Carrier.length; i++) {
                                            const data = sdata.Carrier[i];
                                            qry3 += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + sdata.idrequest + "','" + data.display_name + "','" + data.rate + "'),";
                                        }
                                        obj5.nonqrysql = qry3.slice(0, -1);
                                        obj5.prepare();
                                        obj5.execute((error, result) => { });
                                    }
                                }
                                else {
                                    console.log("Issue in deletion of the carrier coverage");
                                }
                            });
                            let objb = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            objb.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`,`rates`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + sdata.data.selectedRequesID + "','7','SHORTCODE_REQUEST_CARRIER_COVERAGE_RATES_UPDATED','ShortCode Request Carrier Coverage Rates Updated Successfully','" + sdata.data.shortcodetype + "','" + sdata.idprofile + "','" + rated + "')";
                            objb.prepare();
                            objb.execute((_error, result) => {
                                console.log("Log Inserted Successfully!");
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "SC Request Updated Successfully", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Something Went Wrong With SC Request Details!",
                                status: 502,
                                error: result
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getsingleSCDetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let sdata1 = JSON.parse(sdata.type);
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `carrier_cost`,idaccount,iduser,sc_campaign_unique_id,sc_type,sender_id,migrated_file_path,migrated_filename,sc_proof_doc_filepath,sc_proof_filename,status,shortocde_number,did_provider,rates,description,filename,file_path,profile_id,id_request,connection FROM sc_request WHERE profile_id = '" + sdata1.idprofile + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `idtariff` FROM `user` WHERE `iduser` = '" + sdata1.iduser + "'";
                        obj1.prepare();
                        obj1.execute((error, result2) => {
                            if (_error == 1) {
                                let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                obj4.qrysql = "SELECT `sc_carrier_coverage`,`rate` FROM `sc_request_carrier_coverage` WHERE `id_request` = '" + sdata1.idrequest + "' ";
                                obj4.prepare();
                                obj4.execute((_errror, result3) => {
                                    if (error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ data: result, data1: result2, data3: result3, message: "SC list Fetched Successfully", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "Something Went Wrong With Rates!",
                                            status: 502,
                                            error: result
                                        });
                                        objv.execute();
                                    }
                                });
                                // let objv = new RawView(res);
                                // objv.prepare({ data: result, data1: result2, message: "SC list Fetched Successfully", status: 200 });
                                // objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Rates!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getIDRequest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idaccount`, `iduser`, `sc_campaign_unique_id`, `status`,`id_profile` FROM sc_campaign_profile WHERE `idaccount`='" + sessData.idaccount + "' AND `status` NOT IN (1,2) ORDER BY `created_at` DESC";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'Request Id Fetched Successfully', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Request Id!", status: 503 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getSCRequest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let condition = '';
                if (sessdata.type == 1)
                    condition += '';
                if (sessdata.type == 2)
                    condition += "WHERE sr.idaccount='" + sessdata.idaccount + "'";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                //obj.qrysql = "SELECT `iduser`,`id_request`, `idaccount`, `sc_campaign_unique_id`, `status`, `sc_type`, `created_at` , `customer_name`,`shortocde_number`,`profile_id`,`sc_request_id`,`connection`,`carrier_cost`,`payment_status` FROM sc_request " + condition + "";
                obj.qrysql = "SELECT sr.iduser, sr.id_request, sr.idaccount, sr.sc_campaign_unique_id, sr.status, sr.sc_type, sr.created_at, sr.customer_name, sr.shortocde_number, sr.profile_id, sr.sc_request_id, sr.connection, sr.carrier_cost, sr.payment_status, scp.status AS status_req FROM sc_request sr INNER JOIN sc_campaign_profile scp ON sr.profile_id = scp.id_profile " + condition;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "SC Request List Fetched Successfully",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With SC Request List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    rejectstatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let sdata = req.body.data;
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `sc_request` SET `status`= '3',`reject_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `profile_id`= '" + sdata.idprofile + "'";
                    obj1.prepare();
                    obj1.execute((errors, result) => {
                        console.log("Status Updated Successfully!");
                        if (errors == 1) {
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.idcamp + "','4','SHORTCODE_REQUEST_PROCESS_REJECTED','ShortCode Request Process Rejected','" + sdata.sc_type + "','" + sdata.idprofile + "')";
                            obj0.prepare();
                            obj0.execute((_error, result) => {
                                console.log("Log Inserted Successfully!");
                            });
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ status: 201, message: "SC Request Rejected Successfully" });
                            objv0.execute();
                        }
                        else {
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ status: 502, message: "Something Went Wrong With Reject Details!" });
                            objv0.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    GetRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "SELECT `rate`,`category`,`priority` FROM `voice_rates` where `idtariff` = '" + sdata.type + "' AND `subtype` = 'message_activation'";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Rates Fetched Successfully", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Get Campaign List!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    Saverandomvanity(req, res, next) {
        var sdata = JSON.parse(req.body.data);
        let did_sub_type = (sdata.data.SCtype === '3') ? 1 : (sdata.data.SCtype == '2') ? 0 : 0;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var filepath;
                var filename;
                let files = req.files;
                files.forEach((file) => {
                    if (file.mimetype === 'text/csv') {
                        filename = file.filename;
                        filepath = SCampaign.shortcode + file.filename;
                    }
                });
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `rates` FROM `sc_request` WHERE `sc_request_id` = '" + sdata.sc_request + "' ";
                obj1.prepare();
                obj1.execute((err, rate_resp) => {
                    if (err == 1) {
                        let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj11.nonqrysql = "UPDATE sc_request SET `sc_campaign_unique_id`='" + sdata.data.SCReqID + "',`did_provider`='" + sdata.data.DIDprovider + "',`file_path`='" + filepath + "',`filename`='" + filename + "',`status`= '4',`shortocde_number`='" + sdata.didnumber + "',`rates`='" + sdata.data.rates + "',`connection`='" + (sdata.connectionname).trim() + "',`description`='" + (0, markError_1.parseBody)(sdata.data.description) + "',`approved_date`=NOW() WHERE `profile_id` = '" + sdata.idprofile + "'";
                        obj11.prepare();
                        obj11.execute((_error, result) => {
                            if (_error == 1) {
                                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj0.nonqrysql = "UPDATE `sc_campaign_profile` SET `status`= '6',`shortcode_number`='" + sdata.didnumber + "',`number_mapped_date`=NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "' AND `id_profile`= '" + sdata.idprofile + "'";
                                obj0.prepare();
                                obj0.execute((_error, result) => {
                                    console.log("Number Mapped Successfully!");
                                });
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "INSERT INTO `did_buy` (`iduser`,`account_id`,`did`,`connection_key`,`sms_provider`,`provider`,`type`,`rates`,`sinch_status`,`did_sub_type`,`camp_registry`,`disconnect_did_status`,`status`,`pro_rates`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.didnumber + "','" + (sdata.connectionname).trim() + "','sinch','shortcode','SC','" + sdata.data.rates + "','1','" + did_sub_type + "','" + sdata.sc_request + "','1','completed','" + rate_resp[0].rates + "')";
                                obj2.prepare();
                                obj2.execute((_error, result) => {
                                    console.log("DID Inserted Successfully!");
                                });
                                let obj10 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj10.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUES ('" + sdata.idaccount + "','" + sdata.iduser + "',NOW(),'42','SMS fully provisioned For Shortcode','" + sdata.didnumber + "')";
                                obj10.prepare();
                                obj10.execute((_error, result) => {
                                    console.log("Data Inserted Successfully!");
                                });
                                let objj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                objj0.nonqrysql = "INSERT INTO `sc_request_log` (`iduser`,`idaccount`,`sc_campaign_unique_id`,`event_type`,`event_desc`,`description`,`sc_type`,`rates`,`profile_id`) VALUES ('" + sdata.iduser + "', '" + sdata.idaccount + "','" + sdata.data.SCReqID + "','5','SHORTCODE_REQUEST_PROCESS_APPROVED','ShortCode Request Process Approved','" + sdata.data.SCtype + "','" + sdata.data.rates + "','" + sdata.idprofile + "')";
                                objj0.prepare();
                                objj0.execute((_error, result) => {
                                    if (_error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ data: result, message: "SC Request Inserted Successfully", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With SC Request!", status: 502, error: result });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With SC Request!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    Connnections(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = JSON.parse(req.query.type);
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT iduser,idaccount,name, connection_key,isDefault FROM endpoint WHERE `idaccount`= '" + data.idaccount + "' AND `iduser`='" + data.iduser + "' ORDER BY `idendpoint` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    AllConnnections(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT name, connection_key FROM endpoint ORDER BY `idendpoint` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAllCost(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let category = '';
            let sdata = JSON.parse(req.query.type);
            if (sdata.SCtype == '1' || sdata.SCtype == '4') {
                category = 'migrated_short_code';
            }
            else if (sdata.SCtype == '2') {
                category = 'short_code_lease';
            }
            else if (sdata.SCtype == '3') {
                category = 'vanity_short_code';
            }
            if (error == 1) {
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `sc_type`,`note` FROM `sc_request` WHERE `id_request` = '" + sdata.idrequest + "' ";
                obj0.prepare();
                obj0.execute((error1, result0) => {
                    if (error1 == 1) {
                        const scType = result0[0].sc_type;
                        let Note = result0[0].note;
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `display_name`,`rate` FROM `sc_carrier_coverage` WHERE `sc_type` = '" + scType + "'";
                        obj1.prepare();
                        obj1.execute((error2, result1) => {
                            if (error2 == 1) {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT `sc_carrier_coverage`,`rate`,`payment_status` FROM `sc_request_carrier_coverage` WHERE `id_request` = '" + sdata.idrequest + "' ";
                                obj.prepare();
                                obj.execute((_error, result) => {
                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj2.qrysql = "SELECT `idtariff` FROM `user` WHERE `idaccount` = '" + sdata.idaccount + "'";
                                    obj2.prepare();
                                    obj2.execute((error3, result2) => {
                                        let idtariff = result2[0].idtariff;
                                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj3.qrysql = "SELECT `rate` , `mo` FROM voice_rates WHERE `category` =  '" + category + "' AND subtype = 'message_activation' AND `idtariff` = '" + idtariff + "'";
                                        obj3.prepare();
                                        obj3.execute((error4, result3) => {
                                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj4.qrysql = "SELECT st.rates,st.display_name FROM sc_shortcode_type st JOIN sc_campaign_profile cp ON st.value = cp.migrated_campaign WHERE cp.sc_campaign_unique_id = '" + sdata.sc_camp_id + "'";
                                            obj4.prepare();
                                            obj4.execute((error5, result4) => {
                                                if (error5 == 1) {
                                                    let rate = result3[0].rate, mo = result3[0].mo;
                                                    let result2 = rate + mo;
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        data: result, data1: result1, data2: result2, data3: result4, note: Note, data4: rate,
                                                        message: "All Cost Fetched Successfully",
                                                        status: 200
                                                    });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        message: "Something Went Wrong!",
                                                        status: 502,
                                                        error: result
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        });
                                    });
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong ",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong !",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    paymentSCRequest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let migrated_type_rate = sdata.migrated_type_rate;
                let carrier_cost = sdata.carrier_cost;
                let mo_rate = sdata.rate;
                let idrequest = sdata.idrequest;
                let profile_id = sdata.profile_id;
                let type = sdata.type;
                let camp_status;
                let sms_status;
                let carrier_status;
                let sc_status;
                let did_sub_type;
                let frequencyMap = {};
                let oddOccurrenceCarriers = [];
                // Count the occurrences
                sdata.carriers.forEach((carrier) => {
                    let key = carrier.display_name;
                    if (frequencyMap[key]) {
                        frequencyMap[key]++;
                    }
                    else {
                        frequencyMap[key] = 1;
                    }
                });
                // Filter for odd occurrences and insert only once
                for (let carrier of sdata.carriers) {
                    let key = carrier.display_name;
                    if (frequencyMap[key] % 2 !== 0 && !oddOccurrenceCarriers.some(c => c.display_name === key)) {
                        oddOccurrenceCarriers.push(carrier);
                    }
                }
                if (sdata.sc_type == 1 || sdata.sc_type == 4) {
                    did_sub_type = 3;
                }
                else if (sdata.sc_type == 3) {
                    did_sub_type = 1;
                }
                else if (sdata.sc_type == 2) {
                    did_sub_type = 0;
                }
                let deduction = '';
                if (sdata.type == 1) {
                    deduction = mo_rate;
                }
                else if (sdata.type == 2) {
                    deduction = migrated_type_rate;
                }
                else if (sdata.type == 3) {
                    deduction = carrier_cost;
                }
                let rate = new APIBase_1.APIBase();
                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                objv1.nonqrysql = "SELECT `idtariff` FROM `user` WHERE  `idaccount`='" + sdata.idaccount + "'";
                objv1.prepare();
                objv1.execute((error, result) => {
                    if (error == 1) {
                        let fun = new numberApi_1.Number();
                        fun.prorationGet(req, res, 'SC', did_sub_type, result[0].idtariff, (error, proration) => {
                            if (error == 1) {
                                let pro = new ShortCodeNumber();
                                pro.prorateCalculator(req, res, proration.proration, mo_rate, proration.setup_cost, idrequest, (pc_err, prorate) => {
                                    if (pc_err == 1) {
                                        if (type == 1) {
                                            deduction = prorate;
                                        }
                                        rate.checkBalance(req, res, sdata.idaccount, deduction, (walletError, wallet) => {
                                            if (walletError == 1) {
                                                // To update the wallet amount
                                                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + deduction + " WHERE `idaccount`='" + sdata.idaccount + "'";
                                                objv1.prepare();
                                                objv1.execute((wallet_error, wallet_success) => {
                                                    if (type == 1) {
                                                        let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objv1.nonqrysql = "UPDATE `sc_request` SET `mo_rates`='" + mo_rate + "' WHERE `id_request`='" + idrequest + "'";
                                                        objv1.prepare();
                                                        objv1.execute((wallet_error, wallet_success) => {
                                                            console.log("Mo Rates Updated Successfully!");
                                                        });
                                                        let objv2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objv2.nonqrysql = "UPDATE `sc_request_log` SET `payment_status`='1' WHERE `profile_id`='" + profile_id + "'";
                                                        objv2.prepare();
                                                        objv2.execute((wallet_error, wallet_success) => {
                                                            console.log("sc_request_log Updated Successfully!");
                                                        });
                                                    }
                                                    if (type == 2) {
                                                        let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objv1.nonqrysql = "UPDATE `sc_campaign_profile_log` SET `payment_status`='1' WHERE `profile_id`='" + profile_id + "'";
                                                        objv1.prepare();
                                                        objv1.execute(() => { });
                                                        console.log("sc_campaign_profile_log Updated Successfully!");
                                                    }
                                                    else if (type == 3) {
                                                        let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objv1.nonqrysql = "UPDATE `sc_request_carrier_coverage` SET `payment_status`='1' WHERE `id_request`='" + idrequest + "'";
                                                        objv1.prepare();
                                                        objv1.execute(() => {
                                                            let objSC = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            objSC.nonqrysql = "UPDATE `sc_request` SET `carrier_cost`='" + sdata.updatedcost + "' WHERE `id_request`='" + idrequest + "'";
                                                            objSC.prepare();
                                                            objSC.execute(() => {
                                                                console.log("payment status updated for sc_request", oddOccurrenceCarriers);
                                                                oddOccurrenceCarriers.forEach(carrier => {
                                                                    let deleteCarrier = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    deleteCarrier.nonqrysql = "DELETE FROM `sc_request_carrier_coverage` WHERE `id_request`='" + idrequest + "' AND `sc_carrier_coverage`='" + carrier.display_name + "'";
                                                                    deleteCarrier.prepare();
                                                                    deleteCarrier.execute((deleteError) => {
                                                                        if (deleteError) {
                                                                            console.log("Error deleting carrier:", carrier.display_name, deleteError);
                                                                        }
                                                                        else {
                                                                            console.log("Deleted carrier from sc_request_carrier_coverage:", carrier.display_name);
                                                                        }
                                                                    });
                                                                });
                                                            });
                                                        });
                                                        console.log("sc_request_carrier_coverage Updated Successfully!");
                                                    }
                                                    // To update the wallet transaction log
                                                    let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                    iQry += "`idaccount`=" + sdata.idaccount + ", ";
                                                    iQry += "`amount`='-" + deduction + "', ";
                                                    iQry += "`purpose`='Wallet amount successfully updated for shortcode', ";
                                                    iQry += "`status`=1;";
                                                    let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objWL.nonqrysql = iQry;
                                                    objWL.prepare();
                                                    objWL.execute(() => {
                                                        console.log("Wallet Updated Successfully!");
                                                        let objS = new RawQuery_1.ModelRawQuery(req, res);
                                                        objS.qrysql = "SELECT (SELECT payment_status FROM sc_campaign_profile_log WHERE event_desc = 'REQUEST_CREATED' AND profile_id = '" + profile_id + "') AS campaign_payment_status, (SELECT payment_status FROM sc_request_log WHERE event_desc = 'SHORTCODE_REQUEST_CREATED' AND profile_id = '" + profile_id + "') AS request_payment_status";
                                                        objS.prepare();
                                                        objS.execute((errors, results) => {
                                                            console.log("results", results);
                                                            camp_status = results[0].campaign_payment_status;
                                                            sms_status = results[0].request_payment_status;
                                                            let objc = new RawQuery_1.ModelRawQuery(req, res);
                                                            objc.qrysql = "SELECT payment_status FROM `sc_request_carrier_coverage` WHERE `id_request` = '" + idrequest + "'";
                                                            objc.prepare();
                                                            objc.execute((errorc, resultc) => {
                                                                console.log("resultc", resultc);
                                                                if (resultc.every((c) => c.payment_status === 0)) {
                                                                    carrier_status = 0;
                                                                }
                                                                else if (resultc.every((c) => c.payment_status === 1)) {
                                                                    carrier_status = 1;
                                                                }
                                                                console.log(camp_status, sms_status, carrier_status, "status check");
                                                                if (camp_status == '0' && sms_status == '0' && carrier_status == '0') {
                                                                    sc_status = 0;
                                                                }
                                                                else if (camp_status == '1' && sms_status == '1' && carrier_status == '1') {
                                                                    sc_status = 1;
                                                                }
                                                                else {
                                                                    sc_status = 2;
                                                                }
                                                                console.log("SC Status", sc_status);
                                                                let objSC = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                // objSC.qrysql = "UPDATE `sc_request` SET `payment_status`='" + sc_status + "' WHERE `id_request`='" + idrequest + "'";
                                                                objSC.nonqrysql = "UPDATE `sc_request` SET `rates` = `rates` + '" + deduction + "',`payment_status` = '" + sc_status + "' WHERE `id_request` = '" + idrequest + "'";
                                                                objSC.prepare();
                                                                objSC.execute((errorsc) => {
                                                                    if (errorsc == 1) {
                                                                        console.log("payment status updated for sc_request");
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            message: "Something Went Wrong!",
                                                                            status: 502
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                                let objSCr1 = new RawQuery_1.ModelRawQuery(req, res);
                                                                objSCr1.qrysql = "SELECT `sc_request_id` from `sc_request`WHERE `id_request`='" + idrequest + "'";
                                                                objSCr1.prepare();
                                                                objSCr1.execute((error, resp) => {
                                                                    let objSCr = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    objSCr.nonqrysql = "UPDATE `did_buy` SET `pro_rates`= `pro_rates` + '" + deduction + "' WHERE `camp_registry`='" + resp[0].sc_request_id + "'";
                                                                    objSCr.prepare();
                                                                    objSCr.execute((errorsc, result) => {
                                                                        if (errorsc == 1) {
                                                                            console.log("payment status updated for sc_request");
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({
                                                                                message: "Something Went Wrong!",
                                                                                status: 502
                                                                            });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                });
                                                            });
                                                        });
                                                    });
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Payment deducted successfully for ShortCode.", status: 200 });
                                                    objv.execute();
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ error_code: 0, error: walletError, message: "Please add funds to your account or contact support.", status: 503 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: 0,
                                            status: 503,
                                            message: "Something went wrong with proration."
                                        });
                                        console.log("Fetching with proration calculation");
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error_code: 0,
                                    status: 503,
                                    message: "Something went wrong with proration."
                                });
                                console.log("Fetching with proration");
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    migratedData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT display_name,value,rates FROM sc_shortcode_type";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Data Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let sdata = JSON.parse(req.query.type);
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT payment_status FROM sc_campaign_profile_log WHERE event_desc='REQUEST_CREATED' AND profile_id = '" + sdata.profile_id + "'";
                obj.prepare();
                obj.execute((error1, result1) => {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT payment_status FROM sc_request_log WHERE event_desc='SHORTCODE_REQUEST_CREATED' AND profile_id = '" + sdata.profile_id + "'";
                    obj1.prepare();
                    obj1.execute((error2, result2) => {
                        if (error2 == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ camp_status: result1[0], sc_status: result2[0], message: "Data Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    saveNote(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let sdata = req.body.data;
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "UPDATE `sc_request` SET `note`= '" + sdata.note + "'  WHERE `id_request`='" + sdata.idrequest + "'";
                obj.prepare();
                obj.execute((error1, result1) => {
                    if (error1 == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Description Added Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    sendNote(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let mo_rates = sdata.mo_rates;
                let idrequest = sdata.idrequest;
                let profile_id = sdata.profile_id;
                let migrated_type_rate = sdata.migrated_type_rate;
                let shortcodeNumberCharges = sdata.shortcodeNumberCharges;
                let totalcarriercost = sdata.totalcarriercost;
                let cost = shortcodeNumberCharges ?? 0;
                let camp_status;
                let sms_status;
                let carrier_status;
                let sc_status;
                let did_sub_type;
                let frequencyMap = {};
                let note = sdata.note;
                let oddOccurrenceCarriers = [];
                // Count the occurrences
                sdata.carriers.forEach((carrier) => {
                    let key = carrier.display_name;
                    if (frequencyMap[key]) {
                        frequencyMap[key]++;
                    }
                    else {
                        frequencyMap[key] = 1;
                    }
                });
                // Filter for odd occurrences and insert only once
                for (let carrier of sdata.carriers) {
                    let key = carrier.display_name;
                    if (frequencyMap[key] % 2 !== 0 && !oddOccurrenceCarriers.some(c => c.display_name === key)) {
                        oddOccurrenceCarriers.push(carrier);
                    }
                }
                if (sdata.sc_type == 1 || sdata.sc_type == 4) {
                    did_sub_type = 3;
                }
                else if (sdata.sc_type == 3) {
                    did_sub_type = 1;
                }
                else if (sdata.sc_type == 2) {
                    did_sub_type = 0;
                }
                let rate = new APIBase_1.APIBase();
                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                objv1.nonqrysql = "SELECT `idtariff` FROM `user` WHERE  `idaccount`='" + sdata.idaccount + "'";
                objv1.prepare();
                objv1.execute((error, result) => {
                    if (error == 1) {
                        let fun = new numberApi_1.Number();
                        fun.prorationGet(req, res, 'SC', did_sub_type, result[0].idtariff, (error, proration) => {
                            if (error == 1) {
                                let pro = new ShortCodeNumber();
                                pro.prorateCalculator(req, res, proration.proration, mo_rates, proration.setup_cost, idrequest, (pc_err, prorate) => {
                                    if (pc_err == 1) {
                                        // Calculate the cost based on the fields present
                                        if (shortcodeNumberCharges) {
                                            cost = prorate;
                                        }
                                        console.log("Prorate applied:", cost);
                                        if (migrated_type_rate) {
                                            cost += migrated_type_rate;
                                        }
                                        console.log("Migrated rate added:", cost);
                                        if (totalcarriercost) {
                                            cost += totalcarriercost;
                                        }
                                        console.log("Total carrier cost added:", cost);
                                        // Execute the wallet balance check and update
                                        rate.checkBalance(req, res, sdata.idaccount, cost, (walletError, wallet) => {
                                            if (walletError == 1) {
                                                // Update wallet amount
                                                let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objv1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + cost + " WHERE `idaccount`='" + sdata.idaccount + "'";
                                                objv1.prepare();
                                                objv1.execute((wallerror, wallet_success) => {
                                                    if (wallerror == 1) {
                                                        if (shortcodeNumberCharges !== null && shortcodeNumberCharges !== undefined && shortcodeNumberCharges >= 0) {
                                                            let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            objv1.nonqrysql = "UPDATE `sc_request_log` SET `payment_status`='1' WHERE `profile_id`='" + profile_id + "'";
                                                            objv1.prepare();
                                                            objv1.execute(() => {
                                                                console.log("sc_request_log Updated Successfully!");
                                                            });
                                                        }
                                                        if (migrated_type_rate !== null && migrated_type_rate !== undefined && migrated_type_rate >= 0) {
                                                            let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            objv1.nonqrysql = "UPDATE `sc_campaign_profile_log` SET `payment_status`='1' WHERE `profile_id`='" + profile_id + "'";
                                                            objv1.prepare();
                                                            objv1.execute(() => {
                                                                console.log("sc_campaign_profile_log Updated Successfully!");
                                                            });
                                                        }
                                                        if (totalcarriercost !== null && totalcarriercost !== undefined && totalcarriercost >= 0) {
                                                            let objv1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            objv1.nonqrysql = "UPDATE `sc_request_carrier_coverage` SET `payment_status`='1' WHERE `id_request`='" + idrequest + "'";
                                                            objv1.prepare();
                                                            objv1.execute(() => {
                                                                console.log("sc_request_carrier_coverage Updated Successfully!");
                                                                // Handle odd occurrence carriers deletion
                                                                oddOccurrenceCarriers.forEach(carrier => {
                                                                    let deleteCarrier = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    deleteCarrier.nonqrysql = "DELETE FROM `sc_request_carrier_coverage` WHERE `id_request`='" + idrequest + "' AND `sc_carrier_coverage`='" + carrier.display_name + "'";
                                                                    deleteCarrier.prepare();
                                                                    deleteCarrier.execute((deleteError) => {
                                                                        if (deleteError) {
                                                                            console.log("Error deleting carrier:", carrier.display_name, deleteError);
                                                                        }
                                                                        else {
                                                                            console.log("Deleted carrier from sc_request_carrier_coverage:", carrier.display_name);
                                                                        }
                                                                    });
                                                                });
                                                            });
                                                        }
                                                        // Update wallet transaction log
                                                        let iQry = "INSERT INTO `wallet_recharge_log` SET ";
                                                        iQry += "`idaccount`=" + sdata.idaccount + ", ";
                                                        iQry += "`amount`='-" + cost + "', ";
                                                        iQry += "`purpose`='Wallet amount successfully updated for shortcode', ";
                                                        iQry += "`status`=1;";
                                                        let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry;
                                                        objWL.prepare();
                                                        objWL.execute(() => {
                                                            console.log("Wallet Updated Successfully!");
                                                            let objSCr1 = new RawQuery_1.ModelRawQuery(req, res);
                                                            objSCr1.qrysql = "SELECT `sc_request_id` from `sc_request`WHERE `id_request`='" + idrequest + "'";
                                                            objSCr1.prepare();
                                                            objSCr1.execute((error, resp) => {
                                                                let objSCr = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                objSCr.nonqrysql = "UPDATE `did_buy` SET `pro_rates`= `pro_rates` + '" + cost + "' WHERE `camp_registry`='" + resp[0].sc_request_id + "'";
                                                                objSCr.prepare();
                                                                objSCr.execute((errorsc, result) => {
                                                                    if (errorsc == 1) {
                                                                        console.log("payment status updated for sc_request");
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            message: "Something Went Wrong!",
                                                                            status: 502
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            });
                                                            let objS = new RawQuery_1.ModelRawQuery(req, res);
                                                            objS.qrysql = "SELECT (SELECT payment_status FROM sc_campaign_profile_log WHERE event_desc = 'REQUEST_CREATED' AND profile_id = '" + profile_id + "') AS campaign_payment_status, (SELECT payment_status FROM sc_request_log WHERE event_desc = 'SHORTCODE_REQUEST_CREATED' AND profile_id = '" + profile_id + "') AS request_payment_status";
                                                            objS.prepare();
                                                            objS.execute((errors, results) => {
                                                                camp_status = results[0].campaign_payment_status;
                                                                sms_status = results[0].request_payment_status;
                                                                let objc = new RawQuery_1.ModelRawQuery(req, res);
                                                                objc.qrysql = "SELECT payment_status FROM `sc_request_carrier_coverage` WHERE `id_request` = '" + idrequest + "'";
                                                                objc.prepare();
                                                                objc.execute((errorc, resultc) => {
                                                                    carrier_status = resultc.every((c) => c.payment_status === 1) ? 1 : 0;
                                                                    sc_status = camp_status == '1' && sms_status == '1' && carrier_status == '1' ? 1 : 0;
                                                                    let objSC = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    objSC.nonqrysql = "UPDATE `sc_request` SET `rates` = `rates` + '" + cost + "',`payment_status` = '" + sc_status + "', `mo_rates`='" + mo_rates + "' WHERE `id_request` = '" + idrequest + "'";
                                                                    objSC.prepare();
                                                                    objSC.execute((errorsc) => {
                                                                        if (errorsc == 1) {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Payment deducted successfully for ShortCode.", status: 200 });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({
                                                                                message: "Something went wrong while updating payment status",
                                                                                status: 502,
                                                                            });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                });
                                                            });
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            message: "Something Went Wrong While Fetching Updating  Balance!",
                                                            status: 400,
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Insufficient Wallet Amount. Please Recharge Your Wallet And Try Again",
                                                    status: 400,
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went wrong with proration", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong While Updating Wallet", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something Went Wrong While Updating Description", status: 502 });
                objv.execute();
            }
        });
    }
    updateSCWebkey(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessdata) => {
            if (sessErr == 1) {
                if (sessdata.type == 2) {
                    let sdata = req.body.data;
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "UPDATE `did_buy` SET `webhook_messaging_key`='" + sdata.webhook_messaging_key + "' WHERE `did`='" + sdata.shortocde_number + "' AND `iduser`= '" + sdata.iduser + "' AND `camp_registry`= '" + sdata.sc_campaign_unique_id + "'";
                    obj0.prepare();
                    obj0.execute((error, resUser) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Update Webhook Key Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    prorateCalculator(req, res, proration, rates, setup_cost, idrequest, callback) {
        let objP = new RawQuery_1.ModelRawQuery(req, res);
        objP.qrysql = "SELECT `approved_date` FROM `sc_request` WHERE `id_request`='" + idrequest + "'";
        objP.prepare();
        objP.execute((error, result) => {
            if (error == 1) {
                let approvedDate = result[0].approved_date ? new Date(result[0].approved_date) : new Date();
                let nDate = new Date();
                let lDate = new Date(nDate.getFullYear(), nDate.getMonth() + 1, 0);
                let totalDays = 0;
                if (approvedDate.getMonth() === nDate.getMonth() && approvedDate.getFullYear() === nDate.getFullYear()) {
                    totalDays = (lDate.getDate() - approvedDate.getUTCDate()) + 1;
                }
                else if (approvedDate < nDate) {
                    totalDays = Math.ceil((lDate.getTime() - approvedDate.getTime()) / (1000 * 60 * 60 * 24)) + 1;
                }
                else {
                    totalDays = lDate.getDate();
                }
                console.log("total dayss:::", totalDays);
                console.log("lDate.getDate():::", lDate.getDate());
                console.log("ratesratesrates:::", rates);
                console.log("setup_costsetup_costsetup_cost:::", setup_cost);
                let prorate;
                if (proration == "true") {
                    prorate = ((totalDays * rates) / lDate.getDate()) + setup_cost;
                }
                else {
                    prorate = rates + setup_cost;
                }
                console.log("Final Prorate :: ", prorate);
                callback(1, prorate);
            }
            else {
                callback(0, null);
            }
        });
    }
    updateConnecion(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = req.body.data;
                let connection_key;
                let inboundKey;
                let outboundKey;
                if (rdata.connection_key) {
                    connection_key = rdata.connection_key;
                }
                else {
                    connection_key = '';
                }
                if (rdata.inboundKey) {
                    inboundKey = rdata.inboundKey;
                }
                else {
                    inboundKey = '';
                }
                if (rdata.outboundKey) {
                    outboundKey = rdata.outboundKey;
                }
                else {
                    outboundKey = '';
                }
                obj2.nonqrysql = "UPDATE `did_buy` SET `connection_key`='" + connection_key + "',`inbound_Key`='" + inboundKey + "', `outbound_Key`='" + outboundKey + "' WHERE `did`= '" + rdata.did + "' AND `iddid`='" + rdata.iddid + "'";
                obj2.qrysql = "";
                obj2.prepare();
                obj2.execute((error, data) => {
                    let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    objk.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'4','Connection Enable','" + rdata.did.trim() + "')";
                    objk.execute((cart_error, result) => {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({ status: 201, error: 0, data: data, message: "Connection Updated Successfully!" });
                        objv.execute();
                    });
                });
                let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj11.nonqrysql = "UPDATE sc_request SET `shortocde_number`='" + rdata.did.trim() + "',`connection`='" + (connection_key).trim() + "' WHERE `shortocde_number` = '" + rdata.did.trim() + "'";
                obj11.prepare();
                obj11.execute((_error, result) => {
                    console.log("Connection Updated on SC Request Table");
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    checkDid(req, res, next) {
        let sdata = req.query;
        let data = JSON.parse(sdata.type);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let idaccount = data.idaccount ?? sessdata.idaccount;
                let iduser = data.iduser ?? sessdata.iduser;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT did FROM did_buy WHERE did='" + data.did + "' AND `type`='SC' AND account_id='" + idaccount + "' AND iduser='" + iduser + "'";
                obj.prepare();
                obj.execute((error1, result) => {
                    if (error1 == 1) {
                        if (result.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: 'You cannot upload the same Shortcode DID', status: 400 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: 'Valid DID', status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.ShortCodeNumber = ShortCodeNumber;
