"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SinchApi = void 0;
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const sinchNumberRegistry_1 = require("../include/sinchNumberRegistry");
const RawView_1 = require("../lib/view/RawView");
const RawQuery_1 = require("../lib/model/RawQuery");
const setting_config_1 = require("../config/setting.config");
const sinchNumAction = new setting_config_1.SinchNumbers();
const syniverseNumAction = new setting_config_1.SyniverseNumbers();
let request = require('request');
// const produrl = 'http://65.214.42.91:84/osr/v2/entries/';
// const projectId = "bd6ca3f8-040c-4b40-ba6c-09f8d63be111";
// const servicePlanId = "IP_LINK_RA";
// const userId = "f0c489dd-2203-4dc9-964a-c59021b9ee74";
// const passwd = "Ew6Ynk~ddXD2UqmoHxWywDczB_";
// const myip = "iplink";
// const nnid = "104141";
class SinchApi extends sinchNumberRegistry_1.SinchNumberRegistry {
    constructor(proirity, sessdata) {
        super(proirity, sessdata);
    }
    /**
     * To Add entry into Sinch :: first method
     */
    submitNumber(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        // var dataString = '{"phone_number":' + number1 + ', "projectId":' + projectId + ', "region_code":"US", "smsConfiguration":{"servicePlanId":' + servicePlanId + ', "campaignId":' + sdata.CampaignId + '}}';
        var dataString = '{"phone_number":' + number1 + ', "projectId":' + sinchNumAction.SinchPId + ', "region_code":"US", "smsConfiguration":{"servicePlanId":' + sinchNumAction.SinchsrvPlanId + ', "campaignId":' + sdata.CampaignId + '}}';
        var options = {
            // url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers',
            url: sinchNumAction.SinchUrl + sinchNumAction.SinchPId + '/importedNumbers',
            method: 'POST',
            headers: headers,
            body: dataString,
            auth: {
                // 'user': userId,
                'user': sinchNumAction.SinchUId,
                // 'pass': passwd
                'pass': sinchNumAction.SinchPwd
            }
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.status == "WAITING") {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '1' where `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                        obj.prepare();
                        obj.execute((err, resp) => {
                            if (resp) {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({});
                                obj.execute();
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ "error": "Query Error", "err": err });
                                obj.execute();
                            }
                        });
                    }
                    else if (data.status == "FAILED") {
                        this.updateNumber(req, res, (err, res) => {
                            if (res) {
                            }
                            else {
                            }
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: SinchSubmitNumber->submitNumber::", e);
                    callback(error, "");
                }
            }
            else {
                callback(error, "");
            }
        });
    }
    /**
     * To Update entry into Sinch :: first method
     */
    updateNumber(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        // var dataString = '{"phone_number":"' + number1 + '", "projectId":"' + projectId + '", "region_code":"US", "smsConfiguration":{"servicePlanId":"' + servicePlanId + '", "campaignId":"' + sdata.CampaignId + '"}}';
        var dataString = '{"phone_number":"' + number1 + '", "projectId":"' + sinchNumAction.SinchPId + '", "region_code":"US", "smsConfiguration":{"servicePlanId":"' + sinchNumAction.SinchsrvPlanId + '", "campaignId":"' + sdata.CampaignId + '"}}';
        var options = {
            // url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/' + number1,
            url: sinchNumAction.SinchUrl + sinchNumAction.SinchPId + '/importedNumbers/' + number1,
            method: 'PATCH',
            headers: headers,
            body: dataString,
            auth: {
                // 'user': userId,
                'user': sinchNumAction.SinchUId,
                // 'pass': passwd
                'pass': sinchNumAction.SinchPwd
            }
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.status == "WAITING") {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '1' where `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                        obj.prepare();
                        obj.execute((err, resp) => {
                            if (resp) {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({});
                                obj.execute();
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ "error": "Query Error", "err": err });
                                obj.execute();
                            }
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: SinchSubmitNumber->updateNumber::", e);
                    callback(error, "");
                }
            }
            else {
                callback(error, "");
            }
        });
    }
    /**
     * To Delete entry from Sinch  :: first method
     */
    deleteNumber(req, res, data, callback) {
        let sdata = req.query;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        /* let iduser: any = '';
        if (sdata.iduser) {
            iduser = sdata.iduser;
        } else {
            iduser = this.sessdata.iduser;
        } */
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        var options = {
            // url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/+1' + number,
            url: sinchNumAction.SinchUrl + sinchNumAction.SinchPId + '/importedNumbers/+1' + number,
            method: 'DELETE',
            headers: headers,
            auth: {
                // 'user': userId,
                'user': sinchNumAction.SinchUId,
                // 'pass': passwd
                'pass': sinchNumAction.SinchPwd
            }
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let dataR = JSON.parse(response.body);
                    if (Object.keys(dataR).length == 0) {
                        // here in this query we are using session iduser and id account for the understanding who is performed this action.
                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'11','DID disconnect From SINCH','" + number.trim() + "','" + data[0].campaign_key + "')";
                        obj4.prepare();
                        obj4.execute((errLog, resLog) => {
                            console.log("SMS Disabled Successfully From SINCH");
                        });
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '0' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                        obj1.prepare();
                        obj1.execute((err, resp) => {
                            if (err == 1) {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 202, message: "SMS facility has been successfully disabled." });
                                obj.execute();
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 502, message: "DID Disabled Successfully But Something Went Wrong With Data Update!" });
                                obj.execute();
                            }
                        });
                    }
                    else if (dataR.error !== undefined && dataR.error.code == 404) {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'46','DID disconnect From SINCH. But it was not imported on SINCH','" + number.trim() + "','" + data[0].campaign_key + "','" + response.body + "')";
                        obj2.prepare();
                        obj2.execute((errLog, resLog) => {
                            console.log("DID disconnect From SINCH. But it was not imported on SINCH");
                        });
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '0' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                        obj1.prepare();
                        obj1.execute((err, resp) => {
                            if (err == 1) {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 202, message: "SMS facility has been successfully disabled." });
                                obj.execute();
                            }
                            else {
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ status: 502, message: "DID Disabled Successfully But Something Went Wrong With Data Update!" });
                                obj.execute();
                            }
                        });
                    }
                    else if (dataR.error !== undefined && dataR.error.code == 403) {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'18','DID disconnect failed from SINCH','" + number.trim() + "','" + data[0].campaign_key + "','" + response.body + "')";
                        obj2.prepare();
                        obj2.execute((errLog, resLog) => {
                            console.log("SMS Disabled failed from SINCH");
                        });
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: dataR.error.code, message: dataR.error.message });
                        obj.execute();
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'18','DID disconnect failed from SINCH','" + number.trim() + "','" + data[0].campaign_key + "','" + response.body + "')";
                        obj2.prepare();
                        obj2.execute((errLog, resLog) => {
                            console.log("SMS Disabled failed from SINCH");
                            callback(error, '');
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: SinchSubmitNumber->deleteNumber::", e);
                    callback(error, '');
                }
            }
            else {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'18','DID disconnect failed from SINCH','" + number.trim() + "','" + data[0].campaign_key + "')";
                obj2.prepare();
                obj2.execute((errLog, resLog) => {
                    console.log("SMS Disabled failed from SINCH");
                    callback(error, '');
                });
            }
        });
    }
    deleteNumberfromSyniverse(req, res, result_camp, callback) {
        let sdata = req.query;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        if (result_camp[0].campaign_key !== undefined && result_camp[0].campaign_key != null && result_camp[0].campaign_key && result_camp[0].campaign_key.startsWith("C")) {
            var options = {
                'method': 'DELETE',
                // 'url': 'https://api.syniverse.com/engage/tendlc-services/v2/campaigns/' + result_camp[0].campaign_key + '/longcodes/1' + number.trim() + '',
                'url': syniverseNumAction.SyniverseUrl + result_camp[0].campaign_key + '/longcodes/1' + number.trim() + '',
                'headers': {
                    'Content-Type': 'application/json',
                    'Content-Length': '0',
                    // 'Authorization': 'Bearer 87f760eb-9864-3a57-a143-368cda7fd23b'
                    'Authorization': syniverseNumAction.SyniverseAuth
                },
            };
            request(options, (error, response) => {
                if (!error) {
                    try {
                        let data = JSON.parse(response.body);
                        if (data.status == 'OK') {
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'28','DID disconnect Pending to SYNIVERSE','" + number.trim() + "','7','" + response.body + "','" + result_camp[0].campaign_key + "')";
                            obj0.prepare();
                            obj0.execute((errLog, resLog) => {
                                console.log("SMS Disabled Successfully From SYNIVERSE");
                            });
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '7' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                            obj1.prepare();
                            obj1.execute((err, resp) => {
                                console.log("SMS facility has been successfully disabled.");
                                callback(1, { status: 202, message: "SMS facility has been successfully disabled." });
                            });
                        }
                        else if (data.status == 'ACCEPTED') {
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'27','DID provisioning REMOVED to SYNIVERSE','" + number.trim() + "','0','" + response.body + "','" + result_camp[0].campaign_key + "')";
                            obj2.prepare();
                            obj2.execute((err4, resp4) => { });
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0' WHERE  `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                            obj3.prepare();
                            obj3.execute((err2, resp2) => {
                                console.log("DID unprovisioned to SYNIVERSE.");
                                callback(1, { status: 202, message: "DID unprovisioned to SYNIVERSE!" });
                            });
                        }
                        else if (data.status == 'CONFLICT') {
                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'30','DID disconnect having conflict to SYNIVERSE','" + number.trim() + "','" + response.body + "','" + result_camp[0].campaign_key + "')";
                            obj4.prepare();
                            obj4.execute((err6, resp6) => {
                                console.log("ImportedNumber Already Exists on SYNIVERSE.");
                                callback(0, { status: 202, message: "ImportedNumber Already Exists on SYNIVERSE" });
                            });
                            // let obj5 = new ModelRawNonQuery(req, res);
                            // obj5.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0' WHERE  iduser = '" + iduser + "' AND `did`='" + number + "'";
                            // obj5.prepare();
                            // obj5.execute((err5, resp5) => {
                            //     console.log("ImportedNumber Already Exists on SYNIVERSE.")
                            //     callback(0, { status: 202, message: "ImportedNumber Already Exists on SYNIVERSE" });
                            // });
                        }
                        else if (data.status == 'BAD_REQUEST') {
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'27','DID provisioning REMOVED to SYNIVERSE','" + number.trim() + "','0','" + response.body + "','" + result_camp[0].campaign_key + "')";
                            obj2.prepare();
                            obj2.execute((err4, resp4) => { });
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0' WHERE  `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                            obj3.prepare();
                            obj3.execute((err2, resp2) => {
                                console.log("SMS facility not disabled successfull!.");
                                callback(1, { status: 202, message: "SMS facility not disabled successfully!" });
                            });
                        }
                        else {
                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'26','DID provisioning DELETE_FAILED/REMOVE_FAILED to SYNIVERSE','" + number.trim() + "','8','" + response.body + "','" + result_camp[0].campaign_key + "')";
                            obj6.prepare();
                            obj6.execute((err8, resp8) => { });
                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='8' WHERE  `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                            obj7.prepare();
                            obj7.execute((err7, resp7) => {
                                console.log("SMS Disabled failed from SYNIVERSE");
                                callback(0, { status: 502, message: "SMS facility not disabled successfully" });
                            });
                        }
                    }
                    catch (e) {
                        console.log("Error :: SinchSubmitNumber->deleteNumberfromSyniverse::", e);
                        callback(0, { status: 502, message: "Something went wrong with Disable SMS.please try again." });
                    }
                }
                else {
                    callback(0, { status: 503, message: "Something went wrong with Disable SMS.please try again." });
                }
            });
        }
        else {
            console.log("Campaign is not available.");
            callback(0, { status: 403, message: "SMS facility not disabled successfully. Because campaign is not available" });
        }
    }
    // public deleteNumber(req: Request, res: Response, callback: (err: any, data: any) => void) {
    //     let sdata: any = req.query;
    //     let did = sdata.DID;
    //     let len = did.length - 10;
    //     let number = did.slice(len, did.length);
    //     let number1 = "1" + number;
    //     let obj0 = new ModelRawQuery(req, res);
    //     obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `iduser` = '" + this.sessdata.iduser + "'";
    //     obj0.prepare();
    //     obj0.execute((err: any, result_did: any) => {
    //         if (err == 1 && result_did.length > 0) {
    //             let obj00 = new ModelRawQuery(req, res);
    //             obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name FROM `campaign` WHERE `iduser`='" + this.sessdata.iduser + "' AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
    //             obj00.prepare();
    //             obj00.execute((err: any, result_camp: any) => {
    //                 if (err == 1 && result_camp.length > 0) {
    //                     let obj00 = new ModelRawQuery(req, res);
    //                     obj00.qrysql = "SELECT `iddidlog` FROM did_log WHERE `did`= '" + sdata.DID.trim() + "' AND `iduser` = '" + this.sessdata.iduser + "' ORDER BY `iddidlog` DESC";
    //                     obj00.prepare();
    //                     obj00.execute((log_error: any, log_res: any) => {
    //                         if (log_error == 1 && log_res.length > 0) {
    //                             var headers = {
    //                                 'accept': '*/*',
    //                                 'Accept': 'application/json'
    //                             };
    //                             var options = {
    //                                 url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/' + number1,
    //                                 method: 'GET',
    //                                 headers: headers,
    //                                 auth: {
    //                                     'user': userId,
    //                                     'pass': passwd
    //                                 }
    //                             };
    //                             request(options, (error: any, response: any) => {
    //                                 if (!error) {
    //                                     let data = JSON.parse(response.body);
    //                                     if (data.status == 200) {
    //                                         let obj1 = new ModelRawNonQuery(req, res);
    //                                         obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '0',`camp_registry` = '' WHERE iduser = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
    //                                         obj1.prepare();
    //                                         obj1.execute((err, resp) => {
    //                                             let obj2 = new ModelRawNonQuery(req, res);
    //                                             obj2.nonqrysql = "INSERT INTO `campaign_history`(`iduser`,`idaccount`,`did`,`campaign_key`,`campaign_name`,`in_use`,`iddidlog`) VALUES ('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + number + "','" + result_camp[0].campaign_key + "','" + result_camp[0].campaign_name + "', '1','" + log_res[0].iddidlog + "')";
    //                                             obj2.prepare();
    //                                             obj2.execute((err, resp) => {
    //                                                 if (err == 1) {
    //                                                     let obj = new RawView(res);
    //                                                     obj.prepare({ status: 202, message: "DID Successfully Disabled." });
    //                                                     obj.execute();
    //                                                 }
    //                                                 else {
    //                                                     let obj = new RawView(res);
    //                                                     obj.prepare({ status: 502, message: "DID Disabled Successfully But Something Went Wrong With Data Update!" });
    //                                                     obj.execute()
    //                                                 }
    //                                             });
    //                                         });
    //                                     } else {
    //                                         callback('', data);
    //                                     }
    //                                 } else {
    //                                     callback(error, '');
    //                                 }
    //                             });
    //                         } else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ status: 404, message: `ID DID not found on this DID!` });
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //                 else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ status: 502, message: 'Campaign Registry Does not Match!' });
    //                     objv.execute()
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ status: 502, message: 'DID Not Available!' });
    //             objv.execute()
    //         }
    //     });
    // }
    /**
     * To Update entry with toll-free provisioning into Sinch :: first method
     */
    updateNumberWithTollfree(req, res, callback) {
        let sdata = req.body;
        let options = {
            'method': 'PUT',
            // 'url': 'https://208.254.45.98/osr/v2/entries/1800551212',
            'url': sinchNumAction.SinchNumWithTF + `1800551212`,
            'headers': {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ "id": "mypid", "nnid": "123456", "context": "A2P", "ownertspid": "3434" })
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let ddata = JSON.parse(response.body);
                    if (ddata.rows.length > 0) {
                    }
                    else {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.prepare();
                        obj.execute((err, data) => {
                            callback(err, data);
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: SinchSubmitNumber->updateNumberWithTollfree::", e);
                    callback(error, '');
                }
            }
            else {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.prepare();
                obj.execute((err, data) => {
                    callback(err, data);
                });
            }
        });
    }
    /**
     * To retrieve entry from Sinch :: first method
     */
    retrieveOsrEntry(req, res, callback) {
        let sdata = req.query;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "1" + number;
        let options = {
            'method': 'GET',
            // 'url': produrl + "" + number1 + "?id=" + myip,
            'url': sinchNumAction.SinchProdurl + "" + number1 + "?id=" + sinchNumAction.SinchMip,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        console.log("options", options);
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    callback('', data);
                }
                catch (e) {
                    console.log("Error :: SinchSubmitNumber->retrieveOsrEntry::", e);
                    callback(error, '');
                }
            }
            else {
                callback(error, '');
            }
        });
    }
    /**
     * To Delete entry from Sinch :: second method
     */
    deleteNumberM2(req, res, payLoad, callback) {
        let did = payLoad.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        var headers = {
            'accept': '*/*',
            'Accept': 'application/json'
        };
        var options = {
            // url: 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/+1' + number,
            url: sinchNumAction.SinchUrl + sinchNumAction.SinchPId + '/importedNumbers/+1' + number,
            method: 'DELETE',
            headers: headers,
            auth: {
                // 'user': userId,
                'user': sinchNumAction.SinchUId,
                // 'pass': passwd
                'pass': sinchNumAction.SinchPwd
            }
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (Object.keys(data).length == 0) {
                        let objn = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        objn.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'11','DID disconnect FROM SINCH','" + number + "', '" + payLoad.campaign + "')";
                        objn.prepare();
                        objn.execute((errorDiDLg, resDiDLg) => { });
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0', `disconnect_did_status`='0' WHERE iduser='" + this.sessdata.iduser + "' AND `did`='" + number + "';";
                        obj.prepare();
                        obj.execute((err, resp) => {
                            if (err == 1) {
                                callback(1, resp);
                            }
                            else {
                                callback(0, err);
                            }
                        });
                    }
                    else if (data.error !== undefined && data.error.code == 404) {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'46','DID disconnect From SINCH. But it was not imported on SINCH','" + number.trim() + "','" + payLoad.campaign + "','" + response.body + "')";
                        obj2.prepare();
                        obj2.execute((errLog, resLog) => {
                            console.log("DID disconnect From SINCH. But it was not imported on SINCH");
                        });
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '0', `disconnect_did_status`='0' WHERE iduser = '" + this.sessdata.iduser + "' AND `did`='" + number.trim() + "'";
                        obj1.prepare();
                        obj1.execute((err, resp) => {
                            if (err == 1) {
                                callback(1, resp);
                            }
                            else {
                                callback(0, err);
                            }
                        });
                    }
                    else if (data.error !== undefined && data.error.code == 403) {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'18','DID disconnect failed from SINCH','" + number.trim() + "','" + payLoad.campaign + "','" + response.body + "')";
                        obj2.prepare();
                        obj2.execute((errLog, resLog) => {
                            console.log({ status: data.error.code, message: data.error.message });
                        });
                        callback(0, data);
                    }
                    else {
                        let objn = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        objn.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'18','DID disconnect failed FROM SINCH','" + number + "', '" + payLoad.campaign + "')";
                        objn.prepare();
                        objn.execute((errorDiDLg, resDiDLg) => {
                            callback(0, data);
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: SinchSubmitNumber->deleteNumberM2::", e);
                    callback(0, error);
                }
            }
            else {
                let objn = new RawNonQuery_1.ModelRawNonQuery(req, res);
                objn.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'18','DID disconnect failed FROM SINCH','" + number + "', '" + payLoad.campaign + "')";
                objn.prepare();
                objn.execute((errorDiDLg, resDiDLg) => { });
                callback(0, error);
            }
        });
    }
    deleteNumberM2fromSyniverse(req, res, payLoad, callback) {
        let did = payLoad.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        if (payLoad.campaign !== undefined && payLoad.campaign != null && payLoad.campaign && payLoad.campaign.startsWith("C")) {
            var options = {
                'method': 'DELETE',
                // 'url': 'https://api.syniverse.com/engage/tendlc-services/v2/campaigns/' + payLoad.campaign + '/longcodes/1' + number.trim() + '',
                'url': syniverseNumAction.SyniverseUrl + payLoad.campaign + '/longcodes/1' + number.trim() + '',
                'headers': {
                    'Content-Type': 'application/json',
                    'Content-Length': '0',
                    // 'Authorization': 'Bearer 87f760eb-9864-3a57-a143-368cda7fd23b'
                    'Authorization': syniverseNumAction.SyniverseAuth
                },
            };
            request(options, (error, response) => {
                if (!error) {
                    try {
                        let data = JSON.parse(response.body);
                        if (data.status == 'OK') {
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + payLoad.iduser + "',NOW(),'28','DID disconnect Pending to SYNIVERSE','" + number.trim() + "','7','" + response.body + "','" + payLoad.campaign + "')";
                            obj0.prepare();
                            obj0.execute((errLog, resLog) => {
                                console.log("SMS Disabled Successfully From SYNIVERSE");
                            });
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status` = '7', `disconnect_did_status`='0' WHERE iduser = '" + payLoad.iduser + "' AND `did`='" + number + "'";
                            obj1.prepare();
                            obj1.execute((err, resp) => {
                                console.log("SMS facility has been successfully disabled.");
                                callback(1, { status: 202, message: "SMS facility has been successfully disabled." });
                            });
                        }
                        else if (data.status == 'ACCEPTED') {
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + payLoad.iduser + "',NOW(),'27','DID provisioning REMOVED to SYNIVERSE','" + number.trim() + "','0','" + response.body + "','" + payLoad.campaign + "')";
                            obj2.prepare();
                            obj2.execute((err4, resp4) => { });
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0', `disconnect_did_status`='0'WHERE  iduser = '" + payLoad.iduser + "' AND `did`='" + number + "'";
                            obj3.prepare();
                            obj3.execute((err2, resp2) => {
                                console.log("DID provisioning REMOVED to SYNIVERSE.");
                                callback(1, { status: 202, message: "DID provisioning REMOVED to SYNIVERSE!" });
                            });
                        }
                        else if (data.status == 'CONFLICT') {
                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + payLoad.iduser + "',NOW(),'30','DID disconnect having conflict to SYNIVERSE','" + number.trim() + "','" + response.body + "','" + payLoad.campaign + "')";
                            obj4.prepare();
                            obj4.execute((err6, resp6) => {
                                console.log("DID disconnect having conflict to SYNIVERSE.");
                                callback(0, { status: 202, message: "DID disconnect having conflict to SYNIVERSE" });
                            });
                        }
                        else if (data.status == 'BAD_REQUEST') {
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + payLoad.iduser + "',NOW(),'27','DID provisioning REMOVED to SYNIVERSE','" + number.trim() + "','0','" + response.body + "','" + payLoad.campaign + "')";
                            obj2.prepare();
                            obj2.execute((err4, resp4) => { });
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0', `disconnect_did_status`='0' WHERE  iduser = '" + payLoad.iduser + "' AND `did`='" + number + "'";
                            obj3.prepare();
                            obj3.execute((err2, resp2) => {
                                console.log("DID provisioning REMOVED to SYNIVERSE.");
                                callback(1, { status: 202, message: "DID provisioning REMOVED to SYNIVERSE!" });
                            });
                        }
                        else {
                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`full_log`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + payLoad.iduser + "',NOW(),'26','DID provisioning DELETE_FAILED/REMOVE_FAILED to SYNIVERSE','" + number.trim() + "','8','" + response.body + "','" + payLoad.campaign + "')";
                            obj6.prepare();
                            obj6.execute((err8, resp8) => { });
                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='8', `disconnect_did_status`='0' WHERE iduser = '" + payLoad.iduser + "' AND `did`='" + number + "'";
                            obj7.prepare();
                            obj7.execute((err7, resp7) => {
                                console.log("SMS Disabled failed from SYNIVERSE");
                                callback(0, { status: 502, message: "SMS facility not disabled successfully" });
                            });
                        }
                    }
                    catch (e) {
                        console.log("Error :: SinchSubmitNumber->deleteNumberM2fromSyniverse::", e);
                        callback(0, { status: 502, message: "Something went wrong with Disable SMS. Please try again." });
                    }
                }
                else {
                    callback(0, { status: 503, message: "Something went wrong with Disable SMS. Please try again." });
                }
            });
        }
        else {
            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj0.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`sinch_status`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + payLoad.iduser + "',NOW(),'38','Campaign not Available For Syniverse','" + number.trim() + "','7','" + payLoad.campaign + "')";
            obj0.prepare();
            obj0.execute((errLog, resLog) => {
                console.log("Campaign not Available");
            });
            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='0', `disconnect_did_status`='0' WHERE iduser = '" + payLoad.iduser + "' AND `did`='" + number + "'";
            obj1.prepare();
            obj1.execute((err1, resp1) => {
                console.log("SMS Disabled from SYNIVERSE");
                callback(0, { status: 502, message: "SMS facility disabled successfully" });
            });
            // callback(0, { status: 503, message: "Campaign not Available!" });
        }
    }
    EnableSMSFromSinch(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        // let iduser: any = sdata.iduser ? sdata.iduser : this.sessdata.iduser;
        // let idaccount: any = sdata.idaccount ? sdata.idaccount : this.sessdata.idaccount;
        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `account_id` = '" + this.sessdata.idaccount + "'";
        obj0.prepare();
        obj0.execute((err, result_did) => {
            if (err == 1 && result_did.length > 0) {
                var options = {
                    'method': 'POST',
                    // 'url': 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers',
                    'url': sinchNumAction.SinchUrl + sinchNumAction.SinchPId + '/importedNumbers',
                    'headers': {
                        'Content-Type': 'application/json',
                        // 'Authorization': 'Basic ZjBjNDg5ZGQtMjIwMy00ZGM5LTk2NGEtYzU5MDIxYjllZTc0OkV3Nllua35kZFhEMlVxbW9IeFd5d0RjekJf'
                        'Authorization': sinchNumAction.SinchAuth
                    },
                    body: JSON.stringify({
                        "phone_number": "+1" + number,
                        "projectId": sinchNumAction.SinchPId,
                        "region_code": "US",
                        "smsConfiguration": {
                            "servicePlanId": "IP_LINK_RA",
                            "campaignId": result_did[0].camp_registry
                        }
                    })
                };
                request(options, (error, response) => {
                    if (!error) {
                        try {
                            let data = JSON.parse(response.body);
                            if (data.smsConfiguration) {
                                if (data.smsConfiguration.scheduledProvisioning == "") {
                                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj0.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','1','" + response.body + "')";
                                    obj0.prepare();
                                    obj0.execute((err0, resp0) => { });
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='1' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                    obj1.prepare();
                                    obj1.execute((err1, resp1) => {
                                        console.log("SMS enabled successfully!");
                                        callback(1, { status: 200, message: "SMS enabled successfully!" });
                                    });
                                }
                                else {
                                    if (data.smsConfiguration.scheduledProvisioning.status == "WAITING") {
                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','2','" + response.body + "')";
                                        obj2.prepare();
                                        obj2.execute((err2, resp2) => { });
                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='2' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                        obj3.prepare();
                                        obj3.execute((err3, resp3) => {
                                            console.log("DID provisioned to SINCH.");
                                            callback(1, { status: 200, message: "SMS enabled successfully!" });
                                        });
                                    }
                                    else {
                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','3','" + response.body + "')";
                                        obj4.prepare();
                                        obj4.execute((err4, resp4) => { });
                                        let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj5.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='3' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                        obj5.prepare();
                                        obj5.execute((err5, resp5) => {
                                            console.log("DID provisioned to SINCH!");
                                            callback(1, { status: 200, message: "SMS enabled successfully!" });
                                        });
                                    }
                                }
                            }
                            else {
                                if (data.error) {
                                    if (data.error.status === "ALREADY_EXISTS") {
                                        let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "','4','" + response.body + "')";
                                        obj6.prepare();
                                        obj6.execute((err6, resp6) => { });
                                        let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='4' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                        obj7.prepare();
                                        obj7.execute((err7, resp7) => {
                                            console.log("ImportedNumber Already Exists on Sinch.");
                                            callback(0, { status: 200, message: "SMS enabled successfully!" });
                                        });
                                    }
                                    else {
                                        let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj8.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'13','SINCH provisioning failed','" + number.trim() + "','" + sdata.CampaignId + "','5','" + response.body + "')";
                                        obj8.prepare();
                                        obj8.execute((err8, resp8) => { });
                                        let obj9 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj9.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='5' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                        obj9.prepare();
                                        obj9.execute((err9, resp9) => {
                                            console.log("Imported Number Does Not Exists on Sinch!");
                                            callback(0, { status: 200, message: "SMS enable failed!" });
                                        });
                                    }
                                }
                            }
                        }
                        catch (e) {
                            console.log("Error :: SinchSubmitNumber->EnableSMSFromSinch::", e);
                            callback(error, '');
                        }
                    }
                    else {
                        callback(error, '');
                    }
                });
            }
        });
    }
    EnableSMSFromSyniverse(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        // let iduser: any = sdata.iduser ? sdata.iduser : this.sessdata.iduser;
        // let idaccount: any = sdata.idaccount ? sdata.idaccount : this.sessdata.idaccount;
        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND account_id = '" + this.sessdata.idaccount + "'";
        obj0.prepare();
        obj0.execute((err, result_did) => {
            if (err == 1 && result_did.length > 0) {
                var options = {
                    'method': 'POST',
                    // 'url': 'https://api.syniverse.com/engage/tendlc-services/v2/campaigns/' + sdata.CampaignId + '/longcodes/1' + number.trim() + '',
                    'url': syniverseNumAction.SyniverseUrl + sdata.CampaignId + '/longcodes/1' + number.trim() + '',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Content-Length': '0',
                        // 'Authorization': 'Bearer 87f760eb-9864-3a57-a143-368cda7fd23b'
                        'Authorization': syniverseNumAction.SyniverseAuth
                    },
                };
                request(options, (error, response) => {
                    if (!error) {
                        try {
                            let data = JSON.parse(response.body);
                            let full_res = response.body === undefined ? '' : response.body;
                            if (data.status == 'OK') {
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'21','DID provisioning PENDING to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','2','" + full_res + "')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => { });
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='2' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj1.prepare();
                                obj1.execute((err1, resp1) => {
                                    console.log("SMS enabled successfully!");
                                    callback(1, { status: 200, message: "SMS Enabled successfully!" });
                                });
                            }
                            else if (data.status == 'ACCEPTED') {
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'19','DID provisioning ACCEPTED to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','3','" + full_res + "')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => { });
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='1' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj2.prepare();
                                obj2.execute((err2, resp2) => {
                                    console.log("DID provisioned to SMS Service.");
                                    callback(1, { status: 200, message: "DID provisioned to SMS Service!" });
                                });
                            }
                            else if (data.status == 'CONFLICT') {
                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'20','DID provisioning CONFLICT to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','1','" + full_res + "')";
                                obj6.prepare();
                                obj6.execute((err6, resp6) => {
                                });
                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='1' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj5.prepare();
                                obj5.execute((err5, resp5) => {
                                    console.log("ImportedNumber Already Exists on SMS Service.");
                                    callback(0, { status: 200, message: "ImportedNumber Already Exists on SMS Service" });
                                });
                            }
                            else {
                                let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj8.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'23','DID provisioning DEPLOYED_FAILED/ADD_FAILED to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','5','" + full_res + "')";
                                obj8.prepare();
                                obj8.execute((err8, resp8) => { });
                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='5' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj7.prepare();
                                obj7.execute((err7, resp7) => {
                                    console.log("Imported Number Does Not Exists on SMS Service!");
                                    callback(0, { status: 200, message: "Imported Number Does Not Exists on SMS Service!" });
                                });
                            }
                        }
                        catch (e) {
                            console.log("Error :: SinchSubmitNumber->EnableSMSFromSyniverse::", e);
                            callback(error, '');
                        }
                    }
                    else {
                        callback(error, '');
                    }
                });
            }
        });
    }
    reEnableSMSFromSyniverse(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        // let iduser: any = sdata.iduser ? sdata.iduser : this.sessdata.iduser;
        // let idaccount: any = sdata.idaccount ? sdata.idaccount : this.sessdata.idaccount;
        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `camp_registry`,`sinch_status` FROM `did_buy` WHERE `did`='" + number + "' AND `account_id` = '" + this.sessdata.idaccount + "'";
        obj0.prepare();
        obj0.execute((err, result_did) => {
            if (err == 1 && result_did.length > 0) {
                var options = {
                    'method': 'POST',
                    // 'url': 'https://api.syniverse.com/engage/tendlc-services/v2/campaigns/' + sdata.CampaignId + '/longcodes/1' + number.trim() + '',
                    'url': syniverseNumAction.SyniverseUrl + sdata.CampaignId + '/longcodes/1' + number.trim() + '',
                    'headers': {
                        'Content-Type': 'application/json',
                        'Content-Length': '0',
                        // 'Authorization': 'Bearer 87f760eb-9864-3a57-a143-368cda7fd23b'
                        'Authorization': syniverseNumAction.SyniverseAuth
                    },
                };
                request(options, (error, response) => {
                    if (!error) {
                        try {
                            let sinchStatus = result_did[0].sinch_status > 0 ? result_did[0].sinch_status : 0;
                            if (result_did[0].sinch_status == 5)
                                sinchStatus = 6;
                            if (result_did[0].sinch_status == 7)
                                sinchStatus = 8;
                            let objj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            objj.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='" + sinchStatus + "', `sinch_retry`=`sinch_retry`+1 WHERE `did` ='" + number + "' AND `disconnect_did_status`=1";
                            objj.prepare();
                            objj.execute((err1, resp1) => {
                                console.log("sinch_retry updated");
                            });
                            let data = JSON.parse(response.body);
                            if (data.status == 'OK') {
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'21','DID provisioning PENDING to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','2','" + response.body + "')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => { });
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='" + sinchStatus + "' WHERE  account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj1.prepare();
                                obj1.execute((err1, resp1) => {
                                    console.log("Request Submitted Successfully!");
                                    callback(1, { status: 200, message: "Request Submitted Successfully!" });
                                });
                            }
                            else if (data.status == 'ACCEPTED') {
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'19','DID provisioning ACCEPTED to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','3','" + response.body + "')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => { });
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='" + sinchStatus + "' WHERE  account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj2.prepare();
                                obj2.execute((err2, resp2) => {
                                    console.log("DID provisioned to SYNIVERSE.");
                                    callback(1, { status: 200, message: "DID provisioned to SYNIVERSE!" });
                                });
                            }
                            else if (data.status == 'CONFLICT') {
                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'20','DID provisioning CONFLICT to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','1','" + response.body + "')";
                                obj6.prepare();
                                obj6.execute((err6, resp6) => {
                                    console.log("DID Already Exists on SYNIVERSE.");
                                    callback(0, { status: 200, message: "DID Already Exists on SYNIVERSE" });
                                });
                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='" + sinchStatus + "' WHERE  account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj5.prepare();
                                obj5.execute((err5, resp5) => {
                                    console.log("ImportedNumber Already Exists on SYNIVERSE.");
                                    callback(0, { status: 200, message: "ImportedNumber Already Exists on SYNIVERSE" });
                                });
                            }
                            else if (data.status == 'BAD_REQUEST') {
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'19','DID provisioning ACCEPTED to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','3','" + response.body + "')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => { });
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='" + sinchStatus + "' WHERE  account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj2.prepare();
                                obj2.execute((err2, resp2) => {
                                    console.log("DID provisioned to SYNIVERSE.");
                                    callback(1, { status: 200, message: "DID provisioned to SYNIVERSE!" });
                                });
                            }
                            else {
                                let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj8.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`,`sinch_status`,`full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'23','DID provisioning DEPLOYED_FAILED/ADD_FAILED to SYNIVERSE','" + number.trim() + "','" + sdata.CampaignId + "','6','" + response.body + "')";
                                obj8.prepare();
                                obj8.execute((err8, resp8) => { });
                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='" + sinchStatus + "' WHERE  account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj7.prepare();
                                obj7.execute((err7, resp7) => {
                                    console.log("Imported Number Does Not Exists on SYNIVERSE!");
                                    callback(0, { status: 200, message: "Imported Number Does Not Exists on SYNIVERSE!" });
                                });
                            }
                        }
                        catch (e) {
                            console.log("Error :: SinchSubmitNumber->reEnableSMSFromSyniverse::", e);
                            callback(error, '');
                        }
                    }
                    else {
                        callback(error, '');
                    }
                });
            }
        });
    }
    reProvisioningToSinch(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        // let iduser: any = sdata.iduser ? sdata.iduser : this.sessdata.iduser;
        // let idaccount: any = sdata.idaccount ? sdata.idaccount : this.sessdata.idaccount;
        let sinchStatus = sdata.sinchStatus;
        var options = {
            'method': 'PATCH',
            // 'url': 'https://imported.numbers.api.sinch.com/v1beta1/projects/' + projectId + '/importedNumbers/+1' + number,
            'url': sinchNumAction.SinchUrl + sinchNumAction.SinchPId + '/importedNumbers/+1' + number,
            'headers': {
                'Content-Type': 'application/json',
                'projectId': sinchNumAction.SinchPId,
                // 'Authorization': 'Basic ZjBjNDg5ZGQtMjIwMy00ZGM5LTk2NGEtYzU5MDIxYjllZTc0OkV3Nllua35kZFhEMlVxbW9IeFd5d0RjekJf'
                'Authorization': sinchNumAction.SinchAuth
            },
            body: JSON.stringify({
                "smsConfiguration": {
                    "servicePlanId": sinchNumAction.SinchsrvPlanId,
                    "campaignId": sdata.CampaignId
                }
            })
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.smsConfiguration) {
                        let objj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        objj.nonqrysql = "UPDATE `did_buy` SET `sinch_retry`=`sinch_retry`+1 WHERE `did` ='" + number + "' AND `disconnect_did_status`=1";
                        objj.prepare();
                        objj.execute((err1, resp1) => {
                            console.log("sinch_retry updated");
                        });
                        if (data.smsConfiguration.scheduledProvisioning == "") {
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='1' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                            obj1.prepare();
                            obj1.execute((err1, resp1) => {
                                console.log("DID Buy Inserted with Sinch Status =>", 1, sdata.CampaignId);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, message: "Re-Provisioning successfully!" });
                                objv.execute();
                            });
                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '1', '" + response.body + "')";
                            obj4.prepare();
                            obj4.execute((err4, resp4) => {
                                console.log("DID Log Inserted with Sinch Status =>", 1, sdata.CampaignId);
                            });
                        }
                        else {
                            if (data.smsConfiguration.scheduledProvisioning.status == "WAITING") {
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `did_buy` SET `sinch_status`= '2' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj2.prepare();
                                obj2.execute((err2, resp2) => {
                                    console.log("DID Buy Inserted with Sinch Status =>", 2, sdata.CampaignId);
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Provisioning Waiting!" });
                                    objv.execute();
                                });
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '2', '" + response.body + "')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => {
                                    console.log("DID Log Inserted with Sinch Status =>", 2, sdata.CampaignId);
                                });
                            }
                            else {
                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='3' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj3.prepare();
                                obj3.execute((err3, resp3) => {
                                    console.log("DID Buy Inserted with Sinch Status =>", 3, sdata.CampaignId);
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Provisioning Inprogress!" });
                                    objv.execute();
                                });
                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '3', '" + response.body + "')";
                                obj4.prepare();
                                obj4.execute((err4, resp4) => {
                                    console.log("DID Log Inserted with Sinch Status =>", 3, sdata.CampaignId);
                                });
                            }
                        }
                    }
                    else {
                        if (data.error) {
                            let objj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            objj.nonqrysql = "UPDATE `did_buy` SET `sinch_retry`=`sinch_retry`+1 WHERE `did` ='" + number + "' AND `disconnect_did_status`=1";
                            objj.prepare();
                            objj.execute((err1, resp1) => {
                                console.log("sinch_retry updated");
                            });
                            if (data.error.status == "ALREADY_EXISTS") {
                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='4' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj5.prepare();
                                obj5.execute((err5, resp5) => {
                                    console.log("DID Buy Inserted with Sinch Status =>", 4, sdata.CampaignId);
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Provisioning Already Exist!" });
                                    objv.execute();
                                });
                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'7','DID provisioned to SINCH','" + number.trim() + "','" + sdata.CampaignId + "', '" + sinchStatus + "', '" + response.body + "')";
                                obj6.prepare();
                                obj6.execute((err6, resp6) => {
                                    console.log("DID Log Inserted with Sinch Status =>", 4, sdata.CampaignId);
                                });
                            }
                            else {
                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj7.nonqrysql = "UPDATE `did_buy` SET `sinch_status`='5' WHERE account_id = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                obj7.prepare();
                                obj7.execute((err7, resp7) => {
                                    console.log("DID Buy Inserted with Sinch Status =>", 5, sdata.CampaignId);
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Provisioning Failed!" });
                                    objv.execute();
                                });
                                let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj8.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`,`sinch_status`, `full_log`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'13','SINCH provisioning failed','" + number.trim() + "','" + sdata.CampaignId + "', '5', '" + response.body + "')";
                                obj8.prepare();
                                obj8.execute((err8, resp8) => {
                                    console.log("DID Log Inserted with Sinch Status =>", 5, sdata.CampaignId);
                                });
                            }
                        }
                    }
                }
                catch (e) {
                    console.log("Error :: SinchSubmitNumber->reProvisioningToSinch::", e);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Provisioning Not Successful!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Provisioning Not Successful!" });
                objv.execute();
            }
        });
    }
}
exports.SinchApi = SinchApi;
