"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwaggerApi = void 0;
const Session_1 = require("../lib/model/Session");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const _406_1 = require("../lib/view/406");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const numberApi_1 = require("./numberApi");
const APIBase_1 = require("./APIBase");
const markError_1 = require("./markError");
const request = require("request");
const Str = require('@supercharge/strings');
const makeNumber = (length) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeChar = (length) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeRanChar = (length) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const generatePassword = () => {
    let result = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
};
class SwaggerApi {
    constructor() {
    }
    BuyTollfree(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    const sdata = req.query;
                    if (sdata.Quantity) {
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT e.idendpoint, e.connection_key, i.inbound_key, o.outbound_key FROM `endpoint` e JOIN `inbound` i ON e.idendpoint = i.idendpoint JOIN `outbound` o ON e.idendpoint = o.idendpoint WHERE e.`isDefault`='true' AND e.`iduser`= '" + sessdata.iduser + "'";
                        obj0.prepare();
                        obj0.execute((connErr, connRes) => {
                            if (connErr == 1) {
                                let connKey = connRes.length > 0 ? connRes[0].connection_key : '';
                                let inbounKey = connRes.length > 0 ? connRes[0].inbound_key : '';
                                let outboundKey = connRes.length > 0 ? connRes[0].outbound_key : '';
                                let GOpayload = {
                                    name: "SOD" + String(new Date().getTime()),
                                    total_dids: sdata.Quantity,
                                    numbers: '',
                                    routing: connKey,
                                    in_routing: inbounKey,
                                    out_routing: outboundKey,
                                    campaign: '',
                                    sessdata: sessdata
                                };
                                let swag = new SwaggerApi();
                                swag.CreateGroupOrder(req, res, GOpayload, (error, response) => {
                                    if (error == 1) {
                                        let groupID = response.data.id_grouporder;
                                        let numberapi = new numberApi_1.Number();
                                        numberapi.BuyTollfreeNumber(req, res, groupID, err => {
                                            if (err == 0) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: "200", message: "Tollfree Order Created Successfully!" });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 503, message: "Service Unavailable!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 201, message: "Group Order is not Created!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 507, message: "Quantity is required" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    CreateGroupOrder(req, res, GOpayload, callback) {
        let checkService = new APIBase_1.APIBase();
        checkService.serviceActivation(req, res, GOpayload.sessdata, "5", (err, resp) => {
            if (resp.status == 200) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let totalDID = GOpayload.total_dids;
                let process_dids = 0;
                obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + GOpayload.sessdata.iduser + ", idaccount=" + GOpayload.sessdata.idaccount + ", name='" + GOpayload.name + "', total_dids=" + (0, markError_1.setToZero)(totalDID) + ", process_dids=" + (0, markError_1.setToZero)(process_dids) + ", numbers='" + GOpayload.numbers + "', routing='" + GOpayload.routing + "', in_routing='" + GOpayload.in_routing + "', out_routing='" + GOpayload.out_routing + "', campaign='" + GOpayload.campaign + "';";
                obj.prepare();
                obj.execute((error, result) => {
                    callback(1, {
                        status: 202,
                        message: "Group successfully created.",
                        data: {
                            id_grouporder: result.insertId
                        }
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error: 1,
                    status: resp.status,
                    message: resp.message.replace(/::SN::/g, "DID Buy")
                });
                objv.execute();
            }
        });
    }
}
exports.SwaggerApi = SwaggerApi;
