"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelDetail = void 0;
const ModelObject_1 = require("./ModelObject");
class ModelDetail extends ModelObject_1.ModelObject {
    prepare() {
        var ret = true;
        if (this.table.length < 1 || this.table == 'undefined' || this.table == null) {
            console.log("Table is not defined properly.");
            ret = false;
        }
        if (this._data.length > 1) {
            this.query.field = this._data;
        }
        else {
            console.log("SELECT fields are not defined properly.");
            ret = false;
        }
        if (this.req.params.hasOwnProperty('filter')) {
            this.query.filter = Object.assign(JSON.parse(this.req.params.filter), this._filter);
            this.query.isfilter = true;
        }
        else {
            if (this.req.params.hasOwnProperty('id')) {
                this.query.filter = Object.assign({ id: this.req.params.id }, this._filter);
                this.query.isfilter = true;
            }
            else {
                console.log("Filter data is not found into the request");
                return false;
            }
        }
        return ret;
    }
    execute(callback) {
        this.query.prepare();
        this.query.Row((err, data) => {
            this.respond(err, data, callback);
        });
    }
}
exports.ModelDetail = ModelDetail;
