"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminApis = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const RawQuery_1 = require("../lib/model/RawQuery");
const numberApi_1 = require("./numberApi");
const markError_1 = require("./markError");
class AdminApis {
    constructor() {
        // super();
    }
    /******************** *
    * Number APIs Started *
    * =================== *
    ********************* */
    EnableSMSAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    const sdata = req.body;
                    let userPayLoad1 = {
                        iduser: sdata.iduser,
                        idaccount: sdata.idaccount
                    };
                    let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `idtariff` FROM `user` WHERE `idaccount`= '" + sdata.idaccount + "' LIMIT 1";
                    obj1.prepare();
                    obj1.execute((proration_error, tariffdata) => {
                        if (proration_error == 1) {
                            let otherPayLoad = {
                                idtariff: tariffdata[0].idtariff
                            };
                            let numberapi = new numberApi_1.Number();
                            numberapi.EnableSMS(req, res, userPayLoad, otherPayLoad, next);
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    DisableSMSAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                if (sessdata.type == 1) {
                    const sdata = req.query;
                    let userPayLoad1 = {
                        iduser: sdata.iduser,
                        idaccount: sdata.idaccount
                    };
                    let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                    let numberapi = new numberApi_1.Number();
                    numberapi.DisableSMS(req, res, userPayLoad, next);
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
}
exports.AdminApis = AdminApis;
