"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TwoFactorAuth = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const net_1 = require("net");
const setting_config_1 = require("../config/setting.config");
const lrnApi_1 = require("./lrnApi");
const APIBase_1 = require("./APIBase");
const markError_1 = require("./markError");
const vs_server = new setting_config_1.VoiceServer();
const prefix = vs_server.Prefix;
const Str = require("@supercharge/strings");
var request = require("request");
const factorAuth = new setting_config_1.twofaAuth();
class TwoFactorAuth {
    constructor() { }
    SendOtpBySMS(req, res, next) {
        let sdata = req.body.data == undefined ? req.body : req.body.data;
        if (sdata.FROM != undefined && sdata.TO != undefined) {
            const uuid = Str.random(30);
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                        let checkService = new APIBase_1.APIBase();
                        checkService.serviceActivation(req, res, sessdata, "1", (err, resp) => {
                            if (resp.status == 200) {
                                let template_key = req.body.data == undefined ? sdata.TemplateKey : sdata.template[0].id;
                                let condition = '';
                                if (template_key) {
                                    condition = "`template_key` = '" + template_key + "'";
                                }
                                else {
                                    condition = "`default`='1'";
                                }
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT `body`,`otp_digit` FROM 2fa_template WHERE " + condition + " AND `tmp_type`='sms' AND `iduser`='" + sessdata.iduser + "'";
                                obj1.execute((errr, rest) => {
                                    let otppDgt;
                                    let msgBody;
                                    if (rest.length > 0) {
                                        otppDgt = rest[0].otp_digit;
                                        msgBody = rest[0].body;
                                    }
                                    else {
                                        otppDgt = 5;
                                        msgBody = "This is your ONE TIME passcode: {OTP}";
                                    }
                                    if (otppDgt && msgBody) {
                                        let otp_size1 = "1";
                                        let opt_size = "9";
                                        for (let i = 1; i < otppDgt; i++) {
                                            opt_size += "0";
                                            otp_size1 += "0";
                                        }
                                        let otp = Math.floor(parseInt(otp_size1) + Math.random() * parseInt(opt_size));
                                        let message = msgBody;
                                        message = message.replace(/{OTP}/g, +otp);
                                        var headers = {
                                            accept: "*/*",
                                            Authorization: sessdata.authkey,
                                            "Content-Type": "application/x-www-form-urlencoded",
                                        };
                                        var dataString = "FROM=" + sdata.FROM + "&TO=" + sdata.TO + "&BODY=" + message;
                                        var options = {
                                            url: req.protocol + "://" + req.get("host") + "/sms",
                                            method: "POST",
                                            headers: headers,
                                            body: dataString,
                                        };
                                        request(options, (error, responce) => {
                                            if (!error) {
                                                let data = JSON.parse(responce.body);
                                                if (data.message == "SMS Submit Successfully") {
                                                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj0.nonqrysql =
                                                        "INSERT INTO `two_factor_auth` (`from`, `to`,`iduser`,`otp`,`session_id`) VALUES('" +
                                                            sdata.FROM +
                                                            "','" +
                                                            sdata.TO +
                                                            "','" +
                                                            sessdata.iduser +
                                                            "','" +
                                                            otp +
                                                            "','" +
                                                            uuid +
                                                            "')";
                                                    obj0.prepare();
                                                    obj0.execute((otp_error, otp_resp) => {
                                                        if (otp_error == 1) {
                                                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj.qrysql =
                                                                "SELECT `session_id` FROM `two_factor_auth`  WHERE `id`='" +
                                                                    otp_resp.insertId +
                                                                    "'";
                                                            obj.prepare();
                                                            obj.execute((otp_err, resp) => {
                                                                if (otp_err == 1) {
                                                                    let obj1 = new RawView_1.RawView(res);
                                                                    obj1.prepare({
                                                                        status: 200,
                                                                        message: "OTP send Successfully",
                                                                        result: resp,
                                                                    });
                                                                    obj1.execute();
                                                                }
                                                                else {
                                                                    let obj1 = new RawView_1.RawView(res);
                                                                    obj1.prepare({
                                                                        status: 502,
                                                                        message: "Something went wrong",
                                                                    });
                                                                    obj1.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let obj1 = new RawView_1.RawView(res);
                                                            obj1.prepare({
                                                                status: 502,
                                                                message: "Something went wrong",
                                                            });
                                                            obj1.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let obj1 = new RawView_1.RawView(res);
                                                    obj1.prepare({ status: 502, message: data.message });
                                                    obj1.execute();
                                                }
                                            }
                                            else {
                                                let obj1 = new RawView_1.RawView(res);
                                                obj1.prepare({
                                                    status: 502,
                                                    message: "Something went wrong",
                                                });
                                                obj1.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let obj1 = new RawView_1.RawView(res);
                                        obj1.prepare({ status: 502, message: "Something went wrong with OTP!" });
                                        obj1.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error_code: err,
                                    status: resp.status,
                                    message: resp.message.replace(/::SN::/g, "SMS")
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare({ status: 404, message: "Not Permitted" });
                        objvs.execute();
                    }
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                status: 500,
                message: "All fields are required, FROM, TO",
            });
            objv.execute();
        }
    }
    SendOtpByCall(req, res, next) {
        let sdata = req.body;
        if (sdata.FROM != undefined && sdata.TO != undefined) {
            const uuid = Str.random(30);
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                        let san = 100000000 + sessdata.idaccount;
                        let checkService = new APIBase_1.APIBase();
                        checkService.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                            if (resp.status == 200) {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                let template = sdata.template == undefined ? sdata.Template : sdata.template[0].id;
                                let condition;
                                if (template == 'true' || template == 'false') {
                                    condition = "iduser='1'";
                                }
                                else {
                                    condition = "id2fa_template='" + template + "'";
                                }
                                obj.qrysql = "SELECT `body`,`otp_digit` FROM 2fa_template WHERE tmp_type='voice' AND " + condition + "";
                                obj.prepare();
                                obj.execute((err, result) => {
                                    if (err == 1 && Array.isArray(result) && result.length > 0) {
                                        let otp_size1 = "1";
                                        let opt_size = "9";
                                        for (let i = 1; i < result[0].otp_digit; i++) {
                                            opt_size += "0";
                                            otp_size1 += "0";
                                        }
                                        let otp = Math.floor(parseInt(otp_size1) + Math.random() * parseInt(opt_size)).toString();
                                        var otp1 = "";
                                        for (let i = 0; i <= otp.length - 1; i++) {
                                            otp1 += otp[i] + ". ";
                                        }
                                        let message = result[0].body;
                                        message = message.replace(/{OTP}/g, " " + otp1);
                                        let socketData = "{sip_cid_type=rpid,origination_caller_id_name=" + sdata.FROM.trim() + ",origination_caller_id_number=" + sdata.FROM.trim() + ",dialed_number=" + sdata.TO + ",san=" + san + "}sofia/gateway/iplink/8279#" + sdata.TO.trim() + " &'javascript(tts.js " + message + ")'";
                                        let client = new net_1.Socket();
                                        client.connect(parseInt(vs_server.PORT), vs_server.HOST1, function () {
                                            client.write("auth " + vs_server.PASS + "\n\n");
                                            client.write("api originate " + socketData + "\n\n");
                                            client.on("data", (respon) => {
                                                let tmp1 = respon.toString().split(" ");
                                                if (tmp1[0] == "-ERR") {
                                                    res.status(503).send({ message: respon.toString() });
                                                }
                                                else {
                                                    let tmp = respon.toString().split("\n");
                                                    tmp.forEach((elem) => {
                                                        if (elem != undefined) {
                                                            if (elem.length > 0) {
                                                                let tmp2 = elem.split(" ");
                                                                if (tmp2[0] == "-ERR") {
                                                                    return res
                                                                        .status(503)
                                                                        .send({ message: tmp2[1], status: 503 });
                                                                }
                                                                else {
                                                                    let t1 = elem.split("OK");
                                                                    if (t1.length == 2) {
                                                                        if (t1[0] == "+") {
                                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj.nonqrysql = "INSERT INTO `2fa_otp_voice`( `from`, `to`, `iduser`, `otp`,`session_id`) VALUES ('" + sdata.FROM + "','" + sdata.TO + "','" + sessdata.iduser + "','" + otp + "','" + sessdata.authkey + "')";
                                                                            obj.prepare();
                                                                            obj.execute((err, result) => {
                                                                                if (err == 1) {
                                                                                    res
                                                                                        .status(200)
                                                                                        .send({
                                                                                        message: "Call Connected Successfully",
                                                                                        uuid: t1[1].trim(),
                                                                                        status: 201,
                                                                                    });
                                                                                }
                                                                                else {
                                                                                    res
                                                                                        .status(200)
                                                                                        .send({
                                                                                        message: "Call Connected Successfully But Error With Send OTP!",
                                                                                        uuid: t1[1].trim(),
                                                                                        status: 201,
                                                                                    });
                                                                                }
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                                // else{
                                                                // res.status(400).send({ message: "Call Connected Successfully", uuid: t1[1].trim() });
                                                                // }
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                            client.on("error", (e) => {
                                            });
                                            client.on("end", () => { });
                                        });
                                    }
                                    else {
                                        res
                                            .status(200)
                                            .send({
                                            message: "Call Connected Successfully But Error With Send OTP!",
                                            status: 201,
                                        });
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error_code: err,
                                    status: resp.status,
                                    message: resp.message.replace(/::SN::/g, "Send OTP By Call")
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare({ status: 404, message: "Not Permitted" });
                        objvs.execute();
                    }
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                status: 500,
                message: "All fields are required, FROM, TO",
            });
            objv.execute();
        }
    }
    VerifyOtp(req, res, next) {
        let sdata = req.body;
        if (sdata.OTP != undefined && sdata.SessionId != undefined) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        //obj.qrysql ="SELECT * FROM `two_factor_auth`  WHERE `otp`='" +sdata.OTP +"' AND `session_id`='" +sdata.SessionId +"' AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300";
                        obj.qrysql = "SELECT * FROM `two_factor_auth`  WHERE `session_id`='" + sdata.SessionId + "' AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300 ORDER BY id DESC LIMIT 1";
                        obj.execute((verf_otp_error, verf_otp_resp) => {
                            if (verf_otp_error == 1) {
                                if (verf_otp_resp.length > 0 && verf_otp_resp[0].otp == sdata.OTP) {
                                    let obj1 = new RawView_1.RawView(res);
                                    obj1.prepare({
                                        status: 200,
                                        message: "OTP Verified Successfully",
                                    });
                                    obj1.execute();
                                }
                                else {
                                    let obj1 = new RawView_1.RawView(res);
                                    obj1.prepare({ status: 404, message: "Your OTP is expired" });
                                    obj1.execute();
                                }
                            }
                            else {
                                let obj1 = new RawView_1.RawView(res);
                                obj1.prepare({ status: 502, message: "Something went wrong!" });
                                obj1.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare({ status: 404, message: "Not Permitted" });
                        objvs.execute();
                    }
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                status: 500,
                message: "All fields are required, FROM, TO",
            });
            objv.execute();
        }
    }
    verifyCallOtp(req, res, next) {
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT `otp` FROM `2fa_otp_voice` WHERE `iduser` = '" + sessdata.iduser + "' AND `otp`='" + sdata.otp + "' AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created_at)<300";
            obj.prepare();
            obj.execute((error, getEmail) => {
                if (error == 1) {
                    if (getEmail.length > 0) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`= 'true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((_error, success) => {
                            if (_error == 1) {
                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj5.prepare();
                                obj5.execute((_sessErr, sessRes) => {
                                    if (_sessErr == 1) {
                                        let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                        obj6.prepare();
                                        obj6.execute((_sessError, sessData) => {
                                            if (_sessError == 1) {
                                                let objup = new RawQuery_1.ModelRawQuery(req, res);
                                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                                objup.prepare();
                                                objup.execute((__errorE, emailE) => {
                                                    let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj7.qrysql = "SELECT * FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                    obj7.prepare();
                                                    obj7.execute((sError, sData) => {
                                                        if (sError == 1) {
                                                            let tmp = "{\"email\": \"" + emailE[0].email + "\"}";
                                                            let emType = JSON.parse(tmp);
                                                            let sData1 = Object.assign(sData, emType);
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                message: "OTP Verified!",
                                                                status: 200,
                                                                session: sData1
                                                            });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                message: "OTP Verified Error With Connection!",
                                                                status: 502
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Mobile Number Not Verified!",
                                                    status: 500
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            errMessage: "Mobile Number Not Verified!",
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Mobile Number Not Verified!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "You Have Enter Wrong OTP!",
                            status: 502
                        });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        message: "Something Went Wrong With Connection!",
                        status: 502
                    });
                    objv.execute();
                }
            });
        });
    }
    sendMMSTemplate(req, res, next) {
        let sdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `body`, `file_path` FROM `mms_template` WHERE `idmms_template`='" + sdata.template + "'";
                obj0.prepare();
                obj0.execute((error, result) => {
                    if (error == 1) {
                        let text;
                        let file;
                        let subject;
                        text = result[0].body;
                        file = result[0].file_path;
                        subject = result[0].name;
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT d.did, c.campaign_key, d.iduser FROM `did_buy` d INNER JOIN `campaign` c ON c.campaign_key=d.camp_registry WHERE d.did='" + sdata.FROM + "' AND d.iduser='" + sessData.iduser + "'";
                        obj1.prepare();
                        obj1.execute((err_r, res_t) => {
                            if (err_r == 1 && res_t.length > 0) {
                                let campaignID = res_t[0].campaign_key;
                                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`=(SELECT upstreamCnpId FROM `campaign` WHERE `campaign_key`='" + campaignID + "' AND `deleted`=0 LIMIT 1)";
                                obj2.prepare();
                                obj2.execute((camperr, campres) => {
                                    let PayLoad = {
                                        TO: sdata.TO
                                    };
                                    let toNum = PayLoad.TO.replace(/\s/g, '').replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');
                                    if (toNum && toNum.length == 10 && isNaN(toNum) === false) {
                                        let lerg = new lrnApi_1.LergApi("", "");
                                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                            let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                                            let baseapi = new APIBase_1.APIBase();
                                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                                if (lerg_info.length > 0) {
                                                    if (camperr == 1 && campres.length > 0) {
                                                        let extension = file.split('.').pop();
                                                        let fType;
                                                        if (extension == 'jpg' || extension == 'jpeg' || extension == 'png' || extension == 'gif' || extension == 'webp') {
                                                            fType = [{ image: { "url": file }, 'message-text': text }];
                                                        }
                                                        else if (extension == 'pdf') {
                                                            fType = [{ pdf: { url: file }, 'message-text': text }];
                                                        }
                                                        else if (extension == 'mp3') {
                                                            fType = [{ audio: { url: file }, 'message-text': text }];
                                                        }
                                                        else {
                                                            fType = [{ video: { url: file }, 'message-text': text }];
                                                        }
                                                        var options = {
                                                            'method': 'POST',
                                                            'url': factorAuth.Url,
                                                            // 'url': 'https://api.ci.mblox.com/ep/v2/',
                                                            'headers': {
                                                                'Content-Type': 'application/json',
                                                                'x-api-key': factorAuth.Key
                                                                // 'x-api-key': '4ZFnGzsQnEspkuOsUWxMHY5FSBaqmue0'
                                                            },
                                                            body: JSON.stringify({
                                                                "action": "sendMMS",
                                                                "service-id": campaignID,
                                                                "to": "1" + sdata.TO,
                                                                "from": "1" + sdata.FROM,
                                                                "from-mask": "1" + sdata.FROM,
                                                                "message-subject": subject,
                                                                "fallback-sms-text": "MMS",
                                                                "disable-fallback-sms-link": false,
                                                                "disable-fallback-sms": false,
                                                                "slide": fType
                                                            })
                                                        };
                                                        request(options, (error, response) => {
                                                            if (!error) {
                                                                try {
                                                                    let OptionStatus = JSON.parse(options.body);
                                                                    let From_number = OptionStatus['from'];
                                                                    let To_number = OptionStatus['to'];
                                                                    let from_mask = OptionStatus['from-mask'];
                                                                    let tracking_id = OptionStatus['tracking-id'];
                                                                    let dStatus = JSON.parse(response.body);
                                                                    let dSta = dStatus['status'];
                                                                    let messageData = '';
                                                                    if (dSta == 'success') {
                                                                        messageData = dStatus['status-details'];
                                                                    }
                                                                    if (dSta == 'failure') {
                                                                        messageData = dStatus['error-info'];
                                                                    }
                                                                    if (!error && dSta == 'success') {
                                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj3.nonqrysql = "INSERT INTO `mms_mdr`(`idaccount`,`iduser`,`batch_id`,`number_type`,`to_number`,`from_number`,`messsage_body`,`status`,`service_id`,`from_mask`,`message_subject`,`fallback-sms-text`,`slide`,`direction`,`status_details`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','" + tracking_id + "','','" + To_number + "','" + From_number + "','" + text + "','" + dSta + "','" + campaignID + "','" + from_mask + "','" + subject + "','" + text + "','" + file + "','outbound','" + messageData + "')";
                                                                        obj3.prepare();
                                                                        obj3.execute((error11, ress) => {
                                                                            if (error11 == 1) {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: "MMS Sent Successfully!", status: 201 });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: "MMS Not Send!", status: 502, });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                        obj4.nonqrysql = "INSERT INTO `mms_mdr`(`idaccount`,`iduser`,`batch_id`,`number_type`,`to_number`,`from_number`,`messsage_body`,`status`,`service_id`,`from_mask`,`message_subject`,`fallback-sms-text`,`slide`,`direction`,`status_details`) VALUES ('" + sessData.idaccount + "','" + sessData.iduser + "','failed','','" + To_number + "','" + From_number + "','" + text + "','" + dSta + "','" + campaignID + "','" + from_mask + "','" + subject + "','" + text + "','" + file + "','outbound','" + messageData + "')";
                                                                        obj4.prepare();
                                                                        obj4.execute((error15, ress) => {
                                                                            if (error15 == 1) {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ message: `MMS not Send due to ${messageData}`, status: 400 });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                                catch (e) {
                                                                    console.log("Error :: TwoFactorAuth->sendMMSTemplate::", e);
                                                                    let obj = new RawView_1.RawView(res);
                                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                    obj.execute();
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 404, message: "CampaignId does not match!" });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 404, message: "CampaignId does not match!" });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 404, message: "Lerg Info Not Found" });
                                                    objv.execute();
                                                }
                                            });
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Invalid Number Please Enter Only 10 Digit!", status: 401 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, message: "CampaignID Not Found on this DID!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 404, message: "MMS Template Not Found!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access !", status: 401 });
                objv.execute();
            }
        });
    }
    SendOtpByCallOnboarding(req, res, next) {
        let sdata = req.body;
        let toNumber = sdata.Country == 'us' ? '1' + sdata.TO : sdata.TO;
        if (sdata.FROM != undefined && sdata.TO != undefined) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                    let san = 100000000 + sessdata.idaccount;
                    let checkService = new APIBase_1.APIBase();
                    checkService.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                        if (resp.status == 200) {
                            let objI = new RawQuery_1.ModelRawQuery(req, res);
                            objI.qrysql = "SELECT `ip_address`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `contact` = '" + sdata.TO.trim() + "'";
                            objI.prepare();
                            objI.execute((_errDomainBlk, getDomainBlock) => {
                                if (_errDomainBlk == 1 && getDomainBlock.length > 0) {
                                    let errMsg = '';
                                    if (getDomainBlock[0].contact == sdata.TO.trim())
                                        errMsg = "Invalid Contact Number!";
                                    else if (getDomainBlock[0].ipAddress == sysInfo.ipAddress[0])
                                        errMsg = "Invalid Detail!";
                                    else
                                        errMsg = "You Can't Use This Number!";
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: errMsg,
                                        status: 501
                                    });
                                    objv.execute();
                                }
                                else {
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT `body`,`otp_digit` FROM 2fa_template WHERE iduser='1' AND tmp_type='voice'";
                                    obj.prepare();
                                    obj.execute((err, result) => {
                                        if (err == 1 && Array.isArray(result) && result.length > 0) {
                                            let otp_size1 = "1";
                                            let opt_size = "9";
                                            for (let i = 1; i < result[0].otp_digit; i++) {
                                                opt_size += "0";
                                                otp_size1 += "0";
                                            }
                                            let otp = Math.floor(parseInt(otp_size1) + Math.random() * parseInt(opt_size)).toString();
                                            var otp1 = "";
                                            for (let i = 0; i <= otp.length - 1; i++) {
                                                otp1 += otp[i] + ". ";
                                            }
                                            let message = result[0].body;
                                            message = message.replace(/{OTP}/g, " " + otp1);
                                            let socketData = "{sip_cid_type=rpid,origination_caller_id_name=" + sdata.FROM.trim() + ",origination_caller_id_number=" + sdata.FROM.trim() + ",dialed_number=" + toNumber + ",san=" + san + "}sofia/gateway/iplink/" + prefix + toNumber.trim() + " &'javascript(tts.js " + message + ")'";
                                            let client = new net_1.Socket();
                                            client.connect(parseInt(vs_server.PORT), vs_server.HOST1, function () {
                                                client.write("auth " + vs_server.PASS + "\n\n");
                                                client.write("api originate " + socketData + "\n\n");
                                                client.on("data", (respon) => {
                                                    let tmp1 = respon.toString().split(" ");
                                                    if (tmp1[0] == "-ERR") {
                                                        res.status(503).send({ message: respon.toString() });
                                                    }
                                                    else {
                                                        let tmp = respon.toString().split("\n");
                                                        tmp.forEach((elem) => {
                                                            if (elem != undefined) {
                                                                if (elem.length > 0) {
                                                                    let tmp2 = elem.split(" ");
                                                                    if (tmp2[0] == "-ERR") {
                                                                        return res
                                                                            .status(503)
                                                                            .send({ message: tmp2[1], status: 503 });
                                                                    }
                                                                    else {
                                                                        let t1 = elem.split("OK");
                                                                        if (t1.length == 2) {
                                                                            if (t1[0] == "+") {
                                                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                obj.nonqrysql = "INSERT INTO `2fa_otp_voice`( `from`, `to`, `iduser`, `otp`,`session_id`) VALUES ('" + sdata.FROM + "','" + sdata.TO + "','" + sessdata.iduser + "','" + otp + "','" + sessdata.authkey + "')";
                                                                                obj.prepare();
                                                                                obj.execute((err, result) => {
                                                                                    if (err == 1) {
                                                                                        res.status(200).send({
                                                                                            message: "Call Connected Successfully",
                                                                                            uuid: t1[1].trim(),
                                                                                            status: 201,
                                                                                        });
                                                                                    }
                                                                                    else {
                                                                                        res.status(200).send({
                                                                                            message: "Call Connected Successfully But Error With Send OTP!",
                                                                                            uuid: t1[1].trim(),
                                                                                            status: 201,
                                                                                        });
                                                                                    }
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        });
                                                    }
                                                });
                                                client.on("error", (e) => {
                                                });
                                                client.on("end", () => { });
                                            });
                                        }
                                        else {
                                            res
                                                .status(200)
                                                .send({
                                                message: "Call Connected Successfully But Error With Send OTP!",
                                                status: 201,
                                            });
                                        }
                                    });
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error_code: err,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "Send OTP By Call")
                            });
                            objv.execute();
                        }
                    });
                    // To maintain the phone log
                    let objj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    objj0.nonqrysql = "INSERT INTO `phone_verification_log` (`iduser`,`idaccount`,`did`,`ipaddress`,`verification_through`,`verification_via`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + toNumber + "','" + sysInfo.ipAddress[0] + "','0','1')";
                    objj0.prepare();
                    objj0.execute((_error, result) => {
                        console.log("Log Inserted Successfully!");
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                status: 500,
                message: "All fields are required, FROM, TO",
            });
            objv.execute();
        }
    }
}
exports.TwoFactorAuth = TwoFactorAuth;
