"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VoiceRates = void 0;
const hashmap_1 = __importDefault(require("hashmap"));
// import { AppRoute } from "../lib/AppRoute";
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const Session_1 = require("../lib/model/Session");
const markError_1 = __importDefault(require("./markError"));
class VoiceRates {
    rate_data;
    constructor() {
        this.rate_data = new hashmap_1.default();
    }
    count() {
        return this.rate_data.count();
    }
    getDIDRate(did) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == "800" || digit == "822" || digit == "9" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("toll_free_number");
        }
        else if (digit == "808" && number.length == 10) {
            return this.rate_data.get("united_states - Hawaii (Zone 2)");
        }
        else if (digit == "907" && number.length == 10) {
            return this.rate_data.get("united_states - Alaska (Zone 3)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("local_number");
        }
        else {
            return this.rate_data.get("sip_interface");
        }
    }
    getCallRate(did) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == "800" || digit == "822" || digit == "833" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("united_states_toll_free");
        }
        else if (digit == "808" && number.length == 10) {
            return this.rate_data.get("united_states - Hawaii (Zone 2)");
        }
        else if (digit == "907" && number.length == 10) {
            return this.rate_data.get("united_states - Alaska (Zone 3)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        else {
            return this.rate_data.get("sip_interface");
        }
    }
    getCallRates(did, zone) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == "800" || digit == "822" || digit == "833" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("united_states_toll_free");
        }
        else if (zone) {
            switch (zone) {
                case "Zone 2":
                    return this.rate_data.get("united_states - Hawaii (Zone 2)808");
                case "Zone 3":
                    return this.rate_data.get("united_states - Alaska (Zone 3)907");
                case "Zone 4":
                    return this.rate_data.get("united_state High Cost (Zone 4)");
                case "Zone 5":
                    return this.rate_data.get("united_state High Cost (Zone 5)");
                default:
                    return this.rate_data.get("united_states_lower 48 (Zone 1)");
            }
        }
        else {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        /* else {
            return this.rate_data.get("sip_trunking");
        } */
    }
    getZone(req, res, did, callback) {
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 6);
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `tz` FROM `zones` WHERE `npanxx`='" + digit + "'";
        obj1.prepare();
        obj1.execute((err, zone) => {
            if (err && zone.length > 0) {
                callback("", zone[0].tz);
            }
            else {
                callback("0", "");
            }
        });
    }
    AMDRate(status) {
        if (status == "true")
            return this.rate_data.get("answering_machine_detection");
        else
            return "0";
    }
    RecordRate(status) {
        if (status == "true") {
            console.log("record", this.rate_data.get("call_recording"));
            return this.rate_data.get("call_recording");
        }
        else
            return "0";
    }
    setRate(data) {
        this.rate_data = data;
    }
    getType(did) {
        console.log("did", did);
        let rate_type;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        console.log("number", number);
        let digit = number.slice(0, 3);
        console.log("digit", digit);
        if ((digit == 800 || digit == 822 || digit == 833 || digit == 844 || digit == 855 || digit == 866 || digit == 877 || digit == 888) && number.length == 10) {
            rate_type = "TF";
        }
        else if (number.length == 10) {
            rate_type = "NN";
        }
        else {
            rate_type = "short_code";
        }
        return rate_type;
    }
    prepareRate(req, res, tariff, type, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT IF(`rate`>0,`rate`,`mt`) `rate` ,`category` FROM `voice_rates` WHERE `idtariff`='" + tariff + "'  AND `type`='" + type + "'";
        obj1.prepare();
        obj1.execute((err, voice_rate) => {
            if (voice_rate.length > 0) {
                voice_rate.forEach((element) => {
                    this.rate_data.set(element.category, element.rate);
                });
                callback("", this.rate_data);
            }
            else {
                callback(err, "");
            }
        });
    }
    verifyDid(req, res, callback) {
        let sdata = req.body;
        let didNumber = sdata.FROM;
        // let len = didNumber.length - 10;
        // let number = didNumber.slice(len, didNumber.length);
        let session = new Session_1.SessionManagment(req, res, () => { });
        session.GetSession((error, sessdata) => {
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT * FROM `did_buy` WHERE `did`='" + didNumber + "'";
            obj.prepare();
            obj.execute((err, did) => {
                if (did.length > 0) {
                    callback('', 1);
                }
                else {
                    callback('', 1);
                }
            });
        });
    }
    getState(req, res, did, callback) {
        let len = did.length - 10;
        var npa = did.slice(len, len + 3);
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT loc_state FROM `did_location_info` WHERE `npa`='" + npa + "' LIMIT 1";
        obj1.prepare();
        obj1.execute((err, state) => {
            if (state.length > 0) {
                callback("", state);
            }
            else {
                callback(err, "");
            }
        });
    }
    async insertBatch(req, res, dataBatch) {
        let iQry = `INSERT INTO lerg_info (npa, nxx, block, ocn, lata, state, co_name_spec_c, category, lergdate, region, lata_name, country, rate_center) VALUES `;
        dataBatch.forEach((DID) => {
            iQry += `('${(0, markError_1.default)(DID[0])}','${(0, markError_1.default)(DID[1])}','${(0, markError_1.default)(DID[2])}','${(0, markError_1.default)(DID[3])}','${(0, markError_1.default)(DID[4])}','${(0, markError_1.default)(DID[5])}','${(0, markError_1.default)(DID[6])}','${(0, markError_1.default)(DID[7])}','${(0, markError_1.default)(DID[8])}','${(0, markError_1.default)(DID[9])}','${(0, markError_1.default)(DID[10])}','${(0, markError_1.default)(DID[11])}','${(0, markError_1.default)(DID[12])}'),`;
        });
        iQry = iQry.slice(0, -1);
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = iQry;
        obj.prepare();
        return new Promise((resolve, reject) => {
            obj.execute((error, result) => {
                if (error == 1) {
                    console.log("Inserted batch successfully:", result);
                    resolve(result);
                }
                else {
                    console.error("Error inserting batch:", error);
                    reject(new Error('Failed to insert batch'));
                }
            });
        });
    }
}
exports.VoiceRates = VoiceRates;
