"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.APIBase = void 0;
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const net_1 = require("net");
//import { VoiceServer, UploadDirectory, Setting, GetRate } from "../config/setting.config";
const setting_config_1 = require("../config/setting.config");
const RawView_1 = require("../lib/view/RawView");
const common_lib_1 = require("./common.lib");
const markError_1 = require("./markError");
var request = require('request');
//const getRatE = new GetRate();
const vs_server = new setting_config_1.VoiceServer();
const prefix = vs_server.Prefix;
const scriptUrl = new setting_config_1.MicroservicesUrlandKey();
const server_1 = require("../server");
class APIBase {
    constructor() {
    }
    getLRN(lrn_detail) {
        if (lrn_detail.hasOwnProperty('errors')) {
            if (lrn_detail.errors[0] == "LRN Not Found.") {
                return true;
            }
            else
                return false;
        }
        else
            return false;
    }
    prorateCalculator(req, res, proration, rates, setup_cost, callback) {
        console.log("Prorate Data for Calculate :: ", { proration: proration, rates: rates, setup_cost: setup_cost });
        const parsedRates = parseFloat(rates);
        const parsedSetupCost = parseFloat(setup_cost);
        const errors = [
            isNaN(parsedRates) && "rates",
            isNaN(parsedSetupCost) && "setup cost"
        ].filter(Boolean);
        const errorMessage = errors.length > 0 ? errors.join(", ") : null;
        if (errorMessage) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 506, message: "Something went wrong with [" + errorMessage + "]" });
            objv.execute();
            return;
        }
        let dateObj = new Date();
        let day = dateObj.getUTCDate();
        let nDate = new Date();
        let lDate = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate();
        let totalDays = (lDate - day) + 1;
        let prorate;
        if (proration == "true")
            prorate = ((totalDays * parseFloat(rates)) / lDate) + parseFloat(setup_cost);
        else
            prorate = (parseFloat(rates)) + parseFloat(setup_cost);
        console.log("Final Prorate :: ", prorate);
        callback(1, (0, markError_1.setToZero)(parseFloat(prorate).toFixed(3)));
    }
    subscriptionProrationCalculator(req, res, idaccount, callback) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT sa.subscription_id, s.proration, s.mrc,s.quantity FROM subscription s JOIN subscription_account sa ON sa.subscription_id = s.subscription_id JOIN `account` ab ON sa.idaccount = ab.idaccount WHERE sa.idaccount = '" + idaccount + "' AND ab.subscription_payment = 0;";
        obj.prepare();
        obj.execute((err, result) => {
            let totalProrate = 0;
            let errors = [];
            result.forEach((entry) => {
                const parsedRates = parseFloat(entry.mrc);
                const parsedQuantity = parseInt(entry.quantity);
                const prorateFlag = parseInt(entry.proration);
                if (isNaN(parsedRates))
                    errors.push("mrc");
                if (isNaN(parsedQuantity))
                    errors.push("quantity");
                if (isNaN(prorateFlag))
                    errors.push("proration");
                if (errors.length > 0)
                    return;
                let dateObj = new Date();
                let day = dateObj.getUTCDate();
                let nDate = new Date();
                let lDate = new Date(nDate.getFullYear(), nDate.getMonth() + 1, 0).getDate();
                let totalDays = lDate - day + 1;
                let prorate;
                let prate = (parsedQuantity * parsedRates);
                if (entry.proration == "1") {
                    prorate = (totalDays * prate) / lDate;
                }
                else {
                    prorate = prate;
                }
                totalProrate += prorate;
            });
            if (errors.length > 0) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    status: 506,
                    message: "Something went wrong with [" + errors.join(", ") + "]",
                });
                objv.execute();
                return;
            }
            callback(1, (0, markError_1.setToZero)(parseFloat(totalProrate).toFixed(3)));
        });
    }
    prorateCalculatorwallet(req, res, mrc, proration, quantity, callback) {
        let totalProrate = 0;
        let errors = [];
        const parsedRates = parseFloat(mrc);
        const parsedQuantity = parseInt(quantity);
        const prorateFlag = parseInt(proration);
        if (isNaN(parsedRates))
            errors.push("mrc");
        if (isNaN(parsedQuantity))
            errors.push("quantity");
        if (isNaN(prorateFlag))
            errors.push("proration");
        if (errors.length > 0) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                status: 506,
                message: "Something went wrong with [" + errors.join(", ") + "]",
            });
            objv.execute();
            return;
        }
        let dateObj = new Date();
        let day = dateObj.getUTCDate();
        let nDate = new Date();
        let lDate = new Date(nDate.getFullYear(), nDate.getMonth() + 1, 0).getDate();
        let totalDays = lDate - day + 1;
        let prorate;
        let prate = (parsedQuantity * parsedRates);
        if (proration == "1") {
            prorate = (totalDays * prate) / lDate;
        }
        else {
            prorate = prate;
        }
        totalProrate = prorate;
        // Fix: toFixed() string deta hai, usko parseFloat se number banaya hai.
        callback(1, (0, markError_1.setToZero)(parseFloat(totalProrate.toFixed(3))));
    }
    getLRNRate(req, res, tariff, type, category, callback) {
        let cat;
        if (category !== 'lrn' && category !== 'lrn_dnc') {
            return false;
        }
        if (category == 'lrn' || 'lrn_dnc') {
            cat = "lrn";
        }
        if (category == 'lrn_dnc') {
            cat = "lrn_dnc";
        }
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `rate` FROM `lookup_api_rates` WHERE `idtariff`='" + tariff + "'  AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
        obj1.prepare();
        obj1.execute((err, rates) => {
            if (err == 1) {
                let rt = [];
                rt = rates.length > 0 ? rates : [Object.assign({ rate: 0 }, rates[0])];
                callback(1, rt);
            }
            else {
                callback(0, "");
            }
        });
    }
    getRate(req, res, tariff, type, category, callback) {
        let cat;
        if (category == 'TF' || category == 'NN') {
            cat = category == 'TF' ? "toll_free_number" : "local_number";
        }
        if (category == 'VN') {
            cat = category == 'VN' ? "vanity_number" : "";
        }
        if (category == '') {
            return false;
        }
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `final_rate` as `rate`, `billing_frequency` FROM `voice_rates` WHERE `idtariff`='" + tariff + "'  AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
        obj1.prepare();
        obj1.execute((err, rates) => {
            if (err == 1) {
                let rate = rates[0].rate;
                let rt = [];
                rt = rates.length > 0 ? [Object.assign({ rate: rate }, rates[0]), rates[0].billing_frequency] : [Object.assign({ rate: 0 }, rates[0].rate), rates[0].billing_frequency];
                callback(err, rt);
            }
            else {
                callback(err, '');
            }
        });
    }
    /* public getRate(req: Request, res: Response, tariff: number, type: string, category: string, callback: (err: any, data: any) => void) {
      if (!category) {
          return res.status(400).json({
              status: 400,
              message: 'Category is required',
          });
      }
  
      let cat: any;
      if (category == 'TF' || category == 'NN') {
        cat = category == 'TF' ? "toll_free_number" : "local_number";
      }
      if (category == 'VN') {
        cat = category == 'VN' ? "vanity_number" : "";
      }
      if (category == '') {
        return false;
      }
  
      const options = {
          method: 'GET',
          url: `${scriptUrl.RedisDAta}/getrate/${tariff}/${type}/${cat}`,
          headers: {
              'Content-Type': 'application/json',
              Authorization: scriptUrl.KEY,
          },
      };
  
      request(options, (error: any, response: any, body: any) => {
        if (error) {
          console.error('Request failed:', error);
          return res.status(500).json({
            status: 500,
            message: 'Request failed due to network error.',
            error: error.message,
          });
        }
    
        if (!response || response.statusCode !== 200) {
          console.error('Unexpected response status:', response?.statusCode);
          return res.status(response?.statusCode || 500).json({
            status: response?.statusCode || 500,
            message: 'Unexpected response from the server.',
          });
        }
  
        try {
          const data = JSON.parse(body);
          console.log("Helooooooo",data)
        
          if (data?.success) {
            let rate;
            let billingFrequency;
        
            if (typeof data.data?.report_data === 'string') {
              const reportData = JSON.parse(data.data.report_data);
              rate = reportData?.rate;
              billingFrequency = reportData?.billing_frequency;
            } else if (Array.isArray(data.data) && data.data.length > 0) {
              rate = data.data[0]?.rate;
              billingFrequency = data.data[0]?.billing_frequency;
            }
        
            if (rate !== undefined && billingFrequency !== undefined) {
              const result = [{ rate, billing_frequency: billingFrequency }, billingFrequency];
              return callback(1, result);
            } else {
              console.error('Rate or billing frequency not found in data');
              return res.status(500).json({
                status: 500,
                message: 'Rate or billing frequency not found in response data.',
              });
            }
          } else {
            console.error('API error:', data.message || 'Unknown error');
            return res.status(data.status || 500).json({
              status: data.status || 500,
              message: data.message || 'Unknown error occurred.',
            });
          }
        } catch (parseError: any) {
          console.error('Error parsing response body:', parseError);
          return res.status(500).json({
            status: 500,
            message: 'Error parsing response body.',
            error: parseError.message,
          });
        }
        
      });
    }*/
    checkBalance1(req, res, idaccount, Rate, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + idaccount + "' AND `balance` + `credit_limit` >= '" + Rate + "'";
        obj1.prepare();
        obj1.execute((err, rates) => {
            if (err == 1 && rates.length > 0)
                callback(1, rates);
            else
                callback(0, "");
        });
    }
    checkBalance(req, res, idaccount, Rate, callback) {
        if (Rate > 0) {
            let options = {
                'method': 'GET',
                'url': scriptUrl.BalanceCheckURL + '/wallet/getbalance/' + idaccount,
                'headers': {
                    'Content-Type': 'application/json',
                    'Authorization': scriptUrl.KEY
                },
            };
            request(options, (error, response, body) => {
                try {
                    if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
                        let data = JSON.parse(response.body);
                        if (data.status == 200) {
                            if (data) {
                                if (data.data.totalBalance > Rate) {
                                    callback(1, data);
                                }
                                else {
                                    callback(0, '');
                                }
                            }
                            else {
                                this.checkBalance1(req, res, idaccount, Rate, callback);
                            }
                        }
                        else {
                            this.checkBalance1(req, res, idaccount, Rate, callback);
                        }
                    }
                    else {
                        this.checkBalance1(req, res, idaccount, Rate, callback);
                    }
                }
                catch (e) {
                    console.error("Error parsing response body:", e);
                    this.checkBalance1(req, res, idaccount, Rate, callback);
                }
            });
        }
        else {
            if (Rate == 0) {
                callback(1, '');
            }
            else {
                callback(0, '');
            }
        }
    }
    checkSwaggerBalance1(req, res, idaccount, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT idaccount, IF(`balance`+`credit_limit`>0,1,0) isbalance, balance,(`balance`+`credit_limit`) `totalBalance` FROM wallet WHERE idaccount='" + idaccount + "' LIMIT 1";
        obj1.prepare();
        obj1.execute((err, rates) => {
            if (err == 1 && rates.length > 0)
                callback(1, rates[0]);
            else
                callback(0, "");
        });
    }
    checkSwaggerBalance(req, res, idaccount, callback) {
        if (idaccount) {
            let options = {
                'method': 'GET',
                'url': scriptUrl.BalanceCheckURL + '/wallet/getbalance/' + idaccount,
                'headers': {
                    'Content-Type': 'application/json',
                    'Authorization': scriptUrl.KEY
                },
            };
            request(options, (error, response, body) => {
                try {
                    if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
                        let data = JSON.parse(response.body);
                        if (data.status == 200) {
                            if (data) {
                                callback(1, data.data);
                            }
                            else {
                                this.checkSwaggerBalance1(req, res, idaccount, callback);
                            }
                        }
                        else {
                            this.checkSwaggerBalance1(req, res, idaccount, callback);
                        }
                    }
                    else {
                        this.checkSwaggerBalance1(req, res, idaccount, callback);
                    }
                }
                catch (e) {
                    console.error("Error : checkSwaggerBalance1 ::", e);
                    this.checkSwaggerBalance1(req, res, idaccount, callback);
                }
            });
        }
        else {
            callback(1, '');
        }
    }
    checkLergInfoDetail1(req, res, npa, nxx, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`, `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`=" + npa + " AND `nxx`=" + nxx + "";
        obj1.prepare();
        obj1.execute((err, data) => {
            if (err == 1 && data.length > 0)
                callback(1, data[0]);
            else
                callback(0, "");
        });
    }
    checkLergInfoDetail(req, res, npa, nxx, callback) {
        if (npa && nxx) {
            let options = {
                'method': 'GET',
                'url': scriptUrl.LergInfoDetailURL + '/getLergeInfoDetail/' + npa + '/' + nxx,
                'headers': {
                    'Content-Type': 'application/json',
                    'Authorization': scriptUrl.KEY
                },
            };
            request(options, (error, response, body) => {
                try {
                    if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body) {
                        let data = JSON.parse(response.body);
                        if (data.status == 200) {
                            if (data.data) {
                                callback(1, data.data);
                            }
                            else {
                                this.checkLergInfoDetail1(req, res, npa, nxx, callback);
                            }
                        }
                        else {
                            this.checkLergInfoDetail1(req, res, npa, nxx, callback);
                        }
                    }
                    else {
                        this.checkLergInfoDetail1(req, res, npa, nxx, callback);
                    }
                }
                catch (e) {
                    console.error("Error parsing response body->checkLergInfoDetail:", e);
                    this.checkLergInfoDetail1(req, res, npa, nxx, callback);
                }
            });
        }
        else {
            callback(0, '');
        }
    }
    getMessageRate(req, res, tariff, type, category, callback) {
        let cat;
        if (category == 'NN') {
            cat = "local_number";
        }
        if (category == 'TF') {
            cat = "toll_free_number";
        }
        if (category == '') {
            return false;
        }
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `nrc`, `mrc` FROM `message_activation_pricing` WHERE `idtariff`='" + tariff + "'  AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
        obj1.prepare();
        obj1.execute((err, rates) => {
            if (err == 1) {
                let rt = [];
                rt = rates.length > 0 ? rates : [Object.assign({ nrc: 0, mrc: 0 }, rates[0])];
                callback(err, rt);
            }
            else {
                callback(err, "");
            }
        });
    }
    checkNumberType(did, callback) {
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let type = '';
        if ((npa == "800" || npa == "822" || npa == "833" || npa == "844" || npa == "855" || npa == "866" || npa == "877" || npa == "888")) {
            console.log("Number Type is Toll-free ", did);
            type = 'toll_free';
            callback(0, { message: "Number Type is Toll-free!", data: type });
        }
        else if (did.length == 10) {
            console.log("Number Type is Local Number ", did);
            type = '10_dlc';
            callback(1, { message: "Number Type is Local Number!", data: type });
        }
        else {
            console.log("Number Type is Short-Code ", did);
            type = 'short_code';
            callback(2, { message: "Number Type is Short-Code!", data: type });
        }
    }
    checkSCType(req, res, did, callback) {
        if (!did) {
            return callback(0, { status: 403, message: "Invalid Shortcode!" });
        }
        const obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT scp.migrated_campaign FROM did_buy db LEFT JOIN sc_request sr ON db.camp_registry = sr.sc_campaign_unique_id LEFT JOIN sc_campaign_profile scp ON sr.profile_id = scp.id_profile WHERE db.did = " + did + " AND db.sinch_status=1 AND db.disconnect_did_status=1 GROUP BY db.did;";
        obj1.prepare();
        obj1.execute((err, sctype) => {
            if (err !== 1) {
                return callback(0, { status: 500, message: "Something went wrong with Shortcode detail!" });
            }
            if (!sctype || sctype.length === 0) {
                return callback(0, { status: 405, message: "Shortcode data not found!" });
            }
            let type = '', iSCType = 1, trfSCType = "short_code";
            switch (sctype[0].migrated_campaign) {
                case 1:
                    type = "ShortCode";
                    iSCType = 1;
                    trfSCType = "short_code";
                    break;
                case 2:
                    type = "FreeToEndUserShortCode";
                    iSCType = 2;
                    trfSCType = "free_to_end_user";
                    break;
                default:
                    type = "ShortCode";
                    iSCType = 1;
                    trfSCType = "short_code";
            }
            console.log("SC Type : " + type + "iType : " + iSCType);
            return callback(1, { scType: type, intSCType: iSCType, trfSCType: trfSCType });
        });
    }
    getTollfreeSMSRate(req, res, tariff, type, category, callback) {
        let cat;
        if (category == 'toll_free') {
            cat = "toll_free";
        }
        if (category == '') {
            return false;
        }
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `MT_rates` FROM `sms_rate` WHERE `id_tariff`='" + tariff + "'  AND `category`='" + cat + "' AND `subcategory`='" + type + "' LIMIT 1";
        obj1.prepare();
        obj1.execute((err, rates) => {
            if (err == 1) {
                let rt = [];
                rt = rates.length > 0 ? rates : [Object.assign({ MO_rates: 0 }, rates[0])];
                callback(err, rt);
            }
            else {
                callback(err, "");
            }
        });
    }
    saveHmp(timekey, provider, data) {
        let existingArray = server_1.DIDSearchHMData.get(timekey);
        if (!existingArray) {
            existingArray = []; // Initialize if the key does not exist
        }
        let key = timekey + '_' + provider;
        let obj = {
            [key]: data
        };
        existingArray.push(obj);
        server_1.DIDSearchHMData.set(timekey, existingArray);
        // return DIDSearchHMData;
    }
    shuffleArray(array) {
        for (let i = array.length - 1; i > 0; i--) {
            const j = Math.floor(Math.random() * (i + 1));
            [array[i], array[j]] = [array[j], array[i]];
        }
        return array;
    }
    getSearchedDID(prodata, qty) {
        const allRecords = [];
        for (const obj of prodata) {
            const key = Object.keys(obj)[0];
            const records = obj[key];
            allRecords.push(...records);
        }
        const shuffledRecords = this.shuffleArray(allRecords);
        const result = shuffledRecords.slice(0, qty);
        return result;
    }
    getCampaignRate(req, res, tariff, type, category, callback) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT `rate` FROM `campaign_rates` WHERE `idtariff`='" + tariff + "' AND `type`='" + type + "'  AND `category`='" + category + "' LIMIT 1";
        obj.prepare();
        obj.execute((err, rates) => {
            if (err == 1) {
                let rt = [];
                rt = rates.length > 0 ? rates : [Object.assign({ rate: 0 }, rates[0])];
                callback(err, rt);
            }
            else {
                callback(err, "");
            }
        });
    }
    getRateCenter(req, res, npa, nxx, callback) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT `rc_abbre`, `loc_state` FROM `did_location_info` WHERE `npa`='" + npa + "'  AND `nxx`='" + nxx + "'";
        obj.prepare();
        obj.execute((err, ratecenter_state) => {
            if (ratecenter_state.length > 0) {
                callback('', ratecenter_state);
            }
            else {
                callback(err, '');
            }
        });
    }
    getLrnDetails(req, res, did, callback) {
        did = "" + did + "";
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let npa = number.slice(0, 3);
        let nxx = number.slice(3, 6);
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT *  FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
        obj1.prepare();
        obj1.execute((err, lrn_details) => {
            if (lrn_details.length > 0) {
                let lrn_result = Object.assign({ lrn: number }, lrn_details[0]);
                callback('', [lrn_result]);
            }
            else {
                callback(err, '');
            }
        });
    }
    getApiRate(req, res, idaccount, req_type, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT req_hits, rate_limit, req_type FROM `api_rate_limit` WHERE req_type = " + req_type + " AND `idaccount` = " + idaccount + " AND `type`=2 AND req_hits < rate_limit";
        obj1.prepare();
        obj1.execute((err, resp) => {
            if (err == 1) {
                if (resp.length > 0) {
                    callback(1, { status: 200, message: "Request Allowed." });
                }
                else {
                    callback(0, { status: 429, message: 'Too Many Requests. You have exceeded the request limit. Please try again later.' });
                }
            }
            else {
                callback(0, { status: 502, message: "Something went wrong with Request!" });
            }
        });
    }
    calculateNextBillingDate(req, res, billf, callback) {
        let calculatedDate;
        const currentDate = new Date();
        // const currentDay = currentDate.getUTCDate() + 5; 
        const currentDay = currentDate.getUTCDate();
        console.log("Current Day:", currentDay);
        console.log("Billing Frequency:", billf);
        let billingfreq = parseFloat(billf);
        if (billingfreq === 0) {
            calculatedDate = new Date(Date.UTC(currentDate.getUTCFullYear(), currentDate.getUTCMonth() + 1, 1));
        }
        else if (billingfreq === 1 || billingfreq === 2 || billingfreq === 3) {
            // Billing Frequency 1, 2, 3: Calculate based on the anniversary date
            const monthsToAdd = billingfreq === 1 ? 3 : billingfreq === 2 ? 6 : 12; // Define months to add
            // Calculate the target month and year
            let targetMonth = currentDate.getUTCMonth() + monthsToAdd;
            let targetYear = currentDate.getUTCFullYear();
            if (targetMonth > 11) {
                targetMonth -= 12;
                targetYear += 1;
            }
            const maxDaysInTargetMonth = new Date(Date.UTC(targetYear, targetMonth + 1, 0)).getUTCDate();
            const adjustedDay = Math.min(currentDay, maxDaysInTargetMonth);
            calculatedDate = new Date(Date.UTC(targetYear, targetMonth, adjustedDay));
            console.log("Next Date Before Adjustment:", calculatedDate);
            // If the currentDay is 29, 30, or 31 and exceeds the max days, default to the 28th
            console.log("currentDay :: ", currentDay);
            console.log("maxDaysInTargetMonth :: ", maxDaysInTargetMonth);
            if (currentDay > maxDaysInTargetMonth || currentDay >= 29) {
                calculatedDate = new Date(Date.UTC(targetYear, targetMonth, 28));
            }
        }
        else {
            callback(0, { status: 404, message: "Invalid billing frequency" });
            return;
        }
        let formattedDate = calculatedDate ? calculatedDate.toISOString().slice(0, 19).replace('T', ' ') : null;
        console.log("Formatted Date ::", formattedDate);
        callback(1, formattedDate);
        return;
    }
    updateApiRate(req, res, idaccount, req_type, callback) {
        let objj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        objj.nonqrysql = "UPDATE `api_rate_limit` SET `req_hits`=`req_hits`+1 WHERE req_type = " + req_type + " AND `type`=2 AND  `idaccount` = " + idaccount + "";
        objj.prepare();
        objj.execute((err1, resp1) => {
            console.log("Request Hits Updated");
        });
    }
    serviceActivation1(req, res, idaccount, fservice_id, callback) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "SELECT fs_id, idaccount, as_status FROM `account_service`  WHERE `idaccount` = " + idaccount + " AND as_status ='1' AND fs_id=" + fservice_id + "";
        obj1.prepare();
        obj1.execute((_err, resp) => {
            if (_err == 1) {
                if (resp.length > 0) {
                    callback(1, { data: resp, message: "::SN:: service is activated", status: 200 });
                }
                else {
                    callback(0, { data: resp, message: "::SN:: service has been suspended. More information please contact support", status: 501 });
                }
            }
            else {
                callback(0, { message: "Something went wrong with ::SN:: service activation", status: 502 });
            }
        });
    }
    serviceActivation(req, res, sessdata, fservice_id, callback) {
        let options = {
            'method': 'GET',
            // 'url': 'http://localhost:3001/getService/' + sessdata.idaccount +'/'+ fservice_id,
            'url': scriptUrl.ServiceActivationURL + '/getService/' + sessdata.idaccount + '/' + fservice_id,
            'headers': {
                'Content-Type': 'application/json',
                'Authorization': scriptUrl.KEY
            },
        };
        request(options, (error, response, body) => {
            try {
                if (response && response.body) {
                    let data = JSON.parse(response.body);
                    if (data) {
                        if (data.status == 200) {
                            if (data.data.fs_id = parseInt(fservice_id) && data.data.as_status == 1) {
                                callback(1, data);
                            }
                            else {
                                callback(0, { status: 501, message: "::SN:: service has been suspended. More information please contact support" });
                            }
                        }
                        else if (data.status == 502) {
                            callback(0, { message: data.message, status: 501 });
                        }
                        else {
                            this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
                        }
                    }
                    else {
                        this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
                    }
                }
                else {
                    this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
                }
            }
            catch (e) {
                console.error("Error serviceActivation :: ", e);
                this.serviceActivation1(req, res, sessdata.idaccount, fservice_id, callback);
            }
        });
    }
    getMasterSlave(req, res, sessdata, idactoridusr, type, callback) {
        let iduser, idaccount, con = '', condition;
        if (type == 2) {
            idaccount = idactoridusr;
            con = '`master_idaccount` = ' + idactoridusr;
        }
        else {
            iduser = idactoridusr;
            con = '`master_iduser` = ' + idactoridusr;
        }
        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `master_iduser`,`slave_iduser`, `master_idaccount` , `slave_idaccount` FROM `customer_group_mapping` WHERE " + con + " AND `cm_status` = '0'";
        obj0.prepare();
        obj0.execute((err, cmRes) => {
            if (err == 1) {
                if (type == 22 || type == 1) {
                    if (cmRes.length > 0) {
                        let masterIduser = cmRes.map((row) => row.slave_iduser);
                        masterIduser.push(iduser);
                        condition += '`iduser` IN(' + masterIduser.join(',') + ')';
                    }
                    else {
                        condition += '`iduser`= ' + iduser + '';
                    }
                }
                else if (type == 2) {
                    if (cmRes.length > 0) {
                        let masterIdaccount = cmRes.map((row) => row.slave_idaccount);
                        masterIdaccount.push(idaccount);
                        condition += '`idaccount` IN(' + masterIdaccount.join(',') + ')';
                    }
                    else {
                        condition += '`idaccount`= ' + idaccount + '';
                    }
                }
                else {
                    callback(1, { status: 501, message: "Customer does not exist during ::MG::" });
                }
                callback(1, { status: 200, message: "Group Found Successfully during ::MG:: ", condition: condition });
            }
            else {
                callback(0, { status: 502, message: "Something went wrong with finding detail during ::MG::" });
            }
        });
    }
    DialCall(req, res, next, sessdata, lerg_data, vrate, callback) {
        let socketData = '{caller_id_number=' + req.body.CALLER.trim() + ',dialed_number=' + req.body.CALLEE.trim() + ',effective_caller_id_name=' + req.body.CALLER.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + (0, markError_1.setToZero)(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_to=' + vrate.getCallRate(req.body.CALLER) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',ctype=4,ocn=' + lerg_data[0].ocn + ',category=' + lerg_data[0].category + ',mobility=' + lerg_data[0].co_name_spec_c + ',effective_caller_id_number=' + req.body.CALLER.trim() + ',origination_caller_id_name=' + req.body.CALLER.trim() + ',origination_caller_id_number=' + req.body.CALLER.trim() + '}sofia/gateway/iplink/' + prefix + req.body.CALLER.trim() + ' &bridge({caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.CALLEE.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',effective_caller_id_number=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + (0, markError_1.setToZero)(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_from=' + vrate.getCallRate(req.body.CALLER) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',ctype=4,rec_rate=' + vrate.RecordRate(req.body.Recording) + ',lata=' + lerg_data[0].lata + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}sofia/gateway/iplink/' + prefix + req.body.CALLEE.trim() + ')';
        let client = new net_1.Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
            client.write('auth ' + vs_server.PASS + '\n\n');
            ;
            client.write('api originate ' + socketData + '\n\n');
            client.on("data", (respon) => {
                let tmp = respon.toString().split("\n");
                tmp.forEach((elem) => {
                    if (elem != undefined) {
                        if (elem.length > 0) {
                            let t1 = elem.split("OK");
                            if (t1.length == 2) {
                                if (t1[0] == "+") {
                                    res.send({ status: 201, message: "Call connected successfully", uuid: t1[1].trim() });
                                }
                            }
                            let t2 = elem.split("ERR");
                            if (t2.length == 2) {
                                res.send({ status: 404, message: t2[1].trim() });
                                client.end();
                            }
                        }
                    }
                });
            });
            client.on("error", (e) => {
            });
            client.on("end", (err) => {
            });
        });
    }
    makeCall(req, res, next, sessdata, lerg_data, vrate, callback) {
        let socketData = '{caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.TO.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',effective_caller_id_number=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + (0, markError_1.setToZero)(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_from=' + vrate.getCallRate(req.body.Extension) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}user/' + req.body.Extension.trim() + ' &bridge({caller_id_number=' + req.body.FROM.trim() + ',dialed_number=' + req.body.TO.trim() + ',effective_caller_id_name=' + req.body.FROM.trim() + ',iduser=' + sessdata.iduser + ',idapi=' + (0, markError_1.setToZero)(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_to=' + vrate.getCallRate(req.body.TO) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',rec_rate=' + vrate.RecordRate(req.body.Recording) + ',ocn=' + lerg_data[0].ocn + ',category=' + lerg_data[0].category + ',mobility=' + lerg_data[0].co_name_spec_c + ',effective_caller_id_number=' + req.body.FROM.trim() + ',origination_caller_id_name=' + req.body.FROM.trim() + ',origination_caller_id_number=' + req.body.FROM.trim() + '}sofia/gateway/iplink/' + prefix + req.body.TO.trim() + ')';
        let client = new net_1.Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
            console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
            client.write('auth ' + vs_server.PASS + '\n\n');
            console.log("Password : " + vs_server.PASS);
            console.log(socketData);
            client.write('api originate ' + socketData + '\n\n');
            client.on("data", (respon) => {
                let tmp = respon.toString().split("\n");
                tmp.forEach((elem) => {
                    if (elem != undefined) {
                        if (elem.length > 0) {
                            console.log(elem);
                            let t1 = elem.split("OK");
                            if (t1.length == 2) {
                                console.log(t1);
                                if (t1[0] == "+") {
                                    res.status(200).send({ message: "Call Connected Successfully", uuid: t1[1].trim() });
                                }
                            }
                        }
                    }
                });
            });
            client.on("error", (e) => {
                console.log(e);
            });
            client.on("end", () => {
            });
        });
    }
    makeCallviaMedia(req, res, next, sessdata, lerg_data, vrate, callback) {
        let sdata = req.body;
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT `uploaded_file`,`iduser` FROM `upload_media` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "' AND `media_id`='" + sdata.mediaID + "'";
        obj.prepare();
        obj.execute((err, result) => {
            if (result.length > 0) {
                let dir = new setting_config_1.UploadDirectory();
                let mediapath = dir.FREESWITCHUPLOAD + result[0].uploaded_file;
                let vz = new common_lib_1.VoiceRates();
                vz.getZone(req, res, lerg_data[0].lrn, (errr, zone) => {
                    let socketData = '{caller_id_number=' + req.body.FROM + ',dialed_number=' + req.body.TO + ',effective_caller_id_name=' + req.body.FROM + ',effective_caller_id_number=' + req.body.FROM + ',iduser=' + sessdata.iduser + ',idapi=' + (0, markError_1.setToZero)(sessdata.idapi) + ',accountcode=' + sessdata.idaccount + ',leg_from=' + vrate.getCallRates(lerg_data[0].lrn, zone) + ',amd_rate=' + vrate.AMDRate(req.body.AMD) + ',ctype=4,rec_rate=' + vrate.RecordRate(req.body.Recording) + ',lata=' + lerg_data[0].lata + ',origination_caller_id_name=' + req.body.FROM + ',origination_caller_id_number=' + req.body.FROM + ',ignore_early_media=true}sofia/gateway/iplink/' + prefix + req.body.TO + ' &playback(' + mediapath + ')';
                    let client = new net_1.Socket();
                    client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                        try {
                            client.write('auth ' + vs_server.PASS + '\n\n');
                            console.log("Password : " + vs_server.PASS);
                            console.log(socketData);
                            client.write('api originate ' + socketData + '\n\n');
                            client.on("data", (respon) => {
                                let tmp = respon.toString().split("\n");
                                tmp.forEach((elem) => {
                                    if (elem != undefined) {
                                        if (elem.length > 0) {
                                            console.log(elem);
                                            let t1 = elem.split("OK");
                                            if (t1.length == 2) {
                                                console.log(t1);
                                                if (t1[0] == "+") {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 200, message: "Call Connected Successfully!", uuid: t1[1].trim() });
                                                    objv.execute();
                                                }
                                            }
                                        }
                                    }
                                });
                            });
                            client.on("error", (e) => {
                                console.log(e);
                            });
                            client.on("end", () => {
                            });
                        }
                        catch (e) {
                            console.log("Error :: makeCallviaMedia ::", e);
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ error_code: 0, status: 502, message: "Something Went Wrong!" });
                            obj.execute();
                        }
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 404, message: "MediaID is Invalid Please Provide Correct MediaID!" });
                objv.execute();
            }
        });
    }
    ThreeWayCall(req, res, next, sessdata, lerg_data, vrate, callback) {
        let digit;
        digit = req.body.TONE;
        let client = new net_1.Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
            console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
            client.write('auth ' + vs_server.PASS + '\n\n');
            console.log("Password : " + vs_server.PASS);
            client.write("api originate {effective_caller_id_name=+14233016767,effective_caller_id_number=+14233016767,origination_caller_id_name=+14233016767,origination_caller_id_number=+14233016767,ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + ",idapi=' + sessdata.idapi + ',leg_other=" + vrate.getCallRate(req.body.Number) + "}sofia/gateway/iplink/" + prefix + req.body.Number + " XML default");
            console.log("api originate {effective_caller_id_name=+14233016767,effective_caller_id_number=+14233016767,origination_caller_id_name=+14233016767,origination_caller_id_number=+14233016767,ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + ",idapi=' + sessdata.idapi + ',leg_other=" + vrate.getCallRate(req.body.Number) + "}sofia/gateway/iplink/" + prefix + req.body.Number + " XML default");
            client.on("data", (respon) => {
                console.log("respon", respon.toString);
                let tmp = respon.toString().split("\n");
                console.log("tmp", tmp);
                tmp.forEach((elem) => {
                    console.log("elem", elem);
                    if (elem != undefined) {
                        if (elem.length > 0) {
                            console.log(elem);
                            let t1 = elem.split("OK");
                            console.log("t1", t1);
                            if (t1.length == 2) {
                                console.log(t1);
                                if (t1[0] == "+") {
                                    res.status(200).send(t1[1].trim());
                                    console.log("uuid_bridge" + req.body.UUID + " " + t1[1].trim());
                                    client.write("uuid_bridge" + req.body.UUID + " " + t1[1].trim());
                                    client.destroy();
                                }
                            }
                        }
                    }
                });
            });
            client.on("error", (e) => {
                console.log(e);
            });
            client.on("end", () => {
            });
        });
    }
    Barge(req, res, next, sessdata, lerg_data, vrate, callback) {
        req.body.FROM = "4233016767";
        let cmd = "api originate {effective_caller_id_name=" + req.body.FROM.trim() + ",effective_caller_id_number=" + req.body.FROM.trim() + ",origination_caller_id_name=" + req.body.FROM.trim() + ",origination_caller_id_number=" + req.body.FROM.trim() + ",leg_other=" + vrate.getCallRate(req.body.Number) + ",idapi=" + (0, markError_1.setToZero)(sessdata.idapi) + ",ocn=" + lerg_data[0].ocn + ",category=" + lerg_data[0].category + ",mobility=" + lerg_data[0].co_name_spec_c + "}sofia/gateway/iplink/" + prefix + req.body.Number + " 88" + req.body.Extension + "";
        console.log(cmd);
        let client = new net_1.Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
            console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
            client.write('auth ' + vs_server.PASS + '\n\n');
            console.log("Password : " + vs_server.PASS);
            client.write(cmd + '\n\n');
            client.on("data", (respon) => {
                let tmp = respon.toString().split("\n");
                tmp.forEach((elem) => {
                    if (elem != undefined) {
                        if (elem.length > 0) {
                            console.log(elem);
                            let t1 = elem.split("OK");
                            if (t1.length == 2) {
                                console.log(t1);
                                if (t1[0] == "+") {
                                    res.status(200).send(t1[1].trim());
                                    client.destroy();
                                }
                            }
                        }
                    }
                });
            });
            client.on("error", (e) => {
                console.log(e);
            });
            client.on("end", () => {
            });
        });
    }
    CallTransfer(req, res, next, sessdata, lerg_data, vrate, callback) {
        let length = req.body.Number.length;
        if (length == 7) {
            var socketData = req.body.UUID + " -bleg " + req.body.Number + " XML default";
        }
        else {
            var socketData = req.body.UUID.trim() + " -bleg 88791" + req.body.Number.trim() + " XML default";
        }
        let client = new net_1.Socket();
        client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
            console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
            client.write('auth ' + vs_server.PASS + '\n\n');
            console.log("Password : " + vs_server.PASS);
            console.log(socketData);
            client.write('api uuid_transfer ' + socketData + '\n\n');
            client.on("data", (respon) => {
                let tmp = respon.toString().split("\n");
                tmp.forEach((elem) => {
                    if (elem != undefined) {
                        if (elem.length > 0) {
                            console.log(elem);
                            let t1 = elem.split("OK");
                            if (t1.length == 2) {
                                console.log(t1);
                                if (t1[0] == "+") {
                                    client.write("api uuid_setvar " + req.body.UUID + " leg_other " + vrate.getCallRate(req.body.Number) + '\n\n');
                                    res.status(200).send(t1[1].trim());
                                    client.destroy();
                                }
                            }
                        }
                    }
                });
            });
            client.on("error", (e) => {
                console.log("Error", e);
            });
            client.on("end", () => {
                console.log("End");
            });
        });
    }
    login(req, res, callback) {
        var options = {
            'method': 'POST',
            'url': 'https://apicontrol.call48.com/api/v4/login',
            'headers': {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                'user_name': 'iplink1',
                "password": "kzwJQV4arc4",
            }),
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let sdata = JSON.parse(response.body);
                    if (sdata.code == 200) {
                        let authkey = sdata.data.token;
                        callback('', authkey);
                    }
                    else {
                        callback(sdata, '');
                    }
                }
                catch (e) {
                    console.log("Error :: login ::", e);
                    callback(error, '');
                }
            }
            else {
                callback(error, '');
            }
        });
    }
}
exports.APIBase = APIBase;
