"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionManagement = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const stripeApi_1 = require("./stripeApi");
const markError_1 = require("./markError");
const APIBase_1 = require("./APIBase");
let rate = new APIBase_1.APIBase();
class SubscriptionManagement {
    constructor() {
    }
    getSubscriptionForterrif(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id,  sa.idaccount,  sa.subscription_id,  sa.quantity AS account_quantity, sa.start_date,  sa.end_date,  sa.status, s.name, s.mrc, s.nrc, s.quantity AS subscription_quantity, s.description, s.proration, s.type, s.billing_frequency, a.san, up.firstname, up.lastname, stm.idtariff FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser LEFT JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE  sa.idaccount = '" + sessdata.idaccount + "' AND stm.idtariff='" + sessdata.idtariff + "'";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    getsubscriptionforuser(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id,  sa.idaccount,  sa.subscription_id,  sa.quantity AS account_quantity,  sa.start_date,  sa.end_date,  sa.status,  s.name,  s.mrc,  s.nrc,  s.quantity AS subscription_quantity,  s.description,  s.type,  s.billing_frequency,  a.san,  up.firstname,  up.lastname,  stm.idtariff FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser LEFT JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id AND stm.idtariff = (SELECT MAX(idtariff) FROM subscription_tariff_mapping WHERE subscription_id = s.subscription_id) WHERE sa.idaccount = '" + sessdata.idaccount + "' GROUP BY sa.subscription_id, sa.idaccount, sa.act_sub_id";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    getUsersubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id,  sa.idaccount,  sa.subscription_id,  sa.quantity AS account_quantity, sa.start_date,  sa.end_date,  sa.status, s.name, s.mrc, s.nrc, s.quantity AS subscription_quantity, s.description, s.type, s.billing_frequency, a.san, up.firstname, up.lastname, stm.idtariff FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser LEFT JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE  sa.idaccount = '" + sessdata.idaccount + "' ";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    SubscriptionControl(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id, sa.idaccount, sa.subscription_id, sa.quantity AS account_quantity, sa.start_date, sa.end_date, sa.status, s.name, s.mrc, s.nrc, s.quantity AS subscription_quantity, s.description, s.billing_frequency,s.type, a.san, up.firstname, up.lastname FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    SubscriptionControlById(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id, sa.idaccount, sa.subscription_id, sa.quantity AS account_quantity, sa.start_date, sa.end_date, sa.status, s.name, s.mrc, s.nrc,s.quantity AS subscription_quantity, s.description, s.type, s.billing_frequency,a.san,up.firstname,up.lastname FROM subscription_account sa JOIN subscription s ON sa.subscription_id = s.subscription_id JOIN `account` a ON sa.idaccount = a.idaccount JOIN user_profile up ON a.idaccount = up.iduser WHERE sa.idaccount='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    getSubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `subscription_id`,`mrc`,`ts_service`,`type`,`description`, `name`,`quantity`,`proration`, `billing_frequency` FROM `subscription`";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    // Updatesuscriptioncontrol(req: Request, res: Response, next: NextFunction) {
    //     let sssdata = JSON.parse(req.body.data);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql="UPDATE `subscription_account` SET `idaccount`='" + sssdata.idaccount + "', `subscription_id`='" + sssdata.subscription_id + "', `quantity`='" + setToZero(sssdata.quantity) + "' WHERE `act_sub_id`='" + sssdata.act_sub_id + "'";
    //             obj.prepare();
    //             obj.execute((sError: any, sData: any) => {
    //                 if (sError == 1) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({
    //                         status: 201,
    //                         message: "Subscription Updated Successfully",
    //                         data: sData
    //                     });
    //                     objv.execute();
    //                 } else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({
    //                         status: 502,
    //                         message: "Something Went Wrong"
    //                     });
    //                     objv.execute();
    //                 }
    //             });
    //         }
    //         else{
    //             let objvs = new RawView(res);
    //             objvs.prepare({ message: "Unauthorize Access!", status: 401 });
    //             objvs.execute();
    //         }
    //     });
    // }
    // Updatesuscriptioncontrol(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let spdata = JSON.parse(req.body.data);
    //             let stipedata = spdata;
    //             const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
    //             const finalAmount = Math.round(stipedata.amount);
    //             let obj1 = new ModelRawQuery(req, res);
    //             obj1.qrysql = "SELECT `quantity` FROM `subscription_account` WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
    //             obj1.prepare();
    //             obj1.execute((err1: any, result1: any) => {
    //                 if (err1 == 1 && result1.length > 0) {
    //                     if (spdata.quantity > result1[0].quantity ) {
    //                         rate.checkBalance(req, res, idaccount, finalAmount, (crErr, crRes) => {
    //                             if (crErr == 1) {
    //                                 let obj = new ModelRawNonQuery(req, res);
    //                                 obj.nonqrysql = "UPDATE `subscription_account` SET `idaccount`='" + spdata.idaccount + "', `subscription_id`='" + spdata.subscription_id + "', `quantity`='" + setToZero(spdata.quantity) + "' WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
    //                                 obj.prepare();
    //                                 obj.execute((sError: any, sData: any) => {
    //                                     if (sError == 1) {
    //                                         let st = new StripeApi();
    //                                         st.subscriptionBalanceDeductfromwallet(req, res, sessdata, stipedata, spdata, (error, resp) => {
    //                                             let objv = new RawView(res);
    //                                             objv.prepare({ message: resp.message, status: resp.status,message1:"Mapped Subscription Updated Successfully"});
    //                                             objv.execute();
    //                                         });
    //                                     } else {
    //                                         let objv = new RawView(res);
    //                                         objv.prepare({
    //                                             status: 502,
    //                                             message: "Something Went Wrong"
    //                                         });
    //                                         objv.execute();
    //                                     }
    //                                 });
    //                             } else {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({
    //                                     message: "User's Account Balance is Low!",
    //                                     status: 502
    //                                 });
    //                                 objv.execute();
    //                             }
    //                         });
    //                     } else {
    //                         let obj = new ModelRawNonQuery(req, res);
    //                         obj.nonqrysql = "UPDATE `subscription_account` SET `idaccount`='" + spdata.idaccount + "', `subscription_id`='" + spdata.subscription_id + "', `quantity`='" + setToZero(spdata.quantity) + "' WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
    //                         obj.prepare();
    //                         obj.execute((sError: any, sData: any) => {
    //                             if (sError == 1) {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({ message: "Mapped Subscription Updated Successfully", status: 200 });
    //                                 objv.execute();
    //                             } else {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({
    //                                     status: 502,
    //                                     message: "Something Went Wrong"
    //                                 });
    //                                 objv.execute();
    //                             }
    //                         });
    //                     }
    //                 } else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({
    //                         message: "Subscription not found!",
    //                         status: 404
    //                     });
    //                     objv.execute();
    //                 }
    //             });
    //         } else {
    //             let objvs = new RawView(res);
    //             objvs.prepare({ message: "Unauthorize Access!", status: 401 });
    //             objvs.execute();
    //         }
    //     });
    // }
    subscriptionBalanceDeductfromwallet(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let finalAmount = req.body.amount;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount` = '" + sessData.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        if (result[0].balance > finalAmount) {
                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj3.nonqrysql = "UPDATE wallet SET `balance`=`balance`-" + finalAmount + " WHERE `idaccount` = '" + sessData.idaccount + "'";
                            obj3.prepare();
                            obj3.execute((_error, wallet) => {
                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                if (_error == 1) {
                                    obj5.nonqrysql = "UPDATE `account` SET `subscription_payment`=1 WHERE `idaccount`='" + sessData.idaccount + "'";
                                    obj5.prepare();
                                    obj5.execute((serror, result) => {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Payment success", status: 200 });
                                        objv.execute();
                                    });
                                }
                                else {
                                    obj5.nonqrysql = "UPDATE `account` SET `subscription_payment`=0 WHERE `idaccount`='" + sessData.idaccount + "'";
                                    obj5.prepare();
                                    obj5.execute((serror, result) => {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something went wrong!", status: 501 });
                                        objv.execute();
                                    });
                                }
                            });
                        }
                        else {
                            if (req.body.payload.paymentdata != null && req.body.payload.paymentdata != "" && req.body.payload.paymentdata != "undefined") {
                                let spdata = JSON.parse(req.body.payload);
                                let stipedata = spdata.paymentdata;
                                let st = new stripeApi_1.StripeApi();
                                st.subscriptionBalanceDeduct(req, res, sessData, stipedata, spdata, (error, resp) => {
                                    if (error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: resp.message, status: resp.status });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something went wrong while checking balance", status: 501 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Unauthorized access", status: 402 });
                objv.execute();
            }
        });
    }
    // Savesuscriptioncontrol(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let sssdata = req.body.data;
    //             let userinfo = sssdata.san[0].iduser;
    //             let subscriptionParts = sssdata.name[0].subscription.split("-");
    //             let subscription = subscriptionParts[0];
    //             let endDateModifier = parseInt(subscriptionParts[2]); 
    //             let currentDate = new Date();
    //             let endDate: string;
    //             if (endDateModifier == 1) {
    //                 endDate = '0000-00-00 00:00:00';
    //             } else {
    //                 let futureDate = new Date();
    //                 futureDate.setDate(currentDate.getDate() + 30); 
    //                 endDate = futureDate.toISOString().slice(0, 19).replace('T', ' '); 
    //             }
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`, `quantity`, `start_date`, `end_date`) VALUES ('" + userinfo + "', '" + subscription + "', '" + setToZero(sssdata.quantity) + "', NOW(), '" + endDate + "')";
    //             obj.prepare();
    //             obj.execute((sError: any, sData: any) => {
    //                 if (sError == 1) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({
    //                         status: 201,
    //                         message: "Subscription Mapped Successfully",
    //                         data: sData
    //                     });
    //                     objv.execute();
    //                 } else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({
    //                         status: 502,
    //                         message: "Something Went Wrong"
    //                     });
    //                     objv.execute();
    //                 }
    //             });
    //         } else {
    //             let objvs = new RawView(res);
    //             objvs.prepare({ message: "Unauthorized Access!", status: 401 });
    //             objvs.execute();
    //         }
    //     });
    // }
    // Savesuscriptioncontrol(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let spdata = JSON.parse(req.body.data);
    //             let stipedata = spdata;
    //             const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
    //             const finalAmount = Math.round(stipedata.amount);
    //             let type = setToZero(stipedata.type);
    //             let currentDate = new Date();
    //             let endDate: string;
    //             if (type == 1) {
    //                 endDate = '0000-00-00 00:00:00';
    //             } else {
    //                 let futureDate = new Date();
    //                 futureDate.setDate(currentDate.getDate() + 30);
    //                 endDate = futureDate.toISOString().slice(0, 19).replace('T', ' ');
    //             }
    //             rate.checkBalance(req, res, idaccount, finalAmount, (crErr, crRes) => {
    //                 if (crErr == 1) {
    //                     let obj = new ModelRawNonQuery(req, res);
    //                     obj.nonqrysql = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`, `quantity`, `start_date`, `end_date`) VALUES ('" + stipedata.idaccount + "', '" + stipedata.subscription_id + "', '" + setToZero(stipedata.quantity) + "', NOW(), '" + endDate + "')";
    //                     obj.prepare();
    //                     obj.execute((sError: any, sData: any) => {
    //                         if (sError == 1) {
    //                             let st = new StripeApi();
    //                             st.subscriptionBalanceDeductfromwallet(req, res, sessdata, stipedata, spdata, (error, resp) => {
    //                                 let objv = new RawView(res);
    //                                 objv.prepare({ message: resp.message, status: resp.status });
    //                                 objv.execute();
    //                             });
    //                         } else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({
    //                                 status: 502,
    //                                 message: "Something Went Wrong"
    //                             });
    //                             objv.execute();
    //                         }
    //                     });
    //                 } else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({
    //                         message: "User's Account Balance is Low!",
    //                         status: 502
    //                     });
    //                     objv.execute();
    //                 }
    //             });
    //         } else {
    //             let objvs = new RawView(res);
    //             objvs.prepare({ message: "Unauthorized Access!", status: 401 });
    //             objvs.execute();
    //         }
    //     });
    // }
    Savesuscriptioncontrolmapping(req, res, subscriptiondata, idaccount, callback) {
        let qrystr = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`,`quantity`, `start_date`,`end_date`) VALUES ";
        subscriptiondata.forEach(subscription => {
            let endDateModifier = subscription.type;
            let currentDate = new Date();
            let endDate;
            if (endDateModifier == 1) {
                endDate = '0000-00-00 00:00:00';
            }
            else {
                let futureDate = new Date();
                futureDate.setDate(currentDate.getDate() + 30);
                endDate = futureDate.toISOString().slice(0, 19).replace('T', ' ');
            }
            qrystr += "('" + idaccount + "', '" + subscription.subscription_id + "','" + (0, markError_1.setToZero)(subscription.quantity) + "', NOW(),'" + endDate + "'), ";
        });
        qrystr = qrystr.slice(0, -2);
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = qrystr;
        obj.prepare();
        obj.execute((err) => {
            if (err == 1) {
                callback(1);
            }
            else {
                callback(0);
            }
        });
    }
    saveSubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sssdata = req.body.data;
                let billingFrequencyValue = (sssdata.billingfrequency == null || sssdata.billingfrequency == "" || sssdata.billingfrequency == 0) ? 0 : 1;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `subscription` (`mrc`, `ts_service`, `description`, `name`,  `type`,`quantity`, `proration`, `billing_frequency`) VALUES ('" + (0, markError_1.setToZero)(sssdata.rate) + "', '" + (0, markError_1.setToZero)(sssdata.tspair) + "', '" + (0, markError_1.parseBody)(sssdata.description) + "', '" + (0, markError_1.parseBody)(sssdata.name) + "', '" + sssdata.type + "','" + (0, markError_1.setToZero)(sssdata.quantity) + "', '" + sssdata.proration + "',  " + billingFrequencyValue + ")";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 201,
                            message: "Subscription Created Successfully",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    deleteSubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sssdata = req.body.data;
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `act_sub_id`, `idaccount`, `subscription_id`, `quantity` FROM `subscription_account` WHERE `subscription_id`='" + sssdata + "'";
                obj1.prepare();
                obj1.execute((sError, result) => {
                    if (sError == 1) {
                        if (result.length > 0 && (result != null || result != '')) {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `subscription_account` SET `status` = '0' WHERE `subscription_id`='" + sssdata + "'";
                            obj.prepare();
                            obj.execute((sError, sData) => {
                                if (sError == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        status: 200,
                                        message: "Subscription Inactive Successfully!",
                                        data: sData
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "DELETE FROM `subscription` WHERE `subscription_id`='" + sssdata + "'";
                            obj2.prepare();
                            obj2.execute((sError, sData) => {
                                if (sError == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Subscription Deleted Successfully" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 501, message: "Issue While Fetching Subscription Details!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorized Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    updateSubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sssdata = req.body.data;
                let billingFrequencyValue = (sssdata.billingfrequency == null || sssdata.billingfrequency == "" || sssdata.billingfrequency == 0) ? 0 : 1;
                let id = req.query.type;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `subscription` SET `mrc` = '" + sssdata.rate + "',name='" + (0, markError_1.parseBody)(sssdata.name) + "', `ts_service` = '" + (0, markError_1.setToZero)(sssdata.tspair) + "', `ts_transaction` = '" + (0, markError_1.setToZero)(sssdata.rate) + "', `description` = '" + (0, markError_1.parseBody)(sssdata.description) + "', `quantity` = '" + sssdata.quantity + "', `proration` = '" + sssdata.proration + "',`type`='" + sssdata.type + "',billing_frequency='" + billingFrequencyValue + "' WHERE `subscription_id` = '" + id + "'";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 201,
                            message: "Subscription Updated Successfully",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    getSingleSubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `subscription_id`,`mrc`,`billing_frequency`,`ts_service`,`ts_transaction`,`description`, `name`,`quantity`,`proration` FROM `subscription`  WHERE `subscription_id` = '" + req.params.id + "'";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    //no isue
    getSubsriptionidterrif(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sssdata = req.query;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT s.subscription_id,s.mrc,s.nrc,s.ts_service,s.ts_transaction,s.description,s.name,s.billing_frequency,s.quantity,s.proration,s.type,stm.idtariff FROM subscription s JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE stm.idtariff = '" + sssdata.type + "'";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    getSubsriptionterrif(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT s.subscription_id,s.mrc,s.nrc,s.ts_service,s.ts_transaction,s.description,s.name,s.quantity,s.billing_frequency,s.proration,s.type,stm.idtariff FROM subscription s JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    subscriptiontariffmapping(req, res, subscriptiondata, allcamp, callback) {
        let tariffData = allcamp[0]?.idtariff ? JSON.stringify(allcamp[0].idtariff) : subscriptiondata[0]?.idtariff;
        let tariffObj = tariffData ? JSON.parse(tariffData) : allcamp;
        let qrystr = "INSERT INTO `subscription_tariff_mapping` (`idtariff`, `subscription_id`, `created_at`) VALUES ";
        subscriptiondata.forEach(subscription => {
            qrystr += "('" + tariffObj + "', '" + subscription.subscription_id + "', NOW()), ";
        });
        qrystr = qrystr.slice(0, -2);
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = qrystr;
        obj.prepare();
        obj.execute((err) => {
            if (err == 1) {
                callback(null);
            }
            else {
                callback(err);
            }
        });
    }
    // public Updatesubscriptiontariffmapping(req: Request, res: Response, subscriptiondata: any[], id: any, callback: (err: any) => void) {
    //     if (!subscriptiondata) {
    //         subscriptiondata = [];
    //     }
    //     let obj1 = new ModelRawQuery(req, res);
    //     obj1.qrysql = "DELETE FROM subscription_tariff_mapping WHERE idtariff = '"+id+"'";
    //     obj1.prepare();
    //     obj1.execute((err: any, sData: any) => {
    //         if (err === 1) {
    //             if (subscriptiondata.length > 0) {
    //                 let valuesArray = subscriptiondata.map(subscription => "('"+id+"', '"+subscription.subscription_id+"', NOW())");
    //                 let qrystr = "INSERT INTO subscription_tariff_mapping (idtariff, subscription_id, created_at) VALUES '"+valuesArray.join(", ")+"'";
    //                 let obj = new ModelRawNonQuery(req, res);
    //                 obj.nonqrysql = qrystr;
    //                 obj.prepare();
    //                 obj.execute((insertErr: any) => {
    //                     if (insertErr === 1) {
    //                         callback(null);
    //                     } else {
    //                         callback(insertErr);
    //                     }
    //                 });
    //             } else {
    //                 callback(null);
    //             }
    //         } else {
    //             callback(err);
    //         }
    //     });
    // }    
    // public Updatesubscriptiontariffmapping(req: Request, res: Response, subscriptiondata: any[], id: any, callback: (err: any) => void) {
    //     if (!subscriptiondata) {
    //         subscriptiondata = [];
    //     }
    //     let obj1 = new ModelRawQuery(req, res);
    //     obj1.qrysql = "DELETE FROM subscription_tariff_mapping WHERE idtariff = '"+id+"'";
    //     obj1.prepare();
    //     obj1.execute((err: any, sData: any) => {
    //         if (err === 1) {
    //             if (subscriptiondata.length > 0) {
    //                 let obj1 = new ModelRawNonQuery(req, res);
    // 								let qry0 = "INSERT INTO `subscription_tariff_mapping` (`idtariff`, `subscription_id`) VALUES ";
    // 								for (let i = 0; i < subscriptiondata.length; i++) {
    // 									let subscriptiondata1 = subscriptiondata[i];
    // 									qry0 += "('" + id + "','" + subscriptiondata1.subscription_id + "'),"
    // 								}
    // 								obj1.nonqrysql = qry0.slice(0, -1)
    // 								obj1.prepare();
    // 								obj1.execute((er: any, result: any) => {
    //                                     if (er == 1) {
    //                                                 callback(null);
    //                                             } else {
    //                                                 callback(er);
    //                                             }
    // 								});
    //             } else {
    //                 callback(null);
    //             }
    //         } else {
    //             callback(err);
    //         }
    //     });
    // }
    getFilterSubscription(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let datas = req.body.data;
                if (sessdata.type == 1) {
                    var sdata = datas;
                    let iQry = "", iQN = 0, cond = "";
                    iQry = `SELECT subscription_id, mrc, nrc, ts_service, ts_transaction, description, name, quantity, proration, billing_frequency, type FROM subscription WHERE 1=1 `;
                    if (sdata.rates) {
                        cond += "AND mrc='" + sdata.rates + "' ";
                        iQN++;
                    }
                    if (sdata.quantitys) {
                        cond += "AND quantity='" + sdata.quantitys + "' ";
                        iQN++;
                    }
                    if (sdata.names) {
                        cond += "AND name LIKE '%" + sdata.names + "%' ";
                        iQN++;
                    }
                    if (sdata.typeselect !== undefined && sdata.typeselect !== "" && sdata.typeselect !== '' && sdata.typeselect !== null) {
                        cond += "AND type='" + sdata.typeselect + "' ";
                        iQN++;
                    }
                    if (iQN > 0) {
                        iQry += cond;
                    }
                    iQry += "ORDER BY subscription_id;";
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = iQry;
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Subscriptions Fetched Successfully.",
                                status: 201
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                data: result,
                                message: "Something Went Wrong!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "Service Unavailable!", status: 503 });
                    objvs.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getSubscriptionmappedto(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id,  sa.idaccount,  sa.subscription_id,  sa.quantity AS account_quantity, sa.start_date,  sa.end_date,  sa.status, s.name, s.mrc, s.nrc, s.quantity AS subscription_quantity, s.description, s.type, s.billing_frequency, a.san, up.firstname, up.lastname, stm.idtariff FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser LEFT JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE sa.subscription_id = '" + req.query.type + "'";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    // public checkbalanceforsubscription(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let spdata = JSON.parse(req.body.data);
    //             let stipedata = spdata;
    //              const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
    //              const finalAmount = Math.round(stipedata.amount);
    //             rate.checkBalance(req, res, idaccount, finalAmount, (crErr, crRes,) => {
    //                 if(crErr==0){
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "User's Account Balance is Low!", status: 502 ,});
    //                     objv.execute();
    //                 }else{
    //                     let objv = new RawView(res);
    //                     objv.prepare({  status: 200 });
    //                     objv.execute();
    //                 }
    //              })
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }
    Updatesubscriptiontariffmapping(req, res, subscriptiondata, id, callback) {
        if (!subscriptiondata) {
            subscriptiondata = [];
        }
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "DELETE FROM subscription_tariff_mapping WHERE idtariff = '" + id + "'";
        obj1.prepare();
        obj1.execute((err, sData) => {
            if (err === 1) {
                if (subscriptiondata.length > 0) {
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let qry0 = "INSERT INTO `subscription_tariff_mapping` (`idtariff`, `subscription_id`) VALUES ";
                    for (let i = 0; i < subscriptiondata.length; i++) {
                        let subscriptiondata1 = subscriptiondata[i];
                        qry0 += "('" + id + "','" + subscriptiondata1.subscription_id + "'),";
                    }
                    obj1.nonqrysql = qry0.slice(0, -1);
                    obj1.prepare();
                    obj1.execute((er, result) => {
                        if (er == 1) {
                            callback(null);
                        }
                        else {
                            callback(er);
                        }
                    });
                }
                else {
                    callback(null);
                }
            }
            else {
                callback(err);
            }
        });
    }
    Updatesuscriptioncontrol(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                let stipedata = spdata;
                const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `quantity` FROM `subscription_account` WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
                obj1.prepare();
                obj1.execute((err1, result1) => {
                    if (err1 == 1 && result1.length > 0) {
                        if (spdata.subscription_quantity > result1[0].quantity) {
                            let actualQuantity = spdata.subscription_quantity - result1[0].quantity;
                            let rate = new APIBase_1.APIBase();
                            rate.prorateCalculatorwallet(req, res, stipedata.mrc, stipedata.proration, actualQuantity, (pc_err, prorate1) => {
                                if (pc_err == 1) {
                                    let finalamount1 = prorate1;
                                    let temp3 = "{\"amount\": \"" + finalamount1 + "\"}";
                                    let fianlprratedamount = JSON.parse(temp3);
                                    let data1 = Object.assign(stipedata, fianlprratedamount);
                                    rate.checkBalance(req, res, idaccount, prorate1, (crErr, crRes) => {
                                        if (crErr == 1) {
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "UPDATE `subscription_account` SET `idaccount`='" + spdata.idaccount + "', `subscription_id`='" + spdata.subscription_id + "', `quantity`='" + (0, markError_1.setToZero)(spdata.subscription_quantity) + "' WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
                                            obj.prepare();
                                            obj.execute((sError, sData) => {
                                                if (sError == 1) {
                                                    let st = new stripeApi_1.StripeApi();
                                                    st.subscriptionBalanceDeductfromwallet(req, res, sessdata, data1, spdata, (error, resp) => {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: resp.message, status: resp.status, message1: "Mapped Subscription Updated Successfully" });
                                                        objv.execute();
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        status: 502,
                                                        message: "Something Went Wrong"
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "User's Account Balance is Low!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objvs = new RawView_1.RawView(res);
                                    objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
                                    objvs.execute();
                                }
                            });
                        }
                        else {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `subscription_account` SET `idaccount`='" + spdata.idaccount + "', `subscription_id`='" + spdata.subscription_id + "', `quantity`='" + (0, markError_1.setToZero)(spdata.subscription_quantity) + "' WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
                            obj.prepare();
                            obj.execute((sError, sData) => {
                                if (sError == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Mapped Subscription Updated Successfully", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Subscription not found!",
                            status: 404
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    Savesuscriptioncontrol(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                let stipedata = spdata;
                const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
                let type = stipedata.type;
                let currentDate = new Date();
                let endDate;
                if (type == 1) {
                    endDate = '0000-00-00 00:00:00';
                }
                else {
                    let futureDate = new Date();
                    futureDate.setDate(currentDate.getDate() + 30);
                    endDate = futureDate.toISOString().slice(0, 19).replace('T', ' ');
                }
                let rate = new APIBase_1.APIBase();
                rate.prorateCalculatorwallet(req, res, stipedata.mrc, stipedata.proration, stipedata.subscription_quantity, (pc_err, prorate1) => {
                    if (pc_err == 1) {
                        let finalamount1 = prorate1;
                        let temp3 = "{\"amount\": \"" + finalamount1 + "\"}";
                        let fianlprratedamount = JSON.parse(temp3);
                        let data1 = Object.assign(stipedata, fianlprratedamount);
                        rate.checkBalance(req, res, idaccount, prorate1, (crErr, crRes) => {
                            if (crErr == 1) {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`, `quantity`, `start_date`, `end_date`) VALUES ('" + stipedata.idaccount + "', '" + stipedata.subscription_id + "', '" + (0, markError_1.setToZero)(stipedata.subscription_quantity) + "', NOW(), '" + endDate + "')";
                                obj.prepare();
                                obj.execute((sError, sData) => {
                                    if (sError == 1) {
                                        let st = new stripeApi_1.StripeApi();
                                        st.subscriptionBalanceDeductfromwallet(req, res, sessdata, data1, data1, (error, resp) => {
                                            console.log(resp.message);
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: resp.message, status: resp.status });
                                            objv.execute();
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            status: 502,
                                            message: "Something Went Wrong"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "User's Account Balance is Low!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objvs = new RawView_1.RawView(res);
                objvs.prepare({ message: "Unauthorized Access!", status: 401 });
                objvs.execute();
            }
        });
    }
}
exports.SubscriptionManagement = SubscriptionManagement;
