"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CSESSION = exports.Sms = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
// import { AppRoute } from "../lib/AppRoute";
const RawQuery_1 = require("../lib/model/RawQuery");
const SinchSMS_1 = require("./SinchSMS");
const TeleApiSMS_1 = require("./TeleApiSMS");
const InteliquentSMS_1 = require("./InteliquentSMS");
const lrnApi_1 = require("./lrnApi");
const markError_1 = require("./markError");
var request = require("request");
var key = "30b32113d0eb4ec9984d9042a49171c6";
const server_1 = require("../server");
const APIBase_1 = require("./APIBase");
const setting_config_1 = require("../config/setting.config");
const fs_1 = require("fs");
const mdrurlAuth = new setting_config_1.smsApi();
class Sms {
    constructor() {
        // super();
    }
    messages(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let checkService = new APIBase_1.APIBase();
                checkService.serviceActivation(req, res, sessdata, "1", (err, resp) => {
                    if (resp.status == 200) {
                        var data = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
                        if (data.FROM !== undefined && data.TO !== undefined) {
                            if (req.file && req.file != null && req.file != undefined) {
                                let mms = new Sms();
                                mms.SendMms(req, res, next);
                            }
                            else {
                                let sms = new Sms();
                                sms.SendSms(req, res, next);
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: 'All Fields are Required,FROM ,TO' });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error_code: err,
                            status: resp.status,
                            message: resp.message.replace(/::SN::/g, "SMS")
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    SendSms(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body;
                if (data.FROM !== undefined && data.FROM !== null && data.FROM !== '' && data.TO !== undefined && data.TO !== null && data.TO !== '' && data.BODY) {
                    data.FROM = data.FROM.replace(/\D/g, '');
                    data.TO = data.TO.replace(/\D/g, '');
                    let did = data.FROM ? data.FROM.trim() : '';
                    let len = did.length - 10;
                    let npa = did.slice(len, len + 3);
                    // console.log("Number Type is NN");
                    let checkService = new APIBase_1.APIBase();
                    checkService.serviceActivation(req, res, sessdata, "1", (err, resp) => {
                        if (resp.status == 200) {
                            // To check the LRN details
                            let PayLoad = {
                                TO: data.TO
                            };
                            let lerg = new lrnApi_1.LergApi("", "");
                            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : data.TO;
                                checkService.checkNumberType(did, (errorr, resp) => {
                                    if (resp.data == 'toll_free') { // Toll Free
                                        let objV1 = new RawQuery_1.ModelRawQuery(req, res);
                                        objV1.qrysql = "CALL Send2SMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + data.FROM + "', '" + ToNumber + "','TollFree');";
                                        objV1.prepare();
                                        objV1.execute((Error, Result) => {
                                            if (Error == 1) {
                                                let dWallet = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : "";
                                                let dDID = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : "";
                                                let dLergDt = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : "";
                                                // To check the account balance
                                                if (dWallet && dWallet.TotalBalance > 0) {
                                                    // To check the DID
                                                    if (dDID) {
                                                        // To check the lerg info data
                                                        if (dLergDt) {
                                                            let pLoad = {
                                                                SmsProvider: dDID.SmsProvider,
                                                                DIDProvider: dDID.DIDProvider,
                                                                campaignId: dDID.campaignId,
                                                                dLergDt: dLergDt,
                                                                nType: resp.data,
                                                                trfType: resp.data
                                                            };
                                                            let smsTF;
                                                            smsTF = new InteliquentSMS_1.InteliquentSMS();
                                                            smsTF.SendTFSms(req, res, next, sessdata, pLoad, (err, respp) => { });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        error: "",
                                                        message: "Please add funds to your account or contact support.",
                                                        status: 503
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    error: Error,
                                                    message: "Something Went Wrong to Fetch Account Data!",
                                                    status: 404
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else if (resp.data == 'short_code') {
                                        console.log("Number Type is ShortCode", did);
                                        checkService.checkSCType(req, res, did, (err_sc, scData) => {
                                            if (err_sc == 1) {
                                                console.log("scData", scData);
                                                console.log("Number Type is " + scData.scType + " of ShortCode");
                                                // To get the overall data for sms
                                                let objV1 = new RawQuery_1.ModelRawQuery(req, res);
                                                objV1.qrysql = "CALL Send2SMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + data.FROM + "', '" + ToNumber + "','" + scData.scType + "');";
                                                objV1.prepare();
                                                objV1.execute((Error, Result) => {
                                                    if (Error == 1) {
                                                        let dWallet = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : "";
                                                        let dDID = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : "";
                                                        let dLergDt = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : "";
                                                        // To check the account balance
                                                        if (dWallet && dWallet.TotalBalance > 0) {
                                                            // To check the DID
                                                            if (dDID) {
                                                                // To check the lerg info data
                                                                if (dLergDt) {
                                                                    if (dDID.SmsProvider == 'sinch') {
                                                                        let smsSC;
                                                                        let Data = {
                                                                            sessdata: sessdata,
                                                                            lergData: [dLergDt],
                                                                            nType: resp.data,
                                                                            trfType: scData.trfSCType
                                                                        };
                                                                        smsSC = new SinchSMS_1.SinchSMS();
                                                                        smsSC.SendSms(req, res, next, Data, dDID, (error, resp) => { });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 501, message: "Provider is invalid!" });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                                                                    objv.execute();
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                error: "",
                                                                message: "Please add funds to your account or contact support.",
                                                                status: 503
                                                            });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            error: Error,
                                                            message: "Something Went Wrong to Fetch Account Data!",
                                                            status: 404
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(scData);
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        // To get the overall data for sms
                                        let objV1 = new RawQuery_1.ModelRawQuery(req, res);
                                        objV1.qrysql = "CALL Send2SMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + data.FROM + "', '" + ToNumber + "','10DLC');";
                                        objV1.prepare();
                                        objV1.execute((Error, Result) => {
                                            if (Error == 1) {
                                                let dWallet = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : "";
                                                let dDID = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : "";
                                                let dLergDt = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : "";
                                                // To check the account balance
                                                if (dWallet && dWallet.TotalBalance > 0) {
                                                    // To check the DID
                                                    if (dDID) {
                                                        // To check the lerg info data
                                                        if (dLergDt) {
                                                            let sms;
                                                            let Data = {
                                                                sessdata: sessdata,
                                                                lergData: [dLergDt],
                                                                nType: resp.data,
                                                                trfType: resp.data
                                                            };
                                                            // Local Number
                                                            switch (dDID.SmsProvider) {
                                                                // TeleAPI sms provider
                                                                case 'teleapi':
                                                                    sms = new TeleApiSMS_1.TeleSMS();
                                                                    sms.SendSms(req, res, next, Data, dDID, (error, resp) => { });
                                                                    break;
                                                                // Inteliquent sms provider
                                                                case 'Inteliquent':
                                                                    sms = new InteliquentSMS_1.InteliquentSMS();
                                                                    sms.SendSms(req, res, next, Data, dDID, (error, resp) => { });
                                                                    break;
                                                                // Sinch sms provider
                                                                case 'sinch':
                                                                    sms = new SinchSMS_1.SinchSMS();
                                                                    sms.SendSms(req, res, next, Data, dDID, (error, resp) => { });
                                                                    break;
                                                                // Syneverse sms provider
                                                                case 'syniv':
                                                                    dDID.SmsProvider = "synverse4";
                                                                    sms = new SinchSMS_1.SinchSMS();
                                                                    sms.SendSms(req, res, next, Data, dDID, (error, resp) => { });
                                                                    /* let cSess: any = new CSESSION()
                                                                    cSess.GetSynv((error: any, result: any) => {
                                                                      if (error == 1) {
                                                                        let ID: string = "synverse" + result
                                                                        console.log("SMSID::", ID)
                                                                        cSess.SetSynv({
                                                                          id: result
                                                                        })
                                                                        dDID.SmsProvider = ID;
                                                                        sms = new SinchSMS();
                                                                        sms.SendSms(req, res, next, Data, dDID, (error, resp) => { })
                                                                      }
                                                                    }) */
                                                                    break;
                                                                default:
                                                                    console.log("CASE::Default");
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Invalid Account Setting", status: 502 });
                                                                    objv.execute();
                                                                    break;
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        error: "",
                                                        message: "Please add funds to your account or contact support.",
                                                        status: 503
                                                    });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    error: Error,
                                                    message: "Something Went Wrong to Fetch Account Data!",
                                                    status: 404
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                });
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error_code: err,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "SMS")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 400, message: 'All Fields are Required, FROM, TO, BODY' });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: 'Invalid authorization!' });
                objv.execute();
            }
        });
    }
    async SendMms(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession(async (sessErr, sessdata) => {
            if (sessErr == 1) {
                var sdata = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
                if (sdata.FROM !== undefined && sdata.TO !== undefined && req.file != null && req.file != undefined) {
                    let dir = new setting_config_1.UploadDirectory();
                    let file = (req.file != null && req.file != undefined) ? dir.MMSMEDIAFILE + req.file.filename : "";
                    let file_path = (req.file != null && req.file != undefined) ? dir.MMSUPLOADS + '/' + req.file.filename : "";
                    let text = (sdata.BODY != null && sdata.BODY != undefined) ? sdata.BODY : "";
                    let extension = req.file.filename.split('.').pop();
                    let checkService = new APIBase_1.APIBase();
                    checkService.serviceActivation(req, res, sessdata, "1", (err, resp) => {
                        if (resp.status == 200) {
                            let payLoad = {
                                file: file,
                                extension: extension,
                                text: text,
                                file_path: file_path,
                                file_size: req.file.size
                            };
                            let mms = new Sms();
                            mms.mmsBody(req, res, payLoad, sdata, sessdata, next);
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error_code: err,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "SMS")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: 'All Fields are Required, FROM, TO and ATTACHMENT' });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
    messagesbymedia(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var data = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
                if (data.FROM !== undefined && data.TO !== undefined) {
                    if (data.mediaID && data.mediaID != null && data.mediaID != undefined) {
                        let mms = new Sms();
                        mms.mmsbymedia(req, res, next);
                    }
                    else {
                        let sms = new Sms();
                        sms.SendSms(req, res, next);
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: 'All Fields are Required,FROM ,TO' });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    mmsbymedia(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessdata) => {
            if (sessErr == 1) {
                var sdata = req.body.data !== undefined && req.body.data ? JSON.parse(req.body.data) : req.body;
                if (sdata.FROM !== undefined && sdata.TO !== undefined && sdata.mediaID != null && sdata.mediaID != undefined) {
                    let mediaId = Array.isArray(sdata.mediaID) ? sdata.mediaID[0].nameMediaID.split('-')[0].trim() : sdata.mediaID.trim();
                    let text = (sdata.BODY != null && sdata.BODY != undefined) ? sdata.BODY : "";
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `audio_play`, `file_path`, `ext`, `file_size` FROM `upload_media` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "' AND `media_id` = '" + (0, markError_1.parseBody)(mediaId) + "'";
                    obj0.prepare();
                    obj0.execute((error, result) => {
                        if (error == 1 && result.length > 0) {
                            let payLoad = {
                                file: result[0].audio_play,
                                extension: result[0].ext,
                                text: text,
                                file_path: result[0].file_path,
                                file_size: result[0].file_size
                            };
                            let mms = new Sms();
                            mms.mmsBody(req, res, payLoad, sdata, sessdata, next);
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Invalid Media ID!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: 'All Fields are Required, FROM, TO and Media ID' });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
    async mmsBody(req, res, payLoad, sdata, sessdata, next) {
        try {
            // Check if the file exists and has content
            let mms = new Sms();
            const fileCheckResult = await mms.checkMediaAvailabilityAsync(payLoad.file_path);
            console.log("File Reading is correct or not :: ", fileCheckResult);
            if (fileCheckResult.status !== 200) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 404, message: fileCheckResult.message });
                objv.execute();
                return;
            }
            let TO = sdata.TO.replace(/\D/g, '').slice(-10);
            let FROM = sdata.FROM.replace(/\D/g, '').slice(-10);
            // To check the LRN details
            let PayLoad = {
                TO: TO
            };
            let lerg = new lrnApi_1.LergApi("", "");
            lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : TO;
                let checkService = new APIBase_1.APIBase();
                checkService.checkNumberType(FROM, (errorr, resp) => {
                    if (resp.data == 'toll_free') { // Toll Free
                        let objV1 = new RawQuery_1.ModelRawQuery(req, res);
                        objV1.qrysql = "CALL Send2MMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + FROM + "', '" + ToNumber + "','TollFree');";
                        objV1.prepare();
                        objV1.execute((Error, Result) => {
                            if (Error == 1) {
                                let dWallet = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : "";
                                let dDID = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : "";
                                let dLergDt = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : "";
                                // To check the account balance
                                if (dWallet && dWallet.TotalBalance > 0) {
                                    // To check the DID
                                    if (dDID) {
                                        // To check the lerg info data
                                        if (dLergDt) {
                                            let pLoad = {
                                                SmsProvider: dDID.SmsProvider,
                                                DIDProvider: dDID.DIDProvider,
                                                campaignId: dDID.campaignId,
                                                fileUrl: payLoad.file,
                                                dLergDt: dLergDt,
                                                nType: resp.data,
                                                trfType: resp.data
                                            };
                                            let smsTF;
                                            smsTF = new InteliquentSMS_1.InteliquentSMS();
                                            smsTF.SendTFMms(req, res, next, sessdata, pLoad, (err, respp) => { });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 402, message: "Lerg Info Not Found" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error: "",
                                        message: "Please add funds to your account or contact support.",
                                        status: 503
                                    });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error: Error,
                                    message: "Something Went Wrong to Fetch Account Data!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else if (resp.data == 'short_code') {
                        console.log("Number Type is ShortCode", FROM);
                        checkService.checkSCType(req, res, FROM, (err_sc, scData) => {
                            if (err_sc == 1) {
                                console.log("Number Type is " + scData.scType + " of ShortCode");
                                // To get the overall data for MMS
                                let objV1 = new RawQuery_1.ModelRawQuery(req, res);
                                objV1.qrysql = "CALL Send2MMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + FROM + "', '" + ToNumber + "','" + scData.scType + "');";
                                objV1.prepare();
                                objV1.execute((Error, Result) => {
                                    if (Error == 1) {
                                        let dWallet = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : "";
                                        let dDID = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : "";
                                        let dLergDt = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : "";
                                        // To check the account balance
                                        if (dWallet && dWallet.TotalBalance > 0) {
                                            // To check the DID
                                            if (dDID) {
                                                // To check the lerg info data
                                                if (dLergDt) {
                                                    let payloadData = this.fileChecker(res, payLoad, dDID.SmsProvider);
                                                    if (payloadData.error !== undefined && payloadData.error) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: payloadData.error, status: payloadData.status });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        if (dDID.SmsProvider == 'sinch') {
                                                            let smsSC;
                                                            let Data = {
                                                                sessdata: sessdata,
                                                                DIDdata: dDID,
                                                                lergData: [dLergDt],
                                                                fileType: payloadData.fType,
                                                                file: payLoad.file,
                                                                file_path: payLoad.file_path,
                                                                nType: resp.data,
                                                                trfType: scData.trfSCType
                                                            };
                                                            smsSC = new SinchSMS_1.SinchSMS();
                                                            smsSC.SendMms(req, res, next, Data, dDID, (error, resp) => { });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 501, message: "Provider is invalid!" });
                                                            objv.execute();
                                                        }
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 501, message: "Lerg Info Not Found" });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                error: "",
                                                message: "Please add funds to your account or contact support.",
                                                status: 503
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error: Error,
                                            message: "Something Went Wrong to Fetch Account Data!",
                                            status: 404
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(scData);
                                objv.execute();
                            }
                        });
                    }
                    else {
                        // To get the overall data for MMS
                        let objV1 = new RawQuery_1.ModelRawQuery(req, res);
                        objV1.qrysql = "CALL Send2MMS(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + FROM + "', '" + ToNumber + "','10DLC');";
                        objV1.prepare();
                        objV1.execute((Error, Result) => {
                            if (Error == 1) {
                                let dWallet = Array.isArray(Result[0]) && (Result[0].length > 0) ? Result[0][0] : "";
                                let dDID = Array.isArray(Result[1]) && (Result[1].length > 0) ? Result[1][0] : "";
                                let dLergDt = Array.isArray(Result[2]) && (Result[2].length > 0) ? Result[2][0] : "";
                                // To check the account balance
                                if (dWallet && dWallet.TotalBalance > 0) {
                                    // To check the DID
                                    if (dDID) {
                                        // To check the lerg info data
                                        if (dLergDt) {
                                            let sms;
                                            let payloadData = this.fileChecker(res, payLoad, dDID.SmsProvider);
                                            console.log(dDID.SmsProvider, "File Checker::", payloadData);
                                            if (payloadData.error !== undefined && payloadData.error) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: payloadData.error, status: payloadData.status });
                                                objv.execute();
                                            }
                                            else {
                                                let Data = {
                                                    sessdata: sessdata,
                                                    DIDdata: dDID,
                                                    lergData: [dLergDt],
                                                    fileType: payloadData.fType,
                                                    file: payLoad.file,
                                                    file_path: payLoad.file_path,
                                                    nType: resp.data,
                                                    trfType: resp.data
                                                };
                                                // Proceed with sending the MMS using the Data object
                                                switch (dDID.SmsProvider) {
                                                    // Sinch mms provider
                                                    case 'sinch':
                                                        sms = new SinchSMS_1.SinchSMS();
                                                        sms.SendMms(req, res, next, Data, "sinch", (error, resp) => { });
                                                        break;
                                                    case 'syniv':
                                                        let ID = "synverse4";
                                                        sms = new SinchSMS_1.SinchSMS();
                                                        sms.SendSynivMms(req, res, next, Data, ID, (error, resp) => { });
                                                        /* let cSess: any = new CSESSION()
                                                        cSess.GetSynv((error: any, result: any) => {
                                                          if (error == 1) {
                                                            let ID: string = "synverse" + result
                                                            console.log("SMSID::", ID)
                            
                                                            cSess.SetSynv({
                                                              id: result
                                                            })
                                                            
                                                            sms = new SinchSMS();
                                                            sms.SendSynivMms(req, res, next, Data, ID, (error, resp) => { })
                                                          }
                                                        }) */
                                                        break;
                                                    default:
                                                        console.log("CASE::Default");
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Invalid Account Setting", status: 502 });
                                                        objv.execute();
                                                        break;
                                                }
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 402, message: "Lerg Info Not Found" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Invalid Account Setting or Invalid DID!", status: 502 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        error: "",
                                        message: "Please add funds to your account or contact support.",
                                        status: 503
                                    });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error: Error,
                                    message: "Something Went Wrong to Fetch Account Data!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                });
            });
        }
        catch (erro) {
            console.log("Error in SendMms ::", erro);
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: 'Something went wrong with file checking' });
            objv.execute();
        }
    }
    checkMediaAvailabilityAsync = async (filePath) => {
        try {
            const stats = await fs_1.promises.stat(filePath);
            if (stats.isFile() && stats.size > 0) {
                return { status: 200, message: `File exists and has content.` };
            }
            else {
                return { status: 404, message: `File exists but is empty.` };
            }
        }
        catch (error) {
            console.error('Error in checkMediaAvailabilityAsync:', error);
            if (error.code === 'ENOENT') {
                return { status: 404, message: `File does not exist.` };
            }
            return { status: 404, message: 'Something went wrong with checking file' };
        }
    };
    fileChecker(res, payLoad, provider) {
        let fType = [];
        let maxSize;
        let allowedTypes;
        let message;
        if (provider === 'sinch') {
            message = "File too Big, please select a file less than 1MB!";
            maxSize = 1 * 1024 * 1024;
            allowedTypes = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'pdf', 'mp4', 'mp3', 'mov', 'vcf', 'ogg',
                'wav', '3gp', '3g2', 'amr', 'qcp', 'wma', 'flv', 'asx', 'wmv', 'movie', 'smil', 'msg', 'xml', 'ical', 'txt', 'ics'];
            switch (payLoad.extension) {
                case 'jpg':
                case 'jpeg':
                case 'png':
                case 'gif':
                case 'webp':
                    fType = [{ image: { "url": payLoad.file }, 'message-text': payLoad.text }];
                    break;
                case 'pdf':
                    fType = [{ pdf: { url: payLoad.file }, 'message-text': payLoad.text }];
                    break;
                case 'mp4':
                case '3gp':
                case '3g2':
                case 'mov':
                case 'flv':
                case 'asx':
                case 'wmv':
                case 'movie':
                    fType = [{ video: { url: payLoad.file }, 'message-text': payLoad.text }];
                    break;
                case 'mp3':
                case 'ogg':
                case 'wav':
                case 'wma':
                case 'amr':
                case 'qcp':
                    fType = [{ audio: { url: payLoad.file }, 'message-text': payLoad.text }];
                    break;
                case 'vcf':
                    fType = [{ contact: { url: payLoad.file }, 'message-text': payLoad.text }];
                    break;
                case 'ical':
                case 'ics':
                    fType = [{ calendar: { url: payLoad.file }, 'message-text': payLoad.text }];
                    break;
                case 'xml':
                case 'txt':
                case 'smil':
                case 'msg':
                case 'html':
                    fType = [{ document: { url: payLoad.file }, 'message-text': payLoad.text }];
                    break;
                default:
                    fType = [{ file: { "url": payLoad.file }, 'message-text': payLoad.text }];
                    break;
            }
        }
        else {
            message = "File too Big, please select a file less than 5MB!";
            maxSize = 5 * 1024 * 1024;
            allowedTypes = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'qcelp', 'qcp', 'xwav', 'midi', 'mid', 'amr', 'aac', 'aacp', 'vcf', 'h263', 'h264', 'jpgv', '3gp', '3g2', 'gz', 'rtf', 'mov', 'webp', 'mp4', 'mp3', 'ical', 'ics'];
            fType = [];
        }
        if (payLoad.file_size > maxSize) {
            return {
                error: message,
                status: 502
            };
        }
        if (!allowedTypes.includes(payLoad.extension)) {
            return {
                error: "File type is not allowed!",
                status: 502
            };
        }
        return {
            fType: fType
        };
    }
    mdrsearch(req, res, next) {
        console.log("Req==>" + JSON.stringify(req.body));
        var sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var options = {
                    'method': 'GET',
                    'url': mdrurlAuth.mdrUrl + `${sdata.Batch_Id}` + '/delivery_report/' + `${sdata.Recipient_id}`,
                    // 'url': 'https://sms.api.sinch.com/xms/v1/IPLink_gw111/batches/' + `${sdata.Batch_Id}` + '/delivery_report/' + `${sdata.Recipient_id}`,
                    'headers': {
                        'Authorization': "Bearer " + mdrurlAuth.mdrAuth,
                        // 'Authorization': "Bearer " + key,
                        'Content-Type': 'application/json'
                    }
                };
                request(options, function (error, response) {
                    if (error) {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ "message": error });
                        obj.execute();
                    }
                    else {
                        try {
                            console.log("Body==>", response.body);
                            var smsdetails = JSON.parse(response.body);
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `mdr` SET `status`='" + smsdetails.status + "' , `deliver_at`='" + smsdetails.at + "' , `operator_status_at`='" + smsdetails.operator_status_at + "' WHERE `batch_id`='" + sdata.Batch_Id + "' AND `idaccount`='" + sessdata.idaccount + "'";
                            obj.prepare();
                            obj.execute((error, responce) => {
                                if (responce) {
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT * FROM `mdr` WHERE `batch_id`='" + sdata.Batch_Id + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((err, resp) => {
                                        let obj1 = new RawView_1.RawView(res);
                                        obj1.prepare({ "message": "Sms Details", "result": resp });
                                        obj1.execute();
                                    });
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ "message": error });
                                    obj.execute();
                                }
                            });
                        }
                        catch (e) {
                            console.log("Error :: smsApi->mdrsearch::", e);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}
exports.Sms = Sms;
class CSESSION {
    constructor() { }
    GetSynv(callback) {
        callback(1, server_1.sessiondata.get("smscID"));
    }
    SetSynv(data) {
        switch (data.id) {
            case 4: {
                server_1.sessiondata.set("smscID", 5);
                break;
            }
            case 5: {
                server_1.sessiondata.set("smscID", 7); // 6 
                break;
            }
            /* case 6: {
              sessiondata.set("smscID", 7)
              break
            } */
            case 7: {
                server_1.sessiondata.set("smscID", 4);
                break;
            }
            default: {
                server_1.sessiondata.set("smscID", 4);
            }
        }
    }
}
exports.CSESSION = CSESSION;
