"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Webhook = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const RawQuery_1 = require("../lib/model/RawQuery");
const markError_1 = require("./markError");
class Webhook {
    constructor() {
        // super();
    }
    Webhookcategory(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `webhookCategory` FROM `webhook_roles` GROUP BY `webhookCategory`";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Webhook Category Fetched",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    geteventType(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `eventType` FROM `webhook_roles` where `webhookCategory`='" + sdata.type + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Hook Url Fetched Successfully",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let sdata = req.query;
            let con = '';
            if (sessdata.type == 1) {
                if (sdata.type !== null && sdata.type !== undefined && sdata.type) {
                    con = "WHERE we.`idaccount`= '" + sdata.type.split('-')[1] + "'";
                }
                else {
                    con = '';
                }
            }
            if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                con = "WHERE `idaccount`= '" + sessdata.idaccount + "'";
            }
            if (sessdata.type == 22) {
                con = "WHERE `iduser`= '" + sessdata.iduser + "'";
            }
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT `webhook_id`,`iduser`, `idaccount`, `webhookCategory`,`eventType`,`webhookUrl`,`created_at` FROM `webhook_endpoint` "+con+"";
                obj.qrysql = "SELECT we.`webhook_id`,we.`iduser`, we.`idaccount`,up.`firstname`,up.`lastname`, we.`webhookCategory`,we.`eventType`,we.`webhookUrl`,we.`created_at`FROM `webhook_endpoint` we INNER JOIN `user_profile` up ON we.iduser=up.iduser  " + con + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: result,
                            message: "Webhook Fetched Successfully",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502,
                            error: result
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    addWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `webhookCategory` FROM `webhook_endpoint` WHERE `webhookCategory`='" + sdata.webhookCategory + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((__error, resWebhook) => {
                    if (__error == 1 && resWebhook.length < 1) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = " INSERT INTO `webhook_endpoint` (`iduser`,`idaccount`,`webhookCategory`, `eventType`,`webhookUrl`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.webhookCategory + "', '" + sdata.eventType + "', '" + (0, markError_1.parseBody)(sdata.webhookUrl) + "')";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: result,
                                    message: "Webhook Inserted Successfully",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something Went Wrong With Webhook!",
                                    status: 502,
                                    error: result
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Already Exits Webhook Endpoint",
                            status: 502,
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deleteWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, _sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `webhook_endpoint` WHERE `webhook_id`='" + sdata.id + "';";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Webhook Deleted Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Webhook!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updateWebhook(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, _sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `webhook_endpoint` SET `webhookCategory`='" + sdata.webhookCategory + "',`eventType`='" + sdata.eventType + "',`webhookUrl`='" + (0, markError_1.parseBody)(sdata.webhookUrl) + "' WHERE `webhook_id`='" + sdata.webhook_id + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Webhook Updated Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Webhook Update!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    addWebhookForSwagger(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body;
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT `webhookCategory` FROM `webhook_endpoint` WHERE `webhookCategory`='" + sdata.eventCategory + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj0.prepare();
                obj0.execute((__error, resWebhook) => {
                    if (__error == 1 && resWebhook.length < 1) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `webhook_endpoint` (`iduser`,`idaccount`,`webhookCategory`,`webhookUrl`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + sdata.eventCategory + "', '" + (0, markError_1.parseBody)(sdata.webhookEndpoint) + "')";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: sdata,
                                    message: "Webhook Subscribed Successfully.",
                                    status: 200
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Webhook Not Subscribed!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `webhook_endpoint` SET `webhookCategory`='" + sdata.eventCategory + "',`webhookUrl`='" + (0, markError_1.parseBody)(sdata.webhookEndpoint) + "' WHERE `webhookCategory`='" + sdata.eventCategory + "' AND `idaccount`='" + sessdata.idaccount + "'";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: sdata, message: "Webhook Subscribed Successfully!", status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Webhook Update!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Webhook = Webhook;
