"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMod = exports.login_logout = exports.voicerates = exports.cursess = exports.DIDSearchHMData = exports.setservicedata = exports.invalidsessdata = exports.sessiondata = void 0;
const https_1 = __importDefault(require("https"));
const http_1 = __importDefault(require("http"));
const express_1 = __importDefault(require("express"));
const body_parser_1 = __importDefault(require("body-parser"));
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const hashmap_1 = __importDefault(require("hashmap"));
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const Session_1 = require("./lib/model/Session");
var cron = require("node-cron");
var net = require('net');
const CRLF = "\r\n";
const END = "\r\n\r\n";
var client = new net.Socket();
const setting_config_1 = require("./config/setting.config");
const _406_1 = require("./lib/view/406");
const module_config_1 = require("./config/module.config");
const swagger_ui_express_1 = __importDefault(require("swagger-ui-express"));
const yamljs_1 = __importDefault(require("yamljs"));
const logger_1 = require("./lib/logger");
//import * as swaggerJsonDocument from './swagger.json'
const vs_server = new setting_config_1.VoiceServer();
const setting = new setting_config_1.Setting();
const yml = new setting_config_1.YMLDirectory();
exports.sessiondata = new hashmap_1.default();
exports.invalidsessdata = new hashmap_1.default();
exports.setservicedata = new hashmap_1.default();
exports.DIDSearchHMData = new hashmap_1.default();
exports.cursess = new Session_1.CurrentSession();
exports.voicerates = new hashmap_1.default();
exports.login_logout = new hashmap_1.default();
exports.getMod = new module_config_1.modData();
/** To generate the dynamic smsid for synverse */
exports.sessiondata.set("smscID", 4);
const app = (0, express_1.default)();
// app.use(bodyParser.urlencoded({ limit: "50mb", extended: true, parameterLimit: 50000 }));
app.use(body_parser_1.default.json({ limit: '50mb' }));
app.use(body_parser_1.default.urlencoded({ limit: '50mb', extended: true }));
app.use(body_parser_1.default.json());
app.use((0, cookie_parser_1.default)());
app.use(function (req, res, next) {
    res.header("Access-Control-Allow-Origin", "*");
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Authorization");
    res.header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    next();
});
app.use("/uploads", express_1.default.static(path_1.default.join(__dirname, "uploads")));
const swaggerDocument = yamljs_1.default.load(process.cwd() + "/swagger/testing.yml");
var options = {
    customCss: `
    .topbar-wrapper img {content:url('https://portal.signalmash.com/assets/img/logo-left-white.png'); width:300px; height:auto;}
    .swagger-ui .topbar { background-color: black;}`,
    customSiteTitle: "Signalmash API Documentation",
    customfavIcon: "https://portal.signalmash.com/assets/img/icon.png"
};
app.use('/doc', swagger_ui_express_1.default.serve, swagger_ui_express_1.default.setup(swaggerDocument, options));
app.use((req, res, next) => {
    let url = req.url.split("?");
    if (url[0] == "/login" || url[0] == "/delete-user" || url[0] == "/apilogin" || url[0] == "smsdelivery" || url[0] == "/signup" || url[0] == '/forgot-mail' || url[0] == "/verify-token" || url[0] == "/update-password" || url[0] == "/emailverify" || url[0] == "/callbackmms/v1/sinch_mms" || url[0] == "/callbackdlr/v1/sinch_dlr" || url[0] == "/restore-account" || url[0] == "/voltauth" || url[0] == "/enhancedVettingReport" || url[0] == "/verify-url" || url[0] == "/setpassworduser") {
        next();
    }
    else {
        if (req.method == "OPTIONS") {
            res.status(200).send();
        }
        else {
            let sess = new Session_1.SessionManagment(req, res, next);
            sess.GetSession((error, data) => {
                if (error == 1) {
                    exports.cursess.session = data;
                    exports.cursess.error = 0;
                    const originalSend = res.send;
                    let logOnce = false;
                    res.send = function (body) {
                        if (!logOnce) {
                            const timestamp = new Date().toISOString();
                            const ipAddress = req.headers['x-forwarded-for'] || req.connection.remoteAddress;
                            // Log the API data
                            if (url[0] == "/user" || url[0] == "/details_cdr" || url[0] == "/SummeryCdrForm" || url[0] == "/getmdrfilter" || url[0] == "/summerysmsmdrfilter" || url[0] == "/getmmsmdrfilter" || url[0] == "/summerymmsmdrfilter") {
                                logger_1.Logger.info(JSON.stringify({
                                    "info": {
                                        endpoint: url[0],
                                        "Current Session": exports.cursess.session.authkey,
                                        idaccount: exports.cursess.session.idaccount,
                                        ipAddress: ipAddress,
                                        sessionType: exports.cursess.session.sessionType,
                                        request: {
                                            timestamp: timestamp,
                                            requestQuery: req.query,
                                            requestBody: req.body
                                        },
                                        response: {
                                            timestamp: timestamp,
                                            status: res.statusCode,
                                            message: "Data Fetch Successfully!"
                                        }
                                    }
                                }));
                            }
                            else if (url[0] == "/reseller_login") {
                                logger_1.Logger.info(JSON.stringify({
                                    "info": {
                                        endpoint: url[0],
                                        "Current Session": exports.cursess.session.authkey,
                                        idaccount: exports.cursess.session.idaccount,
                                        ipAddress: ipAddress,
                                        request: {
                                            timestamp: timestamp,
                                            requestQuery: req.query,
                                            requestBody: req.body
                                        },
                                        response: {
                                            timestamp: timestamp,
                                            status: res.statusCode,
                                            result: body
                                        }
                                    }
                                }));
                            }
                            else {
                                // Log for undefined requests
                                if (res.statusCode === 404) {
                                    logger_1.Logger.warn(JSON.stringify({
                                        "warning": {
                                            endpoint: url[0],
                                            message: "Undefined request",
                                            idaccount: exports.cursess.session.idaccount,
                                            ipAddress: ipAddress,
                                            requestDetails: {
                                                timestamp: timestamp,
                                                requestQuery: req.query,
                                                requestBody: req.body
                                            }
                                        }
                                    }));
                                }
                                else {
                                    // Log other API requests
                                    logger_1.Logger.info(JSON.stringify({
                                        "info": {
                                            endpoint: url[0],
                                            "Current Session": exports.cursess.session.authkey,
                                            idaccount: exports.cursess.session.idaccount,
                                            ipAddress: ipAddress,
                                            sessionType: exports.cursess.session.sessionType,
                                            request: {
                                                timestamp: timestamp,
                                                requestQuery: req.query,
                                                requestBody: req.body
                                            },
                                            response: {
                                                timestamp: timestamp,
                                                status: res.statusCode,
                                                result: body
                                            }
                                        }
                                    }));
                                }
                            }
                            logOnce = true;
                        }
                        return originalSend.call(this, body);
                    };
                }
                else {
                    logger_1.Logger.warn(JSON.stringify({
                        "warning": {
                            message: "Unauthorized access",
                            endpoint: url[0],
                            requestDetails: {
                                method: req.method,
                                url: req.originalUrl,
                                headers: req.headers,
                                body: req.body,
                            }
                        }
                    }));
                    if (res.headersSent)
                        return;
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ message: "Error in session" });
                    objv.execute();
                    return;
                }
                next();
            });
        }
    }
});
//app.use(session({secret:"gventureworksforyou", resave: false, saveUninitialized: false}));
var routes = require('./routes/routes.class'); //importing route
/*if(vs_server.TYPE.toLowerCase()=="freeswitch")
{
  client.connect(vs_server.PORT, vs_server.HOST, function () {
    console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
    client.write('auth '+vs_server.PASS+'\n\n');
    console.log("Password : "+vs_server.PASS);
  });
}

if(vs_server.TYPE.toLowerCase()=="asterisk"){
  client.connect(vs_server.PORT, vs_server.HOST, function () {
    console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
    var obj = { Action: 'Login', Username: vs_server.USER, Secret: vs_server.PASS, ActionID:1};
    var str = '';
    Object.entries(obj).forEach(([key, value]) => {
        str += (key + ": " + value + CRLF);
    });
    str+=CRLF;
    client.write(str, 'ascii');
  });
}*/
//HTTPS server
if (setting.HTTPS) {
    const options = {
        key: fs_1.default.readFileSync(setting.KEY),
        cert: fs_1.default.readFileSync(setting.CERT),
    };
    let serversocket = new https_1.default.Server(options);
    serversocket = https_1.default.createServer(options, app);
    if (vs_server.TYPE != "none") {
        const io = require("socket.io").listen(serversocket);
        //var iosocket = new SocketIO(io, client);
    }
    // Websocket start
    app.set("socketport", process.env.SOCKETPORT || setting.SOCKETPORT);
    routes(app);
    app.post("/send-notification", (req, res) => {
        const notify = { data: req.body };
        socket.emit("notificationCount", notify);
        res.send(notify);
    });
    const socketIO = https_1.default.createServer(options, app);
    const serverIO = socketIO.listen(app.get("socketport"), () => {
        console.log(`Server connection on  http://127.0.0.1:${app.get("socketport")}`);
    });
    const socket = require("socket.io")(serverIO, options);
    socket.on("connection", (socket) => {
        console.log("Socket Connected");
    });
    // Websocket end
    app.set("port", process.env.PORT || setting.PORT);
    routes(app); //register the route
    const server = serversocket.listen(app.get("port"), setting.DOMAIN, () => {
        console.log("App is running at https://%s:%d in %s mode", setting.DOMAIN, app.get("port"), app.get("env"));
        console.log("  Press CTRL-C to stop\n");
    });
}
//HTTP server generation setting with complete socket
else {
    let serversocket = new http_1.default.Server();
    serversocket = http_1.default.createServer(app);
    if (vs_server.TYPE != "none") {
        const io = require("socket.io").listen(serversocket);
        //var iosocket = new SocketIO(io, client);
    }
    //Websocket Start
    app.set("socketport", process.env.SOCKETPORT || setting.SOCKETPORT);
    routes(app);
    app.post("/send-notification", (req, res) => {
        const notify = { data: req.body };
        socket.emit("notificationCount", notify);
        res.send(notify);
    });
    const socketIO = http_1.default.createServer(app);
    const serverIO = socketIO.listen(app.get("socketport"), () => {
        console.log(`Server connection on  http://127.0.0.1:${app.get("socketport")}`);
    });
    const socket = require("socket.io")(serverIO);
    socket.on("connection", (socket) => {
        console.log("Socket Connected");
    });
    // Websocket end
    app.set("port", process.env.PORT || setting.PORT);
    routes(app); //register the route
    const server = serversocket.listen(app.get("port"), setting.DOMAIN, () => {
        console.log("App is running at http://%s:%d in %s mode", setting.DOMAIN, app.get("port"), app.get("env"));
        console.log("Press CTRL-C to stop\n");
    });
}
