"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DIDManager = exports.Number = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
// import { AppRoute } from "../lib/AppRoute";
const RawQuery_1 = require("../lib/model/RawQuery");
const ThinQ_1 = require("./ThinQ");
const Inteliquent_1 = require("./Inteliquent");
const CoreTel_1 = require("./CoreTel");
const Osr_1 = require("./Osr");
const TeleApi_1 = require("./TeleApi");
const _404_1 = require("../lib/view/404");
const md5_1 = __importDefault(require("md5"));
const Peerless_1 = require("./Peerless");
const SinchSubmitNumber_1 = require("./SinchSubmitNumber");
const lrnApi_1 = require("./lrnApi");
const markError_1 = require("./markError");
const APIBase_1 = require("./APIBase");
const Importnumber_1 = require("./Importnumber");
const server_1 = require("../server");
const setting_config_1 = require("../config/setting.config");
let request = require('request');
const fs = require('fs');
const getOsrRecords = new setting_config_1.GetOsrRecord();
const dir = new setting_config_1.UploadDirectory();
const csvbulkaction = new setting_config_1.BulkActionLog();
const appealEvidence = new setting_config_1.AppealEvidence();
/* const devurl = 'http://osrdev-e1.netnumber.net:84/osr/v2/entries/';
const myip = "iplink";
const nnid = "104141";
let email = "noc@nglcom.com"
let password = "xUxCyLwd" */
class Number {
    constructor() {
        // super();
    }
    SearchByNpxNaa(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    let sdata = req.query;
                    let base = new APIBase_1.APIBase();
                    base.getApiRate(req, res, sessdata.iduser, 1, (err, resp) => {
                        if (err == 1) {
                            base.updateApiRate(req, res, sessdata.iduser, 1, (err, resp) => {
                            });
                            if (sdata.NPA && sdata.NPA !== null && sdata.Qty) {
                                let qnty = sdata.Qty;
                                if (sdata.Qty > 500)
                                    qnty = 500;
                                base.getRate(req, res, sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                                    if (err == 1 && voice_rate.length > 0) {
                                        let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT p.`priority`, u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                                        obj1.prepare();
                                        obj1.execute((error, responce) => {
                                            console.log("responce :: ", responce);
                                            if (error == 1) {
                                                if (responce.length > 0) {
                                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                                    responce.forEach((ele) => {
                                                        if (ele.username == "thinq")
                                                            index_thinq = ele.priority;
                                                        if (ele.username == "inteliquent")
                                                            index_intel = ele.priority;
                                                        if (ele.username == "teleapi")
                                                            index_teleapi = ele.priority;
                                                        if (ele.username == "Coretel")
                                                            index_coretel = ele.priority;
                                                        if (ele.username == "Peerless")
                                                            index_peerless = ele.priority;
                                                    });
                                                    console.log({
                                                        "index_thinq": index_thinq,
                                                        "index_intel": index_intel,
                                                        "index_teleapi": index_teleapi,
                                                        "index_coretel": index_coretel,
                                                        "index_peerless": index_peerless
                                                    });
                                                    let data = {
                                                        rate: voice_rate[0].rate,
                                                        searchqty: qnty,
                                                        billingfreq: voice_rate[0].billing_frequency,
                                                    };
                                                    let thinq = new ThinQ_1.ThinQAPI(index_thinq, sessdata, key);
                                                    thinq.getNpaNxx(req, res, data, (err1, res1) => {
                                                        let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                                        intel.getNpaNxx(req, res, data, (err2, res2) => {
                                                            let tele = new TeleApi_1.TeleAPI(index_teleapi, sessdata, key);
                                                            tele.getNpaNxx(req, res, data, (err3, res3) => {
                                                                let peer = new Peerless_1.PeerlessAPI(index_peerless, sessdata, key);
                                                                peer.getNpaNxx(req, res, data, (err4, res4) => {
                                                                    if (server_1.DIDSearchHMData.has(key.toString())) {
                                                                        let prodata = server_1.DIDSearchHMData.get(key.toString());
                                                                        let result = base.getSearchedDID(prodata, qnty);
                                                                        // To remove data from hashmap
                                                                        server_1.DIDSearchHMData.delete(key.toString());
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 200, message: "DID Fetched Successfully", data: result });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 404, message: "No DID's found on [" + sdata.NPA + "]" });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            });
                                                        });
                                                    });
                                                }
                                                else {
                                                    let objv = new _404_1.Res404(res);
                                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new _404_1.Res404(res);
                                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 500, message: "All field are required,NPA,Qty" });
                                objv.execute();
                            }
                        }
                        else {
                            console.log("Error SearchByNpxNaa :: ", resp.message);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: resp.status, message: resp.message });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    SearchByRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    let base = new APIBase_1.APIBase();
                    base.getApiRate(req, res, sessdata.iduser, 1, (err, resp) => {
                        if (err == 1) {
                            base.updateApiRate(req, res, sessdata.iduser, 1, (err, resp) => {
                            });
                            let sdata = req.query;
                            let qnty = sdata.Qty;
                            if (sdata.Qty > 500)
                                qnty = 500;
                            if (sdata.RateCenter && sdata.State && sdata.Qty) {
                                base.getRate(req, res, sessdata.idtariff, "message", "NN", (err, voice_rate) => {
                                    if (err == 1 && voice_rate.length > 0) {
                                        let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                                        obj1.prepare();
                                        obj1.execute((error, responce) => {
                                            if (error == 1) {
                                                if (responce.length > 0) {
                                                    let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                                    responce.forEach((ele) => {
                                                        console.log("ele", ele);
                                                        if (ele.username == "thinq")
                                                            index_thinq = ele.priority;
                                                        if (ele.username == "inteliquent")
                                                            index_intel = ele.priority;
                                                        if (ele.username == "teleapi")
                                                            index_teleapi = ele.priority;
                                                        if (ele.username == "Coretel")
                                                            index_coretel = ele.priority;
                                                        if (ele.username == "Peerless")
                                                            index_peerless = ele.priority;
                                                    });
                                                    console.log({
                                                        "index_thinq": index_thinq,
                                                        "index_intel": index_intel,
                                                        "index_teleapi": index_teleapi,
                                                        "index_coretel": index_coretel,
                                                        "index_peerless": index_peerless
                                                    });
                                                    let data = {
                                                        rate: voice_rate[0].rate,
                                                        searchqty: qnty,
                                                        billingfreq: voice_rate[0].billing_frequency,
                                                    };
                                                    let thinq = new ThinQ_1.ThinQAPI(index_thinq, sessdata, key);
                                                    thinq.getByRate(req, res, data, (err1, res1) => {
                                                        let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                                        intel.getByRate(req, res, data, (err2, res2) => {
                                                            let tele = new TeleApi_1.TeleAPI(index_teleapi, sessdata, key);
                                                            tele.getByRate(req, res, data, (err2, res2) => {
                                                                let peer = new Peerless_1.PeerlessAPI(index_peerless, sessdata, key);
                                                                peer.getByRate(req, res, data, (err4, res4) => {
                                                                    if (server_1.DIDSearchHMData.has(key.toString())) {
                                                                        let prodata = server_1.DIDSearchHMData.get(key.toString());
                                                                        let result = base.getSearchedDID(prodata, qnty);
                                                                        // To remove data from hashmap
                                                                        server_1.DIDSearchHMData.delete(key.toString());
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 200, message: "DID Fetched Successfully", data: result });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 404, message: "No DID's found on [" + sdata.RateCenter + "]" });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            });
                                                        });
                                                    });
                                                }
                                                else {
                                                    let objv = new _404_1.Res404(res);
                                                    objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 502, message: " Something went wrong with connection!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 500, message: "All field are required,RateCenter,State,Qty" });
                                objv.execute();
                            }
                        }
                        else {
                            console.log("Error SearchByRate :: ", resp.message);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: resp.status, message: resp.message });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    SearchTolefree(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    let base = new APIBase_1.APIBase();
                    base.getApiRate(req, res, sessdata.iduser, 1, (err, resp) => {
                        if (err == 1) {
                            base.updateApiRate(req, res, sessdata.iduser, 1, (err, resp) => {
                            });
                            let sdata = req.query;
                            //sdata.TF_PREFIX
                            let msg = '';
                            if (!sdata.quantity) {
                                msg = "Quantity is Required";
                            }
                            if (!sdata.tnMask1 && !sdata.wildcard) {
                                msg = "TF Number is Required";
                            }
                            if ((sdata.tnMask1 || sdata.wildcard) && sdata.quantity) {
                                let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                                obj1.prepare();
                                obj1.execute((error, responce) => {
                                    console.log(responce);
                                    if (error == 1) {
                                        if (responce.length > 0) {
                                            let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                            responce.forEach((ele) => {
                                                if (ele.username == "thinq")
                                                    index_thinq = ele.priority;
                                                if (ele.username == "inteliquent")
                                                    index_intel = ele.priority;
                                                if (ele.username == "teleapi")
                                                    index_teleapi = ele.priority;
                                                if (ele.username == "Coretel")
                                                    index_coretel = ele.priority;
                                                if (ele.username == "Peerless")
                                                    index_peerless = ele.priority;
                                            });
                                            console.log({
                                                "index_thinq": index_thinq,
                                                "index_intel": index_intel,
                                                "index_teleapi": index_teleapi,
                                                "index_coretel": index_coretel,
                                                "index_peerless": index_peerless
                                            });
                                            let thinq = new ThinQ_1.ThinQAPI(index_thinq, sessdata, key);
                                            thinq.getTollFree(req, res, (err1, res1) => {
                                                let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                                intel.getTollFree(req, res, (err2, res2) => {
                                                    let tele = new TeleApi_1.TeleAPI(index_teleapi, sessdata, key);
                                                    tele.getTollFree(req, res, (err2, res2) => {
                                                        let peer = new Peerless_1.PeerlessAPI(index_peerless, sessdata, key);
                                                        peer.getTollFree(req, res, (err3, res3) => {
                                                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj2.qrysql = "SELECT  `phone_number`, `provider` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                            obj2.prepare();
                                                            obj2.execute((err_result, res_result) => {
                                                                if (err_result == 1) {
                                                                    if (res_result.length > 0) {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 404, message: "No DID's found!" });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        });
                                                    });
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new _404_1.Res404(res);
                                            objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 500, message: msg });
                                objv.execute();
                            }
                        }
                        else {
                            console.log("Error SearchByRate :: ", resp.message);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: resp.status, message: resp.message });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    tfRequest(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let checkService = new APIBase_1.APIBase();
                checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                    if (resp.status == 200) {
                        //sdata.TF_PREFIX 
                        if (sdata.cdata.Qty) {
                            if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                                let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                                obj1.prepare();
                                obj1.execute((error, responce) => {
                                    if (error == 1) {
                                        if (responce.length > 0) {
                                            let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                            responce.forEach((ele) => {
                                                if (ele.username == "thinq")
                                                    index_thinq = ele.priority;
                                                if (ele.username == "inteliquent")
                                                    index_intel = ele.priority;
                                                if (ele.username == "teleapi")
                                                    index_teleapi = ele.priority;
                                                if (ele.username == "Coretel")
                                                    index_coretel = ele.priority;
                                                if (ele.username == "Peerless")
                                                    index_peerless = ele.priority;
                                            });
                                            console.log({
                                                "index_thinq": index_thinq,
                                                "index_intel": index_intel,
                                                "index_teleapi": index_teleapi,
                                                "index_coretel": index_coretel,
                                                "index_peerless": index_peerless
                                            });
                                            // let thinq = new ThinQAPI(index_thinq, sessdata, key);
                                            // thinq.tfRequest(req, res, (err1, res1) => {
                                            let groupId = sdata.groupId;
                                            let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                            intel.tfRequest(req, res, groupId, (err2, res2) => {
                                            });
                                            /* intel.tfRequest(req, res, groupId, (err2, res2) => {
                                                // let tele = new TeleAPI(index_teleapi, sessdata, key);
                                                // tele.tfRequest(req, res, (err2, res2) => {
                                                // let peer = new PeerlessAPI(index_peerless, sessdata, key);
                                                // peer.tfRequest(req, res, (err3, res3) => {
                                                let obj2 = new ModelRawQuery(req, res);
                                                obj2.qrysql = "SELECT  `phone_number`, `provider` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                obj2.prepare();
                                                obj2.execute((err_result, res_result) => {
                                                    if (err_result == 1) {
                                                        if (res_result.length > 0) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                            objv.execute();
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 404, message: "No DID's found!" });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                        objv.execute();
                                                    }
                                                });
                                                // })
                                                //});
                                            }); */
                                            //});
                                        }
                                        else {
                                            let objv = new _404_1.Res404(res);
                                            objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, message: "Not Permitted" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 500, message: "Quantity is Required!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error_code: err,
                            status: resp.status,
                            message: resp.message.replace(/::SN::/g, "DID Buy")
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    PurchaseDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    const sdata = req.body;
                    let checkService = new APIBase_1.APIBase();
                    checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                        if (resp.status == 200) {
                            let via_panel = (typeof sdata.via_panel != 'undefined' && sdata.via_panel > 0) ? sdata.via_panel : 0;
                            if (sdata.DID) {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                // obj.qrysql = "SELECT `provider`, `rates`, `type`,`did_sub_type`,`portout_pin_supported` FROM `did_search` WHERE `iduser`='" + sessdata.iduser + "' AND `phone_number`='" + sdata.DID.trim() + "'";
                                obj.qrysql = "SELECT `billing_frequency`,`provider`, `rates`, `type`,`did_sub_type`,`portout_pin_supported` FROM `did_search` WHERE `iduser`='" + sessdata.iduser + "' AND `phone_number`=" + sdata.DID.trim() + "";
                                obj.prepare();
                                obj.execute((error, responce) => {
                                    if (error == 1 && responce.length > 0) {
                                        if (responce.length > 0) {
                                            if ((responce[0].rates < 0 || isNaN(responce[0].rates))) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 506, message: "Something Went Wrong with DID rates!" });
                                                objv.execute();
                                                return;
                                            }
                                            let fun = new Number();
                                            fun.prorationGet(req, res, responce[0].type, responce[0].did_sub_type, sessdata.idtariff, (error, proration) => {
                                                if (error == 1) {
                                                    if ((proration.setup_cost < 0 || isNaN(proration.setup_cost))) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 506, message: "Something Went Wrong with DID setup cost!" });
                                                        objv.execute();
                                                        return;
                                                    }
                                                    let objv11 = new RawQuery_1.ModelRawQuery(req, res);
                                                    objv11.qrysql = "SELECT t.`day_num`, DATE_FORMAT(IF(DATE_ADD(NOW(),INTERVAL t.day_num DAY) >NOW(), DATE_ADD(NOW(),INTERVAL t.day_num DAY),LAST_DAY(NOW())),'%Y-%m-%d %H:%i:%s') AS subscription_end_date FROM `user`u INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE u.iduser= '" + sessdata.iduser + "'";
                                                    objv11.prepare();
                                                    objv11.execute((days_err, days) => {
                                                        if (days_err == 1) {
                                                            let fullrates = parseFloat(responce[0].rates) + parseFloat(proration.setup_cost);
                                                            let rate = new APIBase_1.APIBase();
                                                            rate.prorateCalculator(req, res, proration.proration, responce[0].rates, proration.setup_cost, (pc_err, prorate) => {
                                                                if (pc_err == 1) {
                                                                    rate.checkBalance(req, res, sessdata.idaccount, prorate, (walletError, wallet) => {
                                                                        if (walletError == 1) {
                                                                            rate.calculateNextBillingDate(req, res, responce[0].billing_frequency, (billingError, billing) => {
                                                                                if (billingError == 1) {
                                                                                    // To create the group_order for external customers
                                                                                    // Payload of group order
                                                                                    let payLoad = {
                                                                                        via_panel: via_panel,
                                                                                        numbers: sdata.DID.toString(),
                                                                                        routing: sdata.Connection,
                                                                                        in_routing: sdata.InboundVoice,
                                                                                        out_routing: sdata.OutboundVoice
                                                                                    };
                                                                                    let DIDM = new DIDManager();
                                                                                    DIDM.CreateGroupOrder(req, res, sessdata, payLoad, (error, result) => {
                                                                                        if (error == 1) {
                                                                                            let id_grouporder = result.id_grouporder;
                                                                                            // To update the process count of group order
                                                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj.nonqrysql = "UPDATE `did_group_order` SET `is_process`=1 WHERE `id_grouporder`=" + id_grouporder + ";";
                                                                                            obj.prepare();
                                                                                            obj.execute((error, result) => {
                                                                                                console.log("GroupOrder process count::\n", result);
                                                                                            });
                                                                                            let other_data = {
                                                                                                id_grouporder: id_grouporder,
                                                                                                sub_type: responce[0].did_sub_type,
                                                                                                proration: proration.proration,
                                                                                                setup_cost: proration.setup_cost,
                                                                                                days: days,
                                                                                                fullrates: fullrates,
                                                                                                prorate: prorate,
                                                                                                billing_frequency: responce[0].billing_frequency,
                                                                                                nextbilling_cycle: billing
                                                                                            };
                                                                                            // Thinq provider
                                                                                            if (responce[0].provider == "thinQ") {
                                                                                                console.log("Going to :::: thinQ");
                                                                                                let thinq = new ThinQ_1.ThinQAPI("", sessdata, '');
                                                                                                thinq.buyDID(req, res, responce, other_data, (err, resp) => { });
                                                                                            }
                                                                                            // Intelliquent provider
                                                                                            else if (responce[0].provider == "inteliQ") {
                                                                                                console.log("Going to :::: inteliQ");
                                                                                                let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
                                                                                                intel.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                                                            }
                                                                                            // TeleAPI provider
                                                                                            else if (responce[0].provider == "teleapi") {
                                                                                                console.log("Going to :::: teleapi");
                                                                                                let tele = new TeleApi_1.TeleAPI("", sessdata, '');
                                                                                                tele.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                                                            }
                                                                                            // Peerless provider
                                                                                            else if (responce[0].provider == "Peerless") {
                                                                                                console.log("Going to :::: Peerless");
                                                                                                let peer = new Peerless_1.PeerlessAPI("", sessdata, '');
                                                                                                peer.buyDID(req, res, responce, other_data, (error, responce) => { });
                                                                                            }
                                                                                            // CoreTelAPI provider
                                                                                            else {
                                                                                                console.log("Going to :::: CoreTelAPI");
                                                                                                let coretel = new CoreTel_1.CoreTelAPI("", sessdata);
                                                                                                coretel.buyDID(req, res, responce, other_data, (error, responce) => {
                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                    objv.prepare({
                                                                                                        error_code: 0,
                                                                                                        status: 404,
                                                                                                        message: "Invalid DID provider!"
                                                                                                    });
                                                                                                    objv.execute();
                                                                                                });
                                                                                            }
                                                                                        }
                                                                                        else {
                                                                                            let objv = new RawView_1.RawView(res);
                                                                                            objv.prepare({
                                                                                                error_code: 0,
                                                                                                error: result,
                                                                                                message: "Something Went Wrong With Connection!",
                                                                                                status: 502
                                                                                            });
                                                                                            objv.execute();
                                                                                        }
                                                                                    });
                                                                                }
                                                                                else {
                                                                                    let obj = new RawView_1.RawView(res);
                                                                                    obj.prepare(billing);
                                                                                    obj.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({
                                                                                error_code: 0,
                                                                                error: 'Wallet Issue',
                                                                                message: "Something Went Wrong to Fetch Account Balance!",
                                                                                status: 502
                                                                            });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        error_code: 0,
                                                                        error: 'Wallet Issue',
                                                                        message: "Something Went Wrong to Fetch Account Balance.",
                                                                        status: 503
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({
                                                                error_code: 0,
                                                                status: 502,
                                                                message: "Something went wrong with get proration!"
                                                            });
                                                            obj.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        error_code: 0,
                                                        status: 503,
                                                        message: "Something went wrong with connection."
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                error_code: 0,
                                                status: 404,
                                                message: "Did Not Available"
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            error_code: 0,
                                            status: 502,
                                            message: "Something went wrong with connection!"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error_code: 0,
                                    status: 500,
                                    message: "DID are required!"
                                });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error_code: err,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "DID Buy")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error_code: 0,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    EnableSMS(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    const sdata = req.body;
                    if (sdata.DID && sdata.CampaignId) {
                        // let iduser: any = sdata.iduser ? sdata.iduser : sessdata.iduser;
                        // let idaccount: any = sdata.idaccount ? sdata.idaccount : sessdata.idaccount;
                        let checkMasterAc = new APIBase_1.APIBase();
                        checkMasterAc.getMasterSlave(req, res, sessdata, sessdata.idaccount, 2, (err, resp1) => {
                            if (resp1.status == 200) {
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId,provisioning_status FROM campaign WHERE `campaign_key` = '" + sdata.CampaignId + "' AND " + resp1.condition + " GROUP BY campaign_key";
                                obj1.prepare();
                                obj1.execute((error, camp_res) => {
                                    console.log("Campaign Data :::::", camp_res);
                                    if (error == 1 && camp_res.length > 0 && camp_res[0].provisioning_status == 3) {
                                        if (camp_res[0].did_count >= camp_res[0].did_limit) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "You can enable only [" + camp_res[0].did_limit + "] DID's in this Campaign" });
                                            objv.execute();
                                        }
                                        else {
                                            let objh = new RawQuery_1.ModelRawQuery(req, res);
                                            objh.qrysql = "SELECT did, did_sub_type, camp_registry, sms_provider, provider,osr_status,sinch_status,type FROM did_buy WHERE account_id = '" + sessdata.idaccount + "' AND did = '" + sdata.DID.trim() + "' AND disconnect_did_status=1 GROUP BY did";
                                            objh.prepare();
                                            objh.execute((error, responce) => {
                                                if (error == 1 && responce.length > 0) {
                                                    let category = responce[0].type == 'NN' || responce[0].type == 'INN' ? 'NN' : 'TF';
                                                    if (category == 'NN') {
                                                        // if osr_status='register' and sinch_status='0'
                                                        if (responce[0].osr_status == 'register' && responce[0].osr_status !== '' && (responce[0].sinch_status == '0' || responce[0].sinch_status == '' || responce[0].sinch_status == null || responce[0].sinch_status == undefined || responce[0].sinch_status == 'null' || responce[0].sinch_status == 'undefined')) {
                                                            console.log("condition >>::::>> if sinch_status='0' and osr_status='register'");
                                                            if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                                sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                                    if (errorr == 1) {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 200, message: resp.message });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 502, message: resp.message });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                                sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                                    if (errorr == 1) {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 200, message: resp.message });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 502, message: resp.message });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        // if osr_status == 'unregister' and responce[0].sinch_status == '0'
                                                        else if ((responce[0].osr_status == 'unregister' || responce[0].osr_status == '' || responce[0].osr_status == null || responce[0].osr_status == 'null' || responce[0].osr_status == undefined || responce[0].osr_status == 'undefined') && (responce[0].sinch_status == '0' || responce[0].sinch_status == '' || responce[0].sinch_status == null || responce[0].sinch_status == undefined || responce[0].sinch_status == 'null' || responce[0].sinch_status == 'undefined')) {
                                                            console.log("condition >>::::>> if osr_status == 'unregister' and sinch_status == '0'");
                                                            let rate = new APIBase_1.APIBase();
                                                            rate.getMessageRate(req, res, sessdata.idtariff, "message_activation", category, (err, message_rate) => {
                                                                if (err == 1) {
                                                                    let nrcMsgRate = message_rate.length > 0 && message_rate[0].nrc !== undefined ? message_rate[0].nrc : 0, mrcMsgRate = message_rate.length > 0 && message_rate[0].mrc !== undefined ? message_rate[0].mrc : 0;
                                                                    // let obj1 = new ModelRawQuery(req, res);
                                                                    // obj1.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + idaccount + "' AND `balance` + `credit_limit` >= '" + nrcMsgRate + "'"
                                                                    // obj1.prepare();
                                                                    // obj1.execute((walletError: any, wallet: any) => {
                                                                    //     if (walletError == 1 && wallet.length > 0) {
                                                                    let rate = new APIBase_1.APIBase();
                                                                    rate.checkBalance(req, res, sessdata.idaccount, nrcMsgRate, (walletError, wallet) => {
                                                                        if (walletError == 1) {
                                                                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                                            obj0.qrysql = "SELECT `myip`, `nnid`, nnid2, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + camp_res[0].upstreamCnpId + "'";
                                                                            obj0.prepare();
                                                                            obj0.execute((camperr, campres) => {
                                                                                if (camperr == 1 && campres.length > 0) {
                                                                                    if (camp_res[0].did_limit > camp_res[0].did_count) {
                                                                                        if (responce[0].provider == "inteliQ" || responce[0].provider == "thinQ" || responce[0].provider == "Peerless" || responce[0].provider == 'Importnumber' || responce[0].provider == 'OTT_MASH') {
                                                                                            let nnid = responce[0].did_sub_type == 1 && responce[0].type == 'NN' ? campres[0].nnid2 : campres[0].nnid;
                                                                                            let did = sdata.DID;
                                                                                            let len = did.length - 10;
                                                                                            let number = did.slice(len, did.length);
                                                                                            let number1 = "+1" + number;
                                                                                            let options = {
                                                                                                'method': 'PUT',
                                                                                                'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
                                                                                                'headers': {
                                                                                                    'Content-Type': 'application/json'
                                                                                                },
                                                                                                body: '{ id: "' + campres[0].myip + '", nnid:"' + nnid + '" , "context": "A2P", "campaign_id": "' + sdata.CampaignId + '" }'
                                                                                            };
                                                                                            request(options, (error, response) => {
                                                                                                if (!error) {
                                                                                                    try {
                                                                                                        let data = JSON.parse(response.body);
                                                                                                        if (data.message == "Success") {
                                                                                                            if (nrcMsgRate > 0) {
                                                                                                                // To deduct SMS Enable charges
                                                                                                                let objv = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + nrcMsgRate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                                                                                objv.prepare();
                                                                                                                objv.execute((wallet_error, wallet_success) => {
                                                                                                                    if (wallet_error == 1) {
                                                                                                                        let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                        objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + sessdata.idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount successfully updated for EnableSMS', `status`=1";
                                                                                                                        objWL.prepare();
                                                                                                                        objWL.execute((error, result) => {
                                                                                                                            console.log("Wallet amount successfully updated for EnableSMS :: ", nrcMsgRate);
                                                                                                                        });
                                                                                                                    }
                                                                                                                    else {
                                                                                                                        let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                        objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + sessdata.idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount not updated for EnableSMS', `status`=2";
                                                                                                                        objWL.prepare();
                                                                                                                        objWL.execute((error, result) => {
                                                                                                                            console.log("Wallet amount not updated for EnableSMS :: ", nrcMsgRate);
                                                                                                                        });
                                                                                                                    }
                                                                                                                });
                                                                                                                // To Insert nrc
                                                                                                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                obj4.nonqrysql = "INSERT INTO `sms_enabled_charges_log`(`iduser`,`idaccount`,`did`,`nrc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + number + "','" + nrcMsgRate + "')";
                                                                                                                obj4.prepare();
                                                                                                                obj4.execute((osr_err, resp) => {
                                                                                                                    console.log("SMS Enabled Charges Log Inserted :: ", nrcMsgRate);
                                                                                                                });
                                                                                                            }
                                                                                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                            obj2.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` + 1  WHERE " + resp1.condition + " AND `campaign_key` = '" + sdata.CampaignId + "'";
                                                                                                            obj2.prepare();
                                                                                                            obj2.execute((osr_errrr, resppp) => {
                                                                                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                obj3.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "', `sms_mrc`='" + mrcMsgRate + "' WHERE `did`='" + number + "' AND `disconnect_did_status`=1";
                                                                                                                obj3.prepare();
                                                                                                                obj3.execute((osr_err, resp) => {
                                                                                                                    if (osr_err == 1) {
                                                                                                                        if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                                            let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                                                                                            sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                                                                                                if (errorr == 1) {
                                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                                    objv.prepare({ status: 200, message: resp.message });
                                                                                                                                    objv.execute();
                                                                                                                                }
                                                                                                                                else {
                                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                                    objv.prepare({ status: 502, message: resp.message });
                                                                                                                                    objv.execute();
                                                                                                                                }
                                                                                                                            });
                                                                                                                        }
                                                                                                                        else {
                                                                                                                            let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                                                                                            sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                                                                                                if (errorr == 1) {
                                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                                    objv.prepare({ status: 200, message: resp.message });
                                                                                                                                    objv.execute();
                                                                                                                                }
                                                                                                                                else {
                                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                                    objv.prepare({ status: 502, message: resp.message });
                                                                                                                                    objv.execute();
                                                                                                                                }
                                                                                                                            });
                                                                                                                        }
                                                                                                                    }
                                                                                                                    else {
                                                                                                                        let objv = new RawView_1.RawView(res);
                                                                                                                        objv.prepare({ status: 502, message: "SMS is not enabled!" });
                                                                                                                        objv.execute();
                                                                                                                    }
                                                                                                                    let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                                    obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'6','DID provisioned to OSR','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                                                    obj6.prepare();
                                                                                                                    obj6.execute((er, ins_result) => {
                                                                                                                        console.log("DID Log Inserted.");
                                                                                                                    });
                                                                                                                });
                                                                                                            });
                                                                                                        }
                                                                                                        else {
                                                                                                            console.log("condition >>::::>> if osr_status == 'unregister' and need to enable from sinch");
                                                                                                            let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                            obj8.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "' WHERE `account_id` = '" + sessdata.idaccount + "' AND `did`='" + number + "' AND `disconnect_did_status`=1";
                                                                                                            obj8.prepare();
                                                                                                            obj8.execute((osr_failed, resp) => {
                                                                                                                if (osr_failed == 1) {
                                                                                                                    if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                                        let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                                                                                        sinch.EnableSMSFromSinch(req, res, (errorr, resp) => {
                                                                                                                            if (errorr == 1) {
                                                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                                                objv.prepare({ status: 200, message: resp.message });
                                                                                                                                objv.execute();
                                                                                                                            }
                                                                                                                            else {
                                                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                                                objv.prepare({ status: 502, message: resp.message });
                                                                                                                                objv.execute();
                                                                                                                            }
                                                                                                                        });
                                                                                                                    }
                                                                                                                    else {
                                                                                                                        let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                                                                                        sinch.EnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                                                                                            if (errorr == 1) {
                                                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                                                objv.prepare({ status: 200, message: resp.message });
                                                                                                                                objv.execute();
                                                                                                                            }
                                                                                                                            else {
                                                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                                                objv.prepare({ status: 502, message: resp.message });
                                                                                                                                objv.execute();
                                                                                                                            }
                                                                                                                        });
                                                                                                                    }
                                                                                                                }
                                                                                                                else {
                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                    objv.prepare({ status: 502, message: "SMS is not enabled!" });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                            });
                                                                                                            let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                            obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'12','OSR provisioning failed','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                                            obj7.prepare();
                                                                                                            obj7.execute((er, ins_result) => {
                                                                                                                console.log("DID Log Inserted.");
                                                                                                            });
                                                                                                        }
                                                                                                    }
                                                                                                    catch (e) {
                                                                                                        console.log("Error :: numberApi->EnableSMS::", e);
                                                                                                        let obj = new RawView_1.RawView(res);
                                                                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                                                        obj.execute();
                                                                                                    }
                                                                                                }
                                                                                                else {
                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                    objv.prepare({ status: 400, error: error, message: "Something went wrong with Enable SMS!" });
                                                                                                    objv.execute();
                                                                                                }
                                                                                            });
                                                                                        }
                                                                                        else {
                                                                                            let objv = new RawView_1.RawView(res);
                                                                                            objv.prepare({ status: 404, message: "Invalid Provider!" });
                                                                                            objv.execute();
                                                                                        }
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView_1.RawView(res);
                                                                                        objv.prepare({ status: 404, message: "Maximum DID limit completed. You have already " + camp_res[0].did_count + " DID enabled in this campaign!" });
                                                                                        objv.execute();
                                                                                    }
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({ status: 404, message: "SMS Provider does Not Exist!" });
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({
                                                                                error_code: 0,
                                                                                error: '',
                                                                                message: "Please add funds to your account or contact support.",
                                                                                status: 503
                                                                            });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 502, message: "Rates Setting Invalid!" });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            console.log("condition >>::::>> if osr_status == 'register' and sinch_status == '1'");
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 208, message: "SMS Service [" + responce[0].camp_registry + "] is Already Enabled on this DID [" + responce[0].did + "]!" });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: "Service Unavailable!" });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 404, message: "DID Not Found!" });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 404, message: "This Campaign is not approved yet or not available in our entity. Please try with another one!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: resp1.status,
                                    message: resp1.message.replace(/::MG::/g, "Enable SMS")
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 500, message: "All fields are required, DID, CampaignId" });
                        objv.execute();
                    }
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    reProvisioningSMS(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    const sdata = req.body;
                    if (sdata.DID && sdata.CampaignId) {
                        // let iduser: any = sdata.iduser ? sdata.iduser : sessdata.iduser;
                        let checkMasterAc = new APIBase_1.APIBase();
                        checkMasterAc.getMasterSlave(req, res, sessdata, sessdata.idaccount, 2, (err, resp1) => {
                            if (resp1.status == 200) {
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId FROM campaign WHERE `campaign_key` = '" + sdata.CampaignId + "' AND " + resp1.condition + " GROUP BY campaign_key";
                                obj1.prepare();
                                obj1.execute((error, camp_res) => {
                                    if (error == 1 && camp_res.length > 0) {
                                        let objh = new RawQuery_1.ModelRawQuery(req, res);
                                        objh.qrysql = "SELECT did, camp_registry, sms_provider, provider FROM did_buy WHERE account_id = '" + sessdata.idaccount + "' AND did = '" + sdata.DID.trim() + "' GROUP BY did";
                                        objh.prepare();
                                        objh.execute((error, responce) => {
                                            if (error == 1 && responce.length > 0) {
                                                if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                    sinch.reProvisioningToSinch(req, res, (errorr, resp) => {
                                                    });
                                                }
                                                else {
                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', sessdata);
                                                    sinch.reEnableSMSFromSyniverse(req, res, (errorr, resp) => {
                                                        if (errorr == 1) {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 200, message: resp.message });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 502, message: resp.message });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 404, message: "DID Not Found!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 404, message: "Campaign Expired!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: resp1.status,
                                    message: resp1.message.replace(/::MG::/g, "Re-Enable SMS Facility!")
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 500, message: "All fields are required, DID, CampaignId" });
                        objv.execute();
                    }
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    DisconnectDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    const sdata = req.body;
                    if (sdata.DID) {
                        let iduser = (typeof sdata.iduser != 'undefined' && sdata.iduser > 0) ? sdata.iduser : sessdata.iduser;
                        let idaccount = (typeof sdata.idaccount != 'undefined' && sdata.idaccount > 0) ? sdata.idaccount : sessdata.idaccount;
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `provider`,`sms_provider`,`camp_registry`,`did_disconnect_days`, DATEDIFF(NOW(), `created_at`) AS remaining_days, `type`, `did_sub_type` FROM `did_buy` WHERE `did`='" + sdata.DID + "' AND `account_id`='" + idaccount + "' AND `disconnect_did_status`=1";
                        obj.prepare();
                        obj.execute((error, responce) => {
                            if (error == 1) {
                                if (responce.length > 0) {
                                    let remaining_days = responce[0].did_disconnect_days - responce[0].remaining_days;
                                    if (responce[0].type == 'TF' || responce[0].type == 'NN') {
                                        if (responce[0].remaining_days >= responce[0].did_disconnect_days) {
                                            let data = {
                                                sms_provider: responce[0].sms_provider,
                                                campaign: responce[0].camp_registry,
                                                type: responce[0].type,
                                                did_sub_type: responce[0].did_sub_type
                                            };
                                            // Thinq provider
                                            if (responce[0].provider == "thinQ") {
                                                console.log("Going to :::: thinQ");
                                                let thinq = new ThinQ_1.ThinQAPI("", sessdata, '');
                                                thinq.disconnectDID(req, res, data, (error, responce) => { });
                                            }
                                            // Intelliquent provider
                                            else if (responce[0].provider == "inteliQ") {
                                                console.log("Going to :::: inteliQ");
                                                let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
                                                intel.disconnectDID(req, res, data, (error, responce) => { });
                                            }
                                            // TeleAPI provider
                                            else if (responce[0].provider == "teleapi") {
                                                console.log("Going to :::: teleapi");
                                                let tele = new TeleApi_1.TeleAPI("", sessdata, '');
                                                tele.disconnectDID(req, res, (error, responce) => { });
                                            }
                                            // Peerless provider
                                            else if (responce[0].provider == "Peerless") {
                                                console.log("Going to :::: Peerless");
                                                let peer = new Peerless_1.PeerlessAPI("", sessdata, '');
                                                peer.disconnectDID(req, res, data, (error, responce) => { });
                                            }
                                            // Imported number provider
                                            else if (responce[0].provider == "Importnumber") {
                                                console.log("Going to :::: Import NUmber");
                                                let impNum = new Importnumber_1.Importnumber("", sessdata, '');
                                                impNum.disconnectDID(req, res, data, (error, responce) => { });
                                            }
                                            // Imported number provider
                                            else if (responce[0].provider == "OTT_MASH") {
                                                console.log("Going to :::: OTT_MASH");
                                                let impNum = new Importnumber_1.Importnumber("", sessdata, '');
                                                impNum.disconnectDIDOTTMASH(req, res, data, (error, responce) => { });
                                            }
                                            // CoreTelAPI provider
                                            else {
                                                console.log("Going to :::: CoreTelAPI");
                                                let coretel = new CoreTel_1.CoreTelAPI("", sessdata);
                                                coretel.disconnectDID(req, res, (error, responce) => { });
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 417, message: remaining_days + " days left for this DID So you can not disconnect Did from this Account" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 503, message: "Service Unavailable!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 404, message: "DID Not Available" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 500, message: "DID are required" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted " });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    disconnectSelectedDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            var disDID = [];
            disDID.length = 0;
            disDID.splice(0, disDID.length);
            var disDIDid = [];
            disDIDid.length = 0;
            disDIDid.splice(0, disDIDid.length);
            var notdisDID = [];
            notdisDID.length = 0;
            notdisDID.splice(0, notdisDID.length);
            var notdisDIDid = [];
            notdisDIDid.length = 0;
            notdisDIDid.splice(0, notdisDIDid.length);
            let arrStr = '';
            let TotalDays;
            if (err == 1) {
                let sdata = req.body.data;
                let inc = 0;
                let DIDIds = [];
                let DIDIM = [];
                for (let x of sdata) {
                    if (x.type == 'INN' || x.type == 'ITF') {
                        DIDIM.push(x.iddid);
                    }
                    else {
                        DIDIds.push(x.iddid);
                    }
                }
                if (DIDIds.length > 0) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT t.day_num,d.iddid,d.created_at,d.did FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid IN(" + DIDIds + ")";
                    obj1.prepare();
                    obj1.execute((errday, resday) => {
                        if (errday == 1 && resday.length > 0) {
                            for (let y of resday) {
                                let did_buy_date = y.created_at;
                                let today_date = new Date();
                                const oneDay = 1000 * 60 * 60 * 24;
                                const diffInTime = today_date.getTime() - did_buy_date.getTime();
                                TotalDays = Math.round(diffInTime / oneDay);
                                if (TotalDays) {
                                    if (TotalDays > y.day_num) {
                                        disDID.push(y.did);
                                        arrStr = disDIDid.push(y.iddid);
                                    }
                                    else {
                                        notdisDID.push(y.did);
                                        notdisDIDid.push(y.iddid);
                                    }
                                }
                            }
                            if (disDIDid.length > 0) {
                                let tmpqurty = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES ";
                                disDID.forEach((element) => {
                                    tmpqurty += "('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + element + "','31','Bulk DID Delete Initiated',NOW()),";
                                });
                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj5.nonqrysql = tmpqurty.slice(0, -1);
                                obj5.prepare();
                                obj5.execute((error, result) => { });
                                arrStr = disDIDid;
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `iddid` IN(" + arrStr + ")";
                                obj2.prepare();
                                obj2.execute((errorin, data) => {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 201, error: 0, message: disDID.length + " DID Disconnected Successfully and " + notdisDID.length + " DID's not Disconnect", disdata: disDID, notdisDID: notdisDID });
                                    objv.execute();
                                    console.log("DID Disconnected Successfully!");
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, error: 0, message: "DID Not Disconnected!", disdata: '', notdisDID: '' });
                                objv.execute();
                                // console.log("DID Not Disconnected Successfully!");
                            }
                        }
                    });
                }
                if (DIDIM.length > 0) {
                    let tmpqurty = "INSERT into did_log (`account_id`,`iduser`,`did`,`event_type`,`description`,`updated_at`) VALUES ";
                    disDID.forEach((element) => {
                        tmpqurty += "('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + element + "','5','Disconnect DID from provider',NOW()),";
                    });
                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj5.nonqrysql = tmpqurty.slice(0, -1);
                    obj5.prepare();
                    obj5.execute((error, result) => { });
                    arrStr = DIDIM;
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status`='2' WHERE `iddid` IN(" + arrStr + ")";
                    obj2.prepare();
                    obj2.execute((errorin, data) => {
                        console.log("DID Updated Successfully!");
                    });
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 201, error: 0, message: disDID.length + " DID Disconnected Successfully and " + notdisDID.length + " DID's not Disconnect", disdata: disDID, notdisDID: notdisDID });
                    objv.execute();
                }
                // let objv = new RawView(res);
                // objv.prepare({ status: 201, error: 0, message: "DID Updated Successfully!", disdata: disDID, notdisDID: notdisDID })
                // objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    RetrievOsr(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                const sdata = req.query;
                if (sdata.DID) {
                    console.log("sdata==>" + sdata);
                    let osr = new Osr_1.OsrApi('', sessdata);
                    osr.retrieveOsrEntry(req, res, (error, resp) => {
                        if (resp) {
                            let obj1 = new RawView_1.RawView(res);
                            obj1.prepare({ status: 200, message: "OSR Details Find Successfully", result: resp });
                            obj1.execute();
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 404, message: "OSR Details Not Found", result: error });
                            obj.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 500, message: "DID are required" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    RetrievOsrNotification(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                const sdata = req.query;
                console.log("sdata==>" + sdata);
                let osr = new Osr_1.OsrApi('', sessdata);
                osr.retrieveOsrNotifications(req, res, (error, resp) => {
                    if (resp) {
                        let obj1 = new RawView_1.RawView(res);
                        obj1.prepare({ status: 200, message: "OSR Details Find Successfully", result: resp });
                        obj1.execute();
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 404, message: "OSR Details Not Found", result: error });
                        obj.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    DisableSMS(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    const sdata = req.query;
                    if (sdata.DID) {
                        let numberData = new APIBase_1.APIBase();
                        numberData.checkNumberType(sdata.DID, (errorr, resp1) => {
                            if (resp1.data == '10_dlc') {
                                let osr = new Osr_1.OsrApi('', sessdata);
                                osr.deleteNumber(req, res, (error, resp) => {
                                    if (!error) {
                                        delete resp.nnid;
                                        let obj1 = new RawView_1.RawView(res);
                                        obj1.prepare({ status: 200, message: "SMS facility has been successfully disabled.", result: resp });
                                        obj1.execute();
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ status: 400, error: error });
                                        obj.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 503, message: "Service Unavailable!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 500, message: "DID are required" });
                        objv.execute();
                    }
                }
                else {
                    let objvs = new RawView_1.RawView(res);
                    objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                    objvs.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    DeleteSinchNumber(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                const sdata = req.query;
                const campaign_key = '';
                console.log("sdata==>" + sdata);
                if (sdata.DID) {
                    let osr = new SinchSubmitNumber_1.SinchApi('', sessdata);
                    osr.deleteNumber(req, res, campaign_key, (error, resp) => {
                        if (resp) {
                            let obj1 = new RawView_1.RawView(res);
                            obj1.prepare({ status: 201, message: "DID Delete From SInch successfully", result: resp });
                            obj1.execute();
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 502, message: "Somthing went Wrong", result: error });
                            obj.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 500, message: "DID are required" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    lrnDetail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let numApi = new Number();
                let ltype = sdata.lookupType !== undefined && sdata.lookupType !== null && sdata.lookupType ? sdata.lookupType : 'lrn';
                if (ltype == 'dnc') {
                    numApi.NetworkOperatorsDnc(req, res, sessdata, sdata, next);
                }
                else {
                    numApi.NetworkOperators(req, res, sessdata, sdata, next);
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    NetworkOperators(req, res, sessdata, sdata, next) {
        if (sdata.DID) {
            let number = sdata.DID;
            console.log("Number::", number);
            if ((0, markError_1.isNumber)(number) >= 0 && number.length >= 10) {
                let numberData = new APIBase_1.APIBase();
                numberData.checkNumberType(number, (errorr, resp1) => {
                    if (resp1.data == '10_dlc') { // 1 is NN
                        numberData.getLRNRate(req, res, sessdata.idtariff, "lookup", "lrn", (errorl, resl) => {
                            if (errorl == 1) {
                                numberData.checkBalance(req, res, sessdata.idaccount, resl[0].rate, (errorR, resR) => {
                                    if (errorR == 1) {
                                        // To check the LRN details
                                        let PayLoad = {
                                            TO: number
                                        };
                                        let lerg = new lrnApi_1.LergApi("", "");
                                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                            let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : number;
                                            let num = ToNumber;
                                            let did = "" + num + "";
                                            let len = did.length - 10;
                                            let number1 = did.slice(len, did.length);
                                            let npa = number1.slice(0, 3);
                                            let nxx = number1.slice(3, 6);
                                            let base = new APIBase_1.APIBase();
                                            base.checkLergInfoDetail(req, res, parseInt(npa), parseInt(nxx), (lrn_err, lrn_details) => {
                                                if (lrn_err == 1) {
                                                    if (lrn_details) {
                                                        let lrn_result = Object.assign({ telephoneNumber: number, lrn: ToNumber }, lrn_details);
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 200, message: [lrn_result] });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                    objv.execute();
                                                }
                                            });
                                            /* let obj1 = new ModelRawQuery(req, res);
                                            obj1.qrysql = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`, `category`,`region`,`lata_name` `lata name`,`country`FROM `lerg_info` WHERE `npa`='" + npa + "' AND `nxx`='" + nxx + "'";
                                            obj1.prepare()
                                            obj1.execute((lrn_err, lrn_details) => {
                                                if (lrn_err == 1) {
                                                    if (lrn_details.length > 0) {
                                                        let lrn_result = Object.assign({ telephoneNumber: number, lrn: ToNumber }, lrn_details[0]);
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 200, message: [lrn_result] });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                    objv.execute();
                                                }
                                            }); */
                                            if (resl[0].rate > 0) {
                                                // To wallet deduct
                                                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj0.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + resl[0].rate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                obj0.prepare();
                                                obj0.execute((wallet_error, wallet_success) => {
                                                    if (wallet_error == 1) {
                                                        console.log("Wallet amount deducted for /getnumberdetails :: ", resl[0].rate, number);
                                                    }
                                                    else {
                                                        console.log("Wallet amount not deducted for /getnumberdetails :: ", resl[0].rate, number);
                                                    }
                                                });
                                                // To manage log
                                                let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj00.nonqrysql = "INSERT INTO `api_charges_log` (`iduser`, `idaccount`, `cost`,`req_param`,`endpoint`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + (0, markError_1.setToZero)(resl[0].rate) + "','" + number + "','/getnumberdetails')";
                                                obj00.prepare();
                                                obj00.execute((error, result) => {
                                                    console.log("api_charges_log Inserted Successfully!");
                                                });
                                            }
                                            else {
                                                console.log("Wallet amount is 0 for /getnumberdetails :: ", number);
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 504, message: "Somthing went wrong with balance!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 505, message: "Rate not found" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 503, message: "Number information not available!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 400, message: "Invalid Number! Number should be 10 digit!" });
                objv.execute();
            }
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "DID are required" });
            objv.execute();
        }
    }
    NetworkOperatorsDnc(req, res, sessdata, sdata, next) {
        if (sdata.DID) {
            let number = sdata.DID;
            console.log("Number DNC::", number);
            if ((0, markError_1.isNumber)(number) >= 0 && number.length >= 10) {
                let numberData = new APIBase_1.APIBase();
                numberData.checkNumberType(number, (errorr, resp1) => {
                    if (resp1.data == '10_dlc') {
                        numberData.getLRNRate(req, res, sessdata.idtariff, "lookup", "lrn_dnc", (errorl, resl) => {
                            if (errorl == 1) {
                                numberData.checkBalance(req, res, sessdata.idaccount, resl[0].rate, (errorR, resR) => {
                                    if (errorR == 1) {
                                        let PayLoad = {
                                            TO: number
                                        };
                                        let lerg = new lrnApi_1.LergApi("", "");
                                        lerg.lrnDetailsM2(req, res, PayLoad, (lrn_err, lrn_detail) => {
                                            let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : number;
                                            let dncStatus = lrn_detail.data.dncstatus == 1 ? true : false;
                                            let num = ToNumber;
                                            let did = "" + num + "";
                                            let len = did.length - 10;
                                            let number1 = did.slice(len, did.length);
                                            let npa = number1.slice(0, 3);
                                            let nxx = number1.slice(3, 6);
                                            let base = new APIBase_1.APIBase();
                                            base.checkLergInfoDetail(req, res, parseInt(npa), parseInt(nxx), (lrn_err, lrn_details) => {
                                                if (lrn_err == 1) {
                                                    if (lrn_details) {
                                                        let lrn_result = Object.assign({ telephoneNumber: number, lrn: ToNumber }, lrn_details, { dncstatus: dncStatus });
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 200, message: [lrn_result] });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 404, message: "LRN not found", result: sdata.DID });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                    objv.execute();
                                                }
                                            });
                                            if (resl[0].rate > 0) {
                                                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj0.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + resl[0].rate + " WHERE `idaccount`='" + sessdata.idaccount + "'";
                                                obj0.prepare();
                                                obj0.execute((wallet_error, wallet_success) => {
                                                    if (wallet_error == 1) {
                                                        console.log("Wallet amount deducted for /getnumberdetails :: ", resl[0].rate, number);
                                                    }
                                                    else {
                                                        console.log("Wallet amount not deducted for /getnumberdetails :: ", resl[0].rate, number);
                                                    }
                                                });
                                                let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj00.nonqrysql = "INSERT INTO `api_charges_log` (`iduser`, `idaccount`, `cost`,`req_param`,`endpoint`) VALUES('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + (0, markError_1.setToZero)(resl[0].rate) + "','" + number + "','/getnumberdetails')";
                                                obj00.prepare();
                                                obj00.execute((error, result) => {
                                                    console.log("api_charges_log Inserted Successfully!");
                                                });
                                            }
                                            else {
                                                console.log("Wallet amount is 0 for /getnumberdetails :: ", number);
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 504, message: "Somthing went wrong with balance!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 505, message: "Rate not found" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 503, message: "Number information not available!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 400, message: "Invalid Number! Number should be 10 digit!" });
                objv.execute();
            }
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "DID are required" });
            objv.execute();
        }
    }
    GetMdr(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                const sdata = req.query;
                let message = "";
                if (!sdata.SessionId)
                    message = "SessionId is required!";
                if (sdata.Limit && (sdata.Limit < 1 || sdata.Limit > 1000))
                    message = "Min Limit 1 and Max Limit is 1000";
                if (!sdata.Limit || sdata.Limit == null || sdata.Limit == undefined)
                    message = "Please Enter a Valid Limit!";
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `to_number`,`from_number`,`messsage_body`, `npa`,`state`,`direction`, IF(`direction`='inbound',Mo_rates,MT_rates)`rates`, IF(`direction`='inbound',Mo_surcharge,MT_surcharge) `surcharge`, `ocn`,`lata`,`category`, DATE_FORMAT(`created_at`,'%Y-%m-%d %H:%i:%s') `date`, DATE_FORMAT(`message_accepted_by_signalmash`,'%Y-%m-%d %H:%i:%s') `message_accepted_by_signalmash`, DATE_FORMAT(`message_delivered_to_operator`,'%Y-%m-%d %H:%i:%s') `message_delivered_to_operator`, DATE_FORMAT(`delivery_receipt_delivered`,'%Y-%m-%d %H:%i:%s') `delivery_receipt_delivered`, IF(`status`=1,'Success','Failed') `status` FROM mdr WHERE `idaccount` = '" + sessdata.idaccount + "' AND `batch_id`='" + sdata.SessionId + "' ORDER BY `created_at` LIMIT " + sdata.Limit + "";
                    obj.prepare();
                    obj.execute((mdr_error, result) => {
                        if (mdr_error == 1 && result.length > 0) {
                            console.log("result :: ", result);
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, message: "MDR fatched successfully!", data: result });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: "No record found!", data: result });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    GetCdr(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                const sdata = req.query;
                console.log("sdata==>" + sdata);
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT  `caller_id_number`, `dialed_number`,  `direction` ,`hangup_cause`, `start_stamp`, `answer_stamp`, `end_stamp`, `duration`,`billsec`,`npa`,`state`,`invite_failure_phrase`,`ocn`,`lata`,`category` FROM cdr WHERE iduser IN (SELECT iduser FROM `user` WHERE idaccount=(SELECT idaccount FROM `user` WHERE iduser='" + sessdata.iduser + "')) ORDER BY `idcdr` DESC LIMIT 1000";
                obj.prepare();
                obj.execute((cdr_error, result) => {
                    if (cdr_error == 1) {
                        console.log(result);
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, message: "CDR Find successfully!", result: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!", result: error });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    onAddToCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = "INSERT into did_cart (`idaccount`, `iduser`, `did`, `provider`) VALUES('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + rdata.phone_number + "', '" + rdata.provider + "')";
                obj3.execute((cart_error, result) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: cart_error, message: result.sqlMessage });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    addAllToCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let rdata = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT into did_cart (`idaccount`,`iduser`, `did`, `provider`) VALUES ";
                rdata.forEach((element) => {
                    tmpqurty += "('" + sessdata.idaccount + "','" + sessdata.iduser + "', '" + element.phone_number + "', '" + element.provider + "'),";
                });
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = tmpqurty.slice(0, -1);
                obj3.execute((cart_error, result) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: cart_error, message: result.sqlMessage });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM did_cart where iduser = '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((cart_error, result) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: msg });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                console.log(req.query);
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM did_cart WHERE id_cart = '" + req.query.id + "'";
                obj.prepare();
                obj.execute((cart_error, lastid) => {
                    if (cart_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: "DID removed Successfully!", data: lastid[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteItems(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err === 1) {
                let qData = req.body;
                let didArray = qData.map((el) => el.id_cart);
                let totaldids = didArray.map((id_cart) => "'" + id_cart + "'").join(", ");
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM did_cart WHERE id_cart IN (" + totaldids + ")";
                obj.prepare();
                obj.execute((error, lastid) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 201,
                            message: "Cart Items Removed!",
                            data: lastid
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 500,
                            message: "Error removing cart items",
                            data: error
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    clearCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM did_cart WHERE idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((error1, lastid) => {
                    if (lastid) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: "Cart Cleared!", data: lastid[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: error1, message: "Something went wrong" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    verifyDid(req, res, callback) {
        let session = new Session_1.SessionManagment(req, res, () => { });
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body;
                let didNumber = sdata.FROM;
                if (sessdata.isMobileVerify == "false" && sessdata.isEmailVerify == "true") {
                    callback('', 1);
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `iddid` FROM `did_buy` WHERE `did`='" + didNumber + "' AND `iduser`='" + sessdata.iduser + "'";
                    obj.prepare();
                    obj.execute((err, data) => {
                        if (data.length > 0) {
                            callback('', 1);
                        }
                        else {
                            callback('', -1);
                        }
                    });
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    // To Get DIDs for panel
    onGetDIDs(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = [];
                sdata = req.query;
                let iduser = sdata.selectedUser.split("-")[0];
                let idaccount = sdata.selectedUser.split("-")[1];
                let condition = "";
                // For Customer account
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition += "d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";
                // For Customer account
                if (sessdata.type == 22)
                    condition += 'd.`iduser`="' + sessdata.iduser + '" AND ';
                if (sdata.selectedUser)
                    condition += 'd.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                if (sdata.selectSMS == 'enabled')
                    condition += "d.`sinch_status`='1' AND ";
                if (sdata.selectSMS == 'disabled')
                    condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                if (sdata.didnpa)
                    condition += 'd.`npa`="' + sdata.didnpa + '" AND ';
                if (sdata.didnumber)
                    condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                if (sdata.selectState)
                    condition += 'd.`state`="' + sdata.selectState + '" AND ';
                if (sdata.connectionKey)
                    condition += 'd.`connection_key`="' + sdata.connectionKey + '" AND ';
                if (sdata.campaignKey)
                    condition += 'd.`camp_registry`="' + sdata.campaignKey + '" AND ';
                if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                    let atr = sdata.autoRenew == 'Enabled' ? true : false;
                    condition += 'd.`subscription_auto_renew`="' + atr + '" AND ';
                }
                if (sdata.portout)
                    condition += 'd.`portoutpin`="' + sdata.portout + '" AND ';
                if (sdata.fromDate && sdata.toDate)
                    condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s') `created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' GROUP BY d.did ORDER BY d.iddid DESC LIMIT 1000";
                obj2.qrysql = "SELECT d.iddid, d.iduser, CONCAT(100000000 + CAST(d.account_id AS UNSIGNED)) AS account_id,d.portoutpin, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d') `created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' AND (d.type = 'NN' OR d.type = 'TF' OR d.type = 'INN') GROUP BY d.did ORDER BY d.iddid DESC LIMIT 1000";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    onExportDID(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let condition = "";
                let idaccount;
                let account_id = "";
                let portoutpin = "";
                if (sdata.selectedUser) {
                    idaccount = sdata.selectedUser.split("-")[1];
                }
                if (sessdata.type == 1) {
                    account_id += 'CONCAT(100000000 + CAST(db.account_id AS UNSIGNED)) AS SAN, ';
                    portoutpin += "(db.portoutpin) AS 'Port Out PIN',";
                }
                // For Customer account
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition += "db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";
                // For Customer account
                if (sessdata.type == 22)
                    condition += 'db.`iduser`="' + sessdata.iduser + '" AND ';
                if (sdata.selectedUser)
                    condition += 'db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                if (sdata.selectSMS == 'enabled')
                    condition += "db.`sinch_status`='1' AND ";
                if (sdata.selectSMS == 'disabled')
                    condition += "(db.`sinch_status` !='1' OR db.`sinch_status` IS NULL OR db.`sinch_status`='' OR db.`sinch_status` ='0') AND ";
                if (sdata.didnpa)
                    condition += 'db.`npa`="' + sdata.didnpa + '" AND ';
                if (sdata.didnumber)
                    condition += 'db.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                if (sdata.selectState)
                    condition += 'db.`state`="' + sdata.selectState + '" AND ';
                if (sdata.connectionKey)
                    condition += 'db.`connection_key`="' + sdata.connectionKey + '" AND ';
                if (sdata.campaignKey)
                    condition += 'db.`camp_registry`="' + sdata.campaignKey + '" AND ';
                if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                    let atr = sdata.autoRenew == 'Enabled' ? true : false;
                    condition += 'db.`subscription_auto_renew`="' + atr + '" AND ';
                }
                if (sdata.portout)
                    condition += 'db.`portoutpin`="' + sdata.portout + '" AND ';
                if (sdata.fromDate && sdata.toDate)
                    condition += 'db.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // obj2.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, MAX(db.npa) AS NPA, MAX(db.nxx) AS NXX, MAX(db.state) AS State, MAX(db.ratecenter) AS `Rate Center`,MAX(ep.connection_key) AS `Connection Key`,MAX(ep.name) AS `Connection Name`, MAX(DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s')) AS `Start Subscription`, DATE_FORMAT(LAST_DAY(NOW()), '%Y-%m-%d %H:%i:%s') AS `End Subscription`,MAX(db.subscription_auto_renew) AS `Auto Renewal`,MAX(db.camp_registry) AS `SMS Campaign`, MAX(db.`did_disconnect_days`) AS DisconnectDays FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " db.disconnect_did_status = '1' GROUP BY db.did ORDER BY `Start Subscription` DESC";
                obj2.qrysql = "SELECT " + account_id + " " + portoutpin + "  REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, MAX(db.npa) AS NPA, MAX(db.nxx) AS NXX, MAX(db.state) AS State, MAX(db.ratecenter) AS `Rate Center`,MAX(ep.connection_key) AS `Connection Key`,MAX(ep.name) AS `Connection Name`, MAX(DATE_FORMAT(db.created_at, '%m-%d-%Y')) AS `Start Subscription`, DATE_FORMAT(db.subscription_end_date, '%m-%d-%Y') AS `End Subscription`,MAX(db.subscription_auto_renew) AS `Auto Renewal`,MAX(db.camp_registry) AS `SMS Campaign`, MAX(db.`did_disconnect_days`) AS DisconnectDays, MAX(db.type) AS TYPE FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " db.disconnect_did_status = '1' AND (db.type = 'NN' OR db.type = 'TF' OR db.type = 'INN') GROUP BY db.did ORDER BY `Start Subscription` DESC";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Expoting!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    GetPortOutPIN(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT san, portoutpin FROM account WHERE account_type = '2'";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "PortOutPin Fetched Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Service Unavailable!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    onExportOrderDID(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT DISTINCT REPLACE(REPLACE(dd.did, CHAR(10),''), CHAR(13),'') AS did,SUBSTRING(dd.did,'1','3')`npa`,SUBSTRING(dd.did,'4','3')`nxx`,IFNULL(d.state,'')`state`,IFNULL(d.ratecenter,'')`ratecenter`, DATE_FORMAT(dg.`date`, '%Y-%m-%d') date,IF(IFNULL(d.did,'')='','Failed','Success')AS OrderStatus, d.`did_disconnect_days` AS DisconnectDays FROM `did_group_order` dg INNER JOIN `did_order` dd ON dg.id_grouporder=dd.id_grouporder LEFT JOIN `did_buy` d ON dd.did=d.did WHERE  dg.id_grouporder='" + sdata.group_id + "' AND dg.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "')";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Exported Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Export!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    customerDidsCount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = [];
                sdata = req.query;
                let iduser = sdata.selectedUser.split("-")[0];
                let idaccount = sdata.selectedUser.split("-")[1];
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                // for customer account
                // obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END  'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_date, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + idaccount + "') AND d.disconnect_did_status = '1' GROUP BY d.did"
                obj2.qrysql = "SELECT MAX(d.iddid) AS iddid, MAX(d.iduser) AS iduser, MAX(d.account_id) AS account_id, MAX(d.user_id) AS user_id, MAX(d.sinch_retry) AS sinch_retry, MAX(d.status) AS `status`, MAX(d.sinch_status) AS sinch_status, MAX(d.connection_key) AS connection_key,MAX(d.inbound_key) AS inbound_key,MAX(d.outbound_key) AS outbound_key,MAX(d.camp_registry) AS camp_registry, MAX(CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END) AS subscription_auto_renew,IF(DATE_ADD(MAX(d.`created_at`), INTERVAL MAX(t.day_num) DAY) >NOW(),DATE_ADD(MAX(d.`created_at`),INTERVAL MAX(t.day_num) DAY),LAST_DAY(NOW())) AS subscription_end_date, IF(DATE_ADD(MAX(d.`created_at`),INTERVAL MAX(t.day_num) DAY) >NOW(),'Not Expire','Expire') AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, MAX(d.provider) AS provider, MAX(d.sms_provider) AS sms_provider, MAX(d.order_id) AS order_id, MAX(d.npa) AS npa, MAX(d.nxx) AS nxx, MAX(d.state) AS state, MAX(d.ratecenter) AS ratecenter, MAX(d.type) AS `type`, MAX(d.cnam) AS cnam, MAX(d.is_sms_inbound) AS is_sms_inbound, MAX(e.name) AS connectionName, DATE_FORMAT(MAX(d.`created_at`), '%Y-%m-%d %H:%i:%s')`created_at`, MAX(d.`did_disconnect_days`) AS did_disconnect_days FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`=" + idaccount + ") AND d.disconnect_did_status = '1' GROUP BY d.did";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    DidLocationInfo(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `npa`, `nxx`, `ocn`, `lata`, `local_state` FROM `did_location_info`";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, data: result, message: "Did Location fatched successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    updateDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = req.body.data;
                let connection_key;
                let inboundKey;
                let outboundKey;
                if (rdata.connection_key) {
                    connection_key = rdata.connection_key;
                }
                else {
                    connection_key = '';
                }
                if (rdata.inboundKey) {
                    inboundKey = rdata.inboundKey;
                }
                else {
                    inboundKey = '';
                }
                if (rdata.outboundKey) {
                    outboundKey = rdata.outboundKey;
                }
                else {
                    outboundKey = '';
                }
                obj2.nonqrysql = "UPDATE `did_buy` SET `connection_key`='" + connection_key + "',`inbound_Key`='" + inboundKey + "', `outbound_Key`='" + outboundKey + "' WHERE `iddid`= '" + rdata.iddid + "'";
                obj2.qrysql = "";
                obj2.prepare();
                obj2.execute((error, data) => {
                    let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    objk.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'4','Connection Enable','" + rdata.did.trim() + "')";
                    objk.execute((cart_error, result) => {
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({ status: 201, error: 0, data: data, message: "DID Updated Successfully!" });
                        objv.execute();
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    didEnableDisable(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = req.body.data, type = '', desc = '';
                let isEnable = rdata.isEnable == 'Enabled' ? true : false;
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `did_buy` SET `subscription_auto_renew`='" + isEnable + "' WHERE `iddid`= '" + rdata.iddid + "'";
                obj2.prepare();
                obj2.execute((error1, data) => {
                    if (error1 == 1) {
                        if (rdata.isEnable == 'Enabled') {
                            type = '3';
                            desc = 'Auto Renewal Enable';
                        }
                        if (rdata.isEnable == 'Disabled') {
                            type = '8';
                            desc = 'Auto Renewal Disable';
                        }
                        let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        objk.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'" + type + "','" + desc + "','" + rdata.did.trim() + "')";
                        objk.execute((log_error, result) => {
                            log_error == 1 ? console.log("DID Log Inserted Successfully ::=>", rdata.isEnable) : console.log("DID Log Not Inserted ::=>", rdata.isEnable);
                        });
                        let objv = new RawView_1.RawView(res);
                        obj2.prepare();
                        objv.prepare({ status: 201, message: "DID Successfully " + rdata.isEnable + "!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong with auto renewal!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    updateSelectedDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((el, idx, dids) => {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let connection_key;
                    let inboundKey;
                    let outboundKey;
                    if (el.connection_key) {
                        connection_key = el.connection_key;
                    }
                    else {
                        connection_key = '';
                    }
                    if (el.inboundKey) {
                        inboundKey = el.inboundKey;
                    }
                    else {
                        inboundKey = '';
                    }
                    if (el.outboundKey) {
                        outboundKey = el.outboundKey;
                    }
                    else {
                        outboundKey = '';
                    }
                    obj2.nonqrysql = "UPDATE `did_buy` SET `connection_key`='" + connection_key + "',`inbound_Key`='" + inboundKey + "', `outbound_Key`='" + outboundKey + "' WHERE `iddid`= '" + el.iddid + "'";
                    obj2.prepare();
                    obj2.execute((error, data) => {
                        let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        objk.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'4','Connection Enable','" + el.did.trim() + "')";
                        objk.execute((cart_error, result) => {
                            if (idx == (dids.length - 1)) {
                                let objv = new RawView_1.RawView(res);
                                obj2.prepare();
                                objv.prepare({ status: 201, error: 0, data: "update", message: "DID Updated Successfully!" });
                                objv.execute();
                            }
                        });
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    GetState(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT DISTINCT loc_state FROM did_location_info";
                obj.prepare();
                obj.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, data: result, message: "State Find successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    GetRateCenter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                if (sdata.State) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  rc_abbre FROM did_location_info WHERE `loc_state` = '" + req.query.State + "' ORDER BY rc_abbre ASC";
                    obj.prepare();
                    obj.execute((err, result) => {
                        if (err == 1) {
                            if (result.length > 0) {
                                // console.log(result);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, data: result, message: "Rate center found successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, data: result, message: "Rate center not found!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 500, message: "State are required" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    GetNPA(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                if (sdata.State) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  npa FROM did_location_info WHERE `loc_state` = '" + req.query.State + "'";
                    obj.prepare();
                    obj.execute((errorr, result) => {
                        if (errorr == 1) {
                            if (result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, data: result, message: "NPA Find successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, data: result, message: "NPA are not available!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 500, message: "State are required!" });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    GetNXX(req, res, next) {
        let sdata = req.query;
        if (sdata.NPA) {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT  DISTINCT  nxx FROM did_location_info WHERE `npa` = '" + req.query.NPA + "'";
                    obj.prepare();
                    obj.execute((errorr, result) => {
                        if (errorr == 1) {
                            if (result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, data: result, message: "NXX Find successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, data: result, message: "NXX are not available!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ status: 401, message: "Unauthorized User" });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 500, message: "NPA are required" });
            objv.execute();
        }
    }
    // To Get All DID List For Swagger Side
    getDID(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let sdata = req.query;
                    let con = '';
                    let pg = '';
                    let page = sdata.page;
                    let recordsPerPage = sdata.recordsPerPage;
                    if ((0, markError_1.isNumber)(page) >= 0 && (0, markError_1.isNumber)(recordsPerPage) >= 0 && (0, markError_1.isNumber)(sdata.NPA) >= 0 && (0, markError_1.isNumber)(sdata.NXX) >= 0) {
                        let message = '';
                        if (!page)
                            page = 1;
                        if (page < 1)
                            message = "Page Minimum Limit 1";
                        if (page > 500)
                            message = "Page Maximum Limit 500";
                        if (!recordsPerPage)
                            recordsPerPage = 500;
                        if (recordsPerPage > 500)
                            message = "recordsPerPage Maximum Limit 500";
                        if (recordsPerPage < 1)
                            message = "recordsPerPage Minimum Limit 1";
                        if (recordsPerPage <= 500 && recordsPerPage >= 1 && page >= 1) {
                            if (sdata.campaignKey)
                                con += " AND `camp_registry` = '" + sdata.campaignKey + "'";
                            if (sdata.NPA)
                                con += " AND `npa` LIKE '%" + sdata.NPA + "%'";
                            if (sdata.NXX)
                                con += " AND `nxx` LIKE '%" + sdata.NXX + "%'";
                            if (sdata.rateCenter)
                                con += " AND `ratecenter` LIKE '%" + sdata.rateCenter + "%'";
                            if (sdata.state)
                                con += " AND `state` LIKE '%" + sdata.state + "%'";
                            if (sdata.start_date)
                                con += " AND DATE_FORMAT(`created_at`,'%Y-%m-%d') >= '" + sdata.start_date + "'";
                            if (sdata.end_date)
                                con += " AND DATE_FORMAT(`created_at`,'%Y-%m-%d') <= '" + sdata.end_date + "'";
                            if (page && recordsPerPage) {
                                let perPage = (page - 1) * recordsPerPage;
                                pg = " LIMIT " + recordsPerPage + " OFFSET " + perPage + "";
                            }
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `did` FROM `did_buy` WHERE `disconnect_did_status` = '1' " + con + " AND `account_id`='" + sessdata.idaccount + "' AND type IN ('NN', 'TF','INN') GROUP BY did ORDER BY `iddid` ASC " + pg + "";
                            obj.prepare();
                            obj.execute((errorr, result) => {
                                if (errorr == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 200, data: result, message: "DIDs Fetched Successfully" });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 200, data: [], message: "No DIDs Available!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something went wrong!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 503, message: message });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 505, message: "Not a Correct Number!" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    // To Get All DID List For Swagger Side in behalf of campaign_key and connection_key
    getDIDall(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let sdata = req.query;
                    let con = '';
                    if (sdata.connectionKey)
                        con += " AND db.`connection_key`='" + sdata.connectionKey + "'";
                    if (sdata.campaignKey)
                        con += " AND db.`camp_registry`='" + sdata.campaignKey + "'";
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS did, db.npa, db.nxx, db.state, db.ratecenter, ep.name AS connection_name, db.connection_key, DATE_FORMAT(db.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS start_subscription, CASE db.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'auto_renewal', db.camp_registry AS sms_campaign, CASE WHEN db.sinch_status = '' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '0' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '1' THEN 'SMS Fully Provisioned' WHEN db.sinch_status = '2' THEN 'Provisioning Waiting' WHEN db.sinch_status = '3' THEN 'Provisioning Inprogress' WHEN db.sinch_status = '4' THEN 'Provisioning Already Exist' WHEN db.sinch_status = '5' THEN 'Provisioned Failed' WHEN db.sinch_status = '6' THEN 'Retrying after 4 hours' WHEN db.sinch_status = '7' THEN 'You are not eligible to retry after failed' WHEN db.sinch_status = '8' THEN 'Time-out after 4 hour retry' WHEN db.sinch_status = '9' THEN 'Failed after failed retry' END AS sms_service, db.`did_disconnect_days` FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key=ep.connection_key WHERE db.disconnect_did_status = '1' " + con + " AND db.`account_id`='" + sessdata.idaccount + "' AND db.type IN ('NN', 'TF','INN') GROUP BY db.`did` ORDER BY db.`iddid` ASC";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            if (result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, data: result, message: "DIDs Fetched Successfully" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, data: [], message: "No DIDs Available!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something went wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    // To Get DID's Detail For Swagger Side
    getDIDdetail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let con = '';
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    if (isNaN(sdata.DID) == false && typeof parseInt(sdata.DID) == "number") {
                        obj.qrysql = "SELECT REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS did, db.npa, db.nxx, db.state, db.ratecenter, ep.name AS connection_name, db.connection_key,DATE_FORMAT(db.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s') AS start_subscription, CASE db.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'auto_renewal', db.camp_registry AS sms_campaign, CASE WHEN db.sinch_status = '' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '0' THEN 'Enable SMS Service For This Number' WHEN db.sinch_status = '1' THEN 'SMS Fully Provisioned' WHEN db.sinch_status = '2' THEN 'Provisioning Waiting' WHEN db.sinch_status = '3' THEN 'Provisioning Inprogress' WHEN db.sinch_status = '4' THEN 'Provisioning Already Exist' WHEN db.sinch_status = '5' THEN 'Provisioned Failed' WHEN db.sinch_status = '6' THEN 'Retrying after 4 hours' WHEN db.sinch_status = '7' THEN 'You are not eligible to retry after failed' WHEN db.sinch_status = '8' THEN 'Time-out after 4 hour retry' WHEN db.sinch_status = '9' THEN 'Failed after failed retry' WHEN db.sinch_status = '10' THEN 'Provisioned Failed' END AS sms_service, db.`did_disconnect_days` FROM `did_buy` db LEFT JOIN `endpoint` ep ON  db.connection_key=ep.connection_key WHERE db.did LIKE '%" + sdata.DID + "%' " + con + " AND db.`account_id`='" + sessdata.idaccount + "' AND db.disconnect_did_status = '1' GROUP BY db.did";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                if (result.length > 0) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, data: result, message: "Record Fetched Successfully" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 402, message: "Record not found!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "DID is not Correct" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Not Permitted" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    // To Get getshortcode for panel
    getshortcode(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = [];
                sdata = req.query;
                let iduser = sdata.selectedUser.split("-")[0];
                let idaccount = sdata.selectedUser.split("-")[1];
                let condition = "";
                // For Customer account
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition += "d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";
                // For Customer account
                if (sessdata.type == 22)
                    condition += 'd.`iduser`="' + sessdata.iduser + '" AND ';
                if (sdata.selectedUser)
                    condition += 'd.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                if (sdata.selectSMS == 'enabled')
                    condition += "d.`sinch_status`='1' AND ";
                if (sdata.selectSMS == 'disabled')
                    condition += "(d.`sinch_status` !='1' OR d.`sinch_status` IS NULL OR d.`sinch_status`='' OR d.`sinch_status` ='0') AND ";
                if (sdata.didnumber)
                    condition += 'd.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                    let atr = sdata.autoRenew == 'Enabled' ? true : false;
                    condition += 'd.`subscription_auto_renew`="' + atr + '" AND ';
                }
                if (sdata.selectStatus == '0' || sdata.selectStatus == '1' || sdata.selectStatus == '2') {
                    let status = sdata.selectStatus;
                    condition += 'd.`sinch_status`="' + status + '" AND ';
                }
                if (sdata.fromDate && sdata.toDate)
                    condition += 'd.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT d.iddid, d.iduser, CONCAT(100000000 + CAST(d.account_id AS UNSIGNED)) AS san, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s') `created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " disconnect_did_status = '1' AND d.`type` = 'SC' GROUP BY d.did ORDER BY d.iddid DESC LIMIT 1000";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Fetch!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    onExportSCode(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let condition = "";
                let account_id = "";
                let idaccount;
                if (sdata.selectedUser) {
                    idaccount = sdata.selectedUser.split("-")[1];
                }
                if (sessdata.type == 1)
                    account_id += 'CONCAT(100000000 + CAST(db.account_id AS UNSIGNED)) AS SAN, ';
                // For Customer account
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition += "db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";
                // For Customer account
                if (sessdata.type == 22)
                    condition += 'db.`iduser`="' + sessdata.iduser + '" AND ';
                if (sdata.selectedUser)
                    condition += 'db.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`="' + idaccount + '") AND ';
                if (sdata.selectSMS == 'enabled')
                    condition += "db.`sinch_status`='1' AND ";
                if (sdata.selectSMS == 'disabled')
                    condition += "(db.`sinch_status` !='1' OR db.`sinch_status` IS NULL OR db.`sinch_status`='' OR db.`sinch_status` ='0') AND ";
                if (sdata.didnumber)
                    condition += 'db.`did` LIKE "%' + sdata.didnumber + '%" AND ';
                if (sdata.autoRenew == 'Enabled' || sdata.autoRenew == 'Disabled') {
                    let atr = sdata.autoRenew == 'Enabled' ? true : false;
                    condition += 'db.`subscription_auto_renew`="' + atr + '" AND ';
                }
                if (sdata.selectStatus == '0' || sdata.selectStatus == '1' || sdata.selectStatus == '2') {
                    let status = sdata.selectStatus;
                    condition += 'db.`sinch_status`="' + status + '" AND ';
                }
                if (sdata.fromDate && sdata.toDate)
                    condition += 'db.`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND ';
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT " + account_id + " REPLACE(REPLACE(db.did, CHAR(10),''), CHAR(13),'') AS DID, MAX(DATE_FORMAT(db.created_at, '%Y-%m-%d %H:%i:%s')) AS `Start Subscription`, DATE_FORMAT(db.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS `End Subscription`, MAX(db.subscription_auto_renew) AS `Auto Renewal`, MAX(db.`did_disconnect_days`) AS `Disconnect Days` , CASE db.sinch_status WHEN '0' THEN 'Not Assigned' WHEN '1' THEN 'SMS Fully Provisioned' WHEN '2' THEN 'Shortcode Number is in Processing' ELSE 'Unknown' END AS 'Status' FROM `did_buy` db LEFT JOIN `endpoint` ep ON db.connection_key = ep.connection_key INNER JOIN `user`u ON db.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " db.disconnect_did_status = '1' AND db.`type`= 'SC' GROUP BY db.did ORDER BY `Start Subscription` DESC";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Fetched Successfully!", data: result, status: 200, username: sessdata.username });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Data Expoting!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    AddCart(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = "INSERT into did_cart (`idaccount`, `phone_number`, `provider`) VALUES('" + sessdata.idaccount + "', '" + rdata.phone_number + "', '" + rdata.provider + "')";
                obj3.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: result, message: "DID Added into Your Cart!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: error, message: "Something went wrong" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getStates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id`, `name`, `abbrev` FROM `states` ORDER BY abbrev ASC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "States Fetched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    updateConnectionOnDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let condition = "";
                if (sessdata.type == 1)
                    condition = "";
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition = " AND `account_id`='" + sessdata.idaccount + "'";
                if (sessdata.type == 22)
                    condition = " AND `iduser`='" + sessdata.iduser + "'";
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body;
                obj2.nonqrysql = "UPDATE `did_buy` SET connection_key='" + rdata.ConnectionKey + "' WHERE `did`= '" + rdata.DID.trim() + "' " + condition + "";
                obj2.prepare();
                obj2.execute((error1, data) => {
                    if (error1 == 1 && data.affectedRows > 0) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'4','Connection Enabled Successfully','" + rdata.DID.trim() + "')";
                        obj1.prepare();
                        obj1.execute((errLog, resLog) => {
                            console.log("Connection Enabled Successfully.");
                        });
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, data: rdata, message: "Connection Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, error: error1, message: "Connection not updated Successfully!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /**
     * Other modules
     */
    PurchaseAllDIDs(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    let checkService = new APIBase_1.APIBase();
                    checkService.serviceActivation(req, res, sessdata, "5", async (err, resp) => {
                        if (resp.status == 200) {
                            const sdata = req.body;
                            const formattedDIDs = sdata.DID.map((number) => `'${number}'`).join(',');
                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT SUM(`rates`) AS overall_total_rates FROM (SELECT DISTINCT `phone_number`, `type`, `did_sub_type`, `rates` FROM `did_search` WHERE `phone_number` IN (" + formattedDIDs + ") AND `iduser` = '" + sessdata.iduser + "') AS subquery";
                            obj0.prepare();
                            obj0.execute((_error1, success) => {
                                if (_error1 == 1) {
                                    let didcount = sdata.DID.length;
                                    // To get the proration status
                                    /* let obj1 = new ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT t.idtariff FROM `user`u JOIN `tariff`t ON u.idtariff=t.idtariff WHERE iduser= '" + sessdata.iduser + "'";
                                    obj1.prepare();
                                    obj1.execute((proration_error, proration_success) => {
                                        if (proration_error == 1) { */
                                    let fun = new Number();
                                    fun.prorationGet(req, res, 'NN', 0, sessdata.idtariff, (error, proration) => {
                                        if (error == 1) {
                                            let rate = new APIBase_1.APIBase();
                                            rate.prorateCalculator(req, res, proration.proration, success[0].overall_total_rates, proration.setup_cost * didcount, (pc_err, prorate1) => {
                                                if (pc_err == 1) {
                                                    let proratedd = typeof prorate1 != 'undefined' && prorate1 > 0 ? prorate1 : 0;
                                                    let rate = new APIBase_1.APIBase();
                                                    rate.checkBalance(req, res, sessdata.idaccount, proratedd, (walletError, wallet) => {
                                                        if (walletError == 1) {
                                                            console.log("Bulk By Prorate::", proratedd);
                                                            let PI = 0;
                                                            let iQry = "";
                                                            let objN = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            // Iterate DID numbers to create the pending orders
                                                            if (Array.isArray(sdata.DID) && sdata.DID.length > 0) {
                                                                sdata.DID.forEach((ele) => {
                                                                    iQry += "INSERT INTO `did_order` SET `iduser`=" + sessdata.iduser + ", `idaccount`=" + sessdata.idaccount + ", `did`='" + ele + "', `id_grouporder`=" + sdata.id_grouporder + ", status='102';\n";
                                                                    PI++;
                                                                });
                                                            }
                                                            if (PI > 0) {
                                                                objN.nonqrysql = iQry;
                                                                objN.prepare();
                                                                objN.execute((error, result) => {
                                                                    if (error == 1) {
                                                                        let condition;
                                                                        // To delete the selected DID from cart
                                                                        if (sdata.NonDID.length > 0) {
                                                                            condition += '`did` IN(' + sdata.DID + "," + sdata.NonDID + ')';
                                                                        }
                                                                        else {
                                                                            condition += '`did` IN(' + sdata.DID + ')';
                                                                        }
                                                                        iQry = "DELETE FROM `did_cart` WHERE " + condition + ";";
                                                                        objN.nonqrysql = iQry;
                                                                        objN.prepare();
                                                                        objN.execute((error, result) => {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({
                                                                                error: 0,
                                                                                status: 200,
                                                                                message: "DIDs successfully processed for bulk order purchase."
                                                                            });
                                                                            objv.execute();
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            error: 1,
                                                                            status: 400,
                                                                            message: "DIDs did not processed for bulk order purchase!"
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    error: 1,
                                                                    status: 500,
                                                                    message: "There are no DIDs in cart!"
                                                                });
                                                                objv.execute();
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                error_code: 0,
                                                                error: walletError,
                                                                message: "Please add funds to your account or contact support.",
                                                                status: 503
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        error_code: 0,
                                                        error: 'Wallet Issue',
                                                        message: "Something Went Wrong to Fetch Account Balance.",
                                                        status: 503
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                error_code: 0,
                                                status: 503,
                                                message: "Something went wrong with connection."
                                            });
                                            objv.execute();
                                        }
                                    });
                                    /* let dateObj = new Date();
                                    let day = dateObj.getUTCDate();
                                    let nDate: any = new Date()
                                    let lDate: any = (new Date(nDate.getFullYear(), (nDate.getMonth() + 1), 0)).getDate()
                                    let totalDays = (lDate - day) + 1;
                                    let prorate: any;
                                    if (proration_success[0].proration == "true")
                                        prorate = (totalDays * success[0].overall_total_rates) / lDate;
                                    else
                                        prorate = success[0].overall_total_rates;

                                    prorate = typeof prorate != 'undefined' && prorate > 0 ? prorate : 0 */
                                    // let obj2 = new ModelRawQuery(req, res);
                                    // obj2.qrysql = "SELECT `idwallet` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "' AND `balance` + `credit_limit` >= '" + prorate + "'"
                                    // obj2.prepare();
                                    // obj2.execute((walletError: any, wallet: any) => {
                                    //     if (walletError == 1 && wallet.length > 0) {
                                    /* } else {
                                        let obj = new RawView(res);
                                        obj.prepare({
                                            error_code: 0,
                                            status: 502,
                                            message: "Something went wrong with get proration!"
                                        });
                                        obj.execute();
                                    }
                                }); */
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: 1, status: 404, message: "Rates not found!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error_code: err,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "DID Buy")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ status: 404, message: "Permission Denied!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /**
     * To create the group of did orders
     */
    CreateGroupOrder(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    let checkService = new APIBase_1.APIBase();
                    checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                        if (resp.status == 200) {
                            const sdata = req.body.data;
                            let process_dids;
                            if (sdata.numbers)
                                process_dids = sdata.total_dids <= 10 ? sdata.total_dids : 0;
                            else
                                process_dids = 0;
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + sdata.name + "', total_dids=" + (0, markError_1.setToZero)(sdata.total_dids) + ", process_dids=" + process_dids + ", numbers='" + sdata.numbers + "', routing='" + sdata.routing + "', in_routing='" + sdata.in_routing + "', out_routing='" + sdata.out_routing + "', campaign='" + sdata.campaign + "',status='0';";
                            obj.prepare();
                            obj.execute((error, result) => {
                                let objv = new RawView_1.RawView(res);
                                if (error == 1) {
                                    objv.prepare({
                                        error: 0,
                                        status: 200,
                                        message: "Group successfully created.",
                                        data: {
                                            id_grouporder: result.insertId
                                        }
                                    });
                                    objv.execute();
                                }
                                else {
                                    objv.prepare({
                                        error: 1,
                                        status: 502,
                                        message: "Something went wrong with connection!"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error: 1,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "DID Buy")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    checkDidOrder(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                    let checkService = new APIBase_1.APIBase();
                    checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                        if (resp.status == 200) {
                            const sdata = req.body;
                            const numbersArray = [] = sdata;
                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                            obj2.qrysql = "SELECT `numbers` FROM `did_group_order` WHERE iduser=" + sessdata.iduser + " AND idaccount=" + sessdata.idaccount + " AND `status`=0";
                            obj2.prepare();
                            obj2.execute((error, result) => {
                                let objv = new RawView_1.RawView(res);
                                if (error == 1) {
                                    if (result.length > 0) {
                                        // // Filter array2 to find values that are also in array1
                                        var matchNo;
                                        var nonMatchingNo = [];
                                        if (result.length > 0) {
                                            var numberSet = new Set(numbersArray);
                                            var databaseNo = [];
                                            result.forEach((packet) => {
                                                let numbersArray1 = packet.numbers.split(',');
                                                databaseNo.push(...numbersArray1);
                                            });
                                            databaseNo = [...new Set(databaseNo)];
                                            matchNo = databaseNo.filter((value) => numbersArray.includes(value));
                                            //    nonMatchingNo =matchNo.filter((value: any) => !numbersArray.includes(value));
                                            nonMatchingNo = sdata.filter((value) => !new Set(matchNo).has(value));
                                            objv.prepare({
                                                error: 0,
                                                status: 409,
                                                message: 'Your Previous order is in Pending. Do you want to make order again?',
                                                data: {
                                                    matchNo: matchNo,
                                                    nonMatchingNo: nonMatchingNo,
                                                    pendingOrder: result.length
                                                }
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        objv.prepare({
                                            error: 0,
                                            status: 408,
                                            message: "You Don't have Pending Order!",
                                            data: {
                                                matchNo: [],
                                                nonMatchingNo: numbersArray,
                                                pendingOrder: 0
                                            }
                                        });
                                        objv.execute();
                                    }
                                }
                                else {
                                    objv.prepare({
                                        error: 1,
                                        status: 502,
                                        message: "Something went wrong with connection!"
                                    });
                                    objv.execute();
                                }
                            });
                            //End bulk dids
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error: 1,
                                status: resp.status,
                                message: resp.message.replace(/::SN::/g, "DID Buy")
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /**
     * To store order
     */
    async storeDidOrder(req, res, next) {
        return new Promise((resolve, reject) => {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    const sdata = req.body;
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let process_dids;
                    if (sdata.DID.length)
                        process_dids = sdata.DID.length <= 10 ? sdata.DID.lenght : 0;
                    else
                        process_dids = 0;
                    obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + sdata.name + "', total_dids=" + (0, markError_1.setToZero)(sdata.DID.length) + ", process_dids=" + (0, markError_1.setToZero)(process_dids) + ", numbers='" + sdata.DID.join() + "', routing='" + sdata.Connection + "', in_routing='" + sdata.InboundVoice + "', out_routing='" + sdata.OutboundVoice + "', campaign='" + sdata.CampaignId + "';";
                    obj.prepare();
                    obj.execute((error, result) => {
                        let objv = new RawView_1.RawView(res);
                        if (error == 1) {
                            resolve(result.insertId);
                            objv.prepare({
                                error: 0,
                                status: 200,
                                message: "Group successfully created.",
                                data: {
                                    id_grouporder: result.insertId
                                }
                            });
                            objv.execute();
                            console.log("result.insertId", result.insertId);
                        }
                        else {
                            objv.prepare({
                                error: 1,
                                status: 502,
                                message: "Something went wrong with connection!"
                            });
                            objv.execute();
                            reject(0);
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 401, message: "Unauthorized User" });
                    objv.execute();
                }
            });
        });
    }
    /**
     * To get the customer's DID list for sms test
     */
    getSMSTextDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let con = "";
                if (sessData.type !== 1) {
                    con = " AND `account_id` = '" + sessData.idaccount + "'";
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error_code: 0,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                    return;
                }
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `did` FROM `did_buy` WHERE `sinch_status` = '1' " + con + " AND `disconnect_did_status` = '1'";
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'DID Fatched', data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**
     * To get the orders history
     */
    GetOrdersHistory(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let objv = new RawView_1.RawView(res);
                obj2.qrysql = "SELECT `id_grouporder`, `name`, total_dids, process_dids, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `date`, CASE WHEN `status` = 0 THEN 'Pending' WHEN `status` = 1 THEN 'Complete' WHEN `status` = 2 THEN 'Partially Complete' WHEN `status` = 3 THEN 'Failed' ELSE '' END as `status` FROM `did_group_order` WHERE idaccount=" + sessdata.idaccount + " ORDER BY id_grouporder";
                obj2.prepare();
                obj2.execute((error, result) => {
                    if (error == 1) {
                        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                        obj3.qrysql = "SELECT `id_grouporder`, `name`, total_dids, process_dids, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `date`, CASE WHEN `status` = 0 THEN 'Pending' WHEN `status` = 1 THEN 'Complete' WHEN `status` = 2 THEN 'Partially Complete' WHEN `status` = 3 THEN 'Failed' ELSE '' END as `status` FROM `did_group_order` WHERE idaccount=" + sessdata.idaccount + " ORDER BY id_grouporder DESC LIMIT 1000;";
                        obj3.prepare();
                        obj3.execute((errE, result1) => {
                            if (errE == 1) {
                                objv.prepare({
                                    error: 0,
                                    message: "Records fetched successfully.",
                                    data: result,
                                    data1: result1,
                                });
                                objv.execute();
                            }
                            else {
                                objv.prepare({
                                    error: 1,
                                    message: "No data found!",
                                    data: [],
                                    data1: []
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "No data found!",
                            data: [],
                            data1: []
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    /**
     * To view the order history
     */
    ViewOrderHistory(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = [];
                sdata = req.query;
                console.log("QRY::", sdata);
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let objv = new RawView_1.RawView(res);
                let iQry = "SELECT `did`,`provider`,`providerOrderId`,`status`,`type`,`cost`,`description`,`log_status`,`log_statusCode`,`log_message`,`log_result`,`log_error`,`order_no`, CASE WHEN is_process=0 THEN 'In Process' WHEN error_code=2 THEN 'Completed' WHEN error_code=4 THEN 'Failed' ELSE 'N/A' END order_status, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `created_date` FROM `did_order`\n";
                iQry += "WHERE idaccount=" + sessdata.idaccount + " AND id_grouporder=" + sdata.id_grouporder + " ORDER BY id_order DESC;";
                obj2.qrysql = iQry;
                obj2.prepare();
                obj2.execute((error, result) => {
                    if (error == 1) {
                        let Result = result ? result : [];
                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: Result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "No data found!",
                            data: []
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    getDisconnectedDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessdata) => {
            if (sessErr == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                let con = '';
                if (sessdata.type == 1) // for Admin account
                    con = '';
                else if (sessdata.type == 22) //for sub customer account
                    con = " AND d.iduser = '" + sessdata.iduser + "'";
                else // for customer account
                    con = " AND d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "')";
                obj2.qrysql = "SELECT d.iddid, d.iduser, d.account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key WHERE  disconnect_did_status = '2' " + con + "";
                obj2.prepare();
                obj2.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Disconnected DID Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    restoreDisconnectDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessdata) => {
            if (sessErr == 1) {
                if (sessdata.type == 2 || sessdata.type == 22) {
                    let sdata = req.body.data;
                    let count = 0;
                    sdata.forEach((el, idx, dids) => {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE  `did_buy` SET disconnect_did_status='1' WHERE disconnect_did_status='2' AND `did`=" + el.did + " AND `iddid`=" + el.iddid + "";
                        obj.prepare();
                        obj.execute((err, result) => {
                            if (err == 1) {
                                count++;
                                console.log("Count ::" + count);
                                if (count == sdata.length) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: 'DID Restored Successfully!', status: 200 });
                                    objv.execute();
                                }
                            }
                        });
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        error: 1,
                        status: 404,
                        message: "Not Permitted"
                    });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    getSmsProvider(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT p.`priority`, u.`username` as `sms_provider` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sdata.type + "') AND p.type='sms'";
                obj1.prepare();
                obj1.execute((error, responce) => {
                    if (error == 1) {
                        if (responce.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, message: "Provider fetched successfully", data: responce });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: "No provider found" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new _404_1.Res404(res);
                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getMultiSearch(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = JSON.parse(req.body.data);
                var allData = [];
                var forNotFound = [];
                var roughDID = [];
                let allFindDID = [];
                var didWithLk = '';
                var condition = "";
                var eMsg = "";
                if (sessdata.type == 1)
                    condition = "";
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    condition = " d.`iduser` IN (SELECT `iduser` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "') AND ";
                if (sessdata.type == 22)
                    condition = " d.`iduser`='" + sessdata.iduser + "' AND ";
                if (sdata.num && sdata.num.length > 0) {
                    var temp;
                    var allData = [];
                    var forNotFound = [];
                    var roughDID = [];
                    Object.keys(sdata.num).forEach((ele) => {
                        temp = sdata.num[ele].replace(/^\s*/, "").replace(/\s*$/, "").trim();
                        if (temp.length >= 10 && temp.length <= 12 && temp !== undefined) {
                            // allData.push('"' + temp + '"');
                            allData.push(temp);
                            forNotFound.push(temp);
                            didWithLk += " d.`did` LIKE '" + (temp.replace(/"/g, '')).slice(-10) + "%' OR";
                        }
                        else {
                            if (temp.length > 0)
                                roughDID.push(temp);
                        }
                    });
                }
                if (req.file) {
                    let firstrow1 = fs.readFileSync(req.file.path).toString().split('\n');
                    let firstrow = firstrow1[0].split('\r');
                    let str = "";
                    if (!firstrow[0].match(/[a-z]/)) {
                        console.log("LETTER FOUND");
                        str = '';
                    }
                    else {
                        console.log("LETTER NOT FOUND");
                        str = 'IGNORE 1 LINES';
                    }
                    var str_array = [];
                    str_array = firstrow[0].split(',');
                    var allData = [];
                    var forNotFound = [];
                    var roughDID = [];
                    for (var i = 1; i < firstrow1.length; i++) {
                        let num = firstrow1[i].replace(/^\s*/, "").replace(/\s*$/, "").trim();
                        if (num && num.length >= 10 && num.length <= 12 && num !== undefined) {
                            // allData.push('"' + num + '"');
                            allData.push(num);
                            forNotFound.push(num);
                            didWithLk += " d.`did` LIKE '" + (num.replace(/"/g, '')).slice(-10) + "%' OR";
                        }
                        else {
                            if (num.length > 0)
                                roughDID.push(num);
                        }
                    }
                }
                let DIDL = didWithLk !== '' && didWithLk !== undefined ? didWithLk.slice(0, -2) : '';
                let event_type = "", descMsg = "", errMsg = "", keyVal = "", event_desc = "", chekCondition = "";
                switch (sdata.option) {
                    case "connection":
                        event_type = "9";
                        event_desc = "Connection Disable";
                        descMsg = "Connection Disabled Successfully";
                        errMsg = "Something went wrong with Connection Disabled!";
                        keyVal = " connection_key = '', inbound_key='', outbound_key='', updated_at=NOW() ";
                        chekCondition = '';
                        break;
                    case "set_connection":
                        event_type = "14";
                        event_desc = "Connection Updated";
                        descMsg = "Connection Updated Successfully";
                        errMsg = "Something went wrong with Connection Disabled!";
                        keyVal = " connection_key = '" + sdata.connectionValue + "', inbound_key='" + sdata.inboundValue + "', outbound_key='" + sdata.outboundValue + "',updated_at=NOW() ";
                        chekCondition = sdata.connectionValue;
                        break;
                    case "auto_enable":
                        event_type = "3";
                        event_desc = "Auto Renewal Enable";
                        descMsg = "Auto Renewal Enable Successfully";
                        errMsg = "Something went wrong with Auto Renewal Enable!";
                        keyVal = " subscription_auto_renew = 'true', updated_at=NOW() ";
                        chekCondition = 'true';
                        break;
                    case "auto_disable":
                        event_type = "8";
                        event_desc = "Auto Renewal Disable";
                        descMsg = "Auto Renewal Disabled Successfully";
                        errMsg = "Something went wrong with Auto Renewal Disabled!";
                        keyVal = " subscription_auto_renew = 'false', updated_at=NOW() ";
                        chekCondition = 'false';
                        break;
                    case "disconnect":
                        event_type = "31";
                        event_desc = "Bulk DID Delete Initiated";
                        descMsg = "DID Disconnected Successfully";
                        errMsg = "Something went wrong with DID Disconnected!";
                        keyVal = " disconnect_did_status = '2', updated_at=NOW() ";
                        chekCondition = '2';
                        break;
                    case "search":
                        event_desc = "Search";
                        break;
                }
                if (!sdata.option || sdata.option == 'no')
                    eMsg = "Please select Action Type";
                if (allData.length <= 0)
                    eMsg = "Please send at least one 10 digit's DID";
                if (eMsg) {
                    let payload = {
                        roughDID: roughDID,
                        allFindDID: [],
                        forNotFound: [],
                        sessdata: sessdata,
                        sdata: sdata,
                        actiontype: event_desc
                    };
                    let number = new Number();
                    number.bulkLogCreator(req, res, payload, 'BulkActionLog', next);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: eMsg, roughDID: roughDID, findDID: [], notFindDID: [] });
                    objv.execute();
                }
                else {
                    if (sdata.option == "search") {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT d.iddid, d.iduser, CONCAT(100000000 + CAST(d.account_id AS UNSIGNED)) AS account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`, d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " (" + DIDL + ") AND d.`disconnect_did_status` = '1' AND d.type IN ('NN', 'TF','INN') GROUP BY d.`did` ORDER BY d.`iddid` DESC LIMIT 10000";
                        obj1.prepare();
                        obj1.execute((error1, responce) => {
                            if (error1 == 1 && responce.length > 0) {
                                responce.forEach((element) => {
                                    allFindDID.push(element.did);
                                });
                                for (let i of allFindDID) {
                                    const index = forNotFound.indexOf(i);
                                    if (index > -1) { // when item is found
                                        forNotFound.splice(index, 1); // means remove one item only
                                    }
                                }
                                // bulk action log 
                                let payload = {
                                    roughDID: roughDID,
                                    allFindDID: allFindDID,
                                    forNotFound: forNotFound,
                                    sessdata: sessdata,
                                    sdata: sdata,
                                    actiontype: event_desc
                                };
                                let number = new Number();
                                number.bulkLogCreator(req, res, payload, 'BulkActionLog', next);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, message: "Result Fetched Successfully!", data: responce, roughDID: roughDID, findDID: allFindDID, notFindDID: forNotFound });
                                objv.execute();
                            }
                            else {
                                // bulk action log 
                                let payload = {
                                    roughDID: roughDID,
                                    allFindDID: allFindDID,
                                    forNotFound: forNotFound,
                                    sessdata: sessdata,
                                    sdata: sdata,
                                    actiontype: event_desc
                                };
                                let number = new Number();
                                number.bulkLogCreator(req, res, payload, 'BulkActionLog', next);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "DID not found!", roughDID: roughDID, findDID: [], notFindDID: [] });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT d.iddid, d.did, d.iduser, CONCAT(100000000 + CAST(d.account_id AS UNSIGNED)) AS account_id, d.`did_disconnect_days`,d.`connection_key`,d.`subscription_auto_renew`,d.`disconnect_did_status` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " (" + DIDL + ") AND d.`disconnect_did_status` = '1' GROUP BY d.`did` ORDER BY d.`iddid` DESC";
                        obj1.prepare();
                        obj1.execute((error1, resDD) => {
                            if (error1 == 1 && resDD.length > 0) {
                                var allData1 = [];
                                var allDataForLog = [];
                                var allDataForNotLog = [];
                                var didWithLk1 = '';
                                let temp;
                                let checkKey;
                                const optionToKeyMap = {
                                    connection: 'connection_key',
                                    set_connection: 'connection_key',
                                    auto_enable: 'subscription_auto_renew',
                                    auto_disable: 'subscription_auto_renew',
                                    disconnect: 'disconnect_did_status',
                                };
                                checkKey = optionToKeyMap[sdata.option] || '';
                                resDD.forEach((element) => {
                                    temp = element.did.replace(/^\s*/, "").replace(/\s*$/, "").trim();
                                    allData1.push(temp);
                                    if (checkKey && element[checkKey] == chekCondition) {
                                        allDataForNotLog.push(temp); // Match condition
                                    }
                                    else {
                                        allDataForLog.push(temp); // Doesn't match condition
                                        didWithLk1 += " d.`did` LIKE '" + (temp.replace(/"/g, '')).slice(-10) + "%' OR";
                                    }
                                });
                                for (let i of allData1) {
                                    const index = forNotFound.indexOf(i);
                                    if (index > -1) { // when item is found
                                        forNotFound.splice(index, 1); // means remove one item only
                                    }
                                }
                                let DIDL1 = didWithLk1 !== '' && didWithLk1 !== undefined ? didWithLk1.slice(0, -2) : '';
                                if (DIDL1 !== '') {
                                    // DIDL1 = d.`did` IN (" + allData1 + ")
                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj2.nonqrysql = "UPDATE did_buy d SET " + keyVal + " WHERE " + condition + " " + DIDL1 + ";";
                                    obj2.prepare();
                                    obj2.execute((error, resp) => {
                                        if (error == 1) {
                                            if (allDataForLog.length > 0) {
                                                let iQry = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`) VALUE";
                                                // for (let did of allData1) {
                                                for (let did of allDataForLog) {
                                                    iQry += "('" + sessdata.idaccount + "','" + sessdata.iduser + "',NOW(),'" + event_type + "','" + event_desc + "','" + did + "'),";
                                                }
                                                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj0.nonqrysql = iQry.slice(0, -1);
                                                obj0.prepare();
                                                obj0.execute((errLog, resLog) => {
                                                    console.log(descMsg);
                                                });
                                            }
                                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj1.qrysql = "SELECT d.iddid, d.iduser, CONCAT(100000000 + CAST(d.account_id AS UNSIGNED)) AS account_id, d.user_id, d.sinch_retry, d.status, d.sinch_status, d.connection_key,d.inbound_key,d.outbound_key,d.camp_registry,DATE_FORMAT(d.subscription_end_date, '%Y-%m-%d %H:%i:%s') AS subscription_end_date, CASE d.subscription_auto_renew WHEN 'true' THEN 'Enabled' ELSE 'Disabled' END 'sub_auto_renew',IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY),LAST_DAY(NOW()))AS subscription_end_dates, IF(DATE_ADD(d.`created_at`,INTERVAL t.day_num DAY) >NOW(),'Not Expire','Expire')AS subscription_status, REPLACE(REPLACE(d.did, CHAR(10),''), CHAR(13),'') AS did, d.provider, d.sms_provider, d.order_id, d.npa, d.nxx, d.state, d.ratecenter, d.type, d.cnam, d.is_sms_inbound, e.name AS connectionName, DATE_FORMAT(d.`created_at`, '%Y-%m-%d %H:%i:%s')`created_at`,d.`did_disconnect_days` FROM `did_buy`d LEFT JOIN `endpoint`e ON d.connection_key = e.connection_key INNER JOIN `user`u ON d.iduser=u.iduser INNER JOIN `tariff` t ON t.idtariff=u.idtariff WHERE " + condition + " (" + DIDL1 + ") AND d.`disconnect_did_status` = '1' AND d.type IN ('NN', 'TF','INN') GROUP BY d.`did` ORDER BY d.`iddid` DESC LIMIT 1000";
                                            obj1.prepare();
                                            obj1.execute((errDID, resDID) => {
                                                if (errDID == 1) {
                                                    // -------------------------
                                                    let allFindDID = [];
                                                    resDID.forEach((element) => {
                                                        // allFindDID.push('"' + element.did + '"');
                                                        allFindDID.push(element.did);
                                                    });
                                                    for (let i of allFindDID) {
                                                        const index = forNotFound.indexOf(i);
                                                        if (index > -1) { // when item is found
                                                            forNotFound.splice(index, 1); // means remove one item only
                                                        }
                                                    }
                                                    // bulk action log 
                                                    let payload = {
                                                        roughDID: roughDID,
                                                        allFindDID: allData1,
                                                        forNotFound: forNotFound,
                                                        sessdata: sessdata,
                                                        sdata: sdata,
                                                        actiontype: event_desc
                                                    };
                                                    let number = new Number();
                                                    number.bulkLogCreator(req, res, payload, 'BulkActionLog', next);
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 200, message: descMsg, data: resDID, roughDID: roughDID, findDID: allData1, notFindDID: forNotFound, logNotCreated: allDataForNotLog, logCreated: allDataForLog });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 502, message: errMsg, roughDID: roughDID, findDID: [], notFindDID: [] });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: errMsg, roughDID: roughDID, findDID: [], notFindDID: [] });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    // bulk action log 
                                    let payload = {
                                        roughDID: roughDID,
                                        allFindDID: allFindDID,
                                        forNotFound: forNotFound,
                                        sessdata: sessdata,
                                        sdata: sdata,
                                        actiontype: event_desc
                                    };
                                    let number = new Number();
                                    number.bulkLogCreator(req, res, payload, 'BulkActionLog', next);
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "DID not found!", roughDID: roughDID, findDID: [], notFindDID: [] });
                                    objv.execute();
                                }
                            }
                            else {
                                // bulk action log 
                                let payload = {
                                    roughDID: roughDID,
                                    allFindDID: allFindDID,
                                    forNotFound: forNotFound,
                                    sessdata: sessdata,
                                    sdata: sdata,
                                    actiontype: event_desc
                                };
                                let number = new Number();
                                number.bulkLogCreator(req, res, payload, 'BulkActionLog', next);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "DID not found.", roughDID: roughDID, findDID: [], notFindDID: [] });
                                objv.execute();
                            }
                        });
                    }
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    bulkLogCreator(req, res, payload, type, next) {
        const fs = require("fs");
        const path = require("path");
        const timestamp = Date.now();
        console.log("payloadpayload", payload);
        const logs = [
            { values: payload.roughDID, type: "InCorrect DID" },
            { values: payload.allFindDID, type: "Action Perform" },
            { values: payload.forNotFound, type: "Not Found" },
        ];
        // Path for the CSV file
        const directoryPath = dir.SAVECSV;
        const fileName = `output_${timestamp}.csv`;
        const filePath = path.join(directoryPath, fileName);
        let csvData = "NPANXXYYYY,Type\n";
        logs.forEach(log => {
            log.values.forEach((value) => {
                csvData += `${value},${log.type}\n`;
            });
        });
        // Write CSV data to the file
        fs.writeFile(filePath, csvData, (err) => {
            // console.log("Sdfsdfsdfsdf", filePath, csvData);
            if (err) {
                console.error("Error writing to file", err);
            }
            else {
                console.log("Data written to CSV file successfully");
            }
        });
        let localpath = csvbulkaction.BulkActionLogCsv + fileName;
        // console.log("asdfsdfdsfsd", localpath);
        // End csv code
        let add = payload.roughDID.length + payload.allFindDID.length + payload.forNotFound.length;
        let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj7.nonqrysql = "INSERT INTO `did_log_bulkaction` (`idaccount`,`iduser`,`total_did`,`correct_did`,`notfound_did`,`incorrect_did`,`actiontype`,`file_path`,`created_at`) VALUES ('" + payload.sessdata.idaccount + "','" + payload.sessdata.iduser + "','" + add + "','" + payload.allFindDID.length + "','" + payload.forNotFound.length + "','" + payload.roughDID.length + "','" + payload.actiontype + "','" + localpath + "', NOW())";
        obj7.prepare();
        obj7.execute((error7, responce7) => {
            if (error7 == 1 && responce7.length > 0) {
                console.log("Log Created Successfully");
            }
            else {
                console.log("Something went wrong with Log Creation!");
            }
        });
    }
    BuyTollfreeNumber(req, res, data, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query.Quantity;
                let checkService = new APIBase_1.APIBase();
                checkService.serviceActivation(req, res, sessdata, "5", (err, resp) => {
                    if (resp.status == 200) {
                        if (sdata) {
                            if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                                let key = (0, md5_1.default)(sessdata.authkey + (new Date()));
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT p.`priority` ,u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + sessdata.iduser + "' ) AND p.type='did'";
                                obj1.prepare();
                                obj1.execute((error, responce) => {
                                    if (error == 1) {
                                        if (responce.length > 0) {
                                            let index_thinq = "100", index_intel = "100", index_coretel = "100", index_teleapi = "100", index_peerless = "100";
                                            responce.forEach((ele) => {
                                                if (ele.username == "thinq")
                                                    index_thinq = ele.priority;
                                                if (ele.username == "inteliquent")
                                                    index_intel = ele.priority;
                                                if (ele.username == "teleapi")
                                                    index_teleapi = ele.priority;
                                                if (ele.username == "Coretel")
                                                    index_coretel = ele.priority;
                                                if (ele.username == "Peerless")
                                                    index_peerless = ele.priority;
                                            });
                                            console.log({
                                                "index_thinq": index_thinq,
                                                "index_intel": index_intel,
                                                "index_teleapi": index_teleapi,
                                                "index_coretel": index_coretel,
                                                "index_peerless": index_peerless
                                            });
                                            // let thinq = new ThinQAPI(index_thinq, sessdata, key);
                                            // thinq.tfRequest(req, res, (err1, res1) => {
                                            let intel = new Inteliquent_1.InteliquentAPI(index_intel, sessdata, key);
                                            intel.tfRequest(req, res, data, (err2, res2) => {
                                            });
                                            /* intel.tfRequest(req, res, data, (err2, res2) => {
                                                // let tele = new TeleAPI(index_teleapi, sessdata, key);
                                                // tele.tfRequest(req, res, (err2, res2) => {
                                                // let peer = new PeerlessAPI(index_peerless, sessdata, key);
                                                // peer.tfRequest(req, res, (err3, res3) => {
                                                let obj2 = new ModelRawQuery(req, res);
                                                obj2.qrysql = "SELECT  `phone_number`, `provider` FROM `did_search` where `iduser` = '" + sessdata.iduser + "' AND `key`='" + key + "' ORDER BY `priorty`, `phone_number`";
                                                obj2.prepare();
                                                obj2.execute((err_result, res_result) => {
                                                    if (err_result == 1) {
                                                        if (res_result.length > 0) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 200, message: "DID Fetched Successfully", data: res_result });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 404, message: "No DID's found!" });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                        objv.execute();
                                                    }
                                                });
                                                // })
                                                //});
                                            }); */
                                            //});
                                        }
                                        else {
                                            let objv = new _404_1.Res404(res);
                                            objv.prepare({ status: 401, message: "Invalid  account setting kindly contact Admin" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, message: "Service unavilable!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 500, message: "Quantity is Required!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error_code: err,
                            status: resp.status,
                            message: resp.message.replace(/::SN::/g, "DID Buy")
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    Orderhistoryfilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let data = req.body.data;
                let condition = '';
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                let conditionU = '';
                if (sessdata.type == 1) {
                    conditionU += data.idaccount !== undefined ? " AND `idaccount`='" + data.idaccount + "'" : '';
                }
                if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203)
                    conditionU += "`idaccount`=" + sessdata.idaccount + "";
                if (data.Order_id) {
                    condition += ' `name` LIKE "%' + (0, markError_1.parseBody)(data.Order_id) + '%" AND';
                }
                if (data.fromDate && data.toDate) {
                    condition += ' `date` BETWEEN "' + data.fromDate + ' 00:00:00" AND "' + data.toDate + ' 23:59:59" AND';
                }
                if (data.Status) {
                    condition += ' `status` = ' + data.Status + ' AND';
                }
                obj.qrysql = "SELECT `id_grouporder`,`name`, `total_dids`, `process_dids`, DATE_FORMAT(`date`, '%d %b, %Y %h:%i %p') `date`, CASE WHEN `status` = 0 THEN 'Pending' WHEN `status` = 1 THEN 'Complete' WHEN `status` = 2 THEN 'Partially Complete' WHEN `status` = 3 THEN 'Failed' ELSE '' END as `status` FROM `did_group_order` WHERE " + condition + "" + conditionU;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Order List Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objh = new RawView_1.RawView(res);
                        objh.prepare({ message: "Something Went Wrong With Fetched Order List!", status: 502, error: result });
                        objh.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    prorationGet(req, res, types, subtypes, idtariff, callback) {
        let category, sub_category = 'message_activation';
        // To get catogory
        if (types == 'TF' && subtypes == 0) {
            category = 'toll_free_number';
        }
        else if (types == 'TF' && subtypes == 1) {
            category = 'vanity_number';
        }
        else if (types == 'NN' && subtypes == 0) {
            category = 'local_number';
        }
        else if (types == 'NN' && subtypes == 1) {
            category = 'imported_ott_mash';
        }
        else if (types == 'SC' && subtypes == 0) {
            category = 'short_code_lease';
        }
        else if (types == 'SC' && subtypes == 1) {
            category = 'vanity_short_code';
        }
        else if (types == 'SC' && (subtypes == 2 || subtypes == 3)) {
            category = 'migrated_short_code';
        }
        let objP = new RawQuery_1.ModelRawQuery(req, res);
        objP.qrysql = "SELECT `proration`, `mo` FROM `voice_rates` WHERE `category`='" + category + "' AND `idtariff`='" + idtariff + "' AND `subtype` = '" + sub_category + "'";
        objP.prepare();
        objP.execute((error, proration) => {
            if (error == 1) {
                let rt = [];
                if (proration.length > 0) {
                    rt = {
                        proration: proration[0].proration,
                        setup_cost: proration[0].mo
                    };
                }
                else {
                    rt = { proration: false, setup_cost: 0 };
                }
                callback(1, rt);
            }
            else {
                callback(0, '');
            }
        });
    }
    getDIDActionLog(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let conditionU;
                if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 202 || sessdata.type == 201 || sessdata.type == 203)
                    conditionU += " WHERE `idaccount`=" + sessdata.idaccount + "";
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id`,`idaccount`, `total_did`,`correct_did`,`notfound_did`,`incorrect_did`,`actiontype`,`file_path`,`created_at` FROM `did_log_bulkaction` " + conditionU + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "DID Log Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.Number = Number;
/**
 * Other class
 */
class DIDManager {
    constructor() { }
    /**
     * To create the group order for single DID
     */
    CreateGroupOrder(req, res, sessdata, data, callback) {
        const sdata = data;
        if (sdata.via_panel == 0) {
            let oname = "SOD" + String(new Date().getTime());
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + sessdata.iduser + ", idaccount=" + sessdata.idaccount + ", name='" + oname + "', total_dids=1, process_dids=1, numbers='" + sdata.numbers + "', routing='" + sdata.routing + "', in_routing='" + sdata.in_routing + "', out_routing='" + sdata.out_routing + "';";
            obj.prepare();
            obj.execute((error, result) => {
                if (error == 1) {
                    callback(1, {
                        id_grouporder: result.insertId
                    });
                }
                else {
                    callback(1, {
                        id_grouporder: 0
                    });
                }
            });
        }
        else {
            let id_grouporder = (typeof req.body.id_grouporder != 'undefined' && req.body.id_grouporder > 0) ? req.body.id_grouporder : 0;
            callback(1, {
                id_grouporder: id_grouporder
            });
        }
    }
}
exports.DIDManager = DIDManager;
