"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const multer1 = require('multer');
const setting_config_1 = require("../config/setting.config");
const MIME_TYPE_MAP1 = {
    // Images
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'image/bmp': 'bmp',
    'image/gif; version="87a"': 'gif',
    'image/gif; version="89a"': 'gif',
    // Audio    
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'audio/qcelp': 'qcelp',
    'audio/QCELP': 'qcp',
    'audio/x-wav': 'xwav',
    'audio/midi': 'midi',
    'audio/mid': 'mid',
    'audio/amr': 'amr',
    'audio/aac': 'aac',
    'audio/aacp': 'aacp',
    'audio/vnd.dlna.adts': 'aac',
    // Video   
    'video/h263': 'h263',
    'video/h264': 'h264',
    'video/jpeg': 'jpgv',
    'video/3gpp': '3gp',
    'video/mp4': 'mp4',
    'video/3gpp2': '3g2',
    'video/mp4v-es': 'mp4',
    'video/mp4-es': 'mp4',
    'video/quicktime': 'mov',
    // Application
    'application/gzip': 'gz',
    'application/rtf': 'rtf',
    'application/zip': 'zip',
    'application/x-zip-compressed': 'zip',
    'application/pdf': 'pdf',
    'application/msword': 'rtf',
    'application/x-gzip': 'gz',
    //Text 
    'text/x-vcard': 'vcf',
    'text/vcard': 'vcf',
};
const storage1 = multer1.diskStorage({
    destination: (req, file, cb) => {
        let mmsdir = new setting_config_1.UploadDirectory();
        const isValid = MIME_TYPE_MAP1[file.mimetype];
        let store;
        if (!isValid) {
            const error = new Error('Invalid file type');
            return cb(error);
        }
        else {
            if (req.route.path === "/uploadmmsmedia") {
                store = mmsdir.MMSUPLOADS;
            }
            else {
                store = mmsdir.MEDIAUPLOAD;
            }
            cb(null, store);
        }
    },
    filename: (req, file, cb) => {
        let file_path = file.originalname;
        let extension = file_path.split('.').pop();
        let randomName = Math.random().toString(36).substring(2, 12);
        const filenm = file.originalname;
        const flName = Date.now() + '-' + filenm.replace(filenm, randomName);
        const fileName = flName + '.' + extension;
        const ext = MIME_TYPE_MAP1[file.mimetype];
        cb(null, fileName);
    }
});
const errorHandler = (err, req, res, next) => {
    if (err) {
        res.status(502).json({ status: 404, message: err.message });
    }
    else {
        next();
    }
};
module.exports = [
    multer1({ storage: storage1 }).single('UPLOAD'),
    errorHandler
];
