"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OsrApi = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const numberRegistry_1 = require("../include/numberRegistry");
const SinchSubmitNumber_1 = require("../include/SinchSubmitNumber");
const RawView_1 = require("../lib/view/RawView");
const setting_config_1 = require("../config/setting.config");
const getOsrRecords = new setting_config_1.GetOsrRecord();
const cron = require('node-cron');
let request = require('request');
// const produrl = 'http://65.214.42.91:84/osr/v2/entries/';
// const devurl = 'http://osrdev-e1.netnumber.net:84/osr/v2/entries/';
// const myip = "iplink";
// const nnid = "104141";
class OsrApi extends numberRegistry_1.NumberRegistry {
    constructor(proirity, sessdata) {
        super(proirity, sessdata);
    }
    /**
     * To Add entry into OSR :: first method
     */
    addNumber(req, res, callback) {
        let sdata = req.body;
        let did = sdata.DID;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        let options = {
            'method': 'PUT',
            // 'url': produrl + "" + `${number1}`,
            'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
            'headers': {
                'Content-Type': 'application/json'
            },
            // body: '{id:"' + myip + '", nnid: "' + nnid + '"}'
            body: '{id:"' + getOsrRecords.OsrMyip + '", nnid: "' + getOsrRecords.Osrnnid + '"}'
        };
        console.log("options", options);
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.message == "Success") {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register' where `iduser` = '" + this.sessdata.iduser + "' AND `did`='" + number + "'";
                        obj.prepare();
                        obj.execute((err, resp) => {
                            if (resp) {
                                if (sdata.CampaignId !== undefined) {
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: 201, message: "DID buy and SMS enabled successfully" });
                                    obj.execute();
                                }
                            }
                            return callback(err, '');
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: Osr->addNumber::", e);
                    callback(error, "");
                }
            }
            else {
                callback(error, "");
            }
        });
    }
    /**
    //  * To Update entry into OSR :: first method //  Not in use
     */
    updateNumber(req, res, did_id, callback) {
        let sdata = req.body;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        if (sdata.CampaignId != null && sdata.CampaignId != '') {
            let checkMasterAc = new APIBase_1.APIBase();
            checkMasterAc.getMasterSlave(req, res, this.sessdata, this.sessdata.idaccount, 2, (err, resp1) => {
                if (resp1.status == 200) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId,provisioning_status FROM campaign WHERE `campaign_key` = '" + sdata.CampaignId + "' AND `idaccount` = '" + this.sessdata.idaccount + "' GROUP BY campaign_key";
                    obj1.prepare();
                    obj1.execute((error, camp_res) => {
                        if (error == 1 && camp_res.length > 0 && camp_res[0].provisioning_status == 3) {
                            if (camp_res[0].did_count >= camp_res[0].did_limit) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 400,
                                    message: "DID Buy Successfully but you can enable only [" + camp_res[0].did_limit + "] DID's in this Campaign.",
                                    result: [
                                        {
                                            "did": number
                                        }
                                    ]
                                });
                                objv.execute();
                            }
                            else {
                                let objh = new RawQuery_1.ModelRawQuery(req, res);
                                objh.qrysql = "SELECT did, camp_registry, sms_provider, provider,osr_status,sinch_status,type FROM did_buy WHERE account_id = '" + this.sessdata.idaccount + "' AND did = '" + sdata.DID.trim() + "' GROUP BY did";
                                objh.prepare();
                                objh.execute((error, responce) => {
                                    if (error == 1 && responce.length > 0) {
                                        let category = responce[0].type == 'NN' || responce[0].type == 'INN' ? 'NN' : 'TF';
                                        if (category == 'NN') {
                                            console.log("condition >>::::>> if osr_status == 'unregister' and sinch_status == '0'");
                                            let rate = new APIBase_1.APIBase();
                                            rate.getMessageRate(req, res, this.sessdata.idtariff, "message_activation", category, (err, message_rate) => {
                                                if (err == 1) {
                                                    let nrcMsgRate = message_rate.length > 0 && message_rate[0].nrc !== undefined ? message_rate[0].nrc : 0, mrcMsgRate = message_rate.length > 0 && message_rate[0].mrc !== undefined ? message_rate[0].mrc : 0;
                                                    let rate = new APIBase_1.APIBase();
                                                    rate.checkBalance(req, res, this.sessdata.idaccount, nrcMsgRate, (walletError, wallet) => {
                                                        if (walletError == 1) {
                                                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj0.qrysql = "SELECT `myip`, `nnid`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + camp_res[0].upstreamCnpId + "'";
                                                            obj0.prepare();
                                                            obj0.execute((camperr, campres) => {
                                                                if (camperr == 1 && campres.length > 0) {
                                                                    if (responce[0].provider == "inteliQ" || responce[0].provider == "thinQ" || responce[0].provider == "Peerless" || responce[0].provider == 'Importnumber') {
                                                                        let did = sdata.DID;
                                                                        let len = did.length - 10;
                                                                        let number = did.slice(len, did.length);
                                                                        let number1 = "+1" + number;
                                                                        let options = {
                                                                            'method': 'PUT',
                                                                            // 'url': produrl + "" + `${number1}`,
                                                                            'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
                                                                            'headers': {
                                                                                'Content-Type': 'application/json'
                                                                            },
                                                                            body: '{ id: "' + campres[0].myip + '", nnid:"' + campres[0].nnid + '" , "context": "A2P", "campaign_id": "' + sdata.CampaignId + '" }'
                                                                        };
                                                                        request(options, (error, response) => {
                                                                            if (!error) {
                                                                                try {
                                                                                    let data = JSON.parse(response.body);
                                                                                    let __tn = typeof data.tn != 'undefined' ? data.tn : '';
                                                                                    let __message = typeof data.message != 'undefined' ? data.message : '';
                                                                                    let __campaign_id = typeof data.campaign_id != 'undefined' ? data.campaign_id : '';
                                                                                    let rDt = {
                                                                                        tn: __tn,
                                                                                        message: __message,
                                                                                        campaign_id: __campaign_id
                                                                                    };
                                                                                    if (data.message == "Success") {
                                                                                        if (nrcMsgRate > 0) {
                                                                                            // To deduct SMS Enable charges
                                                                                            let objv = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            objv.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`-" + nrcMsgRate + " WHERE `idaccount`='" + this.sessdata.idaccount + "'";
                                                                                            objv.prepare();
                                                                                            objv.execute((wallet_error, wallet_success) => {
                                                                                                if (wallet_error == 1) {
                                                                                                    let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                    objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + this.sessdata.idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount successfully updated for EnableSMS', `status`=1";
                                                                                                    objWL.prepare();
                                                                                                    objWL.execute((error, result) => {
                                                                                                        console.log("Wallet amount successfully updated for EnableSMS :: ", nrcMsgRate);
                                                                                                    });
                                                                                                }
                                                                                                else {
                                                                                                    let objWL = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                    objWL.nonqrysql = "INSERT INTO `wallet_recharge_log` SET `idaccount`=" + this.sessdata.idaccount + ", `amount`='-" + nrcMsgRate + "', `purpose`='Wallet amount not updated for EnableSMS', `status`=2";
                                                                                                    objWL.prepare();
                                                                                                    objWL.execute((error, result) => {
                                                                                                        console.log("Wallet amount not updated for EnableSMS :: ", nrcMsgRate);
                                                                                                    });
                                                                                                }
                                                                                            });
                                                                                            // To Insert nrc
                                                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj4.nonqrysql = "INSERT INTO `sms_enabled_charges_log`(`iduser`,`idaccount`,`did`,`nrc`) VALUES ('" + this.sessdata.iduser + "','" + this.sessdata.idaccount + "','" + number + "','" + nrcMsgRate + "')";
                                                                                            obj4.prepare();
                                                                                            obj4.execute((osr_err, resp) => {
                                                                                                console.log("SMS Enabled Charges Log Inserted :: ", nrcMsgRate);
                                                                                            });
                                                                                        }
                                                                                        /* let obj2 = new ModelRawNonQuery(req, res);
                                                                                        obj2.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` + 1  WHERE `idaccount` = '" + this.sessdata.idaccount + "' AND `campaign_key` = '" + sdata.CampaignId + "'";
                                                                                        obj2.prepare();
                                                                                        obj2.execute((osr_errrr, resppp) => { */
                                                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                        obj3.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'register', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "', `sms_mrc`='" + mrcMsgRate + "' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                                                                        obj3.prepare();
                                                                                        obj3.execute((osr_err, resp) => {
                                                                                            if (osr_err == 1) {
                                                                                                if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSinch(req, res, resp1, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400,
                                                                                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SINCH!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                else {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSyniverse(req, res, resp1, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400,
                                                                                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SYNIVERSE!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                objv.prepare({
                                                                                                    status: 400,
                                                                                                    message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                    result: [
                                                                                                        {
                                                                                                            "did": number
                                                                                                        }
                                                                                                    ],
                                                                                                    error: "Something went wrong with updation!"
                                                                                                });
                                                                                                objv.execute();
                                                                                            }
                                                                                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'6','DID provisioned','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                            obj6.prepare();
                                                                                            obj6.execute((er, ins_result) => {
                                                                                                console.log("DID Log Inserted.");
                                                                                            });
                                                                                        });
                                                                                        /* }); */
                                                                                    }
                                                                                    else {
                                                                                        console.log("condition >>::::>> if osr_status == 'unregister' and need to enable from sinch");
                                                                                        let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                        obj8.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister', `camp_registry`='" + sdata.CampaignId + "', `sms_provider`='" + campres[0].sms_provider + "' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                                                                        obj8.prepare();
                                                                                        obj8.execute((osr_failed, resp) => {
                                                                                            if (osr_failed == 1) {
                                                                                                if (camp_res[0].upstreamCnpId == 'SINCH') {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSinch(req, res, resp1, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400, message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SINCH!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                else {
                                                                                                    let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                                                    sinch.EnableSMSFromSyniverse(req, res, resp1, (errorr, resp) => {
                                                                                                        if (errorr == 1) {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 200, message: "DID Buy Successfully!" });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({
                                                                                                                status: 400,
                                                                                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                                result: [
                                                                                                                    {
                                                                                                                        "did": number
                                                                                                                    }
                                                                                                                ],
                                                                                                                error: "DID not submitted to SYNIVERSE!"
                                                                                                            });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                objv.prepare({
                                                                                                    status: 400,
                                                                                                    message: "DID Buy Successfully but SMS enabled Failed!",
                                                                                                    result: [
                                                                                                        {
                                                                                                            "did": number
                                                                                                        }
                                                                                                    ],
                                                                                                    error: "Something went wrong with updation!"
                                                                                                });
                                                                                                objv.execute();
                                                                                            }
                                                                                        });
                                                                                        let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                        obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'12','provisioning failed','" + sdata.DID.trim() + "','" + sdata.CampaignId + "')";
                                                                                        obj7.prepare();
                                                                                        obj7.execute((er, ins_result) => {
                                                                                            console.log("DID Log Inserted.");
                                                                                        });
                                                                                    }
                                                                                }
                                                                                catch (e) {
                                                                                    console.log("Error :: Osr->updateNumber::", e);
                                                                                    let obj = new RawView_1.RawView(res);
                                                                                    obj.prepare({
                                                                                        error_code: 0, status: 502,
                                                                                        message: "DID Buy Successfully but Something went wrong!",
                                                                                        result: [
                                                                                            {
                                                                                                "did": number
                                                                                            }
                                                                                        ],
                                                                                        error: "Something went wrong!"
                                                                                    });
                                                                                    obj.execute();
                                                                                }
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({
                                                                                    status: 400,
                                                                                    message: "DID buy successfully but SMS enabled Failed",
                                                                                    result: [
                                                                                        {
                                                                                            "did": number
                                                                                        }
                                                                                    ],
                                                                                    error: "DID not submission failed to OSR!"
                                                                                });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            status: 404,
                                                                            message: "DID Buy Successfully but SMS enabled Failed",
                                                                            result: [
                                                                                {
                                                                                    "did": number
                                                                                }
                                                                            ],
                                                                            error: "Provider not found!"
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        status: 404,
                                                                        message: "DID buy successfully but SMS enabled Failed",
                                                                        result: [
                                                                            {
                                                                                "did": number
                                                                            }
                                                                        ],
                                                                        error: "SMS provider not found!"
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                status: 404,
                                                                message: "DID buy successfully but SMS enabled Failed",
                                                                result: [
                                                                    {
                                                                        "did": number
                                                                    }
                                                                ],
                                                                error: "Amount is not enough!"
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({
                                                        status: 400,
                                                        message: "DID Buy Successfully but SMS enabled Failed!",
                                                        result: [
                                                            {
                                                                "did": number
                                                            }
                                                        ],
                                                        error: "Rates Setting Invalid!"
                                                    });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                status: 400,
                                                message: "DID Buy Successfully but SMS enabled Failed!",
                                                result: [
                                                    {
                                                        "did": number
                                                    }
                                                ],
                                                error: "Service not available!"
                                            });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            status: 404,
                                            message: "DID Buy Successfully but This Campaign is not approved yet.Please try with another one!",
                                            result: [
                                                {
                                                    "did": number
                                                }
                                            ],
                                            error: "DID Not Found for enable SMS"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 404,
                                message: "DID Buy Successfully but This Campaign is not approved yet.Please try with another one!",
                                result: [
                                    {
                                        "did": number
                                    }
                                ],
                                error: "Campaign is not available or not approved!"
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        status: resp1.status,
                        message: resp1.message.replace(/::MG::/g, "Enable SMS")
                    });
                    objv.execute();
                }
            });
        }
        else {
            let obj = new RawView_1.RawView(res);
            obj.prepare({
                error_code: 1,
                status: 400,
                message: "DID Buy Successfully but SMS enabled Failed!",
                result: [
                    {
                        "did": number
                    }
                ],
                error: "Campaign Not found!"
            });
            obj.execute();
        }
    }
    /**
     * To Update entry with toll-free provisioning into OSR :: first method
     */
    updateNumberWithTollfree(req, res, callback) {
        let sdata = req.body;
        let options = {
            'method': 'PUT',
            // 'url': 'https://208.254.45.98/osr/v2/entries/1800551212',
            'url': getOsrRecords.OsrNumWithTollFree + `1800551212`,
            'headers': {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ "id": "mypid", "nnid": "123456", "context": "A2P", "ownertspid": "3434" })
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let ddata = JSON.parse(response.body);
                    if (ddata.rows.length > 0) {
                    }
                    else {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.prepare();
                        obj.execute((err, data) => {
                            callback(err, data);
                        });
                    }
                }
                catch (e) {
                    console.log("Error :: Osr->updateNumberWithTollfree::", e);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.prepare();
                obj.execute((err, data) => {
                    callback(err, data);
                });
            }
        });
    }
    /**
     * To Delete entry from OSR And Then SINCH :: first method
     */
    deleteNumber(req, res, callback) {
        let sdata = req.query;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "+1" + number;
        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
        obj0.qrysql = "SELECT `did`, `camp_registry`, did_sub_type, type, `osr_status`, `sinch_status`, `sinch_retry` FROM `did_buy` WHERE `did`='" + number + "' AND `account_id` = '" + this.sessdata.idaccount + "'";
        obj0.prepare();
        obj0.execute((err, result_did) => {
            if (err == 1 && result_did.length > 0) {
                let checkMasterAc = new APIBase_1.APIBase();
                checkMasterAc.getMasterSlave(req, res, this.sessdata, this.sessdata.idaccount, 2, (err, resp1) => {
                    if (resp1.status == 200) {
                        let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                        obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name,upstreamCnpId FROM `campaign` WHERE " + resp1.condition + " AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
                        obj00.prepare();
                        obj00.execute((err, result_camp) => {
                            if (err == 1 && result_camp.length > 0) {
                                let msg = '';
                                const sinchStatus = result_did[0].sinch_status == 0 || result_did[0].sinch_status == undefined || result_did[0].sinch_status == null || result_did[0].sinch_status == 'undefined' || result_did[0].sinch_status == 'null' || result_did[0].sinch_status == '' ? 0 : parseInt(result_did[0].sinch_status);
                                const sinchRetry = parseInt(result_did[0].sinch_retry);
                                switch (true) {
                                    case [0].includes(sinchStatus):
                                        msg = "SMS Service [" + result_did[0].camp_registry + "] is Already Disabled on this DID [" + result_did[0].did + "].";
                                        break;
                                    case [2, 3, 4, 10, 20].includes(sinchStatus):
                                        msg = 'SMS Disabled failed. Please try again.';
                                        break;
                                    case [5, 7].includes(sinchStatus) && sinchRetry < 2:
                                        msg = 'SMS Disabled failed. Please try again!';
                                        break;
                                }
                                if (msg) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: msg });
                                    objv.execute();
                                    return;
                                }
                                if ((result_did[0].osr_status == 'unregister' || result_did[0].osr_status == 'undefined' || result_did[0].osr_status == undefined || result_did[0].osr_status == null || result_did[0].osr_status == 'null') && (result_did[0].sinch_status == '1')) {
                                    console.log("Disable SMS condition >>::::>> if sinch_status='1' and osr_status='unregister'");
                                    if (result_camp[0].upstreamCnpId == 'SINCH') {
                                        // Delete from sinch
                                        let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                        sinch.deleteNumber(req, res, result_camp, resp1, (errorr, resp) => {
                                            if (!errorr) {
                                                let obj5 = new RawView_1.RawView(res);
                                                obj5.prepare({ status: 201, message: "SMS facility has been successfully disabled.", result: resp });
                                                obj5.execute();
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ status: 400, message: "SMS Disabled failed. Please try again." });
                                                obj.execute();
                                            }
                                        });
                                    }
                                    else {
                                        //  Delete from syniverse
                                        let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                        sinch.deleteNumberfromSyniverse(req, res, result_camp, resp1, (errorr, resp) => {
                                            if (errorr == 1) {
                                                let obj5 = new RawView_1.RawView(res);
                                                obj5.prepare({ status: 201, message: "SMS facility has been successfully disabled." });
                                                obj5.execute();
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ status: resp.status, message: resp.message });
                                                obj.execute();
                                            }
                                        });
                                    }
                                }
                                else if (result_did[0].osr_status == 'register' && result_did[0].sinch_status == '1') {
                                    console.log("Disable SMS condition >>::::>> if sinch_status='1' and osr_status='register'");
                                    let objk = new RawQuery_1.ModelRawQuery(req, res);
                                    objk.qrysql = "SELECT `myip`, `nnid`, nnid2, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + result_camp[0].upstreamCnpId + "'";
                                    objk.prepare();
                                    objk.execute((camperr, campres) => {
                                        if (camperr == 1 && campres.length > 0) {
                                            let nnid = result_did[0].did_sub_type == 1 && result_did[0].type == 'NN' ? campres[0].nnid2 : campres[0].nnid;
                                            let options = {
                                                'method': 'DELETE',
                                                // 'url': produrl + "" + `${number1}`,
                                                'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
                                                'headers': {
                                                    'Content-Type': 'application/json'
                                                },
                                                body: '{id:"' + campres[0].myip + '", nnid: "' + nnid + '"}'
                                            };
                                            request(options, (error, response) => {
                                                if (!error) {
                                                    try {
                                                        let data = JSON.parse(response.body);
                                                        if (data.message == "Success") {
                                                            //Counting Decrease (-1) and status update
                                                            /* let obj1 = new ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` - 1 WHERE " + resp1.condition + " AND campaign_key = '" + result_camp[0].campaign_key + "'";
                                                            obj1.prepare();
                                                            obj1.execute((err, updt_didby) => {
                                                            }); */
                                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj2.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                                            obj2.prepare();
                                                            obj2.execute((uperr, updt_stts) => { });
                                                            // here in this query we are using session iduser and id account for the understanding who is performed this action.
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'10','DID disconnected successfully','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                            obj4.prepare();
                                                            obj4.execute((er, ins_result) => {
                                                                console.log("SMS Disabled Successfully From OSR");
                                                            });
                                                            if (result_camp[0].upstreamCnpId == 'SINCH') {
                                                                // Delete from sinch
                                                                let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                sinch.deleteNumber(req, res, result_camp, resp1, (errorr, resp) => {
                                                                    if (!errorr) {
                                                                        let obj5 = new RawView_1.RawView(res);
                                                                        obj5.prepare({ status: 201, message: "SMS facility has been successfully disabled.", result: resp });
                                                                        obj5.execute();
                                                                    }
                                                                    else {
                                                                        let obj = new RawView_1.RawView(res);
                                                                        obj.prepare({ status: 400, message: "SMS Disabled failed. Please try again." });
                                                                        obj.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                //  Delete from syniverse
                                                                let sinch = new SinchSubmitNumber_1.SinchApi('', this.sessdata);
                                                                sinch.deleteNumberfromSyniverse(req, res, result_camp, resp1, (errorr, resp) => {
                                                                    if (errorr == 1) {
                                                                        let obj5 = new RawView_1.RawView(res);
                                                                        obj5.prepare({ status: 201, message: "SMS facility has been successfully disabled." });
                                                                        obj5.execute();
                                                                    }
                                                                    else {
                                                                        let obj = new RawView_1.RawView(res);
                                                                        obj.prepare({ status: resp.status, message: resp.message });
                                                                        obj.execute();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        else {
                                                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'17','DID disconnect failed','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                            obj6.prepare();
                                                            obj6.execute((er, ins_result) => {
                                                                console.log("SMS is not Disabled From OSR");
                                                            });
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({ status: data.response_code, message: data.message, result: data });
                                                            obj.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: Osr->deleteNumber::", e);
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'17','DID disconnect failed','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                    obj7.prepare();
                                                    obj7.execute((er, ins_result) => {
                                                        console.log("SMS is not Disabled From OSR");
                                                    });
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ status: 400, message: "SMS facility not disabled successfully." });
                                                    obj.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 404, message: "SMS Provider does Not Exist!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    console.log("Disable SMS condition >>::::>> if sinch_status='0' and osr_status='register'");
                                    let objk = new RawQuery_1.ModelRawQuery(req, res);
                                    objk.qrysql = "SELECT `myip`, `nnid`, `nnid2`, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + result_camp[0].upstreamCnpId + "'";
                                    objk.prepare();
                                    objk.execute((camperr, campres) => {
                                        if (camperr == 1 && campres.length > 0) {
                                            let nnid = result_did[0].did_sub_type == 1 && result_did[0].type == 'NN' ? campres[0].nnid2 : campres[0].nnid;
                                            let options = {
                                                'method': 'DELETE',
                                                // 'url': produrl + "" + `${number1}`,
                                                'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
                                                'headers': {
                                                    'Content-Type': 'application/json'
                                                },
                                                body: '{id:"' + campres[0].myip + '", nnid: "' + nnid + '"}'
                                            };
                                            request(options, (error, response) => {
                                                if (!error) {
                                                    try {
                                                        let data = JSON.parse(response.body);
                                                        if (data.message == "Success") {
                                                            //Counting Decrease (-1) and status update
                                                            /* let obj1 = new ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "UPDATE `campaign` SET `did_count`=`did_count` - 1 WHERE " + resp1.condition + " AND campaign_key = '" + result_camp[0].campaign_key + "'";
                                                            obj1.prepare();
                                                            obj1.execute((err, updt_didby) => {
                                                            }); */
                                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj2.nonqrysql = "UPDATE `did_buy` SET `osr_status` = 'unregister' WHERE `account_id` = '" + this.sessdata.idaccount + "' AND `did`='" + number + "'";
                                                            obj2.prepare();
                                                            obj2.execute((uperr, updt_stts) => {
                                                            });
                                                            // here in this query we are using session iduser and id account for the understanding who is performed this action.
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'10','DID disconnected successfully','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                            obj4.prepare();
                                                            obj4.execute((er, ins_result) => {
                                                                console.log("SMS Disabled Successfully From OSR");
                                                            });
                                                            let obj5 = new RawView_1.RawView(res);
                                                            obj5.prepare({ status: 201, message: "SMS facility has been successfully disabled." });
                                                            obj5.execute();
                                                        }
                                                        else {
                                                            let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj6.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'17','DID disconnect failed','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                            obj6.prepare();
                                                            obj6.execute((er, ins_result) => {
                                                                console.log("SMS is not Disabled From OSR");
                                                            });
                                                            console.log({ status: 400, message: "SMS Disabled failed. Please try again." });
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({ status: data.response_code, message: data.message, result: data });
                                                            obj.execute();
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("Error :: Osr->deleteNumber::", e);
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                        obj.execute();
                                                    }
                                                }
                                                else {
                                                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj7.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'17','DID disconnect failed','" + sdata.DID.trim() + "','" + result_camp[0].campaign_key + "')";
                                                    obj7.prepare();
                                                    obj7.execute((er, ins_result) => {
                                                        console.log("SMS is not Disabled From OSR");
                                                    });
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ status: 400, message: "SMS Disabled failed. Please try again." });
                                                    obj.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 404, message: "SMS Provider does Not Exist!" });
                                            objv.execute();
                                        }
                                    });
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, message: 'Cannot find ImportedNumber' });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: resp1.status,
                            message: resp1.message.replace(/::MG::/g, "Disable SMS Facility!")
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: 'DID Detail Not Available!' });
                objv.execute();
            }
        });
    }
    /**
     * To retrieve entry from OSR :: first method
     */
    retrieveOsrEntry(req, res, callback) {
        let sdata = req.query;
        let did = sdata.DID.trim();
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        let number1 = "1" + number;
        let options = {
            'method': 'GET',
            // 'url': produrl + "" + number1 + "?id=" + myip,
            'url': getOsrRecords.OsrProdurl + "" + number1 + "?id=" + getOsrRecords.OsrMyip,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    if (data.message == "Success") {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: 200, message: "OSR Details Find Successfully", result: data });
                        obj.execute();
                    }
                    else {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ status: data.response_code, message: data.message, result: data });
                        obj.execute();
                    }
                }
                catch (e) {
                    console.log("Error :: Osr->retrieveOsrEntry::", e);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawView_1.RawView(res);
                obj.prepare({ status: 400, result: error });
                obj.execute();
            }
        });
    }
    /**
     * To retrieve notification from OSR :: first method
     */
    retrieveOsrNotifications(req, res, callback) {
        let sdata = req.query;
        let options = {
            'method': 'GET',
            // 'url': "http://65.214.42.91:84/osr/v2/notifications?id=" + myip + "&tid=" + sdata.TID,
            'url': getOsrRecords.OsrNotification + getOsrRecords.OsrMyip + "&tid=" + sdata.TID,
            'headers': {
                'Content-Type': 'application/json'
            }
        };
        console.log("options", options);
        request(options, (error, response) => {
            if (!error) {
                try {
                    let data = JSON.parse(response.body);
                    console.log("Data", data);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ status: 200, message: "OSR Details Find Successfully", result: data });
                    obj.execute();
                }
                catch (e) {
                    console.log("Error :: Osr->retrieveOsrNotifications::", e);
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            }
            else {
                let obj = new RawView_1.RawView(res);
                obj.prepare({ status: 400, result: error });
                obj.execute();
            }
        });
    }
    /**
     * To Delete entry from OSR :: second method
     */
    deleteNumberM2(req, res, payLoad, callback) {
        let checkMasterAc = new APIBase_1.APIBase();
        checkMasterAc.getMasterSlave(req, res, this.sessdata, this.sessdata.idaccount, 2, (err, resp1) => {
            if (resp1.status == 200) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT campaign_key, did_count, did_limit, campaign_name, upstreamCnpId,provisioning_status FROM campaign WHERE `campaign_key` = '" + payLoad.campaign + "' AND " + resp1.condition + " GROUP BY campaign_key";
                obj1.prepare();
                obj1.execute((error, camp_res) => {
                    console.log("Campaign Data >:::::::", camp_res);
                    if (error == 1 && camp_res.length > 0 && camp_res[0].provisioning_status == 3) {
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `myip`, `nnid`, nnid2, `sms_provider` FROM `osr_nnid` WHERE `sms_provider`='" + camp_res[0].upstreamCnpId + "'";
                        obj0.prepare();
                        obj0.execute((camperr, campres) => {
                            if (camperr == 1 && campres.length > 0) {
                                let did = payLoad.DID;
                                let len = did.length - 10;
                                let number = did.slice(len, did.length);
                                let number1 = "+1" + number;
                                let nnid = payLoad.did_sub_type == 1 && payLoad.type == 'NN' ? campres[0].nnid2 : campres[0].nnid;
                                let options = {
                                    'method': 'DELETE',
                                    // 'url': produrl + "" + `${number1}`,
                                    'url': getOsrRecords.OsrProdurl + "" + `${number1}`,
                                    'headers': {
                                        'Content-Type': 'application/json'
                                    },
                                    // body: '{id:"' + myip + '", nnid: "' + nnid + '"}'
                                    body: '{id:"' + getOsrRecords.OsrMyip + '", nnid: "' + nnid + '"}'
                                };
                                request(options, (error, response) => {
                                    if (!error) {
                                        try {
                                            let data = JSON.parse(response.body);
                                            if (data.message == "Success") {
                                                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj0.qrysql = "SELECT `camp_registry` FROM `did_buy` WHERE `did`='" + number + "' AND `account_id` = '" + this.sessdata.idaccount + "'";
                                                obj0.prepare();
                                                obj0.execute((_err, result_did) => {
                                                    if (_err == 1 && result_did.length > 0) {
                                                        let checkMasterAc = new APIBase_1.APIBase();
                                                        checkMasterAc.getMasterSlave(req, res, this.sessdata, this.sessdata.iduser, 22, (err, resp1) => {
                                                            if (resp1.status == 200) {
                                                                let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                                                                obj00.qrysql = "SELECT `did_count`, `did_limit`, campaign_key, campaign_name FROM `campaign` WHERE " + resp1.condition + " AND `campaign_key`='" + result_did[0].camp_registry + "' GROUP BY campaign_key";
                                                                obj00.prepare();
                                                                obj00.execute((__err, result_camp) => {
                                                                    if (__err == 1 && result_camp.length > 0) {
                                                                        /* let obj1 = new ModelRawNonQuery(req, res);
                                                                        obj1.nonqrysql = "UPDATE `campaign` SET did_count=`did_count` - 1 WHERE " + resp1.condition + " AND campaign_key = '" + result_camp[0].campaign_key + "'";
                                                                        obj1.prepare();
                                                                        obj1.execute((___err, updt_didby) => {
                                                                            if (___err == 1) {
                                                                                console.log("Counting Updated.");
                                                                            }
                                                                            else {
                                                                                console.log("Counting Not Updated!");
                                                                            }
                                                                        }); */
                                                                        /* let obj2 = new ModelRawNonQuery(req, res);
                                                                        obj2.nonqrysql = "UPDATE `did_buy` SET `camp_registry` = '' WHERE `account_id`='" + this.sessdata.idaccount + "' AND `did`='" + number + "';";
                                                                        obj2.prepare();
                                                                        obj2.execute((err, resp) => {
                                                                        }) */
                                                                    }
                                                                    else {
                                                                        console.log("Campaign Data Not Found.");
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                console.log(resp1.message.replace(/::MG::/g, "Disconnect Number Facility!"));
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Campaign Registry Not Found.");
                                                    }
                                                });
                                                let objn = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objn.nonqrysql = "INSERT INTO `did_log` (`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`,`campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'10','DID Unprovisioned','" + number + "', '" + payLoad.campaign + "')";
                                                objn.prepare();
                                                objn.execute((errorDiDLg, resDiDLg) => { });
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `did_buy` SET `osr_status`='unregister', `disconnect_did_status`='4' WHERE `account_id`='" + this.sessdata.idaccount + "' AND `did`='" + number + "';";
                                                obj.prepare();
                                                obj.execute((err, resp) => {
                                                    if (err == 1) {
                                                        callback(1, resp);
                                                    }
                                                    else {
                                                        callback(0, err);
                                                    }
                                                });
                                            }
                                            else {
                                                let objn = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                objn.nonqrysql = "INSERT INTO `did_log`(`account_id`,`iduser`,`updated_at`,`event_type`,`description`,`did`, `campaign_key`) VALUE('" + this.sessdata.idaccount + "','" + this.sessdata.iduser + "',NOW(),'17','DID disconnected successfully','" + number + "', '" + payLoad.campaign + "')";
                                                objn.prepare();
                                                objn.execute((errorDiDLg, resDiDLg) => { });
                                                callback(0, data);
                                            }
                                        }
                                        catch (e) {
                                            console.log("Error :: Osr->deleteNumberM2::", e);
                                            callback(0, error);
                                        }
                                    }
                                    else {
                                        callback(0, error);
                                    }
                                });
                            }
                            else {
                                // let objv = new RawView(res);
                                // objv.prepare({ status: 404, message: "SMS Provider does Not Exist!" });
                                // objv.execute();
                                callback(1, '');
                            }
                        });
                    }
                    else {
                        // let objv = new RawView(res);
                        // objv.prepare({ status: 404, message: "This Campaign is not approved yet or not available in our entity. Please try with another one!" });
                        // objv.execute();
                        callback(1, '');
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    status: resp1.status,
                    message: resp1.message.replace(/::MG::/g, "Disconnect Number")
                });
                objv.execute();
            }
        });
    }
}
exports.OsrApi = OsrApi;
