"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setEnum = exports.setToZero = exports.parseBody = exports.ipAddressAndBrowser = exports.isNumber = void 0;
const Str = require('@supercharge/strings');
const jwt = require('jsonwebtoken');
const { networkInterfaces } = require('os');
/* const rateLimit = require('express-rate-limit');


const userRateLimiter = rateLimit({
    windowMs:  1 * 60 * 1000, // 15 minutes
    max: 1, // Limit each user to 5 requests per windowMs
    keyGenerator: (req:any) => req.uniqueuserid.id, // Use user ID as the key
    handler: (req:any, res:any) => {
        let objv = new RawView(res);
        objv.prepare({ status: 429, message: 'Too Many Requests. You have exceeded the request limit. Please try again later.' });
        objv.execute();
    }
}); */
// const checkDesc = (desc: any) => {
//     let result: any = '';
//     if (desc) {
//         result = desc.replace(/"/g, '\\"').replace(/'/g, "\\'");
//         return result;
//     } else {
//         result = '';
//         return result;
//     }
// }
const parseBody = (desc) => {
    let result = '';
    if (desc) {
        result = desc
            .replace(/\\/g, '\\\\')
            .replace(/"/g, '\\"')
            .replace(/'/g, "\\'");
    }
    return result;
};
exports.parseBody = parseBody;
const setToZero = (data) => {
    let description = data ?? '';
    let dest = Number(description);
    if (dest == '') {
        return 0;
    }
    else {
        return data;
    }
};
exports.setToZero = setToZero;
const setEnum = (data) => {
    if (data === null || data === undefined || data === '') {
        return false;
    }
    return data;
};
exports.setEnum = setEnum;
const isNumber = (num) => {
    let result = '';
    let number = num ? num : 0;
    if (isNaN(number) == false && typeof parseInt(number) == "number") {
        result = number;
        console.log("result :: ", result);
        return result;
    }
    else {
        result = 'NaN';
        console.log("result :: ", result);
        return result;
    }
};
exports.isNumber = isNumber;
const ipAddressAndBrowser = (req) => {
    /* login history Create  Token */
    let secret = Str.random(15);
    let Token = jwt.sign({
        exp: Math.floor(Date.now() / 1000),
    }, secret);
    //To Get ipaddress
    const nets = networkInterfaces();
    const ipAddress = [];
    for (const name of Object.keys(nets)) {
        for (const net of nets[name]) {
            const familyV4Value = typeof net.family === 'string' ? 'IPv4' : 4;
            if (net.family === familyV4Value && !net.internal) {
                ipAddress.push(net.address);
            }
        }
    }
    /*To Get Browser Name */
    const userAgentString = req.headers['user-agent'];
    const userAgent = userAgentString;
    let browserName = 'unknown';
    if (userAgent?.includes('Safari')) {
        browserName = 'Safari';
    }
    if (userAgent?.includes('Chrome')) {
        browserName = 'Google Chrome';
    }
    if (userAgent?.includes('Edg')) {
        browserName = 'Microsoft Edge';
    }
    if (userAgent?.includes('OPR')) {
        browserName = 'Opera';
    }
    if (userAgent?.includes('msie')) {
        browserName = 'Internet Explorer';
    }
    if (userAgent?.includes('Firefox')) {
        browserName = 'Firefox';
    }
    let sysInfo = {
        ipAddress: [req.headers['x-forwarded-for'] || req.socket.remoteAddress],
        browserName: browserName, uniqueToken: Token
    };
    return sysInfo;
};
exports.ipAddressAndBrowser = ipAddressAndBrowser;
//export default checkDesc
exports.default = parseBody;
