"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelRawNonQuery = void 0;
const ModelObject_1 = require("./ModelObject");
class ModelRawNonQuery extends ModelObject_1.ModelObject {
    prepare() {
        var ret = true;
        if (this.req.query.hasOwnProperty('filter')) {
            if (this._isfilter) {
                let v = this.req.query.filter;
                let tmp = JSON.parse(v);
                this.nonquery.filter = Object.assign(tmp, this._filter);
                this.nonquery.isfilter = true;
            }
            else {
                let v = this.req.query.filter;
                let tmp = JSON.parse(v);
                this.nonquery.filter = JSON.parse(tmp);
                this.nonquery.isfilter = true;
            }
        }
        else {
            if (this.req.query.hasOwnProperty('id')) {
                if (this._isfilter) {
                    this.nonquery.filter = Object.assign({ id: this.req.query.id }, this._filter);
                    this.nonquery.isfilter = true;
                }
                else {
                    this.nonquery.filter = { id: this.req.query.id };
                    this.nonquery.isfilter = true;
                }
            }
            else {
                if (this._isfilter) {
                    this.nonquery.filter = this._filter;
                    this.nonquery.isfilter = true;
                }
            }
        }
        this.nonquery.raw_prepare();
        return ret;
    }
    execute(callback) {
        this.nonquery.Raw_Execute(function (err, data) {
            callback(err, data);
        });
    }
}
exports.ModelRawNonQuery = ModelRawNonQuery;
