"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TierManagement = void 0;
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
const ModelPdfUpload_1 = require("../lib/model/ModelPdfUpload");
// import { AppRoute } from "../lib/AppRoute";
const markError_1 = require("./markError");
class TierManagement {
    constructor() {
        // super();
    }
    // get Tariffs
    getTraiffs(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    // Get Tariff Via Type
    // get Tariffs
    getTypesTraiffs(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where `idaccount` = '" + sessdata.idaccount + "' AND `type`= '" + req.query.type + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    // get Tariffs
    getTraiff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where `idtariff` = '" + req.query.type + "' ";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: allcamp, message: "Data Fetched Succesfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    saveTariff(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where name = '" + (0, markError_1.parseBody)(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error, getTariff) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Tariff Already Exists!", status: 409
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.filter = null;
                        // obj2.qrysql = "INSERT into tariff (`idaccount`,`name`, `description`, `type`) VALUES('"+sessdata.idaccount+"', '" + rdata.name + "', '" + rdata.description + "', '"+rdata.type+"')";
                        obj2.qrysql = "Call AddTariff(" + sessdata.idaccount + ", 'Registered', '" + (0, markError_1.parseBody)(rdata.name) + "', '" + (0, markError_1.parseBody)(rdata.description) + "', " + (0, markError_1.setToZero)(rdata.day_num) + ")";
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: allcamp[0], message: "Tariff Saved Successfully", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                        // });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    copyTariff(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where name = '" + (0, markError_1.parseBody)(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error, getTariff) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 504, message: "Tariff Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.filter = null;
                        obj2.qrysql = "Call AddTariff(" + sessdata.idaccount + ", 'Registered', '" + (0, markError_1.parseBody)(rdata.name) + "', '" + (0, markError_1.parseBody)(rdata.description) + "', " + (0, markError_1.setToZero)(rdata.day_num) + ")";
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            // Copy TARIFF
                            if (allcamp.length > 0 && rdata.id) {
                                let IDtar = allcamp[0][0].idtariff;
                                // voice rate Table
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT idrates,idaccount,idtariff,type,subtype,rate,final_rate,mo,mt,code,state,city,category,description,priority,rateType,billing_type,billing_frequency,proration FROM `voice_rates` WHERE `idtariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                obj.prepare();
                                obj.execute((errors, data1) => {
                                    if (errors == 1 && data1.length > 0) {
                                        let result = {};
                                        result = data1;
                                        result.forEach((element) => {
                                            let updatedPrice = element.rate;
                                            switch (element.billing_frequency) {
                                                case '0':
                                                    updatedPrice = element.rate * 1;
                                                    break;
                                                case '1':
                                                    updatedPrice = element.rate * 3;
                                                    break;
                                                case '2':
                                                    updatedPrice = element.rate * 6;
                                                    break;
                                                case '3':
                                                    updatedPrice = element.rate * 12;
                                                    break;
                                                default:
                                                    break;
                                            }
                                            let proration = element.proration && element.proration !== undefined ? element.proration : false;
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "UPDATE `voice_rates` SET `rate`='" + (0, markError_1.setToZero)(element.rate) + "', `mo` = '" + (0, markError_1.setToZero)(element.mo) + "', `mt` = '" + (0, markError_1.setToZero)(element.mt) + "', `billing_frequency` = " + (0, markError_1.setToZero)(element.billing_frequency) + " , `proration` = '" + proration + "', `final_rate` = " + (0, markError_1.setToZero)(updatedPrice) + " WHERE `idtariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `subtype` = '" + element.subtype + "' AND `category` = '" + element.category + "'";
                                            obj3.prepare();
                                            obj3.execute((eror, voiceRate) => {
                                                console.log("Voice Rate Updated Found");
                                            });
                                        });
                                    }
                                    else {
                                        console.log("Voice Rate Not Found");
                                    }
                                });
                                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT `day_num`,`proration` FROM `tariff` WHERE `idtariff`=" + rdata.id + "";
                                obj2.prepare();
                                obj2.execute((error1, DayNUM) => {
                                    if (error1 == 1 && DayNUM.length > 0) {
                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `tariff` SET `day_num`=" + (0, markError_1.setToZero)(DayNUM[0].day_num) + ",`proration`='" + DayNUM[0].proration + "' WHERE `idtariff` = " + IDtar + "";
                                        obj2.prepare();
                                        obj2.execute((error2, uDayNUM) => {
                                            console.log("Proration Updated");
                                        });
                                    }
                                    else {
                                        console.log("Proration not Updated");
                                    }
                                });
                                // sms rates table
                                let objs = new RawQuery_1.ModelRawQuery(req, res);
                                objs.qrysql = "SELECT idsmsrate,id_tariff,idaccount,category,categoryvalue,subcategory,priority,type,MO_rates,MT_rates,code,state,city from `sms_rate` WHERE `id_tariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                objs.prepare();
                                objs.execute((error, data2) => {
                                    if (error == 1 && data2.length > 0) {
                                        let result2 = {};
                                        result2 = data2;
                                        result2.forEach((element) => {
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "UPDATE `sms_rate` SET `MO_rates`='" + (0, markError_1.setToZero)(element.MO_rates) + "', `MT_rates` = '" + (0, markError_1.setToZero)(element.MT_rates) + "' WHERE `id_tariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `category` = '" + element.category + "' AND `subcategory` = '" + element.subcategory + "'";
                                            obj4.prepare();
                                            obj4.execute((error, smsRate) => {
                                                console.log("SMS Rate Updated");
                                            });
                                        });
                                    }
                                    else {
                                        console.log("SMS Rate Not Found");
                                    }
                                });
                                let objkk = new RawQuery_1.ModelRawQuery(req, res);
                                objkk.qrysql = "SELECT idrates,idaccount,iduser,idtariff,type,rate,category,description,priority FROM `lookup_api_rates` WHERE `idtariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                objkk.prepare();
                                objkk.execute((errors, look_res) => {
                                    if (errors == 1 && look_res.length > 0) {
                                        let result2 = {};
                                        result2 = look_res;
                                        result2.forEach((element) => {
                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj4.nonqrysql = "UPDATE `lookup_api_rates` SET `rate`='" + (0, markError_1.setToZero)(element.rate) + "' WHERE `idtariff` = '" + IDtar + "' AND `type` = '" + element.type + "' AND `category` = '" + element.category + "'";
                                            obj4.prepare();
                                            obj4.execute((error, smsRate) => {
                                                console.log("Lookups API Rate updated");
                                            });
                                        });
                                    }
                                    else {
                                        console.log("Lookups API Rate Not Found");
                                    }
                                });
                                // msg activation price
                                let obj10 = new RawQuery_1.ModelRawQuery(req, res);
                                obj10.qrysql = "SELECT `idrates`,`idaccount`,`iduser`,`idtariff`,`type`,`mrc`,`nrc`,`category`,`priority` FROM `message_activation_pricing` WHERE `idtariff` = " + rdata.id + " ORDER BY `priority` ASC";
                                obj10.prepare();
                                obj10.execute((errors, msgPrices) => {
                                    if (errors == 1 && msgPrices.length > 0) {
                                        let result4 = {};
                                        result4 = msgPrices;
                                        result4.forEach((element) => {
                                            let obj04 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj04.nonqrysql = "UPDATE `message_activation_pricing` SET `mrc`='" + (0, markError_1.setToZero)(element.mrc) + "',`nrc`= '" + (0, markError_1.setToZero)(element.nrc) + "' WHERE `idtariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `category` = '" + element.category + "'";
                                            obj04.prepare();
                                            obj04.execute((error, upmsgRes) => {
                                                console.log("Message Activation Pricing Inserted Successfully");
                                            });
                                        });
                                    }
                                    else {
                                        console.log("Message Activation Rate Not Found");
                                    }
                                });
                                let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                                obj00.qrysql = "SELECT campaign_rate_id,idaccount,iduser,idtariff,type,rate,category,priority,mrc FROM `campaign_rates` WHERE `idtariff` = '" + rdata.id + "' ORDER BY `priority` ASC";
                                obj00.prepare();
                                obj00.execute((errors, Campres) => {
                                    if (errors == 1 && Campres.length > 0) {
                                        let result3 = {};
                                        result3 = Campres;
                                        result3.forEach((element) => {
                                            let obj04 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj04.nonqrysql = "UPDATE `campaign_rates` SET `rate`=" + (0, markError_1.setToZero)(element.rate) + ",`mrc`=" + (0, markError_1.setToZero)(element.mrc) + " WHERE `idtariff` = " + IDtar + " AND `type` = '" + element.type + "' AND `category` = '" + element.category + "'";
                                            obj04.prepare();
                                            obj04.execute((error, upCampRes) => {
                                                console.log("Campaign Rates Inserted");
                                            });
                                        });
                                    }
                                    else {
                                        console.log("Campaign Rates Not Found");
                                    }
                                });
                                let obj1 = new RawView_1.RawView(res);
                                obj1.prepare({ data: allcamp[0], message: "Tariff Copied Successfully", status: 201 });
                                obj1.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Copy Tariff!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    updateTariff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let sdata = [];
                sdata = req.body.data;
                obj.nonqrysql = "UPDATE tariff SET name='" + (0, markError_1.parseBody)(sdata.name) + "', description='" + (0, markError_1.parseBody)(sdata.description) + "' WHERE idtariff = " + sdata.id + "";
                obj.prepare();
                obj.execute((_error, allcamp) => {
                    if (_error == 1) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "Select idtariff,idaccount,name,description,type,day_num,proration from tariff where idaccount = " + sessdata.idaccount + "";
                        obj1.prepare();
                        obj1.execute((__error, resResult) => {
                            if (__error == 1) {
                                let objv2 = new RawView_1.RawView(res);
                                objv2.prepare({ message: "Rate Plan Update Successfully!", data: resResult, status: 201 });
                                objv2.execute();
                            }
                            else {
                                let objv2 = new RawView_1.RawView(res);
                                objv2.prepare({ message: "Rate Plan Updated Connection break with fetch data!", data: resResult, status: 502 });
                                objv2.execute();
                            }
                        });
                    }
                    else {
                        let objv2 = new RawView_1.RawView(res);
                        objv2.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv2.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    deleteTariff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from tariff WHERE idtariff = " + req.query.id + "";
            obj.prepare();
            obj.execute((_error, lastid) => {
                if (_error == 10) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Tariff is already mapped to some accounts!", status: 401 });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Tariff Deleted Successfully", data: lastid[0], status: 201 });
                    objv.execute();
                }
            });
        });
    }
    // Save Tariff 
    saveSurcharge(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idsurcharge,idaccount,name,description FROM surcharge where name = '" + (0, markError_1.parseBody)(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error, getTariff) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Surcharge Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.filter = null;
                        obj2.nonqrysql = "INSERT into surcharge (`idaccount`,`name`, `description`) VALUES (" + sessdata.idaccount + ", '" + (0, markError_1.parseBody)(rdata.name) + "', '" + (0, markError_1.parseBody)(rdata.description) + "')";
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: allcamp, message: "Surcharge Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    updateSurcharge(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, session) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let Qry = '';
                for (let key of Object.keys(rdata)) {
                    let num = [];
                    num = key.match(/[\d\.]+/g);
                    let index = num.length;
                    let idoperator = num[index - 1];
                    // let idoperator = num.at(-1);
                    /*
                    If you will request some data other than priority and rates from angular side, then you will have to change this below condition.
                    */
                    if (key !== 'priority_' + idoperator) {
                        if (key !== 'idoperator_' + idoperator) {
                            // console.log("keykey",key);
                            let type = key.split('_')[0];
                            let subtype = key.split('_')[1];
                            let direction = key.split('_')[2];
                            Qry += "UPDATE `surcharge_rates` SET `rates`=" + (0, markError_1.setToZero)(rdata[key]) + " WHERE `idoperator`= " + (0, markError_1.setToZero)(idoperator) + " AND `type`= '" + type + "' AND `subtype`= '" + subtype + "' AND `direction`= '" + direction + "';\n";
                        }
                    }
                }
                if (Qry) {
                    let objk = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    objk.nonqrysql = Qry;
                    objk.prepare();
                    objk.execute((error, data) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Surcharge Updated Successfully!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Surcharge Not Updated Successfully!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Surcharge Not Updated!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "You Are Not Authorized!", status: 504 });
                objv.execute();
            }
        });
    }
    editSurcharge(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, session) => {
            if (error == 1) {
                let rdata = req.body.data;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `surcharge` SET `name`='" + (0, markError_1.parseBody)(rdata.name) + "', `description`='" + (0, markError_1.parseBody)(rdata.description) + "' WHERE `idsurcharge`= " + rdata.idsurcharge + "";
                obj.prepare();
                obj.execute((error, data) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Surcharge Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Surcharge Not Updated Successfully!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    updateTariffDay(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj2.nonqrysql = "UPDATE `tariff` SET `day_num`=" + (0, markError_1.setToZero)(rdata.day_num) + " WHERE `idtariff` = " + rdata.idtariff + "";
                obj2.prepare();
                obj2.execute((errorr, allcamp) => {
                    if (errorr == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 201, message: "(" + rdata.day_num + ") Days Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Days Not Updated!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateProRate(req, res, next) {
        let spdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                if (spdata.proration === "true" || spdata.proration === "false") {
                    obj2.nonqrysql = "UPDATE `tariff` SET `proration`='" + spdata.proration + "' WHERE `idtariff` = " + spdata.idtariff + "";
                    obj2.prepare();
                    obj2.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Proration Successfully Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Prorate!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Pro-rate!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    updateProration(req, res, next) {
        let prorateData = req.body.data;
        console.log(prorateData, "proration data");
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (prorateData.proration === "true" || prorateData.proration === "false") {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `voice_rates` SET `proration`='" + prorateData.proration + "' WHERE `idtariff` = " + prorateData.idtariff + " AND `category` = '" + prorateData.category + "'";
                    obj2.prepare();
                    obj2.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Proration Successfully Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Prorate!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Pro-rate!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    // Save Service Profile
    saveServiceProfile(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idservice,iduser,name,description,is_default FROM service where name = '" + (0, markError_1.parseBody)(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error, getTariff) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Service Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.filter = null;
                        obj2.nonqrysql = "INSERT into `service` (`iduser`,`name`, `description`) VALUES (" + sessdata.iduser + ", '" + (0, markError_1.parseBody)(rdata.name) + "', '" + (0, markError_1.parseBody)(rdata.description) + "')";
                        obj2.prepare();
                        obj2.execute((_error, allcamp) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: allcamp, message: "Service Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    savePreference(req, res, next) {
        let sdata = {};
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                rdata = JSON.parse(req.body.data);
                let tmpqurty = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `description`, `type`) VALUES  ";
                rdata.forEach((element) => {
                    tmpqurty += "('" + sessdata.idaccount + "', '" + (0, markError_1.setToZero)(element.idservice) + "', '" + (0, markError_1.setToZero)(element.idsupplier) + "','" + (0, markError_1.setToZero)(element.priority) + "','" + 'Description' + "', '" + (0, markError_1.parseBody)(element.type) + "'),";
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Preference Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    updatePreference(req, res, next) {
        let sdata = {};
        sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                sdata.forEach((result) => {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `type`, `key`) VALUE ('" + sessdata.idaccount + "','" + (0, markError_1.setToZero)(result.idservice) + "', '" + result.idsupplier + "','" + (0, markError_1.setToZero)(result.priority) + "', '" + (0, markError_1.parseBody)(result.type) + "', '" + sessdata.idaccount + "-" + (0, markError_1.setToZero)(result.idservice) + "-" + (0, markError_1.parseBody)(result.type) + "-" + (0, markError_1.setToZero)(result.priority) + "' ) ON DUPLICATE KEY UPDATE `idservice`='" + (0, markError_1.setToZero)(result.idservice) + "', `idsupplier`='" + (0, markError_1.setToZero)(result.idsupplier) + "',`priority`='" + (0, markError_1.setToZero)(result.priority) + "', `key`='" + sessdata.idaccount + "-" + (0, markError_1.setToZero)(result.idservice) + "-" + (0, markError_1.parseBody)(result.type) + "-" + (0, markError_1.setToZero)(result.priority) + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Preference Update Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getPreference(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idpreference`, `key`, `idaccount`, `idservice`, `idsupplier`, `priority`, `type`, `created`, `description` FROM `preference` WHERE `type` = '" + sdata.type + "' AND `idservice`='" + sdata.idservice + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }
    updatePreferenceService(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            let sdata = [];
            sdata = req.body.data;
            obj.nonqrysql = "UPDATE service SET name='" + (0, markError_1.parseBody)(sdata.name) + "', description='" + (0, markError_1.parseBody)(sdata.description) + "' WHERE idservice = '" + sdata.idservice + "'";
            obj.prepare();
            obj.execute((_error, allcamp) => {
                if (allcamp) {
                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                    obj1.qrysql = "select idservice,iduser,name,description,is_default from service where iduser = '" + sessdata.iduser + "'";
                    obj1.prepare();
                    obj1.execute((_error, resResult) => {
                        let objv2 = new RawView_1.RawView(res);
                        objv2.prepare({ message: "Service Profile Update Successfully!", data: resResult });
                        objv2.execute();
                    });
                }
                else {
                    let objv2 = new RawView_1.RawView(res);
                    objv2.prepare({ message: "Something Went Wrong!" });
                    objv2.execute();
                }
            });
        });
    }
    getServiceProfiles(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idservice,iduser,name,description,is_default FROM `service` WHERE `iduser`='" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }
    getServiceProfile(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idservice,iduser,name,description,is_default FROM `service` WHERE `idservice`='" + sdata.idservice + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }
    setDefaultService(req, res, next) {
        let sdata = req.body;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj1.nonqrysql = "UPDATE `service` SET `is_default`='false' WHERE `iduser`='" + sdata.data.split('-')[1] + "'";
                obj1.prepare();
                obj1.execute((_error, result) => {
                    if (_error == 1) {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `service` SET `is_default`='true' WHERE `iduser`='" + sdata.data.split('-')[1] + "' AND `idservice`='" + sdata.data.split('-')[0] + "'";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Default Preference Service Changed Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong With Preference Service", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    deletePreferenceService(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from `service` WHERE `idservice` = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error, lastid) => {
                if (_error == 10) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Profile Deleted Successfully", data: lastid[0] });
                    objv.execute();
                }
            });
        });
    }
    // get Surcharge
    getSurcharges(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idsurcharge, idaccount, name, description FROM `surcharge` where `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    if (_error == 1 && allcamp.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: allcamp,
                            message: "Data Fetched Succesfully.",
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: allcamp,
                            message: "No Data Available!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    getTariffList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff";
                obj.prepare();
                obj.execute((error, data) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Tariff Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    getSingleTraiff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        let trfid = req.query.type;
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idtariff,idaccount,name,description,type,day_num,proration FROM tariff where `idtariff` = " + trfid + " AND `idaccount` = " + sessdata.idaccount + "";
                obj2.prepare();
                obj2.execute((_error, allcamp) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    deleteSurcharge(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from surcharge WHERE idsurcharge = " + req.query.id + "";
            obj.prepare();
            obj.execute((_error, lastid) => {
                if (_error == 10) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Surcharge is already mapped to some Tariff!", status: 200 });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Surcharge Deleted Successfully", data: lastid[0] });
                    objv.execute();
                }
            });
        });
    }
    // public SaveRate(req: Request, res: Response, next: NextFunction) {
    //     console.log("Data===>"+req.body.data);
    //     console.log("req.query", req.query);
    //     let sdata: any;
    //     try {
    //         sdata = req.body.data;
    //     } catch (e) {
    //         sdata =  req.body.data;
    //     }
    //     console.log(sdata);
    //     let session = new SessionManagment(req, res, next);
    //     let msg = "";
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "CALL AddBilling('" + sessdata.iduser + "', '"+sdata+"', '20')";
    //             obj.prepare();
    //             obj.execute((error: any, result: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: result[0], message: msg });
    //                 objv.execute();
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    SaveRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error, sessdata) => {
            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
            var result = [];
            obj2.filter = null;
            let rdata = req.body.data;
            rdata.forEach((element) => {
                element.forEach((ele) => {
                    result[ele.field] = ele.value;
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `billing_rate` (`id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc`) VALUES(" + (0, markError_1.setToZero)(result.idtariff) + ", " + (0, markError_1.setToZero)(result.idpriority) + " , '" + (0, markError_1.parseBody)(result.feature) + "', " + (0, markError_1.setToZero)(result.usage) + " ," + (0, markError_1.setToZero)(result.disconnect) + ", " + (0, markError_1.setToZero)(result.setup) + ", " + (0, markError_1.setToZero)(result.recurringmrc) + ", " + (0, markError_1.setToZero)(result.portinnrc) + ", " + (0, markError_1.setToZero)(result.portoutnrc) + ")";
                obj.prepare();
                obj.execute((error, data) => {
                });
            });
            let objv = new RawView_1.RawView(res);
            objv.prepare({ message: "Rate Saved Successfully!" });
            objv.execute();
        });
    }
    updateData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `billing_rate` SET `feature`='" + result.feature + "', `usage`='" + (0, markError_1.setToZero)(result.usage) + "', `disconnect`='" + (0, markError_1.setToZero)(result.disconnect) + "', `setup`='" + (0, markError_1.setToZero)(result.setup) + "', `recurring_mrc`='" + (0, markError_1.setToZero)(result.recurringmrc) + "', `port_in_nrc`='" + (0, markError_1.setToZero)(result.portinnrc) + "', `port_out_nrc`='" + (0, markError_1.setToZero)(result.portoutnrc) + "' WHERE `idbilling_rate`= '" + result.idbillingrate + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    UploadCSV(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let sdata = {};
        let session = new Session_1.SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var sdata = req.body;
                let objfile = new ModelPdfUpload_1.ModelPdfUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let tier_csv = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'");
                obj.nonqrysql = "INSERT INTO `upload` (`FileName`,`DestinationPath`,`FileType`,`UserID`)	VALUES ('" + tier_csv + "', '" + req.file.destination + "', '" + req.body.filetype + "','" + req.body.sessionid + "')";
                obj.prepare();
                obj.execute((error, lastid) => {
                    let objv = new RawView_1.RawView(res);
                    let filepath = req.file.destination + tier_csv;
                    objv.prepare({ message: "Rate CSV Uploaded Successfully.", insertedid: lastid.insertId, filename: filepath });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getTierFeature(req, res, next) {
        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
        obj2.qrysql = "SELECT idinbound_rates, feature FROM billing_feature";
        obj2.prepare();
        obj2.execute((error, allcamp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                error: 0,
                data: allcamp,
                message: "Data Fetched Successfully"
            });
            objv.execute();
        });
    }
    getBillingRatename(req, res, next) {
        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            obj2.qrysql = "SELECT idbilling_ratename,idtariff,name FROM billing_ratename";
            obj2.prepare();
            obj2.execute((error, allcamp) => {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error: 0,
                    data: allcamp,
                    message: "Data Fetched Succesfully"
                });
                objv.execute();
            });
        });
    }
    getBillingRate(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select `idbilling_rate`, `id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc` from `billing_rate` where `id_tariff` = '" + req.query.type + "' ORDER BY `idinbound_rates` ASC";
                obj.prepare();
                obj.execute((error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result, message: msg });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // public USA_SMS_Rates(req: Request, res: Response, next: NextFunction) {
    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES('"+sessdata.idaccount+"', '"+result.idtariff+"', '"+result.priority+"' ,'"+result.category+"', '"+result.MO+"', '"+result.MT+"', '"+result.subCategory+"', '"+result.categoryValue+"')";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //              });
    //         });
    //         let objv = new RawView(res);
    //         objv.prepare({ message: "Rate Saved Successfully!" });
    //         objv.execute();
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    Add10DLCA2P(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `10DLC_A2P_surcharge` (`idaccount`, `id_tariff`, `priority` ,`category`, `a`, `b`, `c`, `d`, `e`, `inbound_A2P_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "','" + result.category + "', '" + result.a + "', '" + result.b + "', '" + result.c + "', '" + result.d + "', '" + result.e + "', '" + result.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    TollFreeA2p(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `surcharge_rates` (`idaccount`, `id_tariff`, `type` ,`operator`, `direction`, `sms1`, `sms2`, `mms1`, `mms2`,`a`,`b`,`c`,`d`,`e`,`Inbound_a2p_surcharge`) VALUES('" + sessdata.idaccount + "', '" + element.idtariff + "', '" + element.type + "', '" + element.operator + "', '" + element.direction + "', '" + element.sms1 + "', '" + element.sms2 + "','" + element.sms1 + "', '" + element.sms2 + "', '" + element.a + "', '" + element.b + "','" + element.c + "','" + element.d + "','" + element.e + "', '" + element.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    ShortCodeRate(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `short_code_rates` (`idaccount`, `id_tariff`, `priority` ,`category`, `outbound_message_surcharge`, `inbound_message_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + (0, markError_1.setToZero)(result.priority) + "' ,'" + result.category + "', '" + (0, markError_1.setToZero)(result.outboundSurcharge) + "', '" + (0, markError_1.setToZero)(result.inboundSurcharge) + "')";
                    obj.prepare();
                    obj.execute((error, data) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    VoiceRates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = [];
                result = req.body.data;
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `voice_rates` (`idaccount`, `id_tariff`, `usa_rate`, `canada_rate`) VALUES('" + sessdata.idaccount + "', '" + result.id_tariff + "', '" + result.cvoicerate + "', '" + result.uvoicerate + "')";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Rate Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // Get rates 
    GetUSA_SMS_Rates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "select idsmsrate,id_tariff,idaccount,category,categoryvalue,subcategory,priority,type,MO_rates,MT_rates,code,state,city from `sms_rate` where `id_tariff` = " + req.query.idtariff + " AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetCampaignSur_Rates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select `displayName`,`rate`,`nrc_rates` from `campaign_cases`";
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetCoverage_Rates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `display_name`,`rate` FROM `sc_carrier_coverage`";
                    obj.prepare();
                    obj.execute((error, result) => {
                        if (error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Service Unavailable!", status: 503 });
                    objv.execute();
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    Get10DLCA2P(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select id_dlc_a2p,id_tariff,idaccount,priority,category,a,b,c,d,e,inbound_A2P_surcharge from `10DLC_A2P_surcharge` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetTollFreeA2p(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select id_tollfree,id_tariff,idaccount,priority,category,a,b,c,d,e,inbound_A2P_surcharge from `tollfree_a2p_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetShortCodeRate(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select idshort_code,id_tariff,idaccount,priority,category,outbound_message_surcharge,inbound_message_surcharge from `short_code_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    GetVoiceRates(req, res, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select `id_voicerate`, `id_tariff`, `usa_rate`, `canada_rate` from `voice_rates` where `id_tariff` = '" + req.query.type + "'";
                obj.prepare();
                obj.execute((error, data) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: data[0], message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // Update Rates
    update10DLCRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `10DLC_A2P_surcharge` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_dlc_a2p` = '" + result.iddlca2p + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateTollFreeRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `tollfree_a2p_rates` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_tollfree` = '" + result.idtollfree + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateSMSRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let idsrt;
                    if (result.idsmsratenew !== null) {
                        idsrt = result.idsmsratenew;
                    }
                    else {
                        idsrt = result.idsmsrate;
                    }
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `sms_rate` SET `MO_rates`=" + (0, markError_1.setToZero)(result.MO) + ", `MT_rates` = " + (0, markError_1.setToZero)(result.MT) + " WHERE `idsmsrate` = " + idsrt + "";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateShortCodeRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `short_code_rates` SET `outbound_message_surcharge`='" + (0, markError_1.setToZero)(result.outboundSurcharge) + "', `inbound_message_surcharge`='" + (0, markError_1.setToZero)(result.inboundSurcharge) + "' WHERE `idshort_code` = '" + result.idshortcode + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                    });
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateVoiceRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.nonqrysql = "update `voice_rates` SET `usa_rate`='" + rdata.uvoicerate + "', `canada_rate`='" + rdata.cvoicerate + "' where `id_voicerate` = '" + rdata.id_voicerate + "'";
                obj2.prepare();
                obj2.execute((error, allcamp) => {
                    if (allcamp) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            data: allcamp,
                            message: "Rates Updated successfully!"
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: error,
                            message: "Something went wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    // Unregistered Rates 
    addvoiceRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `mo`, `mt`, `category`) VALUES ";
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "(" + sessdata.idaccount + ", " + (0, markError_1.setToZero)(result.idtariff) + ", '" + result.priority + "', '" + result.type + "', '" + result.subtype + "', " + (0, markError_1.setToZero)(result.price) + ", " + (0, markError_1.setToZero)(result.mo) + "," + (0, markError_1.setToZero)(result.mt) + ", '" + result.category + "' ),";
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // addiVoiceApiRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // addDepthVoiceRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // addNumberRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // onSipRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.mo + "', '"+result.mt+"','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // sipNumberPrice(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate` , `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // onDepthVoiceRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"','" + result.mo + "', '" + result.mt + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    onSmsRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `type`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES ";
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "(" + sessdata.idaccount + ", " + (0, markError_1.setToZero)(result.idtariff) + ", '" + result.priority + "' ,'" + result.category + "', '" + result.type + "' ," + (0, markError_1.setToZero)(result.MO) + ", " + (0, markError_1.setToZero)(result.MT) + ", '" + result.subCategory + "', '" + result.categoryValue + "'),";
                });
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error, result) => {
                    if (result) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // numberActivationRates(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"','"+result.priority+"', '"+result.type+"', '"+result.subtype+"','" + result.price + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    //  Get Rates For Customers
    // subCustomerRates(req: Request, res: Response, next: NextFunction) {
    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawQuery(req, res);
    //             obj.qrysql = "select * from `voice_rates` where `idtariff` = '"+sessdata.idtariff+"' AND `type`='"+req.query.type+"' AND `subtype`='"+req.query.subtype+"' ORDER BY `priority` ASC";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
    //                 objv.execute();
    //              });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }
    // Get Single Unregistered rates
    voiceApiRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT idrates,idaccount,idtariff,type,subtype,rate,mo,mt,code,state,city,category,description,priority,rateType, billing_type , billing_frequency,proration, `final_rate` from `voice_rates` WHERE `idtariff` = " + req.query.idtariff + " AND `type`='" + req.query.type + "' AND `subtype`='" + req.query.subtype + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // Update Unregistered rates
    unregisteredRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let idrats = [];
                rdata.forEach((element) => {
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let prc = (result.price == null || result.price == undefined || result.price == '') ? 0 : result.price;
                    let updatedPrice = prc;
                    switch (result.billingfrequency) {
                        case '0':
                            updatedPrice = prc * 1;
                            break;
                        case '1':
                            updatedPrice = prc * 3;
                            break;
                        case '2':
                            updatedPrice = prc * 6;
                            break;
                        case '3':
                            updatedPrice = prc * 12;
                            break;
                        default:
                            break;
                    }
                    updatedPrice = parseFloat(updatedPrice ?? 0).toFixed(3);
                    let idrt;
                    if (result.idratesnew !== null) {
                        idrt = result.idratesnew;
                    }
                    else {
                        idrt = result.idrates;
                    }
                    if (result.idrates !== null) {
                        idrats.push(result.idrates);
                    }
                    let pr = result.proration && result.proration !== undefined ? result.proration : false;
                    if (result.idrates == null && result.idrates == undefined && result.idrates == '') {
                        console.log("Record Inserted");
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `idtariff` FROM `voice_rates` WHERE `idrates` IN (" + idrats + ")";
                        obj0.prepare();
                        obj0.execute((error, data) => {
                            if (error == 1) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT into voice_rates (`idaccount`,`idtariff`, `priority`, `type`, `subtype`,`rate`, `mo`, `mt`,`billing_frequency`,`category`,`proration`,`final_rate`) VALUES (" + sessdata.idaccount + ", " + (0, markError_1.setToZero)(data[0].idtariff) + ", '" + 5 + "', 'message', 'message_activation'," + (0, markError_1.setToZero)(result.price) + "," + (0, markError_1.setToZero)(result.mo) + "," + (0, markError_1.setToZero)(result.mt) + ",'" + (0, markError_1.setToZero)(result.billingfrequency) + "','" + result.category + "','" + pr + "','" + (0, markError_1.setToZero)(updatedPrice) + "')";
                                obj1.prepare();
                                obj1.execute((_error, res) => {
                                    console.log("Rates Updated Successfully!");
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `voice_rates` SET `rate`=" + (0, markError_1.setToZero)(result.price) + ", `mo` = " + (0, markError_1.setToZero)(result.mo) + ", `mt` = " + (0, markError_1.setToZero)(result.mt) + ", `billing_frequency` = " + (0, markError_1.setToZero)(result.billingfrequency) + ", `proration`='" + pr + "', `final_rate` = '" + (0, markError_1.setToZero)(updatedPrice) + "' WHERE `idrates` = " + (0, markError_1.setToZero)(idrt) + "";
                        obj2.prepare();
                        obj2.execute((__error, allcamp) => { });
                    }
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!", status: 201 });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    // SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id
    getSurcharge(req, res, next) {
        console.log(req.query);
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id";  
                obj.qrysql = `SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(data), '}') data FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction,CONCAT('"',sr.type, '_',sr.subtype,'_', sr.direction, '":',sr.rates) data FROM surcharge_rates sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction, sr.rates) tbl GROUP BY tbl.id`;
                obj.prepare();
                obj.execute((error, data) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    updatelookupRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let indexID = 0;
                rdata.forEach((element) => {
                    indexID++;
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let idsrt = result.idrates;
                    if (idsrt == null || idsrt == undefined) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT into `lookup_api_rates` (`idaccount`,`idtariff`, `type`, `rate`,`category`,`priority`) VALUES (" + sessdata.idaccount + ", " + (0, markError_1.setToZero)(result.idtariff) + ",'" + result.type + "'," + (0, markError_1.setToZero)(result.price) + ",'" + result.categoryValue + "'," + (0, markError_1.setToZero)(indexID) + ")";
                        obj1.prepare();
                        obj1.execute((error, allcamp) => {
                        });
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `lookup_api_rates` SET `rate`=" + (0, markError_1.setToZero)(result.price) + " WHERE `idrates` = " + idsrt + "";
                        obj2.prepare();
                        obj2.execute((error, allcamp) => {
                        });
                    }
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Lookup Rates Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateCampaignReviewRate(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let indexID = 0;
                rdata.forEach((element) => {
                    indexID++;
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let idsrt = result.idrates;
                    if (idsrt == null || idsrt == undefined) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT into `campaign_rates` (`idaccount`,`idtariff`, `type`, `rate`,`category`,`priority`,`mrc`) VALUES (" + sessdata.idaccount + ", " + (0, markError_1.setToZero)(result.idtariff) + ",'" + result.type + "'," + (0, markError_1.setToZero)(result.price) + ",'" + result.category + "','" + (0, markError_1.setToZero)(result.priority) + "','" + (0, markError_1.setToZero)(result.mrc) + "')";
                        obj1.prepare();
                        obj1.execute((error, Inscamp) => {
                            console.log("Campaign Review & Redundant Campaign Rates Updated Successfully");
                        });
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `campaign_rates` SET `rate`=" + (0, markError_1.setToZero)(result.price) + ",`mrc`=" + (0, markError_1.setToZero)(result.mrc) + " WHERE `campaign_rate_id` = " + idsrt + "";
                        obj2.prepare();
                        obj2.execute((error, upcamp) => {
                            console.log("Campaign Review & Redundant Campaign Rates Updated Successfully");
                        });
                    }
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "A2P Charges Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    lookupRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select idrates,idaccount,iduser,idtariff,type,rate,category,description,priority from `lookup_api_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Lookup Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    CampaignReviewRates(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select campaign_rate_id,idaccount,iduser,idtariff,type,rate,category,priority,mrc from `campaign_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Campaign Review & Redundant Campaign Rates Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    /*Edit Activate Msg Pricing*/
    updateActivatemessage(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let result = {};
                let rdata = [];
                rdata = req.body.data;
                let indexID = 0;
                rdata.forEach((element) => {
                    indexID++;
                    element.forEach((element) => {
                        result[element.field] = element.value;
                    });
                    let idsrt = result.idrates;
                    if (idsrt == null || idsrt == undefined) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT into `message_activation_pricing` (`idaccount`,`iduser`,`idtariff`,`type`,`mrc`,`nrc`,`category`,`priority`) VALUES (" + sessdata.idaccount + "," + sessdata.iduser + ", " + (0, markError_1.setToZero)(result.idtariff) + ",'" + result.type + "'," + (0, markError_1.setToZero)(result.mrc) + "," + (0, markError_1.setToZero)(result.nrc) + ",'" + result.category + "'," + (0, markError_1.setToZero)(indexID) + ")";
                        obj1.prepare();
                        obj1.execute((error, allcamp) => {
                        });
                    }
                    else {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `message_activation_pricing` SET `mrc`=" + (0, markError_1.setToZero)(result.mrc) + ",`nrc`=" + (0, markError_1.setToZero)(result.nrc) + "  WHERE `idrates` = " + idsrt + "";
                        obj2.prepare();
                        obj2.execute((error, allcamp) => {
                            console.log("Activation Message Pricing Updated Successfully!");
                        });
                    }
                });
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Activate Message Updated Successfully!" });
                objv.execute();
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    /*Get Activate Msg Pricing*/
    get_activatemsg(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "Select idrates,idaccount,idtariff,type,mrc,nrc,category,priority from `message_activation_pricing` where `idtariff` = " + req.query.idtariff + " AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error, data) => {
                    if (data.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: data, message: "Activate Message Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.TierManagement = TierManagement;
